# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CustomizeAlertRuleUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'thresholds': 'list[AlertRuleThresholds]',
        'disabled': 'bool',
        'clusters': 'ClusterWhereInput'
    }

    attribute_map = {
        'thresholds': 'thresholds',
        'disabled': 'disabled',
        'clusters': 'clusters'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CustomizeAlertRuleUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._thresholds = None
        self._disabled = None
        self._clusters = None
        self.discriminator = None

        if "thresholds" in kwargs:
            self.thresholds = kwargs["thresholds"]
        if "disabled" in kwargs:
            self.disabled = kwargs["disabled"]
        if "clusters" in kwargs:
            self.clusters = kwargs["clusters"]

    @property
    def thresholds(self):
        """Gets the thresholds of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501


        :return: The thresholds of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :rtype: list[AlertRuleThresholds]
        """
        return self._thresholds

    @thresholds.setter
    def thresholds(self, thresholds):
        """Sets the thresholds of this CustomizeAlertRuleUpdationParamsData.


        :param thresholds: The thresholds of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :type thresholds: list[AlertRuleThresholds]
        """

        self._thresholds = thresholds

    @property
    def disabled(self):
        """Gets the disabled of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501


        :return: The disabled of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this CustomizeAlertRuleUpdationParamsData.


        :param disabled: The disabled of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :type disabled: bool
        """

        self._disabled = disabled

    @property
    def clusters(self):
        """Gets the clusters of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501


        :return: The clusters of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """Sets the clusters of this CustomizeAlertRuleUpdationParamsData.


        :param clusters: The clusters of this CustomizeAlertRuleUpdationParamsData.  # noqa: E501
        :type clusters: ClusterWhereInput
        """
        if self.local_vars_configuration.client_side_validation and clusters is None:  # noqa: E501
            raise ValueError("Invalid value for `clusters`, must not be `None`")  # noqa: E501

        self._clusters = clusters

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomizeAlertRuleUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CustomizeAlertRuleUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
