# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class DeployCloudTowerApplicationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'target_package': 'str',
        'vm_spec': 'ApplicationVmSpecDefinition'
    }

    attribute_map = {
        'name': 'name',
        'target_package': 'targetPackage',
        'vm_spec': 'vmSpec'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DeployCloudTowerApplicationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._name = None
        self._target_package = None
        self._vm_spec = None
        self.discriminator = None

        if "name" in kwargs:
            self.name = kwargs["name"]
        if "target_package" in kwargs:
            self.target_package = kwargs["target_package"]
        if "vm_spec" in kwargs:
            self.vm_spec = kwargs["vm_spec"]

    @property
    def name(self):
        """Gets the name of this DeployCloudTowerApplicationParams.  # noqa: E501


        :return: The name of this DeployCloudTowerApplicationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeployCloudTowerApplicationParams.


        :param name: The name of this DeployCloudTowerApplicationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def target_package(self):
        """Gets the target_package of this DeployCloudTowerApplicationParams.  # noqa: E501


        :return: The target_package of this DeployCloudTowerApplicationParams.  # noqa: E501
        :rtype: str
        """
        return self._target_package

    @target_package.setter
    def target_package(self, target_package):
        """Sets the target_package of this DeployCloudTowerApplicationParams.


        :param target_package: The target_package of this DeployCloudTowerApplicationParams.  # noqa: E501
        :type target_package: str
        """
        if self.local_vars_configuration.client_side_validation and target_package is None:  # noqa: E501
            raise ValueError("Invalid value for `target_package`, must not be `None`")  # noqa: E501

        self._target_package = target_package

    @property
    def vm_spec(self):
        """Gets the vm_spec of this DeployCloudTowerApplicationParams.  # noqa: E501


        :return: The vm_spec of this DeployCloudTowerApplicationParams.  # noqa: E501
        :rtype: ApplicationVmSpecDefinition
        """
        return self._vm_spec

    @vm_spec.setter
    def vm_spec(self, vm_spec):
        """Sets the vm_spec of this DeployCloudTowerApplicationParams.


        :param vm_spec: The vm_spec of this DeployCloudTowerApplicationParams.  # noqa: E501
        :type vm_spec: ApplicationVmSpecDefinition
        """
        if self.local_vars_configuration.client_side_validation and vm_spec is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_spec`, must not be `None`")  # noqa: E501

        self._vm_spec = vm_spec

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeployCloudTowerApplicationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeployCloudTowerApplicationParams):
            return True

        return self.to_dict() != other.to_dict()
