# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class DisassociateSystemServiceFromObsServiceResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'error_message': 'str',
        'error_code': 'str',
        'result': 'DisassociateSystemServiceFromObsServiceResultType'
    }

    attribute_map = {
        'error_message': 'errorMessage',
        'error_code': 'errorCode',
        'result': 'result'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DisassociateSystemServiceFromObsServiceResult - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._error_message = None
        self._error_code = None
        self._result = None
        self.discriminator = None

        if "error_message" in kwargs:
            self.error_message = kwargs["error_message"]
        if "error_code" in kwargs:
            self.error_code = kwargs["error_code"]
        if "result" in kwargs:
            self.result = kwargs["result"]

    @property
    def error_message(self):
        """Gets the error_message of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501


        :return: The error_message of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this DisassociateSystemServiceFromObsServiceResult.


        :param error_message: The error_message of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :type error_message: str
        """

        self._error_message = error_message

    @property
    def error_code(self):
        """Gets the error_code of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501


        :return: The error_code of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this DisassociateSystemServiceFromObsServiceResult.


        :param error_code: The error_code of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :type error_code: str
        """

        self._error_code = error_code

    @property
    def result(self):
        """Gets the result of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501


        :return: The result of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :rtype: DisassociateSystemServiceFromObsServiceResultType
        """
        return self._result

    @result.setter
    def result(self, result):
        """Sets the result of this DisassociateSystemServiceFromObsServiceResult.


        :param result: The result of this DisassociateSystemServiceFromObsServiceResult.  # noqa: E501
        :type result: DisassociateSystemServiceFromObsServiceResultType
        """
        if self.local_vars_configuration.client_side_validation and result is None:  # noqa: E501
            raise ValueError("Invalid value for `result`, must not be `None`")  # noqa: E501

        self._result = result

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DisassociateSystemServiceFromObsServiceResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DisassociateSystemServiceFromObsServiceResult):
            return True

        return self.to_dict() != other.to_dict()
