# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class DiskPool(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'chunk_id': 'int',
        'chunk_ins_id': 'int',
        'data_space_usage': 'float',
        'dirty_cache_space': 'int',
        'dirty_cache_usage': 'float',
        'disks': 'list[NestedDisk]',
        'failure_cache_space': 'int',
        'failure_data_space': 'int',
        'hdd_disk_count': 'int',
        'host': 'NestedHost',
        'id': 'str',
        'labels': 'list[NestedLabel]',
        'local_id': 'str',
        'numa_node': 'str',
        'nvme_ssd_disk_count': 'int',
        'perf_allocated_data_space': 'int',
        'perf_failure_data_space': 'int',
        'perf_total_data_capacity': 'int',
        'perf_used_data_space': 'int',
        'perf_valid_data_space': 'int',
        'planned_prioritized_space': 'int',
        'prio_space_percentage': 'float',
        'sata_or_sas_ssd_disk_count': 'int',
        'status': 'DiskPoolStatus',
        'total_cache_capacity': 'int',
        'total_data_capacity': 'int',
        'use_state': 'DiskPoolUseState',
        'used_cache_space': 'int',
        'used_data_space': 'int',
        'valid_cache_space': 'int',
        'valid_free_cache_space': 'int'
    }

    attribute_map = {
        'chunk_id': 'chunk_id',
        'chunk_ins_id': 'chunk_ins_id',
        'data_space_usage': 'data_space_usage',
        'dirty_cache_space': 'dirty_cache_space',
        'dirty_cache_usage': 'dirty_cache_usage',
        'disks': 'disks',
        'failure_cache_space': 'failure_cache_space',
        'failure_data_space': 'failure_data_space',
        'hdd_disk_count': 'hdd_disk_count',
        'host': 'host',
        'id': 'id',
        'labels': 'labels',
        'local_id': 'local_id',
        'numa_node': 'numa_node',
        'nvme_ssd_disk_count': 'nvme_ssd_disk_count',
        'perf_allocated_data_space': 'perf_allocated_data_space',
        'perf_failure_data_space': 'perf_failure_data_space',
        'perf_total_data_capacity': 'perf_total_data_capacity',
        'perf_used_data_space': 'perf_used_data_space',
        'perf_valid_data_space': 'perf_valid_data_space',
        'planned_prioritized_space': 'planned_prioritized_space',
        'prio_space_percentage': 'prio_space_percentage',
        'sata_or_sas_ssd_disk_count': 'sata_or_sas_ssd_disk_count',
        'status': 'status',
        'total_cache_capacity': 'total_cache_capacity',
        'total_data_capacity': 'total_data_capacity',
        'use_state': 'use_state',
        'used_cache_space': 'used_cache_space',
        'used_data_space': 'used_data_space',
        'valid_cache_space': 'valid_cache_space',
        'valid_free_cache_space': 'valid_free_cache_space'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DiskPool - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._chunk_id = None
        self._chunk_ins_id = None
        self._data_space_usage = None
        self._dirty_cache_space = None
        self._dirty_cache_usage = None
        self._disks = None
        self._failure_cache_space = None
        self._failure_data_space = None
        self._hdd_disk_count = None
        self._host = None
        self._id = None
        self._labels = None
        self._local_id = None
        self._numa_node = None
        self._nvme_ssd_disk_count = None
        self._perf_allocated_data_space = None
        self._perf_failure_data_space = None
        self._perf_total_data_capacity = None
        self._perf_used_data_space = None
        self._perf_valid_data_space = None
        self._planned_prioritized_space = None
        self._prio_space_percentage = None
        self._sata_or_sas_ssd_disk_count = None
        self._status = None
        self._total_cache_capacity = None
        self._total_data_capacity = None
        self._use_state = None
        self._used_cache_space = None
        self._used_data_space = None
        self._valid_cache_space = None
        self._valid_free_cache_space = None
        self.discriminator = None

        if "chunk_id" in kwargs:
            self.chunk_id = kwargs["chunk_id"]
        if "chunk_ins_id" in kwargs:
            self.chunk_ins_id = kwargs["chunk_ins_id"]
        if "data_space_usage" in kwargs:
            self.data_space_usage = kwargs["data_space_usage"]
        if "dirty_cache_space" in kwargs:
            self.dirty_cache_space = kwargs["dirty_cache_space"]
        if "dirty_cache_usage" in kwargs:
            self.dirty_cache_usage = kwargs["dirty_cache_usage"]
        self.disks = kwargs.get("disks", None)
        if "failure_cache_space" in kwargs:
            self.failure_cache_space = kwargs["failure_cache_space"]
        if "failure_data_space" in kwargs:
            self.failure_data_space = kwargs["failure_data_space"]
        if "hdd_disk_count" in kwargs:
            self.hdd_disk_count = kwargs["hdd_disk_count"]
        if "host" in kwargs:
            self.host = kwargs["host"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.labels = kwargs.get("labels", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "numa_node" in kwargs:
            self.numa_node = kwargs["numa_node"]
        if "nvme_ssd_disk_count" in kwargs:
            self.nvme_ssd_disk_count = kwargs["nvme_ssd_disk_count"]
        if "perf_allocated_data_space" in kwargs:
            self.perf_allocated_data_space = kwargs["perf_allocated_data_space"]
        if "perf_failure_data_space" in kwargs:
            self.perf_failure_data_space = kwargs["perf_failure_data_space"]
        if "perf_total_data_capacity" in kwargs:
            self.perf_total_data_capacity = kwargs["perf_total_data_capacity"]
        if "perf_used_data_space" in kwargs:
            self.perf_used_data_space = kwargs["perf_used_data_space"]
        if "perf_valid_data_space" in kwargs:
            self.perf_valid_data_space = kwargs["perf_valid_data_space"]
        if "planned_prioritized_space" in kwargs:
            self.planned_prioritized_space = kwargs["planned_prioritized_space"]
        self.prio_space_percentage = kwargs.get("prio_space_percentage", None)
        if "sata_or_sas_ssd_disk_count" in kwargs:
            self.sata_or_sas_ssd_disk_count = kwargs["sata_or_sas_ssd_disk_count"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "total_cache_capacity" in kwargs:
            self.total_cache_capacity = kwargs["total_cache_capacity"]
        if "total_data_capacity" in kwargs:
            self.total_data_capacity = kwargs["total_data_capacity"]
        if "use_state" in kwargs:
            self.use_state = kwargs["use_state"]
        if "used_cache_space" in kwargs:
            self.used_cache_space = kwargs["used_cache_space"]
        if "used_data_space" in kwargs:
            self.used_data_space = kwargs["used_data_space"]
        if "valid_cache_space" in kwargs:
            self.valid_cache_space = kwargs["valid_cache_space"]
        if "valid_free_cache_space" in kwargs:
            self.valid_free_cache_space = kwargs["valid_free_cache_space"]

    @property
    def chunk_id(self):
        """Gets the chunk_id of this DiskPool.  # noqa: E501


        :return: The chunk_id of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id

    @chunk_id.setter
    def chunk_id(self, chunk_id):
        """Sets the chunk_id of this DiskPool.


        :param chunk_id: The chunk_id of this DiskPool.  # noqa: E501
        :type chunk_id: int
        """
        if self.local_vars_configuration.client_side_validation and chunk_id is None:  # noqa: E501
            raise ValueError("Invalid value for `chunk_id`, must not be `None`")  # noqa: E501

        self._chunk_id = chunk_id

    @property
    def chunk_ins_id(self):
        """Gets the chunk_ins_id of this DiskPool.  # noqa: E501


        :return: The chunk_ins_id of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id

    @chunk_ins_id.setter
    def chunk_ins_id(self, chunk_ins_id):
        """Sets the chunk_ins_id of this DiskPool.


        :param chunk_ins_id: The chunk_ins_id of this DiskPool.  # noqa: E501
        :type chunk_ins_id: int
        """
        if self.local_vars_configuration.client_side_validation and chunk_ins_id is None:  # noqa: E501
            raise ValueError("Invalid value for `chunk_ins_id`, must not be `None`")  # noqa: E501

        self._chunk_ins_id = chunk_ins_id

    @property
    def data_space_usage(self):
        """Gets the data_space_usage of this DiskPool.  # noqa: E501


        :return: The data_space_usage of this DiskPool.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage

    @data_space_usage.setter
    def data_space_usage(self, data_space_usage):
        """Sets the data_space_usage of this DiskPool.


        :param data_space_usage: The data_space_usage of this DiskPool.  # noqa: E501
        :type data_space_usage: float
        """
        if self.local_vars_configuration.client_side_validation and data_space_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `data_space_usage`, must not be `None`")  # noqa: E501

        self._data_space_usage = data_space_usage

    @property
    def dirty_cache_space(self):
        """Gets the dirty_cache_space of this DiskPool.  # noqa: E501


        :return: The dirty_cache_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space

    @dirty_cache_space.setter
    def dirty_cache_space(self, dirty_cache_space):
        """Sets the dirty_cache_space of this DiskPool.


        :param dirty_cache_space: The dirty_cache_space of this DiskPool.  # noqa: E501
        :type dirty_cache_space: int
        """
        if self.local_vars_configuration.client_side_validation and dirty_cache_space is None:  # noqa: E501
            raise ValueError("Invalid value for `dirty_cache_space`, must not be `None`")  # noqa: E501

        self._dirty_cache_space = dirty_cache_space

    @property
    def dirty_cache_usage(self):
        """Gets the dirty_cache_usage of this DiskPool.  # noqa: E501


        :return: The dirty_cache_usage of this DiskPool.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage

    @dirty_cache_usage.setter
    def dirty_cache_usage(self, dirty_cache_usage):
        """Sets the dirty_cache_usage of this DiskPool.


        :param dirty_cache_usage: The dirty_cache_usage of this DiskPool.  # noqa: E501
        :type dirty_cache_usage: float
        """
        if self.local_vars_configuration.client_side_validation and dirty_cache_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `dirty_cache_usage`, must not be `None`")  # noqa: E501

        self._dirty_cache_usage = dirty_cache_usage

    @property
    def disks(self):
        """Gets the disks of this DiskPool.  # noqa: E501


        :return: The disks of this DiskPool.  # noqa: E501
        :rtype: list[NestedDisk]
        """
        return self._disks

    @disks.setter
    def disks(self, disks):
        """Sets the disks of this DiskPool.


        :param disks: The disks of this DiskPool.  # noqa: E501
        :type disks: list[NestedDisk]
        """

        self._disks = disks

    @property
    def failure_cache_space(self):
        """Gets the failure_cache_space of this DiskPool.  # noqa: E501


        :return: The failure_cache_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space

    @failure_cache_space.setter
    def failure_cache_space(self, failure_cache_space):
        """Sets the failure_cache_space of this DiskPool.


        :param failure_cache_space: The failure_cache_space of this DiskPool.  # noqa: E501
        :type failure_cache_space: int
        """
        if self.local_vars_configuration.client_side_validation and failure_cache_space is None:  # noqa: E501
            raise ValueError("Invalid value for `failure_cache_space`, must not be `None`")  # noqa: E501

        self._failure_cache_space = failure_cache_space

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this DiskPool.  # noqa: E501


        :return: The failure_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this DiskPool.


        :param failure_data_space: The failure_data_space of this DiskPool.  # noqa: E501
        :type failure_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and failure_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `failure_data_space`, must not be `None`")  # noqa: E501

        self._failure_data_space = failure_data_space

    @property
    def hdd_disk_count(self):
        """Gets the hdd_disk_count of this DiskPool.  # noqa: E501


        :return: The hdd_disk_count of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count

    @hdd_disk_count.setter
    def hdd_disk_count(self, hdd_disk_count):
        """Sets the hdd_disk_count of this DiskPool.


        :param hdd_disk_count: The hdd_disk_count of this DiskPool.  # noqa: E501
        :type hdd_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and hdd_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `hdd_disk_count`, must not be `None`")  # noqa: E501

        self._hdd_disk_count = hdd_disk_count

    @property
    def host(self):
        """Gets the host of this DiskPool.  # noqa: E501


        :return: The host of this DiskPool.  # noqa: E501
        :rtype: NestedHost
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this DiskPool.


        :param host: The host of this DiskPool.  # noqa: E501
        :type host: NestedHost
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def id(self):
        """Gets the id of this DiskPool.  # noqa: E501


        :return: The id of this DiskPool.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DiskPool.


        :param id: The id of this DiskPool.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this DiskPool.  # noqa: E501


        :return: The labels of this DiskPool.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this DiskPool.


        :param labels: The labels of this DiskPool.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_id(self):
        """Gets the local_id of this DiskPool.  # noqa: E501


        :return: The local_id of this DiskPool.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this DiskPool.


        :param local_id: The local_id of this DiskPool.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def numa_node(self):
        """Gets the numa_node of this DiskPool.  # noqa: E501


        :return: The numa_node of this DiskPool.  # noqa: E501
        :rtype: str
        """
        return self._numa_node

    @numa_node.setter
    def numa_node(self, numa_node):
        """Sets the numa_node of this DiskPool.


        :param numa_node: The numa_node of this DiskPool.  # noqa: E501
        :type numa_node: str
        """
        if self.local_vars_configuration.client_side_validation and numa_node is None:  # noqa: E501
            raise ValueError("Invalid value for `numa_node`, must not be `None`")  # noqa: E501

        self._numa_node = numa_node

    @property
    def nvme_ssd_disk_count(self):
        """Gets the nvme_ssd_disk_count of this DiskPool.  # noqa: E501


        :return: The nvme_ssd_disk_count of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count

    @nvme_ssd_disk_count.setter
    def nvme_ssd_disk_count(self, nvme_ssd_disk_count):
        """Sets the nvme_ssd_disk_count of this DiskPool.


        :param nvme_ssd_disk_count: The nvme_ssd_disk_count of this DiskPool.  # noqa: E501
        :type nvme_ssd_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and nvme_ssd_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `nvme_ssd_disk_count`, must not be `None`")  # noqa: E501

        self._nvme_ssd_disk_count = nvme_ssd_disk_count

    @property
    def perf_allocated_data_space(self):
        """Gets the perf_allocated_data_space of this DiskPool.  # noqa: E501


        :return: The perf_allocated_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space

    @perf_allocated_data_space.setter
    def perf_allocated_data_space(self, perf_allocated_data_space):
        """Sets the perf_allocated_data_space of this DiskPool.


        :param perf_allocated_data_space: The perf_allocated_data_space of this DiskPool.  # noqa: E501
        :type perf_allocated_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and perf_allocated_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `perf_allocated_data_space`, must not be `None`")  # noqa: E501

        self._perf_allocated_data_space = perf_allocated_data_space

    @property
    def perf_failure_data_space(self):
        """Gets the perf_failure_data_space of this DiskPool.  # noqa: E501


        :return: The perf_failure_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space

    @perf_failure_data_space.setter
    def perf_failure_data_space(self, perf_failure_data_space):
        """Sets the perf_failure_data_space of this DiskPool.


        :param perf_failure_data_space: The perf_failure_data_space of this DiskPool.  # noqa: E501
        :type perf_failure_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and perf_failure_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `perf_failure_data_space`, must not be `None`")  # noqa: E501

        self._perf_failure_data_space = perf_failure_data_space

    @property
    def perf_total_data_capacity(self):
        """Gets the perf_total_data_capacity of this DiskPool.  # noqa: E501


        :return: The perf_total_data_capacity of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity

    @perf_total_data_capacity.setter
    def perf_total_data_capacity(self, perf_total_data_capacity):
        """Sets the perf_total_data_capacity of this DiskPool.


        :param perf_total_data_capacity: The perf_total_data_capacity of this DiskPool.  # noqa: E501
        :type perf_total_data_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and perf_total_data_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `perf_total_data_capacity`, must not be `None`")  # noqa: E501

        self._perf_total_data_capacity = perf_total_data_capacity

    @property
    def perf_used_data_space(self):
        """Gets the perf_used_data_space of this DiskPool.  # noqa: E501


        :return: The perf_used_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space

    @perf_used_data_space.setter
    def perf_used_data_space(self, perf_used_data_space):
        """Sets the perf_used_data_space of this DiskPool.


        :param perf_used_data_space: The perf_used_data_space of this DiskPool.  # noqa: E501
        :type perf_used_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and perf_used_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `perf_used_data_space`, must not be `None`")  # noqa: E501

        self._perf_used_data_space = perf_used_data_space

    @property
    def perf_valid_data_space(self):
        """Gets the perf_valid_data_space of this DiskPool.  # noqa: E501


        :return: The perf_valid_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space

    @perf_valid_data_space.setter
    def perf_valid_data_space(self, perf_valid_data_space):
        """Sets the perf_valid_data_space of this DiskPool.


        :param perf_valid_data_space: The perf_valid_data_space of this DiskPool.  # noqa: E501
        :type perf_valid_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and perf_valid_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `perf_valid_data_space`, must not be `None`")  # noqa: E501

        self._perf_valid_data_space = perf_valid_data_space

    @property
    def planned_prioritized_space(self):
        """Gets the planned_prioritized_space of this DiskPool.  # noqa: E501


        :return: The planned_prioritized_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space

    @planned_prioritized_space.setter
    def planned_prioritized_space(self, planned_prioritized_space):
        """Sets the planned_prioritized_space of this DiskPool.


        :param planned_prioritized_space: The planned_prioritized_space of this DiskPool.  # noqa: E501
        :type planned_prioritized_space: int
        """
        if self.local_vars_configuration.client_side_validation and planned_prioritized_space is None:  # noqa: E501
            raise ValueError("Invalid value for `planned_prioritized_space`, must not be `None`")  # noqa: E501

        self._planned_prioritized_space = planned_prioritized_space

    @property
    def prio_space_percentage(self):
        """Gets the prio_space_percentage of this DiskPool.  # noqa: E501


        :return: The prio_space_percentage of this DiskPool.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage

    @prio_space_percentage.setter
    def prio_space_percentage(self, prio_space_percentage):
        """Sets the prio_space_percentage of this DiskPool.


        :param prio_space_percentage: The prio_space_percentage of this DiskPool.  # noqa: E501
        :type prio_space_percentage: float
        """

        self._prio_space_percentage = prio_space_percentage

    @property
    def sata_or_sas_ssd_disk_count(self):
        """Gets the sata_or_sas_ssd_disk_count of this DiskPool.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count

    @sata_or_sas_ssd_disk_count.setter
    def sata_or_sas_ssd_disk_count(self, sata_or_sas_ssd_disk_count):
        """Sets the sata_or_sas_ssd_disk_count of this DiskPool.


        :param sata_or_sas_ssd_disk_count: The sata_or_sas_ssd_disk_count of this DiskPool.  # noqa: E501
        :type sata_or_sas_ssd_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and sata_or_sas_ssd_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `sata_or_sas_ssd_disk_count`, must not be `None`")  # noqa: E501

        self._sata_or_sas_ssd_disk_count = sata_or_sas_ssd_disk_count

    @property
    def status(self):
        """Gets the status of this DiskPool.  # noqa: E501


        :return: The status of this DiskPool.  # noqa: E501
        :rtype: DiskPoolStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DiskPool.


        :param status: The status of this DiskPool.  # noqa: E501
        :type status: DiskPoolStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this DiskPool.  # noqa: E501


        :return: The total_cache_capacity of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this DiskPool.


        :param total_cache_capacity: The total_cache_capacity of this DiskPool.  # noqa: E501
        :type total_cache_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and total_cache_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `total_cache_capacity`, must not be `None`")  # noqa: E501

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this DiskPool.  # noqa: E501


        :return: The total_data_capacity of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this DiskPool.


        :param total_data_capacity: The total_data_capacity of this DiskPool.  # noqa: E501
        :type total_data_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and total_data_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `total_data_capacity`, must not be `None`")  # noqa: E501

        self._total_data_capacity = total_data_capacity

    @property
    def use_state(self):
        """Gets the use_state of this DiskPool.  # noqa: E501


        :return: The use_state of this DiskPool.  # noqa: E501
        :rtype: DiskPoolUseState
        """
        return self._use_state

    @use_state.setter
    def use_state(self, use_state):
        """Sets the use_state of this DiskPool.


        :param use_state: The use_state of this DiskPool.  # noqa: E501
        :type use_state: DiskPoolUseState
        """
        if self.local_vars_configuration.client_side_validation and use_state is None:  # noqa: E501
            raise ValueError("Invalid value for `use_state`, must not be `None`")  # noqa: E501

        self._use_state = use_state

    @property
    def used_cache_space(self):
        """Gets the used_cache_space of this DiskPool.  # noqa: E501


        :return: The used_cache_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space

    @used_cache_space.setter
    def used_cache_space(self, used_cache_space):
        """Sets the used_cache_space of this DiskPool.


        :param used_cache_space: The used_cache_space of this DiskPool.  # noqa: E501
        :type used_cache_space: int
        """
        if self.local_vars_configuration.client_side_validation and used_cache_space is None:  # noqa: E501
            raise ValueError("Invalid value for `used_cache_space`, must not be `None`")  # noqa: E501

        self._used_cache_space = used_cache_space

    @property
    def used_data_space(self):
        """Gets the used_data_space of this DiskPool.  # noqa: E501


        :return: The used_data_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this DiskPool.


        :param used_data_space: The used_data_space of this DiskPool.  # noqa: E501
        :type used_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and used_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `used_data_space`, must not be `None`")  # noqa: E501

        self._used_data_space = used_data_space

    @property
    def valid_cache_space(self):
        """Gets the valid_cache_space of this DiskPool.  # noqa: E501


        :return: The valid_cache_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space

    @valid_cache_space.setter
    def valid_cache_space(self, valid_cache_space):
        """Sets the valid_cache_space of this DiskPool.


        :param valid_cache_space: The valid_cache_space of this DiskPool.  # noqa: E501
        :type valid_cache_space: int
        """
        if self.local_vars_configuration.client_side_validation and valid_cache_space is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_cache_space`, must not be `None`")  # noqa: E501

        self._valid_cache_space = valid_cache_space

    @property
    def valid_free_cache_space(self):
        """Gets the valid_free_cache_space of this DiskPool.  # noqa: E501


        :return: The valid_free_cache_space of this DiskPool.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space

    @valid_free_cache_space.setter
    def valid_free_cache_space(self, valid_free_cache_space):
        """Sets the valid_free_cache_space of this DiskPool.


        :param valid_free_cache_space: The valid_free_cache_space of this DiskPool.  # noqa: E501
        :type valid_free_cache_space: int
        """
        if self.local_vars_configuration.client_side_validation and valid_free_cache_space is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_free_cache_space`, must not be `None`")  # noqa: E501

        self._valid_free_cache_space = valid_free_cache_space

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskPool):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DiskPool):
            return True

        return self.to_dict() != other.to_dict()
