# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class DiskPoolPinInPerformanceInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'planned_prioritized_space': 'int',
        'prio_space_percentage': 'float',
        'id': 'str'
    }

    attribute_map = {
        'planned_prioritized_space': 'planned_prioritized_space',
        'prio_space_percentage': 'prio_space_percentage',
        'id': 'id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DiskPoolPinInPerformanceInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._planned_prioritized_space = None
        self._prio_space_percentage = None
        self._id = None
        self.discriminator = None

        self.planned_prioritized_space = kwargs.get("planned_prioritized_space", None)
        self.prio_space_percentage = kwargs.get("prio_space_percentage", None)
        if "id" in kwargs:
            self.id = kwargs["id"]

    @property
    def planned_prioritized_space(self):
        """Gets the planned_prioritized_space of this DiskPoolPinInPerformanceInfo.  # noqa: E501


        :return: The planned_prioritized_space of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space

    @planned_prioritized_space.setter
    def planned_prioritized_space(self, planned_prioritized_space):
        """Sets the planned_prioritized_space of this DiskPoolPinInPerformanceInfo.


        :param planned_prioritized_space: The planned_prioritized_space of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :type planned_prioritized_space: int
        """

        self._planned_prioritized_space = planned_prioritized_space

    @property
    def prio_space_percentage(self):
        """Gets the prio_space_percentage of this DiskPoolPinInPerformanceInfo.  # noqa: E501


        :return: The prio_space_percentage of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage

    @prio_space_percentage.setter
    def prio_space_percentage(self, prio_space_percentage):
        """Sets the prio_space_percentage of this DiskPoolPinInPerformanceInfo.


        :param prio_space_percentage: The prio_space_percentage of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :type prio_space_percentage: float
        """

        self._prio_space_percentage = prio_space_percentage

    @property
    def id(self):
        """Gets the id of this DiskPoolPinInPerformanceInfo.  # noqa: E501


        :return: The id of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DiskPoolPinInPerformanceInfo.


        :param id: The id of this DiskPoolPinInPerformanceInfo.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskPoolPinInPerformanceInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DiskPoolPinInPerformanceInfo):
            return True

        return self.to_dict() != other.to_dict()
