# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class DiskPoolWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[DiskPoolWhereInput]',
        '_not': 'list[DiskPoolWhereInput]',
        '_or': 'list[DiskPoolWhereInput]',
        'chunk_id': 'int',
        'chunk_id_gt': 'int',
        'chunk_id_gte': 'int',
        'chunk_id_in': 'list[int]',
        'chunk_id_lt': 'int',
        'chunk_id_lte': 'int',
        'chunk_id_not': 'int',
        'chunk_id_not_in': 'list[int]',
        'chunk_ins_id': 'int',
        'chunk_ins_id_gt': 'int',
        'chunk_ins_id_gte': 'int',
        'chunk_ins_id_in': 'list[int]',
        'chunk_ins_id_lt': 'int',
        'chunk_ins_id_lte': 'int',
        'chunk_ins_id_not': 'int',
        'chunk_ins_id_not_in': 'list[int]',
        'data_space_usage': 'float',
        'data_space_usage_gt': 'float',
        'data_space_usage_gte': 'float',
        'data_space_usage_in': 'list[float]',
        'data_space_usage_lt': 'float',
        'data_space_usage_lte': 'float',
        'data_space_usage_not': 'float',
        'data_space_usage_not_in': 'list[float]',
        'dirty_cache_space': 'int',
        'dirty_cache_space_gt': 'int',
        'dirty_cache_space_gte': 'int',
        'dirty_cache_space_in': 'list[int]',
        'dirty_cache_space_lt': 'int',
        'dirty_cache_space_lte': 'int',
        'dirty_cache_space_not': 'int',
        'dirty_cache_space_not_in': 'list[int]',
        'dirty_cache_usage': 'float',
        'dirty_cache_usage_gt': 'float',
        'dirty_cache_usage_gte': 'float',
        'dirty_cache_usage_in': 'list[float]',
        'dirty_cache_usage_lt': 'float',
        'dirty_cache_usage_lte': 'float',
        'dirty_cache_usage_not': 'float',
        'dirty_cache_usage_not_in': 'list[float]',
        'disks_every': 'DiskWhereInput',
        'disks_none': 'DiskWhereInput',
        'disks_some': 'DiskWhereInput',
        'failure_cache_space': 'int',
        'failure_cache_space_gt': 'int',
        'failure_cache_space_gte': 'int',
        'failure_cache_space_in': 'list[int]',
        'failure_cache_space_lt': 'int',
        'failure_cache_space_lte': 'int',
        'failure_cache_space_not': 'int',
        'failure_cache_space_not_in': 'list[int]',
        'failure_data_space': 'int',
        'failure_data_space_gt': 'int',
        'failure_data_space_gte': 'int',
        'failure_data_space_in': 'list[int]',
        'failure_data_space_lt': 'int',
        'failure_data_space_lte': 'int',
        'failure_data_space_not': 'int',
        'failure_data_space_not_in': 'list[int]',
        'hdd_disk_count': 'int',
        'hdd_disk_count_gt': 'int',
        'hdd_disk_count_gte': 'int',
        'hdd_disk_count_in': 'list[int]',
        'hdd_disk_count_lt': 'int',
        'hdd_disk_count_lte': 'int',
        'hdd_disk_count_not': 'int',
        'hdd_disk_count_not_in': 'list[int]',
        'host': 'HostWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'numa_node': 'str',
        'numa_node_contains': 'str',
        'numa_node_ends_with': 'str',
        'numa_node_gt': 'str',
        'numa_node_gte': 'str',
        'numa_node_in': 'list[str]',
        'numa_node_lt': 'str',
        'numa_node_lte': 'str',
        'numa_node_not': 'str',
        'numa_node_not_contains': 'str',
        'numa_node_not_ends_with': 'str',
        'numa_node_not_in': 'list[str]',
        'numa_node_not_starts_with': 'str',
        'numa_node_starts_with': 'str',
        'nvme_ssd_disk_count': 'int',
        'nvme_ssd_disk_count_gt': 'int',
        'nvme_ssd_disk_count_gte': 'int',
        'nvme_ssd_disk_count_in': 'list[int]',
        'nvme_ssd_disk_count_lt': 'int',
        'nvme_ssd_disk_count_lte': 'int',
        'nvme_ssd_disk_count_not': 'int',
        'nvme_ssd_disk_count_not_in': 'list[int]',
        'perf_allocated_data_space': 'int',
        'perf_allocated_data_space_gt': 'int',
        'perf_allocated_data_space_gte': 'int',
        'perf_allocated_data_space_in': 'list[int]',
        'perf_allocated_data_space_lt': 'int',
        'perf_allocated_data_space_lte': 'int',
        'perf_allocated_data_space_not': 'int',
        'perf_allocated_data_space_not_in': 'list[int]',
        'perf_failure_data_space': 'int',
        'perf_failure_data_space_gt': 'int',
        'perf_failure_data_space_gte': 'int',
        'perf_failure_data_space_in': 'list[int]',
        'perf_failure_data_space_lt': 'int',
        'perf_failure_data_space_lte': 'int',
        'perf_failure_data_space_not': 'int',
        'perf_failure_data_space_not_in': 'list[int]',
        'perf_total_data_capacity': 'int',
        'perf_total_data_capacity_gt': 'int',
        'perf_total_data_capacity_gte': 'int',
        'perf_total_data_capacity_in': 'list[int]',
        'perf_total_data_capacity_lt': 'int',
        'perf_total_data_capacity_lte': 'int',
        'perf_total_data_capacity_not': 'int',
        'perf_total_data_capacity_not_in': 'list[int]',
        'perf_used_data_space': 'int',
        'perf_used_data_space_gt': 'int',
        'perf_used_data_space_gte': 'int',
        'perf_used_data_space_in': 'list[int]',
        'perf_used_data_space_lt': 'int',
        'perf_used_data_space_lte': 'int',
        'perf_used_data_space_not': 'int',
        'perf_used_data_space_not_in': 'list[int]',
        'perf_valid_data_space': 'int',
        'perf_valid_data_space_gt': 'int',
        'perf_valid_data_space_gte': 'int',
        'perf_valid_data_space_in': 'list[int]',
        'perf_valid_data_space_lt': 'int',
        'perf_valid_data_space_lte': 'int',
        'perf_valid_data_space_not': 'int',
        'perf_valid_data_space_not_in': 'list[int]',
        'planned_prioritized_space': 'int',
        'planned_prioritized_space_gt': 'int',
        'planned_prioritized_space_gte': 'int',
        'planned_prioritized_space_in': 'list[int]',
        'planned_prioritized_space_lt': 'int',
        'planned_prioritized_space_lte': 'int',
        'planned_prioritized_space_not': 'int',
        'planned_prioritized_space_not_in': 'list[int]',
        'prio_space_percentage': 'float',
        'prio_space_percentage_gt': 'float',
        'prio_space_percentage_gte': 'float',
        'prio_space_percentage_in': 'list[float]',
        'prio_space_percentage_lt': 'float',
        'prio_space_percentage_lte': 'float',
        'prio_space_percentage_not': 'float',
        'prio_space_percentage_not_in': 'list[float]',
        'sata_or_sas_ssd_disk_count': 'int',
        'sata_or_sas_ssd_disk_count_gt': 'int',
        'sata_or_sas_ssd_disk_count_gte': 'int',
        'sata_or_sas_ssd_disk_count_in': 'list[int]',
        'sata_or_sas_ssd_disk_count_lt': 'int',
        'sata_or_sas_ssd_disk_count_lte': 'int',
        'sata_or_sas_ssd_disk_count_not': 'int',
        'sata_or_sas_ssd_disk_count_not_in': 'list[int]',
        'status': 'DiskPoolStatus',
        'status_in': 'list[DiskPoolStatus]',
        'status_not': 'DiskPoolStatus',
        'status_not_in': 'list[DiskPoolStatus]',
        'total_cache_capacity': 'int',
        'total_cache_capacity_gt': 'int',
        'total_cache_capacity_gte': 'int',
        'total_cache_capacity_in': 'list[int]',
        'total_cache_capacity_lt': 'int',
        'total_cache_capacity_lte': 'int',
        'total_cache_capacity_not': 'int',
        'total_cache_capacity_not_in': 'list[int]',
        'total_data_capacity': 'int',
        'total_data_capacity_gt': 'int',
        'total_data_capacity_gte': 'int',
        'total_data_capacity_in': 'list[int]',
        'total_data_capacity_lt': 'int',
        'total_data_capacity_lte': 'int',
        'total_data_capacity_not': 'int',
        'total_data_capacity_not_in': 'list[int]',
        'use_state': 'DiskPoolUseState',
        'use_state_in': 'list[DiskPoolUseState]',
        'use_state_not': 'DiskPoolUseState',
        'use_state_not_in': 'list[DiskPoolUseState]',
        'used_cache_space': 'int',
        'used_cache_space_gt': 'int',
        'used_cache_space_gte': 'int',
        'used_cache_space_in': 'list[int]',
        'used_cache_space_lt': 'int',
        'used_cache_space_lte': 'int',
        'used_cache_space_not': 'int',
        'used_cache_space_not_in': 'list[int]',
        'used_data_space': 'int',
        'used_data_space_gt': 'int',
        'used_data_space_gte': 'int',
        'used_data_space_in': 'list[int]',
        'used_data_space_lt': 'int',
        'used_data_space_lte': 'int',
        'used_data_space_not': 'int',
        'used_data_space_not_in': 'list[int]',
        'valid_cache_space': 'int',
        'valid_cache_space_gt': 'int',
        'valid_cache_space_gte': 'int',
        'valid_cache_space_in': 'list[int]',
        'valid_cache_space_lt': 'int',
        'valid_cache_space_lte': 'int',
        'valid_cache_space_not': 'int',
        'valid_cache_space_not_in': 'list[int]',
        'valid_free_cache_space': 'int',
        'valid_free_cache_space_gt': 'int',
        'valid_free_cache_space_gte': 'int',
        'valid_free_cache_space_in': 'list[int]',
        'valid_free_cache_space_lt': 'int',
        'valid_free_cache_space_lte': 'int',
        'valid_free_cache_space_not': 'int',
        'valid_free_cache_space_not_in': 'list[int]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'chunk_id': 'chunk_id',
        'chunk_id_gt': 'chunk_id_gt',
        'chunk_id_gte': 'chunk_id_gte',
        'chunk_id_in': 'chunk_id_in',
        'chunk_id_lt': 'chunk_id_lt',
        'chunk_id_lte': 'chunk_id_lte',
        'chunk_id_not': 'chunk_id_not',
        'chunk_id_not_in': 'chunk_id_not_in',
        'chunk_ins_id': 'chunk_ins_id',
        'chunk_ins_id_gt': 'chunk_ins_id_gt',
        'chunk_ins_id_gte': 'chunk_ins_id_gte',
        'chunk_ins_id_in': 'chunk_ins_id_in',
        'chunk_ins_id_lt': 'chunk_ins_id_lt',
        'chunk_ins_id_lte': 'chunk_ins_id_lte',
        'chunk_ins_id_not': 'chunk_ins_id_not',
        'chunk_ins_id_not_in': 'chunk_ins_id_not_in',
        'data_space_usage': 'data_space_usage',
        'data_space_usage_gt': 'data_space_usage_gt',
        'data_space_usage_gte': 'data_space_usage_gte',
        'data_space_usage_in': 'data_space_usage_in',
        'data_space_usage_lt': 'data_space_usage_lt',
        'data_space_usage_lte': 'data_space_usage_lte',
        'data_space_usage_not': 'data_space_usage_not',
        'data_space_usage_not_in': 'data_space_usage_not_in',
        'dirty_cache_space': 'dirty_cache_space',
        'dirty_cache_space_gt': 'dirty_cache_space_gt',
        'dirty_cache_space_gte': 'dirty_cache_space_gte',
        'dirty_cache_space_in': 'dirty_cache_space_in',
        'dirty_cache_space_lt': 'dirty_cache_space_lt',
        'dirty_cache_space_lte': 'dirty_cache_space_lte',
        'dirty_cache_space_not': 'dirty_cache_space_not',
        'dirty_cache_space_not_in': 'dirty_cache_space_not_in',
        'dirty_cache_usage': 'dirty_cache_usage',
        'dirty_cache_usage_gt': 'dirty_cache_usage_gt',
        'dirty_cache_usage_gte': 'dirty_cache_usage_gte',
        'dirty_cache_usage_in': 'dirty_cache_usage_in',
        'dirty_cache_usage_lt': 'dirty_cache_usage_lt',
        'dirty_cache_usage_lte': 'dirty_cache_usage_lte',
        'dirty_cache_usage_not': 'dirty_cache_usage_not',
        'dirty_cache_usage_not_in': 'dirty_cache_usage_not_in',
        'disks_every': 'disks_every',
        'disks_none': 'disks_none',
        'disks_some': 'disks_some',
        'failure_cache_space': 'failure_cache_space',
        'failure_cache_space_gt': 'failure_cache_space_gt',
        'failure_cache_space_gte': 'failure_cache_space_gte',
        'failure_cache_space_in': 'failure_cache_space_in',
        'failure_cache_space_lt': 'failure_cache_space_lt',
        'failure_cache_space_lte': 'failure_cache_space_lte',
        'failure_cache_space_not': 'failure_cache_space_not',
        'failure_cache_space_not_in': 'failure_cache_space_not_in',
        'failure_data_space': 'failure_data_space',
        'failure_data_space_gt': 'failure_data_space_gt',
        'failure_data_space_gte': 'failure_data_space_gte',
        'failure_data_space_in': 'failure_data_space_in',
        'failure_data_space_lt': 'failure_data_space_lt',
        'failure_data_space_lte': 'failure_data_space_lte',
        'failure_data_space_not': 'failure_data_space_not',
        'failure_data_space_not_in': 'failure_data_space_not_in',
        'hdd_disk_count': 'hdd_disk_count',
        'hdd_disk_count_gt': 'hdd_disk_count_gt',
        'hdd_disk_count_gte': 'hdd_disk_count_gte',
        'hdd_disk_count_in': 'hdd_disk_count_in',
        'hdd_disk_count_lt': 'hdd_disk_count_lt',
        'hdd_disk_count_lte': 'hdd_disk_count_lte',
        'hdd_disk_count_not': 'hdd_disk_count_not',
        'hdd_disk_count_not_in': 'hdd_disk_count_not_in',
        'host': 'host',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'numa_node': 'numa_node',
        'numa_node_contains': 'numa_node_contains',
        'numa_node_ends_with': 'numa_node_ends_with',
        'numa_node_gt': 'numa_node_gt',
        'numa_node_gte': 'numa_node_gte',
        'numa_node_in': 'numa_node_in',
        'numa_node_lt': 'numa_node_lt',
        'numa_node_lte': 'numa_node_lte',
        'numa_node_not': 'numa_node_not',
        'numa_node_not_contains': 'numa_node_not_contains',
        'numa_node_not_ends_with': 'numa_node_not_ends_with',
        'numa_node_not_in': 'numa_node_not_in',
        'numa_node_not_starts_with': 'numa_node_not_starts_with',
        'numa_node_starts_with': 'numa_node_starts_with',
        'nvme_ssd_disk_count': 'nvme_ssd_disk_count',
        'nvme_ssd_disk_count_gt': 'nvme_ssd_disk_count_gt',
        'nvme_ssd_disk_count_gte': 'nvme_ssd_disk_count_gte',
        'nvme_ssd_disk_count_in': 'nvme_ssd_disk_count_in',
        'nvme_ssd_disk_count_lt': 'nvme_ssd_disk_count_lt',
        'nvme_ssd_disk_count_lte': 'nvme_ssd_disk_count_lte',
        'nvme_ssd_disk_count_not': 'nvme_ssd_disk_count_not',
        'nvme_ssd_disk_count_not_in': 'nvme_ssd_disk_count_not_in',
        'perf_allocated_data_space': 'perf_allocated_data_space',
        'perf_allocated_data_space_gt': 'perf_allocated_data_space_gt',
        'perf_allocated_data_space_gte': 'perf_allocated_data_space_gte',
        'perf_allocated_data_space_in': 'perf_allocated_data_space_in',
        'perf_allocated_data_space_lt': 'perf_allocated_data_space_lt',
        'perf_allocated_data_space_lte': 'perf_allocated_data_space_lte',
        'perf_allocated_data_space_not': 'perf_allocated_data_space_not',
        'perf_allocated_data_space_not_in': 'perf_allocated_data_space_not_in',
        'perf_failure_data_space': 'perf_failure_data_space',
        'perf_failure_data_space_gt': 'perf_failure_data_space_gt',
        'perf_failure_data_space_gte': 'perf_failure_data_space_gte',
        'perf_failure_data_space_in': 'perf_failure_data_space_in',
        'perf_failure_data_space_lt': 'perf_failure_data_space_lt',
        'perf_failure_data_space_lte': 'perf_failure_data_space_lte',
        'perf_failure_data_space_not': 'perf_failure_data_space_not',
        'perf_failure_data_space_not_in': 'perf_failure_data_space_not_in',
        'perf_total_data_capacity': 'perf_total_data_capacity',
        'perf_total_data_capacity_gt': 'perf_total_data_capacity_gt',
        'perf_total_data_capacity_gte': 'perf_total_data_capacity_gte',
        'perf_total_data_capacity_in': 'perf_total_data_capacity_in',
        'perf_total_data_capacity_lt': 'perf_total_data_capacity_lt',
        'perf_total_data_capacity_lte': 'perf_total_data_capacity_lte',
        'perf_total_data_capacity_not': 'perf_total_data_capacity_not',
        'perf_total_data_capacity_not_in': 'perf_total_data_capacity_not_in',
        'perf_used_data_space': 'perf_used_data_space',
        'perf_used_data_space_gt': 'perf_used_data_space_gt',
        'perf_used_data_space_gte': 'perf_used_data_space_gte',
        'perf_used_data_space_in': 'perf_used_data_space_in',
        'perf_used_data_space_lt': 'perf_used_data_space_lt',
        'perf_used_data_space_lte': 'perf_used_data_space_lte',
        'perf_used_data_space_not': 'perf_used_data_space_not',
        'perf_used_data_space_not_in': 'perf_used_data_space_not_in',
        'perf_valid_data_space': 'perf_valid_data_space',
        'perf_valid_data_space_gt': 'perf_valid_data_space_gt',
        'perf_valid_data_space_gte': 'perf_valid_data_space_gte',
        'perf_valid_data_space_in': 'perf_valid_data_space_in',
        'perf_valid_data_space_lt': 'perf_valid_data_space_lt',
        'perf_valid_data_space_lte': 'perf_valid_data_space_lte',
        'perf_valid_data_space_not': 'perf_valid_data_space_not',
        'perf_valid_data_space_not_in': 'perf_valid_data_space_not_in',
        'planned_prioritized_space': 'planned_prioritized_space',
        'planned_prioritized_space_gt': 'planned_prioritized_space_gt',
        'planned_prioritized_space_gte': 'planned_prioritized_space_gte',
        'planned_prioritized_space_in': 'planned_prioritized_space_in',
        'planned_prioritized_space_lt': 'planned_prioritized_space_lt',
        'planned_prioritized_space_lte': 'planned_prioritized_space_lte',
        'planned_prioritized_space_not': 'planned_prioritized_space_not',
        'planned_prioritized_space_not_in': 'planned_prioritized_space_not_in',
        'prio_space_percentage': 'prio_space_percentage',
        'prio_space_percentage_gt': 'prio_space_percentage_gt',
        'prio_space_percentage_gte': 'prio_space_percentage_gte',
        'prio_space_percentage_in': 'prio_space_percentage_in',
        'prio_space_percentage_lt': 'prio_space_percentage_lt',
        'prio_space_percentage_lte': 'prio_space_percentage_lte',
        'prio_space_percentage_not': 'prio_space_percentage_not',
        'prio_space_percentage_not_in': 'prio_space_percentage_not_in',
        'sata_or_sas_ssd_disk_count': 'sata_or_sas_ssd_disk_count',
        'sata_or_sas_ssd_disk_count_gt': 'sata_or_sas_ssd_disk_count_gt',
        'sata_or_sas_ssd_disk_count_gte': 'sata_or_sas_ssd_disk_count_gte',
        'sata_or_sas_ssd_disk_count_in': 'sata_or_sas_ssd_disk_count_in',
        'sata_or_sas_ssd_disk_count_lt': 'sata_or_sas_ssd_disk_count_lt',
        'sata_or_sas_ssd_disk_count_lte': 'sata_or_sas_ssd_disk_count_lte',
        'sata_or_sas_ssd_disk_count_not': 'sata_or_sas_ssd_disk_count_not',
        'sata_or_sas_ssd_disk_count_not_in': 'sata_or_sas_ssd_disk_count_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'total_cache_capacity': 'total_cache_capacity',
        'total_cache_capacity_gt': 'total_cache_capacity_gt',
        'total_cache_capacity_gte': 'total_cache_capacity_gte',
        'total_cache_capacity_in': 'total_cache_capacity_in',
        'total_cache_capacity_lt': 'total_cache_capacity_lt',
        'total_cache_capacity_lte': 'total_cache_capacity_lte',
        'total_cache_capacity_not': 'total_cache_capacity_not',
        'total_cache_capacity_not_in': 'total_cache_capacity_not_in',
        'total_data_capacity': 'total_data_capacity',
        'total_data_capacity_gt': 'total_data_capacity_gt',
        'total_data_capacity_gte': 'total_data_capacity_gte',
        'total_data_capacity_in': 'total_data_capacity_in',
        'total_data_capacity_lt': 'total_data_capacity_lt',
        'total_data_capacity_lte': 'total_data_capacity_lte',
        'total_data_capacity_not': 'total_data_capacity_not',
        'total_data_capacity_not_in': 'total_data_capacity_not_in',
        'use_state': 'use_state',
        'use_state_in': 'use_state_in',
        'use_state_not': 'use_state_not',
        'use_state_not_in': 'use_state_not_in',
        'used_cache_space': 'used_cache_space',
        'used_cache_space_gt': 'used_cache_space_gt',
        'used_cache_space_gte': 'used_cache_space_gte',
        'used_cache_space_in': 'used_cache_space_in',
        'used_cache_space_lt': 'used_cache_space_lt',
        'used_cache_space_lte': 'used_cache_space_lte',
        'used_cache_space_not': 'used_cache_space_not',
        'used_cache_space_not_in': 'used_cache_space_not_in',
        'used_data_space': 'used_data_space',
        'used_data_space_gt': 'used_data_space_gt',
        'used_data_space_gte': 'used_data_space_gte',
        'used_data_space_in': 'used_data_space_in',
        'used_data_space_lt': 'used_data_space_lt',
        'used_data_space_lte': 'used_data_space_lte',
        'used_data_space_not': 'used_data_space_not',
        'used_data_space_not_in': 'used_data_space_not_in',
        'valid_cache_space': 'valid_cache_space',
        'valid_cache_space_gt': 'valid_cache_space_gt',
        'valid_cache_space_gte': 'valid_cache_space_gte',
        'valid_cache_space_in': 'valid_cache_space_in',
        'valid_cache_space_lt': 'valid_cache_space_lt',
        'valid_cache_space_lte': 'valid_cache_space_lte',
        'valid_cache_space_not': 'valid_cache_space_not',
        'valid_cache_space_not_in': 'valid_cache_space_not_in',
        'valid_free_cache_space': 'valid_free_cache_space',
        'valid_free_cache_space_gt': 'valid_free_cache_space_gt',
        'valid_free_cache_space_gte': 'valid_free_cache_space_gte',
        'valid_free_cache_space_in': 'valid_free_cache_space_in',
        'valid_free_cache_space_lt': 'valid_free_cache_space_lt',
        'valid_free_cache_space_lte': 'valid_free_cache_space_lte',
        'valid_free_cache_space_not': 'valid_free_cache_space_not',
        'valid_free_cache_space_not_in': 'valid_free_cache_space_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DiskPoolWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._chunk_id = None
        self._chunk_id_gt = None
        self._chunk_id_gte = None
        self._chunk_id_in = None
        self._chunk_id_lt = None
        self._chunk_id_lte = None
        self._chunk_id_not = None
        self._chunk_id_not_in = None
        self._chunk_ins_id = None
        self._chunk_ins_id_gt = None
        self._chunk_ins_id_gte = None
        self._chunk_ins_id_in = None
        self._chunk_ins_id_lt = None
        self._chunk_ins_id_lte = None
        self._chunk_ins_id_not = None
        self._chunk_ins_id_not_in = None
        self._data_space_usage = None
        self._data_space_usage_gt = None
        self._data_space_usage_gte = None
        self._data_space_usage_in = None
        self._data_space_usage_lt = None
        self._data_space_usage_lte = None
        self._data_space_usage_not = None
        self._data_space_usage_not_in = None
        self._dirty_cache_space = None
        self._dirty_cache_space_gt = None
        self._dirty_cache_space_gte = None
        self._dirty_cache_space_in = None
        self._dirty_cache_space_lt = None
        self._dirty_cache_space_lte = None
        self._dirty_cache_space_not = None
        self._dirty_cache_space_not_in = None
        self._dirty_cache_usage = None
        self._dirty_cache_usage_gt = None
        self._dirty_cache_usage_gte = None
        self._dirty_cache_usage_in = None
        self._dirty_cache_usage_lt = None
        self._dirty_cache_usage_lte = None
        self._dirty_cache_usage_not = None
        self._dirty_cache_usage_not_in = None
        self._disks_every = None
        self._disks_none = None
        self._disks_some = None
        self._failure_cache_space = None
        self._failure_cache_space_gt = None
        self._failure_cache_space_gte = None
        self._failure_cache_space_in = None
        self._failure_cache_space_lt = None
        self._failure_cache_space_lte = None
        self._failure_cache_space_not = None
        self._failure_cache_space_not_in = None
        self._failure_data_space = None
        self._failure_data_space_gt = None
        self._failure_data_space_gte = None
        self._failure_data_space_in = None
        self._failure_data_space_lt = None
        self._failure_data_space_lte = None
        self._failure_data_space_not = None
        self._failure_data_space_not_in = None
        self._hdd_disk_count = None
        self._hdd_disk_count_gt = None
        self._hdd_disk_count_gte = None
        self._hdd_disk_count_in = None
        self._hdd_disk_count_lt = None
        self._hdd_disk_count_lte = None
        self._hdd_disk_count_not = None
        self._hdd_disk_count_not_in = None
        self._host = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._numa_node = None
        self._numa_node_contains = None
        self._numa_node_ends_with = None
        self._numa_node_gt = None
        self._numa_node_gte = None
        self._numa_node_in = None
        self._numa_node_lt = None
        self._numa_node_lte = None
        self._numa_node_not = None
        self._numa_node_not_contains = None
        self._numa_node_not_ends_with = None
        self._numa_node_not_in = None
        self._numa_node_not_starts_with = None
        self._numa_node_starts_with = None
        self._nvme_ssd_disk_count = None
        self._nvme_ssd_disk_count_gt = None
        self._nvme_ssd_disk_count_gte = None
        self._nvme_ssd_disk_count_in = None
        self._nvme_ssd_disk_count_lt = None
        self._nvme_ssd_disk_count_lte = None
        self._nvme_ssd_disk_count_not = None
        self._nvme_ssd_disk_count_not_in = None
        self._perf_allocated_data_space = None
        self._perf_allocated_data_space_gt = None
        self._perf_allocated_data_space_gte = None
        self._perf_allocated_data_space_in = None
        self._perf_allocated_data_space_lt = None
        self._perf_allocated_data_space_lte = None
        self._perf_allocated_data_space_not = None
        self._perf_allocated_data_space_not_in = None
        self._perf_failure_data_space = None
        self._perf_failure_data_space_gt = None
        self._perf_failure_data_space_gte = None
        self._perf_failure_data_space_in = None
        self._perf_failure_data_space_lt = None
        self._perf_failure_data_space_lte = None
        self._perf_failure_data_space_not = None
        self._perf_failure_data_space_not_in = None
        self._perf_total_data_capacity = None
        self._perf_total_data_capacity_gt = None
        self._perf_total_data_capacity_gte = None
        self._perf_total_data_capacity_in = None
        self._perf_total_data_capacity_lt = None
        self._perf_total_data_capacity_lte = None
        self._perf_total_data_capacity_not = None
        self._perf_total_data_capacity_not_in = None
        self._perf_used_data_space = None
        self._perf_used_data_space_gt = None
        self._perf_used_data_space_gte = None
        self._perf_used_data_space_in = None
        self._perf_used_data_space_lt = None
        self._perf_used_data_space_lte = None
        self._perf_used_data_space_not = None
        self._perf_used_data_space_not_in = None
        self._perf_valid_data_space = None
        self._perf_valid_data_space_gt = None
        self._perf_valid_data_space_gte = None
        self._perf_valid_data_space_in = None
        self._perf_valid_data_space_lt = None
        self._perf_valid_data_space_lte = None
        self._perf_valid_data_space_not = None
        self._perf_valid_data_space_not_in = None
        self._planned_prioritized_space = None
        self._planned_prioritized_space_gt = None
        self._planned_prioritized_space_gte = None
        self._planned_prioritized_space_in = None
        self._planned_prioritized_space_lt = None
        self._planned_prioritized_space_lte = None
        self._planned_prioritized_space_not = None
        self._planned_prioritized_space_not_in = None
        self._prio_space_percentage = None
        self._prio_space_percentage_gt = None
        self._prio_space_percentage_gte = None
        self._prio_space_percentage_in = None
        self._prio_space_percentage_lt = None
        self._prio_space_percentage_lte = None
        self._prio_space_percentage_not = None
        self._prio_space_percentage_not_in = None
        self._sata_or_sas_ssd_disk_count = None
        self._sata_or_sas_ssd_disk_count_gt = None
        self._sata_or_sas_ssd_disk_count_gte = None
        self._sata_or_sas_ssd_disk_count_in = None
        self._sata_or_sas_ssd_disk_count_lt = None
        self._sata_or_sas_ssd_disk_count_lte = None
        self._sata_or_sas_ssd_disk_count_not = None
        self._sata_or_sas_ssd_disk_count_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._total_cache_capacity = None
        self._total_cache_capacity_gt = None
        self._total_cache_capacity_gte = None
        self._total_cache_capacity_in = None
        self._total_cache_capacity_lt = None
        self._total_cache_capacity_lte = None
        self._total_cache_capacity_not = None
        self._total_cache_capacity_not_in = None
        self._total_data_capacity = None
        self._total_data_capacity_gt = None
        self._total_data_capacity_gte = None
        self._total_data_capacity_in = None
        self._total_data_capacity_lt = None
        self._total_data_capacity_lte = None
        self._total_data_capacity_not = None
        self._total_data_capacity_not_in = None
        self._use_state = None
        self._use_state_in = None
        self._use_state_not = None
        self._use_state_not_in = None
        self._used_cache_space = None
        self._used_cache_space_gt = None
        self._used_cache_space_gte = None
        self._used_cache_space_in = None
        self._used_cache_space_lt = None
        self._used_cache_space_lte = None
        self._used_cache_space_not = None
        self._used_cache_space_not_in = None
        self._used_data_space = None
        self._used_data_space_gt = None
        self._used_data_space_gte = None
        self._used_data_space_in = None
        self._used_data_space_lt = None
        self._used_data_space_lte = None
        self._used_data_space_not = None
        self._used_data_space_not_in = None
        self._valid_cache_space = None
        self._valid_cache_space_gt = None
        self._valid_cache_space_gte = None
        self._valid_cache_space_in = None
        self._valid_cache_space_lt = None
        self._valid_cache_space_lte = None
        self._valid_cache_space_not = None
        self._valid_cache_space_not_in = None
        self._valid_free_cache_space = None
        self._valid_free_cache_space_gt = None
        self._valid_free_cache_space_gte = None
        self._valid_free_cache_space_in = None
        self._valid_free_cache_space_lt = None
        self._valid_free_cache_space_lte = None
        self._valid_free_cache_space_not = None
        self._valid_free_cache_space_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.chunk_id = kwargs.get("chunk_id", None)
        self.chunk_id_gt = kwargs.get("chunk_id_gt", None)
        self.chunk_id_gte = kwargs.get("chunk_id_gte", None)
        self.chunk_id_in = kwargs.get("chunk_id_in", None)
        self.chunk_id_lt = kwargs.get("chunk_id_lt", None)
        self.chunk_id_lte = kwargs.get("chunk_id_lte", None)
        self.chunk_id_not = kwargs.get("chunk_id_not", None)
        self.chunk_id_not_in = kwargs.get("chunk_id_not_in", None)
        self.chunk_ins_id = kwargs.get("chunk_ins_id", None)
        self.chunk_ins_id_gt = kwargs.get("chunk_ins_id_gt", None)
        self.chunk_ins_id_gte = kwargs.get("chunk_ins_id_gte", None)
        self.chunk_ins_id_in = kwargs.get("chunk_ins_id_in", None)
        self.chunk_ins_id_lt = kwargs.get("chunk_ins_id_lt", None)
        self.chunk_ins_id_lte = kwargs.get("chunk_ins_id_lte", None)
        self.chunk_ins_id_not = kwargs.get("chunk_ins_id_not", None)
        self.chunk_ins_id_not_in = kwargs.get("chunk_ins_id_not_in", None)
        self.data_space_usage = kwargs.get("data_space_usage", None)
        self.data_space_usage_gt = kwargs.get("data_space_usage_gt", None)
        self.data_space_usage_gte = kwargs.get("data_space_usage_gte", None)
        self.data_space_usage_in = kwargs.get("data_space_usage_in", None)
        self.data_space_usage_lt = kwargs.get("data_space_usage_lt", None)
        self.data_space_usage_lte = kwargs.get("data_space_usage_lte", None)
        self.data_space_usage_not = kwargs.get("data_space_usage_not", None)
        self.data_space_usage_not_in = kwargs.get("data_space_usage_not_in", None)
        self.dirty_cache_space = kwargs.get("dirty_cache_space", None)
        self.dirty_cache_space_gt = kwargs.get("dirty_cache_space_gt", None)
        self.dirty_cache_space_gte = kwargs.get("dirty_cache_space_gte", None)
        self.dirty_cache_space_in = kwargs.get("dirty_cache_space_in", None)
        self.dirty_cache_space_lt = kwargs.get("dirty_cache_space_lt", None)
        self.dirty_cache_space_lte = kwargs.get("dirty_cache_space_lte", None)
        self.dirty_cache_space_not = kwargs.get("dirty_cache_space_not", None)
        self.dirty_cache_space_not_in = kwargs.get("dirty_cache_space_not_in", None)
        self.dirty_cache_usage = kwargs.get("dirty_cache_usage", None)
        self.dirty_cache_usage_gt = kwargs.get("dirty_cache_usage_gt", None)
        self.dirty_cache_usage_gte = kwargs.get("dirty_cache_usage_gte", None)
        self.dirty_cache_usage_in = kwargs.get("dirty_cache_usage_in", None)
        self.dirty_cache_usage_lt = kwargs.get("dirty_cache_usage_lt", None)
        self.dirty_cache_usage_lte = kwargs.get("dirty_cache_usage_lte", None)
        self.dirty_cache_usage_not = kwargs.get("dirty_cache_usage_not", None)
        self.dirty_cache_usage_not_in = kwargs.get("dirty_cache_usage_not_in", None)
        self.disks_every = kwargs.get("disks_every", None)
        self.disks_none = kwargs.get("disks_none", None)
        self.disks_some = kwargs.get("disks_some", None)
        self.failure_cache_space = kwargs.get("failure_cache_space", None)
        self.failure_cache_space_gt = kwargs.get("failure_cache_space_gt", None)
        self.failure_cache_space_gte = kwargs.get("failure_cache_space_gte", None)
        self.failure_cache_space_in = kwargs.get("failure_cache_space_in", None)
        self.failure_cache_space_lt = kwargs.get("failure_cache_space_lt", None)
        self.failure_cache_space_lte = kwargs.get("failure_cache_space_lte", None)
        self.failure_cache_space_not = kwargs.get("failure_cache_space_not", None)
        self.failure_cache_space_not_in = kwargs.get("failure_cache_space_not_in", None)
        self.failure_data_space = kwargs.get("failure_data_space", None)
        self.failure_data_space_gt = kwargs.get("failure_data_space_gt", None)
        self.failure_data_space_gte = kwargs.get("failure_data_space_gte", None)
        self.failure_data_space_in = kwargs.get("failure_data_space_in", None)
        self.failure_data_space_lt = kwargs.get("failure_data_space_lt", None)
        self.failure_data_space_lte = kwargs.get("failure_data_space_lte", None)
        self.failure_data_space_not = kwargs.get("failure_data_space_not", None)
        self.failure_data_space_not_in = kwargs.get("failure_data_space_not_in", None)
        self.hdd_disk_count = kwargs.get("hdd_disk_count", None)
        self.hdd_disk_count_gt = kwargs.get("hdd_disk_count_gt", None)
        self.hdd_disk_count_gte = kwargs.get("hdd_disk_count_gte", None)
        self.hdd_disk_count_in = kwargs.get("hdd_disk_count_in", None)
        self.hdd_disk_count_lt = kwargs.get("hdd_disk_count_lt", None)
        self.hdd_disk_count_lte = kwargs.get("hdd_disk_count_lte", None)
        self.hdd_disk_count_not = kwargs.get("hdd_disk_count_not", None)
        self.hdd_disk_count_not_in = kwargs.get("hdd_disk_count_not_in", None)
        self.host = kwargs.get("host", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.numa_node = kwargs.get("numa_node", None)
        self.numa_node_contains = kwargs.get("numa_node_contains", None)
        self.numa_node_ends_with = kwargs.get("numa_node_ends_with", None)
        self.numa_node_gt = kwargs.get("numa_node_gt", None)
        self.numa_node_gte = kwargs.get("numa_node_gte", None)
        self.numa_node_in = kwargs.get("numa_node_in", None)
        self.numa_node_lt = kwargs.get("numa_node_lt", None)
        self.numa_node_lte = kwargs.get("numa_node_lte", None)
        self.numa_node_not = kwargs.get("numa_node_not", None)
        self.numa_node_not_contains = kwargs.get("numa_node_not_contains", None)
        self.numa_node_not_ends_with = kwargs.get("numa_node_not_ends_with", None)
        self.numa_node_not_in = kwargs.get("numa_node_not_in", None)
        self.numa_node_not_starts_with = kwargs.get("numa_node_not_starts_with", None)
        self.numa_node_starts_with = kwargs.get("numa_node_starts_with", None)
        self.nvme_ssd_disk_count = kwargs.get("nvme_ssd_disk_count", None)
        self.nvme_ssd_disk_count_gt = kwargs.get("nvme_ssd_disk_count_gt", None)
        self.nvme_ssd_disk_count_gte = kwargs.get("nvme_ssd_disk_count_gte", None)
        self.nvme_ssd_disk_count_in = kwargs.get("nvme_ssd_disk_count_in", None)
        self.nvme_ssd_disk_count_lt = kwargs.get("nvme_ssd_disk_count_lt", None)
        self.nvme_ssd_disk_count_lte = kwargs.get("nvme_ssd_disk_count_lte", None)
        self.nvme_ssd_disk_count_not = kwargs.get("nvme_ssd_disk_count_not", None)
        self.nvme_ssd_disk_count_not_in = kwargs.get("nvme_ssd_disk_count_not_in", None)
        self.perf_allocated_data_space = kwargs.get("perf_allocated_data_space", None)
        self.perf_allocated_data_space_gt = kwargs.get("perf_allocated_data_space_gt", None)
        self.perf_allocated_data_space_gte = kwargs.get("perf_allocated_data_space_gte", None)
        self.perf_allocated_data_space_in = kwargs.get("perf_allocated_data_space_in", None)
        self.perf_allocated_data_space_lt = kwargs.get("perf_allocated_data_space_lt", None)
        self.perf_allocated_data_space_lte = kwargs.get("perf_allocated_data_space_lte", None)
        self.perf_allocated_data_space_not = kwargs.get("perf_allocated_data_space_not", None)
        self.perf_allocated_data_space_not_in = kwargs.get("perf_allocated_data_space_not_in", None)
        self.perf_failure_data_space = kwargs.get("perf_failure_data_space", None)
        self.perf_failure_data_space_gt = kwargs.get("perf_failure_data_space_gt", None)
        self.perf_failure_data_space_gte = kwargs.get("perf_failure_data_space_gte", None)
        self.perf_failure_data_space_in = kwargs.get("perf_failure_data_space_in", None)
        self.perf_failure_data_space_lt = kwargs.get("perf_failure_data_space_lt", None)
        self.perf_failure_data_space_lte = kwargs.get("perf_failure_data_space_lte", None)
        self.perf_failure_data_space_not = kwargs.get("perf_failure_data_space_not", None)
        self.perf_failure_data_space_not_in = kwargs.get("perf_failure_data_space_not_in", None)
        self.perf_total_data_capacity = kwargs.get("perf_total_data_capacity", None)
        self.perf_total_data_capacity_gt = kwargs.get("perf_total_data_capacity_gt", None)
        self.perf_total_data_capacity_gte = kwargs.get("perf_total_data_capacity_gte", None)
        self.perf_total_data_capacity_in = kwargs.get("perf_total_data_capacity_in", None)
        self.perf_total_data_capacity_lt = kwargs.get("perf_total_data_capacity_lt", None)
        self.perf_total_data_capacity_lte = kwargs.get("perf_total_data_capacity_lte", None)
        self.perf_total_data_capacity_not = kwargs.get("perf_total_data_capacity_not", None)
        self.perf_total_data_capacity_not_in = kwargs.get("perf_total_data_capacity_not_in", None)
        self.perf_used_data_space = kwargs.get("perf_used_data_space", None)
        self.perf_used_data_space_gt = kwargs.get("perf_used_data_space_gt", None)
        self.perf_used_data_space_gte = kwargs.get("perf_used_data_space_gte", None)
        self.perf_used_data_space_in = kwargs.get("perf_used_data_space_in", None)
        self.perf_used_data_space_lt = kwargs.get("perf_used_data_space_lt", None)
        self.perf_used_data_space_lte = kwargs.get("perf_used_data_space_lte", None)
        self.perf_used_data_space_not = kwargs.get("perf_used_data_space_not", None)
        self.perf_used_data_space_not_in = kwargs.get("perf_used_data_space_not_in", None)
        self.perf_valid_data_space = kwargs.get("perf_valid_data_space", None)
        self.perf_valid_data_space_gt = kwargs.get("perf_valid_data_space_gt", None)
        self.perf_valid_data_space_gte = kwargs.get("perf_valid_data_space_gte", None)
        self.perf_valid_data_space_in = kwargs.get("perf_valid_data_space_in", None)
        self.perf_valid_data_space_lt = kwargs.get("perf_valid_data_space_lt", None)
        self.perf_valid_data_space_lte = kwargs.get("perf_valid_data_space_lte", None)
        self.perf_valid_data_space_not = kwargs.get("perf_valid_data_space_not", None)
        self.perf_valid_data_space_not_in = kwargs.get("perf_valid_data_space_not_in", None)
        self.planned_prioritized_space = kwargs.get("planned_prioritized_space", None)
        self.planned_prioritized_space_gt = kwargs.get("planned_prioritized_space_gt", None)
        self.planned_prioritized_space_gte = kwargs.get("planned_prioritized_space_gte", None)
        self.planned_prioritized_space_in = kwargs.get("planned_prioritized_space_in", None)
        self.planned_prioritized_space_lt = kwargs.get("planned_prioritized_space_lt", None)
        self.planned_prioritized_space_lte = kwargs.get("planned_prioritized_space_lte", None)
        self.planned_prioritized_space_not = kwargs.get("planned_prioritized_space_not", None)
        self.planned_prioritized_space_not_in = kwargs.get("planned_prioritized_space_not_in", None)
        self.prio_space_percentage = kwargs.get("prio_space_percentage", None)
        self.prio_space_percentage_gt = kwargs.get("prio_space_percentage_gt", None)
        self.prio_space_percentage_gte = kwargs.get("prio_space_percentage_gte", None)
        self.prio_space_percentage_in = kwargs.get("prio_space_percentage_in", None)
        self.prio_space_percentage_lt = kwargs.get("prio_space_percentage_lt", None)
        self.prio_space_percentage_lte = kwargs.get("prio_space_percentage_lte", None)
        self.prio_space_percentage_not = kwargs.get("prio_space_percentage_not", None)
        self.prio_space_percentage_not_in = kwargs.get("prio_space_percentage_not_in", None)
        self.sata_or_sas_ssd_disk_count = kwargs.get("sata_or_sas_ssd_disk_count", None)
        self.sata_or_sas_ssd_disk_count_gt = kwargs.get("sata_or_sas_ssd_disk_count_gt", None)
        self.sata_or_sas_ssd_disk_count_gte = kwargs.get("sata_or_sas_ssd_disk_count_gte", None)
        self.sata_or_sas_ssd_disk_count_in = kwargs.get("sata_or_sas_ssd_disk_count_in", None)
        self.sata_or_sas_ssd_disk_count_lt = kwargs.get("sata_or_sas_ssd_disk_count_lt", None)
        self.sata_or_sas_ssd_disk_count_lte = kwargs.get("sata_or_sas_ssd_disk_count_lte", None)
        self.sata_or_sas_ssd_disk_count_not = kwargs.get("sata_or_sas_ssd_disk_count_not", None)
        self.sata_or_sas_ssd_disk_count_not_in = kwargs.get("sata_or_sas_ssd_disk_count_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.total_cache_capacity = kwargs.get("total_cache_capacity", None)
        self.total_cache_capacity_gt = kwargs.get("total_cache_capacity_gt", None)
        self.total_cache_capacity_gte = kwargs.get("total_cache_capacity_gte", None)
        self.total_cache_capacity_in = kwargs.get("total_cache_capacity_in", None)
        self.total_cache_capacity_lt = kwargs.get("total_cache_capacity_lt", None)
        self.total_cache_capacity_lte = kwargs.get("total_cache_capacity_lte", None)
        self.total_cache_capacity_not = kwargs.get("total_cache_capacity_not", None)
        self.total_cache_capacity_not_in = kwargs.get("total_cache_capacity_not_in", None)
        self.total_data_capacity = kwargs.get("total_data_capacity", None)
        self.total_data_capacity_gt = kwargs.get("total_data_capacity_gt", None)
        self.total_data_capacity_gte = kwargs.get("total_data_capacity_gte", None)
        self.total_data_capacity_in = kwargs.get("total_data_capacity_in", None)
        self.total_data_capacity_lt = kwargs.get("total_data_capacity_lt", None)
        self.total_data_capacity_lte = kwargs.get("total_data_capacity_lte", None)
        self.total_data_capacity_not = kwargs.get("total_data_capacity_not", None)
        self.total_data_capacity_not_in = kwargs.get("total_data_capacity_not_in", None)
        self.use_state = kwargs.get("use_state", None)
        self.use_state_in = kwargs.get("use_state_in", None)
        self.use_state_not = kwargs.get("use_state_not", None)
        self.use_state_not_in = kwargs.get("use_state_not_in", None)
        self.used_cache_space = kwargs.get("used_cache_space", None)
        self.used_cache_space_gt = kwargs.get("used_cache_space_gt", None)
        self.used_cache_space_gte = kwargs.get("used_cache_space_gte", None)
        self.used_cache_space_in = kwargs.get("used_cache_space_in", None)
        self.used_cache_space_lt = kwargs.get("used_cache_space_lt", None)
        self.used_cache_space_lte = kwargs.get("used_cache_space_lte", None)
        self.used_cache_space_not = kwargs.get("used_cache_space_not", None)
        self.used_cache_space_not_in = kwargs.get("used_cache_space_not_in", None)
        self.used_data_space = kwargs.get("used_data_space", None)
        self.used_data_space_gt = kwargs.get("used_data_space_gt", None)
        self.used_data_space_gte = kwargs.get("used_data_space_gte", None)
        self.used_data_space_in = kwargs.get("used_data_space_in", None)
        self.used_data_space_lt = kwargs.get("used_data_space_lt", None)
        self.used_data_space_lte = kwargs.get("used_data_space_lte", None)
        self.used_data_space_not = kwargs.get("used_data_space_not", None)
        self.used_data_space_not_in = kwargs.get("used_data_space_not_in", None)
        self.valid_cache_space = kwargs.get("valid_cache_space", None)
        self.valid_cache_space_gt = kwargs.get("valid_cache_space_gt", None)
        self.valid_cache_space_gte = kwargs.get("valid_cache_space_gte", None)
        self.valid_cache_space_in = kwargs.get("valid_cache_space_in", None)
        self.valid_cache_space_lt = kwargs.get("valid_cache_space_lt", None)
        self.valid_cache_space_lte = kwargs.get("valid_cache_space_lte", None)
        self.valid_cache_space_not = kwargs.get("valid_cache_space_not", None)
        self.valid_cache_space_not_in = kwargs.get("valid_cache_space_not_in", None)
        self.valid_free_cache_space = kwargs.get("valid_free_cache_space", None)
        self.valid_free_cache_space_gt = kwargs.get("valid_free_cache_space_gt", None)
        self.valid_free_cache_space_gte = kwargs.get("valid_free_cache_space_gte", None)
        self.valid_free_cache_space_in = kwargs.get("valid_free_cache_space_in", None)
        self.valid_free_cache_space_lt = kwargs.get("valid_free_cache_space_lt", None)
        self.valid_free_cache_space_lte = kwargs.get("valid_free_cache_space_lte", None)
        self.valid_free_cache_space_not = kwargs.get("valid_free_cache_space_not", None)
        self.valid_free_cache_space_not_in = kwargs.get("valid_free_cache_space_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this DiskPoolWhereInput.  # noqa: E501


        :return: The _and of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this DiskPoolWhereInput.


        :param _and: The _and of this DiskPoolWhereInput.  # noqa: E501
        :type _and: list[DiskPoolWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this DiskPoolWhereInput.  # noqa: E501


        :return: The _not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this DiskPoolWhereInput.


        :param _not: The _not of this DiskPoolWhereInput.  # noqa: E501
        :type _not: list[DiskPoolWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this DiskPoolWhereInput.  # noqa: E501


        :return: The _or of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this DiskPoolWhereInput.


        :param _or: The _or of this DiskPoolWhereInput.  # noqa: E501
        :type _or: list[DiskPoolWhereInput]
        """

        self.__or = _or

    @property
    def chunk_id(self):
        """Gets the chunk_id of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id

    @chunk_id.setter
    def chunk_id(self, chunk_id):
        """Sets the chunk_id of this DiskPoolWhereInput.


        :param chunk_id: The chunk_id of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id: int
        """

        self._chunk_id = chunk_id

    @property
    def chunk_id_gt(self):
        """Gets the chunk_id_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id_gt

    @chunk_id_gt.setter
    def chunk_id_gt(self, chunk_id_gt):
        """Sets the chunk_id_gt of this DiskPoolWhereInput.


        :param chunk_id_gt: The chunk_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_gt: int
        """

        self._chunk_id_gt = chunk_id_gt

    @property
    def chunk_id_gte(self):
        """Gets the chunk_id_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id_gte

    @chunk_id_gte.setter
    def chunk_id_gte(self, chunk_id_gte):
        """Sets the chunk_id_gte of this DiskPoolWhereInput.


        :param chunk_id_gte: The chunk_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_gte: int
        """

        self._chunk_id_gte = chunk_id_gte

    @property
    def chunk_id_in(self):
        """Gets the chunk_id_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_id_in

    @chunk_id_in.setter
    def chunk_id_in(self, chunk_id_in):
        """Sets the chunk_id_in of this DiskPoolWhereInput.


        :param chunk_id_in: The chunk_id_in of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_in: list[int]
        """

        self._chunk_id_in = chunk_id_in

    @property
    def chunk_id_lt(self):
        """Gets the chunk_id_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id_lt

    @chunk_id_lt.setter
    def chunk_id_lt(self, chunk_id_lt):
        """Sets the chunk_id_lt of this DiskPoolWhereInput.


        :param chunk_id_lt: The chunk_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_lt: int
        """

        self._chunk_id_lt = chunk_id_lt

    @property
    def chunk_id_lte(self):
        """Gets the chunk_id_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id_lte

    @chunk_id_lte.setter
    def chunk_id_lte(self, chunk_id_lte):
        """Sets the chunk_id_lte of this DiskPoolWhereInput.


        :param chunk_id_lte: The chunk_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_lte: int
        """

        self._chunk_id_lte = chunk_id_lte

    @property
    def chunk_id_not(self):
        """Gets the chunk_id_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_id_not

    @chunk_id_not.setter
    def chunk_id_not(self, chunk_id_not):
        """Sets the chunk_id_not of this DiskPoolWhereInput.


        :param chunk_id_not: The chunk_id_not of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_not: int
        """

        self._chunk_id_not = chunk_id_not

    @property
    def chunk_id_not_in(self):
        """Gets the chunk_id_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_id_not_in

    @chunk_id_not_in.setter
    def chunk_id_not_in(self, chunk_id_not_in):
        """Sets the chunk_id_not_in of this DiskPoolWhereInput.


        :param chunk_id_not_in: The chunk_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_id_not_in: list[int]
        """

        self._chunk_id_not_in = chunk_id_not_in

    @property
    def chunk_ins_id(self):
        """Gets the chunk_ins_id of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id

    @chunk_ins_id.setter
    def chunk_ins_id(self, chunk_ins_id):
        """Sets the chunk_ins_id of this DiskPoolWhereInput.


        :param chunk_ins_id: The chunk_ins_id of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id: int
        """

        self._chunk_ins_id = chunk_ins_id

    @property
    def chunk_ins_id_gt(self):
        """Gets the chunk_ins_id_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id_gt

    @chunk_ins_id_gt.setter
    def chunk_ins_id_gt(self, chunk_ins_id_gt):
        """Sets the chunk_ins_id_gt of this DiskPoolWhereInput.


        :param chunk_ins_id_gt: The chunk_ins_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_gt: int
        """

        self._chunk_ins_id_gt = chunk_ins_id_gt

    @property
    def chunk_ins_id_gte(self):
        """Gets the chunk_ins_id_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id_gte

    @chunk_ins_id_gte.setter
    def chunk_ins_id_gte(self, chunk_ins_id_gte):
        """Sets the chunk_ins_id_gte of this DiskPoolWhereInput.


        :param chunk_ins_id_gte: The chunk_ins_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_gte: int
        """

        self._chunk_ins_id_gte = chunk_ins_id_gte

    @property
    def chunk_ins_id_in(self):
        """Gets the chunk_ins_id_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_ins_id_in

    @chunk_ins_id_in.setter
    def chunk_ins_id_in(self, chunk_ins_id_in):
        """Sets the chunk_ins_id_in of this DiskPoolWhereInput.


        :param chunk_ins_id_in: The chunk_ins_id_in of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_in: list[int]
        """

        self._chunk_ins_id_in = chunk_ins_id_in

    @property
    def chunk_ins_id_lt(self):
        """Gets the chunk_ins_id_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id_lt

    @chunk_ins_id_lt.setter
    def chunk_ins_id_lt(self, chunk_ins_id_lt):
        """Sets the chunk_ins_id_lt of this DiskPoolWhereInput.


        :param chunk_ins_id_lt: The chunk_ins_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_lt: int
        """

        self._chunk_ins_id_lt = chunk_ins_id_lt

    @property
    def chunk_ins_id_lte(self):
        """Gets the chunk_ins_id_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id_lte

    @chunk_ins_id_lte.setter
    def chunk_ins_id_lte(self, chunk_ins_id_lte):
        """Sets the chunk_ins_id_lte of this DiskPoolWhereInput.


        :param chunk_ins_id_lte: The chunk_ins_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_lte: int
        """

        self._chunk_ins_id_lte = chunk_ins_id_lte

    @property
    def chunk_ins_id_not(self):
        """Gets the chunk_ins_id_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_ins_id_not

    @chunk_ins_id_not.setter
    def chunk_ins_id_not(self, chunk_ins_id_not):
        """Sets the chunk_ins_id_not of this DiskPoolWhereInput.


        :param chunk_ins_id_not: The chunk_ins_id_not of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_not: int
        """

        self._chunk_ins_id_not = chunk_ins_id_not

    @property
    def chunk_ins_id_not_in(self):
        """Gets the chunk_ins_id_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The chunk_ins_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_ins_id_not_in

    @chunk_ins_id_not_in.setter
    def chunk_ins_id_not_in(self, chunk_ins_id_not_in):
        """Sets the chunk_ins_id_not_in of this DiskPoolWhereInput.


        :param chunk_ins_id_not_in: The chunk_ins_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type chunk_ins_id_not_in: list[int]
        """

        self._chunk_ins_id_not_in = chunk_ins_id_not_in

    @property
    def data_space_usage(self):
        """Gets the data_space_usage of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage

    @data_space_usage.setter
    def data_space_usage(self, data_space_usage):
        """Sets the data_space_usage of this DiskPoolWhereInput.


        :param data_space_usage: The data_space_usage of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage: float
        """

        self._data_space_usage = data_space_usage

    @property
    def data_space_usage_gt(self):
        """Gets the data_space_usage_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage_gt

    @data_space_usage_gt.setter
    def data_space_usage_gt(self, data_space_usage_gt):
        """Sets the data_space_usage_gt of this DiskPoolWhereInput.


        :param data_space_usage_gt: The data_space_usage_gt of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_gt: float
        """

        self._data_space_usage_gt = data_space_usage_gt

    @property
    def data_space_usage_gte(self):
        """Gets the data_space_usage_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage_gte

    @data_space_usage_gte.setter
    def data_space_usage_gte(self, data_space_usage_gte):
        """Sets the data_space_usage_gte of this DiskPoolWhereInput.


        :param data_space_usage_gte: The data_space_usage_gte of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_gte: float
        """

        self._data_space_usage_gte = data_space_usage_gte

    @property
    def data_space_usage_in(self):
        """Gets the data_space_usage_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._data_space_usage_in

    @data_space_usage_in.setter
    def data_space_usage_in(self, data_space_usage_in):
        """Sets the data_space_usage_in of this DiskPoolWhereInput.


        :param data_space_usage_in: The data_space_usage_in of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_in: list[float]
        """

        self._data_space_usage_in = data_space_usage_in

    @property
    def data_space_usage_lt(self):
        """Gets the data_space_usage_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage_lt

    @data_space_usage_lt.setter
    def data_space_usage_lt(self, data_space_usage_lt):
        """Sets the data_space_usage_lt of this DiskPoolWhereInput.


        :param data_space_usage_lt: The data_space_usage_lt of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_lt: float
        """

        self._data_space_usage_lt = data_space_usage_lt

    @property
    def data_space_usage_lte(self):
        """Gets the data_space_usage_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage_lte

    @data_space_usage_lte.setter
    def data_space_usage_lte(self, data_space_usage_lte):
        """Sets the data_space_usage_lte of this DiskPoolWhereInput.


        :param data_space_usage_lte: The data_space_usage_lte of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_lte: float
        """

        self._data_space_usage_lte = data_space_usage_lte

    @property
    def data_space_usage_not(self):
        """Gets the data_space_usage_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._data_space_usage_not

    @data_space_usage_not.setter
    def data_space_usage_not(self, data_space_usage_not):
        """Sets the data_space_usage_not of this DiskPoolWhereInput.


        :param data_space_usage_not: The data_space_usage_not of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_not: float
        """

        self._data_space_usage_not = data_space_usage_not

    @property
    def data_space_usage_not_in(self):
        """Gets the data_space_usage_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The data_space_usage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._data_space_usage_not_in

    @data_space_usage_not_in.setter
    def data_space_usage_not_in(self, data_space_usage_not_in):
        """Sets the data_space_usage_not_in of this DiskPoolWhereInput.


        :param data_space_usage_not_in: The data_space_usage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type data_space_usage_not_in: list[float]
        """

        self._data_space_usage_not_in = data_space_usage_not_in

    @property
    def dirty_cache_space(self):
        """Gets the dirty_cache_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space

    @dirty_cache_space.setter
    def dirty_cache_space(self, dirty_cache_space):
        """Sets the dirty_cache_space of this DiskPoolWhereInput.


        :param dirty_cache_space: The dirty_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space: int
        """

        self._dirty_cache_space = dirty_cache_space

    @property
    def dirty_cache_space_gt(self):
        """Gets the dirty_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space_gt

    @dirty_cache_space_gt.setter
    def dirty_cache_space_gt(self, dirty_cache_space_gt):
        """Sets the dirty_cache_space_gt of this DiskPoolWhereInput.


        :param dirty_cache_space_gt: The dirty_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_gt: int
        """

        self._dirty_cache_space_gt = dirty_cache_space_gt

    @property
    def dirty_cache_space_gte(self):
        """Gets the dirty_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space_gte

    @dirty_cache_space_gte.setter
    def dirty_cache_space_gte(self, dirty_cache_space_gte):
        """Sets the dirty_cache_space_gte of this DiskPoolWhereInput.


        :param dirty_cache_space_gte: The dirty_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_gte: int
        """

        self._dirty_cache_space_gte = dirty_cache_space_gte

    @property
    def dirty_cache_space_in(self):
        """Gets the dirty_cache_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._dirty_cache_space_in

    @dirty_cache_space_in.setter
    def dirty_cache_space_in(self, dirty_cache_space_in):
        """Sets the dirty_cache_space_in of this DiskPoolWhereInput.


        :param dirty_cache_space_in: The dirty_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_in: list[int]
        """

        self._dirty_cache_space_in = dirty_cache_space_in

    @property
    def dirty_cache_space_lt(self):
        """Gets the dirty_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space_lt

    @dirty_cache_space_lt.setter
    def dirty_cache_space_lt(self, dirty_cache_space_lt):
        """Sets the dirty_cache_space_lt of this DiskPoolWhereInput.


        :param dirty_cache_space_lt: The dirty_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_lt: int
        """

        self._dirty_cache_space_lt = dirty_cache_space_lt

    @property
    def dirty_cache_space_lte(self):
        """Gets the dirty_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space_lte

    @dirty_cache_space_lte.setter
    def dirty_cache_space_lte(self, dirty_cache_space_lte):
        """Sets the dirty_cache_space_lte of this DiskPoolWhereInput.


        :param dirty_cache_space_lte: The dirty_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_lte: int
        """

        self._dirty_cache_space_lte = dirty_cache_space_lte

    @property
    def dirty_cache_space_not(self):
        """Gets the dirty_cache_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._dirty_cache_space_not

    @dirty_cache_space_not.setter
    def dirty_cache_space_not(self, dirty_cache_space_not):
        """Sets the dirty_cache_space_not of this DiskPoolWhereInput.


        :param dirty_cache_space_not: The dirty_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_not: int
        """

        self._dirty_cache_space_not = dirty_cache_space_not

    @property
    def dirty_cache_space_not_in(self):
        """Gets the dirty_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._dirty_cache_space_not_in

    @dirty_cache_space_not_in.setter
    def dirty_cache_space_not_in(self, dirty_cache_space_not_in):
        """Sets the dirty_cache_space_not_in of this DiskPoolWhereInput.


        :param dirty_cache_space_not_in: The dirty_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_space_not_in: list[int]
        """

        self._dirty_cache_space_not_in = dirty_cache_space_not_in

    @property
    def dirty_cache_usage(self):
        """Gets the dirty_cache_usage of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage

    @dirty_cache_usage.setter
    def dirty_cache_usage(self, dirty_cache_usage):
        """Sets the dirty_cache_usage of this DiskPoolWhereInput.


        :param dirty_cache_usage: The dirty_cache_usage of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage: float
        """

        self._dirty_cache_usage = dirty_cache_usage

    @property
    def dirty_cache_usage_gt(self):
        """Gets the dirty_cache_usage_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage_gt

    @dirty_cache_usage_gt.setter
    def dirty_cache_usage_gt(self, dirty_cache_usage_gt):
        """Sets the dirty_cache_usage_gt of this DiskPoolWhereInput.


        :param dirty_cache_usage_gt: The dirty_cache_usage_gt of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_gt: float
        """

        self._dirty_cache_usage_gt = dirty_cache_usage_gt

    @property
    def dirty_cache_usage_gte(self):
        """Gets the dirty_cache_usage_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage_gte

    @dirty_cache_usage_gte.setter
    def dirty_cache_usage_gte(self, dirty_cache_usage_gte):
        """Sets the dirty_cache_usage_gte of this DiskPoolWhereInput.


        :param dirty_cache_usage_gte: The dirty_cache_usage_gte of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_gte: float
        """

        self._dirty_cache_usage_gte = dirty_cache_usage_gte

    @property
    def dirty_cache_usage_in(self):
        """Gets the dirty_cache_usage_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._dirty_cache_usage_in

    @dirty_cache_usage_in.setter
    def dirty_cache_usage_in(self, dirty_cache_usage_in):
        """Sets the dirty_cache_usage_in of this DiskPoolWhereInput.


        :param dirty_cache_usage_in: The dirty_cache_usage_in of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_in: list[float]
        """

        self._dirty_cache_usage_in = dirty_cache_usage_in

    @property
    def dirty_cache_usage_lt(self):
        """Gets the dirty_cache_usage_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage_lt

    @dirty_cache_usage_lt.setter
    def dirty_cache_usage_lt(self, dirty_cache_usage_lt):
        """Sets the dirty_cache_usage_lt of this DiskPoolWhereInput.


        :param dirty_cache_usage_lt: The dirty_cache_usage_lt of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_lt: float
        """

        self._dirty_cache_usage_lt = dirty_cache_usage_lt

    @property
    def dirty_cache_usage_lte(self):
        """Gets the dirty_cache_usage_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage_lte

    @dirty_cache_usage_lte.setter
    def dirty_cache_usage_lte(self, dirty_cache_usage_lte):
        """Sets the dirty_cache_usage_lte of this DiskPoolWhereInput.


        :param dirty_cache_usage_lte: The dirty_cache_usage_lte of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_lte: float
        """

        self._dirty_cache_usage_lte = dirty_cache_usage_lte

    @property
    def dirty_cache_usage_not(self):
        """Gets the dirty_cache_usage_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._dirty_cache_usage_not

    @dirty_cache_usage_not.setter
    def dirty_cache_usage_not(self, dirty_cache_usage_not):
        """Sets the dirty_cache_usage_not of this DiskPoolWhereInput.


        :param dirty_cache_usage_not: The dirty_cache_usage_not of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_not: float
        """

        self._dirty_cache_usage_not = dirty_cache_usage_not

    @property
    def dirty_cache_usage_not_in(self):
        """Gets the dirty_cache_usage_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The dirty_cache_usage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._dirty_cache_usage_not_in

    @dirty_cache_usage_not_in.setter
    def dirty_cache_usage_not_in(self, dirty_cache_usage_not_in):
        """Sets the dirty_cache_usage_not_in of this DiskPoolWhereInput.


        :param dirty_cache_usage_not_in: The dirty_cache_usage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type dirty_cache_usage_not_in: list[float]
        """

        self._dirty_cache_usage_not_in = dirty_cache_usage_not_in

    @property
    def disks_every(self):
        """Gets the disks_every of this DiskPoolWhereInput.  # noqa: E501


        :return: The disks_every of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_every

    @disks_every.setter
    def disks_every(self, disks_every):
        """Sets the disks_every of this DiskPoolWhereInput.


        :param disks_every: The disks_every of this DiskPoolWhereInput.  # noqa: E501
        :type disks_every: DiskWhereInput
        """

        self._disks_every = disks_every

    @property
    def disks_none(self):
        """Gets the disks_none of this DiskPoolWhereInput.  # noqa: E501


        :return: The disks_none of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_none

    @disks_none.setter
    def disks_none(self, disks_none):
        """Sets the disks_none of this DiskPoolWhereInput.


        :param disks_none: The disks_none of this DiskPoolWhereInput.  # noqa: E501
        :type disks_none: DiskWhereInput
        """

        self._disks_none = disks_none

    @property
    def disks_some(self):
        """Gets the disks_some of this DiskPoolWhereInput.  # noqa: E501


        :return: The disks_some of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_some

    @disks_some.setter
    def disks_some(self, disks_some):
        """Sets the disks_some of this DiskPoolWhereInput.


        :param disks_some: The disks_some of this DiskPoolWhereInput.  # noqa: E501
        :type disks_some: DiskWhereInput
        """

        self._disks_some = disks_some

    @property
    def failure_cache_space(self):
        """Gets the failure_cache_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space

    @failure_cache_space.setter
    def failure_cache_space(self, failure_cache_space):
        """Sets the failure_cache_space of this DiskPoolWhereInput.


        :param failure_cache_space: The failure_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space: int
        """

        self._failure_cache_space = failure_cache_space

    @property
    def failure_cache_space_gt(self):
        """Gets the failure_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space_gt

    @failure_cache_space_gt.setter
    def failure_cache_space_gt(self, failure_cache_space_gt):
        """Sets the failure_cache_space_gt of this DiskPoolWhereInput.


        :param failure_cache_space_gt: The failure_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_gt: int
        """

        self._failure_cache_space_gt = failure_cache_space_gt

    @property
    def failure_cache_space_gte(self):
        """Gets the failure_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space_gte

    @failure_cache_space_gte.setter
    def failure_cache_space_gte(self, failure_cache_space_gte):
        """Sets the failure_cache_space_gte of this DiskPoolWhereInput.


        :param failure_cache_space_gte: The failure_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_gte: int
        """

        self._failure_cache_space_gte = failure_cache_space_gte

    @property
    def failure_cache_space_in(self):
        """Gets the failure_cache_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_cache_space_in

    @failure_cache_space_in.setter
    def failure_cache_space_in(self, failure_cache_space_in):
        """Sets the failure_cache_space_in of this DiskPoolWhereInput.


        :param failure_cache_space_in: The failure_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_in: list[int]
        """

        self._failure_cache_space_in = failure_cache_space_in

    @property
    def failure_cache_space_lt(self):
        """Gets the failure_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space_lt

    @failure_cache_space_lt.setter
    def failure_cache_space_lt(self, failure_cache_space_lt):
        """Sets the failure_cache_space_lt of this DiskPoolWhereInput.


        :param failure_cache_space_lt: The failure_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_lt: int
        """

        self._failure_cache_space_lt = failure_cache_space_lt

    @property
    def failure_cache_space_lte(self):
        """Gets the failure_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space_lte

    @failure_cache_space_lte.setter
    def failure_cache_space_lte(self, failure_cache_space_lte):
        """Sets the failure_cache_space_lte of this DiskPoolWhereInput.


        :param failure_cache_space_lte: The failure_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_lte: int
        """

        self._failure_cache_space_lte = failure_cache_space_lte

    @property
    def failure_cache_space_not(self):
        """Gets the failure_cache_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_cache_space_not

    @failure_cache_space_not.setter
    def failure_cache_space_not(self, failure_cache_space_not):
        """Sets the failure_cache_space_not of this DiskPoolWhereInput.


        :param failure_cache_space_not: The failure_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_not: int
        """

        self._failure_cache_space_not = failure_cache_space_not

    @property
    def failure_cache_space_not_in(self):
        """Gets the failure_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_cache_space_not_in

    @failure_cache_space_not_in.setter
    def failure_cache_space_not_in(self, failure_cache_space_not_in):
        """Sets the failure_cache_space_not_in of this DiskPoolWhereInput.


        :param failure_cache_space_not_in: The failure_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type failure_cache_space_not_in: list[int]
        """

        self._failure_cache_space_not_in = failure_cache_space_not_in

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this DiskPoolWhereInput.


        :param failure_data_space: The failure_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space: int
        """

        self._failure_data_space = failure_data_space

    @property
    def failure_data_space_gt(self):
        """Gets the failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gt

    @failure_data_space_gt.setter
    def failure_data_space_gt(self, failure_data_space_gt):
        """Sets the failure_data_space_gt of this DiskPoolWhereInput.


        :param failure_data_space_gt: The failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_gt: int
        """

        self._failure_data_space_gt = failure_data_space_gt

    @property
    def failure_data_space_gte(self):
        """Gets the failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gte

    @failure_data_space_gte.setter
    def failure_data_space_gte(self, failure_data_space_gte):
        """Sets the failure_data_space_gte of this DiskPoolWhereInput.


        :param failure_data_space_gte: The failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_gte: int
        """

        self._failure_data_space_gte = failure_data_space_gte

    @property
    def failure_data_space_in(self):
        """Gets the failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_in

    @failure_data_space_in.setter
    def failure_data_space_in(self, failure_data_space_in):
        """Sets the failure_data_space_in of this DiskPoolWhereInput.


        :param failure_data_space_in: The failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_in: list[int]
        """

        self._failure_data_space_in = failure_data_space_in

    @property
    def failure_data_space_lt(self):
        """Gets the failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lt

    @failure_data_space_lt.setter
    def failure_data_space_lt(self, failure_data_space_lt):
        """Sets the failure_data_space_lt of this DiskPoolWhereInput.


        :param failure_data_space_lt: The failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_lt: int
        """

        self._failure_data_space_lt = failure_data_space_lt

    @property
    def failure_data_space_lte(self):
        """Gets the failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lte

    @failure_data_space_lte.setter
    def failure_data_space_lte(self, failure_data_space_lte):
        """Sets the failure_data_space_lte of this DiskPoolWhereInput.


        :param failure_data_space_lte: The failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_lte: int
        """

        self._failure_data_space_lte = failure_data_space_lte

    @property
    def failure_data_space_not(self):
        """Gets the failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_not

    @failure_data_space_not.setter
    def failure_data_space_not(self, failure_data_space_not):
        """Sets the failure_data_space_not of this DiskPoolWhereInput.


        :param failure_data_space_not: The failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_not: int
        """

        self._failure_data_space_not = failure_data_space_not

    @property
    def failure_data_space_not_in(self):
        """Gets the failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_not_in

    @failure_data_space_not_in.setter
    def failure_data_space_not_in(self, failure_data_space_not_in):
        """Sets the failure_data_space_not_in of this DiskPoolWhereInput.


        :param failure_data_space_not_in: The failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type failure_data_space_not_in: list[int]
        """

        self._failure_data_space_not_in = failure_data_space_not_in

    @property
    def hdd_disk_count(self):
        """Gets the hdd_disk_count of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count

    @hdd_disk_count.setter
    def hdd_disk_count(self, hdd_disk_count):
        """Sets the hdd_disk_count of this DiskPoolWhereInput.


        :param hdd_disk_count: The hdd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count: int
        """

        self._hdd_disk_count = hdd_disk_count

    @property
    def hdd_disk_count_gt(self):
        """Gets the hdd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_gt

    @hdd_disk_count_gt.setter
    def hdd_disk_count_gt(self, hdd_disk_count_gt):
        """Sets the hdd_disk_count_gt of this DiskPoolWhereInput.


        :param hdd_disk_count_gt: The hdd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_gt: int
        """

        self._hdd_disk_count_gt = hdd_disk_count_gt

    @property
    def hdd_disk_count_gte(self):
        """Gets the hdd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_gte

    @hdd_disk_count_gte.setter
    def hdd_disk_count_gte(self, hdd_disk_count_gte):
        """Sets the hdd_disk_count_gte of this DiskPoolWhereInput.


        :param hdd_disk_count_gte: The hdd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_gte: int
        """

        self._hdd_disk_count_gte = hdd_disk_count_gte

    @property
    def hdd_disk_count_in(self):
        """Gets the hdd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_disk_count_in

    @hdd_disk_count_in.setter
    def hdd_disk_count_in(self, hdd_disk_count_in):
        """Sets the hdd_disk_count_in of this DiskPoolWhereInput.


        :param hdd_disk_count_in: The hdd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_in: list[int]
        """

        self._hdd_disk_count_in = hdd_disk_count_in

    @property
    def hdd_disk_count_lt(self):
        """Gets the hdd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_lt

    @hdd_disk_count_lt.setter
    def hdd_disk_count_lt(self, hdd_disk_count_lt):
        """Sets the hdd_disk_count_lt of this DiskPoolWhereInput.


        :param hdd_disk_count_lt: The hdd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_lt: int
        """

        self._hdd_disk_count_lt = hdd_disk_count_lt

    @property
    def hdd_disk_count_lte(self):
        """Gets the hdd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_lte

    @hdd_disk_count_lte.setter
    def hdd_disk_count_lte(self, hdd_disk_count_lte):
        """Sets the hdd_disk_count_lte of this DiskPoolWhereInput.


        :param hdd_disk_count_lte: The hdd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_lte: int
        """

        self._hdd_disk_count_lte = hdd_disk_count_lte

    @property
    def hdd_disk_count_not(self):
        """Gets the hdd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_not

    @hdd_disk_count_not.setter
    def hdd_disk_count_not(self, hdd_disk_count_not):
        """Sets the hdd_disk_count_not of this DiskPoolWhereInput.


        :param hdd_disk_count_not: The hdd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_not: int
        """

        self._hdd_disk_count_not = hdd_disk_count_not

    @property
    def hdd_disk_count_not_in(self):
        """Gets the hdd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The hdd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_disk_count_not_in

    @hdd_disk_count_not_in.setter
    def hdd_disk_count_not_in(self, hdd_disk_count_not_in):
        """Sets the hdd_disk_count_not_in of this DiskPoolWhereInput.


        :param hdd_disk_count_not_in: The hdd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type hdd_disk_count_not_in: list[int]
        """

        self._hdd_disk_count_not_in = hdd_disk_count_not_in

    @property
    def host(self):
        """Gets the host of this DiskPoolWhereInput.  # noqa: E501


        :return: The host of this DiskPoolWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this DiskPoolWhereInput.


        :param host: The host of this DiskPoolWhereInput.  # noqa: E501
        :type host: HostWhereInput
        """

        self._host = host

    @property
    def id(self):
        """Gets the id of this DiskPoolWhereInput.  # noqa: E501


        :return: The id of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DiskPoolWhereInput.


        :param id: The id of this DiskPoolWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this DiskPoolWhereInput.


        :param id_contains: The id_contains of this DiskPoolWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this DiskPoolWhereInput.


        :param id_ends_with: The id_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this DiskPoolWhereInput.


        :param id_gt: The id_gt of this DiskPoolWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this DiskPoolWhereInput.


        :param id_gte: The id_gte of this DiskPoolWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this DiskPoolWhereInput.


        :param id_in: The id_in of this DiskPoolWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this DiskPoolWhereInput.


        :param id_lt: The id_lt of this DiskPoolWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this DiskPoolWhereInput.


        :param id_lte: The id_lte of this DiskPoolWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this DiskPoolWhereInput.


        :param id_not: The id_not of this DiskPoolWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this DiskPoolWhereInput.


        :param id_not_contains: The id_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this DiskPoolWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this DiskPoolWhereInput.


        :param id_not_in: The id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this DiskPoolWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The id_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this DiskPoolWhereInput.


        :param id_starts_with: The id_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def labels_every(self):
        """Gets the labels_every of this DiskPoolWhereInput.  # noqa: E501


        :return: The labels_every of this DiskPoolWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this DiskPoolWhereInput.


        :param labels_every: The labels_every of this DiskPoolWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this DiskPoolWhereInput.  # noqa: E501


        :return: The labels_none of this DiskPoolWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this DiskPoolWhereInput.


        :param labels_none: The labels_none of this DiskPoolWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this DiskPoolWhereInput.  # noqa: E501


        :return: The labels_some of this DiskPoolWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this DiskPoolWhereInput.


        :param labels_some: The labels_some of this DiskPoolWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_id(self):
        """Gets the local_id of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this DiskPoolWhereInput.


        :param local_id: The local_id of this DiskPoolWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this DiskPoolWhereInput.


        :param local_id_contains: The local_id_contains of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this DiskPoolWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this DiskPoolWhereInput.


        :param local_id_gt: The local_id_gt of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this DiskPoolWhereInput.


        :param local_id_gte: The local_id_gte of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this DiskPoolWhereInput.


        :param local_id_in: The local_id_in of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this DiskPoolWhereInput.


        :param local_id_lt: The local_id_lt of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this DiskPoolWhereInput.


        :param local_id_lte: The local_id_lte of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this DiskPoolWhereInput.


        :param local_id_not: The local_id_not of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this DiskPoolWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this DiskPoolWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this DiskPoolWhereInput.


        :param local_id_not_in: The local_id_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this DiskPoolWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this DiskPoolWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def numa_node(self):
        """Gets the numa_node of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node

    @numa_node.setter
    def numa_node(self, numa_node):
        """Sets the numa_node of this DiskPoolWhereInput.


        :param numa_node: The numa_node of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node: str
        """

        self._numa_node = numa_node

    @property
    def numa_node_contains(self):
        """Gets the numa_node_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_contains

    @numa_node_contains.setter
    def numa_node_contains(self, numa_node_contains):
        """Sets the numa_node_contains of this DiskPoolWhereInput.


        :param numa_node_contains: The numa_node_contains of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_contains: str
        """

        self._numa_node_contains = numa_node_contains

    @property
    def numa_node_ends_with(self):
        """Gets the numa_node_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_ends_with

    @numa_node_ends_with.setter
    def numa_node_ends_with(self, numa_node_ends_with):
        """Sets the numa_node_ends_with of this DiskPoolWhereInput.


        :param numa_node_ends_with: The numa_node_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_ends_with: str
        """

        self._numa_node_ends_with = numa_node_ends_with

    @property
    def numa_node_gt(self):
        """Gets the numa_node_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_gt

    @numa_node_gt.setter
    def numa_node_gt(self, numa_node_gt):
        """Sets the numa_node_gt of this DiskPoolWhereInput.


        :param numa_node_gt: The numa_node_gt of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_gt: str
        """

        self._numa_node_gt = numa_node_gt

    @property
    def numa_node_gte(self):
        """Gets the numa_node_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_gte

    @numa_node_gte.setter
    def numa_node_gte(self, numa_node_gte):
        """Sets the numa_node_gte of this DiskPoolWhereInput.


        :param numa_node_gte: The numa_node_gte of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_gte: str
        """

        self._numa_node_gte = numa_node_gte

    @property
    def numa_node_in(self):
        """Gets the numa_node_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._numa_node_in

    @numa_node_in.setter
    def numa_node_in(self, numa_node_in):
        """Sets the numa_node_in of this DiskPoolWhereInput.


        :param numa_node_in: The numa_node_in of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_in: list[str]
        """

        self._numa_node_in = numa_node_in

    @property
    def numa_node_lt(self):
        """Gets the numa_node_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_lt

    @numa_node_lt.setter
    def numa_node_lt(self, numa_node_lt):
        """Sets the numa_node_lt of this DiskPoolWhereInput.


        :param numa_node_lt: The numa_node_lt of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_lt: str
        """

        self._numa_node_lt = numa_node_lt

    @property
    def numa_node_lte(self):
        """Gets the numa_node_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_lte

    @numa_node_lte.setter
    def numa_node_lte(self, numa_node_lte):
        """Sets the numa_node_lte of this DiskPoolWhereInput.


        :param numa_node_lte: The numa_node_lte of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_lte: str
        """

        self._numa_node_lte = numa_node_lte

    @property
    def numa_node_not(self):
        """Gets the numa_node_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_not

    @numa_node_not.setter
    def numa_node_not(self, numa_node_not):
        """Sets the numa_node_not of this DiskPoolWhereInput.


        :param numa_node_not: The numa_node_not of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_not: str
        """

        self._numa_node_not = numa_node_not

    @property
    def numa_node_not_contains(self):
        """Gets the numa_node_not_contains of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_not_contains

    @numa_node_not_contains.setter
    def numa_node_not_contains(self, numa_node_not_contains):
        """Sets the numa_node_not_contains of this DiskPoolWhereInput.


        :param numa_node_not_contains: The numa_node_not_contains of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_not_contains: str
        """

        self._numa_node_not_contains = numa_node_not_contains

    @property
    def numa_node_not_ends_with(self):
        """Gets the numa_node_not_ends_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_not_ends_with

    @numa_node_not_ends_with.setter
    def numa_node_not_ends_with(self, numa_node_not_ends_with):
        """Sets the numa_node_not_ends_with of this DiskPoolWhereInput.


        :param numa_node_not_ends_with: The numa_node_not_ends_with of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_not_ends_with: str
        """

        self._numa_node_not_ends_with = numa_node_not_ends_with

    @property
    def numa_node_not_in(self):
        """Gets the numa_node_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._numa_node_not_in

    @numa_node_not_in.setter
    def numa_node_not_in(self, numa_node_not_in):
        """Sets the numa_node_not_in of this DiskPoolWhereInput.


        :param numa_node_not_in: The numa_node_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_not_in: list[str]
        """

        self._numa_node_not_in = numa_node_not_in

    @property
    def numa_node_not_starts_with(self):
        """Gets the numa_node_not_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_not_starts_with

    @numa_node_not_starts_with.setter
    def numa_node_not_starts_with(self, numa_node_not_starts_with):
        """Sets the numa_node_not_starts_with of this DiskPoolWhereInput.


        :param numa_node_not_starts_with: The numa_node_not_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_not_starts_with: str
        """

        self._numa_node_not_starts_with = numa_node_not_starts_with

    @property
    def numa_node_starts_with(self):
        """Gets the numa_node_starts_with of this DiskPoolWhereInput.  # noqa: E501


        :return: The numa_node_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._numa_node_starts_with

    @numa_node_starts_with.setter
    def numa_node_starts_with(self, numa_node_starts_with):
        """Sets the numa_node_starts_with of this DiskPoolWhereInput.


        :param numa_node_starts_with: The numa_node_starts_with of this DiskPoolWhereInput.  # noqa: E501
        :type numa_node_starts_with: str
        """

        self._numa_node_starts_with = numa_node_starts_with

    @property
    def nvme_ssd_disk_count(self):
        """Gets the nvme_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count

    @nvme_ssd_disk_count.setter
    def nvme_ssd_disk_count(self, nvme_ssd_disk_count):
        """Sets the nvme_ssd_disk_count of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count: The nvme_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count: int
        """

        self._nvme_ssd_disk_count = nvme_ssd_disk_count

    @property
    def nvme_ssd_disk_count_gt(self):
        """Gets the nvme_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count_gt

    @nvme_ssd_disk_count_gt.setter
    def nvme_ssd_disk_count_gt(self, nvme_ssd_disk_count_gt):
        """Sets the nvme_ssd_disk_count_gt of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_gt: The nvme_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_gt: int
        """

        self._nvme_ssd_disk_count_gt = nvme_ssd_disk_count_gt

    @property
    def nvme_ssd_disk_count_gte(self):
        """Gets the nvme_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count_gte

    @nvme_ssd_disk_count_gte.setter
    def nvme_ssd_disk_count_gte(self, nvme_ssd_disk_count_gte):
        """Sets the nvme_ssd_disk_count_gte of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_gte: The nvme_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_gte: int
        """

        self._nvme_ssd_disk_count_gte = nvme_ssd_disk_count_gte

    @property
    def nvme_ssd_disk_count_in(self):
        """Gets the nvme_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._nvme_ssd_disk_count_in

    @nvme_ssd_disk_count_in.setter
    def nvme_ssd_disk_count_in(self, nvme_ssd_disk_count_in):
        """Sets the nvme_ssd_disk_count_in of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_in: The nvme_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_in: list[int]
        """

        self._nvme_ssd_disk_count_in = nvme_ssd_disk_count_in

    @property
    def nvme_ssd_disk_count_lt(self):
        """Gets the nvme_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count_lt

    @nvme_ssd_disk_count_lt.setter
    def nvme_ssd_disk_count_lt(self, nvme_ssd_disk_count_lt):
        """Sets the nvme_ssd_disk_count_lt of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_lt: The nvme_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_lt: int
        """

        self._nvme_ssd_disk_count_lt = nvme_ssd_disk_count_lt

    @property
    def nvme_ssd_disk_count_lte(self):
        """Gets the nvme_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count_lte

    @nvme_ssd_disk_count_lte.setter
    def nvme_ssd_disk_count_lte(self, nvme_ssd_disk_count_lte):
        """Sets the nvme_ssd_disk_count_lte of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_lte: The nvme_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_lte: int
        """

        self._nvme_ssd_disk_count_lte = nvme_ssd_disk_count_lte

    @property
    def nvme_ssd_disk_count_not(self):
        """Gets the nvme_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nvme_ssd_disk_count_not

    @nvme_ssd_disk_count_not.setter
    def nvme_ssd_disk_count_not(self, nvme_ssd_disk_count_not):
        """Sets the nvme_ssd_disk_count_not of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_not: The nvme_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_not: int
        """

        self._nvme_ssd_disk_count_not = nvme_ssd_disk_count_not

    @property
    def nvme_ssd_disk_count_not_in(self):
        """Gets the nvme_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The nvme_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._nvme_ssd_disk_count_not_in

    @nvme_ssd_disk_count_not_in.setter
    def nvme_ssd_disk_count_not_in(self, nvme_ssd_disk_count_not_in):
        """Sets the nvme_ssd_disk_count_not_in of this DiskPoolWhereInput.


        :param nvme_ssd_disk_count_not_in: The nvme_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type nvme_ssd_disk_count_not_in: list[int]
        """

        self._nvme_ssd_disk_count_not_in = nvme_ssd_disk_count_not_in

    @property
    def perf_allocated_data_space(self):
        """Gets the perf_allocated_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space

    @perf_allocated_data_space.setter
    def perf_allocated_data_space(self, perf_allocated_data_space):
        """Sets the perf_allocated_data_space of this DiskPoolWhereInput.


        :param perf_allocated_data_space: The perf_allocated_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space: int
        """

        self._perf_allocated_data_space = perf_allocated_data_space

    @property
    def perf_allocated_data_space_gt(self):
        """Gets the perf_allocated_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_gt

    @perf_allocated_data_space_gt.setter
    def perf_allocated_data_space_gt(self, perf_allocated_data_space_gt):
        """Sets the perf_allocated_data_space_gt of this DiskPoolWhereInput.


        :param perf_allocated_data_space_gt: The perf_allocated_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_gt: int
        """

        self._perf_allocated_data_space_gt = perf_allocated_data_space_gt

    @property
    def perf_allocated_data_space_gte(self):
        """Gets the perf_allocated_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_gte

    @perf_allocated_data_space_gte.setter
    def perf_allocated_data_space_gte(self, perf_allocated_data_space_gte):
        """Sets the perf_allocated_data_space_gte of this DiskPoolWhereInput.


        :param perf_allocated_data_space_gte: The perf_allocated_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_gte: int
        """

        self._perf_allocated_data_space_gte = perf_allocated_data_space_gte

    @property
    def perf_allocated_data_space_in(self):
        """Gets the perf_allocated_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_allocated_data_space_in

    @perf_allocated_data_space_in.setter
    def perf_allocated_data_space_in(self, perf_allocated_data_space_in):
        """Sets the perf_allocated_data_space_in of this DiskPoolWhereInput.


        :param perf_allocated_data_space_in: The perf_allocated_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_in: list[int]
        """

        self._perf_allocated_data_space_in = perf_allocated_data_space_in

    @property
    def perf_allocated_data_space_lt(self):
        """Gets the perf_allocated_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_lt

    @perf_allocated_data_space_lt.setter
    def perf_allocated_data_space_lt(self, perf_allocated_data_space_lt):
        """Sets the perf_allocated_data_space_lt of this DiskPoolWhereInput.


        :param perf_allocated_data_space_lt: The perf_allocated_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_lt: int
        """

        self._perf_allocated_data_space_lt = perf_allocated_data_space_lt

    @property
    def perf_allocated_data_space_lte(self):
        """Gets the perf_allocated_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_lte

    @perf_allocated_data_space_lte.setter
    def perf_allocated_data_space_lte(self, perf_allocated_data_space_lte):
        """Sets the perf_allocated_data_space_lte of this DiskPoolWhereInput.


        :param perf_allocated_data_space_lte: The perf_allocated_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_lte: int
        """

        self._perf_allocated_data_space_lte = perf_allocated_data_space_lte

    @property
    def perf_allocated_data_space_not(self):
        """Gets the perf_allocated_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_not

    @perf_allocated_data_space_not.setter
    def perf_allocated_data_space_not(self, perf_allocated_data_space_not):
        """Sets the perf_allocated_data_space_not of this DiskPoolWhereInput.


        :param perf_allocated_data_space_not: The perf_allocated_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_not: int
        """

        self._perf_allocated_data_space_not = perf_allocated_data_space_not

    @property
    def perf_allocated_data_space_not_in(self):
        """Gets the perf_allocated_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_allocated_data_space_not_in

    @perf_allocated_data_space_not_in.setter
    def perf_allocated_data_space_not_in(self, perf_allocated_data_space_not_in):
        """Sets the perf_allocated_data_space_not_in of this DiskPoolWhereInput.


        :param perf_allocated_data_space_not_in: The perf_allocated_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_allocated_data_space_not_in: list[int]
        """

        self._perf_allocated_data_space_not_in = perf_allocated_data_space_not_in

    @property
    def perf_failure_data_space(self):
        """Gets the perf_failure_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space

    @perf_failure_data_space.setter
    def perf_failure_data_space(self, perf_failure_data_space):
        """Sets the perf_failure_data_space of this DiskPoolWhereInput.


        :param perf_failure_data_space: The perf_failure_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space: int
        """

        self._perf_failure_data_space = perf_failure_data_space

    @property
    def perf_failure_data_space_gt(self):
        """Gets the perf_failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_gt

    @perf_failure_data_space_gt.setter
    def perf_failure_data_space_gt(self, perf_failure_data_space_gt):
        """Sets the perf_failure_data_space_gt of this DiskPoolWhereInput.


        :param perf_failure_data_space_gt: The perf_failure_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_gt: int
        """

        self._perf_failure_data_space_gt = perf_failure_data_space_gt

    @property
    def perf_failure_data_space_gte(self):
        """Gets the perf_failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_gte

    @perf_failure_data_space_gte.setter
    def perf_failure_data_space_gte(self, perf_failure_data_space_gte):
        """Sets the perf_failure_data_space_gte of this DiskPoolWhereInput.


        :param perf_failure_data_space_gte: The perf_failure_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_gte: int
        """

        self._perf_failure_data_space_gte = perf_failure_data_space_gte

    @property
    def perf_failure_data_space_in(self):
        """Gets the perf_failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_failure_data_space_in

    @perf_failure_data_space_in.setter
    def perf_failure_data_space_in(self, perf_failure_data_space_in):
        """Sets the perf_failure_data_space_in of this DiskPoolWhereInput.


        :param perf_failure_data_space_in: The perf_failure_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_in: list[int]
        """

        self._perf_failure_data_space_in = perf_failure_data_space_in

    @property
    def perf_failure_data_space_lt(self):
        """Gets the perf_failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_lt

    @perf_failure_data_space_lt.setter
    def perf_failure_data_space_lt(self, perf_failure_data_space_lt):
        """Sets the perf_failure_data_space_lt of this DiskPoolWhereInput.


        :param perf_failure_data_space_lt: The perf_failure_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_lt: int
        """

        self._perf_failure_data_space_lt = perf_failure_data_space_lt

    @property
    def perf_failure_data_space_lte(self):
        """Gets the perf_failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_lte

    @perf_failure_data_space_lte.setter
    def perf_failure_data_space_lte(self, perf_failure_data_space_lte):
        """Sets the perf_failure_data_space_lte of this DiskPoolWhereInput.


        :param perf_failure_data_space_lte: The perf_failure_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_lte: int
        """

        self._perf_failure_data_space_lte = perf_failure_data_space_lte

    @property
    def perf_failure_data_space_not(self):
        """Gets the perf_failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_not

    @perf_failure_data_space_not.setter
    def perf_failure_data_space_not(self, perf_failure_data_space_not):
        """Sets the perf_failure_data_space_not of this DiskPoolWhereInput.


        :param perf_failure_data_space_not: The perf_failure_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_not: int
        """

        self._perf_failure_data_space_not = perf_failure_data_space_not

    @property
    def perf_failure_data_space_not_in(self):
        """Gets the perf_failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_failure_data_space_not_in

    @perf_failure_data_space_not_in.setter
    def perf_failure_data_space_not_in(self, perf_failure_data_space_not_in):
        """Sets the perf_failure_data_space_not_in of this DiskPoolWhereInput.


        :param perf_failure_data_space_not_in: The perf_failure_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_failure_data_space_not_in: list[int]
        """

        self._perf_failure_data_space_not_in = perf_failure_data_space_not_in

    @property
    def perf_total_data_capacity(self):
        """Gets the perf_total_data_capacity of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity

    @perf_total_data_capacity.setter
    def perf_total_data_capacity(self, perf_total_data_capacity):
        """Sets the perf_total_data_capacity of this DiskPoolWhereInput.


        :param perf_total_data_capacity: The perf_total_data_capacity of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity: int
        """

        self._perf_total_data_capacity = perf_total_data_capacity

    @property
    def perf_total_data_capacity_gt(self):
        """Gets the perf_total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_gt

    @perf_total_data_capacity_gt.setter
    def perf_total_data_capacity_gt(self, perf_total_data_capacity_gt):
        """Sets the perf_total_data_capacity_gt of this DiskPoolWhereInput.


        :param perf_total_data_capacity_gt: The perf_total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_gt: int
        """

        self._perf_total_data_capacity_gt = perf_total_data_capacity_gt

    @property
    def perf_total_data_capacity_gte(self):
        """Gets the perf_total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_gte

    @perf_total_data_capacity_gte.setter
    def perf_total_data_capacity_gte(self, perf_total_data_capacity_gte):
        """Sets the perf_total_data_capacity_gte of this DiskPoolWhereInput.


        :param perf_total_data_capacity_gte: The perf_total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_gte: int
        """

        self._perf_total_data_capacity_gte = perf_total_data_capacity_gte

    @property
    def perf_total_data_capacity_in(self):
        """Gets the perf_total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_total_data_capacity_in

    @perf_total_data_capacity_in.setter
    def perf_total_data_capacity_in(self, perf_total_data_capacity_in):
        """Sets the perf_total_data_capacity_in of this DiskPoolWhereInput.


        :param perf_total_data_capacity_in: The perf_total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_in: list[int]
        """

        self._perf_total_data_capacity_in = perf_total_data_capacity_in

    @property
    def perf_total_data_capacity_lt(self):
        """Gets the perf_total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_lt

    @perf_total_data_capacity_lt.setter
    def perf_total_data_capacity_lt(self, perf_total_data_capacity_lt):
        """Sets the perf_total_data_capacity_lt of this DiskPoolWhereInput.


        :param perf_total_data_capacity_lt: The perf_total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_lt: int
        """

        self._perf_total_data_capacity_lt = perf_total_data_capacity_lt

    @property
    def perf_total_data_capacity_lte(self):
        """Gets the perf_total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_lte

    @perf_total_data_capacity_lte.setter
    def perf_total_data_capacity_lte(self, perf_total_data_capacity_lte):
        """Sets the perf_total_data_capacity_lte of this DiskPoolWhereInput.


        :param perf_total_data_capacity_lte: The perf_total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_lte: int
        """

        self._perf_total_data_capacity_lte = perf_total_data_capacity_lte

    @property
    def perf_total_data_capacity_not(self):
        """Gets the perf_total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_not

    @perf_total_data_capacity_not.setter
    def perf_total_data_capacity_not(self, perf_total_data_capacity_not):
        """Sets the perf_total_data_capacity_not of this DiskPoolWhereInput.


        :param perf_total_data_capacity_not: The perf_total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_not: int
        """

        self._perf_total_data_capacity_not = perf_total_data_capacity_not

    @property
    def perf_total_data_capacity_not_in(self):
        """Gets the perf_total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_total_data_capacity_not_in

    @perf_total_data_capacity_not_in.setter
    def perf_total_data_capacity_not_in(self, perf_total_data_capacity_not_in):
        """Sets the perf_total_data_capacity_not_in of this DiskPoolWhereInput.


        :param perf_total_data_capacity_not_in: The perf_total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_total_data_capacity_not_in: list[int]
        """

        self._perf_total_data_capacity_not_in = perf_total_data_capacity_not_in

    @property
    def perf_used_data_space(self):
        """Gets the perf_used_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space

    @perf_used_data_space.setter
    def perf_used_data_space(self, perf_used_data_space):
        """Sets the perf_used_data_space of this DiskPoolWhereInput.


        :param perf_used_data_space: The perf_used_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space: int
        """

        self._perf_used_data_space = perf_used_data_space

    @property
    def perf_used_data_space_gt(self):
        """Gets the perf_used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_gt

    @perf_used_data_space_gt.setter
    def perf_used_data_space_gt(self, perf_used_data_space_gt):
        """Sets the perf_used_data_space_gt of this DiskPoolWhereInput.


        :param perf_used_data_space_gt: The perf_used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_gt: int
        """

        self._perf_used_data_space_gt = perf_used_data_space_gt

    @property
    def perf_used_data_space_gte(self):
        """Gets the perf_used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_gte

    @perf_used_data_space_gte.setter
    def perf_used_data_space_gte(self, perf_used_data_space_gte):
        """Sets the perf_used_data_space_gte of this DiskPoolWhereInput.


        :param perf_used_data_space_gte: The perf_used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_gte: int
        """

        self._perf_used_data_space_gte = perf_used_data_space_gte

    @property
    def perf_used_data_space_in(self):
        """Gets the perf_used_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_used_data_space_in

    @perf_used_data_space_in.setter
    def perf_used_data_space_in(self, perf_used_data_space_in):
        """Sets the perf_used_data_space_in of this DiskPoolWhereInput.


        :param perf_used_data_space_in: The perf_used_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_in: list[int]
        """

        self._perf_used_data_space_in = perf_used_data_space_in

    @property
    def perf_used_data_space_lt(self):
        """Gets the perf_used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_lt

    @perf_used_data_space_lt.setter
    def perf_used_data_space_lt(self, perf_used_data_space_lt):
        """Sets the perf_used_data_space_lt of this DiskPoolWhereInput.


        :param perf_used_data_space_lt: The perf_used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_lt: int
        """

        self._perf_used_data_space_lt = perf_used_data_space_lt

    @property
    def perf_used_data_space_lte(self):
        """Gets the perf_used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_lte

    @perf_used_data_space_lte.setter
    def perf_used_data_space_lte(self, perf_used_data_space_lte):
        """Sets the perf_used_data_space_lte of this DiskPoolWhereInput.


        :param perf_used_data_space_lte: The perf_used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_lte: int
        """

        self._perf_used_data_space_lte = perf_used_data_space_lte

    @property
    def perf_used_data_space_not(self):
        """Gets the perf_used_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_not

    @perf_used_data_space_not.setter
    def perf_used_data_space_not(self, perf_used_data_space_not):
        """Sets the perf_used_data_space_not of this DiskPoolWhereInput.


        :param perf_used_data_space_not: The perf_used_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_not: int
        """

        self._perf_used_data_space_not = perf_used_data_space_not

    @property
    def perf_used_data_space_not_in(self):
        """Gets the perf_used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_used_data_space_not_in

    @perf_used_data_space_not_in.setter
    def perf_used_data_space_not_in(self, perf_used_data_space_not_in):
        """Sets the perf_used_data_space_not_in of this DiskPoolWhereInput.


        :param perf_used_data_space_not_in: The perf_used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_used_data_space_not_in: list[int]
        """

        self._perf_used_data_space_not_in = perf_used_data_space_not_in

    @property
    def perf_valid_data_space(self):
        """Gets the perf_valid_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space

    @perf_valid_data_space.setter
    def perf_valid_data_space(self, perf_valid_data_space):
        """Sets the perf_valid_data_space of this DiskPoolWhereInput.


        :param perf_valid_data_space: The perf_valid_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space: int
        """

        self._perf_valid_data_space = perf_valid_data_space

    @property
    def perf_valid_data_space_gt(self):
        """Gets the perf_valid_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_gt

    @perf_valid_data_space_gt.setter
    def perf_valid_data_space_gt(self, perf_valid_data_space_gt):
        """Sets the perf_valid_data_space_gt of this DiskPoolWhereInput.


        :param perf_valid_data_space_gt: The perf_valid_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_gt: int
        """

        self._perf_valid_data_space_gt = perf_valid_data_space_gt

    @property
    def perf_valid_data_space_gte(self):
        """Gets the perf_valid_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_gte

    @perf_valid_data_space_gte.setter
    def perf_valid_data_space_gte(self, perf_valid_data_space_gte):
        """Sets the perf_valid_data_space_gte of this DiskPoolWhereInput.


        :param perf_valid_data_space_gte: The perf_valid_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_gte: int
        """

        self._perf_valid_data_space_gte = perf_valid_data_space_gte

    @property
    def perf_valid_data_space_in(self):
        """Gets the perf_valid_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_valid_data_space_in

    @perf_valid_data_space_in.setter
    def perf_valid_data_space_in(self, perf_valid_data_space_in):
        """Sets the perf_valid_data_space_in of this DiskPoolWhereInput.


        :param perf_valid_data_space_in: The perf_valid_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_in: list[int]
        """

        self._perf_valid_data_space_in = perf_valid_data_space_in

    @property
    def perf_valid_data_space_lt(self):
        """Gets the perf_valid_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_lt

    @perf_valid_data_space_lt.setter
    def perf_valid_data_space_lt(self, perf_valid_data_space_lt):
        """Sets the perf_valid_data_space_lt of this DiskPoolWhereInput.


        :param perf_valid_data_space_lt: The perf_valid_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_lt: int
        """

        self._perf_valid_data_space_lt = perf_valid_data_space_lt

    @property
    def perf_valid_data_space_lte(self):
        """Gets the perf_valid_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_lte

    @perf_valid_data_space_lte.setter
    def perf_valid_data_space_lte(self, perf_valid_data_space_lte):
        """Sets the perf_valid_data_space_lte of this DiskPoolWhereInput.


        :param perf_valid_data_space_lte: The perf_valid_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_lte: int
        """

        self._perf_valid_data_space_lte = perf_valid_data_space_lte

    @property
    def perf_valid_data_space_not(self):
        """Gets the perf_valid_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_not

    @perf_valid_data_space_not.setter
    def perf_valid_data_space_not(self, perf_valid_data_space_not):
        """Sets the perf_valid_data_space_not of this DiskPoolWhereInput.


        :param perf_valid_data_space_not: The perf_valid_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_not: int
        """

        self._perf_valid_data_space_not = perf_valid_data_space_not

    @property
    def perf_valid_data_space_not_in(self):
        """Gets the perf_valid_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_valid_data_space_not_in

    @perf_valid_data_space_not_in.setter
    def perf_valid_data_space_not_in(self, perf_valid_data_space_not_in):
        """Sets the perf_valid_data_space_not_in of this DiskPoolWhereInput.


        :param perf_valid_data_space_not_in: The perf_valid_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type perf_valid_data_space_not_in: list[int]
        """

        self._perf_valid_data_space_not_in = perf_valid_data_space_not_in

    @property
    def planned_prioritized_space(self):
        """Gets the planned_prioritized_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space

    @planned_prioritized_space.setter
    def planned_prioritized_space(self, planned_prioritized_space):
        """Sets the planned_prioritized_space of this DiskPoolWhereInput.


        :param planned_prioritized_space: The planned_prioritized_space of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space: int
        """

        self._planned_prioritized_space = planned_prioritized_space

    @property
    def planned_prioritized_space_gt(self):
        """Gets the planned_prioritized_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_gt

    @planned_prioritized_space_gt.setter
    def planned_prioritized_space_gt(self, planned_prioritized_space_gt):
        """Sets the planned_prioritized_space_gt of this DiskPoolWhereInput.


        :param planned_prioritized_space_gt: The planned_prioritized_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_gt: int
        """

        self._planned_prioritized_space_gt = planned_prioritized_space_gt

    @property
    def planned_prioritized_space_gte(self):
        """Gets the planned_prioritized_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_gte

    @planned_prioritized_space_gte.setter
    def planned_prioritized_space_gte(self, planned_prioritized_space_gte):
        """Sets the planned_prioritized_space_gte of this DiskPoolWhereInput.


        :param planned_prioritized_space_gte: The planned_prioritized_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_gte: int
        """

        self._planned_prioritized_space_gte = planned_prioritized_space_gte

    @property
    def planned_prioritized_space_in(self):
        """Gets the planned_prioritized_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._planned_prioritized_space_in

    @planned_prioritized_space_in.setter
    def planned_prioritized_space_in(self, planned_prioritized_space_in):
        """Sets the planned_prioritized_space_in of this DiskPoolWhereInput.


        :param planned_prioritized_space_in: The planned_prioritized_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_in: list[int]
        """

        self._planned_prioritized_space_in = planned_prioritized_space_in

    @property
    def planned_prioritized_space_lt(self):
        """Gets the planned_prioritized_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_lt

    @planned_prioritized_space_lt.setter
    def planned_prioritized_space_lt(self, planned_prioritized_space_lt):
        """Sets the planned_prioritized_space_lt of this DiskPoolWhereInput.


        :param planned_prioritized_space_lt: The planned_prioritized_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_lt: int
        """

        self._planned_prioritized_space_lt = planned_prioritized_space_lt

    @property
    def planned_prioritized_space_lte(self):
        """Gets the planned_prioritized_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_lte

    @planned_prioritized_space_lte.setter
    def planned_prioritized_space_lte(self, planned_prioritized_space_lte):
        """Sets the planned_prioritized_space_lte of this DiskPoolWhereInput.


        :param planned_prioritized_space_lte: The planned_prioritized_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_lte: int
        """

        self._planned_prioritized_space_lte = planned_prioritized_space_lte

    @property
    def planned_prioritized_space_not(self):
        """Gets the planned_prioritized_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_not

    @planned_prioritized_space_not.setter
    def planned_prioritized_space_not(self, planned_prioritized_space_not):
        """Sets the planned_prioritized_space_not of this DiskPoolWhereInput.


        :param planned_prioritized_space_not: The planned_prioritized_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_not: int
        """

        self._planned_prioritized_space_not = planned_prioritized_space_not

    @property
    def planned_prioritized_space_not_in(self):
        """Gets the planned_prioritized_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._planned_prioritized_space_not_in

    @planned_prioritized_space_not_in.setter
    def planned_prioritized_space_not_in(self, planned_prioritized_space_not_in):
        """Sets the planned_prioritized_space_not_in of this DiskPoolWhereInput.


        :param planned_prioritized_space_not_in: The planned_prioritized_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type planned_prioritized_space_not_in: list[int]
        """

        self._planned_prioritized_space_not_in = planned_prioritized_space_not_in

    @property
    def prio_space_percentage(self):
        """Gets the prio_space_percentage of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage

    @prio_space_percentage.setter
    def prio_space_percentage(self, prio_space_percentage):
        """Sets the prio_space_percentage of this DiskPoolWhereInput.


        :param prio_space_percentage: The prio_space_percentage of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage: float
        """

        self._prio_space_percentage = prio_space_percentage

    @property
    def prio_space_percentage_gt(self):
        """Gets the prio_space_percentage_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_gt

    @prio_space_percentage_gt.setter
    def prio_space_percentage_gt(self, prio_space_percentage_gt):
        """Sets the prio_space_percentage_gt of this DiskPoolWhereInput.


        :param prio_space_percentage_gt: The prio_space_percentage_gt of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_gt: float
        """

        self._prio_space_percentage_gt = prio_space_percentage_gt

    @property
    def prio_space_percentage_gte(self):
        """Gets the prio_space_percentage_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_gte

    @prio_space_percentage_gte.setter
    def prio_space_percentage_gte(self, prio_space_percentage_gte):
        """Sets the prio_space_percentage_gte of this DiskPoolWhereInput.


        :param prio_space_percentage_gte: The prio_space_percentage_gte of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_gte: float
        """

        self._prio_space_percentage_gte = prio_space_percentage_gte

    @property
    def prio_space_percentage_in(self):
        """Gets the prio_space_percentage_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._prio_space_percentage_in

    @prio_space_percentage_in.setter
    def prio_space_percentage_in(self, prio_space_percentage_in):
        """Sets the prio_space_percentage_in of this DiskPoolWhereInput.


        :param prio_space_percentage_in: The prio_space_percentage_in of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_in: list[float]
        """

        self._prio_space_percentage_in = prio_space_percentage_in

    @property
    def prio_space_percentage_lt(self):
        """Gets the prio_space_percentage_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_lt

    @prio_space_percentage_lt.setter
    def prio_space_percentage_lt(self, prio_space_percentage_lt):
        """Sets the prio_space_percentage_lt of this DiskPoolWhereInput.


        :param prio_space_percentage_lt: The prio_space_percentage_lt of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_lt: float
        """

        self._prio_space_percentage_lt = prio_space_percentage_lt

    @property
    def prio_space_percentage_lte(self):
        """Gets the prio_space_percentage_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_lte

    @prio_space_percentage_lte.setter
    def prio_space_percentage_lte(self, prio_space_percentage_lte):
        """Sets the prio_space_percentage_lte of this DiskPoolWhereInput.


        :param prio_space_percentage_lte: The prio_space_percentage_lte of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_lte: float
        """

        self._prio_space_percentage_lte = prio_space_percentage_lte

    @property
    def prio_space_percentage_not(self):
        """Gets the prio_space_percentage_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_not

    @prio_space_percentage_not.setter
    def prio_space_percentage_not(self, prio_space_percentage_not):
        """Sets the prio_space_percentage_not of this DiskPoolWhereInput.


        :param prio_space_percentage_not: The prio_space_percentage_not of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_not: float
        """

        self._prio_space_percentage_not = prio_space_percentage_not

    @property
    def prio_space_percentage_not_in(self):
        """Gets the prio_space_percentage_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The prio_space_percentage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._prio_space_percentage_not_in

    @prio_space_percentage_not_in.setter
    def prio_space_percentage_not_in(self, prio_space_percentage_not_in):
        """Sets the prio_space_percentage_not_in of this DiskPoolWhereInput.


        :param prio_space_percentage_not_in: The prio_space_percentage_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type prio_space_percentage_not_in: list[float]
        """

        self._prio_space_percentage_not_in = prio_space_percentage_not_in

    @property
    def sata_or_sas_ssd_disk_count(self):
        """Gets the sata_or_sas_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count

    @sata_or_sas_ssd_disk_count.setter
    def sata_or_sas_ssd_disk_count(self, sata_or_sas_ssd_disk_count):
        """Sets the sata_or_sas_ssd_disk_count of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count: The sata_or_sas_ssd_disk_count of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count: int
        """

        self._sata_or_sas_ssd_disk_count = sata_or_sas_ssd_disk_count

    @property
    def sata_or_sas_ssd_disk_count_gt(self):
        """Gets the sata_or_sas_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count_gt

    @sata_or_sas_ssd_disk_count_gt.setter
    def sata_or_sas_ssd_disk_count_gt(self, sata_or_sas_ssd_disk_count_gt):
        """Sets the sata_or_sas_ssd_disk_count_gt of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_gt: The sata_or_sas_ssd_disk_count_gt of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_gt: int
        """

        self._sata_or_sas_ssd_disk_count_gt = sata_or_sas_ssd_disk_count_gt

    @property
    def sata_or_sas_ssd_disk_count_gte(self):
        """Gets the sata_or_sas_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count_gte

    @sata_or_sas_ssd_disk_count_gte.setter
    def sata_or_sas_ssd_disk_count_gte(self, sata_or_sas_ssd_disk_count_gte):
        """Sets the sata_or_sas_ssd_disk_count_gte of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_gte: The sata_or_sas_ssd_disk_count_gte of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_gte: int
        """

        self._sata_or_sas_ssd_disk_count_gte = sata_or_sas_ssd_disk_count_gte

    @property
    def sata_or_sas_ssd_disk_count_in(self):
        """Gets the sata_or_sas_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._sata_or_sas_ssd_disk_count_in

    @sata_or_sas_ssd_disk_count_in.setter
    def sata_or_sas_ssd_disk_count_in(self, sata_or_sas_ssd_disk_count_in):
        """Sets the sata_or_sas_ssd_disk_count_in of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_in: The sata_or_sas_ssd_disk_count_in of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_in: list[int]
        """

        self._sata_or_sas_ssd_disk_count_in = sata_or_sas_ssd_disk_count_in

    @property
    def sata_or_sas_ssd_disk_count_lt(self):
        """Gets the sata_or_sas_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count_lt

    @sata_or_sas_ssd_disk_count_lt.setter
    def sata_or_sas_ssd_disk_count_lt(self, sata_or_sas_ssd_disk_count_lt):
        """Sets the sata_or_sas_ssd_disk_count_lt of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_lt: The sata_or_sas_ssd_disk_count_lt of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_lt: int
        """

        self._sata_or_sas_ssd_disk_count_lt = sata_or_sas_ssd_disk_count_lt

    @property
    def sata_or_sas_ssd_disk_count_lte(self):
        """Gets the sata_or_sas_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count_lte

    @sata_or_sas_ssd_disk_count_lte.setter
    def sata_or_sas_ssd_disk_count_lte(self, sata_or_sas_ssd_disk_count_lte):
        """Sets the sata_or_sas_ssd_disk_count_lte of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_lte: The sata_or_sas_ssd_disk_count_lte of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_lte: int
        """

        self._sata_or_sas_ssd_disk_count_lte = sata_or_sas_ssd_disk_count_lte

    @property
    def sata_or_sas_ssd_disk_count_not(self):
        """Gets the sata_or_sas_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._sata_or_sas_ssd_disk_count_not

    @sata_or_sas_ssd_disk_count_not.setter
    def sata_or_sas_ssd_disk_count_not(self, sata_or_sas_ssd_disk_count_not):
        """Sets the sata_or_sas_ssd_disk_count_not of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_not: The sata_or_sas_ssd_disk_count_not of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_not: int
        """

        self._sata_or_sas_ssd_disk_count_not = sata_or_sas_ssd_disk_count_not

    @property
    def sata_or_sas_ssd_disk_count_not_in(self):
        """Gets the sata_or_sas_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The sata_or_sas_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._sata_or_sas_ssd_disk_count_not_in

    @sata_or_sas_ssd_disk_count_not_in.setter
    def sata_or_sas_ssd_disk_count_not_in(self, sata_or_sas_ssd_disk_count_not_in):
        """Sets the sata_or_sas_ssd_disk_count_not_in of this DiskPoolWhereInput.


        :param sata_or_sas_ssd_disk_count_not_in: The sata_or_sas_ssd_disk_count_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type sata_or_sas_ssd_disk_count_not_in: list[int]
        """

        self._sata_or_sas_ssd_disk_count_not_in = sata_or_sas_ssd_disk_count_not_in

    @property
    def status(self):
        """Gets the status of this DiskPoolWhereInput.  # noqa: E501


        :return: The status of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskPoolStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DiskPoolWhereInput.


        :param status: The status of this DiskPoolWhereInput.  # noqa: E501
        :type status: DiskPoolStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The status_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this DiskPoolWhereInput.


        :param status_in: The status_in of this DiskPoolWhereInput.  # noqa: E501
        :type status_in: list[DiskPoolStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The status_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskPoolStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this DiskPoolWhereInput.


        :param status_not: The status_not of this DiskPoolWhereInput.  # noqa: E501
        :type status_not: DiskPoolStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The status_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this DiskPoolWhereInput.


        :param status_not_in: The status_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type status_not_in: list[DiskPoolStatus]
        """

        self._status_not_in = status_not_in

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this DiskPoolWhereInput.


        :param total_cache_capacity: The total_cache_capacity of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity: int
        """

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_cache_capacity_gt(self):
        """Gets the total_cache_capacity_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gt

    @total_cache_capacity_gt.setter
    def total_cache_capacity_gt(self, total_cache_capacity_gt):
        """Sets the total_cache_capacity_gt of this DiskPoolWhereInput.


        :param total_cache_capacity_gt: The total_cache_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_gt: int
        """

        self._total_cache_capacity_gt = total_cache_capacity_gt

    @property
    def total_cache_capacity_gte(self):
        """Gets the total_cache_capacity_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gte

    @total_cache_capacity_gte.setter
    def total_cache_capacity_gte(self, total_cache_capacity_gte):
        """Sets the total_cache_capacity_gte of this DiskPoolWhereInput.


        :param total_cache_capacity_gte: The total_cache_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_gte: int
        """

        self._total_cache_capacity_gte = total_cache_capacity_gte

    @property
    def total_cache_capacity_in(self):
        """Gets the total_cache_capacity_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_in

    @total_cache_capacity_in.setter
    def total_cache_capacity_in(self, total_cache_capacity_in):
        """Sets the total_cache_capacity_in of this DiskPoolWhereInput.


        :param total_cache_capacity_in: The total_cache_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_in: list[int]
        """

        self._total_cache_capacity_in = total_cache_capacity_in

    @property
    def total_cache_capacity_lt(self):
        """Gets the total_cache_capacity_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lt

    @total_cache_capacity_lt.setter
    def total_cache_capacity_lt(self, total_cache_capacity_lt):
        """Sets the total_cache_capacity_lt of this DiskPoolWhereInput.


        :param total_cache_capacity_lt: The total_cache_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_lt: int
        """

        self._total_cache_capacity_lt = total_cache_capacity_lt

    @property
    def total_cache_capacity_lte(self):
        """Gets the total_cache_capacity_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lte

    @total_cache_capacity_lte.setter
    def total_cache_capacity_lte(self, total_cache_capacity_lte):
        """Sets the total_cache_capacity_lte of this DiskPoolWhereInput.


        :param total_cache_capacity_lte: The total_cache_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_lte: int
        """

        self._total_cache_capacity_lte = total_cache_capacity_lte

    @property
    def total_cache_capacity_not(self):
        """Gets the total_cache_capacity_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_not

    @total_cache_capacity_not.setter
    def total_cache_capacity_not(self, total_cache_capacity_not):
        """Sets the total_cache_capacity_not of this DiskPoolWhereInput.


        :param total_cache_capacity_not: The total_cache_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_not: int
        """

        self._total_cache_capacity_not = total_cache_capacity_not

    @property
    def total_cache_capacity_not_in(self):
        """Gets the total_cache_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_not_in

    @total_cache_capacity_not_in.setter
    def total_cache_capacity_not_in(self, total_cache_capacity_not_in):
        """Sets the total_cache_capacity_not_in of this DiskPoolWhereInput.


        :param total_cache_capacity_not_in: The total_cache_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type total_cache_capacity_not_in: list[int]
        """

        self._total_cache_capacity_not_in = total_cache_capacity_not_in

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this DiskPoolWhereInput.


        :param total_data_capacity: The total_data_capacity of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity: int
        """

        self._total_data_capacity = total_data_capacity

    @property
    def total_data_capacity_gt(self):
        """Gets the total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gt

    @total_data_capacity_gt.setter
    def total_data_capacity_gt(self, total_data_capacity_gt):
        """Sets the total_data_capacity_gt of this DiskPoolWhereInput.


        :param total_data_capacity_gt: The total_data_capacity_gt of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_gt: int
        """

        self._total_data_capacity_gt = total_data_capacity_gt

    @property
    def total_data_capacity_gte(self):
        """Gets the total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gte

    @total_data_capacity_gte.setter
    def total_data_capacity_gte(self, total_data_capacity_gte):
        """Sets the total_data_capacity_gte of this DiskPoolWhereInput.


        :param total_data_capacity_gte: The total_data_capacity_gte of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_gte: int
        """

        self._total_data_capacity_gte = total_data_capacity_gte

    @property
    def total_data_capacity_in(self):
        """Gets the total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_in

    @total_data_capacity_in.setter
    def total_data_capacity_in(self, total_data_capacity_in):
        """Sets the total_data_capacity_in of this DiskPoolWhereInput.


        :param total_data_capacity_in: The total_data_capacity_in of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_in: list[int]
        """

        self._total_data_capacity_in = total_data_capacity_in

    @property
    def total_data_capacity_lt(self):
        """Gets the total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lt

    @total_data_capacity_lt.setter
    def total_data_capacity_lt(self, total_data_capacity_lt):
        """Sets the total_data_capacity_lt of this DiskPoolWhereInput.


        :param total_data_capacity_lt: The total_data_capacity_lt of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_lt: int
        """

        self._total_data_capacity_lt = total_data_capacity_lt

    @property
    def total_data_capacity_lte(self):
        """Gets the total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lte

    @total_data_capacity_lte.setter
    def total_data_capacity_lte(self, total_data_capacity_lte):
        """Sets the total_data_capacity_lte of this DiskPoolWhereInput.


        :param total_data_capacity_lte: The total_data_capacity_lte of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_lte: int
        """

        self._total_data_capacity_lte = total_data_capacity_lte

    @property
    def total_data_capacity_not(self):
        """Gets the total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_not

    @total_data_capacity_not.setter
    def total_data_capacity_not(self, total_data_capacity_not):
        """Sets the total_data_capacity_not of this DiskPoolWhereInput.


        :param total_data_capacity_not: The total_data_capacity_not of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_not: int
        """

        self._total_data_capacity_not = total_data_capacity_not

    @property
    def total_data_capacity_not_in(self):
        """Gets the total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_not_in

    @total_data_capacity_not_in.setter
    def total_data_capacity_not_in(self, total_data_capacity_not_in):
        """Sets the total_data_capacity_not_in of this DiskPoolWhereInput.


        :param total_data_capacity_not_in: The total_data_capacity_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type total_data_capacity_not_in: list[int]
        """

        self._total_data_capacity_not_in = total_data_capacity_not_in

    @property
    def use_state(self):
        """Gets the use_state of this DiskPoolWhereInput.  # noqa: E501


        :return: The use_state of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskPoolUseState
        """
        return self._use_state

    @use_state.setter
    def use_state(self, use_state):
        """Sets the use_state of this DiskPoolWhereInput.


        :param use_state: The use_state of this DiskPoolWhereInput.  # noqa: E501
        :type use_state: DiskPoolUseState
        """

        self._use_state = use_state

    @property
    def use_state_in(self):
        """Gets the use_state_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The use_state_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolUseState]
        """
        return self._use_state_in

    @use_state_in.setter
    def use_state_in(self, use_state_in):
        """Sets the use_state_in of this DiskPoolWhereInput.


        :param use_state_in: The use_state_in of this DiskPoolWhereInput.  # noqa: E501
        :type use_state_in: list[DiskPoolUseState]
        """

        self._use_state_in = use_state_in

    @property
    def use_state_not(self):
        """Gets the use_state_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The use_state_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: DiskPoolUseState
        """
        return self._use_state_not

    @use_state_not.setter
    def use_state_not(self, use_state_not):
        """Sets the use_state_not of this DiskPoolWhereInput.


        :param use_state_not: The use_state_not of this DiskPoolWhereInput.  # noqa: E501
        :type use_state_not: DiskPoolUseState
        """

        self._use_state_not = use_state_not

    @property
    def use_state_not_in(self):
        """Gets the use_state_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The use_state_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[DiskPoolUseState]
        """
        return self._use_state_not_in

    @use_state_not_in.setter
    def use_state_not_in(self, use_state_not_in):
        """Sets the use_state_not_in of this DiskPoolWhereInput.


        :param use_state_not_in: The use_state_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type use_state_not_in: list[DiskPoolUseState]
        """

        self._use_state_not_in = use_state_not_in

    @property
    def used_cache_space(self):
        """Gets the used_cache_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space

    @used_cache_space.setter
    def used_cache_space(self, used_cache_space):
        """Sets the used_cache_space of this DiskPoolWhereInput.


        :param used_cache_space: The used_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space: int
        """

        self._used_cache_space = used_cache_space

    @property
    def used_cache_space_gt(self):
        """Gets the used_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_gt

    @used_cache_space_gt.setter
    def used_cache_space_gt(self, used_cache_space_gt):
        """Sets the used_cache_space_gt of this DiskPoolWhereInput.


        :param used_cache_space_gt: The used_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_gt: int
        """

        self._used_cache_space_gt = used_cache_space_gt

    @property
    def used_cache_space_gte(self):
        """Gets the used_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_gte

    @used_cache_space_gte.setter
    def used_cache_space_gte(self, used_cache_space_gte):
        """Sets the used_cache_space_gte of this DiskPoolWhereInput.


        :param used_cache_space_gte: The used_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_gte: int
        """

        self._used_cache_space_gte = used_cache_space_gte

    @property
    def used_cache_space_in(self):
        """Gets the used_cache_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_cache_space_in

    @used_cache_space_in.setter
    def used_cache_space_in(self, used_cache_space_in):
        """Sets the used_cache_space_in of this DiskPoolWhereInput.


        :param used_cache_space_in: The used_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_in: list[int]
        """

        self._used_cache_space_in = used_cache_space_in

    @property
    def used_cache_space_lt(self):
        """Gets the used_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_lt

    @used_cache_space_lt.setter
    def used_cache_space_lt(self, used_cache_space_lt):
        """Sets the used_cache_space_lt of this DiskPoolWhereInput.


        :param used_cache_space_lt: The used_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_lt: int
        """

        self._used_cache_space_lt = used_cache_space_lt

    @property
    def used_cache_space_lte(self):
        """Gets the used_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_lte

    @used_cache_space_lte.setter
    def used_cache_space_lte(self, used_cache_space_lte):
        """Sets the used_cache_space_lte of this DiskPoolWhereInput.


        :param used_cache_space_lte: The used_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_lte: int
        """

        self._used_cache_space_lte = used_cache_space_lte

    @property
    def used_cache_space_not(self):
        """Gets the used_cache_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_not

    @used_cache_space_not.setter
    def used_cache_space_not(self, used_cache_space_not):
        """Sets the used_cache_space_not of this DiskPoolWhereInput.


        :param used_cache_space_not: The used_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_not: int
        """

        self._used_cache_space_not = used_cache_space_not

    @property
    def used_cache_space_not_in(self):
        """Gets the used_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_cache_space_not_in

    @used_cache_space_not_in.setter
    def used_cache_space_not_in(self, used_cache_space_not_in):
        """Sets the used_cache_space_not_in of this DiskPoolWhereInput.


        :param used_cache_space_not_in: The used_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type used_cache_space_not_in: list[int]
        """

        self._used_cache_space_not_in = used_cache_space_not_in

    @property
    def used_data_space(self):
        """Gets the used_data_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this DiskPoolWhereInput.


        :param used_data_space: The used_data_space of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space: int
        """

        self._used_data_space = used_data_space

    @property
    def used_data_space_gt(self):
        """Gets the used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gt

    @used_data_space_gt.setter
    def used_data_space_gt(self, used_data_space_gt):
        """Sets the used_data_space_gt of this DiskPoolWhereInput.


        :param used_data_space_gt: The used_data_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_gt: int
        """

        self._used_data_space_gt = used_data_space_gt

    @property
    def used_data_space_gte(self):
        """Gets the used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gte

    @used_data_space_gte.setter
    def used_data_space_gte(self, used_data_space_gte):
        """Sets the used_data_space_gte of this DiskPoolWhereInput.


        :param used_data_space_gte: The used_data_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_gte: int
        """

        self._used_data_space_gte = used_data_space_gte

    @property
    def used_data_space_in(self):
        """Gets the used_data_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_in

    @used_data_space_in.setter
    def used_data_space_in(self, used_data_space_in):
        """Sets the used_data_space_in of this DiskPoolWhereInput.


        :param used_data_space_in: The used_data_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_in: list[int]
        """

        self._used_data_space_in = used_data_space_in

    @property
    def used_data_space_lt(self):
        """Gets the used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lt

    @used_data_space_lt.setter
    def used_data_space_lt(self, used_data_space_lt):
        """Sets the used_data_space_lt of this DiskPoolWhereInput.


        :param used_data_space_lt: The used_data_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_lt: int
        """

        self._used_data_space_lt = used_data_space_lt

    @property
    def used_data_space_lte(self):
        """Gets the used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lte

    @used_data_space_lte.setter
    def used_data_space_lte(self, used_data_space_lte):
        """Sets the used_data_space_lte of this DiskPoolWhereInput.


        :param used_data_space_lte: The used_data_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_lte: int
        """

        self._used_data_space_lte = used_data_space_lte

    @property
    def used_data_space_not(self):
        """Gets the used_data_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_not

    @used_data_space_not.setter
    def used_data_space_not(self, used_data_space_not):
        """Sets the used_data_space_not of this DiskPoolWhereInput.


        :param used_data_space_not: The used_data_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_not: int
        """

        self._used_data_space_not = used_data_space_not

    @property
    def used_data_space_not_in(self):
        """Gets the used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_not_in

    @used_data_space_not_in.setter
    def used_data_space_not_in(self, used_data_space_not_in):
        """Sets the used_data_space_not_in of this DiskPoolWhereInput.


        :param used_data_space_not_in: The used_data_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type used_data_space_not_in: list[int]
        """

        self._used_data_space_not_in = used_data_space_not_in

    @property
    def valid_cache_space(self):
        """Gets the valid_cache_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space

    @valid_cache_space.setter
    def valid_cache_space(self, valid_cache_space):
        """Sets the valid_cache_space of this DiskPoolWhereInput.


        :param valid_cache_space: The valid_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space: int
        """

        self._valid_cache_space = valid_cache_space

    @property
    def valid_cache_space_gt(self):
        """Gets the valid_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_gt

    @valid_cache_space_gt.setter
    def valid_cache_space_gt(self, valid_cache_space_gt):
        """Sets the valid_cache_space_gt of this DiskPoolWhereInput.


        :param valid_cache_space_gt: The valid_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_gt: int
        """

        self._valid_cache_space_gt = valid_cache_space_gt

    @property
    def valid_cache_space_gte(self):
        """Gets the valid_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_gte

    @valid_cache_space_gte.setter
    def valid_cache_space_gte(self, valid_cache_space_gte):
        """Sets the valid_cache_space_gte of this DiskPoolWhereInput.


        :param valid_cache_space_gte: The valid_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_gte: int
        """

        self._valid_cache_space_gte = valid_cache_space_gte

    @property
    def valid_cache_space_in(self):
        """Gets the valid_cache_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_cache_space_in

    @valid_cache_space_in.setter
    def valid_cache_space_in(self, valid_cache_space_in):
        """Sets the valid_cache_space_in of this DiskPoolWhereInput.


        :param valid_cache_space_in: The valid_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_in: list[int]
        """

        self._valid_cache_space_in = valid_cache_space_in

    @property
    def valid_cache_space_lt(self):
        """Gets the valid_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_lt

    @valid_cache_space_lt.setter
    def valid_cache_space_lt(self, valid_cache_space_lt):
        """Sets the valid_cache_space_lt of this DiskPoolWhereInput.


        :param valid_cache_space_lt: The valid_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_lt: int
        """

        self._valid_cache_space_lt = valid_cache_space_lt

    @property
    def valid_cache_space_lte(self):
        """Gets the valid_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_lte

    @valid_cache_space_lte.setter
    def valid_cache_space_lte(self, valid_cache_space_lte):
        """Sets the valid_cache_space_lte of this DiskPoolWhereInput.


        :param valid_cache_space_lte: The valid_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_lte: int
        """

        self._valid_cache_space_lte = valid_cache_space_lte

    @property
    def valid_cache_space_not(self):
        """Gets the valid_cache_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_not

    @valid_cache_space_not.setter
    def valid_cache_space_not(self, valid_cache_space_not):
        """Sets the valid_cache_space_not of this DiskPoolWhereInput.


        :param valid_cache_space_not: The valid_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_not: int
        """

        self._valid_cache_space_not = valid_cache_space_not

    @property
    def valid_cache_space_not_in(self):
        """Gets the valid_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_cache_space_not_in

    @valid_cache_space_not_in.setter
    def valid_cache_space_not_in(self, valid_cache_space_not_in):
        """Sets the valid_cache_space_not_in of this DiskPoolWhereInput.


        :param valid_cache_space_not_in: The valid_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type valid_cache_space_not_in: list[int]
        """

        self._valid_cache_space_not_in = valid_cache_space_not_in

    @property
    def valid_free_cache_space(self):
        """Gets the valid_free_cache_space of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space

    @valid_free_cache_space.setter
    def valid_free_cache_space(self, valid_free_cache_space):
        """Sets the valid_free_cache_space of this DiskPoolWhereInput.


        :param valid_free_cache_space: The valid_free_cache_space of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space: int
        """

        self._valid_free_cache_space = valid_free_cache_space

    @property
    def valid_free_cache_space_gt(self):
        """Gets the valid_free_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_gt

    @valid_free_cache_space_gt.setter
    def valid_free_cache_space_gt(self, valid_free_cache_space_gt):
        """Sets the valid_free_cache_space_gt of this DiskPoolWhereInput.


        :param valid_free_cache_space_gt: The valid_free_cache_space_gt of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_gt: int
        """

        self._valid_free_cache_space_gt = valid_free_cache_space_gt

    @property
    def valid_free_cache_space_gte(self):
        """Gets the valid_free_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_gte

    @valid_free_cache_space_gte.setter
    def valid_free_cache_space_gte(self, valid_free_cache_space_gte):
        """Sets the valid_free_cache_space_gte of this DiskPoolWhereInput.


        :param valid_free_cache_space_gte: The valid_free_cache_space_gte of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_gte: int
        """

        self._valid_free_cache_space_gte = valid_free_cache_space_gte

    @property
    def valid_free_cache_space_in(self):
        """Gets the valid_free_cache_space_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_free_cache_space_in

    @valid_free_cache_space_in.setter
    def valid_free_cache_space_in(self, valid_free_cache_space_in):
        """Sets the valid_free_cache_space_in of this DiskPoolWhereInput.


        :param valid_free_cache_space_in: The valid_free_cache_space_in of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_in: list[int]
        """

        self._valid_free_cache_space_in = valid_free_cache_space_in

    @property
    def valid_free_cache_space_lt(self):
        """Gets the valid_free_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_lt

    @valid_free_cache_space_lt.setter
    def valid_free_cache_space_lt(self, valid_free_cache_space_lt):
        """Sets the valid_free_cache_space_lt of this DiskPoolWhereInput.


        :param valid_free_cache_space_lt: The valid_free_cache_space_lt of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_lt: int
        """

        self._valid_free_cache_space_lt = valid_free_cache_space_lt

    @property
    def valid_free_cache_space_lte(self):
        """Gets the valid_free_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_lte

    @valid_free_cache_space_lte.setter
    def valid_free_cache_space_lte(self, valid_free_cache_space_lte):
        """Sets the valid_free_cache_space_lte of this DiskPoolWhereInput.


        :param valid_free_cache_space_lte: The valid_free_cache_space_lte of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_lte: int
        """

        self._valid_free_cache_space_lte = valid_free_cache_space_lte

    @property
    def valid_free_cache_space_not(self):
        """Gets the valid_free_cache_space_not of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_not

    @valid_free_cache_space_not.setter
    def valid_free_cache_space_not(self, valid_free_cache_space_not):
        """Sets the valid_free_cache_space_not of this DiskPoolWhereInput.


        :param valid_free_cache_space_not: The valid_free_cache_space_not of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_not: int
        """

        self._valid_free_cache_space_not = valid_free_cache_space_not

    @property
    def valid_free_cache_space_not_in(self):
        """Gets the valid_free_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_free_cache_space_not_in

    @valid_free_cache_space_not_in.setter
    def valid_free_cache_space_not_in(self, valid_free_cache_space_not_in):
        """Sets the valid_free_cache_space_not_in of this DiskPoolWhereInput.


        :param valid_free_cache_space_not_in: The valid_free_cache_space_not_in of this DiskPoolWhereInput.  # noqa: E501
        :type valid_free_cache_space_not_in: list[int]
        """

        self._valid_free_cache_space_not_in = valid_free_cache_space_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskPoolWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DiskPoolWhereInput):
            return True

        return self.to_dict() != other.to_dict()
