# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class EcpLicense(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'cluster_local_id': 'str',
        'ecp_edition': 'EcpEdition',
        'expire_date': 'str',
        'has_metrox': 'bool',
        'has_remote_backup': 'bool',
        'id': 'str',
        'license_type': 'LicenseType',
        'max_core_num': 'int',
        'max_physical_data_capacity': 'float',
        'original_code': 'str',
        'product_name': 'str',
        'serial': 'str',
        'sign_date': 'str',
        'subscription_expire_date': 'str',
        'subscription_start_date': 'str',
        'vendor': 'str',
        'version': 'int'
    }

    attribute_map = {
        'cluster': 'cluster',
        'cluster_local_id': 'cluster_local_id',
        'ecp_edition': 'ecp_edition',
        'expire_date': 'expire_date',
        'has_metrox': 'has_metrox',
        'has_remote_backup': 'has_remote_backup',
        'id': 'id',
        'license_type': 'license_type',
        'max_core_num': 'max_core_num',
        'max_physical_data_capacity': 'max_physical_data_capacity',
        'original_code': 'original_code',
        'product_name': 'product_name',
        'serial': 'serial',
        'sign_date': 'sign_date',
        'subscription_expire_date': 'subscription_expire_date',
        'subscription_start_date': 'subscription_start_date',
        'vendor': 'vendor',
        'version': 'version'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """EcpLicense - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._cluster_local_id = None
        self._ecp_edition = None
        self._expire_date = None
        self._has_metrox = None
        self._has_remote_backup = None
        self._id = None
        self._license_type = None
        self._max_core_num = None
        self._max_physical_data_capacity = None
        self._original_code = None
        self._product_name = None
        self._serial = None
        self._sign_date = None
        self._subscription_expire_date = None
        self._subscription_start_date = None
        self._vendor = None
        self._version = None
        self.discriminator = None

        self.cluster = kwargs.get("cluster", None)
        if "cluster_local_id" in kwargs:
            self.cluster_local_id = kwargs["cluster_local_id"]
        if "ecp_edition" in kwargs:
            self.ecp_edition = kwargs["ecp_edition"]
        self.expire_date = kwargs.get("expire_date", None)
        self.has_metrox = kwargs.get("has_metrox", None)
        self.has_remote_backup = kwargs.get("has_remote_backup", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.license_type = kwargs.get("license_type", None)
        if "max_core_num" in kwargs:
            self.max_core_num = kwargs["max_core_num"]
        self.max_physical_data_capacity = kwargs.get("max_physical_data_capacity", None)
        self.original_code = kwargs.get("original_code", None)
        if "product_name" in kwargs:
            self.product_name = kwargs["product_name"]
        if "serial" in kwargs:
            self.serial = kwargs["serial"]
        if "sign_date" in kwargs:
            self.sign_date = kwargs["sign_date"]
        self.subscription_expire_date = kwargs.get("subscription_expire_date", None)
        self.subscription_start_date = kwargs.get("subscription_start_date", None)
        self.vendor = kwargs.get("vendor", None)
        if "version" in kwargs:
            self.version = kwargs["version"]

    @property
    def cluster(self):
        """Gets the cluster of this EcpLicense.  # noqa: E501


        :return: The cluster of this EcpLicense.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this EcpLicense.


        :param cluster: The cluster of this EcpLicense.  # noqa: E501
        :type cluster: NestedCluster
        """

        self._cluster = cluster

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this EcpLicense.  # noqa: E501


        :return: The cluster_local_id of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this EcpLicense.


        :param cluster_local_id: The cluster_local_id of this EcpLicense.  # noqa: E501
        :type cluster_local_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_local_id`, must not be `None`")  # noqa: E501

        self._cluster_local_id = cluster_local_id

    @property
    def ecp_edition(self):
        """Gets the ecp_edition of this EcpLicense.  # noqa: E501


        :return: The ecp_edition of this EcpLicense.  # noqa: E501
        :rtype: EcpEdition
        """
        return self._ecp_edition

    @ecp_edition.setter
    def ecp_edition(self, ecp_edition):
        """Sets the ecp_edition of this EcpLicense.


        :param ecp_edition: The ecp_edition of this EcpLicense.  # noqa: E501
        :type ecp_edition: EcpEdition
        """
        if self.local_vars_configuration.client_side_validation and ecp_edition is None:  # noqa: E501
            raise ValueError("Invalid value for `ecp_edition`, must not be `None`")  # noqa: E501

        self._ecp_edition = ecp_edition

    @property
    def expire_date(self):
        """Gets the expire_date of this EcpLicense.  # noqa: E501


        :return: The expire_date of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._expire_date

    @expire_date.setter
    def expire_date(self, expire_date):
        """Sets the expire_date of this EcpLicense.


        :param expire_date: The expire_date of this EcpLicense.  # noqa: E501
        :type expire_date: str
        """

        self._expire_date = expire_date

    @property
    def has_metrox(self):
        """Gets the has_metrox of this EcpLicense.  # noqa: E501


        :return: The has_metrox of this EcpLicense.  # noqa: E501
        :rtype: bool
        """
        return self._has_metrox

    @has_metrox.setter
    def has_metrox(self, has_metrox):
        """Sets the has_metrox of this EcpLicense.


        :param has_metrox: The has_metrox of this EcpLicense.  # noqa: E501
        :type has_metrox: bool
        """

        self._has_metrox = has_metrox

    @property
    def has_remote_backup(self):
        """Gets the has_remote_backup of this EcpLicense.  # noqa: E501


        :return: The has_remote_backup of this EcpLicense.  # noqa: E501
        :rtype: bool
        """
        return self._has_remote_backup

    @has_remote_backup.setter
    def has_remote_backup(self, has_remote_backup):
        """Sets the has_remote_backup of this EcpLicense.


        :param has_remote_backup: The has_remote_backup of this EcpLicense.  # noqa: E501
        :type has_remote_backup: bool
        """

        self._has_remote_backup = has_remote_backup

    @property
    def id(self):
        """Gets the id of this EcpLicense.  # noqa: E501


        :return: The id of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EcpLicense.


        :param id: The id of this EcpLicense.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def license_type(self):
        """Gets the license_type of this EcpLicense.  # noqa: E501


        :return: The license_type of this EcpLicense.  # noqa: E501
        :rtype: LicenseType
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """Sets the license_type of this EcpLicense.


        :param license_type: The license_type of this EcpLicense.  # noqa: E501
        :type license_type: LicenseType
        """

        self._license_type = license_type

    @property
    def max_core_num(self):
        """Gets the max_core_num of this EcpLicense.  # noqa: E501


        :return: The max_core_num of this EcpLicense.  # noqa: E501
        :rtype: int
        """
        return self._max_core_num

    @max_core_num.setter
    def max_core_num(self, max_core_num):
        """Sets the max_core_num of this EcpLicense.


        :param max_core_num: The max_core_num of this EcpLicense.  # noqa: E501
        :type max_core_num: int
        """
        if self.local_vars_configuration.client_side_validation and max_core_num is None:  # noqa: E501
            raise ValueError("Invalid value for `max_core_num`, must not be `None`")  # noqa: E501

        self._max_core_num = max_core_num

    @property
    def max_physical_data_capacity(self):
        """Gets the max_physical_data_capacity of this EcpLicense.  # noqa: E501


        :return: The max_physical_data_capacity of this EcpLicense.  # noqa: E501
        :rtype: float
        """
        return self._max_physical_data_capacity

    @max_physical_data_capacity.setter
    def max_physical_data_capacity(self, max_physical_data_capacity):
        """Sets the max_physical_data_capacity of this EcpLicense.


        :param max_physical_data_capacity: The max_physical_data_capacity of this EcpLicense.  # noqa: E501
        :type max_physical_data_capacity: float
        """

        self._max_physical_data_capacity = max_physical_data_capacity

    @property
    def original_code(self):
        """Gets the original_code of this EcpLicense.  # noqa: E501


        :return: The original_code of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._original_code

    @original_code.setter
    def original_code(self, original_code):
        """Sets the original_code of this EcpLicense.


        :param original_code: The original_code of this EcpLicense.  # noqa: E501
        :type original_code: str
        """

        self._original_code = original_code

    @property
    def product_name(self):
        """Gets the product_name of this EcpLicense.  # noqa: E501


        :return: The product_name of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this EcpLicense.


        :param product_name: The product_name of this EcpLicense.  # noqa: E501
        :type product_name: str
        """
        if self.local_vars_configuration.client_side_validation and product_name is None:  # noqa: E501
            raise ValueError("Invalid value for `product_name`, must not be `None`")  # noqa: E501

        self._product_name = product_name

    @property
    def serial(self):
        """Gets the serial of this EcpLicense.  # noqa: E501


        :return: The serial of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._serial

    @serial.setter
    def serial(self, serial):
        """Sets the serial of this EcpLicense.


        :param serial: The serial of this EcpLicense.  # noqa: E501
        :type serial: str
        """
        if self.local_vars_configuration.client_side_validation and serial is None:  # noqa: E501
            raise ValueError("Invalid value for `serial`, must not be `None`")  # noqa: E501

        self._serial = serial

    @property
    def sign_date(self):
        """Gets the sign_date of this EcpLicense.  # noqa: E501


        :return: The sign_date of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._sign_date

    @sign_date.setter
    def sign_date(self, sign_date):
        """Sets the sign_date of this EcpLicense.


        :param sign_date: The sign_date of this EcpLicense.  # noqa: E501
        :type sign_date: str
        """
        if self.local_vars_configuration.client_side_validation and sign_date is None:  # noqa: E501
            raise ValueError("Invalid value for `sign_date`, must not be `None`")  # noqa: E501

        self._sign_date = sign_date

    @property
    def subscription_expire_date(self):
        """Gets the subscription_expire_date of this EcpLicense.  # noqa: E501


        :return: The subscription_expire_date of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._subscription_expire_date

    @subscription_expire_date.setter
    def subscription_expire_date(self, subscription_expire_date):
        """Sets the subscription_expire_date of this EcpLicense.


        :param subscription_expire_date: The subscription_expire_date of this EcpLicense.  # noqa: E501
        :type subscription_expire_date: str
        """

        self._subscription_expire_date = subscription_expire_date

    @property
    def subscription_start_date(self):
        """Gets the subscription_start_date of this EcpLicense.  # noqa: E501


        :return: The subscription_start_date of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._subscription_start_date

    @subscription_start_date.setter
    def subscription_start_date(self, subscription_start_date):
        """Sets the subscription_start_date of this EcpLicense.


        :param subscription_start_date: The subscription_start_date of this EcpLicense.  # noqa: E501
        :type subscription_start_date: str
        """

        self._subscription_start_date = subscription_start_date

    @property
    def vendor(self):
        """Gets the vendor of this EcpLicense.  # noqa: E501


        :return: The vendor of this EcpLicense.  # noqa: E501
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """Sets the vendor of this EcpLicense.


        :param vendor: The vendor of this EcpLicense.  # noqa: E501
        :type vendor: str
        """

        self._vendor = vendor

    @property
    def version(self):
        """Gets the version of this EcpLicense.  # noqa: E501


        :return: The version of this EcpLicense.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this EcpLicense.


        :param version: The version of this EcpLicense.  # noqa: E501
        :type version: int
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EcpLicense):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EcpLicense):
            return True

        return self.to_dict() != other.to_dict()
