# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class EnterMaintenanceModeResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'shutdown_vms': 'list[ShutdownVmID]',
        'done': 'bool'
    }

    attribute_map = {
        'shutdown_vms': 'shutdownVms',
        'done': 'done'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """EnterMaintenanceModeResult - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._shutdown_vms = None
        self._done = None
        self.discriminator = None

        if "shutdown_vms" in kwargs:
            self.shutdown_vms = kwargs["shutdown_vms"]
        if "done" in kwargs:
            self.done = kwargs["done"]

    @property
    def shutdown_vms(self):
        """Gets the shutdown_vms of this EnterMaintenanceModeResult.  # noqa: E501


        :return: The shutdown_vms of this EnterMaintenanceModeResult.  # noqa: E501
        :rtype: list[ShutdownVmID]
        """
        return self._shutdown_vms

    @shutdown_vms.setter
    def shutdown_vms(self, shutdown_vms):
        """Sets the shutdown_vms of this EnterMaintenanceModeResult.


        :param shutdown_vms: The shutdown_vms of this EnterMaintenanceModeResult.  # noqa: E501
        :type shutdown_vms: list[ShutdownVmID]
        """
        if self.local_vars_configuration.client_side_validation and shutdown_vms is None:  # noqa: E501
            raise ValueError("Invalid value for `shutdown_vms`, must not be `None`")  # noqa: E501

        self._shutdown_vms = shutdown_vms

    @property
    def done(self):
        """Gets the done of this EnterMaintenanceModeResult.  # noqa: E501


        :return: The done of this EnterMaintenanceModeResult.  # noqa: E501
        :rtype: bool
        """
        return self._done

    @done.setter
    def done(self, done):
        """Sets the done of this EnterMaintenanceModeResult.


        :param done: The done of this EnterMaintenanceModeResult.  # noqa: E501
        :type done: bool
        """
        if self.local_vars_configuration.client_side_validation and done is None:  # noqa: E501
            raise ValueError("Invalid value for `done`, must not be `None`")  # noqa: E501

        self._done = done

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterMaintenanceModeResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EnterMaintenanceModeResult):
            return True

        return self.to_dict() != other.to_dict()
