# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class EntityFilterCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'exclude_vms': 'VmWhereInput',
        'clusters': 'ClusterWhereInput',
        'apply_to_all_clusters': 'bool',
        'rules': 'list[FilterRuleInput]',
        'name': 'str'
    }

    attribute_map = {
        'exclude_vms': 'exclude_vms',
        'clusters': 'clusters',
        'apply_to_all_clusters': 'apply_to_all_clusters',
        'rules': 'rules',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """EntityFilterCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._exclude_vms = None
        self._clusters = None
        self._apply_to_all_clusters = None
        self._rules = None
        self._name = None
        self.discriminator = None

        if "exclude_vms" in kwargs:
            self.exclude_vms = kwargs["exclude_vms"]
        if "clusters" in kwargs:
            self.clusters = kwargs["clusters"]
        if "apply_to_all_clusters" in kwargs:
            self.apply_to_all_clusters = kwargs["apply_to_all_clusters"]
        if "rules" in kwargs:
            self.rules = kwargs["rules"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def exclude_vms(self):
        """Gets the exclude_vms of this EntityFilterCreationParams.  # noqa: E501


        :return: The exclude_vms of this EntityFilterCreationParams.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._exclude_vms

    @exclude_vms.setter
    def exclude_vms(self, exclude_vms):
        """Sets the exclude_vms of this EntityFilterCreationParams.


        :param exclude_vms: The exclude_vms of this EntityFilterCreationParams.  # noqa: E501
        :type exclude_vms: VmWhereInput
        """

        self._exclude_vms = exclude_vms

    @property
    def clusters(self):
        """Gets the clusters of this EntityFilterCreationParams.  # noqa: E501


        :return: The clusters of this EntityFilterCreationParams.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """Sets the clusters of this EntityFilterCreationParams.


        :param clusters: The clusters of this EntityFilterCreationParams.  # noqa: E501
        :type clusters: ClusterWhereInput
        """

        self._clusters = clusters

    @property
    def apply_to_all_clusters(self):
        """Gets the apply_to_all_clusters of this EntityFilterCreationParams.  # noqa: E501


        :return: The apply_to_all_clusters of this EntityFilterCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._apply_to_all_clusters

    @apply_to_all_clusters.setter
    def apply_to_all_clusters(self, apply_to_all_clusters):
        """Sets the apply_to_all_clusters of this EntityFilterCreationParams.


        :param apply_to_all_clusters: The apply_to_all_clusters of this EntityFilterCreationParams.  # noqa: E501
        :type apply_to_all_clusters: bool
        """

        self._apply_to_all_clusters = apply_to_all_clusters

    @property
    def rules(self):
        """Gets the rules of this EntityFilterCreationParams.  # noqa: E501


        :return: The rules of this EntityFilterCreationParams.  # noqa: E501
        :rtype: list[FilterRuleInput]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this EntityFilterCreationParams.


        :param rules: The rules of this EntityFilterCreationParams.  # noqa: E501
        :type rules: list[FilterRuleInput]
        """
        if self.local_vars_configuration.client_side_validation and rules is None:  # noqa: E501
            raise ValueError("Invalid value for `rules`, must not be `None`")  # noqa: E501

        self._rules = rules

    @property
    def name(self):
        """Gets the name of this EntityFilterCreationParams.  # noqa: E501


        :return: The name of this EntityFilterCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EntityFilterCreationParams.


        :param name: The name of this EntityFilterCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityFilterCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EntityFilterCreationParams):
            return True

        return self.to_dict() != other.to_dict()
