# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class EntityFilterWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[EntityFilterWhereInput]',
        '_not': 'list[EntityFilterWhereInput]',
        '_or': 'list[EntityFilterWhereInput]',
        'apply_to_all_clusters': 'bool',
        'apply_to_all_clusters_not': 'bool',
        'clusters_every': 'ClusterWhereInput',
        'clusters_none': 'ClusterWhereInput',
        'clusters_some': 'ClusterWhereInput',
        'entity_type': 'EntityType',
        'entity_type_in': 'list[EntityType]',
        'entity_type_not': 'EntityType',
        'entity_type_not_in': 'list[EntityType]',
        'exec_failed_cluster_every': 'ClusterWhereInput',
        'exec_failed_cluster_none': 'ClusterWhereInput',
        'exec_failed_cluster_some': 'ClusterWhereInput',
        'filter_status': 'FilterStatus',
        'filter_status_in': 'list[FilterStatus]',
        'filter_status_not': 'FilterStatus',
        'filter_status_not_in': 'list[FilterStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'last_executed_at': 'str',
        'last_executed_at_gt': 'str',
        'last_executed_at_gte': 'str',
        'last_executed_at_in': 'list[str]',
        'last_executed_at_lt': 'str',
        'last_executed_at_lte': 'str',
        'last_executed_at_not': 'str',
        'last_executed_at_not_in': 'list[str]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'preset': 'str',
        'preset_contains': 'str',
        'preset_ends_with': 'str',
        'preset_gt': 'str',
        'preset_gte': 'str',
        'preset_in': 'list[str]',
        'preset_lt': 'str',
        'preset_lte': 'str',
        'preset_not': 'str',
        'preset_not_contains': 'str',
        'preset_not_ends_with': 'str',
        'preset_not_in': 'list[str]',
        'preset_not_starts_with': 'str',
        'preset_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'apply_to_all_clusters': 'apply_to_all_clusters',
        'apply_to_all_clusters_not': 'apply_to_all_clusters_not',
        'clusters_every': 'clusters_every',
        'clusters_none': 'clusters_none',
        'clusters_some': 'clusters_some',
        'entity_type': 'entity_type',
        'entity_type_in': 'entity_type_in',
        'entity_type_not': 'entity_type_not',
        'entity_type_not_in': 'entity_type_not_in',
        'exec_failed_cluster_every': 'exec_failed_cluster_every',
        'exec_failed_cluster_none': 'exec_failed_cluster_none',
        'exec_failed_cluster_some': 'exec_failed_cluster_some',
        'filter_status': 'filter_status',
        'filter_status_in': 'filter_status_in',
        'filter_status_not': 'filter_status_not',
        'filter_status_not_in': 'filter_status_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'last_executed_at': 'last_executed_at',
        'last_executed_at_gt': 'last_executed_at_gt',
        'last_executed_at_gte': 'last_executed_at_gte',
        'last_executed_at_in': 'last_executed_at_in',
        'last_executed_at_lt': 'last_executed_at_lt',
        'last_executed_at_lte': 'last_executed_at_lte',
        'last_executed_at_not': 'last_executed_at_not',
        'last_executed_at_not_in': 'last_executed_at_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'preset': 'preset',
        'preset_contains': 'preset_contains',
        'preset_ends_with': 'preset_ends_with',
        'preset_gt': 'preset_gt',
        'preset_gte': 'preset_gte',
        'preset_in': 'preset_in',
        'preset_lt': 'preset_lt',
        'preset_lte': 'preset_lte',
        'preset_not': 'preset_not',
        'preset_not_contains': 'preset_not_contains',
        'preset_not_ends_with': 'preset_not_ends_with',
        'preset_not_in': 'preset_not_in',
        'preset_not_starts_with': 'preset_not_starts_with',
        'preset_starts_with': 'preset_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """EntityFilterWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._apply_to_all_clusters = None
        self._apply_to_all_clusters_not = None
        self._clusters_every = None
        self._clusters_none = None
        self._clusters_some = None
        self._entity_type = None
        self._entity_type_in = None
        self._entity_type_not = None
        self._entity_type_not_in = None
        self._exec_failed_cluster_every = None
        self._exec_failed_cluster_none = None
        self._exec_failed_cluster_some = None
        self._filter_status = None
        self._filter_status_in = None
        self._filter_status_not = None
        self._filter_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._last_executed_at = None
        self._last_executed_at_gt = None
        self._last_executed_at_gte = None
        self._last_executed_at_in = None
        self._last_executed_at_lt = None
        self._last_executed_at_lte = None
        self._last_executed_at_not = None
        self._last_executed_at_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._preset = None
        self._preset_contains = None
        self._preset_ends_with = None
        self._preset_gt = None
        self._preset_gte = None
        self._preset_in = None
        self._preset_lt = None
        self._preset_lte = None
        self._preset_not = None
        self._preset_not_contains = None
        self._preset_not_ends_with = None
        self._preset_not_in = None
        self._preset_not_starts_with = None
        self._preset_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.apply_to_all_clusters = kwargs.get("apply_to_all_clusters", None)
        self.apply_to_all_clusters_not = kwargs.get("apply_to_all_clusters_not", None)
        self.clusters_every = kwargs.get("clusters_every", None)
        self.clusters_none = kwargs.get("clusters_none", None)
        self.clusters_some = kwargs.get("clusters_some", None)
        self.entity_type = kwargs.get("entity_type", None)
        self.entity_type_in = kwargs.get("entity_type_in", None)
        self.entity_type_not = kwargs.get("entity_type_not", None)
        self.entity_type_not_in = kwargs.get("entity_type_not_in", None)
        self.exec_failed_cluster_every = kwargs.get("exec_failed_cluster_every", None)
        self.exec_failed_cluster_none = kwargs.get("exec_failed_cluster_none", None)
        self.exec_failed_cluster_some = kwargs.get("exec_failed_cluster_some", None)
        self.filter_status = kwargs.get("filter_status", None)
        self.filter_status_in = kwargs.get("filter_status_in", None)
        self.filter_status_not = kwargs.get("filter_status_not", None)
        self.filter_status_not_in = kwargs.get("filter_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.last_executed_at = kwargs.get("last_executed_at", None)
        self.last_executed_at_gt = kwargs.get("last_executed_at_gt", None)
        self.last_executed_at_gte = kwargs.get("last_executed_at_gte", None)
        self.last_executed_at_in = kwargs.get("last_executed_at_in", None)
        self.last_executed_at_lt = kwargs.get("last_executed_at_lt", None)
        self.last_executed_at_lte = kwargs.get("last_executed_at_lte", None)
        self.last_executed_at_not = kwargs.get("last_executed_at_not", None)
        self.last_executed_at_not_in = kwargs.get("last_executed_at_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.preset = kwargs.get("preset", None)
        self.preset_contains = kwargs.get("preset_contains", None)
        self.preset_ends_with = kwargs.get("preset_ends_with", None)
        self.preset_gt = kwargs.get("preset_gt", None)
        self.preset_gte = kwargs.get("preset_gte", None)
        self.preset_in = kwargs.get("preset_in", None)
        self.preset_lt = kwargs.get("preset_lt", None)
        self.preset_lte = kwargs.get("preset_lte", None)
        self.preset_not = kwargs.get("preset_not", None)
        self.preset_not_contains = kwargs.get("preset_not_contains", None)
        self.preset_not_ends_with = kwargs.get("preset_not_ends_with", None)
        self.preset_not_in = kwargs.get("preset_not_in", None)
        self.preset_not_starts_with = kwargs.get("preset_not_starts_with", None)
        self.preset_starts_with = kwargs.get("preset_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this EntityFilterWhereInput.  # noqa: E501


        :return: The _and of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[EntityFilterWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this EntityFilterWhereInput.


        :param _and: The _and of this EntityFilterWhereInput.  # noqa: E501
        :type _and: list[EntityFilterWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this EntityFilterWhereInput.  # noqa: E501


        :return: The _not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[EntityFilterWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this EntityFilterWhereInput.


        :param _not: The _not of this EntityFilterWhereInput.  # noqa: E501
        :type _not: list[EntityFilterWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this EntityFilterWhereInput.  # noqa: E501


        :return: The _or of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[EntityFilterWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this EntityFilterWhereInput.


        :param _or: The _or of this EntityFilterWhereInput.  # noqa: E501
        :type _or: list[EntityFilterWhereInput]
        """

        self.__or = _or

    @property
    def apply_to_all_clusters(self):
        """Gets the apply_to_all_clusters of this EntityFilterWhereInput.  # noqa: E501


        :return: The apply_to_all_clusters of this EntityFilterWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._apply_to_all_clusters

    @apply_to_all_clusters.setter
    def apply_to_all_clusters(self, apply_to_all_clusters):
        """Sets the apply_to_all_clusters of this EntityFilterWhereInput.


        :param apply_to_all_clusters: The apply_to_all_clusters of this EntityFilterWhereInput.  # noqa: E501
        :type apply_to_all_clusters: bool
        """

        self._apply_to_all_clusters = apply_to_all_clusters

    @property
    def apply_to_all_clusters_not(self):
        """Gets the apply_to_all_clusters_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The apply_to_all_clusters_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._apply_to_all_clusters_not

    @apply_to_all_clusters_not.setter
    def apply_to_all_clusters_not(self, apply_to_all_clusters_not):
        """Sets the apply_to_all_clusters_not of this EntityFilterWhereInput.


        :param apply_to_all_clusters_not: The apply_to_all_clusters_not of this EntityFilterWhereInput.  # noqa: E501
        :type apply_to_all_clusters_not: bool
        """

        self._apply_to_all_clusters_not = apply_to_all_clusters_not

    @property
    def clusters_every(self):
        """Gets the clusters_every of this EntityFilterWhereInput.  # noqa: E501


        :return: The clusters_every of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._clusters_every

    @clusters_every.setter
    def clusters_every(self, clusters_every):
        """Sets the clusters_every of this EntityFilterWhereInput.


        :param clusters_every: The clusters_every of this EntityFilterWhereInput.  # noqa: E501
        :type clusters_every: ClusterWhereInput
        """

        self._clusters_every = clusters_every

    @property
    def clusters_none(self):
        """Gets the clusters_none of this EntityFilterWhereInput.  # noqa: E501


        :return: The clusters_none of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._clusters_none

    @clusters_none.setter
    def clusters_none(self, clusters_none):
        """Sets the clusters_none of this EntityFilterWhereInput.


        :param clusters_none: The clusters_none of this EntityFilterWhereInput.  # noqa: E501
        :type clusters_none: ClusterWhereInput
        """

        self._clusters_none = clusters_none

    @property
    def clusters_some(self):
        """Gets the clusters_some of this EntityFilterWhereInput.  # noqa: E501


        :return: The clusters_some of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._clusters_some

    @clusters_some.setter
    def clusters_some(self, clusters_some):
        """Sets the clusters_some of this EntityFilterWhereInput.


        :param clusters_some: The clusters_some of this EntityFilterWhereInput.  # noqa: E501
        :type clusters_some: ClusterWhereInput
        """

        self._clusters_some = clusters_some

    @property
    def entity_type(self):
        """Gets the entity_type of this EntityFilterWhereInput.  # noqa: E501


        :return: The entity_type of this EntityFilterWhereInput.  # noqa: E501
        :rtype: EntityType
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this EntityFilterWhereInput.


        :param entity_type: The entity_type of this EntityFilterWhereInput.  # noqa: E501
        :type entity_type: EntityType
        """

        self._entity_type = entity_type

    @property
    def entity_type_in(self):
        """Gets the entity_type_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The entity_type_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[EntityType]
        """
        return self._entity_type_in

    @entity_type_in.setter
    def entity_type_in(self, entity_type_in):
        """Sets the entity_type_in of this EntityFilterWhereInput.


        :param entity_type_in: The entity_type_in of this EntityFilterWhereInput.  # noqa: E501
        :type entity_type_in: list[EntityType]
        """

        self._entity_type_in = entity_type_in

    @property
    def entity_type_not(self):
        """Gets the entity_type_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The entity_type_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: EntityType
        """
        return self._entity_type_not

    @entity_type_not.setter
    def entity_type_not(self, entity_type_not):
        """Sets the entity_type_not of this EntityFilterWhereInput.


        :param entity_type_not: The entity_type_not of this EntityFilterWhereInput.  # noqa: E501
        :type entity_type_not: EntityType
        """

        self._entity_type_not = entity_type_not

    @property
    def entity_type_not_in(self):
        """Gets the entity_type_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The entity_type_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[EntityType]
        """
        return self._entity_type_not_in

    @entity_type_not_in.setter
    def entity_type_not_in(self, entity_type_not_in):
        """Sets the entity_type_not_in of this EntityFilterWhereInput.


        :param entity_type_not_in: The entity_type_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type entity_type_not_in: list[EntityType]
        """

        self._entity_type_not_in = entity_type_not_in

    @property
    def exec_failed_cluster_every(self):
        """Gets the exec_failed_cluster_every of this EntityFilterWhereInput.  # noqa: E501


        :return: The exec_failed_cluster_every of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._exec_failed_cluster_every

    @exec_failed_cluster_every.setter
    def exec_failed_cluster_every(self, exec_failed_cluster_every):
        """Sets the exec_failed_cluster_every of this EntityFilterWhereInput.


        :param exec_failed_cluster_every: The exec_failed_cluster_every of this EntityFilterWhereInput.  # noqa: E501
        :type exec_failed_cluster_every: ClusterWhereInput
        """

        self._exec_failed_cluster_every = exec_failed_cluster_every

    @property
    def exec_failed_cluster_none(self):
        """Gets the exec_failed_cluster_none of this EntityFilterWhereInput.  # noqa: E501


        :return: The exec_failed_cluster_none of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._exec_failed_cluster_none

    @exec_failed_cluster_none.setter
    def exec_failed_cluster_none(self, exec_failed_cluster_none):
        """Sets the exec_failed_cluster_none of this EntityFilterWhereInput.


        :param exec_failed_cluster_none: The exec_failed_cluster_none of this EntityFilterWhereInput.  # noqa: E501
        :type exec_failed_cluster_none: ClusterWhereInput
        """

        self._exec_failed_cluster_none = exec_failed_cluster_none

    @property
    def exec_failed_cluster_some(self):
        """Gets the exec_failed_cluster_some of this EntityFilterWhereInput.  # noqa: E501


        :return: The exec_failed_cluster_some of this EntityFilterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._exec_failed_cluster_some

    @exec_failed_cluster_some.setter
    def exec_failed_cluster_some(self, exec_failed_cluster_some):
        """Sets the exec_failed_cluster_some of this EntityFilterWhereInput.


        :param exec_failed_cluster_some: The exec_failed_cluster_some of this EntityFilterWhereInput.  # noqa: E501
        :type exec_failed_cluster_some: ClusterWhereInput
        """

        self._exec_failed_cluster_some = exec_failed_cluster_some

    @property
    def filter_status(self):
        """Gets the filter_status of this EntityFilterWhereInput.  # noqa: E501


        :return: The filter_status of this EntityFilterWhereInput.  # noqa: E501
        :rtype: FilterStatus
        """
        return self._filter_status

    @filter_status.setter
    def filter_status(self, filter_status):
        """Sets the filter_status of this EntityFilterWhereInput.


        :param filter_status: The filter_status of this EntityFilterWhereInput.  # noqa: E501
        :type filter_status: FilterStatus
        """

        self._filter_status = filter_status

    @property
    def filter_status_in(self):
        """Gets the filter_status_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The filter_status_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[FilterStatus]
        """
        return self._filter_status_in

    @filter_status_in.setter
    def filter_status_in(self, filter_status_in):
        """Sets the filter_status_in of this EntityFilterWhereInput.


        :param filter_status_in: The filter_status_in of this EntityFilterWhereInput.  # noqa: E501
        :type filter_status_in: list[FilterStatus]
        """

        self._filter_status_in = filter_status_in

    @property
    def filter_status_not(self):
        """Gets the filter_status_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The filter_status_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: FilterStatus
        """
        return self._filter_status_not

    @filter_status_not.setter
    def filter_status_not(self, filter_status_not):
        """Sets the filter_status_not of this EntityFilterWhereInput.


        :param filter_status_not: The filter_status_not of this EntityFilterWhereInput.  # noqa: E501
        :type filter_status_not: FilterStatus
        """

        self._filter_status_not = filter_status_not

    @property
    def filter_status_not_in(self):
        """Gets the filter_status_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The filter_status_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[FilterStatus]
        """
        return self._filter_status_not_in

    @filter_status_not_in.setter
    def filter_status_not_in(self, filter_status_not_in):
        """Sets the filter_status_not_in of this EntityFilterWhereInput.


        :param filter_status_not_in: The filter_status_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type filter_status_not_in: list[FilterStatus]
        """

        self._filter_status_not_in = filter_status_not_in

    @property
    def id(self):
        """Gets the id of this EntityFilterWhereInput.  # noqa: E501


        :return: The id of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EntityFilterWhereInput.


        :param id: The id of this EntityFilterWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this EntityFilterWhereInput.


        :param id_contains: The id_contains of this EntityFilterWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this EntityFilterWhereInput.


        :param id_ends_with: The id_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_gt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this EntityFilterWhereInput.


        :param id_gt: The id_gt of this EntityFilterWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_gte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this EntityFilterWhereInput.


        :param id_gte: The id_gte of this EntityFilterWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this EntityFilterWhereInput.


        :param id_in: The id_in of this EntityFilterWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_lt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this EntityFilterWhereInput.


        :param id_lt: The id_lt of this EntityFilterWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_lte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this EntityFilterWhereInput.


        :param id_lte: The id_lte of this EntityFilterWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this EntityFilterWhereInput.


        :param id_not: The id_not of this EntityFilterWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this EntityFilterWhereInput.


        :param id_not_contains: The id_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this EntityFilterWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this EntityFilterWhereInput.


        :param id_not_in: The id_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this EntityFilterWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The id_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this EntityFilterWhereInput.


        :param id_starts_with: The id_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def last_executed_at(self):
        """Gets the last_executed_at of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at

    @last_executed_at.setter
    def last_executed_at(self, last_executed_at):
        """Sets the last_executed_at of this EntityFilterWhereInput.


        :param last_executed_at: The last_executed_at of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at: str
        """

        self._last_executed_at = last_executed_at

    @property
    def last_executed_at_gt(self):
        """Gets the last_executed_at_gt of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_gt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gt

    @last_executed_at_gt.setter
    def last_executed_at_gt(self, last_executed_at_gt):
        """Sets the last_executed_at_gt of this EntityFilterWhereInput.


        :param last_executed_at_gt: The last_executed_at_gt of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_gt: str
        """

        self._last_executed_at_gt = last_executed_at_gt

    @property
    def last_executed_at_gte(self):
        """Gets the last_executed_at_gte of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_gte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gte

    @last_executed_at_gte.setter
    def last_executed_at_gte(self, last_executed_at_gte):
        """Sets the last_executed_at_gte of this EntityFilterWhereInput.


        :param last_executed_at_gte: The last_executed_at_gte of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_gte: str
        """

        self._last_executed_at_gte = last_executed_at_gte

    @property
    def last_executed_at_in(self):
        """Gets the last_executed_at_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_in

    @last_executed_at_in.setter
    def last_executed_at_in(self, last_executed_at_in):
        """Sets the last_executed_at_in of this EntityFilterWhereInput.


        :param last_executed_at_in: The last_executed_at_in of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_in: list[str]
        """

        self._last_executed_at_in = last_executed_at_in

    @property
    def last_executed_at_lt(self):
        """Gets the last_executed_at_lt of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_lt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lt

    @last_executed_at_lt.setter
    def last_executed_at_lt(self, last_executed_at_lt):
        """Sets the last_executed_at_lt of this EntityFilterWhereInput.


        :param last_executed_at_lt: The last_executed_at_lt of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_lt: str
        """

        self._last_executed_at_lt = last_executed_at_lt

    @property
    def last_executed_at_lte(self):
        """Gets the last_executed_at_lte of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_lte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lte

    @last_executed_at_lte.setter
    def last_executed_at_lte(self, last_executed_at_lte):
        """Sets the last_executed_at_lte of this EntityFilterWhereInput.


        :param last_executed_at_lte: The last_executed_at_lte of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_lte: str
        """

        self._last_executed_at_lte = last_executed_at_lte

    @property
    def last_executed_at_not(self):
        """Gets the last_executed_at_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_not

    @last_executed_at_not.setter
    def last_executed_at_not(self, last_executed_at_not):
        """Sets the last_executed_at_not of this EntityFilterWhereInput.


        :param last_executed_at_not: The last_executed_at_not of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_not: str
        """

        self._last_executed_at_not = last_executed_at_not

    @property
    def last_executed_at_not_in(self):
        """Gets the last_executed_at_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The last_executed_at_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_not_in

    @last_executed_at_not_in.setter
    def last_executed_at_not_in(self, last_executed_at_not_in):
        """Sets the last_executed_at_not_in of this EntityFilterWhereInput.


        :param last_executed_at_not_in: The last_executed_at_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type last_executed_at_not_in: list[str]
        """

        self._last_executed_at_not_in = last_executed_at_not_in

    @property
    def name(self):
        """Gets the name of this EntityFilterWhereInput.  # noqa: E501


        :return: The name of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EntityFilterWhereInput.


        :param name: The name of this EntityFilterWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this EntityFilterWhereInput.


        :param name_contains: The name_contains of this EntityFilterWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this EntityFilterWhereInput.


        :param name_ends_with: The name_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_gt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this EntityFilterWhereInput.


        :param name_gt: The name_gt of this EntityFilterWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_gte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this EntityFilterWhereInput.


        :param name_gte: The name_gte of this EntityFilterWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this EntityFilterWhereInput.


        :param name_in: The name_in of this EntityFilterWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_lt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this EntityFilterWhereInput.


        :param name_lt: The name_lt of this EntityFilterWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_lte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this EntityFilterWhereInput.


        :param name_lte: The name_lte of this EntityFilterWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this EntityFilterWhereInput.


        :param name_not: The name_not of this EntityFilterWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this EntityFilterWhereInput.


        :param name_not_contains: The name_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this EntityFilterWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this EntityFilterWhereInput.


        :param name_not_in: The name_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this EntityFilterWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The name_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this EntityFilterWhereInput.


        :param name_starts_with: The name_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def preset(self):
        """Gets the preset of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset

    @preset.setter
    def preset(self, preset):
        """Sets the preset of this EntityFilterWhereInput.


        :param preset: The preset of this EntityFilterWhereInput.  # noqa: E501
        :type preset: str
        """

        self._preset = preset

    @property
    def preset_contains(self):
        """Gets the preset_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_contains

    @preset_contains.setter
    def preset_contains(self, preset_contains):
        """Sets the preset_contains of this EntityFilterWhereInput.


        :param preset_contains: The preset_contains of this EntityFilterWhereInput.  # noqa: E501
        :type preset_contains: str
        """

        self._preset_contains = preset_contains

    @property
    def preset_ends_with(self):
        """Gets the preset_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_ends_with

    @preset_ends_with.setter
    def preset_ends_with(self, preset_ends_with):
        """Sets the preset_ends_with of this EntityFilterWhereInput.


        :param preset_ends_with: The preset_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type preset_ends_with: str
        """

        self._preset_ends_with = preset_ends_with

    @property
    def preset_gt(self):
        """Gets the preset_gt of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_gt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_gt

    @preset_gt.setter
    def preset_gt(self, preset_gt):
        """Sets the preset_gt of this EntityFilterWhereInput.


        :param preset_gt: The preset_gt of this EntityFilterWhereInput.  # noqa: E501
        :type preset_gt: str
        """

        self._preset_gt = preset_gt

    @property
    def preset_gte(self):
        """Gets the preset_gte of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_gte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_gte

    @preset_gte.setter
    def preset_gte(self, preset_gte):
        """Sets the preset_gte of this EntityFilterWhereInput.


        :param preset_gte: The preset_gte of this EntityFilterWhereInput.  # noqa: E501
        :type preset_gte: str
        """

        self._preset_gte = preset_gte

    @property
    def preset_in(self):
        """Gets the preset_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._preset_in

    @preset_in.setter
    def preset_in(self, preset_in):
        """Sets the preset_in of this EntityFilterWhereInput.


        :param preset_in: The preset_in of this EntityFilterWhereInput.  # noqa: E501
        :type preset_in: list[str]
        """

        self._preset_in = preset_in

    @property
    def preset_lt(self):
        """Gets the preset_lt of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_lt of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_lt

    @preset_lt.setter
    def preset_lt(self, preset_lt):
        """Sets the preset_lt of this EntityFilterWhereInput.


        :param preset_lt: The preset_lt of this EntityFilterWhereInput.  # noqa: E501
        :type preset_lt: str
        """

        self._preset_lt = preset_lt

    @property
    def preset_lte(self):
        """Gets the preset_lte of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_lte of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_lte

    @preset_lte.setter
    def preset_lte(self, preset_lte):
        """Sets the preset_lte of this EntityFilterWhereInput.


        :param preset_lte: The preset_lte of this EntityFilterWhereInput.  # noqa: E501
        :type preset_lte: str
        """

        self._preset_lte = preset_lte

    @property
    def preset_not(self):
        """Gets the preset_not of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_not of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_not

    @preset_not.setter
    def preset_not(self, preset_not):
        """Sets the preset_not of this EntityFilterWhereInput.


        :param preset_not: The preset_not of this EntityFilterWhereInput.  # noqa: E501
        :type preset_not: str
        """

        self._preset_not = preset_not

    @property
    def preset_not_contains(self):
        """Gets the preset_not_contains of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_not_contains

    @preset_not_contains.setter
    def preset_not_contains(self, preset_not_contains):
        """Sets the preset_not_contains of this EntityFilterWhereInput.


        :param preset_not_contains: The preset_not_contains of this EntityFilterWhereInput.  # noqa: E501
        :type preset_not_contains: str
        """

        self._preset_not_contains = preset_not_contains

    @property
    def preset_not_ends_with(self):
        """Gets the preset_not_ends_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_not_ends_with

    @preset_not_ends_with.setter
    def preset_not_ends_with(self, preset_not_ends_with):
        """Sets the preset_not_ends_with of this EntityFilterWhereInput.


        :param preset_not_ends_with: The preset_not_ends_with of this EntityFilterWhereInput.  # noqa: E501
        :type preset_not_ends_with: str
        """

        self._preset_not_ends_with = preset_not_ends_with

    @property
    def preset_not_in(self):
        """Gets the preset_not_in of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_not_in of this EntityFilterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._preset_not_in

    @preset_not_in.setter
    def preset_not_in(self, preset_not_in):
        """Sets the preset_not_in of this EntityFilterWhereInput.


        :param preset_not_in: The preset_not_in of this EntityFilterWhereInput.  # noqa: E501
        :type preset_not_in: list[str]
        """

        self._preset_not_in = preset_not_in

    @property
    def preset_not_starts_with(self):
        """Gets the preset_not_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_not_starts_with

    @preset_not_starts_with.setter
    def preset_not_starts_with(self, preset_not_starts_with):
        """Sets the preset_not_starts_with of this EntityFilterWhereInput.


        :param preset_not_starts_with: The preset_not_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type preset_not_starts_with: str
        """

        self._preset_not_starts_with = preset_not_starts_with

    @property
    def preset_starts_with(self):
        """Gets the preset_starts_with of this EntityFilterWhereInput.  # noqa: E501


        :return: The preset_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._preset_starts_with

    @preset_starts_with.setter
    def preset_starts_with(self, preset_starts_with):
        """Sets the preset_starts_with of this EntityFilterWhereInput.


        :param preset_starts_with: The preset_starts_with of this EntityFilterWhereInput.  # noqa: E501
        :type preset_starts_with: str
        """

        self._preset_starts_with = preset_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityFilterWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EntityFilterWhereInput):
            return True

        return self.to_dict() != other.to_dict()
