# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class EverouteClusterWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[EverouteClusterWhereInput]',
        '_not': 'list[EverouteClusterWhereInput]',
        '_or': 'list[EverouteClusterWhereInput]',
        'agent_elf_clusters_every': 'ClusterWhereInput',
        'agent_elf_clusters_none': 'ClusterWhereInput',
        'agent_elf_clusters_some': 'ClusterWhereInput',
        'agent_elf_vdses_every': 'VdsWhereInput',
        'agent_elf_vdses_none': 'VdsWhereInput',
        'agent_elf_vdses_some': 'VdsWhereInput',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'global_default_action': 'GlobalPolicyAction',
        'global_default_action_in': 'list[GlobalPolicyAction]',
        'global_default_action_not': 'GlobalPolicyAction',
        'global_default_action_not_in': 'list[GlobalPolicyAction]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'installed': 'bool',
        'installed_not': 'bool',
        'load_balancer_service': 'LoadBalancerServiceWhereInput',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'phase': 'EverouteClusterPhase',
        'phase_in': 'list[EverouteClusterPhase]',
        'phase_not': 'EverouteClusterPhase',
        'phase_not_in': 'list[EverouteClusterPhase]',
        'version': 'str',
        'version_contains': 'str',
        'version_ends_with': 'str',
        'version_gt': 'str',
        'version_gte': 'str',
        'version_in': 'list[str]',
        'version_lt': 'str',
        'version_lte': 'str',
        'version_not': 'str',
        'version_not_contains': 'str',
        'version_not_ends_with': 'str',
        'version_not_in': 'list[str]',
        'version_not_starts_with': 'str',
        'version_starts_with': 'str',
        'vpc_service': 'VirtualPrivateCloudServiceWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'agent_elf_clusters_every': 'agent_elf_clusters_every',
        'agent_elf_clusters_none': 'agent_elf_clusters_none',
        'agent_elf_clusters_some': 'agent_elf_clusters_some',
        'agent_elf_vdses_every': 'agent_elf_vdses_every',
        'agent_elf_vdses_none': 'agent_elf_vdses_none',
        'agent_elf_vdses_some': 'agent_elf_vdses_some',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'global_default_action': 'global_default_action',
        'global_default_action_in': 'global_default_action_in',
        'global_default_action_not': 'global_default_action_not',
        'global_default_action_not_in': 'global_default_action_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'installed': 'installed',
        'installed_not': 'installed_not',
        'load_balancer_service': 'load_balancer_service',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'version': 'version',
        'version_contains': 'version_contains',
        'version_ends_with': 'version_ends_with',
        'version_gt': 'version_gt',
        'version_gte': 'version_gte',
        'version_in': 'version_in',
        'version_lt': 'version_lt',
        'version_lte': 'version_lte',
        'version_not': 'version_not',
        'version_not_contains': 'version_not_contains',
        'version_not_ends_with': 'version_not_ends_with',
        'version_not_in': 'version_not_in',
        'version_not_starts_with': 'version_not_starts_with',
        'version_starts_with': 'version_starts_with',
        'vpc_service': 'vpc_service'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """EverouteClusterWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._agent_elf_clusters_every = None
        self._agent_elf_clusters_none = None
        self._agent_elf_clusters_some = None
        self._agent_elf_vdses_every = None
        self._agent_elf_vdses_none = None
        self._agent_elf_vdses_some = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._global_default_action = None
        self._global_default_action_in = None
        self._global_default_action_not = None
        self._global_default_action_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._installed = None
        self._installed_not = None
        self._load_balancer_service = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._version = None
        self._version_contains = None
        self._version_ends_with = None
        self._version_gt = None
        self._version_gte = None
        self._version_in = None
        self._version_lt = None
        self._version_lte = None
        self._version_not = None
        self._version_not_contains = None
        self._version_not_ends_with = None
        self._version_not_in = None
        self._version_not_starts_with = None
        self._version_starts_with = None
        self._vpc_service = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.agent_elf_clusters_every = kwargs.get("agent_elf_clusters_every", None)
        self.agent_elf_clusters_none = kwargs.get("agent_elf_clusters_none", None)
        self.agent_elf_clusters_some = kwargs.get("agent_elf_clusters_some", None)
        self.agent_elf_vdses_every = kwargs.get("agent_elf_vdses_every", None)
        self.agent_elf_vdses_none = kwargs.get("agent_elf_vdses_none", None)
        self.agent_elf_vdses_some = kwargs.get("agent_elf_vdses_some", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.global_default_action = kwargs.get("global_default_action", None)
        self.global_default_action_in = kwargs.get("global_default_action_in", None)
        self.global_default_action_not = kwargs.get("global_default_action_not", None)
        self.global_default_action_not_in = kwargs.get("global_default_action_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.installed = kwargs.get("installed", None)
        self.installed_not = kwargs.get("installed_not", None)
        self.load_balancer_service = kwargs.get("load_balancer_service", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.version = kwargs.get("version", None)
        self.version_contains = kwargs.get("version_contains", None)
        self.version_ends_with = kwargs.get("version_ends_with", None)
        self.version_gt = kwargs.get("version_gt", None)
        self.version_gte = kwargs.get("version_gte", None)
        self.version_in = kwargs.get("version_in", None)
        self.version_lt = kwargs.get("version_lt", None)
        self.version_lte = kwargs.get("version_lte", None)
        self.version_not = kwargs.get("version_not", None)
        self.version_not_contains = kwargs.get("version_not_contains", None)
        self.version_not_ends_with = kwargs.get("version_not_ends_with", None)
        self.version_not_in = kwargs.get("version_not_in", None)
        self.version_not_starts_with = kwargs.get("version_not_starts_with", None)
        self.version_starts_with = kwargs.get("version_starts_with", None)
        self.vpc_service = kwargs.get("vpc_service", None)

    @property
    def _and(self):
        """Gets the _and of this EverouteClusterWhereInput.  # noqa: E501


        :return: The _and of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this EverouteClusterWhereInput.


        :param _and: The _and of this EverouteClusterWhereInput.  # noqa: E501
        :type _and: list[EverouteClusterWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The _not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this EverouteClusterWhereInput.


        :param _not: The _not of this EverouteClusterWhereInput.  # noqa: E501
        :type _not: list[EverouteClusterWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this EverouteClusterWhereInput.  # noqa: E501


        :return: The _or of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this EverouteClusterWhereInput.


        :param _or: The _or of this EverouteClusterWhereInput.  # noqa: E501
        :type _or: list[EverouteClusterWhereInput]
        """

        self.__or = _or

    @property
    def agent_elf_clusters_every(self):
        """Gets the agent_elf_clusters_every of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_clusters_every of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._agent_elf_clusters_every

    @agent_elf_clusters_every.setter
    def agent_elf_clusters_every(self, agent_elf_clusters_every):
        """Sets the agent_elf_clusters_every of this EverouteClusterWhereInput.


        :param agent_elf_clusters_every: The agent_elf_clusters_every of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_clusters_every: ClusterWhereInput
        """

        self._agent_elf_clusters_every = agent_elf_clusters_every

    @property
    def agent_elf_clusters_none(self):
        """Gets the agent_elf_clusters_none of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_clusters_none of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._agent_elf_clusters_none

    @agent_elf_clusters_none.setter
    def agent_elf_clusters_none(self, agent_elf_clusters_none):
        """Sets the agent_elf_clusters_none of this EverouteClusterWhereInput.


        :param agent_elf_clusters_none: The agent_elf_clusters_none of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_clusters_none: ClusterWhereInput
        """

        self._agent_elf_clusters_none = agent_elf_clusters_none

    @property
    def agent_elf_clusters_some(self):
        """Gets the agent_elf_clusters_some of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_clusters_some of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._agent_elf_clusters_some

    @agent_elf_clusters_some.setter
    def agent_elf_clusters_some(self, agent_elf_clusters_some):
        """Sets the agent_elf_clusters_some of this EverouteClusterWhereInput.


        :param agent_elf_clusters_some: The agent_elf_clusters_some of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_clusters_some: ClusterWhereInput
        """

        self._agent_elf_clusters_some = agent_elf_clusters_some

    @property
    def agent_elf_vdses_every(self):
        """Gets the agent_elf_vdses_every of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_vdses_every of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: VdsWhereInput
        """
        return self._agent_elf_vdses_every

    @agent_elf_vdses_every.setter
    def agent_elf_vdses_every(self, agent_elf_vdses_every):
        """Sets the agent_elf_vdses_every of this EverouteClusterWhereInput.


        :param agent_elf_vdses_every: The agent_elf_vdses_every of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_vdses_every: VdsWhereInput
        """

        self._agent_elf_vdses_every = agent_elf_vdses_every

    @property
    def agent_elf_vdses_none(self):
        """Gets the agent_elf_vdses_none of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_vdses_none of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: VdsWhereInput
        """
        return self._agent_elf_vdses_none

    @agent_elf_vdses_none.setter
    def agent_elf_vdses_none(self, agent_elf_vdses_none):
        """Sets the agent_elf_vdses_none of this EverouteClusterWhereInput.


        :param agent_elf_vdses_none: The agent_elf_vdses_none of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_vdses_none: VdsWhereInput
        """

        self._agent_elf_vdses_none = agent_elf_vdses_none

    @property
    def agent_elf_vdses_some(self):
        """Gets the agent_elf_vdses_some of this EverouteClusterWhereInput.  # noqa: E501


        :return: The agent_elf_vdses_some of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: VdsWhereInput
        """
        return self._agent_elf_vdses_some

    @agent_elf_vdses_some.setter
    def agent_elf_vdses_some(self, agent_elf_vdses_some):
        """Sets the agent_elf_vdses_some of this EverouteClusterWhereInput.


        :param agent_elf_vdses_some: The agent_elf_vdses_some of this EverouteClusterWhereInput.  # noqa: E501
        :type agent_elf_vdses_some: VdsWhereInput
        """

        self._agent_elf_vdses_some = agent_elf_vdses_some

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this EverouteClusterWhereInput.  # noqa: E501


        :return: The entity_async_status of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this EverouteClusterWhereInput.


        :param entity_async_status: The entity_async_status of this EverouteClusterWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this EverouteClusterWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this EverouteClusterWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this EverouteClusterWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this EverouteClusterWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this EverouteClusterWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def global_default_action(self):
        """Gets the global_default_action of this EverouteClusterWhereInput.  # noqa: E501


        :return: The global_default_action of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: GlobalPolicyAction
        """
        return self._global_default_action

    @global_default_action.setter
    def global_default_action(self, global_default_action):
        """Sets the global_default_action of this EverouteClusterWhereInput.


        :param global_default_action: The global_default_action of this EverouteClusterWhereInput.  # noqa: E501
        :type global_default_action: GlobalPolicyAction
        """

        self._global_default_action = global_default_action

    @property
    def global_default_action_in(self):
        """Gets the global_default_action_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The global_default_action_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[GlobalPolicyAction]
        """
        return self._global_default_action_in

    @global_default_action_in.setter
    def global_default_action_in(self, global_default_action_in):
        """Sets the global_default_action_in of this EverouteClusterWhereInput.


        :param global_default_action_in: The global_default_action_in of this EverouteClusterWhereInput.  # noqa: E501
        :type global_default_action_in: list[GlobalPolicyAction]
        """

        self._global_default_action_in = global_default_action_in

    @property
    def global_default_action_not(self):
        """Gets the global_default_action_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The global_default_action_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: GlobalPolicyAction
        """
        return self._global_default_action_not

    @global_default_action_not.setter
    def global_default_action_not(self, global_default_action_not):
        """Sets the global_default_action_not of this EverouteClusterWhereInput.


        :param global_default_action_not: The global_default_action_not of this EverouteClusterWhereInput.  # noqa: E501
        :type global_default_action_not: GlobalPolicyAction
        """

        self._global_default_action_not = global_default_action_not

    @property
    def global_default_action_not_in(self):
        """Gets the global_default_action_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The global_default_action_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[GlobalPolicyAction]
        """
        return self._global_default_action_not_in

    @global_default_action_not_in.setter
    def global_default_action_not_in(self, global_default_action_not_in):
        """Sets the global_default_action_not_in of this EverouteClusterWhereInput.


        :param global_default_action_not_in: The global_default_action_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type global_default_action_not_in: list[GlobalPolicyAction]
        """

        self._global_default_action_not_in = global_default_action_not_in

    @property
    def id(self):
        """Gets the id of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EverouteClusterWhereInput.


        :param id: The id of this EverouteClusterWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this EverouteClusterWhereInput.


        :param id_contains: The id_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this EverouteClusterWhereInput.


        :param id_ends_with: The id_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_gt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this EverouteClusterWhereInput.


        :param id_gt: The id_gt of this EverouteClusterWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_gte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this EverouteClusterWhereInput.


        :param id_gte: The id_gte of this EverouteClusterWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this EverouteClusterWhereInput.


        :param id_in: The id_in of this EverouteClusterWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_lt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this EverouteClusterWhereInput.


        :param id_lt: The id_lt of this EverouteClusterWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_lte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this EverouteClusterWhereInput.


        :param id_lte: The id_lte of this EverouteClusterWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this EverouteClusterWhereInput.


        :param id_not: The id_not of this EverouteClusterWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this EverouteClusterWhereInput.


        :param id_not_contains: The id_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this EverouteClusterWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this EverouteClusterWhereInput.


        :param id_not_in: The id_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this EverouteClusterWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The id_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this EverouteClusterWhereInput.


        :param id_starts_with: The id_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def installed(self):
        """Gets the installed of this EverouteClusterWhereInput.  # noqa: E501


        :return: The installed of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._installed

    @installed.setter
    def installed(self, installed):
        """Sets the installed of this EverouteClusterWhereInput.


        :param installed: The installed of this EverouteClusterWhereInput.  # noqa: E501
        :type installed: bool
        """

        self._installed = installed

    @property
    def installed_not(self):
        """Gets the installed_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The installed_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._installed_not

    @installed_not.setter
    def installed_not(self, installed_not):
        """Sets the installed_not of this EverouteClusterWhereInput.


        :param installed_not: The installed_not of this EverouteClusterWhereInput.  # noqa: E501
        :type installed_not: bool
        """

        self._installed_not = installed_not

    @property
    def load_balancer_service(self):
        """Gets the load_balancer_service of this EverouteClusterWhereInput.  # noqa: E501


        :return: The load_balancer_service of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: LoadBalancerServiceWhereInput
        """
        return self._load_balancer_service

    @load_balancer_service.setter
    def load_balancer_service(self, load_balancer_service):
        """Sets the load_balancer_service of this EverouteClusterWhereInput.


        :param load_balancer_service: The load_balancer_service of this EverouteClusterWhereInput.  # noqa: E501
        :type load_balancer_service: LoadBalancerServiceWhereInput
        """

        self._load_balancer_service = load_balancer_service

    @property
    def name(self):
        """Gets the name of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EverouteClusterWhereInput.


        :param name: The name of this EverouteClusterWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this EverouteClusterWhereInput.


        :param name_contains: The name_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this EverouteClusterWhereInput.


        :param name_ends_with: The name_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_gt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this EverouteClusterWhereInput.


        :param name_gt: The name_gt of this EverouteClusterWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_gte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this EverouteClusterWhereInput.


        :param name_gte: The name_gte of this EverouteClusterWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this EverouteClusterWhereInput.


        :param name_in: The name_in of this EverouteClusterWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_lt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this EverouteClusterWhereInput.


        :param name_lt: The name_lt of this EverouteClusterWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_lte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this EverouteClusterWhereInput.


        :param name_lte: The name_lte of this EverouteClusterWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this EverouteClusterWhereInput.


        :param name_not: The name_not of this EverouteClusterWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this EverouteClusterWhereInput.


        :param name_not_contains: The name_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this EverouteClusterWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this EverouteClusterWhereInput.


        :param name_not_in: The name_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this EverouteClusterWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The name_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this EverouteClusterWhereInput.


        :param name_starts_with: The name_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def phase(self):
        """Gets the phase of this EverouteClusterWhereInput.  # noqa: E501


        :return: The phase of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this EverouteClusterWhereInput.


        :param phase: The phase of this EverouteClusterWhereInput.  # noqa: E501
        :type phase: EverouteClusterPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The phase_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this EverouteClusterWhereInput.


        :param phase_in: The phase_in of this EverouteClusterWhereInput.  # noqa: E501
        :type phase_in: list[EverouteClusterPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The phase_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this EverouteClusterWhereInput.


        :param phase_not: The phase_not of this EverouteClusterWhereInput.  # noqa: E501
        :type phase_not: EverouteClusterPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The phase_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this EverouteClusterWhereInput.


        :param phase_not_in: The phase_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type phase_not_in: list[EverouteClusterPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def version(self):
        """Gets the version of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this EverouteClusterWhereInput.


        :param version: The version of this EverouteClusterWhereInput.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def version_contains(self):
        """Gets the version_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_contains

    @version_contains.setter
    def version_contains(self, version_contains):
        """Sets the version_contains of this EverouteClusterWhereInput.


        :param version_contains: The version_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type version_contains: str
        """

        self._version_contains = version_contains

    @property
    def version_ends_with(self):
        """Gets the version_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_ends_with

    @version_ends_with.setter
    def version_ends_with(self, version_ends_with):
        """Sets the version_ends_with of this EverouteClusterWhereInput.


        :param version_ends_with: The version_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type version_ends_with: str
        """

        self._version_ends_with = version_ends_with

    @property
    def version_gt(self):
        """Gets the version_gt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_gt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gt

    @version_gt.setter
    def version_gt(self, version_gt):
        """Sets the version_gt of this EverouteClusterWhereInput.


        :param version_gt: The version_gt of this EverouteClusterWhereInput.  # noqa: E501
        :type version_gt: str
        """

        self._version_gt = version_gt

    @property
    def version_gte(self):
        """Gets the version_gte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_gte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gte

    @version_gte.setter
    def version_gte(self, version_gte):
        """Sets the version_gte of this EverouteClusterWhereInput.


        :param version_gte: The version_gte of this EverouteClusterWhereInput.  # noqa: E501
        :type version_gte: str
        """

        self._version_gte = version_gte

    @property
    def version_in(self):
        """Gets the version_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_in

    @version_in.setter
    def version_in(self, version_in):
        """Sets the version_in of this EverouteClusterWhereInput.


        :param version_in: The version_in of this EverouteClusterWhereInput.  # noqa: E501
        :type version_in: list[str]
        """

        self._version_in = version_in

    @property
    def version_lt(self):
        """Gets the version_lt of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_lt of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lt

    @version_lt.setter
    def version_lt(self, version_lt):
        """Sets the version_lt of this EverouteClusterWhereInput.


        :param version_lt: The version_lt of this EverouteClusterWhereInput.  # noqa: E501
        :type version_lt: str
        """

        self._version_lt = version_lt

    @property
    def version_lte(self):
        """Gets the version_lte of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_lte of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lte

    @version_lte.setter
    def version_lte(self, version_lte):
        """Sets the version_lte of this EverouteClusterWhereInput.


        :param version_lte: The version_lte of this EverouteClusterWhereInput.  # noqa: E501
        :type version_lte: str
        """

        self._version_lte = version_lte

    @property
    def version_not(self):
        """Gets the version_not of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_not of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not

    @version_not.setter
    def version_not(self, version_not):
        """Sets the version_not of this EverouteClusterWhereInput.


        :param version_not: The version_not of this EverouteClusterWhereInput.  # noqa: E501
        :type version_not: str
        """

        self._version_not = version_not

    @property
    def version_not_contains(self):
        """Gets the version_not_contains of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_contains

    @version_not_contains.setter
    def version_not_contains(self, version_not_contains):
        """Sets the version_not_contains of this EverouteClusterWhereInput.


        :param version_not_contains: The version_not_contains of this EverouteClusterWhereInput.  # noqa: E501
        :type version_not_contains: str
        """

        self._version_not_contains = version_not_contains

    @property
    def version_not_ends_with(self):
        """Gets the version_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_ends_with

    @version_not_ends_with.setter
    def version_not_ends_with(self, version_not_ends_with):
        """Sets the version_not_ends_with of this EverouteClusterWhereInput.


        :param version_not_ends_with: The version_not_ends_with of this EverouteClusterWhereInput.  # noqa: E501
        :type version_not_ends_with: str
        """

        self._version_not_ends_with = version_not_ends_with

    @property
    def version_not_in(self):
        """Gets the version_not_in of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_not_in

    @version_not_in.setter
    def version_not_in(self, version_not_in):
        """Sets the version_not_in of this EverouteClusterWhereInput.


        :param version_not_in: The version_not_in of this EverouteClusterWhereInput.  # noqa: E501
        :type version_not_in: list[str]
        """

        self._version_not_in = version_not_in

    @property
    def version_not_starts_with(self):
        """Gets the version_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_starts_with

    @version_not_starts_with.setter
    def version_not_starts_with(self, version_not_starts_with):
        """Sets the version_not_starts_with of this EverouteClusterWhereInput.


        :param version_not_starts_with: The version_not_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type version_not_starts_with: str
        """

        self._version_not_starts_with = version_not_starts_with

    @property
    def version_starts_with(self):
        """Gets the version_starts_with of this EverouteClusterWhereInput.  # noqa: E501


        :return: The version_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_starts_with

    @version_starts_with.setter
    def version_starts_with(self, version_starts_with):
        """Sets the version_starts_with of this EverouteClusterWhereInput.


        :param version_starts_with: The version_starts_with of this EverouteClusterWhereInput.  # noqa: E501
        :type version_starts_with: str
        """

        self._version_starts_with = version_starts_with

    @property
    def vpc_service(self):
        """Gets the vpc_service of this EverouteClusterWhereInput.  # noqa: E501


        :return: The vpc_service of this EverouteClusterWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudServiceWhereInput
        """
        return self._vpc_service

    @vpc_service.setter
    def vpc_service(self, vpc_service):
        """Sets the vpc_service of this EverouteClusterWhereInput.


        :param vpc_service: The vpc_service of this EverouteClusterWhereInput.  # noqa: E501
        :type vpc_service: VirtualPrivateCloudServiceWhereInput
        """

        self._vpc_service = vpc_service

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EverouteClusterWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EverouteClusterWhereInput):
            return True

        return self.to_dict() != other.to_dict()
