# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ExitMaintenanceModeInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'poweron_vms': 'list[str]',
        'offline_migrate_back_vms': 'list[str]',
        'live_migrate_back_vms': 'list[str]'
    }

    attribute_map = {
        'poweron_vms': 'poweron_vms',
        'offline_migrate_back_vms': 'offline_migrate_back_vms',
        'live_migrate_back_vms': 'live_migrate_back_vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ExitMaintenanceModeInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._poweron_vms = None
        self._offline_migrate_back_vms = None
        self._live_migrate_back_vms = None
        self.discriminator = None

        if "poweron_vms" in kwargs:
            self.poweron_vms = kwargs["poweron_vms"]
        if "offline_migrate_back_vms" in kwargs:
            self.offline_migrate_back_vms = kwargs["offline_migrate_back_vms"]
        if "live_migrate_back_vms" in kwargs:
            self.live_migrate_back_vms = kwargs["live_migrate_back_vms"]

    @property
    def poweron_vms(self):
        """Gets the poweron_vms of this ExitMaintenanceModeInput.  # noqa: E501


        :return: The poweron_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._poweron_vms

    @poweron_vms.setter
    def poweron_vms(self, poweron_vms):
        """Sets the poweron_vms of this ExitMaintenanceModeInput.


        :param poweron_vms: The poweron_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :type poweron_vms: list[str]
        """

        self._poweron_vms = poweron_vms

    @property
    def offline_migrate_back_vms(self):
        """Gets the offline_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501


        :return: The offline_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._offline_migrate_back_vms

    @offline_migrate_back_vms.setter
    def offline_migrate_back_vms(self, offline_migrate_back_vms):
        """Sets the offline_migrate_back_vms of this ExitMaintenanceModeInput.


        :param offline_migrate_back_vms: The offline_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :type offline_migrate_back_vms: list[str]
        """

        self._offline_migrate_back_vms = offline_migrate_back_vms

    @property
    def live_migrate_back_vms(self):
        """Gets the live_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501


        :return: The live_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._live_migrate_back_vms

    @live_migrate_back_vms.setter
    def live_migrate_back_vms(self, live_migrate_back_vms):
        """Sets the live_migrate_back_vms of this ExitMaintenanceModeInput.


        :param live_migrate_back_vms: The live_migrate_back_vms of this ExitMaintenanceModeInput.  # noqa: E501
        :type live_migrate_back_vms: list[str]
        """

        self._live_migrate_back_vms = live_migrate_back_vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExitMaintenanceModeInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExitMaintenanceModeInput):
            return True

        return self.to_dict() != other.to_dict()
