# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class FailoverExecutionWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[FailoverExecutionWhereInput]',
        '_not': 'list[FailoverExecutionWhereInput]',
        '_or': 'list[FailoverExecutionWhereInput]',
        'created_at': 'str',
        'created_at_gt': 'str',
        'created_at_gte': 'str',
        'created_at_in': 'list[str]',
        'created_at_lt': 'str',
        'created_at_lte': 'str',
        'created_at_not': 'str',
        'created_at_not_in': 'list[str]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'external_cloudtower': 'ExternalCloudTowerWhereInput',
        'finished_at': 'str',
        'finished_at_gt': 'str',
        'finished_at_gte': 'str',
        'finished_at_in': 'list[str]',
        'finished_at_lt': 'str',
        'finished_at_lte': 'str',
        'finished_at_not': 'str',
        'finished_at_not_in': 'list[str]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'is_test_mode': 'bool',
        'is_test_mode_not': 'bool',
        'replication_failover_target_executions_every': 'ReplicationFailoverTargetExecutionWhereInput',
        'replication_failover_target_executions_none': 'ReplicationFailoverTargetExecutionWhereInput',
        'replication_failover_target_executions_some': 'ReplicationFailoverTargetExecutionWhereInput',
        'replication_service': 'ReplicationServiceWhereInput',
        'resource_version': 'int',
        'resource_version_gt': 'int',
        'resource_version_gte': 'int',
        'resource_version_in': 'list[int]',
        'resource_version_lt': 'int',
        'resource_version_lte': 'int',
        'resource_version_not': 'int',
        'resource_version_not_in': 'list[int]',
        'shutdown_mode': 'FailoverShutdownMode',
        'shutdown_mode_in': 'list[FailoverShutdownMode]',
        'shutdown_mode_not': 'FailoverShutdownMode',
        'shutdown_mode_not_in': 'list[FailoverShutdownMode]',
        'state': 'BackupExecutionState',
        'state_in': 'list[BackupExecutionState]',
        'state_not': 'BackupExecutionState',
        'state_not_in': 'list[BackupExecutionState]',
        'success_job_count': 'int',
        'success_job_count_gt': 'int',
        'success_job_count_gte': 'int',
        'success_job_count_in': 'list[int]',
        'success_job_count_lt': 'int',
        'success_job_count_lte': 'int',
        'success_job_count_not': 'int',
        'success_job_count_not_in': 'list[int]',
        'total_job_count': 'int',
        'total_job_count_gt': 'int',
        'total_job_count_gte': 'int',
        'total_job_count_in': 'list[int]',
        'total_job_count_lt': 'int',
        'total_job_count_lte': 'int',
        'total_job_count_not': 'int',
        'total_job_count_not_in': 'list[int]',
        'updated_at': 'str',
        'updated_at_gt': 'str',
        'updated_at_gte': 'str',
        'updated_at_in': 'list[str]',
        'updated_at_lt': 'str',
        'updated_at_lte': 'str',
        'updated_at_not': 'str',
        'updated_at_not_in': 'list[str]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'created_at': 'createdAt',
        'created_at_gt': 'createdAt_gt',
        'created_at_gte': 'createdAt_gte',
        'created_at_in': 'createdAt_in',
        'created_at_lt': 'createdAt_lt',
        'created_at_lte': 'createdAt_lte',
        'created_at_not': 'createdAt_not',
        'created_at_not_in': 'createdAt_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'external_cloudtower': 'external_cloudtower',
        'finished_at': 'finished_at',
        'finished_at_gt': 'finished_at_gt',
        'finished_at_gte': 'finished_at_gte',
        'finished_at_in': 'finished_at_in',
        'finished_at_lt': 'finished_at_lt',
        'finished_at_lte': 'finished_at_lte',
        'finished_at_not': 'finished_at_not',
        'finished_at_not_in': 'finished_at_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'is_test_mode': 'is_test_mode',
        'is_test_mode_not': 'is_test_mode_not',
        'replication_failover_target_executions_every': 'replication_failover_target_executions_every',
        'replication_failover_target_executions_none': 'replication_failover_target_executions_none',
        'replication_failover_target_executions_some': 'replication_failover_target_executions_some',
        'replication_service': 'replication_service',
        'resource_version': 'resource_version',
        'resource_version_gt': 'resource_version_gt',
        'resource_version_gte': 'resource_version_gte',
        'resource_version_in': 'resource_version_in',
        'resource_version_lt': 'resource_version_lt',
        'resource_version_lte': 'resource_version_lte',
        'resource_version_not': 'resource_version_not',
        'resource_version_not_in': 'resource_version_not_in',
        'shutdown_mode': 'shutdown_mode',
        'shutdown_mode_in': 'shutdown_mode_in',
        'shutdown_mode_not': 'shutdown_mode_not',
        'shutdown_mode_not_in': 'shutdown_mode_not_in',
        'state': 'state',
        'state_in': 'state_in',
        'state_not': 'state_not',
        'state_not_in': 'state_not_in',
        'success_job_count': 'success_job_count',
        'success_job_count_gt': 'success_job_count_gt',
        'success_job_count_gte': 'success_job_count_gte',
        'success_job_count_in': 'success_job_count_in',
        'success_job_count_lt': 'success_job_count_lt',
        'success_job_count_lte': 'success_job_count_lte',
        'success_job_count_not': 'success_job_count_not',
        'success_job_count_not_in': 'success_job_count_not_in',
        'total_job_count': 'total_job_count',
        'total_job_count_gt': 'total_job_count_gt',
        'total_job_count_gte': 'total_job_count_gte',
        'total_job_count_in': 'total_job_count_in',
        'total_job_count_lt': 'total_job_count_lt',
        'total_job_count_lte': 'total_job_count_lte',
        'total_job_count_not': 'total_job_count_not',
        'total_job_count_not_in': 'total_job_count_not_in',
        'updated_at': 'updatedAt',
        'updated_at_gt': 'updatedAt_gt',
        'updated_at_gte': 'updatedAt_gte',
        'updated_at_in': 'updatedAt_in',
        'updated_at_lt': 'updatedAt_lt',
        'updated_at_lte': 'updatedAt_lte',
        'updated_at_not': 'updatedAt_not',
        'updated_at_not_in': 'updatedAt_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """FailoverExecutionWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._created_at = None
        self._created_at_gt = None
        self._created_at_gte = None
        self._created_at_in = None
        self._created_at_lt = None
        self._created_at_lte = None
        self._created_at_not = None
        self._created_at_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._external_cloudtower = None
        self._finished_at = None
        self._finished_at_gt = None
        self._finished_at_gte = None
        self._finished_at_in = None
        self._finished_at_lt = None
        self._finished_at_lte = None
        self._finished_at_not = None
        self._finished_at_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._is_test_mode = None
        self._is_test_mode_not = None
        self._replication_failover_target_executions_every = None
        self._replication_failover_target_executions_none = None
        self._replication_failover_target_executions_some = None
        self._replication_service = None
        self._resource_version = None
        self._resource_version_gt = None
        self._resource_version_gte = None
        self._resource_version_in = None
        self._resource_version_lt = None
        self._resource_version_lte = None
        self._resource_version_not = None
        self._resource_version_not_in = None
        self._shutdown_mode = None
        self._shutdown_mode_in = None
        self._shutdown_mode_not = None
        self._shutdown_mode_not_in = None
        self._state = None
        self._state_in = None
        self._state_not = None
        self._state_not_in = None
        self._success_job_count = None
        self._success_job_count_gt = None
        self._success_job_count_gte = None
        self._success_job_count_in = None
        self._success_job_count_lt = None
        self._success_job_count_lte = None
        self._success_job_count_not = None
        self._success_job_count_not_in = None
        self._total_job_count = None
        self._total_job_count_gt = None
        self._total_job_count_gte = None
        self._total_job_count_in = None
        self._total_job_count_lt = None
        self._total_job_count_lte = None
        self._total_job_count_not = None
        self._total_job_count_not_in = None
        self._updated_at = None
        self._updated_at_gt = None
        self._updated_at_gte = None
        self._updated_at_in = None
        self._updated_at_lt = None
        self._updated_at_lte = None
        self._updated_at_not = None
        self._updated_at_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.created_at = kwargs.get("created_at", None)
        self.created_at_gt = kwargs.get("created_at_gt", None)
        self.created_at_gte = kwargs.get("created_at_gte", None)
        self.created_at_in = kwargs.get("created_at_in", None)
        self.created_at_lt = kwargs.get("created_at_lt", None)
        self.created_at_lte = kwargs.get("created_at_lte", None)
        self.created_at_not = kwargs.get("created_at_not", None)
        self.created_at_not_in = kwargs.get("created_at_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.external_cloudtower = kwargs.get("external_cloudtower", None)
        self.finished_at = kwargs.get("finished_at", None)
        self.finished_at_gt = kwargs.get("finished_at_gt", None)
        self.finished_at_gte = kwargs.get("finished_at_gte", None)
        self.finished_at_in = kwargs.get("finished_at_in", None)
        self.finished_at_lt = kwargs.get("finished_at_lt", None)
        self.finished_at_lte = kwargs.get("finished_at_lte", None)
        self.finished_at_not = kwargs.get("finished_at_not", None)
        self.finished_at_not_in = kwargs.get("finished_at_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.is_test_mode = kwargs.get("is_test_mode", None)
        self.is_test_mode_not = kwargs.get("is_test_mode_not", None)
        self.replication_failover_target_executions_every = kwargs.get("replication_failover_target_executions_every", None)
        self.replication_failover_target_executions_none = kwargs.get("replication_failover_target_executions_none", None)
        self.replication_failover_target_executions_some = kwargs.get("replication_failover_target_executions_some", None)
        self.replication_service = kwargs.get("replication_service", None)
        self.resource_version = kwargs.get("resource_version", None)
        self.resource_version_gt = kwargs.get("resource_version_gt", None)
        self.resource_version_gte = kwargs.get("resource_version_gte", None)
        self.resource_version_in = kwargs.get("resource_version_in", None)
        self.resource_version_lt = kwargs.get("resource_version_lt", None)
        self.resource_version_lte = kwargs.get("resource_version_lte", None)
        self.resource_version_not = kwargs.get("resource_version_not", None)
        self.resource_version_not_in = kwargs.get("resource_version_not_in", None)
        self.shutdown_mode = kwargs.get("shutdown_mode", None)
        self.shutdown_mode_in = kwargs.get("shutdown_mode_in", None)
        self.shutdown_mode_not = kwargs.get("shutdown_mode_not", None)
        self.shutdown_mode_not_in = kwargs.get("shutdown_mode_not_in", None)
        self.state = kwargs.get("state", None)
        self.state_in = kwargs.get("state_in", None)
        self.state_not = kwargs.get("state_not", None)
        self.state_not_in = kwargs.get("state_not_in", None)
        self.success_job_count = kwargs.get("success_job_count", None)
        self.success_job_count_gt = kwargs.get("success_job_count_gt", None)
        self.success_job_count_gte = kwargs.get("success_job_count_gte", None)
        self.success_job_count_in = kwargs.get("success_job_count_in", None)
        self.success_job_count_lt = kwargs.get("success_job_count_lt", None)
        self.success_job_count_lte = kwargs.get("success_job_count_lte", None)
        self.success_job_count_not = kwargs.get("success_job_count_not", None)
        self.success_job_count_not_in = kwargs.get("success_job_count_not_in", None)
        self.total_job_count = kwargs.get("total_job_count", None)
        self.total_job_count_gt = kwargs.get("total_job_count_gt", None)
        self.total_job_count_gte = kwargs.get("total_job_count_gte", None)
        self.total_job_count_in = kwargs.get("total_job_count_in", None)
        self.total_job_count_lt = kwargs.get("total_job_count_lt", None)
        self.total_job_count_lte = kwargs.get("total_job_count_lte", None)
        self.total_job_count_not = kwargs.get("total_job_count_not", None)
        self.total_job_count_not_in = kwargs.get("total_job_count_not_in", None)
        self.updated_at = kwargs.get("updated_at", None)
        self.updated_at_gt = kwargs.get("updated_at_gt", None)
        self.updated_at_gte = kwargs.get("updated_at_gte", None)
        self.updated_at_in = kwargs.get("updated_at_in", None)
        self.updated_at_lt = kwargs.get("updated_at_lt", None)
        self.updated_at_lte = kwargs.get("updated_at_lte", None)
        self.updated_at_not = kwargs.get("updated_at_not", None)
        self.updated_at_not_in = kwargs.get("updated_at_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The _and of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[FailoverExecutionWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this FailoverExecutionWhereInput.


        :param _and: The _and of this FailoverExecutionWhereInput.  # noqa: E501
        :type _and: list[FailoverExecutionWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The _not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[FailoverExecutionWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this FailoverExecutionWhereInput.


        :param _not: The _not of this FailoverExecutionWhereInput.  # noqa: E501
        :type _not: list[FailoverExecutionWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The _or of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[FailoverExecutionWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this FailoverExecutionWhereInput.


        :param _or: The _or of this FailoverExecutionWhereInput.  # noqa: E501
        :type _or: list[FailoverExecutionWhereInput]
        """

        self.__or = _or

    @property
    def created_at(self):
        """Gets the created_at of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this FailoverExecutionWhereInput.


        :param created_at: The created_at of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_at_gt(self):
        """Gets the created_at_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gt

    @created_at_gt.setter
    def created_at_gt(self, created_at_gt):
        """Sets the created_at_gt of this FailoverExecutionWhereInput.


        :param created_at_gt: The created_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_gt: str
        """

        self._created_at_gt = created_at_gt

    @property
    def created_at_gte(self):
        """Gets the created_at_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gte

    @created_at_gte.setter
    def created_at_gte(self, created_at_gte):
        """Sets the created_at_gte of this FailoverExecutionWhereInput.


        :param created_at_gte: The created_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_gte: str
        """

        self._created_at_gte = created_at_gte

    @property
    def created_at_in(self):
        """Gets the created_at_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_in

    @created_at_in.setter
    def created_at_in(self, created_at_in):
        """Sets the created_at_in of this FailoverExecutionWhereInput.


        :param created_at_in: The created_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_in: list[str]
        """

        self._created_at_in = created_at_in

    @property
    def created_at_lt(self):
        """Gets the created_at_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lt

    @created_at_lt.setter
    def created_at_lt(self, created_at_lt):
        """Sets the created_at_lt of this FailoverExecutionWhereInput.


        :param created_at_lt: The created_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_lt: str
        """

        self._created_at_lt = created_at_lt

    @property
    def created_at_lte(self):
        """Gets the created_at_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lte

    @created_at_lte.setter
    def created_at_lte(self, created_at_lte):
        """Sets the created_at_lte of this FailoverExecutionWhereInput.


        :param created_at_lte: The created_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_lte: str
        """

        self._created_at_lte = created_at_lte

    @property
    def created_at_not(self):
        """Gets the created_at_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_not

    @created_at_not.setter
    def created_at_not(self, created_at_not):
        """Sets the created_at_not of this FailoverExecutionWhereInput.


        :param created_at_not: The created_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_not: str
        """

        self._created_at_not = created_at_not

    @property
    def created_at_not_in(self):
        """Gets the created_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The created_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_not_in

    @created_at_not_in.setter
    def created_at_not_in(self, created_at_not_in):
        """Sets the created_at_not_in of this FailoverExecutionWhereInput.


        :param created_at_not_in: The created_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type created_at_not_in: list[str]
        """

        self._created_at_not_in = created_at_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this FailoverExecutionWhereInput.


        :param entity_async_status: The entity_async_status of this FailoverExecutionWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this FailoverExecutionWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this FailoverExecutionWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this FailoverExecutionWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def external_cloudtower(self):
        """Gets the external_cloudtower of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The external_cloudtower of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: ExternalCloudTowerWhereInput
        """
        return self._external_cloudtower

    @external_cloudtower.setter
    def external_cloudtower(self, external_cloudtower):
        """Sets the external_cloudtower of this FailoverExecutionWhereInput.


        :param external_cloudtower: The external_cloudtower of this FailoverExecutionWhereInput.  # noqa: E501
        :type external_cloudtower: ExternalCloudTowerWhereInput
        """

        self._external_cloudtower = external_cloudtower

    @property
    def finished_at(self):
        """Gets the finished_at of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this FailoverExecutionWhereInput.


        :param finished_at: The finished_at of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def finished_at_gt(self):
        """Gets the finished_at_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gt

    @finished_at_gt.setter
    def finished_at_gt(self, finished_at_gt):
        """Sets the finished_at_gt of this FailoverExecutionWhereInput.


        :param finished_at_gt: The finished_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_gt: str
        """

        self._finished_at_gt = finished_at_gt

    @property
    def finished_at_gte(self):
        """Gets the finished_at_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gte

    @finished_at_gte.setter
    def finished_at_gte(self, finished_at_gte):
        """Sets the finished_at_gte of this FailoverExecutionWhereInput.


        :param finished_at_gte: The finished_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_gte: str
        """

        self._finished_at_gte = finished_at_gte

    @property
    def finished_at_in(self):
        """Gets the finished_at_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_in

    @finished_at_in.setter
    def finished_at_in(self, finished_at_in):
        """Sets the finished_at_in of this FailoverExecutionWhereInput.


        :param finished_at_in: The finished_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_in: list[str]
        """

        self._finished_at_in = finished_at_in

    @property
    def finished_at_lt(self):
        """Gets the finished_at_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lt

    @finished_at_lt.setter
    def finished_at_lt(self, finished_at_lt):
        """Sets the finished_at_lt of this FailoverExecutionWhereInput.


        :param finished_at_lt: The finished_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_lt: str
        """

        self._finished_at_lt = finished_at_lt

    @property
    def finished_at_lte(self):
        """Gets the finished_at_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lte

    @finished_at_lte.setter
    def finished_at_lte(self, finished_at_lte):
        """Sets the finished_at_lte of this FailoverExecutionWhereInput.


        :param finished_at_lte: The finished_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_lte: str
        """

        self._finished_at_lte = finished_at_lte

    @property
    def finished_at_not(self):
        """Gets the finished_at_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_not

    @finished_at_not.setter
    def finished_at_not(self, finished_at_not):
        """Sets the finished_at_not of this FailoverExecutionWhereInput.


        :param finished_at_not: The finished_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_not: str
        """

        self._finished_at_not = finished_at_not

    @property
    def finished_at_not_in(self):
        """Gets the finished_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The finished_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_not_in

    @finished_at_not_in.setter
    def finished_at_not_in(self, finished_at_not_in):
        """Sets the finished_at_not_in of this FailoverExecutionWhereInput.


        :param finished_at_not_in: The finished_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type finished_at_not_in: list[str]
        """

        self._finished_at_not_in = finished_at_not_in

    @property
    def id(self):
        """Gets the id of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FailoverExecutionWhereInput.


        :param id: The id of this FailoverExecutionWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_contains of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this FailoverExecutionWhereInput.


        :param id_contains: The id_contains of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_ends_with of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this FailoverExecutionWhereInput.


        :param id_ends_with: The id_ends_with of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this FailoverExecutionWhereInput.


        :param id_gt: The id_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this FailoverExecutionWhereInput.


        :param id_gte: The id_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this FailoverExecutionWhereInput.


        :param id_in: The id_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this FailoverExecutionWhereInput.


        :param id_lt: The id_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this FailoverExecutionWhereInput.


        :param id_lte: The id_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this FailoverExecutionWhereInput.


        :param id_not: The id_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_not_contains of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this FailoverExecutionWhereInput.


        :param id_not_contains: The id_not_contains of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this FailoverExecutionWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this FailoverExecutionWhereInput.


        :param id_not_in: The id_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this FailoverExecutionWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The id_starts_with of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this FailoverExecutionWhereInput.


        :param id_starts_with: The id_starts_with of this FailoverExecutionWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def is_test_mode(self):
        """Gets the is_test_mode of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The is_test_mode of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_test_mode

    @is_test_mode.setter
    def is_test_mode(self, is_test_mode):
        """Sets the is_test_mode of this FailoverExecutionWhereInput.


        :param is_test_mode: The is_test_mode of this FailoverExecutionWhereInput.  # noqa: E501
        :type is_test_mode: bool
        """

        self._is_test_mode = is_test_mode

    @property
    def is_test_mode_not(self):
        """Gets the is_test_mode_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The is_test_mode_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_test_mode_not

    @is_test_mode_not.setter
    def is_test_mode_not(self, is_test_mode_not):
        """Sets the is_test_mode_not of this FailoverExecutionWhereInput.


        :param is_test_mode_not: The is_test_mode_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type is_test_mode_not: bool
        """

        self._is_test_mode_not = is_test_mode_not

    @property
    def replication_failover_target_executions_every(self):
        """Gets the replication_failover_target_executions_every of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The replication_failover_target_executions_every of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationFailoverTargetExecutionWhereInput
        """
        return self._replication_failover_target_executions_every

    @replication_failover_target_executions_every.setter
    def replication_failover_target_executions_every(self, replication_failover_target_executions_every):
        """Sets the replication_failover_target_executions_every of this FailoverExecutionWhereInput.


        :param replication_failover_target_executions_every: The replication_failover_target_executions_every of this FailoverExecutionWhereInput.  # noqa: E501
        :type replication_failover_target_executions_every: ReplicationFailoverTargetExecutionWhereInput
        """

        self._replication_failover_target_executions_every = replication_failover_target_executions_every

    @property
    def replication_failover_target_executions_none(self):
        """Gets the replication_failover_target_executions_none of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The replication_failover_target_executions_none of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationFailoverTargetExecutionWhereInput
        """
        return self._replication_failover_target_executions_none

    @replication_failover_target_executions_none.setter
    def replication_failover_target_executions_none(self, replication_failover_target_executions_none):
        """Sets the replication_failover_target_executions_none of this FailoverExecutionWhereInput.


        :param replication_failover_target_executions_none: The replication_failover_target_executions_none of this FailoverExecutionWhereInput.  # noqa: E501
        :type replication_failover_target_executions_none: ReplicationFailoverTargetExecutionWhereInput
        """

        self._replication_failover_target_executions_none = replication_failover_target_executions_none

    @property
    def replication_failover_target_executions_some(self):
        """Gets the replication_failover_target_executions_some of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The replication_failover_target_executions_some of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationFailoverTargetExecutionWhereInput
        """
        return self._replication_failover_target_executions_some

    @replication_failover_target_executions_some.setter
    def replication_failover_target_executions_some(self, replication_failover_target_executions_some):
        """Sets the replication_failover_target_executions_some of this FailoverExecutionWhereInput.


        :param replication_failover_target_executions_some: The replication_failover_target_executions_some of this FailoverExecutionWhereInput.  # noqa: E501
        :type replication_failover_target_executions_some: ReplicationFailoverTargetExecutionWhereInput
        """

        self._replication_failover_target_executions_some = replication_failover_target_executions_some

    @property
    def replication_service(self):
        """Gets the replication_service of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The replication_service of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationServiceWhereInput
        """
        return self._replication_service

    @replication_service.setter
    def replication_service(self, replication_service):
        """Sets the replication_service of this FailoverExecutionWhereInput.


        :param replication_service: The replication_service of this FailoverExecutionWhereInput.  # noqa: E501
        :type replication_service: ReplicationServiceWhereInput
        """

        self._replication_service = replication_service

    @property
    def resource_version(self):
        """Gets the resource_version of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """Sets the resource_version of this FailoverExecutionWhereInput.


        :param resource_version: The resource_version of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version: int
        """

        self._resource_version = resource_version

    @property
    def resource_version_gt(self):
        """Gets the resource_version_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gt

    @resource_version_gt.setter
    def resource_version_gt(self, resource_version_gt):
        """Sets the resource_version_gt of this FailoverExecutionWhereInput.


        :param resource_version_gt: The resource_version_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_gt: int
        """

        self._resource_version_gt = resource_version_gt

    @property
    def resource_version_gte(self):
        """Gets the resource_version_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gte

    @resource_version_gte.setter
    def resource_version_gte(self, resource_version_gte):
        """Sets the resource_version_gte of this FailoverExecutionWhereInput.


        :param resource_version_gte: The resource_version_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_gte: int
        """

        self._resource_version_gte = resource_version_gte

    @property
    def resource_version_in(self):
        """Gets the resource_version_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_in

    @resource_version_in.setter
    def resource_version_in(self, resource_version_in):
        """Sets the resource_version_in of this FailoverExecutionWhereInput.


        :param resource_version_in: The resource_version_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_in: list[int]
        """

        self._resource_version_in = resource_version_in

    @property
    def resource_version_lt(self):
        """Gets the resource_version_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lt

    @resource_version_lt.setter
    def resource_version_lt(self, resource_version_lt):
        """Sets the resource_version_lt of this FailoverExecutionWhereInput.


        :param resource_version_lt: The resource_version_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_lt: int
        """

        self._resource_version_lt = resource_version_lt

    @property
    def resource_version_lte(self):
        """Gets the resource_version_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lte

    @resource_version_lte.setter
    def resource_version_lte(self, resource_version_lte):
        """Sets the resource_version_lte of this FailoverExecutionWhereInput.


        :param resource_version_lte: The resource_version_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_lte: int
        """

        self._resource_version_lte = resource_version_lte

    @property
    def resource_version_not(self):
        """Gets the resource_version_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_not

    @resource_version_not.setter
    def resource_version_not(self, resource_version_not):
        """Sets the resource_version_not of this FailoverExecutionWhereInput.


        :param resource_version_not: The resource_version_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_not: int
        """

        self._resource_version_not = resource_version_not

    @property
    def resource_version_not_in(self):
        """Gets the resource_version_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The resource_version_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_not_in

    @resource_version_not_in.setter
    def resource_version_not_in(self, resource_version_not_in):
        """Sets the resource_version_not_in of this FailoverExecutionWhereInput.


        :param resource_version_not_in: The resource_version_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type resource_version_not_in: list[int]
        """

        self._resource_version_not_in = resource_version_not_in

    @property
    def shutdown_mode(self):
        """Gets the shutdown_mode of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The shutdown_mode of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: FailoverShutdownMode
        """
        return self._shutdown_mode

    @shutdown_mode.setter
    def shutdown_mode(self, shutdown_mode):
        """Sets the shutdown_mode of this FailoverExecutionWhereInput.


        :param shutdown_mode: The shutdown_mode of this FailoverExecutionWhereInput.  # noqa: E501
        :type shutdown_mode: FailoverShutdownMode
        """

        self._shutdown_mode = shutdown_mode

    @property
    def shutdown_mode_in(self):
        """Gets the shutdown_mode_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The shutdown_mode_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[FailoverShutdownMode]
        """
        return self._shutdown_mode_in

    @shutdown_mode_in.setter
    def shutdown_mode_in(self, shutdown_mode_in):
        """Sets the shutdown_mode_in of this FailoverExecutionWhereInput.


        :param shutdown_mode_in: The shutdown_mode_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type shutdown_mode_in: list[FailoverShutdownMode]
        """

        self._shutdown_mode_in = shutdown_mode_in

    @property
    def shutdown_mode_not(self):
        """Gets the shutdown_mode_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The shutdown_mode_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: FailoverShutdownMode
        """
        return self._shutdown_mode_not

    @shutdown_mode_not.setter
    def shutdown_mode_not(self, shutdown_mode_not):
        """Sets the shutdown_mode_not of this FailoverExecutionWhereInput.


        :param shutdown_mode_not: The shutdown_mode_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type shutdown_mode_not: FailoverShutdownMode
        """

        self._shutdown_mode_not = shutdown_mode_not

    @property
    def shutdown_mode_not_in(self):
        """Gets the shutdown_mode_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The shutdown_mode_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[FailoverShutdownMode]
        """
        return self._shutdown_mode_not_in

    @shutdown_mode_not_in.setter
    def shutdown_mode_not_in(self, shutdown_mode_not_in):
        """Sets the shutdown_mode_not_in of this FailoverExecutionWhereInput.


        :param shutdown_mode_not_in: The shutdown_mode_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type shutdown_mode_not_in: list[FailoverShutdownMode]
        """

        self._shutdown_mode_not_in = shutdown_mode_not_in

    @property
    def state(self):
        """Gets the state of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The state of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this FailoverExecutionWhereInput.


        :param state: The state of this FailoverExecutionWhereInput.  # noqa: E501
        :type state: BackupExecutionState
        """

        self._state = state

    @property
    def state_in(self):
        """Gets the state_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The state_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionState]
        """
        return self._state_in

    @state_in.setter
    def state_in(self, state_in):
        """Sets the state_in of this FailoverExecutionWhereInput.


        :param state_in: The state_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type state_in: list[BackupExecutionState]
        """

        self._state_in = state_in

    @property
    def state_not(self):
        """Gets the state_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The state_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionState
        """
        return self._state_not

    @state_not.setter
    def state_not(self, state_not):
        """Sets the state_not of this FailoverExecutionWhereInput.


        :param state_not: The state_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type state_not: BackupExecutionState
        """

        self._state_not = state_not

    @property
    def state_not_in(self):
        """Gets the state_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The state_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionState]
        """
        return self._state_not_in

    @state_not_in.setter
    def state_not_in(self, state_not_in):
        """Sets the state_not_in of this FailoverExecutionWhereInput.


        :param state_not_in: The state_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type state_not_in: list[BackupExecutionState]
        """

        self._state_not_in = state_not_in

    @property
    def success_job_count(self):
        """Gets the success_job_count of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count

    @success_job_count.setter
    def success_job_count(self, success_job_count):
        """Sets the success_job_count of this FailoverExecutionWhereInput.


        :param success_job_count: The success_job_count of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count: int
        """

        self._success_job_count = success_job_count

    @property
    def success_job_count_gt(self):
        """Gets the success_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_gt

    @success_job_count_gt.setter
    def success_job_count_gt(self, success_job_count_gt):
        """Sets the success_job_count_gt of this FailoverExecutionWhereInput.


        :param success_job_count_gt: The success_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_gt: int
        """

        self._success_job_count_gt = success_job_count_gt

    @property
    def success_job_count_gte(self):
        """Gets the success_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_gte

    @success_job_count_gte.setter
    def success_job_count_gte(self, success_job_count_gte):
        """Sets the success_job_count_gte of this FailoverExecutionWhereInput.


        :param success_job_count_gte: The success_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_gte: int
        """

        self._success_job_count_gte = success_job_count_gte

    @property
    def success_job_count_in(self):
        """Gets the success_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._success_job_count_in

    @success_job_count_in.setter
    def success_job_count_in(self, success_job_count_in):
        """Sets the success_job_count_in of this FailoverExecutionWhereInput.


        :param success_job_count_in: The success_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_in: list[int]
        """

        self._success_job_count_in = success_job_count_in

    @property
    def success_job_count_lt(self):
        """Gets the success_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_lt

    @success_job_count_lt.setter
    def success_job_count_lt(self, success_job_count_lt):
        """Sets the success_job_count_lt of this FailoverExecutionWhereInput.


        :param success_job_count_lt: The success_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_lt: int
        """

        self._success_job_count_lt = success_job_count_lt

    @property
    def success_job_count_lte(self):
        """Gets the success_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_lte

    @success_job_count_lte.setter
    def success_job_count_lte(self, success_job_count_lte):
        """Sets the success_job_count_lte of this FailoverExecutionWhereInput.


        :param success_job_count_lte: The success_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_lte: int
        """

        self._success_job_count_lte = success_job_count_lte

    @property
    def success_job_count_not(self):
        """Gets the success_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_not

    @success_job_count_not.setter
    def success_job_count_not(self, success_job_count_not):
        """Sets the success_job_count_not of this FailoverExecutionWhereInput.


        :param success_job_count_not: The success_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_not: int
        """

        self._success_job_count_not = success_job_count_not

    @property
    def success_job_count_not_in(self):
        """Gets the success_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._success_job_count_not_in

    @success_job_count_not_in.setter
    def success_job_count_not_in(self, success_job_count_not_in):
        """Sets the success_job_count_not_in of this FailoverExecutionWhereInput.


        :param success_job_count_not_in: The success_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type success_job_count_not_in: list[int]
        """

        self._success_job_count_not_in = success_job_count_not_in

    @property
    def total_job_count(self):
        """Gets the total_job_count of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count

    @total_job_count.setter
    def total_job_count(self, total_job_count):
        """Sets the total_job_count of this FailoverExecutionWhereInput.


        :param total_job_count: The total_job_count of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count: int
        """

        self._total_job_count = total_job_count

    @property
    def total_job_count_gt(self):
        """Gets the total_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_gt

    @total_job_count_gt.setter
    def total_job_count_gt(self, total_job_count_gt):
        """Sets the total_job_count_gt of this FailoverExecutionWhereInput.


        :param total_job_count_gt: The total_job_count_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_gt: int
        """

        self._total_job_count_gt = total_job_count_gt

    @property
    def total_job_count_gte(self):
        """Gets the total_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_gte

    @total_job_count_gte.setter
    def total_job_count_gte(self, total_job_count_gte):
        """Sets the total_job_count_gte of this FailoverExecutionWhereInput.


        :param total_job_count_gte: The total_job_count_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_gte: int
        """

        self._total_job_count_gte = total_job_count_gte

    @property
    def total_job_count_in(self):
        """Gets the total_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_job_count_in

    @total_job_count_in.setter
    def total_job_count_in(self, total_job_count_in):
        """Sets the total_job_count_in of this FailoverExecutionWhereInput.


        :param total_job_count_in: The total_job_count_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_in: list[int]
        """

        self._total_job_count_in = total_job_count_in

    @property
    def total_job_count_lt(self):
        """Gets the total_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_lt

    @total_job_count_lt.setter
    def total_job_count_lt(self, total_job_count_lt):
        """Sets the total_job_count_lt of this FailoverExecutionWhereInput.


        :param total_job_count_lt: The total_job_count_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_lt: int
        """

        self._total_job_count_lt = total_job_count_lt

    @property
    def total_job_count_lte(self):
        """Gets the total_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_lte

    @total_job_count_lte.setter
    def total_job_count_lte(self, total_job_count_lte):
        """Sets the total_job_count_lte of this FailoverExecutionWhereInput.


        :param total_job_count_lte: The total_job_count_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_lte: int
        """

        self._total_job_count_lte = total_job_count_lte

    @property
    def total_job_count_not(self):
        """Gets the total_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_not

    @total_job_count_not.setter
    def total_job_count_not(self, total_job_count_not):
        """Sets the total_job_count_not of this FailoverExecutionWhereInput.


        :param total_job_count_not: The total_job_count_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_not: int
        """

        self._total_job_count_not = total_job_count_not

    @property
    def total_job_count_not_in(self):
        """Gets the total_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_job_count_not_in

    @total_job_count_not_in.setter
    def total_job_count_not_in(self, total_job_count_not_in):
        """Sets the total_job_count_not_in of this FailoverExecutionWhereInput.


        :param total_job_count_not_in: The total_job_count_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type total_job_count_not_in: list[int]
        """

        self._total_job_count_not_in = total_job_count_not_in

    @property
    def updated_at(self):
        """Gets the updated_at of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this FailoverExecutionWhereInput.


        :param updated_at: The updated_at of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def updated_at_gt(self):
        """Gets the updated_at_gt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gt

    @updated_at_gt.setter
    def updated_at_gt(self, updated_at_gt):
        """Sets the updated_at_gt of this FailoverExecutionWhereInput.


        :param updated_at_gt: The updated_at_gt of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_gt: str
        """

        self._updated_at_gt = updated_at_gt

    @property
    def updated_at_gte(self):
        """Gets the updated_at_gte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gte

    @updated_at_gte.setter
    def updated_at_gte(self, updated_at_gte):
        """Sets the updated_at_gte of this FailoverExecutionWhereInput.


        :param updated_at_gte: The updated_at_gte of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_gte: str
        """

        self._updated_at_gte = updated_at_gte

    @property
    def updated_at_in(self):
        """Gets the updated_at_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_in

    @updated_at_in.setter
    def updated_at_in(self, updated_at_in):
        """Sets the updated_at_in of this FailoverExecutionWhereInput.


        :param updated_at_in: The updated_at_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_in: list[str]
        """

        self._updated_at_in = updated_at_in

    @property
    def updated_at_lt(self):
        """Gets the updated_at_lt of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lt

    @updated_at_lt.setter
    def updated_at_lt(self, updated_at_lt):
        """Sets the updated_at_lt of this FailoverExecutionWhereInput.


        :param updated_at_lt: The updated_at_lt of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_lt: str
        """

        self._updated_at_lt = updated_at_lt

    @property
    def updated_at_lte(self):
        """Gets the updated_at_lte of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lte

    @updated_at_lte.setter
    def updated_at_lte(self, updated_at_lte):
        """Sets the updated_at_lte of this FailoverExecutionWhereInput.


        :param updated_at_lte: The updated_at_lte of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_lte: str
        """

        self._updated_at_lte = updated_at_lte

    @property
    def updated_at_not(self):
        """Gets the updated_at_not of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_not

    @updated_at_not.setter
    def updated_at_not(self, updated_at_not):
        """Sets the updated_at_not of this FailoverExecutionWhereInput.


        :param updated_at_not: The updated_at_not of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_not: str
        """

        self._updated_at_not = updated_at_not

    @property
    def updated_at_not_in(self):
        """Gets the updated_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501


        :return: The updated_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_not_in

    @updated_at_not_in.setter
    def updated_at_not_in(self, updated_at_not_in):
        """Sets the updated_at_not_in of this FailoverExecutionWhereInput.


        :param updated_at_not_in: The updated_at_not_in of this FailoverExecutionWhereInput.  # noqa: E501
        :type updated_at_not_in: list[str]
        """

        self._updated_at_not_in = updated_at_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FailoverExecutionWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FailoverExecutionWhereInput):
            return True

        return self.to_dict() != other.to_dict()
