# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class GpuDeviceWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[GpuDeviceWhereInput]',
        '_not': 'list[GpuDeviceWhereInput]',
        '_or': 'list[GpuDeviceWhereInput]',
        'assigned_vgpus_num': 'int',
        'assigned_vgpus_num_gt': 'int',
        'assigned_vgpus_num_gte': 'int',
        'assigned_vgpus_num_in': 'list[int]',
        'assigned_vgpus_num_lt': 'int',
        'assigned_vgpus_num_lte': 'int',
        'assigned_vgpus_num_not': 'int',
        'assigned_vgpus_num_not_in': 'list[int]',
        'available_vgpus_num': 'int',
        'available_vgpus_num_gt': 'int',
        'available_vgpus_num_gte': 'int',
        'available_vgpus_num_in': 'list[int]',
        'available_vgpus_num_lt': 'int',
        'available_vgpus_num_lte': 'int',
        'available_vgpus_num_not': 'int',
        'available_vgpus_num_not_in': 'list[int]',
        'brand': 'str',
        'brand_contains': 'str',
        'brand_ends_with': 'str',
        'brand_gt': 'str',
        'brand_gte': 'str',
        'brand_in': 'list[str]',
        'brand_lt': 'str',
        'brand_lte': 'str',
        'brand_not': 'str',
        'brand_not_contains': 'str',
        'brand_not_ends_with': 'str',
        'brand_not_in': 'list[str]',
        'brand_not_starts_with': 'str',
        'brand_starts_with': 'str',
        'bus_location': 'str',
        'bus_location_contains': 'str',
        'bus_location_ends_with': 'str',
        'bus_location_gt': 'str',
        'bus_location_gte': 'str',
        'bus_location_in': 'list[str]',
        'bus_location_lt': 'str',
        'bus_location_lte': 'str',
        'bus_location_not': 'str',
        'bus_location_not_contains': 'str',
        'bus_location_not_ends_with': 'str',
        'bus_location_not_in': 'list[str]',
        'bus_location_not_starts_with': 'str',
        'bus_location_starts_with': 'str',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'host': 'HostWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'is_nvidia_tools_ready': 'bool',
        'is_nvidia_tools_ready_not': 'bool',
        'is_nvidia_vfs_enabled': 'bool',
        'is_nvidia_vfs_enabled_not': 'bool',
        'is_nvidia_vfs_supported': 'bool',
        'is_nvidia_vfs_supported_not': 'bool',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'model': 'str',
        'model_contains': 'str',
        'model_ends_with': 'str',
        'model_gt': 'str',
        'model_gte': 'str',
        'model_in': 'list[str]',
        'model_lt': 'str',
        'model_lte': 'str',
        'model_not': 'str',
        'model_not_contains': 'str',
        'model_not_ends_with': 'str',
        'model_not_in': 'list[str]',
        'model_not_starts_with': 'str',
        'model_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'status': 'GpuDeviceStatus',
        'status_in': 'list[GpuDeviceStatus]',
        'status_not': 'GpuDeviceStatus',
        'status_not_in': 'list[GpuDeviceStatus]',
        'user_usage': 'GpuDeviceUsage',
        'user_usage_in': 'list[GpuDeviceUsage]',
        'user_usage_not': 'GpuDeviceUsage',
        'user_usage_not_in': 'list[GpuDeviceUsage]',
        'user_vgpu_type_id': 'str',
        'user_vgpu_type_id_contains': 'str',
        'user_vgpu_type_id_ends_with': 'str',
        'user_vgpu_type_id_gt': 'str',
        'user_vgpu_type_id_gte': 'str',
        'user_vgpu_type_id_in': 'list[str]',
        'user_vgpu_type_id_lt': 'str',
        'user_vgpu_type_id_lte': 'str',
        'user_vgpu_type_id_not': 'str',
        'user_vgpu_type_id_not_contains': 'str',
        'user_vgpu_type_id_not_ends_with': 'str',
        'user_vgpu_type_id_not_in': 'list[str]',
        'user_vgpu_type_id_not_starts_with': 'str',
        'user_vgpu_type_id_starts_with': 'str',
        'user_vgpu_type_name': 'str',
        'user_vgpu_type_name_contains': 'str',
        'user_vgpu_type_name_ends_with': 'str',
        'user_vgpu_type_name_gt': 'str',
        'user_vgpu_type_name_gte': 'str',
        'user_vgpu_type_name_in': 'list[str]',
        'user_vgpu_type_name_lt': 'str',
        'user_vgpu_type_name_lte': 'str',
        'user_vgpu_type_name_not': 'str',
        'user_vgpu_type_name_not_contains': 'str',
        'user_vgpu_type_name_not_ends_with': 'str',
        'user_vgpu_type_name_not_in': 'list[str]',
        'user_vgpu_type_name_not_starts_with': 'str',
        'user_vgpu_type_name_starts_with': 'str',
        'vgpu_instance_num': 'int',
        'vgpu_instance_num_gt': 'int',
        'vgpu_instance_num_gte': 'int',
        'vgpu_instance_num_in': 'list[int]',
        'vgpu_instance_num_lt': 'int',
        'vgpu_instance_num_lte': 'int',
        'vgpu_instance_num_not': 'int',
        'vgpu_instance_num_not_in': 'list[int]',
        'vms_every': 'VmWhereInput',
        'vms_none': 'VmWhereInput',
        'vms_some': 'VmWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'assigned_vgpus_num': 'assigned_vgpus_num',
        'assigned_vgpus_num_gt': 'assigned_vgpus_num_gt',
        'assigned_vgpus_num_gte': 'assigned_vgpus_num_gte',
        'assigned_vgpus_num_in': 'assigned_vgpus_num_in',
        'assigned_vgpus_num_lt': 'assigned_vgpus_num_lt',
        'assigned_vgpus_num_lte': 'assigned_vgpus_num_lte',
        'assigned_vgpus_num_not': 'assigned_vgpus_num_not',
        'assigned_vgpus_num_not_in': 'assigned_vgpus_num_not_in',
        'available_vgpus_num': 'available_vgpus_num',
        'available_vgpus_num_gt': 'available_vgpus_num_gt',
        'available_vgpus_num_gte': 'available_vgpus_num_gte',
        'available_vgpus_num_in': 'available_vgpus_num_in',
        'available_vgpus_num_lt': 'available_vgpus_num_lt',
        'available_vgpus_num_lte': 'available_vgpus_num_lte',
        'available_vgpus_num_not': 'available_vgpus_num_not',
        'available_vgpus_num_not_in': 'available_vgpus_num_not_in',
        'brand': 'brand',
        'brand_contains': 'brand_contains',
        'brand_ends_with': 'brand_ends_with',
        'brand_gt': 'brand_gt',
        'brand_gte': 'brand_gte',
        'brand_in': 'brand_in',
        'brand_lt': 'brand_lt',
        'brand_lte': 'brand_lte',
        'brand_not': 'brand_not',
        'brand_not_contains': 'brand_not_contains',
        'brand_not_ends_with': 'brand_not_ends_with',
        'brand_not_in': 'brand_not_in',
        'brand_not_starts_with': 'brand_not_starts_with',
        'brand_starts_with': 'brand_starts_with',
        'bus_location': 'bus_location',
        'bus_location_contains': 'bus_location_contains',
        'bus_location_ends_with': 'bus_location_ends_with',
        'bus_location_gt': 'bus_location_gt',
        'bus_location_gte': 'bus_location_gte',
        'bus_location_in': 'bus_location_in',
        'bus_location_lt': 'bus_location_lt',
        'bus_location_lte': 'bus_location_lte',
        'bus_location_not': 'bus_location_not',
        'bus_location_not_contains': 'bus_location_not_contains',
        'bus_location_not_ends_with': 'bus_location_not_ends_with',
        'bus_location_not_in': 'bus_location_not_in',
        'bus_location_not_starts_with': 'bus_location_not_starts_with',
        'bus_location_starts_with': 'bus_location_starts_with',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'host': 'host',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'is_nvidia_tools_ready': 'is_nvidia_tools_ready',
        'is_nvidia_tools_ready_not': 'is_nvidia_tools_ready_not',
        'is_nvidia_vfs_enabled': 'is_nvidia_vfs_enabled',
        'is_nvidia_vfs_enabled_not': 'is_nvidia_vfs_enabled_not',
        'is_nvidia_vfs_supported': 'is_nvidia_vfs_supported',
        'is_nvidia_vfs_supported_not': 'is_nvidia_vfs_supported_not',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'model': 'model',
        'model_contains': 'model_contains',
        'model_ends_with': 'model_ends_with',
        'model_gt': 'model_gt',
        'model_gte': 'model_gte',
        'model_in': 'model_in',
        'model_lt': 'model_lt',
        'model_lte': 'model_lte',
        'model_not': 'model_not',
        'model_not_contains': 'model_not_contains',
        'model_not_ends_with': 'model_not_ends_with',
        'model_not_in': 'model_not_in',
        'model_not_starts_with': 'model_not_starts_with',
        'model_starts_with': 'model_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'user_usage': 'user_usage',
        'user_usage_in': 'user_usage_in',
        'user_usage_not': 'user_usage_not',
        'user_usage_not_in': 'user_usage_not_in',
        'user_vgpu_type_id': 'user_vgpu_type_id',
        'user_vgpu_type_id_contains': 'user_vgpu_type_id_contains',
        'user_vgpu_type_id_ends_with': 'user_vgpu_type_id_ends_with',
        'user_vgpu_type_id_gt': 'user_vgpu_type_id_gt',
        'user_vgpu_type_id_gte': 'user_vgpu_type_id_gte',
        'user_vgpu_type_id_in': 'user_vgpu_type_id_in',
        'user_vgpu_type_id_lt': 'user_vgpu_type_id_lt',
        'user_vgpu_type_id_lte': 'user_vgpu_type_id_lte',
        'user_vgpu_type_id_not': 'user_vgpu_type_id_not',
        'user_vgpu_type_id_not_contains': 'user_vgpu_type_id_not_contains',
        'user_vgpu_type_id_not_ends_with': 'user_vgpu_type_id_not_ends_with',
        'user_vgpu_type_id_not_in': 'user_vgpu_type_id_not_in',
        'user_vgpu_type_id_not_starts_with': 'user_vgpu_type_id_not_starts_with',
        'user_vgpu_type_id_starts_with': 'user_vgpu_type_id_starts_with',
        'user_vgpu_type_name': 'user_vgpu_type_name',
        'user_vgpu_type_name_contains': 'user_vgpu_type_name_contains',
        'user_vgpu_type_name_ends_with': 'user_vgpu_type_name_ends_with',
        'user_vgpu_type_name_gt': 'user_vgpu_type_name_gt',
        'user_vgpu_type_name_gte': 'user_vgpu_type_name_gte',
        'user_vgpu_type_name_in': 'user_vgpu_type_name_in',
        'user_vgpu_type_name_lt': 'user_vgpu_type_name_lt',
        'user_vgpu_type_name_lte': 'user_vgpu_type_name_lte',
        'user_vgpu_type_name_not': 'user_vgpu_type_name_not',
        'user_vgpu_type_name_not_contains': 'user_vgpu_type_name_not_contains',
        'user_vgpu_type_name_not_ends_with': 'user_vgpu_type_name_not_ends_with',
        'user_vgpu_type_name_not_in': 'user_vgpu_type_name_not_in',
        'user_vgpu_type_name_not_starts_with': 'user_vgpu_type_name_not_starts_with',
        'user_vgpu_type_name_starts_with': 'user_vgpu_type_name_starts_with',
        'vgpu_instance_num': 'vgpu_instance_num',
        'vgpu_instance_num_gt': 'vgpu_instance_num_gt',
        'vgpu_instance_num_gte': 'vgpu_instance_num_gte',
        'vgpu_instance_num_in': 'vgpu_instance_num_in',
        'vgpu_instance_num_lt': 'vgpu_instance_num_lt',
        'vgpu_instance_num_lte': 'vgpu_instance_num_lte',
        'vgpu_instance_num_not': 'vgpu_instance_num_not',
        'vgpu_instance_num_not_in': 'vgpu_instance_num_not_in',
        'vms_every': 'vms_every',
        'vms_none': 'vms_none',
        'vms_some': 'vms_some'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """GpuDeviceWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._assigned_vgpus_num = None
        self._assigned_vgpus_num_gt = None
        self._assigned_vgpus_num_gte = None
        self._assigned_vgpus_num_in = None
        self._assigned_vgpus_num_lt = None
        self._assigned_vgpus_num_lte = None
        self._assigned_vgpus_num_not = None
        self._assigned_vgpus_num_not_in = None
        self._available_vgpus_num = None
        self._available_vgpus_num_gt = None
        self._available_vgpus_num_gte = None
        self._available_vgpus_num_in = None
        self._available_vgpus_num_lt = None
        self._available_vgpus_num_lte = None
        self._available_vgpus_num_not = None
        self._available_vgpus_num_not_in = None
        self._brand = None
        self._brand_contains = None
        self._brand_ends_with = None
        self._brand_gt = None
        self._brand_gte = None
        self._brand_in = None
        self._brand_lt = None
        self._brand_lte = None
        self._brand_not = None
        self._brand_not_contains = None
        self._brand_not_ends_with = None
        self._brand_not_in = None
        self._brand_not_starts_with = None
        self._brand_starts_with = None
        self._bus_location = None
        self._bus_location_contains = None
        self._bus_location_ends_with = None
        self._bus_location_gt = None
        self._bus_location_gte = None
        self._bus_location_in = None
        self._bus_location_lt = None
        self._bus_location_lte = None
        self._bus_location_not = None
        self._bus_location_not_contains = None
        self._bus_location_not_ends_with = None
        self._bus_location_not_in = None
        self._bus_location_not_starts_with = None
        self._bus_location_starts_with = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._host = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._is_nvidia_tools_ready = None
        self._is_nvidia_tools_ready_not = None
        self._is_nvidia_vfs_enabled = None
        self._is_nvidia_vfs_enabled_not = None
        self._is_nvidia_vfs_supported = None
        self._is_nvidia_vfs_supported_not = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._model = None
        self._model_contains = None
        self._model_ends_with = None
        self._model_gt = None
        self._model_gte = None
        self._model_in = None
        self._model_lt = None
        self._model_lte = None
        self._model_not = None
        self._model_not_contains = None
        self._model_not_ends_with = None
        self._model_not_in = None
        self._model_not_starts_with = None
        self._model_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._user_usage = None
        self._user_usage_in = None
        self._user_usage_not = None
        self._user_usage_not_in = None
        self._user_vgpu_type_id = None
        self._user_vgpu_type_id_contains = None
        self._user_vgpu_type_id_ends_with = None
        self._user_vgpu_type_id_gt = None
        self._user_vgpu_type_id_gte = None
        self._user_vgpu_type_id_in = None
        self._user_vgpu_type_id_lt = None
        self._user_vgpu_type_id_lte = None
        self._user_vgpu_type_id_not = None
        self._user_vgpu_type_id_not_contains = None
        self._user_vgpu_type_id_not_ends_with = None
        self._user_vgpu_type_id_not_in = None
        self._user_vgpu_type_id_not_starts_with = None
        self._user_vgpu_type_id_starts_with = None
        self._user_vgpu_type_name = None
        self._user_vgpu_type_name_contains = None
        self._user_vgpu_type_name_ends_with = None
        self._user_vgpu_type_name_gt = None
        self._user_vgpu_type_name_gte = None
        self._user_vgpu_type_name_in = None
        self._user_vgpu_type_name_lt = None
        self._user_vgpu_type_name_lte = None
        self._user_vgpu_type_name_not = None
        self._user_vgpu_type_name_not_contains = None
        self._user_vgpu_type_name_not_ends_with = None
        self._user_vgpu_type_name_not_in = None
        self._user_vgpu_type_name_not_starts_with = None
        self._user_vgpu_type_name_starts_with = None
        self._vgpu_instance_num = None
        self._vgpu_instance_num_gt = None
        self._vgpu_instance_num_gte = None
        self._vgpu_instance_num_in = None
        self._vgpu_instance_num_lt = None
        self._vgpu_instance_num_lte = None
        self._vgpu_instance_num_not = None
        self._vgpu_instance_num_not_in = None
        self._vms_every = None
        self._vms_none = None
        self._vms_some = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.assigned_vgpus_num = kwargs.get("assigned_vgpus_num", None)
        self.assigned_vgpus_num_gt = kwargs.get("assigned_vgpus_num_gt", None)
        self.assigned_vgpus_num_gte = kwargs.get("assigned_vgpus_num_gte", None)
        self.assigned_vgpus_num_in = kwargs.get("assigned_vgpus_num_in", None)
        self.assigned_vgpus_num_lt = kwargs.get("assigned_vgpus_num_lt", None)
        self.assigned_vgpus_num_lte = kwargs.get("assigned_vgpus_num_lte", None)
        self.assigned_vgpus_num_not = kwargs.get("assigned_vgpus_num_not", None)
        self.assigned_vgpus_num_not_in = kwargs.get("assigned_vgpus_num_not_in", None)
        self.available_vgpus_num = kwargs.get("available_vgpus_num", None)
        self.available_vgpus_num_gt = kwargs.get("available_vgpus_num_gt", None)
        self.available_vgpus_num_gte = kwargs.get("available_vgpus_num_gte", None)
        self.available_vgpus_num_in = kwargs.get("available_vgpus_num_in", None)
        self.available_vgpus_num_lt = kwargs.get("available_vgpus_num_lt", None)
        self.available_vgpus_num_lte = kwargs.get("available_vgpus_num_lte", None)
        self.available_vgpus_num_not = kwargs.get("available_vgpus_num_not", None)
        self.available_vgpus_num_not_in = kwargs.get("available_vgpus_num_not_in", None)
        self.brand = kwargs.get("brand", None)
        self.brand_contains = kwargs.get("brand_contains", None)
        self.brand_ends_with = kwargs.get("brand_ends_with", None)
        self.brand_gt = kwargs.get("brand_gt", None)
        self.brand_gte = kwargs.get("brand_gte", None)
        self.brand_in = kwargs.get("brand_in", None)
        self.brand_lt = kwargs.get("brand_lt", None)
        self.brand_lte = kwargs.get("brand_lte", None)
        self.brand_not = kwargs.get("brand_not", None)
        self.brand_not_contains = kwargs.get("brand_not_contains", None)
        self.brand_not_ends_with = kwargs.get("brand_not_ends_with", None)
        self.brand_not_in = kwargs.get("brand_not_in", None)
        self.brand_not_starts_with = kwargs.get("brand_not_starts_with", None)
        self.brand_starts_with = kwargs.get("brand_starts_with", None)
        self.bus_location = kwargs.get("bus_location", None)
        self.bus_location_contains = kwargs.get("bus_location_contains", None)
        self.bus_location_ends_with = kwargs.get("bus_location_ends_with", None)
        self.bus_location_gt = kwargs.get("bus_location_gt", None)
        self.bus_location_gte = kwargs.get("bus_location_gte", None)
        self.bus_location_in = kwargs.get("bus_location_in", None)
        self.bus_location_lt = kwargs.get("bus_location_lt", None)
        self.bus_location_lte = kwargs.get("bus_location_lte", None)
        self.bus_location_not = kwargs.get("bus_location_not", None)
        self.bus_location_not_contains = kwargs.get("bus_location_not_contains", None)
        self.bus_location_not_ends_with = kwargs.get("bus_location_not_ends_with", None)
        self.bus_location_not_in = kwargs.get("bus_location_not_in", None)
        self.bus_location_not_starts_with = kwargs.get("bus_location_not_starts_with", None)
        self.bus_location_starts_with = kwargs.get("bus_location_starts_with", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.host = kwargs.get("host", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.is_nvidia_tools_ready = kwargs.get("is_nvidia_tools_ready", None)
        self.is_nvidia_tools_ready_not = kwargs.get("is_nvidia_tools_ready_not", None)
        self.is_nvidia_vfs_enabled = kwargs.get("is_nvidia_vfs_enabled", None)
        self.is_nvidia_vfs_enabled_not = kwargs.get("is_nvidia_vfs_enabled_not", None)
        self.is_nvidia_vfs_supported = kwargs.get("is_nvidia_vfs_supported", None)
        self.is_nvidia_vfs_supported_not = kwargs.get("is_nvidia_vfs_supported_not", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.model = kwargs.get("model", None)
        self.model_contains = kwargs.get("model_contains", None)
        self.model_ends_with = kwargs.get("model_ends_with", None)
        self.model_gt = kwargs.get("model_gt", None)
        self.model_gte = kwargs.get("model_gte", None)
        self.model_in = kwargs.get("model_in", None)
        self.model_lt = kwargs.get("model_lt", None)
        self.model_lte = kwargs.get("model_lte", None)
        self.model_not = kwargs.get("model_not", None)
        self.model_not_contains = kwargs.get("model_not_contains", None)
        self.model_not_ends_with = kwargs.get("model_not_ends_with", None)
        self.model_not_in = kwargs.get("model_not_in", None)
        self.model_not_starts_with = kwargs.get("model_not_starts_with", None)
        self.model_starts_with = kwargs.get("model_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.user_usage = kwargs.get("user_usage", None)
        self.user_usage_in = kwargs.get("user_usage_in", None)
        self.user_usage_not = kwargs.get("user_usage_not", None)
        self.user_usage_not_in = kwargs.get("user_usage_not_in", None)
        self.user_vgpu_type_id = kwargs.get("user_vgpu_type_id", None)
        self.user_vgpu_type_id_contains = kwargs.get("user_vgpu_type_id_contains", None)
        self.user_vgpu_type_id_ends_with = kwargs.get("user_vgpu_type_id_ends_with", None)
        self.user_vgpu_type_id_gt = kwargs.get("user_vgpu_type_id_gt", None)
        self.user_vgpu_type_id_gte = kwargs.get("user_vgpu_type_id_gte", None)
        self.user_vgpu_type_id_in = kwargs.get("user_vgpu_type_id_in", None)
        self.user_vgpu_type_id_lt = kwargs.get("user_vgpu_type_id_lt", None)
        self.user_vgpu_type_id_lte = kwargs.get("user_vgpu_type_id_lte", None)
        self.user_vgpu_type_id_not = kwargs.get("user_vgpu_type_id_not", None)
        self.user_vgpu_type_id_not_contains = kwargs.get("user_vgpu_type_id_not_contains", None)
        self.user_vgpu_type_id_not_ends_with = kwargs.get("user_vgpu_type_id_not_ends_with", None)
        self.user_vgpu_type_id_not_in = kwargs.get("user_vgpu_type_id_not_in", None)
        self.user_vgpu_type_id_not_starts_with = kwargs.get("user_vgpu_type_id_not_starts_with", None)
        self.user_vgpu_type_id_starts_with = kwargs.get("user_vgpu_type_id_starts_with", None)
        self.user_vgpu_type_name = kwargs.get("user_vgpu_type_name", None)
        self.user_vgpu_type_name_contains = kwargs.get("user_vgpu_type_name_contains", None)
        self.user_vgpu_type_name_ends_with = kwargs.get("user_vgpu_type_name_ends_with", None)
        self.user_vgpu_type_name_gt = kwargs.get("user_vgpu_type_name_gt", None)
        self.user_vgpu_type_name_gte = kwargs.get("user_vgpu_type_name_gte", None)
        self.user_vgpu_type_name_in = kwargs.get("user_vgpu_type_name_in", None)
        self.user_vgpu_type_name_lt = kwargs.get("user_vgpu_type_name_lt", None)
        self.user_vgpu_type_name_lte = kwargs.get("user_vgpu_type_name_lte", None)
        self.user_vgpu_type_name_not = kwargs.get("user_vgpu_type_name_not", None)
        self.user_vgpu_type_name_not_contains = kwargs.get("user_vgpu_type_name_not_contains", None)
        self.user_vgpu_type_name_not_ends_with = kwargs.get("user_vgpu_type_name_not_ends_with", None)
        self.user_vgpu_type_name_not_in = kwargs.get("user_vgpu_type_name_not_in", None)
        self.user_vgpu_type_name_not_starts_with = kwargs.get("user_vgpu_type_name_not_starts_with", None)
        self.user_vgpu_type_name_starts_with = kwargs.get("user_vgpu_type_name_starts_with", None)
        self.vgpu_instance_num = kwargs.get("vgpu_instance_num", None)
        self.vgpu_instance_num_gt = kwargs.get("vgpu_instance_num_gt", None)
        self.vgpu_instance_num_gte = kwargs.get("vgpu_instance_num_gte", None)
        self.vgpu_instance_num_in = kwargs.get("vgpu_instance_num_in", None)
        self.vgpu_instance_num_lt = kwargs.get("vgpu_instance_num_lt", None)
        self.vgpu_instance_num_lte = kwargs.get("vgpu_instance_num_lte", None)
        self.vgpu_instance_num_not = kwargs.get("vgpu_instance_num_not", None)
        self.vgpu_instance_num_not_in = kwargs.get("vgpu_instance_num_not_in", None)
        self.vms_every = kwargs.get("vms_every", None)
        self.vms_none = kwargs.get("vms_none", None)
        self.vms_some = kwargs.get("vms_some", None)

    @property
    def _and(self):
        """Gets the _and of this GpuDeviceWhereInput.  # noqa: E501


        :return: The _and of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this GpuDeviceWhereInput.


        :param _and: The _and of this GpuDeviceWhereInput.  # noqa: E501
        :type _and: list[GpuDeviceWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The _not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this GpuDeviceWhereInput.


        :param _not: The _not of this GpuDeviceWhereInput.  # noqa: E501
        :type _not: list[GpuDeviceWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this GpuDeviceWhereInput.  # noqa: E501


        :return: The _or of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this GpuDeviceWhereInput.


        :param _or: The _or of this GpuDeviceWhereInput.  # noqa: E501
        :type _or: list[GpuDeviceWhereInput]
        """

        self.__or = _or

    @property
    def assigned_vgpus_num(self):
        """Gets the assigned_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num

    @assigned_vgpus_num.setter
    def assigned_vgpus_num(self, assigned_vgpus_num):
        """Sets the assigned_vgpus_num of this GpuDeviceWhereInput.


        :param assigned_vgpus_num: The assigned_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num: int
        """

        self._assigned_vgpus_num = assigned_vgpus_num

    @property
    def assigned_vgpus_num_gt(self):
        """Gets the assigned_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num_gt

    @assigned_vgpus_num_gt.setter
    def assigned_vgpus_num_gt(self, assigned_vgpus_num_gt):
        """Sets the assigned_vgpus_num_gt of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_gt: The assigned_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_gt: int
        """

        self._assigned_vgpus_num_gt = assigned_vgpus_num_gt

    @property
    def assigned_vgpus_num_gte(self):
        """Gets the assigned_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num_gte

    @assigned_vgpus_num_gte.setter
    def assigned_vgpus_num_gte(self, assigned_vgpus_num_gte):
        """Sets the assigned_vgpus_num_gte of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_gte: The assigned_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_gte: int
        """

        self._assigned_vgpus_num_gte = assigned_vgpus_num_gte

    @property
    def assigned_vgpus_num_in(self):
        """Gets the assigned_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._assigned_vgpus_num_in

    @assigned_vgpus_num_in.setter
    def assigned_vgpus_num_in(self, assigned_vgpus_num_in):
        """Sets the assigned_vgpus_num_in of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_in: The assigned_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_in: list[int]
        """

        self._assigned_vgpus_num_in = assigned_vgpus_num_in

    @property
    def assigned_vgpus_num_lt(self):
        """Gets the assigned_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num_lt

    @assigned_vgpus_num_lt.setter
    def assigned_vgpus_num_lt(self, assigned_vgpus_num_lt):
        """Sets the assigned_vgpus_num_lt of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_lt: The assigned_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_lt: int
        """

        self._assigned_vgpus_num_lt = assigned_vgpus_num_lt

    @property
    def assigned_vgpus_num_lte(self):
        """Gets the assigned_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num_lte

    @assigned_vgpus_num_lte.setter
    def assigned_vgpus_num_lte(self, assigned_vgpus_num_lte):
        """Sets the assigned_vgpus_num_lte of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_lte: The assigned_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_lte: int
        """

        self._assigned_vgpus_num_lte = assigned_vgpus_num_lte

    @property
    def assigned_vgpus_num_not(self):
        """Gets the assigned_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num_not

    @assigned_vgpus_num_not.setter
    def assigned_vgpus_num_not(self, assigned_vgpus_num_not):
        """Sets the assigned_vgpus_num_not of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_not: The assigned_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_not: int
        """

        self._assigned_vgpus_num_not = assigned_vgpus_num_not

    @property
    def assigned_vgpus_num_not_in(self):
        """Gets the assigned_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The assigned_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._assigned_vgpus_num_not_in

    @assigned_vgpus_num_not_in.setter
    def assigned_vgpus_num_not_in(self, assigned_vgpus_num_not_in):
        """Sets the assigned_vgpus_num_not_in of this GpuDeviceWhereInput.


        :param assigned_vgpus_num_not_in: The assigned_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type assigned_vgpus_num_not_in: list[int]
        """

        self._assigned_vgpus_num_not_in = assigned_vgpus_num_not_in

    @property
    def available_vgpus_num(self):
        """Gets the available_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num

    @available_vgpus_num.setter
    def available_vgpus_num(self, available_vgpus_num):
        """Sets the available_vgpus_num of this GpuDeviceWhereInput.


        :param available_vgpus_num: The available_vgpus_num of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num: int
        """

        self._available_vgpus_num = available_vgpus_num

    @property
    def available_vgpus_num_gt(self):
        """Gets the available_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num_gt

    @available_vgpus_num_gt.setter
    def available_vgpus_num_gt(self, available_vgpus_num_gt):
        """Sets the available_vgpus_num_gt of this GpuDeviceWhereInput.


        :param available_vgpus_num_gt: The available_vgpus_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_gt: int
        """

        self._available_vgpus_num_gt = available_vgpus_num_gt

    @property
    def available_vgpus_num_gte(self):
        """Gets the available_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num_gte

    @available_vgpus_num_gte.setter
    def available_vgpus_num_gte(self, available_vgpus_num_gte):
        """Sets the available_vgpus_num_gte of this GpuDeviceWhereInput.


        :param available_vgpus_num_gte: The available_vgpus_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_gte: int
        """

        self._available_vgpus_num_gte = available_vgpus_num_gte

    @property
    def available_vgpus_num_in(self):
        """Gets the available_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._available_vgpus_num_in

    @available_vgpus_num_in.setter
    def available_vgpus_num_in(self, available_vgpus_num_in):
        """Sets the available_vgpus_num_in of this GpuDeviceWhereInput.


        :param available_vgpus_num_in: The available_vgpus_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_in: list[int]
        """

        self._available_vgpus_num_in = available_vgpus_num_in

    @property
    def available_vgpus_num_lt(self):
        """Gets the available_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num_lt

    @available_vgpus_num_lt.setter
    def available_vgpus_num_lt(self, available_vgpus_num_lt):
        """Sets the available_vgpus_num_lt of this GpuDeviceWhereInput.


        :param available_vgpus_num_lt: The available_vgpus_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_lt: int
        """

        self._available_vgpus_num_lt = available_vgpus_num_lt

    @property
    def available_vgpus_num_lte(self):
        """Gets the available_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num_lte

    @available_vgpus_num_lte.setter
    def available_vgpus_num_lte(self, available_vgpus_num_lte):
        """Sets the available_vgpus_num_lte of this GpuDeviceWhereInput.


        :param available_vgpus_num_lte: The available_vgpus_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_lte: int
        """

        self._available_vgpus_num_lte = available_vgpus_num_lte

    @property
    def available_vgpus_num_not(self):
        """Gets the available_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num_not

    @available_vgpus_num_not.setter
    def available_vgpus_num_not(self, available_vgpus_num_not):
        """Sets the available_vgpus_num_not of this GpuDeviceWhereInput.


        :param available_vgpus_num_not: The available_vgpus_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_not: int
        """

        self._available_vgpus_num_not = available_vgpus_num_not

    @property
    def available_vgpus_num_not_in(self):
        """Gets the available_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The available_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._available_vgpus_num_not_in

    @available_vgpus_num_not_in.setter
    def available_vgpus_num_not_in(self, available_vgpus_num_not_in):
        """Sets the available_vgpus_num_not_in of this GpuDeviceWhereInput.


        :param available_vgpus_num_not_in: The available_vgpus_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type available_vgpus_num_not_in: list[int]
        """

        self._available_vgpus_num_not_in = available_vgpus_num_not_in

    @property
    def brand(self):
        """Gets the brand of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this GpuDeviceWhereInput.


        :param brand: The brand of this GpuDeviceWhereInput.  # noqa: E501
        :type brand: str
        """

        self._brand = brand

    @property
    def brand_contains(self):
        """Gets the brand_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_contains

    @brand_contains.setter
    def brand_contains(self, brand_contains):
        """Sets the brand_contains of this GpuDeviceWhereInput.


        :param brand_contains: The brand_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_contains: str
        """

        self._brand_contains = brand_contains

    @property
    def brand_ends_with(self):
        """Gets the brand_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_ends_with

    @brand_ends_with.setter
    def brand_ends_with(self, brand_ends_with):
        """Sets the brand_ends_with of this GpuDeviceWhereInput.


        :param brand_ends_with: The brand_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_ends_with: str
        """

        self._brand_ends_with = brand_ends_with

    @property
    def brand_gt(self):
        """Gets the brand_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_gt

    @brand_gt.setter
    def brand_gt(self, brand_gt):
        """Sets the brand_gt of this GpuDeviceWhereInput.


        :param brand_gt: The brand_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_gt: str
        """

        self._brand_gt = brand_gt

    @property
    def brand_gte(self):
        """Gets the brand_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_gte

    @brand_gte.setter
    def brand_gte(self, brand_gte):
        """Sets the brand_gte of this GpuDeviceWhereInput.


        :param brand_gte: The brand_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_gte: str
        """

        self._brand_gte = brand_gte

    @property
    def brand_in(self):
        """Gets the brand_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._brand_in

    @brand_in.setter
    def brand_in(self, brand_in):
        """Sets the brand_in of this GpuDeviceWhereInput.


        :param brand_in: The brand_in of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_in: list[str]
        """

        self._brand_in = brand_in

    @property
    def brand_lt(self):
        """Gets the brand_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_lt

    @brand_lt.setter
    def brand_lt(self, brand_lt):
        """Sets the brand_lt of this GpuDeviceWhereInput.


        :param brand_lt: The brand_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_lt: str
        """

        self._brand_lt = brand_lt

    @property
    def brand_lte(self):
        """Gets the brand_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_lte

    @brand_lte.setter
    def brand_lte(self, brand_lte):
        """Sets the brand_lte of this GpuDeviceWhereInput.


        :param brand_lte: The brand_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_lte: str
        """

        self._brand_lte = brand_lte

    @property
    def brand_not(self):
        """Gets the brand_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_not

    @brand_not.setter
    def brand_not(self, brand_not):
        """Sets the brand_not of this GpuDeviceWhereInput.


        :param brand_not: The brand_not of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_not: str
        """

        self._brand_not = brand_not

    @property
    def brand_not_contains(self):
        """Gets the brand_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_not_contains

    @brand_not_contains.setter
    def brand_not_contains(self, brand_not_contains):
        """Sets the brand_not_contains of this GpuDeviceWhereInput.


        :param brand_not_contains: The brand_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_not_contains: str
        """

        self._brand_not_contains = brand_not_contains

    @property
    def brand_not_ends_with(self):
        """Gets the brand_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_not_ends_with

    @brand_not_ends_with.setter
    def brand_not_ends_with(self, brand_not_ends_with):
        """Sets the brand_not_ends_with of this GpuDeviceWhereInput.


        :param brand_not_ends_with: The brand_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_not_ends_with: str
        """

        self._brand_not_ends_with = brand_not_ends_with

    @property
    def brand_not_in(self):
        """Gets the brand_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._brand_not_in

    @brand_not_in.setter
    def brand_not_in(self, brand_not_in):
        """Sets the brand_not_in of this GpuDeviceWhereInput.


        :param brand_not_in: The brand_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_not_in: list[str]
        """

        self._brand_not_in = brand_not_in

    @property
    def brand_not_starts_with(self):
        """Gets the brand_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_not_starts_with

    @brand_not_starts_with.setter
    def brand_not_starts_with(self, brand_not_starts_with):
        """Sets the brand_not_starts_with of this GpuDeviceWhereInput.


        :param brand_not_starts_with: The brand_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_not_starts_with: str
        """

        self._brand_not_starts_with = brand_not_starts_with

    @property
    def brand_starts_with(self):
        """Gets the brand_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The brand_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._brand_starts_with

    @brand_starts_with.setter
    def brand_starts_with(self, brand_starts_with):
        """Sets the brand_starts_with of this GpuDeviceWhereInput.


        :param brand_starts_with: The brand_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type brand_starts_with: str
        """

        self._brand_starts_with = brand_starts_with

    @property
    def bus_location(self):
        """Gets the bus_location of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location

    @bus_location.setter
    def bus_location(self, bus_location):
        """Sets the bus_location of this GpuDeviceWhereInput.


        :param bus_location: The bus_location of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location: str
        """

        self._bus_location = bus_location

    @property
    def bus_location_contains(self):
        """Gets the bus_location_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_contains

    @bus_location_contains.setter
    def bus_location_contains(self, bus_location_contains):
        """Sets the bus_location_contains of this GpuDeviceWhereInput.


        :param bus_location_contains: The bus_location_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_contains: str
        """

        self._bus_location_contains = bus_location_contains

    @property
    def bus_location_ends_with(self):
        """Gets the bus_location_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_ends_with

    @bus_location_ends_with.setter
    def bus_location_ends_with(self, bus_location_ends_with):
        """Sets the bus_location_ends_with of this GpuDeviceWhereInput.


        :param bus_location_ends_with: The bus_location_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_ends_with: str
        """

        self._bus_location_ends_with = bus_location_ends_with

    @property
    def bus_location_gt(self):
        """Gets the bus_location_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_gt

    @bus_location_gt.setter
    def bus_location_gt(self, bus_location_gt):
        """Sets the bus_location_gt of this GpuDeviceWhereInput.


        :param bus_location_gt: The bus_location_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_gt: str
        """

        self._bus_location_gt = bus_location_gt

    @property
    def bus_location_gte(self):
        """Gets the bus_location_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_gte

    @bus_location_gte.setter
    def bus_location_gte(self, bus_location_gte):
        """Sets the bus_location_gte of this GpuDeviceWhereInput.


        :param bus_location_gte: The bus_location_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_gte: str
        """

        self._bus_location_gte = bus_location_gte

    @property
    def bus_location_in(self):
        """Gets the bus_location_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._bus_location_in

    @bus_location_in.setter
    def bus_location_in(self, bus_location_in):
        """Sets the bus_location_in of this GpuDeviceWhereInput.


        :param bus_location_in: The bus_location_in of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_in: list[str]
        """

        self._bus_location_in = bus_location_in

    @property
    def bus_location_lt(self):
        """Gets the bus_location_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_lt

    @bus_location_lt.setter
    def bus_location_lt(self, bus_location_lt):
        """Sets the bus_location_lt of this GpuDeviceWhereInput.


        :param bus_location_lt: The bus_location_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_lt: str
        """

        self._bus_location_lt = bus_location_lt

    @property
    def bus_location_lte(self):
        """Gets the bus_location_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_lte

    @bus_location_lte.setter
    def bus_location_lte(self, bus_location_lte):
        """Sets the bus_location_lte of this GpuDeviceWhereInput.


        :param bus_location_lte: The bus_location_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_lte: str
        """

        self._bus_location_lte = bus_location_lte

    @property
    def bus_location_not(self):
        """Gets the bus_location_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_not

    @bus_location_not.setter
    def bus_location_not(self, bus_location_not):
        """Sets the bus_location_not of this GpuDeviceWhereInput.


        :param bus_location_not: The bus_location_not of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_not: str
        """

        self._bus_location_not = bus_location_not

    @property
    def bus_location_not_contains(self):
        """Gets the bus_location_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_not_contains

    @bus_location_not_contains.setter
    def bus_location_not_contains(self, bus_location_not_contains):
        """Sets the bus_location_not_contains of this GpuDeviceWhereInput.


        :param bus_location_not_contains: The bus_location_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_not_contains: str
        """

        self._bus_location_not_contains = bus_location_not_contains

    @property
    def bus_location_not_ends_with(self):
        """Gets the bus_location_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_not_ends_with

    @bus_location_not_ends_with.setter
    def bus_location_not_ends_with(self, bus_location_not_ends_with):
        """Sets the bus_location_not_ends_with of this GpuDeviceWhereInput.


        :param bus_location_not_ends_with: The bus_location_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_not_ends_with: str
        """

        self._bus_location_not_ends_with = bus_location_not_ends_with

    @property
    def bus_location_not_in(self):
        """Gets the bus_location_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._bus_location_not_in

    @bus_location_not_in.setter
    def bus_location_not_in(self, bus_location_not_in):
        """Sets the bus_location_not_in of this GpuDeviceWhereInput.


        :param bus_location_not_in: The bus_location_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_not_in: list[str]
        """

        self._bus_location_not_in = bus_location_not_in

    @property
    def bus_location_not_starts_with(self):
        """Gets the bus_location_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_not_starts_with

    @bus_location_not_starts_with.setter
    def bus_location_not_starts_with(self, bus_location_not_starts_with):
        """Sets the bus_location_not_starts_with of this GpuDeviceWhereInput.


        :param bus_location_not_starts_with: The bus_location_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_not_starts_with: str
        """

        self._bus_location_not_starts_with = bus_location_not_starts_with

    @property
    def bus_location_starts_with(self):
        """Gets the bus_location_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The bus_location_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._bus_location_starts_with

    @bus_location_starts_with.setter
    def bus_location_starts_with(self, bus_location_starts_with):
        """Sets the bus_location_starts_with of this GpuDeviceWhereInput.


        :param bus_location_starts_with: The bus_location_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type bus_location_starts_with: str
        """

        self._bus_location_starts_with = bus_location_starts_with

    @property
    def description(self):
        """Gets the description of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GpuDeviceWhereInput.


        :param description: The description of this GpuDeviceWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this GpuDeviceWhereInput.


        :param description_contains: The description_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this GpuDeviceWhereInput.


        :param description_ends_with: The description_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this GpuDeviceWhereInput.


        :param description_gt: The description_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this GpuDeviceWhereInput.


        :param description_gte: The description_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this GpuDeviceWhereInput.


        :param description_in: The description_in of this GpuDeviceWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this GpuDeviceWhereInput.


        :param description_lt: The description_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this GpuDeviceWhereInput.


        :param description_lte: The description_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this GpuDeviceWhereInput.


        :param description_not: The description_not of this GpuDeviceWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this GpuDeviceWhereInput.


        :param description_not_contains: The description_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this GpuDeviceWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this GpuDeviceWhereInput.


        :param description_not_in: The description_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this GpuDeviceWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The description_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this GpuDeviceWhereInput.


        :param description_starts_with: The description_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this GpuDeviceWhereInput.  # noqa: E501


        :return: The entity_async_status of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this GpuDeviceWhereInput.


        :param entity_async_status: The entity_async_status of this GpuDeviceWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this GpuDeviceWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this GpuDeviceWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this GpuDeviceWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this GpuDeviceWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this GpuDeviceWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def host(self):
        """Gets the host of this GpuDeviceWhereInput.  # noqa: E501


        :return: The host of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this GpuDeviceWhereInput.


        :param host: The host of this GpuDeviceWhereInput.  # noqa: E501
        :type host: HostWhereInput
        """

        self._host = host

    @property
    def id(self):
        """Gets the id of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GpuDeviceWhereInput.


        :param id: The id of this GpuDeviceWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this GpuDeviceWhereInput.


        :param id_contains: The id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this GpuDeviceWhereInput.


        :param id_ends_with: The id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this GpuDeviceWhereInput.


        :param id_gt: The id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this GpuDeviceWhereInput.


        :param id_gte: The id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this GpuDeviceWhereInput.


        :param id_in: The id_in of this GpuDeviceWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this GpuDeviceWhereInput.


        :param id_lt: The id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this GpuDeviceWhereInput.


        :param id_lte: The id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this GpuDeviceWhereInput.


        :param id_not: The id_not of this GpuDeviceWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this GpuDeviceWhereInput.


        :param id_not_contains: The id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this GpuDeviceWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this GpuDeviceWhereInput.


        :param id_not_in: The id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this GpuDeviceWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this GpuDeviceWhereInput.


        :param id_starts_with: The id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def is_nvidia_tools_ready(self):
        """Gets the is_nvidia_tools_ready of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_tools_ready of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_tools_ready

    @is_nvidia_tools_ready.setter
    def is_nvidia_tools_ready(self, is_nvidia_tools_ready):
        """Sets the is_nvidia_tools_ready of this GpuDeviceWhereInput.


        :param is_nvidia_tools_ready: The is_nvidia_tools_ready of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_tools_ready: bool
        """

        self._is_nvidia_tools_ready = is_nvidia_tools_ready

    @property
    def is_nvidia_tools_ready_not(self):
        """Gets the is_nvidia_tools_ready_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_tools_ready_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_tools_ready_not

    @is_nvidia_tools_ready_not.setter
    def is_nvidia_tools_ready_not(self, is_nvidia_tools_ready_not):
        """Sets the is_nvidia_tools_ready_not of this GpuDeviceWhereInput.


        :param is_nvidia_tools_ready_not: The is_nvidia_tools_ready_not of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_tools_ready_not: bool
        """

        self._is_nvidia_tools_ready_not = is_nvidia_tools_ready_not

    @property
    def is_nvidia_vfs_enabled(self):
        """Gets the is_nvidia_vfs_enabled of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_vfs_enabled of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_enabled

    @is_nvidia_vfs_enabled.setter
    def is_nvidia_vfs_enabled(self, is_nvidia_vfs_enabled):
        """Sets the is_nvidia_vfs_enabled of this GpuDeviceWhereInput.


        :param is_nvidia_vfs_enabled: The is_nvidia_vfs_enabled of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_vfs_enabled: bool
        """

        self._is_nvidia_vfs_enabled = is_nvidia_vfs_enabled

    @property
    def is_nvidia_vfs_enabled_not(self):
        """Gets the is_nvidia_vfs_enabled_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_vfs_enabled_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_enabled_not

    @is_nvidia_vfs_enabled_not.setter
    def is_nvidia_vfs_enabled_not(self, is_nvidia_vfs_enabled_not):
        """Sets the is_nvidia_vfs_enabled_not of this GpuDeviceWhereInput.


        :param is_nvidia_vfs_enabled_not: The is_nvidia_vfs_enabled_not of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_vfs_enabled_not: bool
        """

        self._is_nvidia_vfs_enabled_not = is_nvidia_vfs_enabled_not

    @property
    def is_nvidia_vfs_supported(self):
        """Gets the is_nvidia_vfs_supported of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_vfs_supported of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_supported

    @is_nvidia_vfs_supported.setter
    def is_nvidia_vfs_supported(self, is_nvidia_vfs_supported):
        """Sets the is_nvidia_vfs_supported of this GpuDeviceWhereInput.


        :param is_nvidia_vfs_supported: The is_nvidia_vfs_supported of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_vfs_supported: bool
        """

        self._is_nvidia_vfs_supported = is_nvidia_vfs_supported

    @property
    def is_nvidia_vfs_supported_not(self):
        """Gets the is_nvidia_vfs_supported_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The is_nvidia_vfs_supported_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_supported_not

    @is_nvidia_vfs_supported_not.setter
    def is_nvidia_vfs_supported_not(self, is_nvidia_vfs_supported_not):
        """Sets the is_nvidia_vfs_supported_not of this GpuDeviceWhereInput.


        :param is_nvidia_vfs_supported_not: The is_nvidia_vfs_supported_not of this GpuDeviceWhereInput.  # noqa: E501
        :type is_nvidia_vfs_supported_not: bool
        """

        self._is_nvidia_vfs_supported_not = is_nvidia_vfs_supported_not

    @property
    def labels_every(self):
        """Gets the labels_every of this GpuDeviceWhereInput.  # noqa: E501


        :return: The labels_every of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this GpuDeviceWhereInput.


        :param labels_every: The labels_every of this GpuDeviceWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this GpuDeviceWhereInput.  # noqa: E501


        :return: The labels_none of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this GpuDeviceWhereInput.


        :param labels_none: The labels_none of this GpuDeviceWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this GpuDeviceWhereInput.  # noqa: E501


        :return: The labels_some of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this GpuDeviceWhereInput.


        :param labels_some: The labels_some of this GpuDeviceWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_created_at(self):
        """Gets the local_created_at of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this GpuDeviceWhereInput.


        :param local_created_at: The local_created_at of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this GpuDeviceWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this GpuDeviceWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this GpuDeviceWhereInput.


        :param local_created_at_in: The local_created_at_in of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this GpuDeviceWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this GpuDeviceWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this GpuDeviceWhereInput.


        :param local_created_at_not: The local_created_at_not of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this GpuDeviceWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this GpuDeviceWhereInput.


        :param local_id: The local_id of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this GpuDeviceWhereInput.


        :param local_id_contains: The local_id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this GpuDeviceWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this GpuDeviceWhereInput.


        :param local_id_gt: The local_id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this GpuDeviceWhereInput.


        :param local_id_gte: The local_id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this GpuDeviceWhereInput.


        :param local_id_in: The local_id_in of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this GpuDeviceWhereInput.


        :param local_id_lt: The local_id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this GpuDeviceWhereInput.


        :param local_id_lte: The local_id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this GpuDeviceWhereInput.


        :param local_id_not: The local_id_not of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this GpuDeviceWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this GpuDeviceWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this GpuDeviceWhereInput.


        :param local_id_not_in: The local_id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this GpuDeviceWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this GpuDeviceWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def model(self):
        """Gets the model of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this GpuDeviceWhereInput.


        :param model: The model of this GpuDeviceWhereInput.  # noqa: E501
        :type model: str
        """

        self._model = model

    @property
    def model_contains(self):
        """Gets the model_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_contains

    @model_contains.setter
    def model_contains(self, model_contains):
        """Sets the model_contains of this GpuDeviceWhereInput.


        :param model_contains: The model_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type model_contains: str
        """

        self._model_contains = model_contains

    @property
    def model_ends_with(self):
        """Gets the model_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_ends_with

    @model_ends_with.setter
    def model_ends_with(self, model_ends_with):
        """Sets the model_ends_with of this GpuDeviceWhereInput.


        :param model_ends_with: The model_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type model_ends_with: str
        """

        self._model_ends_with = model_ends_with

    @property
    def model_gt(self):
        """Gets the model_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_gt

    @model_gt.setter
    def model_gt(self, model_gt):
        """Sets the model_gt of this GpuDeviceWhereInput.


        :param model_gt: The model_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type model_gt: str
        """

        self._model_gt = model_gt

    @property
    def model_gte(self):
        """Gets the model_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_gte

    @model_gte.setter
    def model_gte(self, model_gte):
        """Sets the model_gte of this GpuDeviceWhereInput.


        :param model_gte: The model_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type model_gte: str
        """

        self._model_gte = model_gte

    @property
    def model_in(self):
        """Gets the model_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._model_in

    @model_in.setter
    def model_in(self, model_in):
        """Sets the model_in of this GpuDeviceWhereInput.


        :param model_in: The model_in of this GpuDeviceWhereInput.  # noqa: E501
        :type model_in: list[str]
        """

        self._model_in = model_in

    @property
    def model_lt(self):
        """Gets the model_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_lt

    @model_lt.setter
    def model_lt(self, model_lt):
        """Sets the model_lt of this GpuDeviceWhereInput.


        :param model_lt: The model_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type model_lt: str
        """

        self._model_lt = model_lt

    @property
    def model_lte(self):
        """Gets the model_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_lte

    @model_lte.setter
    def model_lte(self, model_lte):
        """Sets the model_lte of this GpuDeviceWhereInput.


        :param model_lte: The model_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type model_lte: str
        """

        self._model_lte = model_lte

    @property
    def model_not(self):
        """Gets the model_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not

    @model_not.setter
    def model_not(self, model_not):
        """Sets the model_not of this GpuDeviceWhereInput.


        :param model_not: The model_not of this GpuDeviceWhereInput.  # noqa: E501
        :type model_not: str
        """

        self._model_not = model_not

    @property
    def model_not_contains(self):
        """Gets the model_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_contains

    @model_not_contains.setter
    def model_not_contains(self, model_not_contains):
        """Sets the model_not_contains of this GpuDeviceWhereInput.


        :param model_not_contains: The model_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type model_not_contains: str
        """

        self._model_not_contains = model_not_contains

    @property
    def model_not_ends_with(self):
        """Gets the model_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_ends_with

    @model_not_ends_with.setter
    def model_not_ends_with(self, model_not_ends_with):
        """Sets the model_not_ends_with of this GpuDeviceWhereInput.


        :param model_not_ends_with: The model_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type model_not_ends_with: str
        """

        self._model_not_ends_with = model_not_ends_with

    @property
    def model_not_in(self):
        """Gets the model_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._model_not_in

    @model_not_in.setter
    def model_not_in(self, model_not_in):
        """Sets the model_not_in of this GpuDeviceWhereInput.


        :param model_not_in: The model_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type model_not_in: list[str]
        """

        self._model_not_in = model_not_in

    @property
    def model_not_starts_with(self):
        """Gets the model_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_starts_with

    @model_not_starts_with.setter
    def model_not_starts_with(self, model_not_starts_with):
        """Sets the model_not_starts_with of this GpuDeviceWhereInput.


        :param model_not_starts_with: The model_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type model_not_starts_with: str
        """

        self._model_not_starts_with = model_not_starts_with

    @property
    def model_starts_with(self):
        """Gets the model_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The model_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_starts_with

    @model_starts_with.setter
    def model_starts_with(self, model_starts_with):
        """Sets the model_starts_with of this GpuDeviceWhereInput.


        :param model_starts_with: The model_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type model_starts_with: str
        """

        self._model_starts_with = model_starts_with

    @property
    def name(self):
        """Gets the name of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GpuDeviceWhereInput.


        :param name: The name of this GpuDeviceWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this GpuDeviceWhereInput.


        :param name_contains: The name_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this GpuDeviceWhereInput.


        :param name_ends_with: The name_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this GpuDeviceWhereInput.


        :param name_gt: The name_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this GpuDeviceWhereInput.


        :param name_gte: The name_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this GpuDeviceWhereInput.


        :param name_in: The name_in of this GpuDeviceWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this GpuDeviceWhereInput.


        :param name_lt: The name_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this GpuDeviceWhereInput.


        :param name_lte: The name_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this GpuDeviceWhereInput.


        :param name_not: The name_not of this GpuDeviceWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this GpuDeviceWhereInput.


        :param name_not_contains: The name_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this GpuDeviceWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this GpuDeviceWhereInput.


        :param name_not_in: The name_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this GpuDeviceWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The name_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this GpuDeviceWhereInput.


        :param name_starts_with: The name_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def status(self):
        """Gets the status of this GpuDeviceWhereInput.  # noqa: E501


        :return: The status of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: GpuDeviceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this GpuDeviceWhereInput.


        :param status: The status of this GpuDeviceWhereInput.  # noqa: E501
        :type status: GpuDeviceStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The status_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this GpuDeviceWhereInput.


        :param status_in: The status_in of this GpuDeviceWhereInput.  # noqa: E501
        :type status_in: list[GpuDeviceStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The status_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: GpuDeviceStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this GpuDeviceWhereInput.


        :param status_not: The status_not of this GpuDeviceWhereInput.  # noqa: E501
        :type status_not: GpuDeviceStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The status_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this GpuDeviceWhereInput.


        :param status_not_in: The status_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type status_not_in: list[GpuDeviceStatus]
        """

        self._status_not_in = status_not_in

    @property
    def user_usage(self):
        """Gets the user_usage of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_usage of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: GpuDeviceUsage
        """
        return self._user_usage

    @user_usage.setter
    def user_usage(self, user_usage):
        """Sets the user_usage of this GpuDeviceWhereInput.


        :param user_usage: The user_usage of this GpuDeviceWhereInput.  # noqa: E501
        :type user_usage: GpuDeviceUsage
        """

        self._user_usage = user_usage

    @property
    def user_usage_in(self):
        """Gets the user_usage_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_usage_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceUsage]
        """
        return self._user_usage_in

    @user_usage_in.setter
    def user_usage_in(self, user_usage_in):
        """Sets the user_usage_in of this GpuDeviceWhereInput.


        :param user_usage_in: The user_usage_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_usage_in: list[GpuDeviceUsage]
        """

        self._user_usage_in = user_usage_in

    @property
    def user_usage_not(self):
        """Gets the user_usage_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_usage_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: GpuDeviceUsage
        """
        return self._user_usage_not

    @user_usage_not.setter
    def user_usage_not(self, user_usage_not):
        """Sets the user_usage_not of this GpuDeviceWhereInput.


        :param user_usage_not: The user_usage_not of this GpuDeviceWhereInput.  # noqa: E501
        :type user_usage_not: GpuDeviceUsage
        """

        self._user_usage_not = user_usage_not

    @property
    def user_usage_not_in(self):
        """Gets the user_usage_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_usage_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[GpuDeviceUsage]
        """
        return self._user_usage_not_in

    @user_usage_not_in.setter
    def user_usage_not_in(self, user_usage_not_in):
        """Sets the user_usage_not_in of this GpuDeviceWhereInput.


        :param user_usage_not_in: The user_usage_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_usage_not_in: list[GpuDeviceUsage]
        """

        self._user_usage_not_in = user_usage_not_in

    @property
    def user_vgpu_type_id(self):
        """Gets the user_vgpu_type_id of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id

    @user_vgpu_type_id.setter
    def user_vgpu_type_id(self, user_vgpu_type_id):
        """Sets the user_vgpu_type_id of this GpuDeviceWhereInput.


        :param user_vgpu_type_id: The user_vgpu_type_id of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id: str
        """

        self._user_vgpu_type_id = user_vgpu_type_id

    @property
    def user_vgpu_type_id_contains(self):
        """Gets the user_vgpu_type_id_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_contains

    @user_vgpu_type_id_contains.setter
    def user_vgpu_type_id_contains(self, user_vgpu_type_id_contains):
        """Sets the user_vgpu_type_id_contains of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_contains: The user_vgpu_type_id_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_contains: str
        """

        self._user_vgpu_type_id_contains = user_vgpu_type_id_contains

    @property
    def user_vgpu_type_id_ends_with(self):
        """Gets the user_vgpu_type_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_ends_with

    @user_vgpu_type_id_ends_with.setter
    def user_vgpu_type_id_ends_with(self, user_vgpu_type_id_ends_with):
        """Sets the user_vgpu_type_id_ends_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_ends_with: The user_vgpu_type_id_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_ends_with: str
        """

        self._user_vgpu_type_id_ends_with = user_vgpu_type_id_ends_with

    @property
    def user_vgpu_type_id_gt(self):
        """Gets the user_vgpu_type_id_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_gt

    @user_vgpu_type_id_gt.setter
    def user_vgpu_type_id_gt(self, user_vgpu_type_id_gt):
        """Sets the user_vgpu_type_id_gt of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_gt: The user_vgpu_type_id_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_gt: str
        """

        self._user_vgpu_type_id_gt = user_vgpu_type_id_gt

    @property
    def user_vgpu_type_id_gte(self):
        """Gets the user_vgpu_type_id_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_gte

    @user_vgpu_type_id_gte.setter
    def user_vgpu_type_id_gte(self, user_vgpu_type_id_gte):
        """Sets the user_vgpu_type_id_gte of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_gte: The user_vgpu_type_id_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_gte: str
        """

        self._user_vgpu_type_id_gte = user_vgpu_type_id_gte

    @property
    def user_vgpu_type_id_in(self):
        """Gets the user_vgpu_type_id_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_vgpu_type_id_in

    @user_vgpu_type_id_in.setter
    def user_vgpu_type_id_in(self, user_vgpu_type_id_in):
        """Sets the user_vgpu_type_id_in of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_in: The user_vgpu_type_id_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_in: list[str]
        """

        self._user_vgpu_type_id_in = user_vgpu_type_id_in

    @property
    def user_vgpu_type_id_lt(self):
        """Gets the user_vgpu_type_id_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_lt

    @user_vgpu_type_id_lt.setter
    def user_vgpu_type_id_lt(self, user_vgpu_type_id_lt):
        """Sets the user_vgpu_type_id_lt of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_lt: The user_vgpu_type_id_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_lt: str
        """

        self._user_vgpu_type_id_lt = user_vgpu_type_id_lt

    @property
    def user_vgpu_type_id_lte(self):
        """Gets the user_vgpu_type_id_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_lte

    @user_vgpu_type_id_lte.setter
    def user_vgpu_type_id_lte(self, user_vgpu_type_id_lte):
        """Sets the user_vgpu_type_id_lte of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_lte: The user_vgpu_type_id_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_lte: str
        """

        self._user_vgpu_type_id_lte = user_vgpu_type_id_lte

    @property
    def user_vgpu_type_id_not(self):
        """Gets the user_vgpu_type_id_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_not

    @user_vgpu_type_id_not.setter
    def user_vgpu_type_id_not(self, user_vgpu_type_id_not):
        """Sets the user_vgpu_type_id_not of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_not: The user_vgpu_type_id_not of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_not: str
        """

        self._user_vgpu_type_id_not = user_vgpu_type_id_not

    @property
    def user_vgpu_type_id_not_contains(self):
        """Gets the user_vgpu_type_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_not_contains

    @user_vgpu_type_id_not_contains.setter
    def user_vgpu_type_id_not_contains(self, user_vgpu_type_id_not_contains):
        """Sets the user_vgpu_type_id_not_contains of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_not_contains: The user_vgpu_type_id_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_not_contains: str
        """

        self._user_vgpu_type_id_not_contains = user_vgpu_type_id_not_contains

    @property
    def user_vgpu_type_id_not_ends_with(self):
        """Gets the user_vgpu_type_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_not_ends_with

    @user_vgpu_type_id_not_ends_with.setter
    def user_vgpu_type_id_not_ends_with(self, user_vgpu_type_id_not_ends_with):
        """Sets the user_vgpu_type_id_not_ends_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_not_ends_with: The user_vgpu_type_id_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_not_ends_with: str
        """

        self._user_vgpu_type_id_not_ends_with = user_vgpu_type_id_not_ends_with

    @property
    def user_vgpu_type_id_not_in(self):
        """Gets the user_vgpu_type_id_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_vgpu_type_id_not_in

    @user_vgpu_type_id_not_in.setter
    def user_vgpu_type_id_not_in(self, user_vgpu_type_id_not_in):
        """Sets the user_vgpu_type_id_not_in of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_not_in: The user_vgpu_type_id_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_not_in: list[str]
        """

        self._user_vgpu_type_id_not_in = user_vgpu_type_id_not_in

    @property
    def user_vgpu_type_id_not_starts_with(self):
        """Gets the user_vgpu_type_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_not_starts_with

    @user_vgpu_type_id_not_starts_with.setter
    def user_vgpu_type_id_not_starts_with(self, user_vgpu_type_id_not_starts_with):
        """Sets the user_vgpu_type_id_not_starts_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_not_starts_with: The user_vgpu_type_id_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_not_starts_with: str
        """

        self._user_vgpu_type_id_not_starts_with = user_vgpu_type_id_not_starts_with

    @property
    def user_vgpu_type_id_starts_with(self):
        """Gets the user_vgpu_type_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id_starts_with

    @user_vgpu_type_id_starts_with.setter
    def user_vgpu_type_id_starts_with(self, user_vgpu_type_id_starts_with):
        """Sets the user_vgpu_type_id_starts_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_id_starts_with: The user_vgpu_type_id_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_id_starts_with: str
        """

        self._user_vgpu_type_id_starts_with = user_vgpu_type_id_starts_with

    @property
    def user_vgpu_type_name(self):
        """Gets the user_vgpu_type_name of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name

    @user_vgpu_type_name.setter
    def user_vgpu_type_name(self, user_vgpu_type_name):
        """Sets the user_vgpu_type_name of this GpuDeviceWhereInput.


        :param user_vgpu_type_name: The user_vgpu_type_name of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name: str
        """

        self._user_vgpu_type_name = user_vgpu_type_name

    @property
    def user_vgpu_type_name_contains(self):
        """Gets the user_vgpu_type_name_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_contains

    @user_vgpu_type_name_contains.setter
    def user_vgpu_type_name_contains(self, user_vgpu_type_name_contains):
        """Sets the user_vgpu_type_name_contains of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_contains: The user_vgpu_type_name_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_contains: str
        """

        self._user_vgpu_type_name_contains = user_vgpu_type_name_contains

    @property
    def user_vgpu_type_name_ends_with(self):
        """Gets the user_vgpu_type_name_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_ends_with

    @user_vgpu_type_name_ends_with.setter
    def user_vgpu_type_name_ends_with(self, user_vgpu_type_name_ends_with):
        """Sets the user_vgpu_type_name_ends_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_ends_with: The user_vgpu_type_name_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_ends_with: str
        """

        self._user_vgpu_type_name_ends_with = user_vgpu_type_name_ends_with

    @property
    def user_vgpu_type_name_gt(self):
        """Gets the user_vgpu_type_name_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_gt

    @user_vgpu_type_name_gt.setter
    def user_vgpu_type_name_gt(self, user_vgpu_type_name_gt):
        """Sets the user_vgpu_type_name_gt of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_gt: The user_vgpu_type_name_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_gt: str
        """

        self._user_vgpu_type_name_gt = user_vgpu_type_name_gt

    @property
    def user_vgpu_type_name_gte(self):
        """Gets the user_vgpu_type_name_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_gte

    @user_vgpu_type_name_gte.setter
    def user_vgpu_type_name_gte(self, user_vgpu_type_name_gte):
        """Sets the user_vgpu_type_name_gte of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_gte: The user_vgpu_type_name_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_gte: str
        """

        self._user_vgpu_type_name_gte = user_vgpu_type_name_gte

    @property
    def user_vgpu_type_name_in(self):
        """Gets the user_vgpu_type_name_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_vgpu_type_name_in

    @user_vgpu_type_name_in.setter
    def user_vgpu_type_name_in(self, user_vgpu_type_name_in):
        """Sets the user_vgpu_type_name_in of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_in: The user_vgpu_type_name_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_in: list[str]
        """

        self._user_vgpu_type_name_in = user_vgpu_type_name_in

    @property
    def user_vgpu_type_name_lt(self):
        """Gets the user_vgpu_type_name_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_lt

    @user_vgpu_type_name_lt.setter
    def user_vgpu_type_name_lt(self, user_vgpu_type_name_lt):
        """Sets the user_vgpu_type_name_lt of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_lt: The user_vgpu_type_name_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_lt: str
        """

        self._user_vgpu_type_name_lt = user_vgpu_type_name_lt

    @property
    def user_vgpu_type_name_lte(self):
        """Gets the user_vgpu_type_name_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_lte

    @user_vgpu_type_name_lte.setter
    def user_vgpu_type_name_lte(self, user_vgpu_type_name_lte):
        """Sets the user_vgpu_type_name_lte of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_lte: The user_vgpu_type_name_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_lte: str
        """

        self._user_vgpu_type_name_lte = user_vgpu_type_name_lte

    @property
    def user_vgpu_type_name_not(self):
        """Gets the user_vgpu_type_name_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_not

    @user_vgpu_type_name_not.setter
    def user_vgpu_type_name_not(self, user_vgpu_type_name_not):
        """Sets the user_vgpu_type_name_not of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_not: The user_vgpu_type_name_not of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_not: str
        """

        self._user_vgpu_type_name_not = user_vgpu_type_name_not

    @property
    def user_vgpu_type_name_not_contains(self):
        """Gets the user_vgpu_type_name_not_contains of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_not_contains

    @user_vgpu_type_name_not_contains.setter
    def user_vgpu_type_name_not_contains(self, user_vgpu_type_name_not_contains):
        """Sets the user_vgpu_type_name_not_contains of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_not_contains: The user_vgpu_type_name_not_contains of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_not_contains: str
        """

        self._user_vgpu_type_name_not_contains = user_vgpu_type_name_not_contains

    @property
    def user_vgpu_type_name_not_ends_with(self):
        """Gets the user_vgpu_type_name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_not_ends_with

    @user_vgpu_type_name_not_ends_with.setter
    def user_vgpu_type_name_not_ends_with(self, user_vgpu_type_name_not_ends_with):
        """Sets the user_vgpu_type_name_not_ends_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_not_ends_with: The user_vgpu_type_name_not_ends_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_not_ends_with: str
        """

        self._user_vgpu_type_name_not_ends_with = user_vgpu_type_name_not_ends_with

    @property
    def user_vgpu_type_name_not_in(self):
        """Gets the user_vgpu_type_name_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_vgpu_type_name_not_in

    @user_vgpu_type_name_not_in.setter
    def user_vgpu_type_name_not_in(self, user_vgpu_type_name_not_in):
        """Sets the user_vgpu_type_name_not_in of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_not_in: The user_vgpu_type_name_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_not_in: list[str]
        """

        self._user_vgpu_type_name_not_in = user_vgpu_type_name_not_in

    @property
    def user_vgpu_type_name_not_starts_with(self):
        """Gets the user_vgpu_type_name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_not_starts_with

    @user_vgpu_type_name_not_starts_with.setter
    def user_vgpu_type_name_not_starts_with(self, user_vgpu_type_name_not_starts_with):
        """Sets the user_vgpu_type_name_not_starts_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_not_starts_with: The user_vgpu_type_name_not_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_not_starts_with: str
        """

        self._user_vgpu_type_name_not_starts_with = user_vgpu_type_name_not_starts_with

    @property
    def user_vgpu_type_name_starts_with(self):
        """Gets the user_vgpu_type_name_starts_with of this GpuDeviceWhereInput.  # noqa: E501


        :return: The user_vgpu_type_name_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name_starts_with

    @user_vgpu_type_name_starts_with.setter
    def user_vgpu_type_name_starts_with(self, user_vgpu_type_name_starts_with):
        """Sets the user_vgpu_type_name_starts_with of this GpuDeviceWhereInput.


        :param user_vgpu_type_name_starts_with: The user_vgpu_type_name_starts_with of this GpuDeviceWhereInput.  # noqa: E501
        :type user_vgpu_type_name_starts_with: str
        """

        self._user_vgpu_type_name_starts_with = user_vgpu_type_name_starts_with

    @property
    def vgpu_instance_num(self):
        """Gets the vgpu_instance_num of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num

    @vgpu_instance_num.setter
    def vgpu_instance_num(self, vgpu_instance_num):
        """Sets the vgpu_instance_num of this GpuDeviceWhereInput.


        :param vgpu_instance_num: The vgpu_instance_num of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num: int
        """

        self._vgpu_instance_num = vgpu_instance_num

    @property
    def vgpu_instance_num_gt(self):
        """Gets the vgpu_instance_num_gt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num_gt

    @vgpu_instance_num_gt.setter
    def vgpu_instance_num_gt(self, vgpu_instance_num_gt):
        """Sets the vgpu_instance_num_gt of this GpuDeviceWhereInput.


        :param vgpu_instance_num_gt: The vgpu_instance_num_gt of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_gt: int
        """

        self._vgpu_instance_num_gt = vgpu_instance_num_gt

    @property
    def vgpu_instance_num_gte(self):
        """Gets the vgpu_instance_num_gte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num_gte

    @vgpu_instance_num_gte.setter
    def vgpu_instance_num_gte(self, vgpu_instance_num_gte):
        """Sets the vgpu_instance_num_gte of this GpuDeviceWhereInput.


        :param vgpu_instance_num_gte: The vgpu_instance_num_gte of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_gte: int
        """

        self._vgpu_instance_num_gte = vgpu_instance_num_gte

    @property
    def vgpu_instance_num_in(self):
        """Gets the vgpu_instance_num_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vgpu_instance_num_in

    @vgpu_instance_num_in.setter
    def vgpu_instance_num_in(self, vgpu_instance_num_in):
        """Sets the vgpu_instance_num_in of this GpuDeviceWhereInput.


        :param vgpu_instance_num_in: The vgpu_instance_num_in of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_in: list[int]
        """

        self._vgpu_instance_num_in = vgpu_instance_num_in

    @property
    def vgpu_instance_num_lt(self):
        """Gets the vgpu_instance_num_lt of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num_lt

    @vgpu_instance_num_lt.setter
    def vgpu_instance_num_lt(self, vgpu_instance_num_lt):
        """Sets the vgpu_instance_num_lt of this GpuDeviceWhereInput.


        :param vgpu_instance_num_lt: The vgpu_instance_num_lt of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_lt: int
        """

        self._vgpu_instance_num_lt = vgpu_instance_num_lt

    @property
    def vgpu_instance_num_lte(self):
        """Gets the vgpu_instance_num_lte of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num_lte

    @vgpu_instance_num_lte.setter
    def vgpu_instance_num_lte(self, vgpu_instance_num_lte):
        """Sets the vgpu_instance_num_lte of this GpuDeviceWhereInput.


        :param vgpu_instance_num_lte: The vgpu_instance_num_lte of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_lte: int
        """

        self._vgpu_instance_num_lte = vgpu_instance_num_lte

    @property
    def vgpu_instance_num_not(self):
        """Gets the vgpu_instance_num_not of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num_not

    @vgpu_instance_num_not.setter
    def vgpu_instance_num_not(self, vgpu_instance_num_not):
        """Sets the vgpu_instance_num_not of this GpuDeviceWhereInput.


        :param vgpu_instance_num_not: The vgpu_instance_num_not of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_not: int
        """

        self._vgpu_instance_num_not = vgpu_instance_num_not

    @property
    def vgpu_instance_num_not_in(self):
        """Gets the vgpu_instance_num_not_in of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vgpu_instance_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vgpu_instance_num_not_in

    @vgpu_instance_num_not_in.setter
    def vgpu_instance_num_not_in(self, vgpu_instance_num_not_in):
        """Sets the vgpu_instance_num_not_in of this GpuDeviceWhereInput.


        :param vgpu_instance_num_not_in: The vgpu_instance_num_not_in of this GpuDeviceWhereInput.  # noqa: E501
        :type vgpu_instance_num_not_in: list[int]
        """

        self._vgpu_instance_num_not_in = vgpu_instance_num_not_in

    @property
    def vms_every(self):
        """Gets the vms_every of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vms_every of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_every

    @vms_every.setter
    def vms_every(self, vms_every):
        """Sets the vms_every of this GpuDeviceWhereInput.


        :param vms_every: The vms_every of this GpuDeviceWhereInput.  # noqa: E501
        :type vms_every: VmWhereInput
        """

        self._vms_every = vms_every

    @property
    def vms_none(self):
        """Gets the vms_none of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vms_none of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_none

    @vms_none.setter
    def vms_none(self, vms_none):
        """Sets the vms_none of this GpuDeviceWhereInput.


        :param vms_none: The vms_none of this GpuDeviceWhereInput.  # noqa: E501
        :type vms_none: VmWhereInput
        """

        self._vms_none = vms_none

    @property
    def vms_some(self):
        """Gets the vms_some of this GpuDeviceWhereInput.  # noqa: E501


        :return: The vms_some of this GpuDeviceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_some

    @vms_some.setter
    def vms_some(self, vms_some):
        """Sets the vms_some of this GpuDeviceWhereInput.


        :param vms_some: The vms_some of this GpuDeviceWhereInput.  # noqa: E501
        :type vms_some: VmWhereInput
        """

        self._vms_some = vms_some

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GpuDeviceWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GpuDeviceWhereInput):
            return True

        return self.to_dict() != other.to_dict()
