# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class GpuVmInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vms': 'list[GpuVmDetail]',
        'vgpu_instance_num': 'int',
        'user_vgpu_type_name': 'str',
        'user_vgpu_type_id': 'str',
        'user_usage': 'GpuDeviceUsage',
        'status': 'GpuDeviceStatus',
        'name': 'str',
        'model': 'str',
        'mdev_supported_types': 'list[NestedVgpuType]',
        'local_id': 'str',
        'local_created_at': 'str',
        'labels': 'list[NestedLabel]',
        'is_nvidia_vfs_supported': 'bool',
        'is_nvidia_vfs_enabled': 'bool',
        'is_nvidia_tools_ready': 'bool',
        'id': 'str',
        'host': 'NestedHost',
        'entity_async_status': 'EntityAsyncStatus',
        'driver_info': 'NestedGpuDriverInfo',
        'description': 'str',
        'bus_location': 'str',
        'brand': 'str',
        'available_vgpus_num': 'int',
        'assigned_vgpus_num': 'int'
    }

    attribute_map = {
        'vms': 'vms',
        'vgpu_instance_num': 'vgpu_instance_num',
        'user_vgpu_type_name': 'user_vgpu_type_name',
        'user_vgpu_type_id': 'user_vgpu_type_id',
        'user_usage': 'user_usage',
        'status': 'status',
        'name': 'name',
        'model': 'model',
        'mdev_supported_types': 'mdev_supported_types',
        'local_id': 'local_id',
        'local_created_at': 'local_created_at',
        'labels': 'labels',
        'is_nvidia_vfs_supported': 'is_nvidia_vfs_supported',
        'is_nvidia_vfs_enabled': 'is_nvidia_vfs_enabled',
        'is_nvidia_tools_ready': 'is_nvidia_tools_ready',
        'id': 'id',
        'host': 'host',
        'entity_async_status': 'entityAsyncStatus',
        'driver_info': 'driver_info',
        'description': 'description',
        'bus_location': 'bus_location',
        'brand': 'brand',
        'available_vgpus_num': 'available_vgpus_num',
        'assigned_vgpus_num': 'assigned_vgpus_num'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """GpuVmInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vms = None
        self._vgpu_instance_num = None
        self._user_vgpu_type_name = None
        self._user_vgpu_type_id = None
        self._user_usage = None
        self._status = None
        self._name = None
        self._model = None
        self._mdev_supported_types = None
        self._local_id = None
        self._local_created_at = None
        self._labels = None
        self._is_nvidia_vfs_supported = None
        self._is_nvidia_vfs_enabled = None
        self._is_nvidia_tools_ready = None
        self._id = None
        self._host = None
        self._entity_async_status = None
        self._driver_info = None
        self._description = None
        self._bus_location = None
        self._brand = None
        self._available_vgpus_num = None
        self._assigned_vgpus_num = None
        self.discriminator = None

        if "vms" in kwargs:
            self.vms = kwargs["vms"]
        self.vgpu_instance_num = kwargs.get("vgpu_instance_num", None)
        self.user_vgpu_type_name = kwargs.get("user_vgpu_type_name", None)
        self.user_vgpu_type_id = kwargs.get("user_vgpu_type_id", None)
        self.user_usage = kwargs.get("user_usage", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "model" in kwargs:
            self.model = kwargs["model"]
        self.mdev_supported_types = kwargs.get("mdev_supported_types", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        self.labels = kwargs.get("labels", None)
        self.is_nvidia_vfs_supported = kwargs.get("is_nvidia_vfs_supported", None)
        self.is_nvidia_vfs_enabled = kwargs.get("is_nvidia_vfs_enabled", None)
        self.is_nvidia_tools_ready = kwargs.get("is_nvidia_tools_ready", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "host" in kwargs:
            self.host = kwargs["host"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.driver_info = kwargs.get("driver_info", None)
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "bus_location" in kwargs:
            self.bus_location = kwargs["bus_location"]
        if "brand" in kwargs:
            self.brand = kwargs["brand"]
        self.available_vgpus_num = kwargs.get("available_vgpus_num", None)
        self.assigned_vgpus_num = kwargs.get("assigned_vgpus_num", None)

    @property
    def vms(self):
        """Gets the vms of this GpuVmInfo.  # noqa: E501


        :return: The vms of this GpuVmInfo.  # noqa: E501
        :rtype: list[GpuVmDetail]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this GpuVmInfo.


        :param vms: The vms of this GpuVmInfo.  # noqa: E501
        :type vms: list[GpuVmDetail]
        """
        if self.local_vars_configuration.client_side_validation and vms is None:  # noqa: E501
            raise ValueError("Invalid value for `vms`, must not be `None`")  # noqa: E501

        self._vms = vms

    @property
    def vgpu_instance_num(self):
        """Gets the vgpu_instance_num of this GpuVmInfo.  # noqa: E501


        :return: The vgpu_instance_num of this GpuVmInfo.  # noqa: E501
        :rtype: int
        """
        return self._vgpu_instance_num

    @vgpu_instance_num.setter
    def vgpu_instance_num(self, vgpu_instance_num):
        """Sets the vgpu_instance_num of this GpuVmInfo.


        :param vgpu_instance_num: The vgpu_instance_num of this GpuVmInfo.  # noqa: E501
        :type vgpu_instance_num: int
        """

        self._vgpu_instance_num = vgpu_instance_num

    @property
    def user_vgpu_type_name(self):
        """Gets the user_vgpu_type_name of this GpuVmInfo.  # noqa: E501


        :return: The user_vgpu_type_name of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_name

    @user_vgpu_type_name.setter
    def user_vgpu_type_name(self, user_vgpu_type_name):
        """Sets the user_vgpu_type_name of this GpuVmInfo.


        :param user_vgpu_type_name: The user_vgpu_type_name of this GpuVmInfo.  # noqa: E501
        :type user_vgpu_type_name: str
        """

        self._user_vgpu_type_name = user_vgpu_type_name

    @property
    def user_vgpu_type_id(self):
        """Gets the user_vgpu_type_id of this GpuVmInfo.  # noqa: E501


        :return: The user_vgpu_type_id of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._user_vgpu_type_id

    @user_vgpu_type_id.setter
    def user_vgpu_type_id(self, user_vgpu_type_id):
        """Sets the user_vgpu_type_id of this GpuVmInfo.


        :param user_vgpu_type_id: The user_vgpu_type_id of this GpuVmInfo.  # noqa: E501
        :type user_vgpu_type_id: str
        """

        self._user_vgpu_type_id = user_vgpu_type_id

    @property
    def user_usage(self):
        """Gets the user_usage of this GpuVmInfo.  # noqa: E501


        :return: The user_usage of this GpuVmInfo.  # noqa: E501
        :rtype: GpuDeviceUsage
        """
        return self._user_usage

    @user_usage.setter
    def user_usage(self, user_usage):
        """Sets the user_usage of this GpuVmInfo.


        :param user_usage: The user_usage of this GpuVmInfo.  # noqa: E501
        :type user_usage: GpuDeviceUsage
        """

        self._user_usage = user_usage

    @property
    def status(self):
        """Gets the status of this GpuVmInfo.  # noqa: E501


        :return: The status of this GpuVmInfo.  # noqa: E501
        :rtype: GpuDeviceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this GpuVmInfo.


        :param status: The status of this GpuVmInfo.  # noqa: E501
        :type status: GpuDeviceStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def name(self):
        """Gets the name of this GpuVmInfo.  # noqa: E501


        :return: The name of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GpuVmInfo.


        :param name: The name of this GpuVmInfo.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def model(self):
        """Gets the model of this GpuVmInfo.  # noqa: E501


        :return: The model of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this GpuVmInfo.


        :param model: The model of this GpuVmInfo.  # noqa: E501
        :type model: str
        """
        if self.local_vars_configuration.client_side_validation and model is None:  # noqa: E501
            raise ValueError("Invalid value for `model`, must not be `None`")  # noqa: E501

        self._model = model

    @property
    def mdev_supported_types(self):
        """Gets the mdev_supported_types of this GpuVmInfo.  # noqa: E501


        :return: The mdev_supported_types of this GpuVmInfo.  # noqa: E501
        :rtype: list[NestedVgpuType]
        """
        return self._mdev_supported_types

    @mdev_supported_types.setter
    def mdev_supported_types(self, mdev_supported_types):
        """Sets the mdev_supported_types of this GpuVmInfo.


        :param mdev_supported_types: The mdev_supported_types of this GpuVmInfo.  # noqa: E501
        :type mdev_supported_types: list[NestedVgpuType]
        """

        self._mdev_supported_types = mdev_supported_types

    @property
    def local_id(self):
        """Gets the local_id of this GpuVmInfo.  # noqa: E501


        :return: The local_id of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this GpuVmInfo.


        :param local_id: The local_id of this GpuVmInfo.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def local_created_at(self):
        """Gets the local_created_at of this GpuVmInfo.  # noqa: E501


        :return: The local_created_at of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this GpuVmInfo.


        :param local_created_at: The local_created_at of this GpuVmInfo.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def labels(self):
        """Gets the labels of this GpuVmInfo.  # noqa: E501


        :return: The labels of this GpuVmInfo.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this GpuVmInfo.


        :param labels: The labels of this GpuVmInfo.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def is_nvidia_vfs_supported(self):
        """Gets the is_nvidia_vfs_supported of this GpuVmInfo.  # noqa: E501


        :return: The is_nvidia_vfs_supported of this GpuVmInfo.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_supported

    @is_nvidia_vfs_supported.setter
    def is_nvidia_vfs_supported(self, is_nvidia_vfs_supported):
        """Sets the is_nvidia_vfs_supported of this GpuVmInfo.


        :param is_nvidia_vfs_supported: The is_nvidia_vfs_supported of this GpuVmInfo.  # noqa: E501
        :type is_nvidia_vfs_supported: bool
        """

        self._is_nvidia_vfs_supported = is_nvidia_vfs_supported

    @property
    def is_nvidia_vfs_enabled(self):
        """Gets the is_nvidia_vfs_enabled of this GpuVmInfo.  # noqa: E501


        :return: The is_nvidia_vfs_enabled of this GpuVmInfo.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_vfs_enabled

    @is_nvidia_vfs_enabled.setter
    def is_nvidia_vfs_enabled(self, is_nvidia_vfs_enabled):
        """Sets the is_nvidia_vfs_enabled of this GpuVmInfo.


        :param is_nvidia_vfs_enabled: The is_nvidia_vfs_enabled of this GpuVmInfo.  # noqa: E501
        :type is_nvidia_vfs_enabled: bool
        """

        self._is_nvidia_vfs_enabled = is_nvidia_vfs_enabled

    @property
    def is_nvidia_tools_ready(self):
        """Gets the is_nvidia_tools_ready of this GpuVmInfo.  # noqa: E501


        :return: The is_nvidia_tools_ready of this GpuVmInfo.  # noqa: E501
        :rtype: bool
        """
        return self._is_nvidia_tools_ready

    @is_nvidia_tools_ready.setter
    def is_nvidia_tools_ready(self, is_nvidia_tools_ready):
        """Sets the is_nvidia_tools_ready of this GpuVmInfo.


        :param is_nvidia_tools_ready: The is_nvidia_tools_ready of this GpuVmInfo.  # noqa: E501
        :type is_nvidia_tools_ready: bool
        """

        self._is_nvidia_tools_ready = is_nvidia_tools_ready

    @property
    def id(self):
        """Gets the id of this GpuVmInfo.  # noqa: E501


        :return: The id of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GpuVmInfo.


        :param id: The id of this GpuVmInfo.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def host(self):
        """Gets the host of this GpuVmInfo.  # noqa: E501


        :return: The host of this GpuVmInfo.  # noqa: E501
        :rtype: NestedHost
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this GpuVmInfo.


        :param host: The host of this GpuVmInfo.  # noqa: E501
        :type host: NestedHost
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this GpuVmInfo.  # noqa: E501


        :return: The entity_async_status of this GpuVmInfo.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this GpuVmInfo.


        :param entity_async_status: The entity_async_status of this GpuVmInfo.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def driver_info(self):
        """Gets the driver_info of this GpuVmInfo.  # noqa: E501


        :return: The driver_info of this GpuVmInfo.  # noqa: E501
        :rtype: NestedGpuDriverInfo
        """
        return self._driver_info

    @driver_info.setter
    def driver_info(self, driver_info):
        """Sets the driver_info of this GpuVmInfo.


        :param driver_info: The driver_info of this GpuVmInfo.  # noqa: E501
        :type driver_info: NestedGpuDriverInfo
        """

        self._driver_info = driver_info

    @property
    def description(self):
        """Gets the description of this GpuVmInfo.  # noqa: E501


        :return: The description of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GpuVmInfo.


        :param description: The description of this GpuVmInfo.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def bus_location(self):
        """Gets the bus_location of this GpuVmInfo.  # noqa: E501


        :return: The bus_location of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._bus_location

    @bus_location.setter
    def bus_location(self, bus_location):
        """Sets the bus_location of this GpuVmInfo.


        :param bus_location: The bus_location of this GpuVmInfo.  # noqa: E501
        :type bus_location: str
        """
        if self.local_vars_configuration.client_side_validation and bus_location is None:  # noqa: E501
            raise ValueError("Invalid value for `bus_location`, must not be `None`")  # noqa: E501

        self._bus_location = bus_location

    @property
    def brand(self):
        """Gets the brand of this GpuVmInfo.  # noqa: E501


        :return: The brand of this GpuVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this GpuVmInfo.


        :param brand: The brand of this GpuVmInfo.  # noqa: E501
        :type brand: str
        """
        if self.local_vars_configuration.client_side_validation and brand is None:  # noqa: E501
            raise ValueError("Invalid value for `brand`, must not be `None`")  # noqa: E501

        self._brand = brand

    @property
    def available_vgpus_num(self):
        """Gets the available_vgpus_num of this GpuVmInfo.  # noqa: E501


        :return: The available_vgpus_num of this GpuVmInfo.  # noqa: E501
        :rtype: int
        """
        return self._available_vgpus_num

    @available_vgpus_num.setter
    def available_vgpus_num(self, available_vgpus_num):
        """Sets the available_vgpus_num of this GpuVmInfo.


        :param available_vgpus_num: The available_vgpus_num of this GpuVmInfo.  # noqa: E501
        :type available_vgpus_num: int
        """

        self._available_vgpus_num = available_vgpus_num

    @property
    def assigned_vgpus_num(self):
        """Gets the assigned_vgpus_num of this GpuVmInfo.  # noqa: E501


        :return: The assigned_vgpus_num of this GpuVmInfo.  # noqa: E501
        :rtype: int
        """
        return self._assigned_vgpus_num

    @assigned_vgpus_num.setter
    def assigned_vgpus_num(self, assigned_vgpus_num):
        """Sets the assigned_vgpus_num of this GpuVmInfo.


        :param assigned_vgpus_num: The assigned_vgpus_num of this GpuVmInfo.  # noqa: E501
        :type assigned_vgpus_num: int
        """

        self._assigned_vgpus_num = assigned_vgpus_num

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GpuVmInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GpuVmInfo):
            return True

        return self.to_dict() != other.to_dict()
