# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class HostCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'auth_info': 'HostAuthInfo',
        'data': 'list[HostCreationParamsData]',
        'cluster_id': 'str'
    }

    attribute_map = {
        'auth_info': 'auth_info',
        'data': 'data',
        'cluster_id': 'cluster_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """HostCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._auth_info = None
        self._data = None
        self._cluster_id = None
        self.discriminator = None

        if "auth_info" in kwargs:
            self.auth_info = kwargs["auth_info"]
        if "data" in kwargs:
            self.data = kwargs["data"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]

    @property
    def auth_info(self):
        """Gets the auth_info of this HostCreationParams.  # noqa: E501


        :return: The auth_info of this HostCreationParams.  # noqa: E501
        :rtype: HostAuthInfo
        """
        return self._auth_info

    @auth_info.setter
    def auth_info(self, auth_info):
        """Sets the auth_info of this HostCreationParams.


        :param auth_info: The auth_info of this HostCreationParams.  # noqa: E501
        :type auth_info: HostAuthInfo
        """

        self._auth_info = auth_info

    @property
    def data(self):
        """Gets the data of this HostCreationParams.  # noqa: E501


        :return: The data of this HostCreationParams.  # noqa: E501
        :rtype: list[HostCreationParamsData]
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this HostCreationParams.


        :param data: The data of this HostCreationParams.  # noqa: E501
        :type data: list[HostCreationParamsData]
        """
        if self.local_vars_configuration.client_side_validation and data is None:  # noqa: E501
            raise ValueError("Invalid value for `data`, must not be `None`")  # noqa: E501

        self._data = data

    @property
    def cluster_id(self):
        """Gets the cluster_id of this HostCreationParams.  # noqa: E501


        :return: The cluster_id of this HostCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this HostCreationParams.


        :param cluster_id: The cluster_id of this HostCreationParams.  # noqa: E501
        :type cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_id`, must not be `None`")  # noqa: E501

        self._cluster_id = cluster_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HostCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HostCreationParams):
            return True

        return self.to_dict() != other.to_dict()
