# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class HostWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[HostWhereInput]',
        '_not': 'list[HostWhereInput]',
        '_or': 'list[HostWhereInput]',
        'access_ip': 'str',
        'access_ip_contains': 'str',
        'access_ip_ends_with': 'str',
        'access_ip_gt': 'str',
        'access_ip_gte': 'str',
        'access_ip_in': 'list[str]',
        'access_ip_lt': 'str',
        'access_ip_lte': 'str',
        'access_ip_not': 'str',
        'access_ip_not_contains': 'str',
        'access_ip_not_ends_with': 'str',
        'access_ip_not_in': 'list[str]',
        'access_ip_not_starts_with': 'str',
        'access_ip_starts_with': 'str',
        'allocable_cpu_cores_for_vm_exclusive': 'int',
        'allocable_cpu_cores_for_vm_exclusive_gt': 'int',
        'allocable_cpu_cores_for_vm_exclusive_gte': 'int',
        'allocable_cpu_cores_for_vm_exclusive_in': 'list[int]',
        'allocable_cpu_cores_for_vm_exclusive_lt': 'int',
        'allocable_cpu_cores_for_vm_exclusive_lte': 'int',
        'allocable_cpu_cores_for_vm_exclusive_not': 'int',
        'allocable_cpu_cores_for_vm_exclusive_not_in': 'list[int]',
        'allocatable_memory_bytes': 'int',
        'allocatable_memory_bytes_gt': 'int',
        'allocatable_memory_bytes_gte': 'int',
        'allocatable_memory_bytes_in': 'list[int]',
        'allocatable_memory_bytes_lt': 'int',
        'allocatable_memory_bytes_lte': 'int',
        'allocatable_memory_bytes_not': 'int',
        'allocatable_memory_bytes_not_in': 'list[int]',
        'allocated_prioritized_space': 'int',
        'allocated_prioritized_space_gt': 'int',
        'allocated_prioritized_space_gte': 'int',
        'allocated_prioritized_space_in': 'list[int]',
        'allocated_prioritized_space_lt': 'int',
        'allocated_prioritized_space_lte': 'int',
        'allocated_prioritized_space_not': 'int',
        'allocated_prioritized_space_not_in': 'list[int]',
        'allocated_prioritized_space_usage': 'float',
        'allocated_prioritized_space_usage_gt': 'float',
        'allocated_prioritized_space_usage_gte': 'float',
        'allocated_prioritized_space_usage_in': 'list[float]',
        'allocated_prioritized_space_usage_lt': 'float',
        'allocated_prioritized_space_usage_lte': 'float',
        'allocated_prioritized_space_usage_not': 'float',
        'allocated_prioritized_space_usage_not_in': 'list[float]',
        'chunk_id': 'str',
        'chunk_id_contains': 'str',
        'chunk_id_ends_with': 'str',
        'chunk_id_gt': 'str',
        'chunk_id_gte': 'str',
        'chunk_id_in': 'list[str]',
        'chunk_id_lt': 'str',
        'chunk_id_lte': 'str',
        'chunk_id_not': 'str',
        'chunk_id_not_contains': 'str',
        'chunk_id_not_ends_with': 'str',
        'chunk_id_not_in': 'list[str]',
        'chunk_id_not_starts_with': 'str',
        'chunk_id_starts_with': 'str',
        'cluster': 'ClusterWhereInput',
        'commited_memory_bytes': 'int',
        'commited_memory_bytes_gt': 'int',
        'commited_memory_bytes_gte': 'int',
        'commited_memory_bytes_in': 'list[int]',
        'commited_memory_bytes_lt': 'int',
        'commited_memory_bytes_lte': 'int',
        'commited_memory_bytes_not': 'int',
        'commited_memory_bytes_not_in': 'list[int]',
        'connect_status': 'HostConnectStatus',
        'connect_status_in': 'list[HostConnectStatus]',
        'connect_status_not': 'HostConnectStatus',
        'connect_status_not_in': 'list[HostConnectStatus]',
        'cpu_brand': 'str',
        'cpu_brand_contains': 'str',
        'cpu_brand_ends_with': 'str',
        'cpu_brand_gt': 'str',
        'cpu_brand_gte': 'str',
        'cpu_brand_in': 'list[str]',
        'cpu_brand_lt': 'str',
        'cpu_brand_lte': 'str',
        'cpu_brand_not': 'str',
        'cpu_brand_not_contains': 'str',
        'cpu_brand_not_ends_with': 'str',
        'cpu_brand_not_in': 'list[str]',
        'cpu_brand_not_starts_with': 'str',
        'cpu_brand_starts_with': 'str',
        'cpu_fan_speed_unit': 'CpuFanSpeedUnit',
        'cpu_fan_speed_unit_in': 'list[CpuFanSpeedUnit]',
        'cpu_fan_speed_unit_not': 'CpuFanSpeedUnit',
        'cpu_fan_speed_unit_not_in': 'list[CpuFanSpeedUnit]',
        'cpu_hz_per_core': 'int',
        'cpu_hz_per_core_gt': 'int',
        'cpu_hz_per_core_gte': 'int',
        'cpu_hz_per_core_in': 'list[int]',
        'cpu_hz_per_core_lt': 'int',
        'cpu_hz_per_core_lte': 'int',
        'cpu_hz_per_core_not': 'int',
        'cpu_hz_per_core_not_in': 'list[int]',
        'cpu_model': 'str',
        'cpu_model_contains': 'str',
        'cpu_model_ends_with': 'str',
        'cpu_model_gt': 'str',
        'cpu_model_gte': 'str',
        'cpu_model_in': 'list[str]',
        'cpu_model_lt': 'str',
        'cpu_model_lte': 'str',
        'cpu_model_not': 'str',
        'cpu_model_not_contains': 'str',
        'cpu_model_not_ends_with': 'str',
        'cpu_model_not_in': 'list[str]',
        'cpu_model_not_starts_with': 'str',
        'cpu_model_starts_with': 'str',
        'cpu_vendor': 'str',
        'cpu_vendor_contains': 'str',
        'cpu_vendor_ends_with': 'str',
        'cpu_vendor_gt': 'str',
        'cpu_vendor_gte': 'str',
        'cpu_vendor_in': 'list[str]',
        'cpu_vendor_lt': 'str',
        'cpu_vendor_lte': 'str',
        'cpu_vendor_not': 'str',
        'cpu_vendor_not_contains': 'str',
        'cpu_vendor_not_ends_with': 'str',
        'cpu_vendor_not_in': 'list[str]',
        'cpu_vendor_not_starts_with': 'str',
        'cpu_vendor_starts_with': 'str',
        'data_ip': 'str',
        'data_ip_contains': 'str',
        'data_ip_ends_with': 'str',
        'data_ip_gt': 'str',
        'data_ip_gte': 'str',
        'data_ip_in': 'list[str]',
        'data_ip_lt': 'str',
        'data_ip_lte': 'str',
        'data_ip_not': 'str',
        'data_ip_not_contains': 'str',
        'data_ip_not_ends_with': 'str',
        'data_ip_not_in': 'list[str]',
        'data_ip_not_starts_with': 'str',
        'data_ip_starts_with': 'str',
        'disk_pools_every': 'DiskPoolWhereInput',
        'disk_pools_none': 'DiskPoolWhereInput',
        'disk_pools_some': 'DiskPoolWhereInput',
        'disks_every': 'DiskWhereInput',
        'disks_none': 'DiskWhereInput',
        'disks_some': 'DiskWhereInput',
        'downgraded_prioritized_space': 'int',
        'downgraded_prioritized_space_gt': 'int',
        'downgraded_prioritized_space_gte': 'int',
        'downgraded_prioritized_space_in': 'list[int]',
        'downgraded_prioritized_space_lt': 'int',
        'downgraded_prioritized_space_lte': 'int',
        'downgraded_prioritized_space_not': 'int',
        'downgraded_prioritized_space_not_in': 'list[int]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'failure_data_space': 'int',
        'failure_data_space_gt': 'int',
        'failure_data_space_gte': 'int',
        'failure_data_space_in': 'list[int]',
        'failure_data_space_lt': 'int',
        'failure_data_space_lte': 'int',
        'failure_data_space_not': 'int',
        'failure_data_space_not_in': 'list[int]',
        'gpu_devices_every': 'GpuDeviceWhereInput',
        'gpu_devices_none': 'GpuDeviceWhereInput',
        'gpu_devices_some': 'GpuDeviceWhereInput',
        'hdd_data_capacity': 'int',
        'hdd_data_capacity_gt': 'int',
        'hdd_data_capacity_gte': 'int',
        'hdd_data_capacity_in': 'list[int]',
        'hdd_data_capacity_lt': 'int',
        'hdd_data_capacity_lte': 'int',
        'hdd_data_capacity_not': 'int',
        'hdd_data_capacity_not_in': 'list[int]',
        'hdd_disk_count': 'int',
        'hdd_disk_count_gt': 'int',
        'hdd_disk_count_gte': 'int',
        'hdd_disk_count_in': 'list[int]',
        'hdd_disk_count_lt': 'int',
        'hdd_disk_count_lte': 'int',
        'hdd_disk_count_not': 'int',
        'hdd_disk_count_not_in': 'list[int]',
        'hypervisor_ip': 'str',
        'hypervisor_ip_contains': 'str',
        'hypervisor_ip_ends_with': 'str',
        'hypervisor_ip_gt': 'str',
        'hypervisor_ip_gte': 'str',
        'hypervisor_ip_in': 'list[str]',
        'hypervisor_ip_lt': 'str',
        'hypervisor_ip_lte': 'str',
        'hypervisor_ip_not': 'str',
        'hypervisor_ip_not_contains': 'str',
        'hypervisor_ip_not_ends_with': 'str',
        'hypervisor_ip_not_in': 'list[str]',
        'hypervisor_ip_not_starts_with': 'str',
        'hypervisor_ip_starts_with': 'str',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'iommu': 'IommuStatus',
        'iommu_in': 'list[IommuStatus]',
        'iommu_not': 'IommuStatus',
        'iommu_not_in': 'list[IommuStatus]',
        'ipmi': 'IpmiWhereInput',
        'is_os_in_raid1': 'bool',
        'is_os_in_raid1_not': 'bool',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'lsm_cap_disk_safe_umount': 'bool',
        'lsm_cap_disk_safe_umount_not': 'bool',
        'management_ip': 'str',
        'management_ip_contains': 'str',
        'management_ip_ends_with': 'str',
        'management_ip_gt': 'str',
        'management_ip_gte': 'str',
        'management_ip_in': 'list[str]',
        'management_ip_lt': 'str',
        'management_ip_lte': 'str',
        'management_ip_not': 'str',
        'management_ip_not_contains': 'str',
        'management_ip_not_ends_with': 'str',
        'management_ip_not_in': 'list[str]',
        'management_ip_not_starts_with': 'str',
        'management_ip_starts_with': 'str',
        'merged_status': 'HostMergedStatus',
        'merged_status_in': 'list[HostMergedStatus]',
        'merged_status_not': 'HostMergedStatus',
        'merged_status_not_in': 'list[HostMergedStatus]',
        'model': 'str',
        'model_contains': 'str',
        'model_ends_with': 'str',
        'model_gt': 'str',
        'model_gte': 'str',
        'model_in': 'list[str]',
        'model_lt': 'str',
        'model_lte': 'str',
        'model_not': 'str',
        'model_not_contains': 'str',
        'model_not_ends_with': 'str',
        'model_not_in': 'list[str]',
        'model_not_starts_with': 'str',
        'model_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'nested_virtualization': 'bool',
        'nested_virtualization_not': 'bool',
        'nic_count': 'int',
        'nic_count_gt': 'int',
        'nic_count_gte': 'int',
        'nic_count_in': 'list[int]',
        'nic_count_lt': 'int',
        'nic_count_lte': 'int',
        'nic_count_not': 'int',
        'nic_count_not_in': 'list[int]',
        'nics_every': 'NicWhereInput',
        'nics_none': 'NicWhereInput',
        'nics_some': 'NicWhereInput',
        'node_topo_local_id': 'str',
        'node_topo_local_id_contains': 'str',
        'node_topo_local_id_ends_with': 'str',
        'node_topo_local_id_gt': 'str',
        'node_topo_local_id_gte': 'str',
        'node_topo_local_id_in': 'list[str]',
        'node_topo_local_id_lt': 'str',
        'node_topo_local_id_lte': 'str',
        'node_topo_local_id_not': 'str',
        'node_topo_local_id_not_contains': 'str',
        'node_topo_local_id_not_ends_with': 'str',
        'node_topo_local_id_not_in': 'list[str]',
        'node_topo_local_id_not_starts_with': 'str',
        'node_topo_local_id_starts_with': 'str',
        'os_memory_bytes': 'int',
        'os_memory_bytes_gt': 'int',
        'os_memory_bytes_gte': 'int',
        'os_memory_bytes_in': 'list[int]',
        'os_memory_bytes_lt': 'int',
        'os_memory_bytes_lte': 'int',
        'os_memory_bytes_not': 'int',
        'os_memory_bytes_not_in': 'list[int]',
        'os_version': 'str',
        'os_version_contains': 'str',
        'os_version_ends_with': 'str',
        'os_version_gt': 'str',
        'os_version_gte': 'str',
        'os_version_in': 'list[str]',
        'os_version_lt': 'str',
        'os_version_lte': 'str',
        'os_version_not': 'str',
        'os_version_not_contains': 'str',
        'os_version_not_ends_with': 'str',
        'os_version_not_in': 'list[str]',
        'os_version_not_starts_with': 'str',
        'os_version_starts_with': 'str',
        'perf_allocated_data_space': 'int',
        'perf_allocated_data_space_gt': 'int',
        'perf_allocated_data_space_gte': 'int',
        'perf_allocated_data_space_in': 'list[int]',
        'perf_allocated_data_space_lt': 'int',
        'perf_allocated_data_space_lte': 'int',
        'perf_allocated_data_space_not': 'int',
        'perf_allocated_data_space_not_in': 'list[int]',
        'perf_failure_data_space': 'int',
        'perf_failure_data_space_gt': 'int',
        'perf_failure_data_space_gte': 'int',
        'perf_failure_data_space_in': 'list[int]',
        'perf_failure_data_space_lt': 'int',
        'perf_failure_data_space_lte': 'int',
        'perf_failure_data_space_not': 'int',
        'perf_failure_data_space_not_in': 'list[int]',
        'perf_total_data_capacity': 'int',
        'perf_total_data_capacity_gt': 'int',
        'perf_total_data_capacity_gte': 'int',
        'perf_total_data_capacity_in': 'list[int]',
        'perf_total_data_capacity_lt': 'int',
        'perf_total_data_capacity_lte': 'int',
        'perf_total_data_capacity_not': 'int',
        'perf_total_data_capacity_not_in': 'list[int]',
        'perf_used_data_space': 'int',
        'perf_used_data_space_gt': 'int',
        'perf_used_data_space_gte': 'int',
        'perf_used_data_space_in': 'list[int]',
        'perf_used_data_space_lt': 'int',
        'perf_used_data_space_lte': 'int',
        'perf_used_data_space_not': 'int',
        'perf_used_data_space_not_in': 'list[int]',
        'perf_valid_data_space': 'int',
        'perf_valid_data_space_gt': 'int',
        'perf_valid_data_space_gte': 'int',
        'perf_valid_data_space_in': 'list[int]',
        'perf_valid_data_space_lt': 'int',
        'perf_valid_data_space_lte': 'int',
        'perf_valid_data_space_not': 'int',
        'perf_valid_data_space_not_in': 'list[int]',
        'planned_prioritized_space': 'int',
        'planned_prioritized_space_gt': 'int',
        'planned_prioritized_space_gte': 'int',
        'planned_prioritized_space_in': 'list[int]',
        'planned_prioritized_space_lt': 'int',
        'planned_prioritized_space_lte': 'int',
        'planned_prioritized_space_not': 'int',
        'planned_prioritized_space_not_in': 'list[int]',
        'pmem_dimm_capacity': 'int',
        'pmem_dimm_capacity_gt': 'int',
        'pmem_dimm_capacity_gte': 'int',
        'pmem_dimm_capacity_in': 'list[int]',
        'pmem_dimm_capacity_lt': 'int',
        'pmem_dimm_capacity_lte': 'int',
        'pmem_dimm_capacity_not': 'int',
        'pmem_dimm_capacity_not_in': 'list[int]',
        'pmem_dimm_count': 'int',
        'pmem_dimm_count_gt': 'int',
        'pmem_dimm_count_gte': 'int',
        'pmem_dimm_count_in': 'list[int]',
        'pmem_dimm_count_lt': 'int',
        'pmem_dimm_count_lte': 'int',
        'pmem_dimm_count_not': 'int',
        'pmem_dimm_count_not_in': 'list[int]',
        'pmem_dimms_every': 'PmemDimmWhereInput',
        'pmem_dimms_none': 'PmemDimmWhereInput',
        'pmem_dimms_some': 'PmemDimmWhereInput',
        'pmem_disk_count': 'int',
        'pmem_disk_count_gt': 'int',
        'pmem_disk_count_gte': 'int',
        'pmem_disk_count_in': 'list[int]',
        'pmem_disk_count_lt': 'int',
        'pmem_disk_count_lte': 'int',
        'pmem_disk_count_not': 'int',
        'pmem_disk_count_not_in': 'list[int]',
        'prio_space_percentage': 'float',
        'prio_space_percentage_gt': 'float',
        'prio_space_percentage_gte': 'float',
        'prio_space_percentage_in': 'list[float]',
        'prio_space_percentage_lt': 'float',
        'prio_space_percentage_lte': 'float',
        'prio_space_percentage_not': 'float',
        'prio_space_percentage_not_in': 'list[float]',
        'provisioned_cpu_cores': 'int',
        'provisioned_cpu_cores_gt': 'int',
        'provisioned_cpu_cores_gte': 'int',
        'provisioned_cpu_cores_in': 'list[int]',
        'provisioned_cpu_cores_lt': 'int',
        'provisioned_cpu_cores_lte': 'int',
        'provisioned_cpu_cores_not': 'int',
        'provisioned_cpu_cores_not_in': 'list[int]',
        'provisioned_memory_bytes': 'int',
        'provisioned_memory_bytes_gt': 'int',
        'provisioned_memory_bytes_gte': 'int',
        'provisioned_memory_bytes_in': 'list[int]',
        'provisioned_memory_bytes_lt': 'int',
        'provisioned_memory_bytes_lte': 'int',
        'provisioned_memory_bytes_not': 'int',
        'provisioned_memory_bytes_not_in': 'list[int]',
        'running_pause_vm_memory_bytes': 'int',
        'running_pause_vm_memory_bytes_gt': 'int',
        'running_pause_vm_memory_bytes_gte': 'int',
        'running_pause_vm_memory_bytes_in': 'list[int]',
        'running_pause_vm_memory_bytes_lt': 'int',
        'running_pause_vm_memory_bytes_lte': 'int',
        'running_pause_vm_memory_bytes_not': 'int',
        'running_pause_vm_memory_bytes_not_in': 'list[int]',
        'running_vm_num': 'int',
        'running_vm_num_gt': 'int',
        'running_vm_num_gte': 'int',
        'running_vm_num_in': 'list[int]',
        'running_vm_num_lt': 'int',
        'running_vm_num_lte': 'int',
        'running_vm_num_not': 'int',
        'running_vm_num_not_in': 'list[int]',
        'scvm_cpu': 'int',
        'scvm_cpu_gt': 'int',
        'scvm_cpu_gte': 'int',
        'scvm_cpu_in': 'list[int]',
        'scvm_cpu_lt': 'int',
        'scvm_cpu_lte': 'int',
        'scvm_cpu_not': 'int',
        'scvm_cpu_not_in': 'list[int]',
        'scvm_memory': 'int',
        'scvm_memory_gt': 'int',
        'scvm_memory_gte': 'int',
        'scvm_memory_in': 'list[int]',
        'scvm_memory_lt': 'int',
        'scvm_memory_lte': 'int',
        'scvm_memory_not': 'int',
        'scvm_memory_not_in': 'list[int]',
        'scvm_name': 'str',
        'scvm_name_contains': 'str',
        'scvm_name_ends_with': 'str',
        'scvm_name_gt': 'str',
        'scvm_name_gte': 'str',
        'scvm_name_in': 'list[str]',
        'scvm_name_lt': 'str',
        'scvm_name_lte': 'str',
        'scvm_name_not': 'str',
        'scvm_name_not_contains': 'str',
        'scvm_name_not_ends_with': 'str',
        'scvm_name_not_in': 'list[str]',
        'scvm_name_not_starts_with': 'str',
        'scvm_name_starts_with': 'str',
        'serial': 'str',
        'serial_contains': 'str',
        'serial_ends_with': 'str',
        'serial_gt': 'str',
        'serial_gte': 'str',
        'serial_in': 'list[str]',
        'serial_lt': 'str',
        'serial_lte': 'str',
        'serial_not': 'str',
        'serial_not_contains': 'str',
        'serial_not_ends_with': 'str',
        'serial_not_in': 'list[str]',
        'serial_not_starts_with': 'str',
        'serial_starts_with': 'str',
        'ssd_data_capacity': 'int',
        'ssd_data_capacity_gt': 'int',
        'ssd_data_capacity_gte': 'int',
        'ssd_data_capacity_in': 'list[int]',
        'ssd_data_capacity_lt': 'int',
        'ssd_data_capacity_lte': 'int',
        'ssd_data_capacity_not': 'int',
        'ssd_data_capacity_not_in': 'list[int]',
        'ssd_disk_count': 'int',
        'ssd_disk_count_gt': 'int',
        'ssd_disk_count_gte': 'int',
        'ssd_disk_count_in': 'list[int]',
        'ssd_disk_count_lt': 'int',
        'ssd_disk_count_lte': 'int',
        'ssd_disk_count_not': 'int',
        'ssd_disk_count_not_in': 'list[int]',
        'state': 'HostState',
        'state_in': 'list[HostState]',
        'state_not': 'HostState',
        'state_not_in': 'list[HostState]',
        'status': 'HostStatus',
        'status_in': 'list[HostStatus]',
        'status_not': 'HostStatus',
        'status_not_in': 'list[HostStatus]',
        'stopped_vm_num': 'int',
        'stopped_vm_num_gt': 'int',
        'stopped_vm_num_gte': 'int',
        'stopped_vm_num_in': 'list[int]',
        'stopped_vm_num_lt': 'int',
        'stopped_vm_num_lte': 'int',
        'stopped_vm_num_not': 'int',
        'stopped_vm_num_not_in': 'list[int]',
        'suspended_vm_num': 'int',
        'suspended_vm_num_gt': 'int',
        'suspended_vm_num_gte': 'int',
        'suspended_vm_num_in': 'list[int]',
        'suspended_vm_num_lt': 'int',
        'suspended_vm_num_lte': 'int',
        'suspended_vm_num_not': 'int',
        'suspended_vm_num_not_in': 'list[int]',
        'total_cache_capacity': 'int',
        'total_cache_capacity_gt': 'int',
        'total_cache_capacity_gte': 'int',
        'total_cache_capacity_in': 'list[int]',
        'total_cache_capacity_lt': 'int',
        'total_cache_capacity_lte': 'int',
        'total_cache_capacity_not': 'int',
        'total_cache_capacity_not_in': 'list[int]',
        'total_cpu_cores': 'int',
        'total_cpu_cores_gt': 'int',
        'total_cpu_cores_gte': 'int',
        'total_cpu_cores_in': 'list[int]',
        'total_cpu_cores_lt': 'int',
        'total_cpu_cores_lte': 'int',
        'total_cpu_cores_not': 'int',
        'total_cpu_cores_not_in': 'list[int]',
        'total_cpu_hz': 'int',
        'total_cpu_hz_gt': 'int',
        'total_cpu_hz_gte': 'int',
        'total_cpu_hz_in': 'list[int]',
        'total_cpu_hz_lt': 'int',
        'total_cpu_hz_lte': 'int',
        'total_cpu_hz_not': 'int',
        'total_cpu_hz_not_in': 'list[int]',
        'total_cpu_sockets': 'int',
        'total_cpu_sockets_gt': 'int',
        'total_cpu_sockets_gte': 'int',
        'total_cpu_sockets_in': 'list[int]',
        'total_cpu_sockets_lt': 'int',
        'total_cpu_sockets_lte': 'int',
        'total_cpu_sockets_not': 'int',
        'total_cpu_sockets_not_in': 'list[int]',
        'total_data_capacity': 'int',
        'total_data_capacity_gt': 'int',
        'total_data_capacity_gte': 'int',
        'total_data_capacity_in': 'list[int]',
        'total_data_capacity_lt': 'int',
        'total_data_capacity_lte': 'int',
        'total_data_capacity_not': 'int',
        'total_data_capacity_not_in': 'list[int]',
        'total_memory_bytes': 'int',
        'total_memory_bytes_gt': 'int',
        'total_memory_bytes_gte': 'int',
        'total_memory_bytes_in': 'list[int]',
        'total_memory_bytes_lt': 'int',
        'total_memory_bytes_lte': 'int',
        'total_memory_bytes_not': 'int',
        'total_memory_bytes_not_in': 'list[int]',
        'usb_devices_every': 'UsbDeviceWhereInput',
        'usb_devices_none': 'UsbDeviceWhereInput',
        'usb_devices_some': 'UsbDeviceWhereInput',
        'used_cache_space': 'int',
        'used_cache_space_gt': 'int',
        'used_cache_space_gte': 'int',
        'used_cache_space_in': 'list[int]',
        'used_cache_space_lt': 'int',
        'used_cache_space_lte': 'int',
        'used_cache_space_not': 'int',
        'used_cache_space_not_in': 'list[int]',
        'used_cpu_hz': 'float',
        'used_cpu_hz_gt': 'float',
        'used_cpu_hz_gte': 'float',
        'used_cpu_hz_in': 'list[float]',
        'used_cpu_hz_lt': 'float',
        'used_cpu_hz_lte': 'float',
        'used_cpu_hz_not': 'float',
        'used_cpu_hz_not_in': 'list[float]',
        'used_data_space': 'int',
        'used_data_space_gt': 'int',
        'used_data_space_gte': 'int',
        'used_data_space_in': 'list[int]',
        'used_data_space_lt': 'int',
        'used_data_space_lte': 'int',
        'used_data_space_not': 'int',
        'used_data_space_not_in': 'list[int]',
        'used_memory_bytes': 'float',
        'used_memory_bytes_gt': 'float',
        'used_memory_bytes_gte': 'float',
        'used_memory_bytes_in': 'list[float]',
        'used_memory_bytes_lt': 'float',
        'used_memory_bytes_lte': 'float',
        'used_memory_bytes_not': 'float',
        'used_memory_bytes_not_in': 'list[float]',
        'valid_cache_space': 'int',
        'valid_cache_space_gt': 'int',
        'valid_cache_space_gte': 'int',
        'valid_cache_space_in': 'list[int]',
        'valid_cache_space_lt': 'int',
        'valid_cache_space_lte': 'int',
        'valid_cache_space_not': 'int',
        'valid_cache_space_not_in': 'list[int]',
        'valid_free_cache_space': 'int',
        'valid_free_cache_space_gt': 'int',
        'valid_free_cache_space_gte': 'int',
        'valid_free_cache_space_in': 'list[int]',
        'valid_free_cache_space_lt': 'int',
        'valid_free_cache_space_lte': 'int',
        'valid_free_cache_space_not': 'int',
        'valid_free_cache_space_not_in': 'list[int]',
        'vm_num': 'int',
        'vm_num_gt': 'int',
        'vm_num_gte': 'int',
        'vm_num_in': 'list[int]',
        'vm_num_lt': 'int',
        'vm_num_lte': 'int',
        'vm_num_not': 'int',
        'vm_num_not_in': 'list[int]',
        'vmotion_ip': 'str',
        'vmotion_ip_contains': 'str',
        'vmotion_ip_ends_with': 'str',
        'vmotion_ip_gt': 'str',
        'vmotion_ip_gte': 'str',
        'vmotion_ip_in': 'list[str]',
        'vmotion_ip_lt': 'str',
        'vmotion_ip_lte': 'str',
        'vmotion_ip_not': 'str',
        'vmotion_ip_not_contains': 'str',
        'vmotion_ip_not_ends_with': 'str',
        'vmotion_ip_not_in': 'list[str]',
        'vmotion_ip_not_starts_with': 'str',
        'vmotion_ip_starts_with': 'str',
        'vms_every': 'VmWhereInput',
        'vms_none': 'VmWhereInput',
        'vms_some': 'VmWhereInput',
        'vsphere_esxi_account': 'VsphereEsxiAccountWhereInput',
        'with_faster_ssd_as_cache': 'bool',
        'with_faster_ssd_as_cache_not': 'bool',
        'zone': 'ZoneWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'access_ip': 'access_ip',
        'access_ip_contains': 'access_ip_contains',
        'access_ip_ends_with': 'access_ip_ends_with',
        'access_ip_gt': 'access_ip_gt',
        'access_ip_gte': 'access_ip_gte',
        'access_ip_in': 'access_ip_in',
        'access_ip_lt': 'access_ip_lt',
        'access_ip_lte': 'access_ip_lte',
        'access_ip_not': 'access_ip_not',
        'access_ip_not_contains': 'access_ip_not_contains',
        'access_ip_not_ends_with': 'access_ip_not_ends_with',
        'access_ip_not_in': 'access_ip_not_in',
        'access_ip_not_starts_with': 'access_ip_not_starts_with',
        'access_ip_starts_with': 'access_ip_starts_with',
        'allocable_cpu_cores_for_vm_exclusive': 'allocable_cpu_cores_for_vm_exclusive',
        'allocable_cpu_cores_for_vm_exclusive_gt': 'allocable_cpu_cores_for_vm_exclusive_gt',
        'allocable_cpu_cores_for_vm_exclusive_gte': 'allocable_cpu_cores_for_vm_exclusive_gte',
        'allocable_cpu_cores_for_vm_exclusive_in': 'allocable_cpu_cores_for_vm_exclusive_in',
        'allocable_cpu_cores_for_vm_exclusive_lt': 'allocable_cpu_cores_for_vm_exclusive_lt',
        'allocable_cpu_cores_for_vm_exclusive_lte': 'allocable_cpu_cores_for_vm_exclusive_lte',
        'allocable_cpu_cores_for_vm_exclusive_not': 'allocable_cpu_cores_for_vm_exclusive_not',
        'allocable_cpu_cores_for_vm_exclusive_not_in': 'allocable_cpu_cores_for_vm_exclusive_not_in',
        'allocatable_memory_bytes': 'allocatable_memory_bytes',
        'allocatable_memory_bytes_gt': 'allocatable_memory_bytes_gt',
        'allocatable_memory_bytes_gte': 'allocatable_memory_bytes_gte',
        'allocatable_memory_bytes_in': 'allocatable_memory_bytes_in',
        'allocatable_memory_bytes_lt': 'allocatable_memory_bytes_lt',
        'allocatable_memory_bytes_lte': 'allocatable_memory_bytes_lte',
        'allocatable_memory_bytes_not': 'allocatable_memory_bytes_not',
        'allocatable_memory_bytes_not_in': 'allocatable_memory_bytes_not_in',
        'allocated_prioritized_space': 'allocated_prioritized_space',
        'allocated_prioritized_space_gt': 'allocated_prioritized_space_gt',
        'allocated_prioritized_space_gte': 'allocated_prioritized_space_gte',
        'allocated_prioritized_space_in': 'allocated_prioritized_space_in',
        'allocated_prioritized_space_lt': 'allocated_prioritized_space_lt',
        'allocated_prioritized_space_lte': 'allocated_prioritized_space_lte',
        'allocated_prioritized_space_not': 'allocated_prioritized_space_not',
        'allocated_prioritized_space_not_in': 'allocated_prioritized_space_not_in',
        'allocated_prioritized_space_usage': 'allocated_prioritized_space_usage',
        'allocated_prioritized_space_usage_gt': 'allocated_prioritized_space_usage_gt',
        'allocated_prioritized_space_usage_gte': 'allocated_prioritized_space_usage_gte',
        'allocated_prioritized_space_usage_in': 'allocated_prioritized_space_usage_in',
        'allocated_prioritized_space_usage_lt': 'allocated_prioritized_space_usage_lt',
        'allocated_prioritized_space_usage_lte': 'allocated_prioritized_space_usage_lte',
        'allocated_prioritized_space_usage_not': 'allocated_prioritized_space_usage_not',
        'allocated_prioritized_space_usage_not_in': 'allocated_prioritized_space_usage_not_in',
        'chunk_id': 'chunk_id',
        'chunk_id_contains': 'chunk_id_contains',
        'chunk_id_ends_with': 'chunk_id_ends_with',
        'chunk_id_gt': 'chunk_id_gt',
        'chunk_id_gte': 'chunk_id_gte',
        'chunk_id_in': 'chunk_id_in',
        'chunk_id_lt': 'chunk_id_lt',
        'chunk_id_lte': 'chunk_id_lte',
        'chunk_id_not': 'chunk_id_not',
        'chunk_id_not_contains': 'chunk_id_not_contains',
        'chunk_id_not_ends_with': 'chunk_id_not_ends_with',
        'chunk_id_not_in': 'chunk_id_not_in',
        'chunk_id_not_starts_with': 'chunk_id_not_starts_with',
        'chunk_id_starts_with': 'chunk_id_starts_with',
        'cluster': 'cluster',
        'commited_memory_bytes': 'commited_memory_bytes',
        'commited_memory_bytes_gt': 'commited_memory_bytes_gt',
        'commited_memory_bytes_gte': 'commited_memory_bytes_gte',
        'commited_memory_bytes_in': 'commited_memory_bytes_in',
        'commited_memory_bytes_lt': 'commited_memory_bytes_lt',
        'commited_memory_bytes_lte': 'commited_memory_bytes_lte',
        'commited_memory_bytes_not': 'commited_memory_bytes_not',
        'commited_memory_bytes_not_in': 'commited_memory_bytes_not_in',
        'connect_status': 'connect_status',
        'connect_status_in': 'connect_status_in',
        'connect_status_not': 'connect_status_not',
        'connect_status_not_in': 'connect_status_not_in',
        'cpu_brand': 'cpu_brand',
        'cpu_brand_contains': 'cpu_brand_contains',
        'cpu_brand_ends_with': 'cpu_brand_ends_with',
        'cpu_brand_gt': 'cpu_brand_gt',
        'cpu_brand_gte': 'cpu_brand_gte',
        'cpu_brand_in': 'cpu_brand_in',
        'cpu_brand_lt': 'cpu_brand_lt',
        'cpu_brand_lte': 'cpu_brand_lte',
        'cpu_brand_not': 'cpu_brand_not',
        'cpu_brand_not_contains': 'cpu_brand_not_contains',
        'cpu_brand_not_ends_with': 'cpu_brand_not_ends_with',
        'cpu_brand_not_in': 'cpu_brand_not_in',
        'cpu_brand_not_starts_with': 'cpu_brand_not_starts_with',
        'cpu_brand_starts_with': 'cpu_brand_starts_with',
        'cpu_fan_speed_unit': 'cpu_fan_speed_unit',
        'cpu_fan_speed_unit_in': 'cpu_fan_speed_unit_in',
        'cpu_fan_speed_unit_not': 'cpu_fan_speed_unit_not',
        'cpu_fan_speed_unit_not_in': 'cpu_fan_speed_unit_not_in',
        'cpu_hz_per_core': 'cpu_hz_per_core',
        'cpu_hz_per_core_gt': 'cpu_hz_per_core_gt',
        'cpu_hz_per_core_gte': 'cpu_hz_per_core_gte',
        'cpu_hz_per_core_in': 'cpu_hz_per_core_in',
        'cpu_hz_per_core_lt': 'cpu_hz_per_core_lt',
        'cpu_hz_per_core_lte': 'cpu_hz_per_core_lte',
        'cpu_hz_per_core_not': 'cpu_hz_per_core_not',
        'cpu_hz_per_core_not_in': 'cpu_hz_per_core_not_in',
        'cpu_model': 'cpu_model',
        'cpu_model_contains': 'cpu_model_contains',
        'cpu_model_ends_with': 'cpu_model_ends_with',
        'cpu_model_gt': 'cpu_model_gt',
        'cpu_model_gte': 'cpu_model_gte',
        'cpu_model_in': 'cpu_model_in',
        'cpu_model_lt': 'cpu_model_lt',
        'cpu_model_lte': 'cpu_model_lte',
        'cpu_model_not': 'cpu_model_not',
        'cpu_model_not_contains': 'cpu_model_not_contains',
        'cpu_model_not_ends_with': 'cpu_model_not_ends_with',
        'cpu_model_not_in': 'cpu_model_not_in',
        'cpu_model_not_starts_with': 'cpu_model_not_starts_with',
        'cpu_model_starts_with': 'cpu_model_starts_with',
        'cpu_vendor': 'cpu_vendor',
        'cpu_vendor_contains': 'cpu_vendor_contains',
        'cpu_vendor_ends_with': 'cpu_vendor_ends_with',
        'cpu_vendor_gt': 'cpu_vendor_gt',
        'cpu_vendor_gte': 'cpu_vendor_gte',
        'cpu_vendor_in': 'cpu_vendor_in',
        'cpu_vendor_lt': 'cpu_vendor_lt',
        'cpu_vendor_lte': 'cpu_vendor_lte',
        'cpu_vendor_not': 'cpu_vendor_not',
        'cpu_vendor_not_contains': 'cpu_vendor_not_contains',
        'cpu_vendor_not_ends_with': 'cpu_vendor_not_ends_with',
        'cpu_vendor_not_in': 'cpu_vendor_not_in',
        'cpu_vendor_not_starts_with': 'cpu_vendor_not_starts_with',
        'cpu_vendor_starts_with': 'cpu_vendor_starts_with',
        'data_ip': 'data_ip',
        'data_ip_contains': 'data_ip_contains',
        'data_ip_ends_with': 'data_ip_ends_with',
        'data_ip_gt': 'data_ip_gt',
        'data_ip_gte': 'data_ip_gte',
        'data_ip_in': 'data_ip_in',
        'data_ip_lt': 'data_ip_lt',
        'data_ip_lte': 'data_ip_lte',
        'data_ip_not': 'data_ip_not',
        'data_ip_not_contains': 'data_ip_not_contains',
        'data_ip_not_ends_with': 'data_ip_not_ends_with',
        'data_ip_not_in': 'data_ip_not_in',
        'data_ip_not_starts_with': 'data_ip_not_starts_with',
        'data_ip_starts_with': 'data_ip_starts_with',
        'disk_pools_every': 'disk_pools_every',
        'disk_pools_none': 'disk_pools_none',
        'disk_pools_some': 'disk_pools_some',
        'disks_every': 'disks_every',
        'disks_none': 'disks_none',
        'disks_some': 'disks_some',
        'downgraded_prioritized_space': 'downgraded_prioritized_space',
        'downgraded_prioritized_space_gt': 'downgraded_prioritized_space_gt',
        'downgraded_prioritized_space_gte': 'downgraded_prioritized_space_gte',
        'downgraded_prioritized_space_in': 'downgraded_prioritized_space_in',
        'downgraded_prioritized_space_lt': 'downgraded_prioritized_space_lt',
        'downgraded_prioritized_space_lte': 'downgraded_prioritized_space_lte',
        'downgraded_prioritized_space_not': 'downgraded_prioritized_space_not',
        'downgraded_prioritized_space_not_in': 'downgraded_prioritized_space_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'failure_data_space': 'failure_data_space',
        'failure_data_space_gt': 'failure_data_space_gt',
        'failure_data_space_gte': 'failure_data_space_gte',
        'failure_data_space_in': 'failure_data_space_in',
        'failure_data_space_lt': 'failure_data_space_lt',
        'failure_data_space_lte': 'failure_data_space_lte',
        'failure_data_space_not': 'failure_data_space_not',
        'failure_data_space_not_in': 'failure_data_space_not_in',
        'gpu_devices_every': 'gpu_devices_every',
        'gpu_devices_none': 'gpu_devices_none',
        'gpu_devices_some': 'gpu_devices_some',
        'hdd_data_capacity': 'hdd_data_capacity',
        'hdd_data_capacity_gt': 'hdd_data_capacity_gt',
        'hdd_data_capacity_gte': 'hdd_data_capacity_gte',
        'hdd_data_capacity_in': 'hdd_data_capacity_in',
        'hdd_data_capacity_lt': 'hdd_data_capacity_lt',
        'hdd_data_capacity_lte': 'hdd_data_capacity_lte',
        'hdd_data_capacity_not': 'hdd_data_capacity_not',
        'hdd_data_capacity_not_in': 'hdd_data_capacity_not_in',
        'hdd_disk_count': 'hdd_disk_count',
        'hdd_disk_count_gt': 'hdd_disk_count_gt',
        'hdd_disk_count_gte': 'hdd_disk_count_gte',
        'hdd_disk_count_in': 'hdd_disk_count_in',
        'hdd_disk_count_lt': 'hdd_disk_count_lt',
        'hdd_disk_count_lte': 'hdd_disk_count_lte',
        'hdd_disk_count_not': 'hdd_disk_count_not',
        'hdd_disk_count_not_in': 'hdd_disk_count_not_in',
        'hypervisor_ip': 'hypervisor_ip',
        'hypervisor_ip_contains': 'hypervisor_ip_contains',
        'hypervisor_ip_ends_with': 'hypervisor_ip_ends_with',
        'hypervisor_ip_gt': 'hypervisor_ip_gt',
        'hypervisor_ip_gte': 'hypervisor_ip_gte',
        'hypervisor_ip_in': 'hypervisor_ip_in',
        'hypervisor_ip_lt': 'hypervisor_ip_lt',
        'hypervisor_ip_lte': 'hypervisor_ip_lte',
        'hypervisor_ip_not': 'hypervisor_ip_not',
        'hypervisor_ip_not_contains': 'hypervisor_ip_not_contains',
        'hypervisor_ip_not_ends_with': 'hypervisor_ip_not_ends_with',
        'hypervisor_ip_not_in': 'hypervisor_ip_not_in',
        'hypervisor_ip_not_starts_with': 'hypervisor_ip_not_starts_with',
        'hypervisor_ip_starts_with': 'hypervisor_ip_starts_with',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'iommu': 'iommu',
        'iommu_in': 'iommu_in',
        'iommu_not': 'iommu_not',
        'iommu_not_in': 'iommu_not_in',
        'ipmi': 'ipmi',
        'is_os_in_raid1': 'is_os_in_raid1',
        'is_os_in_raid1_not': 'is_os_in_raid1_not',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'lsm_cap_disk_safe_umount': 'lsm_cap_disk_safe_umount',
        'lsm_cap_disk_safe_umount_not': 'lsm_cap_disk_safe_umount_not',
        'management_ip': 'management_ip',
        'management_ip_contains': 'management_ip_contains',
        'management_ip_ends_with': 'management_ip_ends_with',
        'management_ip_gt': 'management_ip_gt',
        'management_ip_gte': 'management_ip_gte',
        'management_ip_in': 'management_ip_in',
        'management_ip_lt': 'management_ip_lt',
        'management_ip_lte': 'management_ip_lte',
        'management_ip_not': 'management_ip_not',
        'management_ip_not_contains': 'management_ip_not_contains',
        'management_ip_not_ends_with': 'management_ip_not_ends_with',
        'management_ip_not_in': 'management_ip_not_in',
        'management_ip_not_starts_with': 'management_ip_not_starts_with',
        'management_ip_starts_with': 'management_ip_starts_with',
        'merged_status': 'merged_status',
        'merged_status_in': 'merged_status_in',
        'merged_status_not': 'merged_status_not',
        'merged_status_not_in': 'merged_status_not_in',
        'model': 'model',
        'model_contains': 'model_contains',
        'model_ends_with': 'model_ends_with',
        'model_gt': 'model_gt',
        'model_gte': 'model_gte',
        'model_in': 'model_in',
        'model_lt': 'model_lt',
        'model_lte': 'model_lte',
        'model_not': 'model_not',
        'model_not_contains': 'model_not_contains',
        'model_not_ends_with': 'model_not_ends_with',
        'model_not_in': 'model_not_in',
        'model_not_starts_with': 'model_not_starts_with',
        'model_starts_with': 'model_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'nested_virtualization': 'nested_virtualization',
        'nested_virtualization_not': 'nested_virtualization_not',
        'nic_count': 'nic_count',
        'nic_count_gt': 'nic_count_gt',
        'nic_count_gte': 'nic_count_gte',
        'nic_count_in': 'nic_count_in',
        'nic_count_lt': 'nic_count_lt',
        'nic_count_lte': 'nic_count_lte',
        'nic_count_not': 'nic_count_not',
        'nic_count_not_in': 'nic_count_not_in',
        'nics_every': 'nics_every',
        'nics_none': 'nics_none',
        'nics_some': 'nics_some',
        'node_topo_local_id': 'node_topo_local_id',
        'node_topo_local_id_contains': 'node_topo_local_id_contains',
        'node_topo_local_id_ends_with': 'node_topo_local_id_ends_with',
        'node_topo_local_id_gt': 'node_topo_local_id_gt',
        'node_topo_local_id_gte': 'node_topo_local_id_gte',
        'node_topo_local_id_in': 'node_topo_local_id_in',
        'node_topo_local_id_lt': 'node_topo_local_id_lt',
        'node_topo_local_id_lte': 'node_topo_local_id_lte',
        'node_topo_local_id_not': 'node_topo_local_id_not',
        'node_topo_local_id_not_contains': 'node_topo_local_id_not_contains',
        'node_topo_local_id_not_ends_with': 'node_topo_local_id_not_ends_with',
        'node_topo_local_id_not_in': 'node_topo_local_id_not_in',
        'node_topo_local_id_not_starts_with': 'node_topo_local_id_not_starts_with',
        'node_topo_local_id_starts_with': 'node_topo_local_id_starts_with',
        'os_memory_bytes': 'os_memory_bytes',
        'os_memory_bytes_gt': 'os_memory_bytes_gt',
        'os_memory_bytes_gte': 'os_memory_bytes_gte',
        'os_memory_bytes_in': 'os_memory_bytes_in',
        'os_memory_bytes_lt': 'os_memory_bytes_lt',
        'os_memory_bytes_lte': 'os_memory_bytes_lte',
        'os_memory_bytes_not': 'os_memory_bytes_not',
        'os_memory_bytes_not_in': 'os_memory_bytes_not_in',
        'os_version': 'os_version',
        'os_version_contains': 'os_version_contains',
        'os_version_ends_with': 'os_version_ends_with',
        'os_version_gt': 'os_version_gt',
        'os_version_gte': 'os_version_gte',
        'os_version_in': 'os_version_in',
        'os_version_lt': 'os_version_lt',
        'os_version_lte': 'os_version_lte',
        'os_version_not': 'os_version_not',
        'os_version_not_contains': 'os_version_not_contains',
        'os_version_not_ends_with': 'os_version_not_ends_with',
        'os_version_not_in': 'os_version_not_in',
        'os_version_not_starts_with': 'os_version_not_starts_with',
        'os_version_starts_with': 'os_version_starts_with',
        'perf_allocated_data_space': 'perf_allocated_data_space',
        'perf_allocated_data_space_gt': 'perf_allocated_data_space_gt',
        'perf_allocated_data_space_gte': 'perf_allocated_data_space_gte',
        'perf_allocated_data_space_in': 'perf_allocated_data_space_in',
        'perf_allocated_data_space_lt': 'perf_allocated_data_space_lt',
        'perf_allocated_data_space_lte': 'perf_allocated_data_space_lte',
        'perf_allocated_data_space_not': 'perf_allocated_data_space_not',
        'perf_allocated_data_space_not_in': 'perf_allocated_data_space_not_in',
        'perf_failure_data_space': 'perf_failure_data_space',
        'perf_failure_data_space_gt': 'perf_failure_data_space_gt',
        'perf_failure_data_space_gte': 'perf_failure_data_space_gte',
        'perf_failure_data_space_in': 'perf_failure_data_space_in',
        'perf_failure_data_space_lt': 'perf_failure_data_space_lt',
        'perf_failure_data_space_lte': 'perf_failure_data_space_lte',
        'perf_failure_data_space_not': 'perf_failure_data_space_not',
        'perf_failure_data_space_not_in': 'perf_failure_data_space_not_in',
        'perf_total_data_capacity': 'perf_total_data_capacity',
        'perf_total_data_capacity_gt': 'perf_total_data_capacity_gt',
        'perf_total_data_capacity_gte': 'perf_total_data_capacity_gte',
        'perf_total_data_capacity_in': 'perf_total_data_capacity_in',
        'perf_total_data_capacity_lt': 'perf_total_data_capacity_lt',
        'perf_total_data_capacity_lte': 'perf_total_data_capacity_lte',
        'perf_total_data_capacity_not': 'perf_total_data_capacity_not',
        'perf_total_data_capacity_not_in': 'perf_total_data_capacity_not_in',
        'perf_used_data_space': 'perf_used_data_space',
        'perf_used_data_space_gt': 'perf_used_data_space_gt',
        'perf_used_data_space_gte': 'perf_used_data_space_gte',
        'perf_used_data_space_in': 'perf_used_data_space_in',
        'perf_used_data_space_lt': 'perf_used_data_space_lt',
        'perf_used_data_space_lte': 'perf_used_data_space_lte',
        'perf_used_data_space_not': 'perf_used_data_space_not',
        'perf_used_data_space_not_in': 'perf_used_data_space_not_in',
        'perf_valid_data_space': 'perf_valid_data_space',
        'perf_valid_data_space_gt': 'perf_valid_data_space_gt',
        'perf_valid_data_space_gte': 'perf_valid_data_space_gte',
        'perf_valid_data_space_in': 'perf_valid_data_space_in',
        'perf_valid_data_space_lt': 'perf_valid_data_space_lt',
        'perf_valid_data_space_lte': 'perf_valid_data_space_lte',
        'perf_valid_data_space_not': 'perf_valid_data_space_not',
        'perf_valid_data_space_not_in': 'perf_valid_data_space_not_in',
        'planned_prioritized_space': 'planned_prioritized_space',
        'planned_prioritized_space_gt': 'planned_prioritized_space_gt',
        'planned_prioritized_space_gte': 'planned_prioritized_space_gte',
        'planned_prioritized_space_in': 'planned_prioritized_space_in',
        'planned_prioritized_space_lt': 'planned_prioritized_space_lt',
        'planned_prioritized_space_lte': 'planned_prioritized_space_lte',
        'planned_prioritized_space_not': 'planned_prioritized_space_not',
        'planned_prioritized_space_not_in': 'planned_prioritized_space_not_in',
        'pmem_dimm_capacity': 'pmem_dimm_capacity',
        'pmem_dimm_capacity_gt': 'pmem_dimm_capacity_gt',
        'pmem_dimm_capacity_gte': 'pmem_dimm_capacity_gte',
        'pmem_dimm_capacity_in': 'pmem_dimm_capacity_in',
        'pmem_dimm_capacity_lt': 'pmem_dimm_capacity_lt',
        'pmem_dimm_capacity_lte': 'pmem_dimm_capacity_lte',
        'pmem_dimm_capacity_not': 'pmem_dimm_capacity_not',
        'pmem_dimm_capacity_not_in': 'pmem_dimm_capacity_not_in',
        'pmem_dimm_count': 'pmem_dimm_count',
        'pmem_dimm_count_gt': 'pmem_dimm_count_gt',
        'pmem_dimm_count_gte': 'pmem_dimm_count_gte',
        'pmem_dimm_count_in': 'pmem_dimm_count_in',
        'pmem_dimm_count_lt': 'pmem_dimm_count_lt',
        'pmem_dimm_count_lte': 'pmem_dimm_count_lte',
        'pmem_dimm_count_not': 'pmem_dimm_count_not',
        'pmem_dimm_count_not_in': 'pmem_dimm_count_not_in',
        'pmem_dimms_every': 'pmem_dimms_every',
        'pmem_dimms_none': 'pmem_dimms_none',
        'pmem_dimms_some': 'pmem_dimms_some',
        'pmem_disk_count': 'pmem_disk_count',
        'pmem_disk_count_gt': 'pmem_disk_count_gt',
        'pmem_disk_count_gte': 'pmem_disk_count_gte',
        'pmem_disk_count_in': 'pmem_disk_count_in',
        'pmem_disk_count_lt': 'pmem_disk_count_lt',
        'pmem_disk_count_lte': 'pmem_disk_count_lte',
        'pmem_disk_count_not': 'pmem_disk_count_not',
        'pmem_disk_count_not_in': 'pmem_disk_count_not_in',
        'prio_space_percentage': 'prio_space_percentage',
        'prio_space_percentage_gt': 'prio_space_percentage_gt',
        'prio_space_percentage_gte': 'prio_space_percentage_gte',
        'prio_space_percentage_in': 'prio_space_percentage_in',
        'prio_space_percentage_lt': 'prio_space_percentage_lt',
        'prio_space_percentage_lte': 'prio_space_percentage_lte',
        'prio_space_percentage_not': 'prio_space_percentage_not',
        'prio_space_percentage_not_in': 'prio_space_percentage_not_in',
        'provisioned_cpu_cores': 'provisioned_cpu_cores',
        'provisioned_cpu_cores_gt': 'provisioned_cpu_cores_gt',
        'provisioned_cpu_cores_gte': 'provisioned_cpu_cores_gte',
        'provisioned_cpu_cores_in': 'provisioned_cpu_cores_in',
        'provisioned_cpu_cores_lt': 'provisioned_cpu_cores_lt',
        'provisioned_cpu_cores_lte': 'provisioned_cpu_cores_lte',
        'provisioned_cpu_cores_not': 'provisioned_cpu_cores_not',
        'provisioned_cpu_cores_not_in': 'provisioned_cpu_cores_not_in',
        'provisioned_memory_bytes': 'provisioned_memory_bytes',
        'provisioned_memory_bytes_gt': 'provisioned_memory_bytes_gt',
        'provisioned_memory_bytes_gte': 'provisioned_memory_bytes_gte',
        'provisioned_memory_bytes_in': 'provisioned_memory_bytes_in',
        'provisioned_memory_bytes_lt': 'provisioned_memory_bytes_lt',
        'provisioned_memory_bytes_lte': 'provisioned_memory_bytes_lte',
        'provisioned_memory_bytes_not': 'provisioned_memory_bytes_not',
        'provisioned_memory_bytes_not_in': 'provisioned_memory_bytes_not_in',
        'running_pause_vm_memory_bytes': 'running_pause_vm_memory_bytes',
        'running_pause_vm_memory_bytes_gt': 'running_pause_vm_memory_bytes_gt',
        'running_pause_vm_memory_bytes_gte': 'running_pause_vm_memory_bytes_gte',
        'running_pause_vm_memory_bytes_in': 'running_pause_vm_memory_bytes_in',
        'running_pause_vm_memory_bytes_lt': 'running_pause_vm_memory_bytes_lt',
        'running_pause_vm_memory_bytes_lte': 'running_pause_vm_memory_bytes_lte',
        'running_pause_vm_memory_bytes_not': 'running_pause_vm_memory_bytes_not',
        'running_pause_vm_memory_bytes_not_in': 'running_pause_vm_memory_bytes_not_in',
        'running_vm_num': 'running_vm_num',
        'running_vm_num_gt': 'running_vm_num_gt',
        'running_vm_num_gte': 'running_vm_num_gte',
        'running_vm_num_in': 'running_vm_num_in',
        'running_vm_num_lt': 'running_vm_num_lt',
        'running_vm_num_lte': 'running_vm_num_lte',
        'running_vm_num_not': 'running_vm_num_not',
        'running_vm_num_not_in': 'running_vm_num_not_in',
        'scvm_cpu': 'scvm_cpu',
        'scvm_cpu_gt': 'scvm_cpu_gt',
        'scvm_cpu_gte': 'scvm_cpu_gte',
        'scvm_cpu_in': 'scvm_cpu_in',
        'scvm_cpu_lt': 'scvm_cpu_lt',
        'scvm_cpu_lte': 'scvm_cpu_lte',
        'scvm_cpu_not': 'scvm_cpu_not',
        'scvm_cpu_not_in': 'scvm_cpu_not_in',
        'scvm_memory': 'scvm_memory',
        'scvm_memory_gt': 'scvm_memory_gt',
        'scvm_memory_gte': 'scvm_memory_gte',
        'scvm_memory_in': 'scvm_memory_in',
        'scvm_memory_lt': 'scvm_memory_lt',
        'scvm_memory_lte': 'scvm_memory_lte',
        'scvm_memory_not': 'scvm_memory_not',
        'scvm_memory_not_in': 'scvm_memory_not_in',
        'scvm_name': 'scvm_name',
        'scvm_name_contains': 'scvm_name_contains',
        'scvm_name_ends_with': 'scvm_name_ends_with',
        'scvm_name_gt': 'scvm_name_gt',
        'scvm_name_gte': 'scvm_name_gte',
        'scvm_name_in': 'scvm_name_in',
        'scvm_name_lt': 'scvm_name_lt',
        'scvm_name_lte': 'scvm_name_lte',
        'scvm_name_not': 'scvm_name_not',
        'scvm_name_not_contains': 'scvm_name_not_contains',
        'scvm_name_not_ends_with': 'scvm_name_not_ends_with',
        'scvm_name_not_in': 'scvm_name_not_in',
        'scvm_name_not_starts_with': 'scvm_name_not_starts_with',
        'scvm_name_starts_with': 'scvm_name_starts_with',
        'serial': 'serial',
        'serial_contains': 'serial_contains',
        'serial_ends_with': 'serial_ends_with',
        'serial_gt': 'serial_gt',
        'serial_gte': 'serial_gte',
        'serial_in': 'serial_in',
        'serial_lt': 'serial_lt',
        'serial_lte': 'serial_lte',
        'serial_not': 'serial_not',
        'serial_not_contains': 'serial_not_contains',
        'serial_not_ends_with': 'serial_not_ends_with',
        'serial_not_in': 'serial_not_in',
        'serial_not_starts_with': 'serial_not_starts_with',
        'serial_starts_with': 'serial_starts_with',
        'ssd_data_capacity': 'ssd_data_capacity',
        'ssd_data_capacity_gt': 'ssd_data_capacity_gt',
        'ssd_data_capacity_gte': 'ssd_data_capacity_gte',
        'ssd_data_capacity_in': 'ssd_data_capacity_in',
        'ssd_data_capacity_lt': 'ssd_data_capacity_lt',
        'ssd_data_capacity_lte': 'ssd_data_capacity_lte',
        'ssd_data_capacity_not': 'ssd_data_capacity_not',
        'ssd_data_capacity_not_in': 'ssd_data_capacity_not_in',
        'ssd_disk_count': 'ssd_disk_count',
        'ssd_disk_count_gt': 'ssd_disk_count_gt',
        'ssd_disk_count_gte': 'ssd_disk_count_gte',
        'ssd_disk_count_in': 'ssd_disk_count_in',
        'ssd_disk_count_lt': 'ssd_disk_count_lt',
        'ssd_disk_count_lte': 'ssd_disk_count_lte',
        'ssd_disk_count_not': 'ssd_disk_count_not',
        'ssd_disk_count_not_in': 'ssd_disk_count_not_in',
        'state': 'state',
        'state_in': 'state_in',
        'state_not': 'state_not',
        'state_not_in': 'state_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'stopped_vm_num': 'stopped_vm_num',
        'stopped_vm_num_gt': 'stopped_vm_num_gt',
        'stopped_vm_num_gte': 'stopped_vm_num_gte',
        'stopped_vm_num_in': 'stopped_vm_num_in',
        'stopped_vm_num_lt': 'stopped_vm_num_lt',
        'stopped_vm_num_lte': 'stopped_vm_num_lte',
        'stopped_vm_num_not': 'stopped_vm_num_not',
        'stopped_vm_num_not_in': 'stopped_vm_num_not_in',
        'suspended_vm_num': 'suspended_vm_num',
        'suspended_vm_num_gt': 'suspended_vm_num_gt',
        'suspended_vm_num_gte': 'suspended_vm_num_gte',
        'suspended_vm_num_in': 'suspended_vm_num_in',
        'suspended_vm_num_lt': 'suspended_vm_num_lt',
        'suspended_vm_num_lte': 'suspended_vm_num_lte',
        'suspended_vm_num_not': 'suspended_vm_num_not',
        'suspended_vm_num_not_in': 'suspended_vm_num_not_in',
        'total_cache_capacity': 'total_cache_capacity',
        'total_cache_capacity_gt': 'total_cache_capacity_gt',
        'total_cache_capacity_gte': 'total_cache_capacity_gte',
        'total_cache_capacity_in': 'total_cache_capacity_in',
        'total_cache_capacity_lt': 'total_cache_capacity_lt',
        'total_cache_capacity_lte': 'total_cache_capacity_lte',
        'total_cache_capacity_not': 'total_cache_capacity_not',
        'total_cache_capacity_not_in': 'total_cache_capacity_not_in',
        'total_cpu_cores': 'total_cpu_cores',
        'total_cpu_cores_gt': 'total_cpu_cores_gt',
        'total_cpu_cores_gte': 'total_cpu_cores_gte',
        'total_cpu_cores_in': 'total_cpu_cores_in',
        'total_cpu_cores_lt': 'total_cpu_cores_lt',
        'total_cpu_cores_lte': 'total_cpu_cores_lte',
        'total_cpu_cores_not': 'total_cpu_cores_not',
        'total_cpu_cores_not_in': 'total_cpu_cores_not_in',
        'total_cpu_hz': 'total_cpu_hz',
        'total_cpu_hz_gt': 'total_cpu_hz_gt',
        'total_cpu_hz_gte': 'total_cpu_hz_gte',
        'total_cpu_hz_in': 'total_cpu_hz_in',
        'total_cpu_hz_lt': 'total_cpu_hz_lt',
        'total_cpu_hz_lte': 'total_cpu_hz_lte',
        'total_cpu_hz_not': 'total_cpu_hz_not',
        'total_cpu_hz_not_in': 'total_cpu_hz_not_in',
        'total_cpu_sockets': 'total_cpu_sockets',
        'total_cpu_sockets_gt': 'total_cpu_sockets_gt',
        'total_cpu_sockets_gte': 'total_cpu_sockets_gte',
        'total_cpu_sockets_in': 'total_cpu_sockets_in',
        'total_cpu_sockets_lt': 'total_cpu_sockets_lt',
        'total_cpu_sockets_lte': 'total_cpu_sockets_lte',
        'total_cpu_sockets_not': 'total_cpu_sockets_not',
        'total_cpu_sockets_not_in': 'total_cpu_sockets_not_in',
        'total_data_capacity': 'total_data_capacity',
        'total_data_capacity_gt': 'total_data_capacity_gt',
        'total_data_capacity_gte': 'total_data_capacity_gte',
        'total_data_capacity_in': 'total_data_capacity_in',
        'total_data_capacity_lt': 'total_data_capacity_lt',
        'total_data_capacity_lte': 'total_data_capacity_lte',
        'total_data_capacity_not': 'total_data_capacity_not',
        'total_data_capacity_not_in': 'total_data_capacity_not_in',
        'total_memory_bytes': 'total_memory_bytes',
        'total_memory_bytes_gt': 'total_memory_bytes_gt',
        'total_memory_bytes_gte': 'total_memory_bytes_gte',
        'total_memory_bytes_in': 'total_memory_bytes_in',
        'total_memory_bytes_lt': 'total_memory_bytes_lt',
        'total_memory_bytes_lte': 'total_memory_bytes_lte',
        'total_memory_bytes_not': 'total_memory_bytes_not',
        'total_memory_bytes_not_in': 'total_memory_bytes_not_in',
        'usb_devices_every': 'usb_devices_every',
        'usb_devices_none': 'usb_devices_none',
        'usb_devices_some': 'usb_devices_some',
        'used_cache_space': 'used_cache_space',
        'used_cache_space_gt': 'used_cache_space_gt',
        'used_cache_space_gte': 'used_cache_space_gte',
        'used_cache_space_in': 'used_cache_space_in',
        'used_cache_space_lt': 'used_cache_space_lt',
        'used_cache_space_lte': 'used_cache_space_lte',
        'used_cache_space_not': 'used_cache_space_not',
        'used_cache_space_not_in': 'used_cache_space_not_in',
        'used_cpu_hz': 'used_cpu_hz',
        'used_cpu_hz_gt': 'used_cpu_hz_gt',
        'used_cpu_hz_gte': 'used_cpu_hz_gte',
        'used_cpu_hz_in': 'used_cpu_hz_in',
        'used_cpu_hz_lt': 'used_cpu_hz_lt',
        'used_cpu_hz_lte': 'used_cpu_hz_lte',
        'used_cpu_hz_not': 'used_cpu_hz_not',
        'used_cpu_hz_not_in': 'used_cpu_hz_not_in',
        'used_data_space': 'used_data_space',
        'used_data_space_gt': 'used_data_space_gt',
        'used_data_space_gte': 'used_data_space_gte',
        'used_data_space_in': 'used_data_space_in',
        'used_data_space_lt': 'used_data_space_lt',
        'used_data_space_lte': 'used_data_space_lte',
        'used_data_space_not': 'used_data_space_not',
        'used_data_space_not_in': 'used_data_space_not_in',
        'used_memory_bytes': 'used_memory_bytes',
        'used_memory_bytes_gt': 'used_memory_bytes_gt',
        'used_memory_bytes_gte': 'used_memory_bytes_gte',
        'used_memory_bytes_in': 'used_memory_bytes_in',
        'used_memory_bytes_lt': 'used_memory_bytes_lt',
        'used_memory_bytes_lte': 'used_memory_bytes_lte',
        'used_memory_bytes_not': 'used_memory_bytes_not',
        'used_memory_bytes_not_in': 'used_memory_bytes_not_in',
        'valid_cache_space': 'valid_cache_space',
        'valid_cache_space_gt': 'valid_cache_space_gt',
        'valid_cache_space_gte': 'valid_cache_space_gte',
        'valid_cache_space_in': 'valid_cache_space_in',
        'valid_cache_space_lt': 'valid_cache_space_lt',
        'valid_cache_space_lte': 'valid_cache_space_lte',
        'valid_cache_space_not': 'valid_cache_space_not',
        'valid_cache_space_not_in': 'valid_cache_space_not_in',
        'valid_free_cache_space': 'valid_free_cache_space',
        'valid_free_cache_space_gt': 'valid_free_cache_space_gt',
        'valid_free_cache_space_gte': 'valid_free_cache_space_gte',
        'valid_free_cache_space_in': 'valid_free_cache_space_in',
        'valid_free_cache_space_lt': 'valid_free_cache_space_lt',
        'valid_free_cache_space_lte': 'valid_free_cache_space_lte',
        'valid_free_cache_space_not': 'valid_free_cache_space_not',
        'valid_free_cache_space_not_in': 'valid_free_cache_space_not_in',
        'vm_num': 'vm_num',
        'vm_num_gt': 'vm_num_gt',
        'vm_num_gte': 'vm_num_gte',
        'vm_num_in': 'vm_num_in',
        'vm_num_lt': 'vm_num_lt',
        'vm_num_lte': 'vm_num_lte',
        'vm_num_not': 'vm_num_not',
        'vm_num_not_in': 'vm_num_not_in',
        'vmotion_ip': 'vmotion_ip',
        'vmotion_ip_contains': 'vmotion_ip_contains',
        'vmotion_ip_ends_with': 'vmotion_ip_ends_with',
        'vmotion_ip_gt': 'vmotion_ip_gt',
        'vmotion_ip_gte': 'vmotion_ip_gte',
        'vmotion_ip_in': 'vmotion_ip_in',
        'vmotion_ip_lt': 'vmotion_ip_lt',
        'vmotion_ip_lte': 'vmotion_ip_lte',
        'vmotion_ip_not': 'vmotion_ip_not',
        'vmotion_ip_not_contains': 'vmotion_ip_not_contains',
        'vmotion_ip_not_ends_with': 'vmotion_ip_not_ends_with',
        'vmotion_ip_not_in': 'vmotion_ip_not_in',
        'vmotion_ip_not_starts_with': 'vmotion_ip_not_starts_with',
        'vmotion_ip_starts_with': 'vmotion_ip_starts_with',
        'vms_every': 'vms_every',
        'vms_none': 'vms_none',
        'vms_some': 'vms_some',
        'vsphere_esxi_account': 'vsphereEsxiAccount',
        'with_faster_ssd_as_cache': 'with_faster_ssd_as_cache',
        'with_faster_ssd_as_cache_not': 'with_faster_ssd_as_cache_not',
        'zone': 'zone'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """HostWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._access_ip = None
        self._access_ip_contains = None
        self._access_ip_ends_with = None
        self._access_ip_gt = None
        self._access_ip_gte = None
        self._access_ip_in = None
        self._access_ip_lt = None
        self._access_ip_lte = None
        self._access_ip_not = None
        self._access_ip_not_contains = None
        self._access_ip_not_ends_with = None
        self._access_ip_not_in = None
        self._access_ip_not_starts_with = None
        self._access_ip_starts_with = None
        self._allocable_cpu_cores_for_vm_exclusive = None
        self._allocable_cpu_cores_for_vm_exclusive_gt = None
        self._allocable_cpu_cores_for_vm_exclusive_gte = None
        self._allocable_cpu_cores_for_vm_exclusive_in = None
        self._allocable_cpu_cores_for_vm_exclusive_lt = None
        self._allocable_cpu_cores_for_vm_exclusive_lte = None
        self._allocable_cpu_cores_for_vm_exclusive_not = None
        self._allocable_cpu_cores_for_vm_exclusive_not_in = None
        self._allocatable_memory_bytes = None
        self._allocatable_memory_bytes_gt = None
        self._allocatable_memory_bytes_gte = None
        self._allocatable_memory_bytes_in = None
        self._allocatable_memory_bytes_lt = None
        self._allocatable_memory_bytes_lte = None
        self._allocatable_memory_bytes_not = None
        self._allocatable_memory_bytes_not_in = None
        self._allocated_prioritized_space = None
        self._allocated_prioritized_space_gt = None
        self._allocated_prioritized_space_gte = None
        self._allocated_prioritized_space_in = None
        self._allocated_prioritized_space_lt = None
        self._allocated_prioritized_space_lte = None
        self._allocated_prioritized_space_not = None
        self._allocated_prioritized_space_not_in = None
        self._allocated_prioritized_space_usage = None
        self._allocated_prioritized_space_usage_gt = None
        self._allocated_prioritized_space_usage_gte = None
        self._allocated_prioritized_space_usage_in = None
        self._allocated_prioritized_space_usage_lt = None
        self._allocated_prioritized_space_usage_lte = None
        self._allocated_prioritized_space_usage_not = None
        self._allocated_prioritized_space_usage_not_in = None
        self._chunk_id = None
        self._chunk_id_contains = None
        self._chunk_id_ends_with = None
        self._chunk_id_gt = None
        self._chunk_id_gte = None
        self._chunk_id_in = None
        self._chunk_id_lt = None
        self._chunk_id_lte = None
        self._chunk_id_not = None
        self._chunk_id_not_contains = None
        self._chunk_id_not_ends_with = None
        self._chunk_id_not_in = None
        self._chunk_id_not_starts_with = None
        self._chunk_id_starts_with = None
        self._cluster = None
        self._commited_memory_bytes = None
        self._commited_memory_bytes_gt = None
        self._commited_memory_bytes_gte = None
        self._commited_memory_bytes_in = None
        self._commited_memory_bytes_lt = None
        self._commited_memory_bytes_lte = None
        self._commited_memory_bytes_not = None
        self._commited_memory_bytes_not_in = None
        self._connect_status = None
        self._connect_status_in = None
        self._connect_status_not = None
        self._connect_status_not_in = None
        self._cpu_brand = None
        self._cpu_brand_contains = None
        self._cpu_brand_ends_with = None
        self._cpu_brand_gt = None
        self._cpu_brand_gte = None
        self._cpu_brand_in = None
        self._cpu_brand_lt = None
        self._cpu_brand_lte = None
        self._cpu_brand_not = None
        self._cpu_brand_not_contains = None
        self._cpu_brand_not_ends_with = None
        self._cpu_brand_not_in = None
        self._cpu_brand_not_starts_with = None
        self._cpu_brand_starts_with = None
        self._cpu_fan_speed_unit = None
        self._cpu_fan_speed_unit_in = None
        self._cpu_fan_speed_unit_not = None
        self._cpu_fan_speed_unit_not_in = None
        self._cpu_hz_per_core = None
        self._cpu_hz_per_core_gt = None
        self._cpu_hz_per_core_gte = None
        self._cpu_hz_per_core_in = None
        self._cpu_hz_per_core_lt = None
        self._cpu_hz_per_core_lte = None
        self._cpu_hz_per_core_not = None
        self._cpu_hz_per_core_not_in = None
        self._cpu_model = None
        self._cpu_model_contains = None
        self._cpu_model_ends_with = None
        self._cpu_model_gt = None
        self._cpu_model_gte = None
        self._cpu_model_in = None
        self._cpu_model_lt = None
        self._cpu_model_lte = None
        self._cpu_model_not = None
        self._cpu_model_not_contains = None
        self._cpu_model_not_ends_with = None
        self._cpu_model_not_in = None
        self._cpu_model_not_starts_with = None
        self._cpu_model_starts_with = None
        self._cpu_vendor = None
        self._cpu_vendor_contains = None
        self._cpu_vendor_ends_with = None
        self._cpu_vendor_gt = None
        self._cpu_vendor_gte = None
        self._cpu_vendor_in = None
        self._cpu_vendor_lt = None
        self._cpu_vendor_lte = None
        self._cpu_vendor_not = None
        self._cpu_vendor_not_contains = None
        self._cpu_vendor_not_ends_with = None
        self._cpu_vendor_not_in = None
        self._cpu_vendor_not_starts_with = None
        self._cpu_vendor_starts_with = None
        self._data_ip = None
        self._data_ip_contains = None
        self._data_ip_ends_with = None
        self._data_ip_gt = None
        self._data_ip_gte = None
        self._data_ip_in = None
        self._data_ip_lt = None
        self._data_ip_lte = None
        self._data_ip_not = None
        self._data_ip_not_contains = None
        self._data_ip_not_ends_with = None
        self._data_ip_not_in = None
        self._data_ip_not_starts_with = None
        self._data_ip_starts_with = None
        self._disk_pools_every = None
        self._disk_pools_none = None
        self._disk_pools_some = None
        self._disks_every = None
        self._disks_none = None
        self._disks_some = None
        self._downgraded_prioritized_space = None
        self._downgraded_prioritized_space_gt = None
        self._downgraded_prioritized_space_gte = None
        self._downgraded_prioritized_space_in = None
        self._downgraded_prioritized_space_lt = None
        self._downgraded_prioritized_space_lte = None
        self._downgraded_prioritized_space_not = None
        self._downgraded_prioritized_space_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._failure_data_space = None
        self._failure_data_space_gt = None
        self._failure_data_space_gte = None
        self._failure_data_space_in = None
        self._failure_data_space_lt = None
        self._failure_data_space_lte = None
        self._failure_data_space_not = None
        self._failure_data_space_not_in = None
        self._gpu_devices_every = None
        self._gpu_devices_none = None
        self._gpu_devices_some = None
        self._hdd_data_capacity = None
        self._hdd_data_capacity_gt = None
        self._hdd_data_capacity_gte = None
        self._hdd_data_capacity_in = None
        self._hdd_data_capacity_lt = None
        self._hdd_data_capacity_lte = None
        self._hdd_data_capacity_not = None
        self._hdd_data_capacity_not_in = None
        self._hdd_disk_count = None
        self._hdd_disk_count_gt = None
        self._hdd_disk_count_gte = None
        self._hdd_disk_count_in = None
        self._hdd_disk_count_lt = None
        self._hdd_disk_count_lte = None
        self._hdd_disk_count_not = None
        self._hdd_disk_count_not_in = None
        self._hypervisor_ip = None
        self._hypervisor_ip_contains = None
        self._hypervisor_ip_ends_with = None
        self._hypervisor_ip_gt = None
        self._hypervisor_ip_gte = None
        self._hypervisor_ip_in = None
        self._hypervisor_ip_lt = None
        self._hypervisor_ip_lte = None
        self._hypervisor_ip_not = None
        self._hypervisor_ip_not_contains = None
        self._hypervisor_ip_not_ends_with = None
        self._hypervisor_ip_not_in = None
        self._hypervisor_ip_not_starts_with = None
        self._hypervisor_ip_starts_with = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._iommu = None
        self._iommu_in = None
        self._iommu_not = None
        self._iommu_not_in = None
        self._ipmi = None
        self._is_os_in_raid1 = None
        self._is_os_in_raid1_not = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._lsm_cap_disk_safe_umount = None
        self._lsm_cap_disk_safe_umount_not = None
        self._management_ip = None
        self._management_ip_contains = None
        self._management_ip_ends_with = None
        self._management_ip_gt = None
        self._management_ip_gte = None
        self._management_ip_in = None
        self._management_ip_lt = None
        self._management_ip_lte = None
        self._management_ip_not = None
        self._management_ip_not_contains = None
        self._management_ip_not_ends_with = None
        self._management_ip_not_in = None
        self._management_ip_not_starts_with = None
        self._management_ip_starts_with = None
        self._merged_status = None
        self._merged_status_in = None
        self._merged_status_not = None
        self._merged_status_not_in = None
        self._model = None
        self._model_contains = None
        self._model_ends_with = None
        self._model_gt = None
        self._model_gte = None
        self._model_in = None
        self._model_lt = None
        self._model_lte = None
        self._model_not = None
        self._model_not_contains = None
        self._model_not_ends_with = None
        self._model_not_in = None
        self._model_not_starts_with = None
        self._model_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._nested_virtualization = None
        self._nested_virtualization_not = None
        self._nic_count = None
        self._nic_count_gt = None
        self._nic_count_gte = None
        self._nic_count_in = None
        self._nic_count_lt = None
        self._nic_count_lte = None
        self._nic_count_not = None
        self._nic_count_not_in = None
        self._nics_every = None
        self._nics_none = None
        self._nics_some = None
        self._node_topo_local_id = None
        self._node_topo_local_id_contains = None
        self._node_topo_local_id_ends_with = None
        self._node_topo_local_id_gt = None
        self._node_topo_local_id_gte = None
        self._node_topo_local_id_in = None
        self._node_topo_local_id_lt = None
        self._node_topo_local_id_lte = None
        self._node_topo_local_id_not = None
        self._node_topo_local_id_not_contains = None
        self._node_topo_local_id_not_ends_with = None
        self._node_topo_local_id_not_in = None
        self._node_topo_local_id_not_starts_with = None
        self._node_topo_local_id_starts_with = None
        self._os_memory_bytes = None
        self._os_memory_bytes_gt = None
        self._os_memory_bytes_gte = None
        self._os_memory_bytes_in = None
        self._os_memory_bytes_lt = None
        self._os_memory_bytes_lte = None
        self._os_memory_bytes_not = None
        self._os_memory_bytes_not_in = None
        self._os_version = None
        self._os_version_contains = None
        self._os_version_ends_with = None
        self._os_version_gt = None
        self._os_version_gte = None
        self._os_version_in = None
        self._os_version_lt = None
        self._os_version_lte = None
        self._os_version_not = None
        self._os_version_not_contains = None
        self._os_version_not_ends_with = None
        self._os_version_not_in = None
        self._os_version_not_starts_with = None
        self._os_version_starts_with = None
        self._perf_allocated_data_space = None
        self._perf_allocated_data_space_gt = None
        self._perf_allocated_data_space_gte = None
        self._perf_allocated_data_space_in = None
        self._perf_allocated_data_space_lt = None
        self._perf_allocated_data_space_lte = None
        self._perf_allocated_data_space_not = None
        self._perf_allocated_data_space_not_in = None
        self._perf_failure_data_space = None
        self._perf_failure_data_space_gt = None
        self._perf_failure_data_space_gte = None
        self._perf_failure_data_space_in = None
        self._perf_failure_data_space_lt = None
        self._perf_failure_data_space_lte = None
        self._perf_failure_data_space_not = None
        self._perf_failure_data_space_not_in = None
        self._perf_total_data_capacity = None
        self._perf_total_data_capacity_gt = None
        self._perf_total_data_capacity_gte = None
        self._perf_total_data_capacity_in = None
        self._perf_total_data_capacity_lt = None
        self._perf_total_data_capacity_lte = None
        self._perf_total_data_capacity_not = None
        self._perf_total_data_capacity_not_in = None
        self._perf_used_data_space = None
        self._perf_used_data_space_gt = None
        self._perf_used_data_space_gte = None
        self._perf_used_data_space_in = None
        self._perf_used_data_space_lt = None
        self._perf_used_data_space_lte = None
        self._perf_used_data_space_not = None
        self._perf_used_data_space_not_in = None
        self._perf_valid_data_space = None
        self._perf_valid_data_space_gt = None
        self._perf_valid_data_space_gte = None
        self._perf_valid_data_space_in = None
        self._perf_valid_data_space_lt = None
        self._perf_valid_data_space_lte = None
        self._perf_valid_data_space_not = None
        self._perf_valid_data_space_not_in = None
        self._planned_prioritized_space = None
        self._planned_prioritized_space_gt = None
        self._planned_prioritized_space_gte = None
        self._planned_prioritized_space_in = None
        self._planned_prioritized_space_lt = None
        self._planned_prioritized_space_lte = None
        self._planned_prioritized_space_not = None
        self._planned_prioritized_space_not_in = None
        self._pmem_dimm_capacity = None
        self._pmem_dimm_capacity_gt = None
        self._pmem_dimm_capacity_gte = None
        self._pmem_dimm_capacity_in = None
        self._pmem_dimm_capacity_lt = None
        self._pmem_dimm_capacity_lte = None
        self._pmem_dimm_capacity_not = None
        self._pmem_dimm_capacity_not_in = None
        self._pmem_dimm_count = None
        self._pmem_dimm_count_gt = None
        self._pmem_dimm_count_gte = None
        self._pmem_dimm_count_in = None
        self._pmem_dimm_count_lt = None
        self._pmem_dimm_count_lte = None
        self._pmem_dimm_count_not = None
        self._pmem_dimm_count_not_in = None
        self._pmem_dimms_every = None
        self._pmem_dimms_none = None
        self._pmem_dimms_some = None
        self._pmem_disk_count = None
        self._pmem_disk_count_gt = None
        self._pmem_disk_count_gte = None
        self._pmem_disk_count_in = None
        self._pmem_disk_count_lt = None
        self._pmem_disk_count_lte = None
        self._pmem_disk_count_not = None
        self._pmem_disk_count_not_in = None
        self._prio_space_percentage = None
        self._prio_space_percentage_gt = None
        self._prio_space_percentage_gte = None
        self._prio_space_percentage_in = None
        self._prio_space_percentage_lt = None
        self._prio_space_percentage_lte = None
        self._prio_space_percentage_not = None
        self._prio_space_percentage_not_in = None
        self._provisioned_cpu_cores = None
        self._provisioned_cpu_cores_gt = None
        self._provisioned_cpu_cores_gte = None
        self._provisioned_cpu_cores_in = None
        self._provisioned_cpu_cores_lt = None
        self._provisioned_cpu_cores_lte = None
        self._provisioned_cpu_cores_not = None
        self._provisioned_cpu_cores_not_in = None
        self._provisioned_memory_bytes = None
        self._provisioned_memory_bytes_gt = None
        self._provisioned_memory_bytes_gte = None
        self._provisioned_memory_bytes_in = None
        self._provisioned_memory_bytes_lt = None
        self._provisioned_memory_bytes_lte = None
        self._provisioned_memory_bytes_not = None
        self._provisioned_memory_bytes_not_in = None
        self._running_pause_vm_memory_bytes = None
        self._running_pause_vm_memory_bytes_gt = None
        self._running_pause_vm_memory_bytes_gte = None
        self._running_pause_vm_memory_bytes_in = None
        self._running_pause_vm_memory_bytes_lt = None
        self._running_pause_vm_memory_bytes_lte = None
        self._running_pause_vm_memory_bytes_not = None
        self._running_pause_vm_memory_bytes_not_in = None
        self._running_vm_num = None
        self._running_vm_num_gt = None
        self._running_vm_num_gte = None
        self._running_vm_num_in = None
        self._running_vm_num_lt = None
        self._running_vm_num_lte = None
        self._running_vm_num_not = None
        self._running_vm_num_not_in = None
        self._scvm_cpu = None
        self._scvm_cpu_gt = None
        self._scvm_cpu_gte = None
        self._scvm_cpu_in = None
        self._scvm_cpu_lt = None
        self._scvm_cpu_lte = None
        self._scvm_cpu_not = None
        self._scvm_cpu_not_in = None
        self._scvm_memory = None
        self._scvm_memory_gt = None
        self._scvm_memory_gte = None
        self._scvm_memory_in = None
        self._scvm_memory_lt = None
        self._scvm_memory_lte = None
        self._scvm_memory_not = None
        self._scvm_memory_not_in = None
        self._scvm_name = None
        self._scvm_name_contains = None
        self._scvm_name_ends_with = None
        self._scvm_name_gt = None
        self._scvm_name_gte = None
        self._scvm_name_in = None
        self._scvm_name_lt = None
        self._scvm_name_lte = None
        self._scvm_name_not = None
        self._scvm_name_not_contains = None
        self._scvm_name_not_ends_with = None
        self._scvm_name_not_in = None
        self._scvm_name_not_starts_with = None
        self._scvm_name_starts_with = None
        self._serial = None
        self._serial_contains = None
        self._serial_ends_with = None
        self._serial_gt = None
        self._serial_gte = None
        self._serial_in = None
        self._serial_lt = None
        self._serial_lte = None
        self._serial_not = None
        self._serial_not_contains = None
        self._serial_not_ends_with = None
        self._serial_not_in = None
        self._serial_not_starts_with = None
        self._serial_starts_with = None
        self._ssd_data_capacity = None
        self._ssd_data_capacity_gt = None
        self._ssd_data_capacity_gte = None
        self._ssd_data_capacity_in = None
        self._ssd_data_capacity_lt = None
        self._ssd_data_capacity_lte = None
        self._ssd_data_capacity_not = None
        self._ssd_data_capacity_not_in = None
        self._ssd_disk_count = None
        self._ssd_disk_count_gt = None
        self._ssd_disk_count_gte = None
        self._ssd_disk_count_in = None
        self._ssd_disk_count_lt = None
        self._ssd_disk_count_lte = None
        self._ssd_disk_count_not = None
        self._ssd_disk_count_not_in = None
        self._state = None
        self._state_in = None
        self._state_not = None
        self._state_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._stopped_vm_num = None
        self._stopped_vm_num_gt = None
        self._stopped_vm_num_gte = None
        self._stopped_vm_num_in = None
        self._stopped_vm_num_lt = None
        self._stopped_vm_num_lte = None
        self._stopped_vm_num_not = None
        self._stopped_vm_num_not_in = None
        self._suspended_vm_num = None
        self._suspended_vm_num_gt = None
        self._suspended_vm_num_gte = None
        self._suspended_vm_num_in = None
        self._suspended_vm_num_lt = None
        self._suspended_vm_num_lte = None
        self._suspended_vm_num_not = None
        self._suspended_vm_num_not_in = None
        self._total_cache_capacity = None
        self._total_cache_capacity_gt = None
        self._total_cache_capacity_gte = None
        self._total_cache_capacity_in = None
        self._total_cache_capacity_lt = None
        self._total_cache_capacity_lte = None
        self._total_cache_capacity_not = None
        self._total_cache_capacity_not_in = None
        self._total_cpu_cores = None
        self._total_cpu_cores_gt = None
        self._total_cpu_cores_gte = None
        self._total_cpu_cores_in = None
        self._total_cpu_cores_lt = None
        self._total_cpu_cores_lte = None
        self._total_cpu_cores_not = None
        self._total_cpu_cores_not_in = None
        self._total_cpu_hz = None
        self._total_cpu_hz_gt = None
        self._total_cpu_hz_gte = None
        self._total_cpu_hz_in = None
        self._total_cpu_hz_lt = None
        self._total_cpu_hz_lte = None
        self._total_cpu_hz_not = None
        self._total_cpu_hz_not_in = None
        self._total_cpu_sockets = None
        self._total_cpu_sockets_gt = None
        self._total_cpu_sockets_gte = None
        self._total_cpu_sockets_in = None
        self._total_cpu_sockets_lt = None
        self._total_cpu_sockets_lte = None
        self._total_cpu_sockets_not = None
        self._total_cpu_sockets_not_in = None
        self._total_data_capacity = None
        self._total_data_capacity_gt = None
        self._total_data_capacity_gte = None
        self._total_data_capacity_in = None
        self._total_data_capacity_lt = None
        self._total_data_capacity_lte = None
        self._total_data_capacity_not = None
        self._total_data_capacity_not_in = None
        self._total_memory_bytes = None
        self._total_memory_bytes_gt = None
        self._total_memory_bytes_gte = None
        self._total_memory_bytes_in = None
        self._total_memory_bytes_lt = None
        self._total_memory_bytes_lte = None
        self._total_memory_bytes_not = None
        self._total_memory_bytes_not_in = None
        self._usb_devices_every = None
        self._usb_devices_none = None
        self._usb_devices_some = None
        self._used_cache_space = None
        self._used_cache_space_gt = None
        self._used_cache_space_gte = None
        self._used_cache_space_in = None
        self._used_cache_space_lt = None
        self._used_cache_space_lte = None
        self._used_cache_space_not = None
        self._used_cache_space_not_in = None
        self._used_cpu_hz = None
        self._used_cpu_hz_gt = None
        self._used_cpu_hz_gte = None
        self._used_cpu_hz_in = None
        self._used_cpu_hz_lt = None
        self._used_cpu_hz_lte = None
        self._used_cpu_hz_not = None
        self._used_cpu_hz_not_in = None
        self._used_data_space = None
        self._used_data_space_gt = None
        self._used_data_space_gte = None
        self._used_data_space_in = None
        self._used_data_space_lt = None
        self._used_data_space_lte = None
        self._used_data_space_not = None
        self._used_data_space_not_in = None
        self._used_memory_bytes = None
        self._used_memory_bytes_gt = None
        self._used_memory_bytes_gte = None
        self._used_memory_bytes_in = None
        self._used_memory_bytes_lt = None
        self._used_memory_bytes_lte = None
        self._used_memory_bytes_not = None
        self._used_memory_bytes_not_in = None
        self._valid_cache_space = None
        self._valid_cache_space_gt = None
        self._valid_cache_space_gte = None
        self._valid_cache_space_in = None
        self._valid_cache_space_lt = None
        self._valid_cache_space_lte = None
        self._valid_cache_space_not = None
        self._valid_cache_space_not_in = None
        self._valid_free_cache_space = None
        self._valid_free_cache_space_gt = None
        self._valid_free_cache_space_gte = None
        self._valid_free_cache_space_in = None
        self._valid_free_cache_space_lt = None
        self._valid_free_cache_space_lte = None
        self._valid_free_cache_space_not = None
        self._valid_free_cache_space_not_in = None
        self._vm_num = None
        self._vm_num_gt = None
        self._vm_num_gte = None
        self._vm_num_in = None
        self._vm_num_lt = None
        self._vm_num_lte = None
        self._vm_num_not = None
        self._vm_num_not_in = None
        self._vmotion_ip = None
        self._vmotion_ip_contains = None
        self._vmotion_ip_ends_with = None
        self._vmotion_ip_gt = None
        self._vmotion_ip_gte = None
        self._vmotion_ip_in = None
        self._vmotion_ip_lt = None
        self._vmotion_ip_lte = None
        self._vmotion_ip_not = None
        self._vmotion_ip_not_contains = None
        self._vmotion_ip_not_ends_with = None
        self._vmotion_ip_not_in = None
        self._vmotion_ip_not_starts_with = None
        self._vmotion_ip_starts_with = None
        self._vms_every = None
        self._vms_none = None
        self._vms_some = None
        self._vsphere_esxi_account = None
        self._with_faster_ssd_as_cache = None
        self._with_faster_ssd_as_cache_not = None
        self._zone = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.access_ip = kwargs.get("access_ip", None)
        self.access_ip_contains = kwargs.get("access_ip_contains", None)
        self.access_ip_ends_with = kwargs.get("access_ip_ends_with", None)
        self.access_ip_gt = kwargs.get("access_ip_gt", None)
        self.access_ip_gte = kwargs.get("access_ip_gte", None)
        self.access_ip_in = kwargs.get("access_ip_in", None)
        self.access_ip_lt = kwargs.get("access_ip_lt", None)
        self.access_ip_lte = kwargs.get("access_ip_lte", None)
        self.access_ip_not = kwargs.get("access_ip_not", None)
        self.access_ip_not_contains = kwargs.get("access_ip_not_contains", None)
        self.access_ip_not_ends_with = kwargs.get("access_ip_not_ends_with", None)
        self.access_ip_not_in = kwargs.get("access_ip_not_in", None)
        self.access_ip_not_starts_with = kwargs.get("access_ip_not_starts_with", None)
        self.access_ip_starts_with = kwargs.get("access_ip_starts_with", None)
        self.allocable_cpu_cores_for_vm_exclusive = kwargs.get("allocable_cpu_cores_for_vm_exclusive", None)
        self.allocable_cpu_cores_for_vm_exclusive_gt = kwargs.get("allocable_cpu_cores_for_vm_exclusive_gt", None)
        self.allocable_cpu_cores_for_vm_exclusive_gte = kwargs.get("allocable_cpu_cores_for_vm_exclusive_gte", None)
        self.allocable_cpu_cores_for_vm_exclusive_in = kwargs.get("allocable_cpu_cores_for_vm_exclusive_in", None)
        self.allocable_cpu_cores_for_vm_exclusive_lt = kwargs.get("allocable_cpu_cores_for_vm_exclusive_lt", None)
        self.allocable_cpu_cores_for_vm_exclusive_lte = kwargs.get("allocable_cpu_cores_for_vm_exclusive_lte", None)
        self.allocable_cpu_cores_for_vm_exclusive_not = kwargs.get("allocable_cpu_cores_for_vm_exclusive_not", None)
        self.allocable_cpu_cores_for_vm_exclusive_not_in = kwargs.get("allocable_cpu_cores_for_vm_exclusive_not_in", None)
        self.allocatable_memory_bytes = kwargs.get("allocatable_memory_bytes", None)
        self.allocatable_memory_bytes_gt = kwargs.get("allocatable_memory_bytes_gt", None)
        self.allocatable_memory_bytes_gte = kwargs.get("allocatable_memory_bytes_gte", None)
        self.allocatable_memory_bytes_in = kwargs.get("allocatable_memory_bytes_in", None)
        self.allocatable_memory_bytes_lt = kwargs.get("allocatable_memory_bytes_lt", None)
        self.allocatable_memory_bytes_lte = kwargs.get("allocatable_memory_bytes_lte", None)
        self.allocatable_memory_bytes_not = kwargs.get("allocatable_memory_bytes_not", None)
        self.allocatable_memory_bytes_not_in = kwargs.get("allocatable_memory_bytes_not_in", None)
        self.allocated_prioritized_space = kwargs.get("allocated_prioritized_space", None)
        self.allocated_prioritized_space_gt = kwargs.get("allocated_prioritized_space_gt", None)
        self.allocated_prioritized_space_gte = kwargs.get("allocated_prioritized_space_gte", None)
        self.allocated_prioritized_space_in = kwargs.get("allocated_prioritized_space_in", None)
        self.allocated_prioritized_space_lt = kwargs.get("allocated_prioritized_space_lt", None)
        self.allocated_prioritized_space_lte = kwargs.get("allocated_prioritized_space_lte", None)
        self.allocated_prioritized_space_not = kwargs.get("allocated_prioritized_space_not", None)
        self.allocated_prioritized_space_not_in = kwargs.get("allocated_prioritized_space_not_in", None)
        self.allocated_prioritized_space_usage = kwargs.get("allocated_prioritized_space_usage", None)
        self.allocated_prioritized_space_usage_gt = kwargs.get("allocated_prioritized_space_usage_gt", None)
        self.allocated_prioritized_space_usage_gte = kwargs.get("allocated_prioritized_space_usage_gte", None)
        self.allocated_prioritized_space_usage_in = kwargs.get("allocated_prioritized_space_usage_in", None)
        self.allocated_prioritized_space_usage_lt = kwargs.get("allocated_prioritized_space_usage_lt", None)
        self.allocated_prioritized_space_usage_lte = kwargs.get("allocated_prioritized_space_usage_lte", None)
        self.allocated_prioritized_space_usage_not = kwargs.get("allocated_prioritized_space_usage_not", None)
        self.allocated_prioritized_space_usage_not_in = kwargs.get("allocated_prioritized_space_usage_not_in", None)
        self.chunk_id = kwargs.get("chunk_id", None)
        self.chunk_id_contains = kwargs.get("chunk_id_contains", None)
        self.chunk_id_ends_with = kwargs.get("chunk_id_ends_with", None)
        self.chunk_id_gt = kwargs.get("chunk_id_gt", None)
        self.chunk_id_gte = kwargs.get("chunk_id_gte", None)
        self.chunk_id_in = kwargs.get("chunk_id_in", None)
        self.chunk_id_lt = kwargs.get("chunk_id_lt", None)
        self.chunk_id_lte = kwargs.get("chunk_id_lte", None)
        self.chunk_id_not = kwargs.get("chunk_id_not", None)
        self.chunk_id_not_contains = kwargs.get("chunk_id_not_contains", None)
        self.chunk_id_not_ends_with = kwargs.get("chunk_id_not_ends_with", None)
        self.chunk_id_not_in = kwargs.get("chunk_id_not_in", None)
        self.chunk_id_not_starts_with = kwargs.get("chunk_id_not_starts_with", None)
        self.chunk_id_starts_with = kwargs.get("chunk_id_starts_with", None)
        self.cluster = kwargs.get("cluster", None)
        self.commited_memory_bytes = kwargs.get("commited_memory_bytes", None)
        self.commited_memory_bytes_gt = kwargs.get("commited_memory_bytes_gt", None)
        self.commited_memory_bytes_gte = kwargs.get("commited_memory_bytes_gte", None)
        self.commited_memory_bytes_in = kwargs.get("commited_memory_bytes_in", None)
        self.commited_memory_bytes_lt = kwargs.get("commited_memory_bytes_lt", None)
        self.commited_memory_bytes_lte = kwargs.get("commited_memory_bytes_lte", None)
        self.commited_memory_bytes_not = kwargs.get("commited_memory_bytes_not", None)
        self.commited_memory_bytes_not_in = kwargs.get("commited_memory_bytes_not_in", None)
        self.connect_status = kwargs.get("connect_status", None)
        self.connect_status_in = kwargs.get("connect_status_in", None)
        self.connect_status_not = kwargs.get("connect_status_not", None)
        self.connect_status_not_in = kwargs.get("connect_status_not_in", None)
        self.cpu_brand = kwargs.get("cpu_brand", None)
        self.cpu_brand_contains = kwargs.get("cpu_brand_contains", None)
        self.cpu_brand_ends_with = kwargs.get("cpu_brand_ends_with", None)
        self.cpu_brand_gt = kwargs.get("cpu_brand_gt", None)
        self.cpu_brand_gte = kwargs.get("cpu_brand_gte", None)
        self.cpu_brand_in = kwargs.get("cpu_brand_in", None)
        self.cpu_brand_lt = kwargs.get("cpu_brand_lt", None)
        self.cpu_brand_lte = kwargs.get("cpu_brand_lte", None)
        self.cpu_brand_not = kwargs.get("cpu_brand_not", None)
        self.cpu_brand_not_contains = kwargs.get("cpu_brand_not_contains", None)
        self.cpu_brand_not_ends_with = kwargs.get("cpu_brand_not_ends_with", None)
        self.cpu_brand_not_in = kwargs.get("cpu_brand_not_in", None)
        self.cpu_brand_not_starts_with = kwargs.get("cpu_brand_not_starts_with", None)
        self.cpu_brand_starts_with = kwargs.get("cpu_brand_starts_with", None)
        self.cpu_fan_speed_unit = kwargs.get("cpu_fan_speed_unit", None)
        self.cpu_fan_speed_unit_in = kwargs.get("cpu_fan_speed_unit_in", None)
        self.cpu_fan_speed_unit_not = kwargs.get("cpu_fan_speed_unit_not", None)
        self.cpu_fan_speed_unit_not_in = kwargs.get("cpu_fan_speed_unit_not_in", None)
        self.cpu_hz_per_core = kwargs.get("cpu_hz_per_core", None)
        self.cpu_hz_per_core_gt = kwargs.get("cpu_hz_per_core_gt", None)
        self.cpu_hz_per_core_gte = kwargs.get("cpu_hz_per_core_gte", None)
        self.cpu_hz_per_core_in = kwargs.get("cpu_hz_per_core_in", None)
        self.cpu_hz_per_core_lt = kwargs.get("cpu_hz_per_core_lt", None)
        self.cpu_hz_per_core_lte = kwargs.get("cpu_hz_per_core_lte", None)
        self.cpu_hz_per_core_not = kwargs.get("cpu_hz_per_core_not", None)
        self.cpu_hz_per_core_not_in = kwargs.get("cpu_hz_per_core_not_in", None)
        self.cpu_model = kwargs.get("cpu_model", None)
        self.cpu_model_contains = kwargs.get("cpu_model_contains", None)
        self.cpu_model_ends_with = kwargs.get("cpu_model_ends_with", None)
        self.cpu_model_gt = kwargs.get("cpu_model_gt", None)
        self.cpu_model_gte = kwargs.get("cpu_model_gte", None)
        self.cpu_model_in = kwargs.get("cpu_model_in", None)
        self.cpu_model_lt = kwargs.get("cpu_model_lt", None)
        self.cpu_model_lte = kwargs.get("cpu_model_lte", None)
        self.cpu_model_not = kwargs.get("cpu_model_not", None)
        self.cpu_model_not_contains = kwargs.get("cpu_model_not_contains", None)
        self.cpu_model_not_ends_with = kwargs.get("cpu_model_not_ends_with", None)
        self.cpu_model_not_in = kwargs.get("cpu_model_not_in", None)
        self.cpu_model_not_starts_with = kwargs.get("cpu_model_not_starts_with", None)
        self.cpu_model_starts_with = kwargs.get("cpu_model_starts_with", None)
        self.cpu_vendor = kwargs.get("cpu_vendor", None)
        self.cpu_vendor_contains = kwargs.get("cpu_vendor_contains", None)
        self.cpu_vendor_ends_with = kwargs.get("cpu_vendor_ends_with", None)
        self.cpu_vendor_gt = kwargs.get("cpu_vendor_gt", None)
        self.cpu_vendor_gte = kwargs.get("cpu_vendor_gte", None)
        self.cpu_vendor_in = kwargs.get("cpu_vendor_in", None)
        self.cpu_vendor_lt = kwargs.get("cpu_vendor_lt", None)
        self.cpu_vendor_lte = kwargs.get("cpu_vendor_lte", None)
        self.cpu_vendor_not = kwargs.get("cpu_vendor_not", None)
        self.cpu_vendor_not_contains = kwargs.get("cpu_vendor_not_contains", None)
        self.cpu_vendor_not_ends_with = kwargs.get("cpu_vendor_not_ends_with", None)
        self.cpu_vendor_not_in = kwargs.get("cpu_vendor_not_in", None)
        self.cpu_vendor_not_starts_with = kwargs.get("cpu_vendor_not_starts_with", None)
        self.cpu_vendor_starts_with = kwargs.get("cpu_vendor_starts_with", None)
        self.data_ip = kwargs.get("data_ip", None)
        self.data_ip_contains = kwargs.get("data_ip_contains", None)
        self.data_ip_ends_with = kwargs.get("data_ip_ends_with", None)
        self.data_ip_gt = kwargs.get("data_ip_gt", None)
        self.data_ip_gte = kwargs.get("data_ip_gte", None)
        self.data_ip_in = kwargs.get("data_ip_in", None)
        self.data_ip_lt = kwargs.get("data_ip_lt", None)
        self.data_ip_lte = kwargs.get("data_ip_lte", None)
        self.data_ip_not = kwargs.get("data_ip_not", None)
        self.data_ip_not_contains = kwargs.get("data_ip_not_contains", None)
        self.data_ip_not_ends_with = kwargs.get("data_ip_not_ends_with", None)
        self.data_ip_not_in = kwargs.get("data_ip_not_in", None)
        self.data_ip_not_starts_with = kwargs.get("data_ip_not_starts_with", None)
        self.data_ip_starts_with = kwargs.get("data_ip_starts_with", None)
        self.disk_pools_every = kwargs.get("disk_pools_every", None)
        self.disk_pools_none = kwargs.get("disk_pools_none", None)
        self.disk_pools_some = kwargs.get("disk_pools_some", None)
        self.disks_every = kwargs.get("disks_every", None)
        self.disks_none = kwargs.get("disks_none", None)
        self.disks_some = kwargs.get("disks_some", None)
        self.downgraded_prioritized_space = kwargs.get("downgraded_prioritized_space", None)
        self.downgraded_prioritized_space_gt = kwargs.get("downgraded_prioritized_space_gt", None)
        self.downgraded_prioritized_space_gte = kwargs.get("downgraded_prioritized_space_gte", None)
        self.downgraded_prioritized_space_in = kwargs.get("downgraded_prioritized_space_in", None)
        self.downgraded_prioritized_space_lt = kwargs.get("downgraded_prioritized_space_lt", None)
        self.downgraded_prioritized_space_lte = kwargs.get("downgraded_prioritized_space_lte", None)
        self.downgraded_prioritized_space_not = kwargs.get("downgraded_prioritized_space_not", None)
        self.downgraded_prioritized_space_not_in = kwargs.get("downgraded_prioritized_space_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.failure_data_space = kwargs.get("failure_data_space", None)
        self.failure_data_space_gt = kwargs.get("failure_data_space_gt", None)
        self.failure_data_space_gte = kwargs.get("failure_data_space_gte", None)
        self.failure_data_space_in = kwargs.get("failure_data_space_in", None)
        self.failure_data_space_lt = kwargs.get("failure_data_space_lt", None)
        self.failure_data_space_lte = kwargs.get("failure_data_space_lte", None)
        self.failure_data_space_not = kwargs.get("failure_data_space_not", None)
        self.failure_data_space_not_in = kwargs.get("failure_data_space_not_in", None)
        self.gpu_devices_every = kwargs.get("gpu_devices_every", None)
        self.gpu_devices_none = kwargs.get("gpu_devices_none", None)
        self.gpu_devices_some = kwargs.get("gpu_devices_some", None)
        self.hdd_data_capacity = kwargs.get("hdd_data_capacity", None)
        self.hdd_data_capacity_gt = kwargs.get("hdd_data_capacity_gt", None)
        self.hdd_data_capacity_gte = kwargs.get("hdd_data_capacity_gte", None)
        self.hdd_data_capacity_in = kwargs.get("hdd_data_capacity_in", None)
        self.hdd_data_capacity_lt = kwargs.get("hdd_data_capacity_lt", None)
        self.hdd_data_capacity_lte = kwargs.get("hdd_data_capacity_lte", None)
        self.hdd_data_capacity_not = kwargs.get("hdd_data_capacity_not", None)
        self.hdd_data_capacity_not_in = kwargs.get("hdd_data_capacity_not_in", None)
        self.hdd_disk_count = kwargs.get("hdd_disk_count", None)
        self.hdd_disk_count_gt = kwargs.get("hdd_disk_count_gt", None)
        self.hdd_disk_count_gte = kwargs.get("hdd_disk_count_gte", None)
        self.hdd_disk_count_in = kwargs.get("hdd_disk_count_in", None)
        self.hdd_disk_count_lt = kwargs.get("hdd_disk_count_lt", None)
        self.hdd_disk_count_lte = kwargs.get("hdd_disk_count_lte", None)
        self.hdd_disk_count_not = kwargs.get("hdd_disk_count_not", None)
        self.hdd_disk_count_not_in = kwargs.get("hdd_disk_count_not_in", None)
        self.hypervisor_ip = kwargs.get("hypervisor_ip", None)
        self.hypervisor_ip_contains = kwargs.get("hypervisor_ip_contains", None)
        self.hypervisor_ip_ends_with = kwargs.get("hypervisor_ip_ends_with", None)
        self.hypervisor_ip_gt = kwargs.get("hypervisor_ip_gt", None)
        self.hypervisor_ip_gte = kwargs.get("hypervisor_ip_gte", None)
        self.hypervisor_ip_in = kwargs.get("hypervisor_ip_in", None)
        self.hypervisor_ip_lt = kwargs.get("hypervisor_ip_lt", None)
        self.hypervisor_ip_lte = kwargs.get("hypervisor_ip_lte", None)
        self.hypervisor_ip_not = kwargs.get("hypervisor_ip_not", None)
        self.hypervisor_ip_not_contains = kwargs.get("hypervisor_ip_not_contains", None)
        self.hypervisor_ip_not_ends_with = kwargs.get("hypervisor_ip_not_ends_with", None)
        self.hypervisor_ip_not_in = kwargs.get("hypervisor_ip_not_in", None)
        self.hypervisor_ip_not_starts_with = kwargs.get("hypervisor_ip_not_starts_with", None)
        self.hypervisor_ip_starts_with = kwargs.get("hypervisor_ip_starts_with", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.iommu = kwargs.get("iommu", None)
        self.iommu_in = kwargs.get("iommu_in", None)
        self.iommu_not = kwargs.get("iommu_not", None)
        self.iommu_not_in = kwargs.get("iommu_not_in", None)
        self.ipmi = kwargs.get("ipmi", None)
        self.is_os_in_raid1 = kwargs.get("is_os_in_raid1", None)
        self.is_os_in_raid1_not = kwargs.get("is_os_in_raid1_not", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.lsm_cap_disk_safe_umount = kwargs.get("lsm_cap_disk_safe_umount", None)
        self.lsm_cap_disk_safe_umount_not = kwargs.get("lsm_cap_disk_safe_umount_not", None)
        self.management_ip = kwargs.get("management_ip", None)
        self.management_ip_contains = kwargs.get("management_ip_contains", None)
        self.management_ip_ends_with = kwargs.get("management_ip_ends_with", None)
        self.management_ip_gt = kwargs.get("management_ip_gt", None)
        self.management_ip_gte = kwargs.get("management_ip_gte", None)
        self.management_ip_in = kwargs.get("management_ip_in", None)
        self.management_ip_lt = kwargs.get("management_ip_lt", None)
        self.management_ip_lte = kwargs.get("management_ip_lte", None)
        self.management_ip_not = kwargs.get("management_ip_not", None)
        self.management_ip_not_contains = kwargs.get("management_ip_not_contains", None)
        self.management_ip_not_ends_with = kwargs.get("management_ip_not_ends_with", None)
        self.management_ip_not_in = kwargs.get("management_ip_not_in", None)
        self.management_ip_not_starts_with = kwargs.get("management_ip_not_starts_with", None)
        self.management_ip_starts_with = kwargs.get("management_ip_starts_with", None)
        self.merged_status = kwargs.get("merged_status", None)
        self.merged_status_in = kwargs.get("merged_status_in", None)
        self.merged_status_not = kwargs.get("merged_status_not", None)
        self.merged_status_not_in = kwargs.get("merged_status_not_in", None)
        self.model = kwargs.get("model", None)
        self.model_contains = kwargs.get("model_contains", None)
        self.model_ends_with = kwargs.get("model_ends_with", None)
        self.model_gt = kwargs.get("model_gt", None)
        self.model_gte = kwargs.get("model_gte", None)
        self.model_in = kwargs.get("model_in", None)
        self.model_lt = kwargs.get("model_lt", None)
        self.model_lte = kwargs.get("model_lte", None)
        self.model_not = kwargs.get("model_not", None)
        self.model_not_contains = kwargs.get("model_not_contains", None)
        self.model_not_ends_with = kwargs.get("model_not_ends_with", None)
        self.model_not_in = kwargs.get("model_not_in", None)
        self.model_not_starts_with = kwargs.get("model_not_starts_with", None)
        self.model_starts_with = kwargs.get("model_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.nested_virtualization = kwargs.get("nested_virtualization", None)
        self.nested_virtualization_not = kwargs.get("nested_virtualization_not", None)
        self.nic_count = kwargs.get("nic_count", None)
        self.nic_count_gt = kwargs.get("nic_count_gt", None)
        self.nic_count_gte = kwargs.get("nic_count_gte", None)
        self.nic_count_in = kwargs.get("nic_count_in", None)
        self.nic_count_lt = kwargs.get("nic_count_lt", None)
        self.nic_count_lte = kwargs.get("nic_count_lte", None)
        self.nic_count_not = kwargs.get("nic_count_not", None)
        self.nic_count_not_in = kwargs.get("nic_count_not_in", None)
        self.nics_every = kwargs.get("nics_every", None)
        self.nics_none = kwargs.get("nics_none", None)
        self.nics_some = kwargs.get("nics_some", None)
        self.node_topo_local_id = kwargs.get("node_topo_local_id", None)
        self.node_topo_local_id_contains = kwargs.get("node_topo_local_id_contains", None)
        self.node_topo_local_id_ends_with = kwargs.get("node_topo_local_id_ends_with", None)
        self.node_topo_local_id_gt = kwargs.get("node_topo_local_id_gt", None)
        self.node_topo_local_id_gte = kwargs.get("node_topo_local_id_gte", None)
        self.node_topo_local_id_in = kwargs.get("node_topo_local_id_in", None)
        self.node_topo_local_id_lt = kwargs.get("node_topo_local_id_lt", None)
        self.node_topo_local_id_lte = kwargs.get("node_topo_local_id_lte", None)
        self.node_topo_local_id_not = kwargs.get("node_topo_local_id_not", None)
        self.node_topo_local_id_not_contains = kwargs.get("node_topo_local_id_not_contains", None)
        self.node_topo_local_id_not_ends_with = kwargs.get("node_topo_local_id_not_ends_with", None)
        self.node_topo_local_id_not_in = kwargs.get("node_topo_local_id_not_in", None)
        self.node_topo_local_id_not_starts_with = kwargs.get("node_topo_local_id_not_starts_with", None)
        self.node_topo_local_id_starts_with = kwargs.get("node_topo_local_id_starts_with", None)
        self.os_memory_bytes = kwargs.get("os_memory_bytes", None)
        self.os_memory_bytes_gt = kwargs.get("os_memory_bytes_gt", None)
        self.os_memory_bytes_gte = kwargs.get("os_memory_bytes_gte", None)
        self.os_memory_bytes_in = kwargs.get("os_memory_bytes_in", None)
        self.os_memory_bytes_lt = kwargs.get("os_memory_bytes_lt", None)
        self.os_memory_bytes_lte = kwargs.get("os_memory_bytes_lte", None)
        self.os_memory_bytes_not = kwargs.get("os_memory_bytes_not", None)
        self.os_memory_bytes_not_in = kwargs.get("os_memory_bytes_not_in", None)
        self.os_version = kwargs.get("os_version", None)
        self.os_version_contains = kwargs.get("os_version_contains", None)
        self.os_version_ends_with = kwargs.get("os_version_ends_with", None)
        self.os_version_gt = kwargs.get("os_version_gt", None)
        self.os_version_gte = kwargs.get("os_version_gte", None)
        self.os_version_in = kwargs.get("os_version_in", None)
        self.os_version_lt = kwargs.get("os_version_lt", None)
        self.os_version_lte = kwargs.get("os_version_lte", None)
        self.os_version_not = kwargs.get("os_version_not", None)
        self.os_version_not_contains = kwargs.get("os_version_not_contains", None)
        self.os_version_not_ends_with = kwargs.get("os_version_not_ends_with", None)
        self.os_version_not_in = kwargs.get("os_version_not_in", None)
        self.os_version_not_starts_with = kwargs.get("os_version_not_starts_with", None)
        self.os_version_starts_with = kwargs.get("os_version_starts_with", None)
        self.perf_allocated_data_space = kwargs.get("perf_allocated_data_space", None)
        self.perf_allocated_data_space_gt = kwargs.get("perf_allocated_data_space_gt", None)
        self.perf_allocated_data_space_gte = kwargs.get("perf_allocated_data_space_gte", None)
        self.perf_allocated_data_space_in = kwargs.get("perf_allocated_data_space_in", None)
        self.perf_allocated_data_space_lt = kwargs.get("perf_allocated_data_space_lt", None)
        self.perf_allocated_data_space_lte = kwargs.get("perf_allocated_data_space_lte", None)
        self.perf_allocated_data_space_not = kwargs.get("perf_allocated_data_space_not", None)
        self.perf_allocated_data_space_not_in = kwargs.get("perf_allocated_data_space_not_in", None)
        self.perf_failure_data_space = kwargs.get("perf_failure_data_space", None)
        self.perf_failure_data_space_gt = kwargs.get("perf_failure_data_space_gt", None)
        self.perf_failure_data_space_gte = kwargs.get("perf_failure_data_space_gte", None)
        self.perf_failure_data_space_in = kwargs.get("perf_failure_data_space_in", None)
        self.perf_failure_data_space_lt = kwargs.get("perf_failure_data_space_lt", None)
        self.perf_failure_data_space_lte = kwargs.get("perf_failure_data_space_lte", None)
        self.perf_failure_data_space_not = kwargs.get("perf_failure_data_space_not", None)
        self.perf_failure_data_space_not_in = kwargs.get("perf_failure_data_space_not_in", None)
        self.perf_total_data_capacity = kwargs.get("perf_total_data_capacity", None)
        self.perf_total_data_capacity_gt = kwargs.get("perf_total_data_capacity_gt", None)
        self.perf_total_data_capacity_gte = kwargs.get("perf_total_data_capacity_gte", None)
        self.perf_total_data_capacity_in = kwargs.get("perf_total_data_capacity_in", None)
        self.perf_total_data_capacity_lt = kwargs.get("perf_total_data_capacity_lt", None)
        self.perf_total_data_capacity_lte = kwargs.get("perf_total_data_capacity_lte", None)
        self.perf_total_data_capacity_not = kwargs.get("perf_total_data_capacity_not", None)
        self.perf_total_data_capacity_not_in = kwargs.get("perf_total_data_capacity_not_in", None)
        self.perf_used_data_space = kwargs.get("perf_used_data_space", None)
        self.perf_used_data_space_gt = kwargs.get("perf_used_data_space_gt", None)
        self.perf_used_data_space_gte = kwargs.get("perf_used_data_space_gte", None)
        self.perf_used_data_space_in = kwargs.get("perf_used_data_space_in", None)
        self.perf_used_data_space_lt = kwargs.get("perf_used_data_space_lt", None)
        self.perf_used_data_space_lte = kwargs.get("perf_used_data_space_lte", None)
        self.perf_used_data_space_not = kwargs.get("perf_used_data_space_not", None)
        self.perf_used_data_space_not_in = kwargs.get("perf_used_data_space_not_in", None)
        self.perf_valid_data_space = kwargs.get("perf_valid_data_space", None)
        self.perf_valid_data_space_gt = kwargs.get("perf_valid_data_space_gt", None)
        self.perf_valid_data_space_gte = kwargs.get("perf_valid_data_space_gte", None)
        self.perf_valid_data_space_in = kwargs.get("perf_valid_data_space_in", None)
        self.perf_valid_data_space_lt = kwargs.get("perf_valid_data_space_lt", None)
        self.perf_valid_data_space_lte = kwargs.get("perf_valid_data_space_lte", None)
        self.perf_valid_data_space_not = kwargs.get("perf_valid_data_space_not", None)
        self.perf_valid_data_space_not_in = kwargs.get("perf_valid_data_space_not_in", None)
        self.planned_prioritized_space = kwargs.get("planned_prioritized_space", None)
        self.planned_prioritized_space_gt = kwargs.get("planned_prioritized_space_gt", None)
        self.planned_prioritized_space_gte = kwargs.get("planned_prioritized_space_gte", None)
        self.planned_prioritized_space_in = kwargs.get("planned_prioritized_space_in", None)
        self.planned_prioritized_space_lt = kwargs.get("planned_prioritized_space_lt", None)
        self.planned_prioritized_space_lte = kwargs.get("planned_prioritized_space_lte", None)
        self.planned_prioritized_space_not = kwargs.get("planned_prioritized_space_not", None)
        self.planned_prioritized_space_not_in = kwargs.get("planned_prioritized_space_not_in", None)
        self.pmem_dimm_capacity = kwargs.get("pmem_dimm_capacity", None)
        self.pmem_dimm_capacity_gt = kwargs.get("pmem_dimm_capacity_gt", None)
        self.pmem_dimm_capacity_gte = kwargs.get("pmem_dimm_capacity_gte", None)
        self.pmem_dimm_capacity_in = kwargs.get("pmem_dimm_capacity_in", None)
        self.pmem_dimm_capacity_lt = kwargs.get("pmem_dimm_capacity_lt", None)
        self.pmem_dimm_capacity_lte = kwargs.get("pmem_dimm_capacity_lte", None)
        self.pmem_dimm_capacity_not = kwargs.get("pmem_dimm_capacity_not", None)
        self.pmem_dimm_capacity_not_in = kwargs.get("pmem_dimm_capacity_not_in", None)
        self.pmem_dimm_count = kwargs.get("pmem_dimm_count", None)
        self.pmem_dimm_count_gt = kwargs.get("pmem_dimm_count_gt", None)
        self.pmem_dimm_count_gte = kwargs.get("pmem_dimm_count_gte", None)
        self.pmem_dimm_count_in = kwargs.get("pmem_dimm_count_in", None)
        self.pmem_dimm_count_lt = kwargs.get("pmem_dimm_count_lt", None)
        self.pmem_dimm_count_lte = kwargs.get("pmem_dimm_count_lte", None)
        self.pmem_dimm_count_not = kwargs.get("pmem_dimm_count_not", None)
        self.pmem_dimm_count_not_in = kwargs.get("pmem_dimm_count_not_in", None)
        self.pmem_dimms_every = kwargs.get("pmem_dimms_every", None)
        self.pmem_dimms_none = kwargs.get("pmem_dimms_none", None)
        self.pmem_dimms_some = kwargs.get("pmem_dimms_some", None)
        self.pmem_disk_count = kwargs.get("pmem_disk_count", None)
        self.pmem_disk_count_gt = kwargs.get("pmem_disk_count_gt", None)
        self.pmem_disk_count_gte = kwargs.get("pmem_disk_count_gte", None)
        self.pmem_disk_count_in = kwargs.get("pmem_disk_count_in", None)
        self.pmem_disk_count_lt = kwargs.get("pmem_disk_count_lt", None)
        self.pmem_disk_count_lte = kwargs.get("pmem_disk_count_lte", None)
        self.pmem_disk_count_not = kwargs.get("pmem_disk_count_not", None)
        self.pmem_disk_count_not_in = kwargs.get("pmem_disk_count_not_in", None)
        self.prio_space_percentage = kwargs.get("prio_space_percentage", None)
        self.prio_space_percentage_gt = kwargs.get("prio_space_percentage_gt", None)
        self.prio_space_percentage_gte = kwargs.get("prio_space_percentage_gte", None)
        self.prio_space_percentage_in = kwargs.get("prio_space_percentage_in", None)
        self.prio_space_percentage_lt = kwargs.get("prio_space_percentage_lt", None)
        self.prio_space_percentage_lte = kwargs.get("prio_space_percentage_lte", None)
        self.prio_space_percentage_not = kwargs.get("prio_space_percentage_not", None)
        self.prio_space_percentage_not_in = kwargs.get("prio_space_percentage_not_in", None)
        self.provisioned_cpu_cores = kwargs.get("provisioned_cpu_cores", None)
        self.provisioned_cpu_cores_gt = kwargs.get("provisioned_cpu_cores_gt", None)
        self.provisioned_cpu_cores_gte = kwargs.get("provisioned_cpu_cores_gte", None)
        self.provisioned_cpu_cores_in = kwargs.get("provisioned_cpu_cores_in", None)
        self.provisioned_cpu_cores_lt = kwargs.get("provisioned_cpu_cores_lt", None)
        self.provisioned_cpu_cores_lte = kwargs.get("provisioned_cpu_cores_lte", None)
        self.provisioned_cpu_cores_not = kwargs.get("provisioned_cpu_cores_not", None)
        self.provisioned_cpu_cores_not_in = kwargs.get("provisioned_cpu_cores_not_in", None)
        self.provisioned_memory_bytes = kwargs.get("provisioned_memory_bytes", None)
        self.provisioned_memory_bytes_gt = kwargs.get("provisioned_memory_bytes_gt", None)
        self.provisioned_memory_bytes_gte = kwargs.get("provisioned_memory_bytes_gte", None)
        self.provisioned_memory_bytes_in = kwargs.get("provisioned_memory_bytes_in", None)
        self.provisioned_memory_bytes_lt = kwargs.get("provisioned_memory_bytes_lt", None)
        self.provisioned_memory_bytes_lte = kwargs.get("provisioned_memory_bytes_lte", None)
        self.provisioned_memory_bytes_not = kwargs.get("provisioned_memory_bytes_not", None)
        self.provisioned_memory_bytes_not_in = kwargs.get("provisioned_memory_bytes_not_in", None)
        self.running_pause_vm_memory_bytes = kwargs.get("running_pause_vm_memory_bytes", None)
        self.running_pause_vm_memory_bytes_gt = kwargs.get("running_pause_vm_memory_bytes_gt", None)
        self.running_pause_vm_memory_bytes_gte = kwargs.get("running_pause_vm_memory_bytes_gte", None)
        self.running_pause_vm_memory_bytes_in = kwargs.get("running_pause_vm_memory_bytes_in", None)
        self.running_pause_vm_memory_bytes_lt = kwargs.get("running_pause_vm_memory_bytes_lt", None)
        self.running_pause_vm_memory_bytes_lte = kwargs.get("running_pause_vm_memory_bytes_lte", None)
        self.running_pause_vm_memory_bytes_not = kwargs.get("running_pause_vm_memory_bytes_not", None)
        self.running_pause_vm_memory_bytes_not_in = kwargs.get("running_pause_vm_memory_bytes_not_in", None)
        self.running_vm_num = kwargs.get("running_vm_num", None)
        self.running_vm_num_gt = kwargs.get("running_vm_num_gt", None)
        self.running_vm_num_gte = kwargs.get("running_vm_num_gte", None)
        self.running_vm_num_in = kwargs.get("running_vm_num_in", None)
        self.running_vm_num_lt = kwargs.get("running_vm_num_lt", None)
        self.running_vm_num_lte = kwargs.get("running_vm_num_lte", None)
        self.running_vm_num_not = kwargs.get("running_vm_num_not", None)
        self.running_vm_num_not_in = kwargs.get("running_vm_num_not_in", None)
        self.scvm_cpu = kwargs.get("scvm_cpu", None)
        self.scvm_cpu_gt = kwargs.get("scvm_cpu_gt", None)
        self.scvm_cpu_gte = kwargs.get("scvm_cpu_gte", None)
        self.scvm_cpu_in = kwargs.get("scvm_cpu_in", None)
        self.scvm_cpu_lt = kwargs.get("scvm_cpu_lt", None)
        self.scvm_cpu_lte = kwargs.get("scvm_cpu_lte", None)
        self.scvm_cpu_not = kwargs.get("scvm_cpu_not", None)
        self.scvm_cpu_not_in = kwargs.get("scvm_cpu_not_in", None)
        self.scvm_memory = kwargs.get("scvm_memory", None)
        self.scvm_memory_gt = kwargs.get("scvm_memory_gt", None)
        self.scvm_memory_gte = kwargs.get("scvm_memory_gte", None)
        self.scvm_memory_in = kwargs.get("scvm_memory_in", None)
        self.scvm_memory_lt = kwargs.get("scvm_memory_lt", None)
        self.scvm_memory_lte = kwargs.get("scvm_memory_lte", None)
        self.scvm_memory_not = kwargs.get("scvm_memory_not", None)
        self.scvm_memory_not_in = kwargs.get("scvm_memory_not_in", None)
        self.scvm_name = kwargs.get("scvm_name", None)
        self.scvm_name_contains = kwargs.get("scvm_name_contains", None)
        self.scvm_name_ends_with = kwargs.get("scvm_name_ends_with", None)
        self.scvm_name_gt = kwargs.get("scvm_name_gt", None)
        self.scvm_name_gte = kwargs.get("scvm_name_gte", None)
        self.scvm_name_in = kwargs.get("scvm_name_in", None)
        self.scvm_name_lt = kwargs.get("scvm_name_lt", None)
        self.scvm_name_lte = kwargs.get("scvm_name_lte", None)
        self.scvm_name_not = kwargs.get("scvm_name_not", None)
        self.scvm_name_not_contains = kwargs.get("scvm_name_not_contains", None)
        self.scvm_name_not_ends_with = kwargs.get("scvm_name_not_ends_with", None)
        self.scvm_name_not_in = kwargs.get("scvm_name_not_in", None)
        self.scvm_name_not_starts_with = kwargs.get("scvm_name_not_starts_with", None)
        self.scvm_name_starts_with = kwargs.get("scvm_name_starts_with", None)
        self.serial = kwargs.get("serial", None)
        self.serial_contains = kwargs.get("serial_contains", None)
        self.serial_ends_with = kwargs.get("serial_ends_with", None)
        self.serial_gt = kwargs.get("serial_gt", None)
        self.serial_gte = kwargs.get("serial_gte", None)
        self.serial_in = kwargs.get("serial_in", None)
        self.serial_lt = kwargs.get("serial_lt", None)
        self.serial_lte = kwargs.get("serial_lte", None)
        self.serial_not = kwargs.get("serial_not", None)
        self.serial_not_contains = kwargs.get("serial_not_contains", None)
        self.serial_not_ends_with = kwargs.get("serial_not_ends_with", None)
        self.serial_not_in = kwargs.get("serial_not_in", None)
        self.serial_not_starts_with = kwargs.get("serial_not_starts_with", None)
        self.serial_starts_with = kwargs.get("serial_starts_with", None)
        self.ssd_data_capacity = kwargs.get("ssd_data_capacity", None)
        self.ssd_data_capacity_gt = kwargs.get("ssd_data_capacity_gt", None)
        self.ssd_data_capacity_gte = kwargs.get("ssd_data_capacity_gte", None)
        self.ssd_data_capacity_in = kwargs.get("ssd_data_capacity_in", None)
        self.ssd_data_capacity_lt = kwargs.get("ssd_data_capacity_lt", None)
        self.ssd_data_capacity_lte = kwargs.get("ssd_data_capacity_lte", None)
        self.ssd_data_capacity_not = kwargs.get("ssd_data_capacity_not", None)
        self.ssd_data_capacity_not_in = kwargs.get("ssd_data_capacity_not_in", None)
        self.ssd_disk_count = kwargs.get("ssd_disk_count", None)
        self.ssd_disk_count_gt = kwargs.get("ssd_disk_count_gt", None)
        self.ssd_disk_count_gte = kwargs.get("ssd_disk_count_gte", None)
        self.ssd_disk_count_in = kwargs.get("ssd_disk_count_in", None)
        self.ssd_disk_count_lt = kwargs.get("ssd_disk_count_lt", None)
        self.ssd_disk_count_lte = kwargs.get("ssd_disk_count_lte", None)
        self.ssd_disk_count_not = kwargs.get("ssd_disk_count_not", None)
        self.ssd_disk_count_not_in = kwargs.get("ssd_disk_count_not_in", None)
        self.state = kwargs.get("state", None)
        self.state_in = kwargs.get("state_in", None)
        self.state_not = kwargs.get("state_not", None)
        self.state_not_in = kwargs.get("state_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.stopped_vm_num = kwargs.get("stopped_vm_num", None)
        self.stopped_vm_num_gt = kwargs.get("stopped_vm_num_gt", None)
        self.stopped_vm_num_gte = kwargs.get("stopped_vm_num_gte", None)
        self.stopped_vm_num_in = kwargs.get("stopped_vm_num_in", None)
        self.stopped_vm_num_lt = kwargs.get("stopped_vm_num_lt", None)
        self.stopped_vm_num_lte = kwargs.get("stopped_vm_num_lte", None)
        self.stopped_vm_num_not = kwargs.get("stopped_vm_num_not", None)
        self.stopped_vm_num_not_in = kwargs.get("stopped_vm_num_not_in", None)
        self.suspended_vm_num = kwargs.get("suspended_vm_num", None)
        self.suspended_vm_num_gt = kwargs.get("suspended_vm_num_gt", None)
        self.suspended_vm_num_gte = kwargs.get("suspended_vm_num_gte", None)
        self.suspended_vm_num_in = kwargs.get("suspended_vm_num_in", None)
        self.suspended_vm_num_lt = kwargs.get("suspended_vm_num_lt", None)
        self.suspended_vm_num_lte = kwargs.get("suspended_vm_num_lte", None)
        self.suspended_vm_num_not = kwargs.get("suspended_vm_num_not", None)
        self.suspended_vm_num_not_in = kwargs.get("suspended_vm_num_not_in", None)
        self.total_cache_capacity = kwargs.get("total_cache_capacity", None)
        self.total_cache_capacity_gt = kwargs.get("total_cache_capacity_gt", None)
        self.total_cache_capacity_gte = kwargs.get("total_cache_capacity_gte", None)
        self.total_cache_capacity_in = kwargs.get("total_cache_capacity_in", None)
        self.total_cache_capacity_lt = kwargs.get("total_cache_capacity_lt", None)
        self.total_cache_capacity_lte = kwargs.get("total_cache_capacity_lte", None)
        self.total_cache_capacity_not = kwargs.get("total_cache_capacity_not", None)
        self.total_cache_capacity_not_in = kwargs.get("total_cache_capacity_not_in", None)
        self.total_cpu_cores = kwargs.get("total_cpu_cores", None)
        self.total_cpu_cores_gt = kwargs.get("total_cpu_cores_gt", None)
        self.total_cpu_cores_gte = kwargs.get("total_cpu_cores_gte", None)
        self.total_cpu_cores_in = kwargs.get("total_cpu_cores_in", None)
        self.total_cpu_cores_lt = kwargs.get("total_cpu_cores_lt", None)
        self.total_cpu_cores_lte = kwargs.get("total_cpu_cores_lte", None)
        self.total_cpu_cores_not = kwargs.get("total_cpu_cores_not", None)
        self.total_cpu_cores_not_in = kwargs.get("total_cpu_cores_not_in", None)
        self.total_cpu_hz = kwargs.get("total_cpu_hz", None)
        self.total_cpu_hz_gt = kwargs.get("total_cpu_hz_gt", None)
        self.total_cpu_hz_gte = kwargs.get("total_cpu_hz_gte", None)
        self.total_cpu_hz_in = kwargs.get("total_cpu_hz_in", None)
        self.total_cpu_hz_lt = kwargs.get("total_cpu_hz_lt", None)
        self.total_cpu_hz_lte = kwargs.get("total_cpu_hz_lte", None)
        self.total_cpu_hz_not = kwargs.get("total_cpu_hz_not", None)
        self.total_cpu_hz_not_in = kwargs.get("total_cpu_hz_not_in", None)
        self.total_cpu_sockets = kwargs.get("total_cpu_sockets", None)
        self.total_cpu_sockets_gt = kwargs.get("total_cpu_sockets_gt", None)
        self.total_cpu_sockets_gte = kwargs.get("total_cpu_sockets_gte", None)
        self.total_cpu_sockets_in = kwargs.get("total_cpu_sockets_in", None)
        self.total_cpu_sockets_lt = kwargs.get("total_cpu_sockets_lt", None)
        self.total_cpu_sockets_lte = kwargs.get("total_cpu_sockets_lte", None)
        self.total_cpu_sockets_not = kwargs.get("total_cpu_sockets_not", None)
        self.total_cpu_sockets_not_in = kwargs.get("total_cpu_sockets_not_in", None)
        self.total_data_capacity = kwargs.get("total_data_capacity", None)
        self.total_data_capacity_gt = kwargs.get("total_data_capacity_gt", None)
        self.total_data_capacity_gte = kwargs.get("total_data_capacity_gte", None)
        self.total_data_capacity_in = kwargs.get("total_data_capacity_in", None)
        self.total_data_capacity_lt = kwargs.get("total_data_capacity_lt", None)
        self.total_data_capacity_lte = kwargs.get("total_data_capacity_lte", None)
        self.total_data_capacity_not = kwargs.get("total_data_capacity_not", None)
        self.total_data_capacity_not_in = kwargs.get("total_data_capacity_not_in", None)
        self.total_memory_bytes = kwargs.get("total_memory_bytes", None)
        self.total_memory_bytes_gt = kwargs.get("total_memory_bytes_gt", None)
        self.total_memory_bytes_gte = kwargs.get("total_memory_bytes_gte", None)
        self.total_memory_bytes_in = kwargs.get("total_memory_bytes_in", None)
        self.total_memory_bytes_lt = kwargs.get("total_memory_bytes_lt", None)
        self.total_memory_bytes_lte = kwargs.get("total_memory_bytes_lte", None)
        self.total_memory_bytes_not = kwargs.get("total_memory_bytes_not", None)
        self.total_memory_bytes_not_in = kwargs.get("total_memory_bytes_not_in", None)
        self.usb_devices_every = kwargs.get("usb_devices_every", None)
        self.usb_devices_none = kwargs.get("usb_devices_none", None)
        self.usb_devices_some = kwargs.get("usb_devices_some", None)
        self.used_cache_space = kwargs.get("used_cache_space", None)
        self.used_cache_space_gt = kwargs.get("used_cache_space_gt", None)
        self.used_cache_space_gte = kwargs.get("used_cache_space_gte", None)
        self.used_cache_space_in = kwargs.get("used_cache_space_in", None)
        self.used_cache_space_lt = kwargs.get("used_cache_space_lt", None)
        self.used_cache_space_lte = kwargs.get("used_cache_space_lte", None)
        self.used_cache_space_not = kwargs.get("used_cache_space_not", None)
        self.used_cache_space_not_in = kwargs.get("used_cache_space_not_in", None)
        self.used_cpu_hz = kwargs.get("used_cpu_hz", None)
        self.used_cpu_hz_gt = kwargs.get("used_cpu_hz_gt", None)
        self.used_cpu_hz_gte = kwargs.get("used_cpu_hz_gte", None)
        self.used_cpu_hz_in = kwargs.get("used_cpu_hz_in", None)
        self.used_cpu_hz_lt = kwargs.get("used_cpu_hz_lt", None)
        self.used_cpu_hz_lte = kwargs.get("used_cpu_hz_lte", None)
        self.used_cpu_hz_not = kwargs.get("used_cpu_hz_not", None)
        self.used_cpu_hz_not_in = kwargs.get("used_cpu_hz_not_in", None)
        self.used_data_space = kwargs.get("used_data_space", None)
        self.used_data_space_gt = kwargs.get("used_data_space_gt", None)
        self.used_data_space_gte = kwargs.get("used_data_space_gte", None)
        self.used_data_space_in = kwargs.get("used_data_space_in", None)
        self.used_data_space_lt = kwargs.get("used_data_space_lt", None)
        self.used_data_space_lte = kwargs.get("used_data_space_lte", None)
        self.used_data_space_not = kwargs.get("used_data_space_not", None)
        self.used_data_space_not_in = kwargs.get("used_data_space_not_in", None)
        self.used_memory_bytes = kwargs.get("used_memory_bytes", None)
        self.used_memory_bytes_gt = kwargs.get("used_memory_bytes_gt", None)
        self.used_memory_bytes_gte = kwargs.get("used_memory_bytes_gte", None)
        self.used_memory_bytes_in = kwargs.get("used_memory_bytes_in", None)
        self.used_memory_bytes_lt = kwargs.get("used_memory_bytes_lt", None)
        self.used_memory_bytes_lte = kwargs.get("used_memory_bytes_lte", None)
        self.used_memory_bytes_not = kwargs.get("used_memory_bytes_not", None)
        self.used_memory_bytes_not_in = kwargs.get("used_memory_bytes_not_in", None)
        self.valid_cache_space = kwargs.get("valid_cache_space", None)
        self.valid_cache_space_gt = kwargs.get("valid_cache_space_gt", None)
        self.valid_cache_space_gte = kwargs.get("valid_cache_space_gte", None)
        self.valid_cache_space_in = kwargs.get("valid_cache_space_in", None)
        self.valid_cache_space_lt = kwargs.get("valid_cache_space_lt", None)
        self.valid_cache_space_lte = kwargs.get("valid_cache_space_lte", None)
        self.valid_cache_space_not = kwargs.get("valid_cache_space_not", None)
        self.valid_cache_space_not_in = kwargs.get("valid_cache_space_not_in", None)
        self.valid_free_cache_space = kwargs.get("valid_free_cache_space", None)
        self.valid_free_cache_space_gt = kwargs.get("valid_free_cache_space_gt", None)
        self.valid_free_cache_space_gte = kwargs.get("valid_free_cache_space_gte", None)
        self.valid_free_cache_space_in = kwargs.get("valid_free_cache_space_in", None)
        self.valid_free_cache_space_lt = kwargs.get("valid_free_cache_space_lt", None)
        self.valid_free_cache_space_lte = kwargs.get("valid_free_cache_space_lte", None)
        self.valid_free_cache_space_not = kwargs.get("valid_free_cache_space_not", None)
        self.valid_free_cache_space_not_in = kwargs.get("valid_free_cache_space_not_in", None)
        self.vm_num = kwargs.get("vm_num", None)
        self.vm_num_gt = kwargs.get("vm_num_gt", None)
        self.vm_num_gte = kwargs.get("vm_num_gte", None)
        self.vm_num_in = kwargs.get("vm_num_in", None)
        self.vm_num_lt = kwargs.get("vm_num_lt", None)
        self.vm_num_lte = kwargs.get("vm_num_lte", None)
        self.vm_num_not = kwargs.get("vm_num_not", None)
        self.vm_num_not_in = kwargs.get("vm_num_not_in", None)
        self.vmotion_ip = kwargs.get("vmotion_ip", None)
        self.vmotion_ip_contains = kwargs.get("vmotion_ip_contains", None)
        self.vmotion_ip_ends_with = kwargs.get("vmotion_ip_ends_with", None)
        self.vmotion_ip_gt = kwargs.get("vmotion_ip_gt", None)
        self.vmotion_ip_gte = kwargs.get("vmotion_ip_gte", None)
        self.vmotion_ip_in = kwargs.get("vmotion_ip_in", None)
        self.vmotion_ip_lt = kwargs.get("vmotion_ip_lt", None)
        self.vmotion_ip_lte = kwargs.get("vmotion_ip_lte", None)
        self.vmotion_ip_not = kwargs.get("vmotion_ip_not", None)
        self.vmotion_ip_not_contains = kwargs.get("vmotion_ip_not_contains", None)
        self.vmotion_ip_not_ends_with = kwargs.get("vmotion_ip_not_ends_with", None)
        self.vmotion_ip_not_in = kwargs.get("vmotion_ip_not_in", None)
        self.vmotion_ip_not_starts_with = kwargs.get("vmotion_ip_not_starts_with", None)
        self.vmotion_ip_starts_with = kwargs.get("vmotion_ip_starts_with", None)
        self.vms_every = kwargs.get("vms_every", None)
        self.vms_none = kwargs.get("vms_none", None)
        self.vms_some = kwargs.get("vms_some", None)
        self.vsphere_esxi_account = kwargs.get("vsphere_esxi_account", None)
        self.with_faster_ssd_as_cache = kwargs.get("with_faster_ssd_as_cache", None)
        self.with_faster_ssd_as_cache_not = kwargs.get("with_faster_ssd_as_cache_not", None)
        self.zone = kwargs.get("zone", None)

    @property
    def _and(self):
        """Gets the _and of this HostWhereInput.  # noqa: E501


        :return: The _and of this HostWhereInput.  # noqa: E501
        :rtype: list[HostWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this HostWhereInput.


        :param _and: The _and of this HostWhereInput.  # noqa: E501
        :type _and: list[HostWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this HostWhereInput.  # noqa: E501


        :return: The _not of this HostWhereInput.  # noqa: E501
        :rtype: list[HostWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this HostWhereInput.


        :param _not: The _not of this HostWhereInput.  # noqa: E501
        :type _not: list[HostWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this HostWhereInput.  # noqa: E501


        :return: The _or of this HostWhereInput.  # noqa: E501
        :rtype: list[HostWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this HostWhereInput.


        :param _or: The _or of this HostWhereInput.  # noqa: E501
        :type _or: list[HostWhereInput]
        """

        self.__or = _or

    @property
    def access_ip(self):
        """Gets the access_ip of this HostWhereInput.  # noqa: E501


        :return: The access_ip of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip

    @access_ip.setter
    def access_ip(self, access_ip):
        """Sets the access_ip of this HostWhereInput.


        :param access_ip: The access_ip of this HostWhereInput.  # noqa: E501
        :type access_ip: str
        """

        self._access_ip = access_ip

    @property
    def access_ip_contains(self):
        """Gets the access_ip_contains of this HostWhereInput.  # noqa: E501


        :return: The access_ip_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_contains

    @access_ip_contains.setter
    def access_ip_contains(self, access_ip_contains):
        """Sets the access_ip_contains of this HostWhereInput.


        :param access_ip_contains: The access_ip_contains of this HostWhereInput.  # noqa: E501
        :type access_ip_contains: str
        """

        self._access_ip_contains = access_ip_contains

    @property
    def access_ip_ends_with(self):
        """Gets the access_ip_ends_with of this HostWhereInput.  # noqa: E501


        :return: The access_ip_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_ends_with

    @access_ip_ends_with.setter
    def access_ip_ends_with(self, access_ip_ends_with):
        """Sets the access_ip_ends_with of this HostWhereInput.


        :param access_ip_ends_with: The access_ip_ends_with of this HostWhereInput.  # noqa: E501
        :type access_ip_ends_with: str
        """

        self._access_ip_ends_with = access_ip_ends_with

    @property
    def access_ip_gt(self):
        """Gets the access_ip_gt of this HostWhereInput.  # noqa: E501


        :return: The access_ip_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_gt

    @access_ip_gt.setter
    def access_ip_gt(self, access_ip_gt):
        """Sets the access_ip_gt of this HostWhereInput.


        :param access_ip_gt: The access_ip_gt of this HostWhereInput.  # noqa: E501
        :type access_ip_gt: str
        """

        self._access_ip_gt = access_ip_gt

    @property
    def access_ip_gte(self):
        """Gets the access_ip_gte of this HostWhereInput.  # noqa: E501


        :return: The access_ip_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_gte

    @access_ip_gte.setter
    def access_ip_gte(self, access_ip_gte):
        """Sets the access_ip_gte of this HostWhereInput.


        :param access_ip_gte: The access_ip_gte of this HostWhereInput.  # noqa: E501
        :type access_ip_gte: str
        """

        self._access_ip_gte = access_ip_gte

    @property
    def access_ip_in(self):
        """Gets the access_ip_in of this HostWhereInput.  # noqa: E501


        :return: The access_ip_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._access_ip_in

    @access_ip_in.setter
    def access_ip_in(self, access_ip_in):
        """Sets the access_ip_in of this HostWhereInput.


        :param access_ip_in: The access_ip_in of this HostWhereInput.  # noqa: E501
        :type access_ip_in: list[str]
        """

        self._access_ip_in = access_ip_in

    @property
    def access_ip_lt(self):
        """Gets the access_ip_lt of this HostWhereInput.  # noqa: E501


        :return: The access_ip_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_lt

    @access_ip_lt.setter
    def access_ip_lt(self, access_ip_lt):
        """Sets the access_ip_lt of this HostWhereInput.


        :param access_ip_lt: The access_ip_lt of this HostWhereInput.  # noqa: E501
        :type access_ip_lt: str
        """

        self._access_ip_lt = access_ip_lt

    @property
    def access_ip_lte(self):
        """Gets the access_ip_lte of this HostWhereInput.  # noqa: E501


        :return: The access_ip_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_lte

    @access_ip_lte.setter
    def access_ip_lte(self, access_ip_lte):
        """Sets the access_ip_lte of this HostWhereInput.


        :param access_ip_lte: The access_ip_lte of this HostWhereInput.  # noqa: E501
        :type access_ip_lte: str
        """

        self._access_ip_lte = access_ip_lte

    @property
    def access_ip_not(self):
        """Gets the access_ip_not of this HostWhereInput.  # noqa: E501


        :return: The access_ip_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_not

    @access_ip_not.setter
    def access_ip_not(self, access_ip_not):
        """Sets the access_ip_not of this HostWhereInput.


        :param access_ip_not: The access_ip_not of this HostWhereInput.  # noqa: E501
        :type access_ip_not: str
        """

        self._access_ip_not = access_ip_not

    @property
    def access_ip_not_contains(self):
        """Gets the access_ip_not_contains of this HostWhereInput.  # noqa: E501


        :return: The access_ip_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_not_contains

    @access_ip_not_contains.setter
    def access_ip_not_contains(self, access_ip_not_contains):
        """Sets the access_ip_not_contains of this HostWhereInput.


        :param access_ip_not_contains: The access_ip_not_contains of this HostWhereInput.  # noqa: E501
        :type access_ip_not_contains: str
        """

        self._access_ip_not_contains = access_ip_not_contains

    @property
    def access_ip_not_ends_with(self):
        """Gets the access_ip_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The access_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_not_ends_with

    @access_ip_not_ends_with.setter
    def access_ip_not_ends_with(self, access_ip_not_ends_with):
        """Sets the access_ip_not_ends_with of this HostWhereInput.


        :param access_ip_not_ends_with: The access_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :type access_ip_not_ends_with: str
        """

        self._access_ip_not_ends_with = access_ip_not_ends_with

    @property
    def access_ip_not_in(self):
        """Gets the access_ip_not_in of this HostWhereInput.  # noqa: E501


        :return: The access_ip_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._access_ip_not_in

    @access_ip_not_in.setter
    def access_ip_not_in(self, access_ip_not_in):
        """Sets the access_ip_not_in of this HostWhereInput.


        :param access_ip_not_in: The access_ip_not_in of this HostWhereInput.  # noqa: E501
        :type access_ip_not_in: list[str]
        """

        self._access_ip_not_in = access_ip_not_in

    @property
    def access_ip_not_starts_with(self):
        """Gets the access_ip_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The access_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_not_starts_with

    @access_ip_not_starts_with.setter
    def access_ip_not_starts_with(self, access_ip_not_starts_with):
        """Sets the access_ip_not_starts_with of this HostWhereInput.


        :param access_ip_not_starts_with: The access_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :type access_ip_not_starts_with: str
        """

        self._access_ip_not_starts_with = access_ip_not_starts_with

    @property
    def access_ip_starts_with(self):
        """Gets the access_ip_starts_with of this HostWhereInput.  # noqa: E501


        :return: The access_ip_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._access_ip_starts_with

    @access_ip_starts_with.setter
    def access_ip_starts_with(self, access_ip_starts_with):
        """Sets the access_ip_starts_with of this HostWhereInput.


        :param access_ip_starts_with: The access_ip_starts_with of this HostWhereInput.  # noqa: E501
        :type access_ip_starts_with: str
        """

        self._access_ip_starts_with = access_ip_starts_with

    @property
    def allocable_cpu_cores_for_vm_exclusive(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive

    @allocable_cpu_cores_for_vm_exclusive.setter
    def allocable_cpu_cores_for_vm_exclusive(self, allocable_cpu_cores_for_vm_exclusive):
        """Sets the allocable_cpu_cores_for_vm_exclusive of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive: The allocable_cpu_cores_for_vm_exclusive of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive: int
        """

        self._allocable_cpu_cores_for_vm_exclusive = allocable_cpu_cores_for_vm_exclusive

    @property
    def allocable_cpu_cores_for_vm_exclusive_gt(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_gt of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive_gt

    @allocable_cpu_cores_for_vm_exclusive_gt.setter
    def allocable_cpu_cores_for_vm_exclusive_gt(self, allocable_cpu_cores_for_vm_exclusive_gt):
        """Sets the allocable_cpu_cores_for_vm_exclusive_gt of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_gt: The allocable_cpu_cores_for_vm_exclusive_gt of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_gt: int
        """

        self._allocable_cpu_cores_for_vm_exclusive_gt = allocable_cpu_cores_for_vm_exclusive_gt

    @property
    def allocable_cpu_cores_for_vm_exclusive_gte(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_gte of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive_gte

    @allocable_cpu_cores_for_vm_exclusive_gte.setter
    def allocable_cpu_cores_for_vm_exclusive_gte(self, allocable_cpu_cores_for_vm_exclusive_gte):
        """Sets the allocable_cpu_cores_for_vm_exclusive_gte of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_gte: The allocable_cpu_cores_for_vm_exclusive_gte of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_gte: int
        """

        self._allocable_cpu_cores_for_vm_exclusive_gte = allocable_cpu_cores_for_vm_exclusive_gte

    @property
    def allocable_cpu_cores_for_vm_exclusive_in(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_in of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocable_cpu_cores_for_vm_exclusive_in

    @allocable_cpu_cores_for_vm_exclusive_in.setter
    def allocable_cpu_cores_for_vm_exclusive_in(self, allocable_cpu_cores_for_vm_exclusive_in):
        """Sets the allocable_cpu_cores_for_vm_exclusive_in of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_in: The allocable_cpu_cores_for_vm_exclusive_in of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_in: list[int]
        """

        self._allocable_cpu_cores_for_vm_exclusive_in = allocable_cpu_cores_for_vm_exclusive_in

    @property
    def allocable_cpu_cores_for_vm_exclusive_lt(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_lt of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive_lt

    @allocable_cpu_cores_for_vm_exclusive_lt.setter
    def allocable_cpu_cores_for_vm_exclusive_lt(self, allocable_cpu_cores_for_vm_exclusive_lt):
        """Sets the allocable_cpu_cores_for_vm_exclusive_lt of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_lt: The allocable_cpu_cores_for_vm_exclusive_lt of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_lt: int
        """

        self._allocable_cpu_cores_for_vm_exclusive_lt = allocable_cpu_cores_for_vm_exclusive_lt

    @property
    def allocable_cpu_cores_for_vm_exclusive_lte(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_lte of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive_lte

    @allocable_cpu_cores_for_vm_exclusive_lte.setter
    def allocable_cpu_cores_for_vm_exclusive_lte(self, allocable_cpu_cores_for_vm_exclusive_lte):
        """Sets the allocable_cpu_cores_for_vm_exclusive_lte of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_lte: The allocable_cpu_cores_for_vm_exclusive_lte of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_lte: int
        """

        self._allocable_cpu_cores_for_vm_exclusive_lte = allocable_cpu_cores_for_vm_exclusive_lte

    @property
    def allocable_cpu_cores_for_vm_exclusive_not(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_not of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocable_cpu_cores_for_vm_exclusive_not

    @allocable_cpu_cores_for_vm_exclusive_not.setter
    def allocable_cpu_cores_for_vm_exclusive_not(self, allocable_cpu_cores_for_vm_exclusive_not):
        """Sets the allocable_cpu_cores_for_vm_exclusive_not of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_not: The allocable_cpu_cores_for_vm_exclusive_not of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_not: int
        """

        self._allocable_cpu_cores_for_vm_exclusive_not = allocable_cpu_cores_for_vm_exclusive_not

    @property
    def allocable_cpu_cores_for_vm_exclusive_not_in(self):
        """Gets the allocable_cpu_cores_for_vm_exclusive_not_in of this HostWhereInput.  # noqa: E501


        :return: The allocable_cpu_cores_for_vm_exclusive_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocable_cpu_cores_for_vm_exclusive_not_in

    @allocable_cpu_cores_for_vm_exclusive_not_in.setter
    def allocable_cpu_cores_for_vm_exclusive_not_in(self, allocable_cpu_cores_for_vm_exclusive_not_in):
        """Sets the allocable_cpu_cores_for_vm_exclusive_not_in of this HostWhereInput.


        :param allocable_cpu_cores_for_vm_exclusive_not_in: The allocable_cpu_cores_for_vm_exclusive_not_in of this HostWhereInput.  # noqa: E501
        :type allocable_cpu_cores_for_vm_exclusive_not_in: list[int]
        """

        self._allocable_cpu_cores_for_vm_exclusive_not_in = allocable_cpu_cores_for_vm_exclusive_not_in

    @property
    def allocatable_memory_bytes(self):
        """Gets the allocatable_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes

    @allocatable_memory_bytes.setter
    def allocatable_memory_bytes(self, allocatable_memory_bytes):
        """Sets the allocatable_memory_bytes of this HostWhereInput.


        :param allocatable_memory_bytes: The allocatable_memory_bytes of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes: int
        """

        self._allocatable_memory_bytes = allocatable_memory_bytes

    @property
    def allocatable_memory_bytes_gt(self):
        """Gets the allocatable_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes_gt

    @allocatable_memory_bytes_gt.setter
    def allocatable_memory_bytes_gt(self, allocatable_memory_bytes_gt):
        """Sets the allocatable_memory_bytes_gt of this HostWhereInput.


        :param allocatable_memory_bytes_gt: The allocatable_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_gt: int
        """

        self._allocatable_memory_bytes_gt = allocatable_memory_bytes_gt

    @property
    def allocatable_memory_bytes_gte(self):
        """Gets the allocatable_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes_gte

    @allocatable_memory_bytes_gte.setter
    def allocatable_memory_bytes_gte(self, allocatable_memory_bytes_gte):
        """Sets the allocatable_memory_bytes_gte of this HostWhereInput.


        :param allocatable_memory_bytes_gte: The allocatable_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_gte: int
        """

        self._allocatable_memory_bytes_gte = allocatable_memory_bytes_gte

    @property
    def allocatable_memory_bytes_in(self):
        """Gets the allocatable_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocatable_memory_bytes_in

    @allocatable_memory_bytes_in.setter
    def allocatable_memory_bytes_in(self, allocatable_memory_bytes_in):
        """Sets the allocatable_memory_bytes_in of this HostWhereInput.


        :param allocatable_memory_bytes_in: The allocatable_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_in: list[int]
        """

        self._allocatable_memory_bytes_in = allocatable_memory_bytes_in

    @property
    def allocatable_memory_bytes_lt(self):
        """Gets the allocatable_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes_lt

    @allocatable_memory_bytes_lt.setter
    def allocatable_memory_bytes_lt(self, allocatable_memory_bytes_lt):
        """Sets the allocatable_memory_bytes_lt of this HostWhereInput.


        :param allocatable_memory_bytes_lt: The allocatable_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_lt: int
        """

        self._allocatable_memory_bytes_lt = allocatable_memory_bytes_lt

    @property
    def allocatable_memory_bytes_lte(self):
        """Gets the allocatable_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes_lte

    @allocatable_memory_bytes_lte.setter
    def allocatable_memory_bytes_lte(self, allocatable_memory_bytes_lte):
        """Sets the allocatable_memory_bytes_lte of this HostWhereInput.


        :param allocatable_memory_bytes_lte: The allocatable_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_lte: int
        """

        self._allocatable_memory_bytes_lte = allocatable_memory_bytes_lte

    @property
    def allocatable_memory_bytes_not(self):
        """Gets the allocatable_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes_not

    @allocatable_memory_bytes_not.setter
    def allocatable_memory_bytes_not(self, allocatable_memory_bytes_not):
        """Sets the allocatable_memory_bytes_not of this HostWhereInput.


        :param allocatable_memory_bytes_not: The allocatable_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_not: int
        """

        self._allocatable_memory_bytes_not = allocatable_memory_bytes_not

    @property
    def allocatable_memory_bytes_not_in(self):
        """Gets the allocatable_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The allocatable_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocatable_memory_bytes_not_in

    @allocatable_memory_bytes_not_in.setter
    def allocatable_memory_bytes_not_in(self, allocatable_memory_bytes_not_in):
        """Sets the allocatable_memory_bytes_not_in of this HostWhereInput.


        :param allocatable_memory_bytes_not_in: The allocatable_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type allocatable_memory_bytes_not_in: list[int]
        """

        self._allocatable_memory_bytes_not_in = allocatable_memory_bytes_not_in

    @property
    def allocated_prioritized_space(self):
        """Gets the allocated_prioritized_space of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space

    @allocated_prioritized_space.setter
    def allocated_prioritized_space(self, allocated_prioritized_space):
        """Sets the allocated_prioritized_space of this HostWhereInput.


        :param allocated_prioritized_space: The allocated_prioritized_space of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space: int
        """

        self._allocated_prioritized_space = allocated_prioritized_space

    @property
    def allocated_prioritized_space_gt(self):
        """Gets the allocated_prioritized_space_gt of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space_gt

    @allocated_prioritized_space_gt.setter
    def allocated_prioritized_space_gt(self, allocated_prioritized_space_gt):
        """Sets the allocated_prioritized_space_gt of this HostWhereInput.


        :param allocated_prioritized_space_gt: The allocated_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_gt: int
        """

        self._allocated_prioritized_space_gt = allocated_prioritized_space_gt

    @property
    def allocated_prioritized_space_gte(self):
        """Gets the allocated_prioritized_space_gte of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space_gte

    @allocated_prioritized_space_gte.setter
    def allocated_prioritized_space_gte(self, allocated_prioritized_space_gte):
        """Sets the allocated_prioritized_space_gte of this HostWhereInput.


        :param allocated_prioritized_space_gte: The allocated_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_gte: int
        """

        self._allocated_prioritized_space_gte = allocated_prioritized_space_gte

    @property
    def allocated_prioritized_space_in(self):
        """Gets the allocated_prioritized_space_in of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocated_prioritized_space_in

    @allocated_prioritized_space_in.setter
    def allocated_prioritized_space_in(self, allocated_prioritized_space_in):
        """Sets the allocated_prioritized_space_in of this HostWhereInput.


        :param allocated_prioritized_space_in: The allocated_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_in: list[int]
        """

        self._allocated_prioritized_space_in = allocated_prioritized_space_in

    @property
    def allocated_prioritized_space_lt(self):
        """Gets the allocated_prioritized_space_lt of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space_lt

    @allocated_prioritized_space_lt.setter
    def allocated_prioritized_space_lt(self, allocated_prioritized_space_lt):
        """Sets the allocated_prioritized_space_lt of this HostWhereInput.


        :param allocated_prioritized_space_lt: The allocated_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_lt: int
        """

        self._allocated_prioritized_space_lt = allocated_prioritized_space_lt

    @property
    def allocated_prioritized_space_lte(self):
        """Gets the allocated_prioritized_space_lte of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space_lte

    @allocated_prioritized_space_lte.setter
    def allocated_prioritized_space_lte(self, allocated_prioritized_space_lte):
        """Sets the allocated_prioritized_space_lte of this HostWhereInput.


        :param allocated_prioritized_space_lte: The allocated_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_lte: int
        """

        self._allocated_prioritized_space_lte = allocated_prioritized_space_lte

    @property
    def allocated_prioritized_space_not(self):
        """Gets the allocated_prioritized_space_not of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space_not

    @allocated_prioritized_space_not.setter
    def allocated_prioritized_space_not(self, allocated_prioritized_space_not):
        """Sets the allocated_prioritized_space_not of this HostWhereInput.


        :param allocated_prioritized_space_not: The allocated_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_not: int
        """

        self._allocated_prioritized_space_not = allocated_prioritized_space_not

    @property
    def allocated_prioritized_space_not_in(self):
        """Gets the allocated_prioritized_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._allocated_prioritized_space_not_in

    @allocated_prioritized_space_not_in.setter
    def allocated_prioritized_space_not_in(self, allocated_prioritized_space_not_in):
        """Sets the allocated_prioritized_space_not_in of this HostWhereInput.


        :param allocated_prioritized_space_not_in: The allocated_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_not_in: list[int]
        """

        self._allocated_prioritized_space_not_in = allocated_prioritized_space_not_in

    @property
    def allocated_prioritized_space_usage(self):
        """Gets the allocated_prioritized_space_usage of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage

    @allocated_prioritized_space_usage.setter
    def allocated_prioritized_space_usage(self, allocated_prioritized_space_usage):
        """Sets the allocated_prioritized_space_usage of this HostWhereInput.


        :param allocated_prioritized_space_usage: The allocated_prioritized_space_usage of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage: float
        """

        self._allocated_prioritized_space_usage = allocated_prioritized_space_usage

    @property
    def allocated_prioritized_space_usage_gt(self):
        """Gets the allocated_prioritized_space_usage_gt of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_gt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage_gt

    @allocated_prioritized_space_usage_gt.setter
    def allocated_prioritized_space_usage_gt(self, allocated_prioritized_space_usage_gt):
        """Sets the allocated_prioritized_space_usage_gt of this HostWhereInput.


        :param allocated_prioritized_space_usage_gt: The allocated_prioritized_space_usage_gt of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_gt: float
        """

        self._allocated_prioritized_space_usage_gt = allocated_prioritized_space_usage_gt

    @property
    def allocated_prioritized_space_usage_gte(self):
        """Gets the allocated_prioritized_space_usage_gte of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_gte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage_gte

    @allocated_prioritized_space_usage_gte.setter
    def allocated_prioritized_space_usage_gte(self, allocated_prioritized_space_usage_gte):
        """Sets the allocated_prioritized_space_usage_gte of this HostWhereInput.


        :param allocated_prioritized_space_usage_gte: The allocated_prioritized_space_usage_gte of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_gte: float
        """

        self._allocated_prioritized_space_usage_gte = allocated_prioritized_space_usage_gte

    @property
    def allocated_prioritized_space_usage_in(self):
        """Gets the allocated_prioritized_space_usage_in of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._allocated_prioritized_space_usage_in

    @allocated_prioritized_space_usage_in.setter
    def allocated_prioritized_space_usage_in(self, allocated_prioritized_space_usage_in):
        """Sets the allocated_prioritized_space_usage_in of this HostWhereInput.


        :param allocated_prioritized_space_usage_in: The allocated_prioritized_space_usage_in of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_in: list[float]
        """

        self._allocated_prioritized_space_usage_in = allocated_prioritized_space_usage_in

    @property
    def allocated_prioritized_space_usage_lt(self):
        """Gets the allocated_prioritized_space_usage_lt of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_lt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage_lt

    @allocated_prioritized_space_usage_lt.setter
    def allocated_prioritized_space_usage_lt(self, allocated_prioritized_space_usage_lt):
        """Sets the allocated_prioritized_space_usage_lt of this HostWhereInput.


        :param allocated_prioritized_space_usage_lt: The allocated_prioritized_space_usage_lt of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_lt: float
        """

        self._allocated_prioritized_space_usage_lt = allocated_prioritized_space_usage_lt

    @property
    def allocated_prioritized_space_usage_lte(self):
        """Gets the allocated_prioritized_space_usage_lte of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_lte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage_lte

    @allocated_prioritized_space_usage_lte.setter
    def allocated_prioritized_space_usage_lte(self, allocated_prioritized_space_usage_lte):
        """Sets the allocated_prioritized_space_usage_lte of this HostWhereInput.


        :param allocated_prioritized_space_usage_lte: The allocated_prioritized_space_usage_lte of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_lte: float
        """

        self._allocated_prioritized_space_usage_lte = allocated_prioritized_space_usage_lte

    @property
    def allocated_prioritized_space_usage_not(self):
        """Gets the allocated_prioritized_space_usage_not of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_not of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage_not

    @allocated_prioritized_space_usage_not.setter
    def allocated_prioritized_space_usage_not(self, allocated_prioritized_space_usage_not):
        """Sets the allocated_prioritized_space_usage_not of this HostWhereInput.


        :param allocated_prioritized_space_usage_not: The allocated_prioritized_space_usage_not of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_not: float
        """

        self._allocated_prioritized_space_usage_not = allocated_prioritized_space_usage_not

    @property
    def allocated_prioritized_space_usage_not_in(self):
        """Gets the allocated_prioritized_space_usage_not_in of this HostWhereInput.  # noqa: E501


        :return: The allocated_prioritized_space_usage_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._allocated_prioritized_space_usage_not_in

    @allocated_prioritized_space_usage_not_in.setter
    def allocated_prioritized_space_usage_not_in(self, allocated_prioritized_space_usage_not_in):
        """Sets the allocated_prioritized_space_usage_not_in of this HostWhereInput.


        :param allocated_prioritized_space_usage_not_in: The allocated_prioritized_space_usage_not_in of this HostWhereInput.  # noqa: E501
        :type allocated_prioritized_space_usage_not_in: list[float]
        """

        self._allocated_prioritized_space_usage_not_in = allocated_prioritized_space_usage_not_in

    @property
    def chunk_id(self):
        """Gets the chunk_id of this HostWhereInput.  # noqa: E501


        :return: The chunk_id of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id

    @chunk_id.setter
    def chunk_id(self, chunk_id):
        """Sets the chunk_id of this HostWhereInput.


        :param chunk_id: The chunk_id of this HostWhereInput.  # noqa: E501
        :type chunk_id: str
        """

        self._chunk_id = chunk_id

    @property
    def chunk_id_contains(self):
        """Gets the chunk_id_contains of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_contains

    @chunk_id_contains.setter
    def chunk_id_contains(self, chunk_id_contains):
        """Sets the chunk_id_contains of this HostWhereInput.


        :param chunk_id_contains: The chunk_id_contains of this HostWhereInput.  # noqa: E501
        :type chunk_id_contains: str
        """

        self._chunk_id_contains = chunk_id_contains

    @property
    def chunk_id_ends_with(self):
        """Gets the chunk_id_ends_with of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_ends_with

    @chunk_id_ends_with.setter
    def chunk_id_ends_with(self, chunk_id_ends_with):
        """Sets the chunk_id_ends_with of this HostWhereInput.


        :param chunk_id_ends_with: The chunk_id_ends_with of this HostWhereInput.  # noqa: E501
        :type chunk_id_ends_with: str
        """

        self._chunk_id_ends_with = chunk_id_ends_with

    @property
    def chunk_id_gt(self):
        """Gets the chunk_id_gt of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_gt

    @chunk_id_gt.setter
    def chunk_id_gt(self, chunk_id_gt):
        """Sets the chunk_id_gt of this HostWhereInput.


        :param chunk_id_gt: The chunk_id_gt of this HostWhereInput.  # noqa: E501
        :type chunk_id_gt: str
        """

        self._chunk_id_gt = chunk_id_gt

    @property
    def chunk_id_gte(self):
        """Gets the chunk_id_gte of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_gte

    @chunk_id_gte.setter
    def chunk_id_gte(self, chunk_id_gte):
        """Sets the chunk_id_gte of this HostWhereInput.


        :param chunk_id_gte: The chunk_id_gte of this HostWhereInput.  # noqa: E501
        :type chunk_id_gte: str
        """

        self._chunk_id_gte = chunk_id_gte

    @property
    def chunk_id_in(self):
        """Gets the chunk_id_in of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._chunk_id_in

    @chunk_id_in.setter
    def chunk_id_in(self, chunk_id_in):
        """Sets the chunk_id_in of this HostWhereInput.


        :param chunk_id_in: The chunk_id_in of this HostWhereInput.  # noqa: E501
        :type chunk_id_in: list[str]
        """

        self._chunk_id_in = chunk_id_in

    @property
    def chunk_id_lt(self):
        """Gets the chunk_id_lt of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_lt

    @chunk_id_lt.setter
    def chunk_id_lt(self, chunk_id_lt):
        """Sets the chunk_id_lt of this HostWhereInput.


        :param chunk_id_lt: The chunk_id_lt of this HostWhereInput.  # noqa: E501
        :type chunk_id_lt: str
        """

        self._chunk_id_lt = chunk_id_lt

    @property
    def chunk_id_lte(self):
        """Gets the chunk_id_lte of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_lte

    @chunk_id_lte.setter
    def chunk_id_lte(self, chunk_id_lte):
        """Sets the chunk_id_lte of this HostWhereInput.


        :param chunk_id_lte: The chunk_id_lte of this HostWhereInput.  # noqa: E501
        :type chunk_id_lte: str
        """

        self._chunk_id_lte = chunk_id_lte

    @property
    def chunk_id_not(self):
        """Gets the chunk_id_not of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_not

    @chunk_id_not.setter
    def chunk_id_not(self, chunk_id_not):
        """Sets the chunk_id_not of this HostWhereInput.


        :param chunk_id_not: The chunk_id_not of this HostWhereInput.  # noqa: E501
        :type chunk_id_not: str
        """

        self._chunk_id_not = chunk_id_not

    @property
    def chunk_id_not_contains(self):
        """Gets the chunk_id_not_contains of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_not_contains

    @chunk_id_not_contains.setter
    def chunk_id_not_contains(self, chunk_id_not_contains):
        """Sets the chunk_id_not_contains of this HostWhereInput.


        :param chunk_id_not_contains: The chunk_id_not_contains of this HostWhereInput.  # noqa: E501
        :type chunk_id_not_contains: str
        """

        self._chunk_id_not_contains = chunk_id_not_contains

    @property
    def chunk_id_not_ends_with(self):
        """Gets the chunk_id_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_not_ends_with

    @chunk_id_not_ends_with.setter
    def chunk_id_not_ends_with(self, chunk_id_not_ends_with):
        """Sets the chunk_id_not_ends_with of this HostWhereInput.


        :param chunk_id_not_ends_with: The chunk_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :type chunk_id_not_ends_with: str
        """

        self._chunk_id_not_ends_with = chunk_id_not_ends_with

    @property
    def chunk_id_not_in(self):
        """Gets the chunk_id_not_in of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._chunk_id_not_in

    @chunk_id_not_in.setter
    def chunk_id_not_in(self, chunk_id_not_in):
        """Sets the chunk_id_not_in of this HostWhereInput.


        :param chunk_id_not_in: The chunk_id_not_in of this HostWhereInput.  # noqa: E501
        :type chunk_id_not_in: list[str]
        """

        self._chunk_id_not_in = chunk_id_not_in

    @property
    def chunk_id_not_starts_with(self):
        """Gets the chunk_id_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_not_starts_with

    @chunk_id_not_starts_with.setter
    def chunk_id_not_starts_with(self, chunk_id_not_starts_with):
        """Sets the chunk_id_not_starts_with of this HostWhereInput.


        :param chunk_id_not_starts_with: The chunk_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :type chunk_id_not_starts_with: str
        """

        self._chunk_id_not_starts_with = chunk_id_not_starts_with

    @property
    def chunk_id_starts_with(self):
        """Gets the chunk_id_starts_with of this HostWhereInput.  # noqa: E501


        :return: The chunk_id_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id_starts_with

    @chunk_id_starts_with.setter
    def chunk_id_starts_with(self, chunk_id_starts_with):
        """Sets the chunk_id_starts_with of this HostWhereInput.


        :param chunk_id_starts_with: The chunk_id_starts_with of this HostWhereInput.  # noqa: E501
        :type chunk_id_starts_with: str
        """

        self._chunk_id_starts_with = chunk_id_starts_with

    @property
    def cluster(self):
        """Gets the cluster of this HostWhereInput.  # noqa: E501


        :return: The cluster of this HostWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this HostWhereInput.


        :param cluster: The cluster of this HostWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def commited_memory_bytes(self):
        """Gets the commited_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes

    @commited_memory_bytes.setter
    def commited_memory_bytes(self, commited_memory_bytes):
        """Sets the commited_memory_bytes of this HostWhereInput.


        :param commited_memory_bytes: The commited_memory_bytes of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes: int
        """

        self._commited_memory_bytes = commited_memory_bytes

    @property
    def commited_memory_bytes_gt(self):
        """Gets the commited_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes_gt

    @commited_memory_bytes_gt.setter
    def commited_memory_bytes_gt(self, commited_memory_bytes_gt):
        """Sets the commited_memory_bytes_gt of this HostWhereInput.


        :param commited_memory_bytes_gt: The commited_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_gt: int
        """

        self._commited_memory_bytes_gt = commited_memory_bytes_gt

    @property
    def commited_memory_bytes_gte(self):
        """Gets the commited_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes_gte

    @commited_memory_bytes_gte.setter
    def commited_memory_bytes_gte(self, commited_memory_bytes_gte):
        """Sets the commited_memory_bytes_gte of this HostWhereInput.


        :param commited_memory_bytes_gte: The commited_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_gte: int
        """

        self._commited_memory_bytes_gte = commited_memory_bytes_gte

    @property
    def commited_memory_bytes_in(self):
        """Gets the commited_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._commited_memory_bytes_in

    @commited_memory_bytes_in.setter
    def commited_memory_bytes_in(self, commited_memory_bytes_in):
        """Sets the commited_memory_bytes_in of this HostWhereInput.


        :param commited_memory_bytes_in: The commited_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_in: list[int]
        """

        self._commited_memory_bytes_in = commited_memory_bytes_in

    @property
    def commited_memory_bytes_lt(self):
        """Gets the commited_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes_lt

    @commited_memory_bytes_lt.setter
    def commited_memory_bytes_lt(self, commited_memory_bytes_lt):
        """Sets the commited_memory_bytes_lt of this HostWhereInput.


        :param commited_memory_bytes_lt: The commited_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_lt: int
        """

        self._commited_memory_bytes_lt = commited_memory_bytes_lt

    @property
    def commited_memory_bytes_lte(self):
        """Gets the commited_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes_lte

    @commited_memory_bytes_lte.setter
    def commited_memory_bytes_lte(self, commited_memory_bytes_lte):
        """Sets the commited_memory_bytes_lte of this HostWhereInput.


        :param commited_memory_bytes_lte: The commited_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_lte: int
        """

        self._commited_memory_bytes_lte = commited_memory_bytes_lte

    @property
    def commited_memory_bytes_not(self):
        """Gets the commited_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._commited_memory_bytes_not

    @commited_memory_bytes_not.setter
    def commited_memory_bytes_not(self, commited_memory_bytes_not):
        """Sets the commited_memory_bytes_not of this HostWhereInput.


        :param commited_memory_bytes_not: The commited_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_not: int
        """

        self._commited_memory_bytes_not = commited_memory_bytes_not

    @property
    def commited_memory_bytes_not_in(self):
        """Gets the commited_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The commited_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._commited_memory_bytes_not_in

    @commited_memory_bytes_not_in.setter
    def commited_memory_bytes_not_in(self, commited_memory_bytes_not_in):
        """Sets the commited_memory_bytes_not_in of this HostWhereInput.


        :param commited_memory_bytes_not_in: The commited_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type commited_memory_bytes_not_in: list[int]
        """

        self._commited_memory_bytes_not_in = commited_memory_bytes_not_in

    @property
    def connect_status(self):
        """Gets the connect_status of this HostWhereInput.  # noqa: E501


        :return: The connect_status of this HostWhereInput.  # noqa: E501
        :rtype: HostConnectStatus
        """
        return self._connect_status

    @connect_status.setter
    def connect_status(self, connect_status):
        """Sets the connect_status of this HostWhereInput.


        :param connect_status: The connect_status of this HostWhereInput.  # noqa: E501
        :type connect_status: HostConnectStatus
        """

        self._connect_status = connect_status

    @property
    def connect_status_in(self):
        """Gets the connect_status_in of this HostWhereInput.  # noqa: E501


        :return: The connect_status_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostConnectStatus]
        """
        return self._connect_status_in

    @connect_status_in.setter
    def connect_status_in(self, connect_status_in):
        """Sets the connect_status_in of this HostWhereInput.


        :param connect_status_in: The connect_status_in of this HostWhereInput.  # noqa: E501
        :type connect_status_in: list[HostConnectStatus]
        """

        self._connect_status_in = connect_status_in

    @property
    def connect_status_not(self):
        """Gets the connect_status_not of this HostWhereInput.  # noqa: E501


        :return: The connect_status_not of this HostWhereInput.  # noqa: E501
        :rtype: HostConnectStatus
        """
        return self._connect_status_not

    @connect_status_not.setter
    def connect_status_not(self, connect_status_not):
        """Sets the connect_status_not of this HostWhereInput.


        :param connect_status_not: The connect_status_not of this HostWhereInput.  # noqa: E501
        :type connect_status_not: HostConnectStatus
        """

        self._connect_status_not = connect_status_not

    @property
    def connect_status_not_in(self):
        """Gets the connect_status_not_in of this HostWhereInput.  # noqa: E501


        :return: The connect_status_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostConnectStatus]
        """
        return self._connect_status_not_in

    @connect_status_not_in.setter
    def connect_status_not_in(self, connect_status_not_in):
        """Sets the connect_status_not_in of this HostWhereInput.


        :param connect_status_not_in: The connect_status_not_in of this HostWhereInput.  # noqa: E501
        :type connect_status_not_in: list[HostConnectStatus]
        """

        self._connect_status_not_in = connect_status_not_in

    @property
    def cpu_brand(self):
        """Gets the cpu_brand of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand

    @cpu_brand.setter
    def cpu_brand(self, cpu_brand):
        """Sets the cpu_brand of this HostWhereInput.


        :param cpu_brand: The cpu_brand of this HostWhereInput.  # noqa: E501
        :type cpu_brand: str
        """

        self._cpu_brand = cpu_brand

    @property
    def cpu_brand_contains(self):
        """Gets the cpu_brand_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_contains

    @cpu_brand_contains.setter
    def cpu_brand_contains(self, cpu_brand_contains):
        """Sets the cpu_brand_contains of this HostWhereInput.


        :param cpu_brand_contains: The cpu_brand_contains of this HostWhereInput.  # noqa: E501
        :type cpu_brand_contains: str
        """

        self._cpu_brand_contains = cpu_brand_contains

    @property
    def cpu_brand_ends_with(self):
        """Gets the cpu_brand_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_ends_with

    @cpu_brand_ends_with.setter
    def cpu_brand_ends_with(self, cpu_brand_ends_with):
        """Sets the cpu_brand_ends_with of this HostWhereInput.


        :param cpu_brand_ends_with: The cpu_brand_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_brand_ends_with: str
        """

        self._cpu_brand_ends_with = cpu_brand_ends_with

    @property
    def cpu_brand_gt(self):
        """Gets the cpu_brand_gt of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_gt

    @cpu_brand_gt.setter
    def cpu_brand_gt(self, cpu_brand_gt):
        """Sets the cpu_brand_gt of this HostWhereInput.


        :param cpu_brand_gt: The cpu_brand_gt of this HostWhereInput.  # noqa: E501
        :type cpu_brand_gt: str
        """

        self._cpu_brand_gt = cpu_brand_gt

    @property
    def cpu_brand_gte(self):
        """Gets the cpu_brand_gte of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_gte

    @cpu_brand_gte.setter
    def cpu_brand_gte(self, cpu_brand_gte):
        """Sets the cpu_brand_gte of this HostWhereInput.


        :param cpu_brand_gte: The cpu_brand_gte of this HostWhereInput.  # noqa: E501
        :type cpu_brand_gte: str
        """

        self._cpu_brand_gte = cpu_brand_gte

    @property
    def cpu_brand_in(self):
        """Gets the cpu_brand_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_brand_in

    @cpu_brand_in.setter
    def cpu_brand_in(self, cpu_brand_in):
        """Sets the cpu_brand_in of this HostWhereInput.


        :param cpu_brand_in: The cpu_brand_in of this HostWhereInput.  # noqa: E501
        :type cpu_brand_in: list[str]
        """

        self._cpu_brand_in = cpu_brand_in

    @property
    def cpu_brand_lt(self):
        """Gets the cpu_brand_lt of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_lt

    @cpu_brand_lt.setter
    def cpu_brand_lt(self, cpu_brand_lt):
        """Sets the cpu_brand_lt of this HostWhereInput.


        :param cpu_brand_lt: The cpu_brand_lt of this HostWhereInput.  # noqa: E501
        :type cpu_brand_lt: str
        """

        self._cpu_brand_lt = cpu_brand_lt

    @property
    def cpu_brand_lte(self):
        """Gets the cpu_brand_lte of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_lte

    @cpu_brand_lte.setter
    def cpu_brand_lte(self, cpu_brand_lte):
        """Sets the cpu_brand_lte of this HostWhereInput.


        :param cpu_brand_lte: The cpu_brand_lte of this HostWhereInput.  # noqa: E501
        :type cpu_brand_lte: str
        """

        self._cpu_brand_lte = cpu_brand_lte

    @property
    def cpu_brand_not(self):
        """Gets the cpu_brand_not of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_not

    @cpu_brand_not.setter
    def cpu_brand_not(self, cpu_brand_not):
        """Sets the cpu_brand_not of this HostWhereInput.


        :param cpu_brand_not: The cpu_brand_not of this HostWhereInput.  # noqa: E501
        :type cpu_brand_not: str
        """

        self._cpu_brand_not = cpu_brand_not

    @property
    def cpu_brand_not_contains(self):
        """Gets the cpu_brand_not_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_not_contains

    @cpu_brand_not_contains.setter
    def cpu_brand_not_contains(self, cpu_brand_not_contains):
        """Sets the cpu_brand_not_contains of this HostWhereInput.


        :param cpu_brand_not_contains: The cpu_brand_not_contains of this HostWhereInput.  # noqa: E501
        :type cpu_brand_not_contains: str
        """

        self._cpu_brand_not_contains = cpu_brand_not_contains

    @property
    def cpu_brand_not_ends_with(self):
        """Gets the cpu_brand_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_not_ends_with

    @cpu_brand_not_ends_with.setter
    def cpu_brand_not_ends_with(self, cpu_brand_not_ends_with):
        """Sets the cpu_brand_not_ends_with of this HostWhereInput.


        :param cpu_brand_not_ends_with: The cpu_brand_not_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_brand_not_ends_with: str
        """

        self._cpu_brand_not_ends_with = cpu_brand_not_ends_with

    @property
    def cpu_brand_not_in(self):
        """Gets the cpu_brand_not_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_brand_not_in

    @cpu_brand_not_in.setter
    def cpu_brand_not_in(self, cpu_brand_not_in):
        """Sets the cpu_brand_not_in of this HostWhereInput.


        :param cpu_brand_not_in: The cpu_brand_not_in of this HostWhereInput.  # noqa: E501
        :type cpu_brand_not_in: list[str]
        """

        self._cpu_brand_not_in = cpu_brand_not_in

    @property
    def cpu_brand_not_starts_with(self):
        """Gets the cpu_brand_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_not_starts_with

    @cpu_brand_not_starts_with.setter
    def cpu_brand_not_starts_with(self, cpu_brand_not_starts_with):
        """Sets the cpu_brand_not_starts_with of this HostWhereInput.


        :param cpu_brand_not_starts_with: The cpu_brand_not_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_brand_not_starts_with: str
        """

        self._cpu_brand_not_starts_with = cpu_brand_not_starts_with

    @property
    def cpu_brand_starts_with(self):
        """Gets the cpu_brand_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_brand_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand_starts_with

    @cpu_brand_starts_with.setter
    def cpu_brand_starts_with(self, cpu_brand_starts_with):
        """Sets the cpu_brand_starts_with of this HostWhereInput.


        :param cpu_brand_starts_with: The cpu_brand_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_brand_starts_with: str
        """

        self._cpu_brand_starts_with = cpu_brand_starts_with

    @property
    def cpu_fan_speed_unit(self):
        """Gets the cpu_fan_speed_unit of this HostWhereInput.  # noqa: E501


        :return: The cpu_fan_speed_unit of this HostWhereInput.  # noqa: E501
        :rtype: CpuFanSpeedUnit
        """
        return self._cpu_fan_speed_unit

    @cpu_fan_speed_unit.setter
    def cpu_fan_speed_unit(self, cpu_fan_speed_unit):
        """Sets the cpu_fan_speed_unit of this HostWhereInput.


        :param cpu_fan_speed_unit: The cpu_fan_speed_unit of this HostWhereInput.  # noqa: E501
        :type cpu_fan_speed_unit: CpuFanSpeedUnit
        """

        self._cpu_fan_speed_unit = cpu_fan_speed_unit

    @property
    def cpu_fan_speed_unit_in(self):
        """Gets the cpu_fan_speed_unit_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_fan_speed_unit_in of this HostWhereInput.  # noqa: E501
        :rtype: list[CpuFanSpeedUnit]
        """
        return self._cpu_fan_speed_unit_in

    @cpu_fan_speed_unit_in.setter
    def cpu_fan_speed_unit_in(self, cpu_fan_speed_unit_in):
        """Sets the cpu_fan_speed_unit_in of this HostWhereInput.


        :param cpu_fan_speed_unit_in: The cpu_fan_speed_unit_in of this HostWhereInput.  # noqa: E501
        :type cpu_fan_speed_unit_in: list[CpuFanSpeedUnit]
        """

        self._cpu_fan_speed_unit_in = cpu_fan_speed_unit_in

    @property
    def cpu_fan_speed_unit_not(self):
        """Gets the cpu_fan_speed_unit_not of this HostWhereInput.  # noqa: E501


        :return: The cpu_fan_speed_unit_not of this HostWhereInput.  # noqa: E501
        :rtype: CpuFanSpeedUnit
        """
        return self._cpu_fan_speed_unit_not

    @cpu_fan_speed_unit_not.setter
    def cpu_fan_speed_unit_not(self, cpu_fan_speed_unit_not):
        """Sets the cpu_fan_speed_unit_not of this HostWhereInput.


        :param cpu_fan_speed_unit_not: The cpu_fan_speed_unit_not of this HostWhereInput.  # noqa: E501
        :type cpu_fan_speed_unit_not: CpuFanSpeedUnit
        """

        self._cpu_fan_speed_unit_not = cpu_fan_speed_unit_not

    @property
    def cpu_fan_speed_unit_not_in(self):
        """Gets the cpu_fan_speed_unit_not_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_fan_speed_unit_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[CpuFanSpeedUnit]
        """
        return self._cpu_fan_speed_unit_not_in

    @cpu_fan_speed_unit_not_in.setter
    def cpu_fan_speed_unit_not_in(self, cpu_fan_speed_unit_not_in):
        """Sets the cpu_fan_speed_unit_not_in of this HostWhereInput.


        :param cpu_fan_speed_unit_not_in: The cpu_fan_speed_unit_not_in of this HostWhereInput.  # noqa: E501
        :type cpu_fan_speed_unit_not_in: list[CpuFanSpeedUnit]
        """

        self._cpu_fan_speed_unit_not_in = cpu_fan_speed_unit_not_in

    @property
    def cpu_hz_per_core(self):
        """Gets the cpu_hz_per_core of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core

    @cpu_hz_per_core.setter
    def cpu_hz_per_core(self, cpu_hz_per_core):
        """Sets the cpu_hz_per_core of this HostWhereInput.


        :param cpu_hz_per_core: The cpu_hz_per_core of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core: int
        """

        self._cpu_hz_per_core = cpu_hz_per_core

    @property
    def cpu_hz_per_core_gt(self):
        """Gets the cpu_hz_per_core_gt of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_gt

    @cpu_hz_per_core_gt.setter
    def cpu_hz_per_core_gt(self, cpu_hz_per_core_gt):
        """Sets the cpu_hz_per_core_gt of this HostWhereInput.


        :param cpu_hz_per_core_gt: The cpu_hz_per_core_gt of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_gt: int
        """

        self._cpu_hz_per_core_gt = cpu_hz_per_core_gt

    @property
    def cpu_hz_per_core_gte(self):
        """Gets the cpu_hz_per_core_gte of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_gte

    @cpu_hz_per_core_gte.setter
    def cpu_hz_per_core_gte(self, cpu_hz_per_core_gte):
        """Sets the cpu_hz_per_core_gte of this HostWhereInput.


        :param cpu_hz_per_core_gte: The cpu_hz_per_core_gte of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_gte: int
        """

        self._cpu_hz_per_core_gte = cpu_hz_per_core_gte

    @property
    def cpu_hz_per_core_in(self):
        """Gets the cpu_hz_per_core_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._cpu_hz_per_core_in

    @cpu_hz_per_core_in.setter
    def cpu_hz_per_core_in(self, cpu_hz_per_core_in):
        """Sets the cpu_hz_per_core_in of this HostWhereInput.


        :param cpu_hz_per_core_in: The cpu_hz_per_core_in of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_in: list[int]
        """

        self._cpu_hz_per_core_in = cpu_hz_per_core_in

    @property
    def cpu_hz_per_core_lt(self):
        """Gets the cpu_hz_per_core_lt of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_lt

    @cpu_hz_per_core_lt.setter
    def cpu_hz_per_core_lt(self, cpu_hz_per_core_lt):
        """Sets the cpu_hz_per_core_lt of this HostWhereInput.


        :param cpu_hz_per_core_lt: The cpu_hz_per_core_lt of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_lt: int
        """

        self._cpu_hz_per_core_lt = cpu_hz_per_core_lt

    @property
    def cpu_hz_per_core_lte(self):
        """Gets the cpu_hz_per_core_lte of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_lte

    @cpu_hz_per_core_lte.setter
    def cpu_hz_per_core_lte(self, cpu_hz_per_core_lte):
        """Sets the cpu_hz_per_core_lte of this HostWhereInput.


        :param cpu_hz_per_core_lte: The cpu_hz_per_core_lte of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_lte: int
        """

        self._cpu_hz_per_core_lte = cpu_hz_per_core_lte

    @property
    def cpu_hz_per_core_not(self):
        """Gets the cpu_hz_per_core_not of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_not

    @cpu_hz_per_core_not.setter
    def cpu_hz_per_core_not(self, cpu_hz_per_core_not):
        """Sets the cpu_hz_per_core_not of this HostWhereInput.


        :param cpu_hz_per_core_not: The cpu_hz_per_core_not of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_not: int
        """

        self._cpu_hz_per_core_not = cpu_hz_per_core_not

    @property
    def cpu_hz_per_core_not_in(self):
        """Gets the cpu_hz_per_core_not_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._cpu_hz_per_core_not_in

    @cpu_hz_per_core_not_in.setter
    def cpu_hz_per_core_not_in(self, cpu_hz_per_core_not_in):
        """Sets the cpu_hz_per_core_not_in of this HostWhereInput.


        :param cpu_hz_per_core_not_in: The cpu_hz_per_core_not_in of this HostWhereInput.  # noqa: E501
        :type cpu_hz_per_core_not_in: list[int]
        """

        self._cpu_hz_per_core_not_in = cpu_hz_per_core_not_in

    @property
    def cpu_model(self):
        """Gets the cpu_model of this HostWhereInput.  # noqa: E501


        :return: The cpu_model of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this HostWhereInput.


        :param cpu_model: The cpu_model of this HostWhereInput.  # noqa: E501
        :type cpu_model: str
        """

        self._cpu_model = cpu_model

    @property
    def cpu_model_contains(self):
        """Gets the cpu_model_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_contains

    @cpu_model_contains.setter
    def cpu_model_contains(self, cpu_model_contains):
        """Sets the cpu_model_contains of this HostWhereInput.


        :param cpu_model_contains: The cpu_model_contains of this HostWhereInput.  # noqa: E501
        :type cpu_model_contains: str
        """

        self._cpu_model_contains = cpu_model_contains

    @property
    def cpu_model_ends_with(self):
        """Gets the cpu_model_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_ends_with

    @cpu_model_ends_with.setter
    def cpu_model_ends_with(self, cpu_model_ends_with):
        """Sets the cpu_model_ends_with of this HostWhereInput.


        :param cpu_model_ends_with: The cpu_model_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_model_ends_with: str
        """

        self._cpu_model_ends_with = cpu_model_ends_with

    @property
    def cpu_model_gt(self):
        """Gets the cpu_model_gt of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_gt

    @cpu_model_gt.setter
    def cpu_model_gt(self, cpu_model_gt):
        """Sets the cpu_model_gt of this HostWhereInput.


        :param cpu_model_gt: The cpu_model_gt of this HostWhereInput.  # noqa: E501
        :type cpu_model_gt: str
        """

        self._cpu_model_gt = cpu_model_gt

    @property
    def cpu_model_gte(self):
        """Gets the cpu_model_gte of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_gte

    @cpu_model_gte.setter
    def cpu_model_gte(self, cpu_model_gte):
        """Sets the cpu_model_gte of this HostWhereInput.


        :param cpu_model_gte: The cpu_model_gte of this HostWhereInput.  # noqa: E501
        :type cpu_model_gte: str
        """

        self._cpu_model_gte = cpu_model_gte

    @property
    def cpu_model_in(self):
        """Gets the cpu_model_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_model_in

    @cpu_model_in.setter
    def cpu_model_in(self, cpu_model_in):
        """Sets the cpu_model_in of this HostWhereInput.


        :param cpu_model_in: The cpu_model_in of this HostWhereInput.  # noqa: E501
        :type cpu_model_in: list[str]
        """

        self._cpu_model_in = cpu_model_in

    @property
    def cpu_model_lt(self):
        """Gets the cpu_model_lt of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_lt

    @cpu_model_lt.setter
    def cpu_model_lt(self, cpu_model_lt):
        """Sets the cpu_model_lt of this HostWhereInput.


        :param cpu_model_lt: The cpu_model_lt of this HostWhereInput.  # noqa: E501
        :type cpu_model_lt: str
        """

        self._cpu_model_lt = cpu_model_lt

    @property
    def cpu_model_lte(self):
        """Gets the cpu_model_lte of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_lte

    @cpu_model_lte.setter
    def cpu_model_lte(self, cpu_model_lte):
        """Sets the cpu_model_lte of this HostWhereInput.


        :param cpu_model_lte: The cpu_model_lte of this HostWhereInput.  # noqa: E501
        :type cpu_model_lte: str
        """

        self._cpu_model_lte = cpu_model_lte

    @property
    def cpu_model_not(self):
        """Gets the cpu_model_not of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not

    @cpu_model_not.setter
    def cpu_model_not(self, cpu_model_not):
        """Sets the cpu_model_not of this HostWhereInput.


        :param cpu_model_not: The cpu_model_not of this HostWhereInput.  # noqa: E501
        :type cpu_model_not: str
        """

        self._cpu_model_not = cpu_model_not

    @property
    def cpu_model_not_contains(self):
        """Gets the cpu_model_not_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_contains

    @cpu_model_not_contains.setter
    def cpu_model_not_contains(self, cpu_model_not_contains):
        """Sets the cpu_model_not_contains of this HostWhereInput.


        :param cpu_model_not_contains: The cpu_model_not_contains of this HostWhereInput.  # noqa: E501
        :type cpu_model_not_contains: str
        """

        self._cpu_model_not_contains = cpu_model_not_contains

    @property
    def cpu_model_not_ends_with(self):
        """Gets the cpu_model_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_ends_with

    @cpu_model_not_ends_with.setter
    def cpu_model_not_ends_with(self, cpu_model_not_ends_with):
        """Sets the cpu_model_not_ends_with of this HostWhereInput.


        :param cpu_model_not_ends_with: The cpu_model_not_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_model_not_ends_with: str
        """

        self._cpu_model_not_ends_with = cpu_model_not_ends_with

    @property
    def cpu_model_not_in(self):
        """Gets the cpu_model_not_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_model_not_in

    @cpu_model_not_in.setter
    def cpu_model_not_in(self, cpu_model_not_in):
        """Sets the cpu_model_not_in of this HostWhereInput.


        :param cpu_model_not_in: The cpu_model_not_in of this HostWhereInput.  # noqa: E501
        :type cpu_model_not_in: list[str]
        """

        self._cpu_model_not_in = cpu_model_not_in

    @property
    def cpu_model_not_starts_with(self):
        """Gets the cpu_model_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_starts_with

    @cpu_model_not_starts_with.setter
    def cpu_model_not_starts_with(self, cpu_model_not_starts_with):
        """Sets the cpu_model_not_starts_with of this HostWhereInput.


        :param cpu_model_not_starts_with: The cpu_model_not_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_model_not_starts_with: str
        """

        self._cpu_model_not_starts_with = cpu_model_not_starts_with

    @property
    def cpu_model_starts_with(self):
        """Gets the cpu_model_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_model_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_starts_with

    @cpu_model_starts_with.setter
    def cpu_model_starts_with(self, cpu_model_starts_with):
        """Sets the cpu_model_starts_with of this HostWhereInput.


        :param cpu_model_starts_with: The cpu_model_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_model_starts_with: str
        """

        self._cpu_model_starts_with = cpu_model_starts_with

    @property
    def cpu_vendor(self):
        """Gets the cpu_vendor of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor

    @cpu_vendor.setter
    def cpu_vendor(self, cpu_vendor):
        """Sets the cpu_vendor of this HostWhereInput.


        :param cpu_vendor: The cpu_vendor of this HostWhereInput.  # noqa: E501
        :type cpu_vendor: str
        """

        self._cpu_vendor = cpu_vendor

    @property
    def cpu_vendor_contains(self):
        """Gets the cpu_vendor_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_contains

    @cpu_vendor_contains.setter
    def cpu_vendor_contains(self, cpu_vendor_contains):
        """Sets the cpu_vendor_contains of this HostWhereInput.


        :param cpu_vendor_contains: The cpu_vendor_contains of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_contains: str
        """

        self._cpu_vendor_contains = cpu_vendor_contains

    @property
    def cpu_vendor_ends_with(self):
        """Gets the cpu_vendor_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_ends_with

    @cpu_vendor_ends_with.setter
    def cpu_vendor_ends_with(self, cpu_vendor_ends_with):
        """Sets the cpu_vendor_ends_with of this HostWhereInput.


        :param cpu_vendor_ends_with: The cpu_vendor_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_ends_with: str
        """

        self._cpu_vendor_ends_with = cpu_vendor_ends_with

    @property
    def cpu_vendor_gt(self):
        """Gets the cpu_vendor_gt of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_gt

    @cpu_vendor_gt.setter
    def cpu_vendor_gt(self, cpu_vendor_gt):
        """Sets the cpu_vendor_gt of this HostWhereInput.


        :param cpu_vendor_gt: The cpu_vendor_gt of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_gt: str
        """

        self._cpu_vendor_gt = cpu_vendor_gt

    @property
    def cpu_vendor_gte(self):
        """Gets the cpu_vendor_gte of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_gte

    @cpu_vendor_gte.setter
    def cpu_vendor_gte(self, cpu_vendor_gte):
        """Sets the cpu_vendor_gte of this HostWhereInput.


        :param cpu_vendor_gte: The cpu_vendor_gte of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_gte: str
        """

        self._cpu_vendor_gte = cpu_vendor_gte

    @property
    def cpu_vendor_in(self):
        """Gets the cpu_vendor_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_vendor_in

    @cpu_vendor_in.setter
    def cpu_vendor_in(self, cpu_vendor_in):
        """Sets the cpu_vendor_in of this HostWhereInput.


        :param cpu_vendor_in: The cpu_vendor_in of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_in: list[str]
        """

        self._cpu_vendor_in = cpu_vendor_in

    @property
    def cpu_vendor_lt(self):
        """Gets the cpu_vendor_lt of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_lt

    @cpu_vendor_lt.setter
    def cpu_vendor_lt(self, cpu_vendor_lt):
        """Sets the cpu_vendor_lt of this HostWhereInput.


        :param cpu_vendor_lt: The cpu_vendor_lt of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_lt: str
        """

        self._cpu_vendor_lt = cpu_vendor_lt

    @property
    def cpu_vendor_lte(self):
        """Gets the cpu_vendor_lte of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_lte

    @cpu_vendor_lte.setter
    def cpu_vendor_lte(self, cpu_vendor_lte):
        """Sets the cpu_vendor_lte of this HostWhereInput.


        :param cpu_vendor_lte: The cpu_vendor_lte of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_lte: str
        """

        self._cpu_vendor_lte = cpu_vendor_lte

    @property
    def cpu_vendor_not(self):
        """Gets the cpu_vendor_not of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_not

    @cpu_vendor_not.setter
    def cpu_vendor_not(self, cpu_vendor_not):
        """Sets the cpu_vendor_not of this HostWhereInput.


        :param cpu_vendor_not: The cpu_vendor_not of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_not: str
        """

        self._cpu_vendor_not = cpu_vendor_not

    @property
    def cpu_vendor_not_contains(self):
        """Gets the cpu_vendor_not_contains of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_not_contains

    @cpu_vendor_not_contains.setter
    def cpu_vendor_not_contains(self, cpu_vendor_not_contains):
        """Sets the cpu_vendor_not_contains of this HostWhereInput.


        :param cpu_vendor_not_contains: The cpu_vendor_not_contains of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_not_contains: str
        """

        self._cpu_vendor_not_contains = cpu_vendor_not_contains

    @property
    def cpu_vendor_not_ends_with(self):
        """Gets the cpu_vendor_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_not_ends_with

    @cpu_vendor_not_ends_with.setter
    def cpu_vendor_not_ends_with(self, cpu_vendor_not_ends_with):
        """Sets the cpu_vendor_not_ends_with of this HostWhereInput.


        :param cpu_vendor_not_ends_with: The cpu_vendor_not_ends_with of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_not_ends_with: str
        """

        self._cpu_vendor_not_ends_with = cpu_vendor_not_ends_with

    @property
    def cpu_vendor_not_in(self):
        """Gets the cpu_vendor_not_in of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_vendor_not_in

    @cpu_vendor_not_in.setter
    def cpu_vendor_not_in(self, cpu_vendor_not_in):
        """Sets the cpu_vendor_not_in of this HostWhereInput.


        :param cpu_vendor_not_in: The cpu_vendor_not_in of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_not_in: list[str]
        """

        self._cpu_vendor_not_in = cpu_vendor_not_in

    @property
    def cpu_vendor_not_starts_with(self):
        """Gets the cpu_vendor_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_not_starts_with

    @cpu_vendor_not_starts_with.setter
    def cpu_vendor_not_starts_with(self, cpu_vendor_not_starts_with):
        """Sets the cpu_vendor_not_starts_with of this HostWhereInput.


        :param cpu_vendor_not_starts_with: The cpu_vendor_not_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_not_starts_with: str
        """

        self._cpu_vendor_not_starts_with = cpu_vendor_not_starts_with

    @property
    def cpu_vendor_starts_with(self):
        """Gets the cpu_vendor_starts_with of this HostWhereInput.  # noqa: E501


        :return: The cpu_vendor_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor_starts_with

    @cpu_vendor_starts_with.setter
    def cpu_vendor_starts_with(self, cpu_vendor_starts_with):
        """Sets the cpu_vendor_starts_with of this HostWhereInput.


        :param cpu_vendor_starts_with: The cpu_vendor_starts_with of this HostWhereInput.  # noqa: E501
        :type cpu_vendor_starts_with: str
        """

        self._cpu_vendor_starts_with = cpu_vendor_starts_with

    @property
    def data_ip(self):
        """Gets the data_ip of this HostWhereInput.  # noqa: E501


        :return: The data_ip of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip

    @data_ip.setter
    def data_ip(self, data_ip):
        """Sets the data_ip of this HostWhereInput.


        :param data_ip: The data_ip of this HostWhereInput.  # noqa: E501
        :type data_ip: str
        """

        self._data_ip = data_ip

    @property
    def data_ip_contains(self):
        """Gets the data_ip_contains of this HostWhereInput.  # noqa: E501


        :return: The data_ip_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_contains

    @data_ip_contains.setter
    def data_ip_contains(self, data_ip_contains):
        """Sets the data_ip_contains of this HostWhereInput.


        :param data_ip_contains: The data_ip_contains of this HostWhereInput.  # noqa: E501
        :type data_ip_contains: str
        """

        self._data_ip_contains = data_ip_contains

    @property
    def data_ip_ends_with(self):
        """Gets the data_ip_ends_with of this HostWhereInput.  # noqa: E501


        :return: The data_ip_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_ends_with

    @data_ip_ends_with.setter
    def data_ip_ends_with(self, data_ip_ends_with):
        """Sets the data_ip_ends_with of this HostWhereInput.


        :param data_ip_ends_with: The data_ip_ends_with of this HostWhereInput.  # noqa: E501
        :type data_ip_ends_with: str
        """

        self._data_ip_ends_with = data_ip_ends_with

    @property
    def data_ip_gt(self):
        """Gets the data_ip_gt of this HostWhereInput.  # noqa: E501


        :return: The data_ip_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_gt

    @data_ip_gt.setter
    def data_ip_gt(self, data_ip_gt):
        """Sets the data_ip_gt of this HostWhereInput.


        :param data_ip_gt: The data_ip_gt of this HostWhereInput.  # noqa: E501
        :type data_ip_gt: str
        """

        self._data_ip_gt = data_ip_gt

    @property
    def data_ip_gte(self):
        """Gets the data_ip_gte of this HostWhereInput.  # noqa: E501


        :return: The data_ip_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_gte

    @data_ip_gte.setter
    def data_ip_gte(self, data_ip_gte):
        """Sets the data_ip_gte of this HostWhereInput.


        :param data_ip_gte: The data_ip_gte of this HostWhereInput.  # noqa: E501
        :type data_ip_gte: str
        """

        self._data_ip_gte = data_ip_gte

    @property
    def data_ip_in(self):
        """Gets the data_ip_in of this HostWhereInput.  # noqa: E501


        :return: The data_ip_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_ip_in

    @data_ip_in.setter
    def data_ip_in(self, data_ip_in):
        """Sets the data_ip_in of this HostWhereInput.


        :param data_ip_in: The data_ip_in of this HostWhereInput.  # noqa: E501
        :type data_ip_in: list[str]
        """

        self._data_ip_in = data_ip_in

    @property
    def data_ip_lt(self):
        """Gets the data_ip_lt of this HostWhereInput.  # noqa: E501


        :return: The data_ip_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_lt

    @data_ip_lt.setter
    def data_ip_lt(self, data_ip_lt):
        """Sets the data_ip_lt of this HostWhereInput.


        :param data_ip_lt: The data_ip_lt of this HostWhereInput.  # noqa: E501
        :type data_ip_lt: str
        """

        self._data_ip_lt = data_ip_lt

    @property
    def data_ip_lte(self):
        """Gets the data_ip_lte of this HostWhereInput.  # noqa: E501


        :return: The data_ip_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_lte

    @data_ip_lte.setter
    def data_ip_lte(self, data_ip_lte):
        """Sets the data_ip_lte of this HostWhereInput.


        :param data_ip_lte: The data_ip_lte of this HostWhereInput.  # noqa: E501
        :type data_ip_lte: str
        """

        self._data_ip_lte = data_ip_lte

    @property
    def data_ip_not(self):
        """Gets the data_ip_not of this HostWhereInput.  # noqa: E501


        :return: The data_ip_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not

    @data_ip_not.setter
    def data_ip_not(self, data_ip_not):
        """Sets the data_ip_not of this HostWhereInput.


        :param data_ip_not: The data_ip_not of this HostWhereInput.  # noqa: E501
        :type data_ip_not: str
        """

        self._data_ip_not = data_ip_not

    @property
    def data_ip_not_contains(self):
        """Gets the data_ip_not_contains of this HostWhereInput.  # noqa: E501


        :return: The data_ip_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_contains

    @data_ip_not_contains.setter
    def data_ip_not_contains(self, data_ip_not_contains):
        """Sets the data_ip_not_contains of this HostWhereInput.


        :param data_ip_not_contains: The data_ip_not_contains of this HostWhereInput.  # noqa: E501
        :type data_ip_not_contains: str
        """

        self._data_ip_not_contains = data_ip_not_contains

    @property
    def data_ip_not_ends_with(self):
        """Gets the data_ip_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The data_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_ends_with

    @data_ip_not_ends_with.setter
    def data_ip_not_ends_with(self, data_ip_not_ends_with):
        """Sets the data_ip_not_ends_with of this HostWhereInput.


        :param data_ip_not_ends_with: The data_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :type data_ip_not_ends_with: str
        """

        self._data_ip_not_ends_with = data_ip_not_ends_with

    @property
    def data_ip_not_in(self):
        """Gets the data_ip_not_in of this HostWhereInput.  # noqa: E501


        :return: The data_ip_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_ip_not_in

    @data_ip_not_in.setter
    def data_ip_not_in(self, data_ip_not_in):
        """Sets the data_ip_not_in of this HostWhereInput.


        :param data_ip_not_in: The data_ip_not_in of this HostWhereInput.  # noqa: E501
        :type data_ip_not_in: list[str]
        """

        self._data_ip_not_in = data_ip_not_in

    @property
    def data_ip_not_starts_with(self):
        """Gets the data_ip_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The data_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_starts_with

    @data_ip_not_starts_with.setter
    def data_ip_not_starts_with(self, data_ip_not_starts_with):
        """Sets the data_ip_not_starts_with of this HostWhereInput.


        :param data_ip_not_starts_with: The data_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :type data_ip_not_starts_with: str
        """

        self._data_ip_not_starts_with = data_ip_not_starts_with

    @property
    def data_ip_starts_with(self):
        """Gets the data_ip_starts_with of this HostWhereInput.  # noqa: E501


        :return: The data_ip_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_starts_with

    @data_ip_starts_with.setter
    def data_ip_starts_with(self, data_ip_starts_with):
        """Sets the data_ip_starts_with of this HostWhereInput.


        :param data_ip_starts_with: The data_ip_starts_with of this HostWhereInput.  # noqa: E501
        :type data_ip_starts_with: str
        """

        self._data_ip_starts_with = data_ip_starts_with

    @property
    def disk_pools_every(self):
        """Gets the disk_pools_every of this HostWhereInput.  # noqa: E501


        :return: The disk_pools_every of this HostWhereInput.  # noqa: E501
        :rtype: DiskPoolWhereInput
        """
        return self._disk_pools_every

    @disk_pools_every.setter
    def disk_pools_every(self, disk_pools_every):
        """Sets the disk_pools_every of this HostWhereInput.


        :param disk_pools_every: The disk_pools_every of this HostWhereInput.  # noqa: E501
        :type disk_pools_every: DiskPoolWhereInput
        """

        self._disk_pools_every = disk_pools_every

    @property
    def disk_pools_none(self):
        """Gets the disk_pools_none of this HostWhereInput.  # noqa: E501


        :return: The disk_pools_none of this HostWhereInput.  # noqa: E501
        :rtype: DiskPoolWhereInput
        """
        return self._disk_pools_none

    @disk_pools_none.setter
    def disk_pools_none(self, disk_pools_none):
        """Sets the disk_pools_none of this HostWhereInput.


        :param disk_pools_none: The disk_pools_none of this HostWhereInput.  # noqa: E501
        :type disk_pools_none: DiskPoolWhereInput
        """

        self._disk_pools_none = disk_pools_none

    @property
    def disk_pools_some(self):
        """Gets the disk_pools_some of this HostWhereInput.  # noqa: E501


        :return: The disk_pools_some of this HostWhereInput.  # noqa: E501
        :rtype: DiskPoolWhereInput
        """
        return self._disk_pools_some

    @disk_pools_some.setter
    def disk_pools_some(self, disk_pools_some):
        """Sets the disk_pools_some of this HostWhereInput.


        :param disk_pools_some: The disk_pools_some of this HostWhereInput.  # noqa: E501
        :type disk_pools_some: DiskPoolWhereInput
        """

        self._disk_pools_some = disk_pools_some

    @property
    def disks_every(self):
        """Gets the disks_every of this HostWhereInput.  # noqa: E501


        :return: The disks_every of this HostWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_every

    @disks_every.setter
    def disks_every(self, disks_every):
        """Sets the disks_every of this HostWhereInput.


        :param disks_every: The disks_every of this HostWhereInput.  # noqa: E501
        :type disks_every: DiskWhereInput
        """

        self._disks_every = disks_every

    @property
    def disks_none(self):
        """Gets the disks_none of this HostWhereInput.  # noqa: E501


        :return: The disks_none of this HostWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_none

    @disks_none.setter
    def disks_none(self, disks_none):
        """Sets the disks_none of this HostWhereInput.


        :param disks_none: The disks_none of this HostWhereInput.  # noqa: E501
        :type disks_none: DiskWhereInput
        """

        self._disks_none = disks_none

    @property
    def disks_some(self):
        """Gets the disks_some of this HostWhereInput.  # noqa: E501


        :return: The disks_some of this HostWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disks_some

    @disks_some.setter
    def disks_some(self, disks_some):
        """Sets the disks_some of this HostWhereInput.


        :param disks_some: The disks_some of this HostWhereInput.  # noqa: E501
        :type disks_some: DiskWhereInput
        """

        self._disks_some = disks_some

    @property
    def downgraded_prioritized_space(self):
        """Gets the downgraded_prioritized_space of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space

    @downgraded_prioritized_space.setter
    def downgraded_prioritized_space(self, downgraded_prioritized_space):
        """Sets the downgraded_prioritized_space of this HostWhereInput.


        :param downgraded_prioritized_space: The downgraded_prioritized_space of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space: int
        """

        self._downgraded_prioritized_space = downgraded_prioritized_space

    @property
    def downgraded_prioritized_space_gt(self):
        """Gets the downgraded_prioritized_space_gt of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space_gt

    @downgraded_prioritized_space_gt.setter
    def downgraded_prioritized_space_gt(self, downgraded_prioritized_space_gt):
        """Sets the downgraded_prioritized_space_gt of this HostWhereInput.


        :param downgraded_prioritized_space_gt: The downgraded_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_gt: int
        """

        self._downgraded_prioritized_space_gt = downgraded_prioritized_space_gt

    @property
    def downgraded_prioritized_space_gte(self):
        """Gets the downgraded_prioritized_space_gte of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space_gte

    @downgraded_prioritized_space_gte.setter
    def downgraded_prioritized_space_gte(self, downgraded_prioritized_space_gte):
        """Sets the downgraded_prioritized_space_gte of this HostWhereInput.


        :param downgraded_prioritized_space_gte: The downgraded_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_gte: int
        """

        self._downgraded_prioritized_space_gte = downgraded_prioritized_space_gte

    @property
    def downgraded_prioritized_space_in(self):
        """Gets the downgraded_prioritized_space_in of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._downgraded_prioritized_space_in

    @downgraded_prioritized_space_in.setter
    def downgraded_prioritized_space_in(self, downgraded_prioritized_space_in):
        """Sets the downgraded_prioritized_space_in of this HostWhereInput.


        :param downgraded_prioritized_space_in: The downgraded_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_in: list[int]
        """

        self._downgraded_prioritized_space_in = downgraded_prioritized_space_in

    @property
    def downgraded_prioritized_space_lt(self):
        """Gets the downgraded_prioritized_space_lt of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space_lt

    @downgraded_prioritized_space_lt.setter
    def downgraded_prioritized_space_lt(self, downgraded_prioritized_space_lt):
        """Sets the downgraded_prioritized_space_lt of this HostWhereInput.


        :param downgraded_prioritized_space_lt: The downgraded_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_lt: int
        """

        self._downgraded_prioritized_space_lt = downgraded_prioritized_space_lt

    @property
    def downgraded_prioritized_space_lte(self):
        """Gets the downgraded_prioritized_space_lte of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space_lte

    @downgraded_prioritized_space_lte.setter
    def downgraded_prioritized_space_lte(self, downgraded_prioritized_space_lte):
        """Sets the downgraded_prioritized_space_lte of this HostWhereInput.


        :param downgraded_prioritized_space_lte: The downgraded_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_lte: int
        """

        self._downgraded_prioritized_space_lte = downgraded_prioritized_space_lte

    @property
    def downgraded_prioritized_space_not(self):
        """Gets the downgraded_prioritized_space_not of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space_not

    @downgraded_prioritized_space_not.setter
    def downgraded_prioritized_space_not(self, downgraded_prioritized_space_not):
        """Sets the downgraded_prioritized_space_not of this HostWhereInput.


        :param downgraded_prioritized_space_not: The downgraded_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_not: int
        """

        self._downgraded_prioritized_space_not = downgraded_prioritized_space_not

    @property
    def downgraded_prioritized_space_not_in(self):
        """Gets the downgraded_prioritized_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The downgraded_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._downgraded_prioritized_space_not_in

    @downgraded_prioritized_space_not_in.setter
    def downgraded_prioritized_space_not_in(self, downgraded_prioritized_space_not_in):
        """Sets the downgraded_prioritized_space_not_in of this HostWhereInput.


        :param downgraded_prioritized_space_not_in: The downgraded_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :type downgraded_prioritized_space_not_in: list[int]
        """

        self._downgraded_prioritized_space_not_in = downgraded_prioritized_space_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this HostWhereInput.  # noqa: E501


        :return: The entity_async_status of this HostWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this HostWhereInput.


        :param entity_async_status: The entity_async_status of this HostWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this HostWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this HostWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this HostWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this HostWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this HostWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this HostWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this HostWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this HostWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this HostWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this HostWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this HostWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this HostWhereInput.


        :param failure_data_space: The failure_data_space of this HostWhereInput.  # noqa: E501
        :type failure_data_space: int
        """

        self._failure_data_space = failure_data_space

    @property
    def failure_data_space_gt(self):
        """Gets the failure_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gt

    @failure_data_space_gt.setter
    def failure_data_space_gt(self, failure_data_space_gt):
        """Sets the failure_data_space_gt of this HostWhereInput.


        :param failure_data_space_gt: The failure_data_space_gt of this HostWhereInput.  # noqa: E501
        :type failure_data_space_gt: int
        """

        self._failure_data_space_gt = failure_data_space_gt

    @property
    def failure_data_space_gte(self):
        """Gets the failure_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gte

    @failure_data_space_gte.setter
    def failure_data_space_gte(self, failure_data_space_gte):
        """Sets the failure_data_space_gte of this HostWhereInput.


        :param failure_data_space_gte: The failure_data_space_gte of this HostWhereInput.  # noqa: E501
        :type failure_data_space_gte: int
        """

        self._failure_data_space_gte = failure_data_space_gte

    @property
    def failure_data_space_in(self):
        """Gets the failure_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_in

    @failure_data_space_in.setter
    def failure_data_space_in(self, failure_data_space_in):
        """Sets the failure_data_space_in of this HostWhereInput.


        :param failure_data_space_in: The failure_data_space_in of this HostWhereInput.  # noqa: E501
        :type failure_data_space_in: list[int]
        """

        self._failure_data_space_in = failure_data_space_in

    @property
    def failure_data_space_lt(self):
        """Gets the failure_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lt

    @failure_data_space_lt.setter
    def failure_data_space_lt(self, failure_data_space_lt):
        """Sets the failure_data_space_lt of this HostWhereInput.


        :param failure_data_space_lt: The failure_data_space_lt of this HostWhereInput.  # noqa: E501
        :type failure_data_space_lt: int
        """

        self._failure_data_space_lt = failure_data_space_lt

    @property
    def failure_data_space_lte(self):
        """Gets the failure_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lte

    @failure_data_space_lte.setter
    def failure_data_space_lte(self, failure_data_space_lte):
        """Sets the failure_data_space_lte of this HostWhereInput.


        :param failure_data_space_lte: The failure_data_space_lte of this HostWhereInput.  # noqa: E501
        :type failure_data_space_lte: int
        """

        self._failure_data_space_lte = failure_data_space_lte

    @property
    def failure_data_space_not(self):
        """Gets the failure_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_not

    @failure_data_space_not.setter
    def failure_data_space_not(self, failure_data_space_not):
        """Sets the failure_data_space_not of this HostWhereInput.


        :param failure_data_space_not: The failure_data_space_not of this HostWhereInput.  # noqa: E501
        :type failure_data_space_not: int
        """

        self._failure_data_space_not = failure_data_space_not

    @property
    def failure_data_space_not_in(self):
        """Gets the failure_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The failure_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_not_in

    @failure_data_space_not_in.setter
    def failure_data_space_not_in(self, failure_data_space_not_in):
        """Sets the failure_data_space_not_in of this HostWhereInput.


        :param failure_data_space_not_in: The failure_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type failure_data_space_not_in: list[int]
        """

        self._failure_data_space_not_in = failure_data_space_not_in

    @property
    def gpu_devices_every(self):
        """Gets the gpu_devices_every of this HostWhereInput.  # noqa: E501


        :return: The gpu_devices_every of this HostWhereInput.  # noqa: E501
        :rtype: GpuDeviceWhereInput
        """
        return self._gpu_devices_every

    @gpu_devices_every.setter
    def gpu_devices_every(self, gpu_devices_every):
        """Sets the gpu_devices_every of this HostWhereInput.


        :param gpu_devices_every: The gpu_devices_every of this HostWhereInput.  # noqa: E501
        :type gpu_devices_every: GpuDeviceWhereInput
        """

        self._gpu_devices_every = gpu_devices_every

    @property
    def gpu_devices_none(self):
        """Gets the gpu_devices_none of this HostWhereInput.  # noqa: E501


        :return: The gpu_devices_none of this HostWhereInput.  # noqa: E501
        :rtype: GpuDeviceWhereInput
        """
        return self._gpu_devices_none

    @gpu_devices_none.setter
    def gpu_devices_none(self, gpu_devices_none):
        """Sets the gpu_devices_none of this HostWhereInput.


        :param gpu_devices_none: The gpu_devices_none of this HostWhereInput.  # noqa: E501
        :type gpu_devices_none: GpuDeviceWhereInput
        """

        self._gpu_devices_none = gpu_devices_none

    @property
    def gpu_devices_some(self):
        """Gets the gpu_devices_some of this HostWhereInput.  # noqa: E501


        :return: The gpu_devices_some of this HostWhereInput.  # noqa: E501
        :rtype: GpuDeviceWhereInput
        """
        return self._gpu_devices_some

    @gpu_devices_some.setter
    def gpu_devices_some(self, gpu_devices_some):
        """Sets the gpu_devices_some of this HostWhereInput.


        :param gpu_devices_some: The gpu_devices_some of this HostWhereInput.  # noqa: E501
        :type gpu_devices_some: GpuDeviceWhereInput
        """

        self._gpu_devices_some = gpu_devices_some

    @property
    def hdd_data_capacity(self):
        """Gets the hdd_data_capacity of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity

    @hdd_data_capacity.setter
    def hdd_data_capacity(self, hdd_data_capacity):
        """Sets the hdd_data_capacity of this HostWhereInput.


        :param hdd_data_capacity: The hdd_data_capacity of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity: int
        """

        self._hdd_data_capacity = hdd_data_capacity

    @property
    def hdd_data_capacity_gt(self):
        """Gets the hdd_data_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity_gt

    @hdd_data_capacity_gt.setter
    def hdd_data_capacity_gt(self, hdd_data_capacity_gt):
        """Sets the hdd_data_capacity_gt of this HostWhereInput.


        :param hdd_data_capacity_gt: The hdd_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_gt: int
        """

        self._hdd_data_capacity_gt = hdd_data_capacity_gt

    @property
    def hdd_data_capacity_gte(self):
        """Gets the hdd_data_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity_gte

    @hdd_data_capacity_gte.setter
    def hdd_data_capacity_gte(self, hdd_data_capacity_gte):
        """Sets the hdd_data_capacity_gte of this HostWhereInput.


        :param hdd_data_capacity_gte: The hdd_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_gte: int
        """

        self._hdd_data_capacity_gte = hdd_data_capacity_gte

    @property
    def hdd_data_capacity_in(self):
        """Gets the hdd_data_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_data_capacity_in

    @hdd_data_capacity_in.setter
    def hdd_data_capacity_in(self, hdd_data_capacity_in):
        """Sets the hdd_data_capacity_in of this HostWhereInput.


        :param hdd_data_capacity_in: The hdd_data_capacity_in of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_in: list[int]
        """

        self._hdd_data_capacity_in = hdd_data_capacity_in

    @property
    def hdd_data_capacity_lt(self):
        """Gets the hdd_data_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity_lt

    @hdd_data_capacity_lt.setter
    def hdd_data_capacity_lt(self, hdd_data_capacity_lt):
        """Sets the hdd_data_capacity_lt of this HostWhereInput.


        :param hdd_data_capacity_lt: The hdd_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_lt: int
        """

        self._hdd_data_capacity_lt = hdd_data_capacity_lt

    @property
    def hdd_data_capacity_lte(self):
        """Gets the hdd_data_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity_lte

    @hdd_data_capacity_lte.setter
    def hdd_data_capacity_lte(self, hdd_data_capacity_lte):
        """Sets the hdd_data_capacity_lte of this HostWhereInput.


        :param hdd_data_capacity_lte: The hdd_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_lte: int
        """

        self._hdd_data_capacity_lte = hdd_data_capacity_lte

    @property
    def hdd_data_capacity_not(self):
        """Gets the hdd_data_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity_not

    @hdd_data_capacity_not.setter
    def hdd_data_capacity_not(self, hdd_data_capacity_not):
        """Sets the hdd_data_capacity_not of this HostWhereInput.


        :param hdd_data_capacity_not: The hdd_data_capacity_not of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_not: int
        """

        self._hdd_data_capacity_not = hdd_data_capacity_not

    @property
    def hdd_data_capacity_not_in(self):
        """Gets the hdd_data_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The hdd_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_data_capacity_not_in

    @hdd_data_capacity_not_in.setter
    def hdd_data_capacity_not_in(self, hdd_data_capacity_not_in):
        """Sets the hdd_data_capacity_not_in of this HostWhereInput.


        :param hdd_data_capacity_not_in: The hdd_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type hdd_data_capacity_not_in: list[int]
        """

        self._hdd_data_capacity_not_in = hdd_data_capacity_not_in

    @property
    def hdd_disk_count(self):
        """Gets the hdd_disk_count of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count

    @hdd_disk_count.setter
    def hdd_disk_count(self, hdd_disk_count):
        """Sets the hdd_disk_count of this HostWhereInput.


        :param hdd_disk_count: The hdd_disk_count of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count: int
        """

        self._hdd_disk_count = hdd_disk_count

    @property
    def hdd_disk_count_gt(self):
        """Gets the hdd_disk_count_gt of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_gt

    @hdd_disk_count_gt.setter
    def hdd_disk_count_gt(self, hdd_disk_count_gt):
        """Sets the hdd_disk_count_gt of this HostWhereInput.


        :param hdd_disk_count_gt: The hdd_disk_count_gt of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_gt: int
        """

        self._hdd_disk_count_gt = hdd_disk_count_gt

    @property
    def hdd_disk_count_gte(self):
        """Gets the hdd_disk_count_gte of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_gte

    @hdd_disk_count_gte.setter
    def hdd_disk_count_gte(self, hdd_disk_count_gte):
        """Sets the hdd_disk_count_gte of this HostWhereInput.


        :param hdd_disk_count_gte: The hdd_disk_count_gte of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_gte: int
        """

        self._hdd_disk_count_gte = hdd_disk_count_gte

    @property
    def hdd_disk_count_in(self):
        """Gets the hdd_disk_count_in of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_disk_count_in

    @hdd_disk_count_in.setter
    def hdd_disk_count_in(self, hdd_disk_count_in):
        """Sets the hdd_disk_count_in of this HostWhereInput.


        :param hdd_disk_count_in: The hdd_disk_count_in of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_in: list[int]
        """

        self._hdd_disk_count_in = hdd_disk_count_in

    @property
    def hdd_disk_count_lt(self):
        """Gets the hdd_disk_count_lt of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_lt

    @hdd_disk_count_lt.setter
    def hdd_disk_count_lt(self, hdd_disk_count_lt):
        """Sets the hdd_disk_count_lt of this HostWhereInput.


        :param hdd_disk_count_lt: The hdd_disk_count_lt of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_lt: int
        """

        self._hdd_disk_count_lt = hdd_disk_count_lt

    @property
    def hdd_disk_count_lte(self):
        """Gets the hdd_disk_count_lte of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_lte

    @hdd_disk_count_lte.setter
    def hdd_disk_count_lte(self, hdd_disk_count_lte):
        """Sets the hdd_disk_count_lte of this HostWhereInput.


        :param hdd_disk_count_lte: The hdd_disk_count_lte of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_lte: int
        """

        self._hdd_disk_count_lte = hdd_disk_count_lte

    @property
    def hdd_disk_count_not(self):
        """Gets the hdd_disk_count_not of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count_not

    @hdd_disk_count_not.setter
    def hdd_disk_count_not(self, hdd_disk_count_not):
        """Sets the hdd_disk_count_not of this HostWhereInput.


        :param hdd_disk_count_not: The hdd_disk_count_not of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_not: int
        """

        self._hdd_disk_count_not = hdd_disk_count_not

    @property
    def hdd_disk_count_not_in(self):
        """Gets the hdd_disk_count_not_in of this HostWhereInput.  # noqa: E501


        :return: The hdd_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._hdd_disk_count_not_in

    @hdd_disk_count_not_in.setter
    def hdd_disk_count_not_in(self, hdd_disk_count_not_in):
        """Sets the hdd_disk_count_not_in of this HostWhereInput.


        :param hdd_disk_count_not_in: The hdd_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :type hdd_disk_count_not_in: list[int]
        """

        self._hdd_disk_count_not_in = hdd_disk_count_not_in

    @property
    def hypervisor_ip(self):
        """Gets the hypervisor_ip of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip

    @hypervisor_ip.setter
    def hypervisor_ip(self, hypervisor_ip):
        """Sets the hypervisor_ip of this HostWhereInput.


        :param hypervisor_ip: The hypervisor_ip of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip: str
        """

        self._hypervisor_ip = hypervisor_ip

    @property
    def hypervisor_ip_contains(self):
        """Gets the hypervisor_ip_contains of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_contains

    @hypervisor_ip_contains.setter
    def hypervisor_ip_contains(self, hypervisor_ip_contains):
        """Sets the hypervisor_ip_contains of this HostWhereInput.


        :param hypervisor_ip_contains: The hypervisor_ip_contains of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_contains: str
        """

        self._hypervisor_ip_contains = hypervisor_ip_contains

    @property
    def hypervisor_ip_ends_with(self):
        """Gets the hypervisor_ip_ends_with of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_ends_with

    @hypervisor_ip_ends_with.setter
    def hypervisor_ip_ends_with(self, hypervisor_ip_ends_with):
        """Sets the hypervisor_ip_ends_with of this HostWhereInput.


        :param hypervisor_ip_ends_with: The hypervisor_ip_ends_with of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_ends_with: str
        """

        self._hypervisor_ip_ends_with = hypervisor_ip_ends_with

    @property
    def hypervisor_ip_gt(self):
        """Gets the hypervisor_ip_gt of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_gt

    @hypervisor_ip_gt.setter
    def hypervisor_ip_gt(self, hypervisor_ip_gt):
        """Sets the hypervisor_ip_gt of this HostWhereInput.


        :param hypervisor_ip_gt: The hypervisor_ip_gt of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_gt: str
        """

        self._hypervisor_ip_gt = hypervisor_ip_gt

    @property
    def hypervisor_ip_gte(self):
        """Gets the hypervisor_ip_gte of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_gte

    @hypervisor_ip_gte.setter
    def hypervisor_ip_gte(self, hypervisor_ip_gte):
        """Sets the hypervisor_ip_gte of this HostWhereInput.


        :param hypervisor_ip_gte: The hypervisor_ip_gte of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_gte: str
        """

        self._hypervisor_ip_gte = hypervisor_ip_gte

    @property
    def hypervisor_ip_in(self):
        """Gets the hypervisor_ip_in of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._hypervisor_ip_in

    @hypervisor_ip_in.setter
    def hypervisor_ip_in(self, hypervisor_ip_in):
        """Sets the hypervisor_ip_in of this HostWhereInput.


        :param hypervisor_ip_in: The hypervisor_ip_in of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_in: list[str]
        """

        self._hypervisor_ip_in = hypervisor_ip_in

    @property
    def hypervisor_ip_lt(self):
        """Gets the hypervisor_ip_lt of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_lt

    @hypervisor_ip_lt.setter
    def hypervisor_ip_lt(self, hypervisor_ip_lt):
        """Sets the hypervisor_ip_lt of this HostWhereInput.


        :param hypervisor_ip_lt: The hypervisor_ip_lt of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_lt: str
        """

        self._hypervisor_ip_lt = hypervisor_ip_lt

    @property
    def hypervisor_ip_lte(self):
        """Gets the hypervisor_ip_lte of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_lte

    @hypervisor_ip_lte.setter
    def hypervisor_ip_lte(self, hypervisor_ip_lte):
        """Sets the hypervisor_ip_lte of this HostWhereInput.


        :param hypervisor_ip_lte: The hypervisor_ip_lte of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_lte: str
        """

        self._hypervisor_ip_lte = hypervisor_ip_lte

    @property
    def hypervisor_ip_not(self):
        """Gets the hypervisor_ip_not of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_not

    @hypervisor_ip_not.setter
    def hypervisor_ip_not(self, hypervisor_ip_not):
        """Sets the hypervisor_ip_not of this HostWhereInput.


        :param hypervisor_ip_not: The hypervisor_ip_not of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_not: str
        """

        self._hypervisor_ip_not = hypervisor_ip_not

    @property
    def hypervisor_ip_not_contains(self):
        """Gets the hypervisor_ip_not_contains of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_not_contains

    @hypervisor_ip_not_contains.setter
    def hypervisor_ip_not_contains(self, hypervisor_ip_not_contains):
        """Sets the hypervisor_ip_not_contains of this HostWhereInput.


        :param hypervisor_ip_not_contains: The hypervisor_ip_not_contains of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_not_contains: str
        """

        self._hypervisor_ip_not_contains = hypervisor_ip_not_contains

    @property
    def hypervisor_ip_not_ends_with(self):
        """Gets the hypervisor_ip_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_not_ends_with

    @hypervisor_ip_not_ends_with.setter
    def hypervisor_ip_not_ends_with(self, hypervisor_ip_not_ends_with):
        """Sets the hypervisor_ip_not_ends_with of this HostWhereInput.


        :param hypervisor_ip_not_ends_with: The hypervisor_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_not_ends_with: str
        """

        self._hypervisor_ip_not_ends_with = hypervisor_ip_not_ends_with

    @property
    def hypervisor_ip_not_in(self):
        """Gets the hypervisor_ip_not_in of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._hypervisor_ip_not_in

    @hypervisor_ip_not_in.setter
    def hypervisor_ip_not_in(self, hypervisor_ip_not_in):
        """Sets the hypervisor_ip_not_in of this HostWhereInput.


        :param hypervisor_ip_not_in: The hypervisor_ip_not_in of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_not_in: list[str]
        """

        self._hypervisor_ip_not_in = hypervisor_ip_not_in

    @property
    def hypervisor_ip_not_starts_with(self):
        """Gets the hypervisor_ip_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_not_starts_with

    @hypervisor_ip_not_starts_with.setter
    def hypervisor_ip_not_starts_with(self, hypervisor_ip_not_starts_with):
        """Sets the hypervisor_ip_not_starts_with of this HostWhereInput.


        :param hypervisor_ip_not_starts_with: The hypervisor_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_not_starts_with: str
        """

        self._hypervisor_ip_not_starts_with = hypervisor_ip_not_starts_with

    @property
    def hypervisor_ip_starts_with(self):
        """Gets the hypervisor_ip_starts_with of this HostWhereInput.  # noqa: E501


        :return: The hypervisor_ip_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip_starts_with

    @hypervisor_ip_starts_with.setter
    def hypervisor_ip_starts_with(self, hypervisor_ip_starts_with):
        """Sets the hypervisor_ip_starts_with of this HostWhereInput.


        :param hypervisor_ip_starts_with: The hypervisor_ip_starts_with of this HostWhereInput.  # noqa: E501
        :type hypervisor_ip_starts_with: str
        """

        self._hypervisor_ip_starts_with = hypervisor_ip_starts_with

    @property
    def id(self):
        """Gets the id of this HostWhereInput.  # noqa: E501


        :return: The id of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HostWhereInput.


        :param id: The id of this HostWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this HostWhereInput.  # noqa: E501


        :return: The id_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this HostWhereInput.


        :param id_contains: The id_contains of this HostWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this HostWhereInput.  # noqa: E501


        :return: The id_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this HostWhereInput.


        :param id_ends_with: The id_ends_with of this HostWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this HostWhereInput.  # noqa: E501


        :return: The id_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this HostWhereInput.


        :param id_gt: The id_gt of this HostWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this HostWhereInput.  # noqa: E501


        :return: The id_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this HostWhereInput.


        :param id_gte: The id_gte of this HostWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this HostWhereInput.  # noqa: E501


        :return: The id_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this HostWhereInput.


        :param id_in: The id_in of this HostWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this HostWhereInput.  # noqa: E501


        :return: The id_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this HostWhereInput.


        :param id_lt: The id_lt of this HostWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this HostWhereInput.  # noqa: E501


        :return: The id_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this HostWhereInput.


        :param id_lte: The id_lte of this HostWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this HostWhereInput.  # noqa: E501


        :return: The id_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this HostWhereInput.


        :param id_not: The id_not of this HostWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this HostWhereInput.  # noqa: E501


        :return: The id_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this HostWhereInput.


        :param id_not_contains: The id_not_contains of this HostWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this HostWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this HostWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this HostWhereInput.  # noqa: E501


        :return: The id_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this HostWhereInput.


        :param id_not_in: The id_not_in of this HostWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this HostWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this HostWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this HostWhereInput.  # noqa: E501


        :return: The id_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this HostWhereInput.


        :param id_starts_with: The id_starts_with of this HostWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def iommu(self):
        """Gets the iommu of this HostWhereInput.  # noqa: E501


        :return: The iommu of this HostWhereInput.  # noqa: E501
        :rtype: IommuStatus
        """
        return self._iommu

    @iommu.setter
    def iommu(self, iommu):
        """Sets the iommu of this HostWhereInput.


        :param iommu: The iommu of this HostWhereInput.  # noqa: E501
        :type iommu: IommuStatus
        """

        self._iommu = iommu

    @property
    def iommu_in(self):
        """Gets the iommu_in of this HostWhereInput.  # noqa: E501


        :return: The iommu_in of this HostWhereInput.  # noqa: E501
        :rtype: list[IommuStatus]
        """
        return self._iommu_in

    @iommu_in.setter
    def iommu_in(self, iommu_in):
        """Sets the iommu_in of this HostWhereInput.


        :param iommu_in: The iommu_in of this HostWhereInput.  # noqa: E501
        :type iommu_in: list[IommuStatus]
        """

        self._iommu_in = iommu_in

    @property
    def iommu_not(self):
        """Gets the iommu_not of this HostWhereInput.  # noqa: E501


        :return: The iommu_not of this HostWhereInput.  # noqa: E501
        :rtype: IommuStatus
        """
        return self._iommu_not

    @iommu_not.setter
    def iommu_not(self, iommu_not):
        """Sets the iommu_not of this HostWhereInput.


        :param iommu_not: The iommu_not of this HostWhereInput.  # noqa: E501
        :type iommu_not: IommuStatus
        """

        self._iommu_not = iommu_not

    @property
    def iommu_not_in(self):
        """Gets the iommu_not_in of this HostWhereInput.  # noqa: E501


        :return: The iommu_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[IommuStatus]
        """
        return self._iommu_not_in

    @iommu_not_in.setter
    def iommu_not_in(self, iommu_not_in):
        """Sets the iommu_not_in of this HostWhereInput.


        :param iommu_not_in: The iommu_not_in of this HostWhereInput.  # noqa: E501
        :type iommu_not_in: list[IommuStatus]
        """

        self._iommu_not_in = iommu_not_in

    @property
    def ipmi(self):
        """Gets the ipmi of this HostWhereInput.  # noqa: E501


        :return: The ipmi of this HostWhereInput.  # noqa: E501
        :rtype: IpmiWhereInput
        """
        return self._ipmi

    @ipmi.setter
    def ipmi(self, ipmi):
        """Sets the ipmi of this HostWhereInput.


        :param ipmi: The ipmi of this HostWhereInput.  # noqa: E501
        :type ipmi: IpmiWhereInput
        """

        self._ipmi = ipmi

    @property
    def is_os_in_raid1(self):
        """Gets the is_os_in_raid1 of this HostWhereInput.  # noqa: E501


        :return: The is_os_in_raid1 of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_os_in_raid1

    @is_os_in_raid1.setter
    def is_os_in_raid1(self, is_os_in_raid1):
        """Sets the is_os_in_raid1 of this HostWhereInput.


        :param is_os_in_raid1: The is_os_in_raid1 of this HostWhereInput.  # noqa: E501
        :type is_os_in_raid1: bool
        """

        self._is_os_in_raid1 = is_os_in_raid1

    @property
    def is_os_in_raid1_not(self):
        """Gets the is_os_in_raid1_not of this HostWhereInput.  # noqa: E501


        :return: The is_os_in_raid1_not of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_os_in_raid1_not

    @is_os_in_raid1_not.setter
    def is_os_in_raid1_not(self, is_os_in_raid1_not):
        """Sets the is_os_in_raid1_not of this HostWhereInput.


        :param is_os_in_raid1_not: The is_os_in_raid1_not of this HostWhereInput.  # noqa: E501
        :type is_os_in_raid1_not: bool
        """

        self._is_os_in_raid1_not = is_os_in_raid1_not

    @property
    def labels_every(self):
        """Gets the labels_every of this HostWhereInput.  # noqa: E501


        :return: The labels_every of this HostWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this HostWhereInput.


        :param labels_every: The labels_every of this HostWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this HostWhereInput.  # noqa: E501


        :return: The labels_none of this HostWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this HostWhereInput.


        :param labels_none: The labels_none of this HostWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this HostWhereInput.  # noqa: E501


        :return: The labels_some of this HostWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this HostWhereInput.


        :param labels_some: The labels_some of this HostWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_id(self):
        """Gets the local_id of this HostWhereInput.  # noqa: E501


        :return: The local_id of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this HostWhereInput.


        :param local_id: The local_id of this HostWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this HostWhereInput.  # noqa: E501


        :return: The local_id_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this HostWhereInput.


        :param local_id_contains: The local_id_contains of this HostWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this HostWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this HostWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this HostWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this HostWhereInput.  # noqa: E501


        :return: The local_id_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this HostWhereInput.


        :param local_id_gt: The local_id_gt of this HostWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this HostWhereInput.  # noqa: E501


        :return: The local_id_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this HostWhereInput.


        :param local_id_gte: The local_id_gte of this HostWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this HostWhereInput.  # noqa: E501


        :return: The local_id_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this HostWhereInput.


        :param local_id_in: The local_id_in of this HostWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this HostWhereInput.  # noqa: E501


        :return: The local_id_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this HostWhereInput.


        :param local_id_lt: The local_id_lt of this HostWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this HostWhereInput.  # noqa: E501


        :return: The local_id_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this HostWhereInput.


        :param local_id_lte: The local_id_lte of this HostWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this HostWhereInput.  # noqa: E501


        :return: The local_id_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this HostWhereInput.


        :param local_id_not: The local_id_not of this HostWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this HostWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this HostWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this HostWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this HostWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this HostWhereInput.  # noqa: E501


        :return: The local_id_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this HostWhereInput.


        :param local_id_not_in: The local_id_not_in of this HostWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this HostWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this HostWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this HostWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this HostWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def lsm_cap_disk_safe_umount(self):
        """Gets the lsm_cap_disk_safe_umount of this HostWhereInput.  # noqa: E501


        :return: The lsm_cap_disk_safe_umount of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._lsm_cap_disk_safe_umount

    @lsm_cap_disk_safe_umount.setter
    def lsm_cap_disk_safe_umount(self, lsm_cap_disk_safe_umount):
        """Sets the lsm_cap_disk_safe_umount of this HostWhereInput.


        :param lsm_cap_disk_safe_umount: The lsm_cap_disk_safe_umount of this HostWhereInput.  # noqa: E501
        :type lsm_cap_disk_safe_umount: bool
        """

        self._lsm_cap_disk_safe_umount = lsm_cap_disk_safe_umount

    @property
    def lsm_cap_disk_safe_umount_not(self):
        """Gets the lsm_cap_disk_safe_umount_not of this HostWhereInput.  # noqa: E501


        :return: The lsm_cap_disk_safe_umount_not of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._lsm_cap_disk_safe_umount_not

    @lsm_cap_disk_safe_umount_not.setter
    def lsm_cap_disk_safe_umount_not(self, lsm_cap_disk_safe_umount_not):
        """Sets the lsm_cap_disk_safe_umount_not of this HostWhereInput.


        :param lsm_cap_disk_safe_umount_not: The lsm_cap_disk_safe_umount_not of this HostWhereInput.  # noqa: E501
        :type lsm_cap_disk_safe_umount_not: bool
        """

        self._lsm_cap_disk_safe_umount_not = lsm_cap_disk_safe_umount_not

    @property
    def management_ip(self):
        """Gets the management_ip of this HostWhereInput.  # noqa: E501


        :return: The management_ip of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip

    @management_ip.setter
    def management_ip(self, management_ip):
        """Sets the management_ip of this HostWhereInput.


        :param management_ip: The management_ip of this HostWhereInput.  # noqa: E501
        :type management_ip: str
        """

        self._management_ip = management_ip

    @property
    def management_ip_contains(self):
        """Gets the management_ip_contains of this HostWhereInput.  # noqa: E501


        :return: The management_ip_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_contains

    @management_ip_contains.setter
    def management_ip_contains(self, management_ip_contains):
        """Sets the management_ip_contains of this HostWhereInput.


        :param management_ip_contains: The management_ip_contains of this HostWhereInput.  # noqa: E501
        :type management_ip_contains: str
        """

        self._management_ip_contains = management_ip_contains

    @property
    def management_ip_ends_with(self):
        """Gets the management_ip_ends_with of this HostWhereInput.  # noqa: E501


        :return: The management_ip_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_ends_with

    @management_ip_ends_with.setter
    def management_ip_ends_with(self, management_ip_ends_with):
        """Sets the management_ip_ends_with of this HostWhereInput.


        :param management_ip_ends_with: The management_ip_ends_with of this HostWhereInput.  # noqa: E501
        :type management_ip_ends_with: str
        """

        self._management_ip_ends_with = management_ip_ends_with

    @property
    def management_ip_gt(self):
        """Gets the management_ip_gt of this HostWhereInput.  # noqa: E501


        :return: The management_ip_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_gt

    @management_ip_gt.setter
    def management_ip_gt(self, management_ip_gt):
        """Sets the management_ip_gt of this HostWhereInput.


        :param management_ip_gt: The management_ip_gt of this HostWhereInput.  # noqa: E501
        :type management_ip_gt: str
        """

        self._management_ip_gt = management_ip_gt

    @property
    def management_ip_gte(self):
        """Gets the management_ip_gte of this HostWhereInput.  # noqa: E501


        :return: The management_ip_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_gte

    @management_ip_gte.setter
    def management_ip_gte(self, management_ip_gte):
        """Sets the management_ip_gte of this HostWhereInput.


        :param management_ip_gte: The management_ip_gte of this HostWhereInput.  # noqa: E501
        :type management_ip_gte: str
        """

        self._management_ip_gte = management_ip_gte

    @property
    def management_ip_in(self):
        """Gets the management_ip_in of this HostWhereInput.  # noqa: E501


        :return: The management_ip_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_ip_in

    @management_ip_in.setter
    def management_ip_in(self, management_ip_in):
        """Sets the management_ip_in of this HostWhereInput.


        :param management_ip_in: The management_ip_in of this HostWhereInput.  # noqa: E501
        :type management_ip_in: list[str]
        """

        self._management_ip_in = management_ip_in

    @property
    def management_ip_lt(self):
        """Gets the management_ip_lt of this HostWhereInput.  # noqa: E501


        :return: The management_ip_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_lt

    @management_ip_lt.setter
    def management_ip_lt(self, management_ip_lt):
        """Sets the management_ip_lt of this HostWhereInput.


        :param management_ip_lt: The management_ip_lt of this HostWhereInput.  # noqa: E501
        :type management_ip_lt: str
        """

        self._management_ip_lt = management_ip_lt

    @property
    def management_ip_lte(self):
        """Gets the management_ip_lte of this HostWhereInput.  # noqa: E501


        :return: The management_ip_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_lte

    @management_ip_lte.setter
    def management_ip_lte(self, management_ip_lte):
        """Sets the management_ip_lte of this HostWhereInput.


        :param management_ip_lte: The management_ip_lte of this HostWhereInput.  # noqa: E501
        :type management_ip_lte: str
        """

        self._management_ip_lte = management_ip_lte

    @property
    def management_ip_not(self):
        """Gets the management_ip_not of this HostWhereInput.  # noqa: E501


        :return: The management_ip_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not

    @management_ip_not.setter
    def management_ip_not(self, management_ip_not):
        """Sets the management_ip_not of this HostWhereInput.


        :param management_ip_not: The management_ip_not of this HostWhereInput.  # noqa: E501
        :type management_ip_not: str
        """

        self._management_ip_not = management_ip_not

    @property
    def management_ip_not_contains(self):
        """Gets the management_ip_not_contains of this HostWhereInput.  # noqa: E501


        :return: The management_ip_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_contains

    @management_ip_not_contains.setter
    def management_ip_not_contains(self, management_ip_not_contains):
        """Sets the management_ip_not_contains of this HostWhereInput.


        :param management_ip_not_contains: The management_ip_not_contains of this HostWhereInput.  # noqa: E501
        :type management_ip_not_contains: str
        """

        self._management_ip_not_contains = management_ip_not_contains

    @property
    def management_ip_not_ends_with(self):
        """Gets the management_ip_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The management_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_ends_with

    @management_ip_not_ends_with.setter
    def management_ip_not_ends_with(self, management_ip_not_ends_with):
        """Sets the management_ip_not_ends_with of this HostWhereInput.


        :param management_ip_not_ends_with: The management_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :type management_ip_not_ends_with: str
        """

        self._management_ip_not_ends_with = management_ip_not_ends_with

    @property
    def management_ip_not_in(self):
        """Gets the management_ip_not_in of this HostWhereInput.  # noqa: E501


        :return: The management_ip_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_ip_not_in

    @management_ip_not_in.setter
    def management_ip_not_in(self, management_ip_not_in):
        """Sets the management_ip_not_in of this HostWhereInput.


        :param management_ip_not_in: The management_ip_not_in of this HostWhereInput.  # noqa: E501
        :type management_ip_not_in: list[str]
        """

        self._management_ip_not_in = management_ip_not_in

    @property
    def management_ip_not_starts_with(self):
        """Gets the management_ip_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The management_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_starts_with

    @management_ip_not_starts_with.setter
    def management_ip_not_starts_with(self, management_ip_not_starts_with):
        """Sets the management_ip_not_starts_with of this HostWhereInput.


        :param management_ip_not_starts_with: The management_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :type management_ip_not_starts_with: str
        """

        self._management_ip_not_starts_with = management_ip_not_starts_with

    @property
    def management_ip_starts_with(self):
        """Gets the management_ip_starts_with of this HostWhereInput.  # noqa: E501


        :return: The management_ip_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_starts_with

    @management_ip_starts_with.setter
    def management_ip_starts_with(self, management_ip_starts_with):
        """Sets the management_ip_starts_with of this HostWhereInput.


        :param management_ip_starts_with: The management_ip_starts_with of this HostWhereInput.  # noqa: E501
        :type management_ip_starts_with: str
        """

        self._management_ip_starts_with = management_ip_starts_with

    @property
    def merged_status(self):
        """Gets the merged_status of this HostWhereInput.  # noqa: E501


        :return: The merged_status of this HostWhereInput.  # noqa: E501
        :rtype: HostMergedStatus
        """
        return self._merged_status

    @merged_status.setter
    def merged_status(self, merged_status):
        """Sets the merged_status of this HostWhereInput.


        :param merged_status: The merged_status of this HostWhereInput.  # noqa: E501
        :type merged_status: HostMergedStatus
        """

        self._merged_status = merged_status

    @property
    def merged_status_in(self):
        """Gets the merged_status_in of this HostWhereInput.  # noqa: E501


        :return: The merged_status_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostMergedStatus]
        """
        return self._merged_status_in

    @merged_status_in.setter
    def merged_status_in(self, merged_status_in):
        """Sets the merged_status_in of this HostWhereInput.


        :param merged_status_in: The merged_status_in of this HostWhereInput.  # noqa: E501
        :type merged_status_in: list[HostMergedStatus]
        """

        self._merged_status_in = merged_status_in

    @property
    def merged_status_not(self):
        """Gets the merged_status_not of this HostWhereInput.  # noqa: E501


        :return: The merged_status_not of this HostWhereInput.  # noqa: E501
        :rtype: HostMergedStatus
        """
        return self._merged_status_not

    @merged_status_not.setter
    def merged_status_not(self, merged_status_not):
        """Sets the merged_status_not of this HostWhereInput.


        :param merged_status_not: The merged_status_not of this HostWhereInput.  # noqa: E501
        :type merged_status_not: HostMergedStatus
        """

        self._merged_status_not = merged_status_not

    @property
    def merged_status_not_in(self):
        """Gets the merged_status_not_in of this HostWhereInput.  # noqa: E501


        :return: The merged_status_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostMergedStatus]
        """
        return self._merged_status_not_in

    @merged_status_not_in.setter
    def merged_status_not_in(self, merged_status_not_in):
        """Sets the merged_status_not_in of this HostWhereInput.


        :param merged_status_not_in: The merged_status_not_in of this HostWhereInput.  # noqa: E501
        :type merged_status_not_in: list[HostMergedStatus]
        """

        self._merged_status_not_in = merged_status_not_in

    @property
    def model(self):
        """Gets the model of this HostWhereInput.  # noqa: E501


        :return: The model of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this HostWhereInput.


        :param model: The model of this HostWhereInput.  # noqa: E501
        :type model: str
        """

        self._model = model

    @property
    def model_contains(self):
        """Gets the model_contains of this HostWhereInput.  # noqa: E501


        :return: The model_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_contains

    @model_contains.setter
    def model_contains(self, model_contains):
        """Sets the model_contains of this HostWhereInput.


        :param model_contains: The model_contains of this HostWhereInput.  # noqa: E501
        :type model_contains: str
        """

        self._model_contains = model_contains

    @property
    def model_ends_with(self):
        """Gets the model_ends_with of this HostWhereInput.  # noqa: E501


        :return: The model_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_ends_with

    @model_ends_with.setter
    def model_ends_with(self, model_ends_with):
        """Sets the model_ends_with of this HostWhereInput.


        :param model_ends_with: The model_ends_with of this HostWhereInput.  # noqa: E501
        :type model_ends_with: str
        """

        self._model_ends_with = model_ends_with

    @property
    def model_gt(self):
        """Gets the model_gt of this HostWhereInput.  # noqa: E501


        :return: The model_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_gt

    @model_gt.setter
    def model_gt(self, model_gt):
        """Sets the model_gt of this HostWhereInput.


        :param model_gt: The model_gt of this HostWhereInput.  # noqa: E501
        :type model_gt: str
        """

        self._model_gt = model_gt

    @property
    def model_gte(self):
        """Gets the model_gte of this HostWhereInput.  # noqa: E501


        :return: The model_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_gte

    @model_gte.setter
    def model_gte(self, model_gte):
        """Sets the model_gte of this HostWhereInput.


        :param model_gte: The model_gte of this HostWhereInput.  # noqa: E501
        :type model_gte: str
        """

        self._model_gte = model_gte

    @property
    def model_in(self):
        """Gets the model_in of this HostWhereInput.  # noqa: E501


        :return: The model_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._model_in

    @model_in.setter
    def model_in(self, model_in):
        """Sets the model_in of this HostWhereInput.


        :param model_in: The model_in of this HostWhereInput.  # noqa: E501
        :type model_in: list[str]
        """

        self._model_in = model_in

    @property
    def model_lt(self):
        """Gets the model_lt of this HostWhereInput.  # noqa: E501


        :return: The model_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_lt

    @model_lt.setter
    def model_lt(self, model_lt):
        """Sets the model_lt of this HostWhereInput.


        :param model_lt: The model_lt of this HostWhereInput.  # noqa: E501
        :type model_lt: str
        """

        self._model_lt = model_lt

    @property
    def model_lte(self):
        """Gets the model_lte of this HostWhereInput.  # noqa: E501


        :return: The model_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_lte

    @model_lte.setter
    def model_lte(self, model_lte):
        """Sets the model_lte of this HostWhereInput.


        :param model_lte: The model_lte of this HostWhereInput.  # noqa: E501
        :type model_lte: str
        """

        self._model_lte = model_lte

    @property
    def model_not(self):
        """Gets the model_not of this HostWhereInput.  # noqa: E501


        :return: The model_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not

    @model_not.setter
    def model_not(self, model_not):
        """Sets the model_not of this HostWhereInput.


        :param model_not: The model_not of this HostWhereInput.  # noqa: E501
        :type model_not: str
        """

        self._model_not = model_not

    @property
    def model_not_contains(self):
        """Gets the model_not_contains of this HostWhereInput.  # noqa: E501


        :return: The model_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_contains

    @model_not_contains.setter
    def model_not_contains(self, model_not_contains):
        """Sets the model_not_contains of this HostWhereInput.


        :param model_not_contains: The model_not_contains of this HostWhereInput.  # noqa: E501
        :type model_not_contains: str
        """

        self._model_not_contains = model_not_contains

    @property
    def model_not_ends_with(self):
        """Gets the model_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The model_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_ends_with

    @model_not_ends_with.setter
    def model_not_ends_with(self, model_not_ends_with):
        """Sets the model_not_ends_with of this HostWhereInput.


        :param model_not_ends_with: The model_not_ends_with of this HostWhereInput.  # noqa: E501
        :type model_not_ends_with: str
        """

        self._model_not_ends_with = model_not_ends_with

    @property
    def model_not_in(self):
        """Gets the model_not_in of this HostWhereInput.  # noqa: E501


        :return: The model_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._model_not_in

    @model_not_in.setter
    def model_not_in(self, model_not_in):
        """Sets the model_not_in of this HostWhereInput.


        :param model_not_in: The model_not_in of this HostWhereInput.  # noqa: E501
        :type model_not_in: list[str]
        """

        self._model_not_in = model_not_in

    @property
    def model_not_starts_with(self):
        """Gets the model_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The model_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_not_starts_with

    @model_not_starts_with.setter
    def model_not_starts_with(self, model_not_starts_with):
        """Sets the model_not_starts_with of this HostWhereInput.


        :param model_not_starts_with: The model_not_starts_with of this HostWhereInput.  # noqa: E501
        :type model_not_starts_with: str
        """

        self._model_not_starts_with = model_not_starts_with

    @property
    def model_starts_with(self):
        """Gets the model_starts_with of this HostWhereInput.  # noqa: E501


        :return: The model_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._model_starts_with

    @model_starts_with.setter
    def model_starts_with(self, model_starts_with):
        """Sets the model_starts_with of this HostWhereInput.


        :param model_starts_with: The model_starts_with of this HostWhereInput.  # noqa: E501
        :type model_starts_with: str
        """

        self._model_starts_with = model_starts_with

    @property
    def name(self):
        """Gets the name of this HostWhereInput.  # noqa: E501


        :return: The name of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HostWhereInput.


        :param name: The name of this HostWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this HostWhereInput.  # noqa: E501


        :return: The name_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this HostWhereInput.


        :param name_contains: The name_contains of this HostWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this HostWhereInput.  # noqa: E501


        :return: The name_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this HostWhereInput.


        :param name_ends_with: The name_ends_with of this HostWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this HostWhereInput.  # noqa: E501


        :return: The name_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this HostWhereInput.


        :param name_gt: The name_gt of this HostWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this HostWhereInput.  # noqa: E501


        :return: The name_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this HostWhereInput.


        :param name_gte: The name_gte of this HostWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this HostWhereInput.  # noqa: E501


        :return: The name_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this HostWhereInput.


        :param name_in: The name_in of this HostWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this HostWhereInput.  # noqa: E501


        :return: The name_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this HostWhereInput.


        :param name_lt: The name_lt of this HostWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this HostWhereInput.  # noqa: E501


        :return: The name_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this HostWhereInput.


        :param name_lte: The name_lte of this HostWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this HostWhereInput.  # noqa: E501


        :return: The name_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this HostWhereInput.


        :param name_not: The name_not of this HostWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this HostWhereInput.  # noqa: E501


        :return: The name_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this HostWhereInput.


        :param name_not_contains: The name_not_contains of this HostWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this HostWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this HostWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this HostWhereInput.  # noqa: E501


        :return: The name_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this HostWhereInput.


        :param name_not_in: The name_not_in of this HostWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this HostWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this HostWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this HostWhereInput.  # noqa: E501


        :return: The name_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this HostWhereInput.


        :param name_starts_with: The name_starts_with of this HostWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def nested_virtualization(self):
        """Gets the nested_virtualization of this HostWhereInput.  # noqa: E501


        :return: The nested_virtualization of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._nested_virtualization

    @nested_virtualization.setter
    def nested_virtualization(self, nested_virtualization):
        """Sets the nested_virtualization of this HostWhereInput.


        :param nested_virtualization: The nested_virtualization of this HostWhereInput.  # noqa: E501
        :type nested_virtualization: bool
        """

        self._nested_virtualization = nested_virtualization

    @property
    def nested_virtualization_not(self):
        """Gets the nested_virtualization_not of this HostWhereInput.  # noqa: E501


        :return: The nested_virtualization_not of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._nested_virtualization_not

    @nested_virtualization_not.setter
    def nested_virtualization_not(self, nested_virtualization_not):
        """Sets the nested_virtualization_not of this HostWhereInput.


        :param nested_virtualization_not: The nested_virtualization_not of this HostWhereInput.  # noqa: E501
        :type nested_virtualization_not: bool
        """

        self._nested_virtualization_not = nested_virtualization_not

    @property
    def nic_count(self):
        """Gets the nic_count of this HostWhereInput.  # noqa: E501


        :return: The nic_count of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count

    @nic_count.setter
    def nic_count(self, nic_count):
        """Sets the nic_count of this HostWhereInput.


        :param nic_count: The nic_count of this HostWhereInput.  # noqa: E501
        :type nic_count: int
        """

        self._nic_count = nic_count

    @property
    def nic_count_gt(self):
        """Gets the nic_count_gt of this HostWhereInput.  # noqa: E501


        :return: The nic_count_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count_gt

    @nic_count_gt.setter
    def nic_count_gt(self, nic_count_gt):
        """Sets the nic_count_gt of this HostWhereInput.


        :param nic_count_gt: The nic_count_gt of this HostWhereInput.  # noqa: E501
        :type nic_count_gt: int
        """

        self._nic_count_gt = nic_count_gt

    @property
    def nic_count_gte(self):
        """Gets the nic_count_gte of this HostWhereInput.  # noqa: E501


        :return: The nic_count_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count_gte

    @nic_count_gte.setter
    def nic_count_gte(self, nic_count_gte):
        """Sets the nic_count_gte of this HostWhereInput.


        :param nic_count_gte: The nic_count_gte of this HostWhereInput.  # noqa: E501
        :type nic_count_gte: int
        """

        self._nic_count_gte = nic_count_gte

    @property
    def nic_count_in(self):
        """Gets the nic_count_in of this HostWhereInput.  # noqa: E501


        :return: The nic_count_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._nic_count_in

    @nic_count_in.setter
    def nic_count_in(self, nic_count_in):
        """Sets the nic_count_in of this HostWhereInput.


        :param nic_count_in: The nic_count_in of this HostWhereInput.  # noqa: E501
        :type nic_count_in: list[int]
        """

        self._nic_count_in = nic_count_in

    @property
    def nic_count_lt(self):
        """Gets the nic_count_lt of this HostWhereInput.  # noqa: E501


        :return: The nic_count_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count_lt

    @nic_count_lt.setter
    def nic_count_lt(self, nic_count_lt):
        """Sets the nic_count_lt of this HostWhereInput.


        :param nic_count_lt: The nic_count_lt of this HostWhereInput.  # noqa: E501
        :type nic_count_lt: int
        """

        self._nic_count_lt = nic_count_lt

    @property
    def nic_count_lte(self):
        """Gets the nic_count_lte of this HostWhereInput.  # noqa: E501


        :return: The nic_count_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count_lte

    @nic_count_lte.setter
    def nic_count_lte(self, nic_count_lte):
        """Sets the nic_count_lte of this HostWhereInput.


        :param nic_count_lte: The nic_count_lte of this HostWhereInput.  # noqa: E501
        :type nic_count_lte: int
        """

        self._nic_count_lte = nic_count_lte

    @property
    def nic_count_not(self):
        """Gets the nic_count_not of this HostWhereInput.  # noqa: E501


        :return: The nic_count_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._nic_count_not

    @nic_count_not.setter
    def nic_count_not(self, nic_count_not):
        """Sets the nic_count_not of this HostWhereInput.


        :param nic_count_not: The nic_count_not of this HostWhereInput.  # noqa: E501
        :type nic_count_not: int
        """

        self._nic_count_not = nic_count_not

    @property
    def nic_count_not_in(self):
        """Gets the nic_count_not_in of this HostWhereInput.  # noqa: E501


        :return: The nic_count_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._nic_count_not_in

    @nic_count_not_in.setter
    def nic_count_not_in(self, nic_count_not_in):
        """Sets the nic_count_not_in of this HostWhereInput.


        :param nic_count_not_in: The nic_count_not_in of this HostWhereInput.  # noqa: E501
        :type nic_count_not_in: list[int]
        """

        self._nic_count_not_in = nic_count_not_in

    @property
    def nics_every(self):
        """Gets the nics_every of this HostWhereInput.  # noqa: E501


        :return: The nics_every of this HostWhereInput.  # noqa: E501
        :rtype: NicWhereInput
        """
        return self._nics_every

    @nics_every.setter
    def nics_every(self, nics_every):
        """Sets the nics_every of this HostWhereInput.


        :param nics_every: The nics_every of this HostWhereInput.  # noqa: E501
        :type nics_every: NicWhereInput
        """

        self._nics_every = nics_every

    @property
    def nics_none(self):
        """Gets the nics_none of this HostWhereInput.  # noqa: E501


        :return: The nics_none of this HostWhereInput.  # noqa: E501
        :rtype: NicWhereInput
        """
        return self._nics_none

    @nics_none.setter
    def nics_none(self, nics_none):
        """Sets the nics_none of this HostWhereInput.


        :param nics_none: The nics_none of this HostWhereInput.  # noqa: E501
        :type nics_none: NicWhereInput
        """

        self._nics_none = nics_none

    @property
    def nics_some(self):
        """Gets the nics_some of this HostWhereInput.  # noqa: E501


        :return: The nics_some of this HostWhereInput.  # noqa: E501
        :rtype: NicWhereInput
        """
        return self._nics_some

    @nics_some.setter
    def nics_some(self, nics_some):
        """Sets the nics_some of this HostWhereInput.


        :param nics_some: The nics_some of this HostWhereInput.  # noqa: E501
        :type nics_some: NicWhereInput
        """

        self._nics_some = nics_some

    @property
    def node_topo_local_id(self):
        """Gets the node_topo_local_id of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id

    @node_topo_local_id.setter
    def node_topo_local_id(self, node_topo_local_id):
        """Sets the node_topo_local_id of this HostWhereInput.


        :param node_topo_local_id: The node_topo_local_id of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id: str
        """

        self._node_topo_local_id = node_topo_local_id

    @property
    def node_topo_local_id_contains(self):
        """Gets the node_topo_local_id_contains of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_contains

    @node_topo_local_id_contains.setter
    def node_topo_local_id_contains(self, node_topo_local_id_contains):
        """Sets the node_topo_local_id_contains of this HostWhereInput.


        :param node_topo_local_id_contains: The node_topo_local_id_contains of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_contains: str
        """

        self._node_topo_local_id_contains = node_topo_local_id_contains

    @property
    def node_topo_local_id_ends_with(self):
        """Gets the node_topo_local_id_ends_with of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_ends_with

    @node_topo_local_id_ends_with.setter
    def node_topo_local_id_ends_with(self, node_topo_local_id_ends_with):
        """Sets the node_topo_local_id_ends_with of this HostWhereInput.


        :param node_topo_local_id_ends_with: The node_topo_local_id_ends_with of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_ends_with: str
        """

        self._node_topo_local_id_ends_with = node_topo_local_id_ends_with

    @property
    def node_topo_local_id_gt(self):
        """Gets the node_topo_local_id_gt of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_gt

    @node_topo_local_id_gt.setter
    def node_topo_local_id_gt(self, node_topo_local_id_gt):
        """Sets the node_topo_local_id_gt of this HostWhereInput.


        :param node_topo_local_id_gt: The node_topo_local_id_gt of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_gt: str
        """

        self._node_topo_local_id_gt = node_topo_local_id_gt

    @property
    def node_topo_local_id_gte(self):
        """Gets the node_topo_local_id_gte of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_gte

    @node_topo_local_id_gte.setter
    def node_topo_local_id_gte(self, node_topo_local_id_gte):
        """Sets the node_topo_local_id_gte of this HostWhereInput.


        :param node_topo_local_id_gte: The node_topo_local_id_gte of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_gte: str
        """

        self._node_topo_local_id_gte = node_topo_local_id_gte

    @property
    def node_topo_local_id_in(self):
        """Gets the node_topo_local_id_in of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._node_topo_local_id_in

    @node_topo_local_id_in.setter
    def node_topo_local_id_in(self, node_topo_local_id_in):
        """Sets the node_topo_local_id_in of this HostWhereInput.


        :param node_topo_local_id_in: The node_topo_local_id_in of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_in: list[str]
        """

        self._node_topo_local_id_in = node_topo_local_id_in

    @property
    def node_topo_local_id_lt(self):
        """Gets the node_topo_local_id_lt of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_lt

    @node_topo_local_id_lt.setter
    def node_topo_local_id_lt(self, node_topo_local_id_lt):
        """Sets the node_topo_local_id_lt of this HostWhereInput.


        :param node_topo_local_id_lt: The node_topo_local_id_lt of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_lt: str
        """

        self._node_topo_local_id_lt = node_topo_local_id_lt

    @property
    def node_topo_local_id_lte(self):
        """Gets the node_topo_local_id_lte of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_lte

    @node_topo_local_id_lte.setter
    def node_topo_local_id_lte(self, node_topo_local_id_lte):
        """Sets the node_topo_local_id_lte of this HostWhereInput.


        :param node_topo_local_id_lte: The node_topo_local_id_lte of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_lte: str
        """

        self._node_topo_local_id_lte = node_topo_local_id_lte

    @property
    def node_topo_local_id_not(self):
        """Gets the node_topo_local_id_not of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_not

    @node_topo_local_id_not.setter
    def node_topo_local_id_not(self, node_topo_local_id_not):
        """Sets the node_topo_local_id_not of this HostWhereInput.


        :param node_topo_local_id_not: The node_topo_local_id_not of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_not: str
        """

        self._node_topo_local_id_not = node_topo_local_id_not

    @property
    def node_topo_local_id_not_contains(self):
        """Gets the node_topo_local_id_not_contains of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_not_contains

    @node_topo_local_id_not_contains.setter
    def node_topo_local_id_not_contains(self, node_topo_local_id_not_contains):
        """Sets the node_topo_local_id_not_contains of this HostWhereInput.


        :param node_topo_local_id_not_contains: The node_topo_local_id_not_contains of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_not_contains: str
        """

        self._node_topo_local_id_not_contains = node_topo_local_id_not_contains

    @property
    def node_topo_local_id_not_ends_with(self):
        """Gets the node_topo_local_id_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_not_ends_with

    @node_topo_local_id_not_ends_with.setter
    def node_topo_local_id_not_ends_with(self, node_topo_local_id_not_ends_with):
        """Sets the node_topo_local_id_not_ends_with of this HostWhereInput.


        :param node_topo_local_id_not_ends_with: The node_topo_local_id_not_ends_with of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_not_ends_with: str
        """

        self._node_topo_local_id_not_ends_with = node_topo_local_id_not_ends_with

    @property
    def node_topo_local_id_not_in(self):
        """Gets the node_topo_local_id_not_in of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._node_topo_local_id_not_in

    @node_topo_local_id_not_in.setter
    def node_topo_local_id_not_in(self, node_topo_local_id_not_in):
        """Sets the node_topo_local_id_not_in of this HostWhereInput.


        :param node_topo_local_id_not_in: The node_topo_local_id_not_in of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_not_in: list[str]
        """

        self._node_topo_local_id_not_in = node_topo_local_id_not_in

    @property
    def node_topo_local_id_not_starts_with(self):
        """Gets the node_topo_local_id_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_not_starts_with

    @node_topo_local_id_not_starts_with.setter
    def node_topo_local_id_not_starts_with(self, node_topo_local_id_not_starts_with):
        """Sets the node_topo_local_id_not_starts_with of this HostWhereInput.


        :param node_topo_local_id_not_starts_with: The node_topo_local_id_not_starts_with of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_not_starts_with: str
        """

        self._node_topo_local_id_not_starts_with = node_topo_local_id_not_starts_with

    @property
    def node_topo_local_id_starts_with(self):
        """Gets the node_topo_local_id_starts_with of this HostWhereInput.  # noqa: E501


        :return: The node_topo_local_id_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id_starts_with

    @node_topo_local_id_starts_with.setter
    def node_topo_local_id_starts_with(self, node_topo_local_id_starts_with):
        """Sets the node_topo_local_id_starts_with of this HostWhereInput.


        :param node_topo_local_id_starts_with: The node_topo_local_id_starts_with of this HostWhereInput.  # noqa: E501
        :type node_topo_local_id_starts_with: str
        """

        self._node_topo_local_id_starts_with = node_topo_local_id_starts_with

    @property
    def os_memory_bytes(self):
        """Gets the os_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes

    @os_memory_bytes.setter
    def os_memory_bytes(self, os_memory_bytes):
        """Sets the os_memory_bytes of this HostWhereInput.


        :param os_memory_bytes: The os_memory_bytes of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes: int
        """

        self._os_memory_bytes = os_memory_bytes

    @property
    def os_memory_bytes_gt(self):
        """Gets the os_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes_gt

    @os_memory_bytes_gt.setter
    def os_memory_bytes_gt(self, os_memory_bytes_gt):
        """Sets the os_memory_bytes_gt of this HostWhereInput.


        :param os_memory_bytes_gt: The os_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_gt: int
        """

        self._os_memory_bytes_gt = os_memory_bytes_gt

    @property
    def os_memory_bytes_gte(self):
        """Gets the os_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes_gte

    @os_memory_bytes_gte.setter
    def os_memory_bytes_gte(self, os_memory_bytes_gte):
        """Sets the os_memory_bytes_gte of this HostWhereInput.


        :param os_memory_bytes_gte: The os_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_gte: int
        """

        self._os_memory_bytes_gte = os_memory_bytes_gte

    @property
    def os_memory_bytes_in(self):
        """Gets the os_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._os_memory_bytes_in

    @os_memory_bytes_in.setter
    def os_memory_bytes_in(self, os_memory_bytes_in):
        """Sets the os_memory_bytes_in of this HostWhereInput.


        :param os_memory_bytes_in: The os_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_in: list[int]
        """

        self._os_memory_bytes_in = os_memory_bytes_in

    @property
    def os_memory_bytes_lt(self):
        """Gets the os_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes_lt

    @os_memory_bytes_lt.setter
    def os_memory_bytes_lt(self, os_memory_bytes_lt):
        """Sets the os_memory_bytes_lt of this HostWhereInput.


        :param os_memory_bytes_lt: The os_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_lt: int
        """

        self._os_memory_bytes_lt = os_memory_bytes_lt

    @property
    def os_memory_bytes_lte(self):
        """Gets the os_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes_lte

    @os_memory_bytes_lte.setter
    def os_memory_bytes_lte(self, os_memory_bytes_lte):
        """Sets the os_memory_bytes_lte of this HostWhereInput.


        :param os_memory_bytes_lte: The os_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_lte: int
        """

        self._os_memory_bytes_lte = os_memory_bytes_lte

    @property
    def os_memory_bytes_not(self):
        """Gets the os_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes_not

    @os_memory_bytes_not.setter
    def os_memory_bytes_not(self, os_memory_bytes_not):
        """Sets the os_memory_bytes_not of this HostWhereInput.


        :param os_memory_bytes_not: The os_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_not: int
        """

        self._os_memory_bytes_not = os_memory_bytes_not

    @property
    def os_memory_bytes_not_in(self):
        """Gets the os_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The os_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._os_memory_bytes_not_in

    @os_memory_bytes_not_in.setter
    def os_memory_bytes_not_in(self, os_memory_bytes_not_in):
        """Sets the os_memory_bytes_not_in of this HostWhereInput.


        :param os_memory_bytes_not_in: The os_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type os_memory_bytes_not_in: list[int]
        """

        self._os_memory_bytes_not_in = os_memory_bytes_not_in

    @property
    def os_version(self):
        """Gets the os_version of this HostWhereInput.  # noqa: E501


        :return: The os_version of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """Sets the os_version of this HostWhereInput.


        :param os_version: The os_version of this HostWhereInput.  # noqa: E501
        :type os_version: str
        """

        self._os_version = os_version

    @property
    def os_version_contains(self):
        """Gets the os_version_contains of this HostWhereInput.  # noqa: E501


        :return: The os_version_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_contains

    @os_version_contains.setter
    def os_version_contains(self, os_version_contains):
        """Sets the os_version_contains of this HostWhereInput.


        :param os_version_contains: The os_version_contains of this HostWhereInput.  # noqa: E501
        :type os_version_contains: str
        """

        self._os_version_contains = os_version_contains

    @property
    def os_version_ends_with(self):
        """Gets the os_version_ends_with of this HostWhereInput.  # noqa: E501


        :return: The os_version_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_ends_with

    @os_version_ends_with.setter
    def os_version_ends_with(self, os_version_ends_with):
        """Sets the os_version_ends_with of this HostWhereInput.


        :param os_version_ends_with: The os_version_ends_with of this HostWhereInput.  # noqa: E501
        :type os_version_ends_with: str
        """

        self._os_version_ends_with = os_version_ends_with

    @property
    def os_version_gt(self):
        """Gets the os_version_gt of this HostWhereInput.  # noqa: E501


        :return: The os_version_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_gt

    @os_version_gt.setter
    def os_version_gt(self, os_version_gt):
        """Sets the os_version_gt of this HostWhereInput.


        :param os_version_gt: The os_version_gt of this HostWhereInput.  # noqa: E501
        :type os_version_gt: str
        """

        self._os_version_gt = os_version_gt

    @property
    def os_version_gte(self):
        """Gets the os_version_gte of this HostWhereInput.  # noqa: E501


        :return: The os_version_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_gte

    @os_version_gte.setter
    def os_version_gte(self, os_version_gte):
        """Sets the os_version_gte of this HostWhereInput.


        :param os_version_gte: The os_version_gte of this HostWhereInput.  # noqa: E501
        :type os_version_gte: str
        """

        self._os_version_gte = os_version_gte

    @property
    def os_version_in(self):
        """Gets the os_version_in of this HostWhereInput.  # noqa: E501


        :return: The os_version_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._os_version_in

    @os_version_in.setter
    def os_version_in(self, os_version_in):
        """Sets the os_version_in of this HostWhereInput.


        :param os_version_in: The os_version_in of this HostWhereInput.  # noqa: E501
        :type os_version_in: list[str]
        """

        self._os_version_in = os_version_in

    @property
    def os_version_lt(self):
        """Gets the os_version_lt of this HostWhereInput.  # noqa: E501


        :return: The os_version_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_lt

    @os_version_lt.setter
    def os_version_lt(self, os_version_lt):
        """Sets the os_version_lt of this HostWhereInput.


        :param os_version_lt: The os_version_lt of this HostWhereInput.  # noqa: E501
        :type os_version_lt: str
        """

        self._os_version_lt = os_version_lt

    @property
    def os_version_lte(self):
        """Gets the os_version_lte of this HostWhereInput.  # noqa: E501


        :return: The os_version_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_lte

    @os_version_lte.setter
    def os_version_lte(self, os_version_lte):
        """Sets the os_version_lte of this HostWhereInput.


        :param os_version_lte: The os_version_lte of this HostWhereInput.  # noqa: E501
        :type os_version_lte: str
        """

        self._os_version_lte = os_version_lte

    @property
    def os_version_not(self):
        """Gets the os_version_not of this HostWhereInput.  # noqa: E501


        :return: The os_version_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_not

    @os_version_not.setter
    def os_version_not(self, os_version_not):
        """Sets the os_version_not of this HostWhereInput.


        :param os_version_not: The os_version_not of this HostWhereInput.  # noqa: E501
        :type os_version_not: str
        """

        self._os_version_not = os_version_not

    @property
    def os_version_not_contains(self):
        """Gets the os_version_not_contains of this HostWhereInput.  # noqa: E501


        :return: The os_version_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_not_contains

    @os_version_not_contains.setter
    def os_version_not_contains(self, os_version_not_contains):
        """Sets the os_version_not_contains of this HostWhereInput.


        :param os_version_not_contains: The os_version_not_contains of this HostWhereInput.  # noqa: E501
        :type os_version_not_contains: str
        """

        self._os_version_not_contains = os_version_not_contains

    @property
    def os_version_not_ends_with(self):
        """Gets the os_version_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The os_version_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_not_ends_with

    @os_version_not_ends_with.setter
    def os_version_not_ends_with(self, os_version_not_ends_with):
        """Sets the os_version_not_ends_with of this HostWhereInput.


        :param os_version_not_ends_with: The os_version_not_ends_with of this HostWhereInput.  # noqa: E501
        :type os_version_not_ends_with: str
        """

        self._os_version_not_ends_with = os_version_not_ends_with

    @property
    def os_version_not_in(self):
        """Gets the os_version_not_in of this HostWhereInput.  # noqa: E501


        :return: The os_version_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._os_version_not_in

    @os_version_not_in.setter
    def os_version_not_in(self, os_version_not_in):
        """Sets the os_version_not_in of this HostWhereInput.


        :param os_version_not_in: The os_version_not_in of this HostWhereInput.  # noqa: E501
        :type os_version_not_in: list[str]
        """

        self._os_version_not_in = os_version_not_in

    @property
    def os_version_not_starts_with(self):
        """Gets the os_version_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The os_version_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_not_starts_with

    @os_version_not_starts_with.setter
    def os_version_not_starts_with(self, os_version_not_starts_with):
        """Sets the os_version_not_starts_with of this HostWhereInput.


        :param os_version_not_starts_with: The os_version_not_starts_with of this HostWhereInput.  # noqa: E501
        :type os_version_not_starts_with: str
        """

        self._os_version_not_starts_with = os_version_not_starts_with

    @property
    def os_version_starts_with(self):
        """Gets the os_version_starts_with of this HostWhereInput.  # noqa: E501


        :return: The os_version_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._os_version_starts_with

    @os_version_starts_with.setter
    def os_version_starts_with(self, os_version_starts_with):
        """Sets the os_version_starts_with of this HostWhereInput.


        :param os_version_starts_with: The os_version_starts_with of this HostWhereInput.  # noqa: E501
        :type os_version_starts_with: str
        """

        self._os_version_starts_with = os_version_starts_with

    @property
    def perf_allocated_data_space(self):
        """Gets the perf_allocated_data_space of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space

    @perf_allocated_data_space.setter
    def perf_allocated_data_space(self, perf_allocated_data_space):
        """Sets the perf_allocated_data_space of this HostWhereInput.


        :param perf_allocated_data_space: The perf_allocated_data_space of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space: int
        """

        self._perf_allocated_data_space = perf_allocated_data_space

    @property
    def perf_allocated_data_space_gt(self):
        """Gets the perf_allocated_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_gt

    @perf_allocated_data_space_gt.setter
    def perf_allocated_data_space_gt(self, perf_allocated_data_space_gt):
        """Sets the perf_allocated_data_space_gt of this HostWhereInput.


        :param perf_allocated_data_space_gt: The perf_allocated_data_space_gt of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_gt: int
        """

        self._perf_allocated_data_space_gt = perf_allocated_data_space_gt

    @property
    def perf_allocated_data_space_gte(self):
        """Gets the perf_allocated_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_gte

    @perf_allocated_data_space_gte.setter
    def perf_allocated_data_space_gte(self, perf_allocated_data_space_gte):
        """Sets the perf_allocated_data_space_gte of this HostWhereInput.


        :param perf_allocated_data_space_gte: The perf_allocated_data_space_gte of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_gte: int
        """

        self._perf_allocated_data_space_gte = perf_allocated_data_space_gte

    @property
    def perf_allocated_data_space_in(self):
        """Gets the perf_allocated_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_allocated_data_space_in

    @perf_allocated_data_space_in.setter
    def perf_allocated_data_space_in(self, perf_allocated_data_space_in):
        """Sets the perf_allocated_data_space_in of this HostWhereInput.


        :param perf_allocated_data_space_in: The perf_allocated_data_space_in of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_in: list[int]
        """

        self._perf_allocated_data_space_in = perf_allocated_data_space_in

    @property
    def perf_allocated_data_space_lt(self):
        """Gets the perf_allocated_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_lt

    @perf_allocated_data_space_lt.setter
    def perf_allocated_data_space_lt(self, perf_allocated_data_space_lt):
        """Sets the perf_allocated_data_space_lt of this HostWhereInput.


        :param perf_allocated_data_space_lt: The perf_allocated_data_space_lt of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_lt: int
        """

        self._perf_allocated_data_space_lt = perf_allocated_data_space_lt

    @property
    def perf_allocated_data_space_lte(self):
        """Gets the perf_allocated_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_lte

    @perf_allocated_data_space_lte.setter
    def perf_allocated_data_space_lte(self, perf_allocated_data_space_lte):
        """Sets the perf_allocated_data_space_lte of this HostWhereInput.


        :param perf_allocated_data_space_lte: The perf_allocated_data_space_lte of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_lte: int
        """

        self._perf_allocated_data_space_lte = perf_allocated_data_space_lte

    @property
    def perf_allocated_data_space_not(self):
        """Gets the perf_allocated_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_allocated_data_space_not

    @perf_allocated_data_space_not.setter
    def perf_allocated_data_space_not(self, perf_allocated_data_space_not):
        """Sets the perf_allocated_data_space_not of this HostWhereInput.


        :param perf_allocated_data_space_not: The perf_allocated_data_space_not of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_not: int
        """

        self._perf_allocated_data_space_not = perf_allocated_data_space_not

    @property
    def perf_allocated_data_space_not_in(self):
        """Gets the perf_allocated_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The perf_allocated_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_allocated_data_space_not_in

    @perf_allocated_data_space_not_in.setter
    def perf_allocated_data_space_not_in(self, perf_allocated_data_space_not_in):
        """Sets the perf_allocated_data_space_not_in of this HostWhereInput.


        :param perf_allocated_data_space_not_in: The perf_allocated_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type perf_allocated_data_space_not_in: list[int]
        """

        self._perf_allocated_data_space_not_in = perf_allocated_data_space_not_in

    @property
    def perf_failure_data_space(self):
        """Gets the perf_failure_data_space of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space

    @perf_failure_data_space.setter
    def perf_failure_data_space(self, perf_failure_data_space):
        """Sets the perf_failure_data_space of this HostWhereInput.


        :param perf_failure_data_space: The perf_failure_data_space of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space: int
        """

        self._perf_failure_data_space = perf_failure_data_space

    @property
    def perf_failure_data_space_gt(self):
        """Gets the perf_failure_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_gt

    @perf_failure_data_space_gt.setter
    def perf_failure_data_space_gt(self, perf_failure_data_space_gt):
        """Sets the perf_failure_data_space_gt of this HostWhereInput.


        :param perf_failure_data_space_gt: The perf_failure_data_space_gt of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_gt: int
        """

        self._perf_failure_data_space_gt = perf_failure_data_space_gt

    @property
    def perf_failure_data_space_gte(self):
        """Gets the perf_failure_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_gte

    @perf_failure_data_space_gte.setter
    def perf_failure_data_space_gte(self, perf_failure_data_space_gte):
        """Sets the perf_failure_data_space_gte of this HostWhereInput.


        :param perf_failure_data_space_gte: The perf_failure_data_space_gte of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_gte: int
        """

        self._perf_failure_data_space_gte = perf_failure_data_space_gte

    @property
    def perf_failure_data_space_in(self):
        """Gets the perf_failure_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_failure_data_space_in

    @perf_failure_data_space_in.setter
    def perf_failure_data_space_in(self, perf_failure_data_space_in):
        """Sets the perf_failure_data_space_in of this HostWhereInput.


        :param perf_failure_data_space_in: The perf_failure_data_space_in of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_in: list[int]
        """

        self._perf_failure_data_space_in = perf_failure_data_space_in

    @property
    def perf_failure_data_space_lt(self):
        """Gets the perf_failure_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_lt

    @perf_failure_data_space_lt.setter
    def perf_failure_data_space_lt(self, perf_failure_data_space_lt):
        """Sets the perf_failure_data_space_lt of this HostWhereInput.


        :param perf_failure_data_space_lt: The perf_failure_data_space_lt of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_lt: int
        """

        self._perf_failure_data_space_lt = perf_failure_data_space_lt

    @property
    def perf_failure_data_space_lte(self):
        """Gets the perf_failure_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_lte

    @perf_failure_data_space_lte.setter
    def perf_failure_data_space_lte(self, perf_failure_data_space_lte):
        """Sets the perf_failure_data_space_lte of this HostWhereInput.


        :param perf_failure_data_space_lte: The perf_failure_data_space_lte of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_lte: int
        """

        self._perf_failure_data_space_lte = perf_failure_data_space_lte

    @property
    def perf_failure_data_space_not(self):
        """Gets the perf_failure_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_failure_data_space_not

    @perf_failure_data_space_not.setter
    def perf_failure_data_space_not(self, perf_failure_data_space_not):
        """Sets the perf_failure_data_space_not of this HostWhereInput.


        :param perf_failure_data_space_not: The perf_failure_data_space_not of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_not: int
        """

        self._perf_failure_data_space_not = perf_failure_data_space_not

    @property
    def perf_failure_data_space_not_in(self):
        """Gets the perf_failure_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The perf_failure_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_failure_data_space_not_in

    @perf_failure_data_space_not_in.setter
    def perf_failure_data_space_not_in(self, perf_failure_data_space_not_in):
        """Sets the perf_failure_data_space_not_in of this HostWhereInput.


        :param perf_failure_data_space_not_in: The perf_failure_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type perf_failure_data_space_not_in: list[int]
        """

        self._perf_failure_data_space_not_in = perf_failure_data_space_not_in

    @property
    def perf_total_data_capacity(self):
        """Gets the perf_total_data_capacity of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity

    @perf_total_data_capacity.setter
    def perf_total_data_capacity(self, perf_total_data_capacity):
        """Sets the perf_total_data_capacity of this HostWhereInput.


        :param perf_total_data_capacity: The perf_total_data_capacity of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity: int
        """

        self._perf_total_data_capacity = perf_total_data_capacity

    @property
    def perf_total_data_capacity_gt(self):
        """Gets the perf_total_data_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_gt

    @perf_total_data_capacity_gt.setter
    def perf_total_data_capacity_gt(self, perf_total_data_capacity_gt):
        """Sets the perf_total_data_capacity_gt of this HostWhereInput.


        :param perf_total_data_capacity_gt: The perf_total_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_gt: int
        """

        self._perf_total_data_capacity_gt = perf_total_data_capacity_gt

    @property
    def perf_total_data_capacity_gte(self):
        """Gets the perf_total_data_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_gte

    @perf_total_data_capacity_gte.setter
    def perf_total_data_capacity_gte(self, perf_total_data_capacity_gte):
        """Sets the perf_total_data_capacity_gte of this HostWhereInput.


        :param perf_total_data_capacity_gte: The perf_total_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_gte: int
        """

        self._perf_total_data_capacity_gte = perf_total_data_capacity_gte

    @property
    def perf_total_data_capacity_in(self):
        """Gets the perf_total_data_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_total_data_capacity_in

    @perf_total_data_capacity_in.setter
    def perf_total_data_capacity_in(self, perf_total_data_capacity_in):
        """Sets the perf_total_data_capacity_in of this HostWhereInput.


        :param perf_total_data_capacity_in: The perf_total_data_capacity_in of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_in: list[int]
        """

        self._perf_total_data_capacity_in = perf_total_data_capacity_in

    @property
    def perf_total_data_capacity_lt(self):
        """Gets the perf_total_data_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_lt

    @perf_total_data_capacity_lt.setter
    def perf_total_data_capacity_lt(self, perf_total_data_capacity_lt):
        """Sets the perf_total_data_capacity_lt of this HostWhereInput.


        :param perf_total_data_capacity_lt: The perf_total_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_lt: int
        """

        self._perf_total_data_capacity_lt = perf_total_data_capacity_lt

    @property
    def perf_total_data_capacity_lte(self):
        """Gets the perf_total_data_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_lte

    @perf_total_data_capacity_lte.setter
    def perf_total_data_capacity_lte(self, perf_total_data_capacity_lte):
        """Sets the perf_total_data_capacity_lte of this HostWhereInput.


        :param perf_total_data_capacity_lte: The perf_total_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_lte: int
        """

        self._perf_total_data_capacity_lte = perf_total_data_capacity_lte

    @property
    def perf_total_data_capacity_not(self):
        """Gets the perf_total_data_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_total_data_capacity_not

    @perf_total_data_capacity_not.setter
    def perf_total_data_capacity_not(self, perf_total_data_capacity_not):
        """Sets the perf_total_data_capacity_not of this HostWhereInput.


        :param perf_total_data_capacity_not: The perf_total_data_capacity_not of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_not: int
        """

        self._perf_total_data_capacity_not = perf_total_data_capacity_not

    @property
    def perf_total_data_capacity_not_in(self):
        """Gets the perf_total_data_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The perf_total_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_total_data_capacity_not_in

    @perf_total_data_capacity_not_in.setter
    def perf_total_data_capacity_not_in(self, perf_total_data_capacity_not_in):
        """Sets the perf_total_data_capacity_not_in of this HostWhereInput.


        :param perf_total_data_capacity_not_in: The perf_total_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type perf_total_data_capacity_not_in: list[int]
        """

        self._perf_total_data_capacity_not_in = perf_total_data_capacity_not_in

    @property
    def perf_used_data_space(self):
        """Gets the perf_used_data_space of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space

    @perf_used_data_space.setter
    def perf_used_data_space(self, perf_used_data_space):
        """Sets the perf_used_data_space of this HostWhereInput.


        :param perf_used_data_space: The perf_used_data_space of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space: int
        """

        self._perf_used_data_space = perf_used_data_space

    @property
    def perf_used_data_space_gt(self):
        """Gets the perf_used_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_gt

    @perf_used_data_space_gt.setter
    def perf_used_data_space_gt(self, perf_used_data_space_gt):
        """Sets the perf_used_data_space_gt of this HostWhereInput.


        :param perf_used_data_space_gt: The perf_used_data_space_gt of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_gt: int
        """

        self._perf_used_data_space_gt = perf_used_data_space_gt

    @property
    def perf_used_data_space_gte(self):
        """Gets the perf_used_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_gte

    @perf_used_data_space_gte.setter
    def perf_used_data_space_gte(self, perf_used_data_space_gte):
        """Sets the perf_used_data_space_gte of this HostWhereInput.


        :param perf_used_data_space_gte: The perf_used_data_space_gte of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_gte: int
        """

        self._perf_used_data_space_gte = perf_used_data_space_gte

    @property
    def perf_used_data_space_in(self):
        """Gets the perf_used_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_used_data_space_in

    @perf_used_data_space_in.setter
    def perf_used_data_space_in(self, perf_used_data_space_in):
        """Sets the perf_used_data_space_in of this HostWhereInput.


        :param perf_used_data_space_in: The perf_used_data_space_in of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_in: list[int]
        """

        self._perf_used_data_space_in = perf_used_data_space_in

    @property
    def perf_used_data_space_lt(self):
        """Gets the perf_used_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_lt

    @perf_used_data_space_lt.setter
    def perf_used_data_space_lt(self, perf_used_data_space_lt):
        """Sets the perf_used_data_space_lt of this HostWhereInput.


        :param perf_used_data_space_lt: The perf_used_data_space_lt of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_lt: int
        """

        self._perf_used_data_space_lt = perf_used_data_space_lt

    @property
    def perf_used_data_space_lte(self):
        """Gets the perf_used_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_lte

    @perf_used_data_space_lte.setter
    def perf_used_data_space_lte(self, perf_used_data_space_lte):
        """Sets the perf_used_data_space_lte of this HostWhereInput.


        :param perf_used_data_space_lte: The perf_used_data_space_lte of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_lte: int
        """

        self._perf_used_data_space_lte = perf_used_data_space_lte

    @property
    def perf_used_data_space_not(self):
        """Gets the perf_used_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_used_data_space_not

    @perf_used_data_space_not.setter
    def perf_used_data_space_not(self, perf_used_data_space_not):
        """Sets the perf_used_data_space_not of this HostWhereInput.


        :param perf_used_data_space_not: The perf_used_data_space_not of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_not: int
        """

        self._perf_used_data_space_not = perf_used_data_space_not

    @property
    def perf_used_data_space_not_in(self):
        """Gets the perf_used_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The perf_used_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_used_data_space_not_in

    @perf_used_data_space_not_in.setter
    def perf_used_data_space_not_in(self, perf_used_data_space_not_in):
        """Sets the perf_used_data_space_not_in of this HostWhereInput.


        :param perf_used_data_space_not_in: The perf_used_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type perf_used_data_space_not_in: list[int]
        """

        self._perf_used_data_space_not_in = perf_used_data_space_not_in

    @property
    def perf_valid_data_space(self):
        """Gets the perf_valid_data_space of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space

    @perf_valid_data_space.setter
    def perf_valid_data_space(self, perf_valid_data_space):
        """Sets the perf_valid_data_space of this HostWhereInput.


        :param perf_valid_data_space: The perf_valid_data_space of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space: int
        """

        self._perf_valid_data_space = perf_valid_data_space

    @property
    def perf_valid_data_space_gt(self):
        """Gets the perf_valid_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_gt

    @perf_valid_data_space_gt.setter
    def perf_valid_data_space_gt(self, perf_valid_data_space_gt):
        """Sets the perf_valid_data_space_gt of this HostWhereInput.


        :param perf_valid_data_space_gt: The perf_valid_data_space_gt of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_gt: int
        """

        self._perf_valid_data_space_gt = perf_valid_data_space_gt

    @property
    def perf_valid_data_space_gte(self):
        """Gets the perf_valid_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_gte

    @perf_valid_data_space_gte.setter
    def perf_valid_data_space_gte(self, perf_valid_data_space_gte):
        """Sets the perf_valid_data_space_gte of this HostWhereInput.


        :param perf_valid_data_space_gte: The perf_valid_data_space_gte of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_gte: int
        """

        self._perf_valid_data_space_gte = perf_valid_data_space_gte

    @property
    def perf_valid_data_space_in(self):
        """Gets the perf_valid_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_valid_data_space_in

    @perf_valid_data_space_in.setter
    def perf_valid_data_space_in(self, perf_valid_data_space_in):
        """Sets the perf_valid_data_space_in of this HostWhereInput.


        :param perf_valid_data_space_in: The perf_valid_data_space_in of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_in: list[int]
        """

        self._perf_valid_data_space_in = perf_valid_data_space_in

    @property
    def perf_valid_data_space_lt(self):
        """Gets the perf_valid_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_lt

    @perf_valid_data_space_lt.setter
    def perf_valid_data_space_lt(self, perf_valid_data_space_lt):
        """Sets the perf_valid_data_space_lt of this HostWhereInput.


        :param perf_valid_data_space_lt: The perf_valid_data_space_lt of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_lt: int
        """

        self._perf_valid_data_space_lt = perf_valid_data_space_lt

    @property
    def perf_valid_data_space_lte(self):
        """Gets the perf_valid_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_lte

    @perf_valid_data_space_lte.setter
    def perf_valid_data_space_lte(self, perf_valid_data_space_lte):
        """Sets the perf_valid_data_space_lte of this HostWhereInput.


        :param perf_valid_data_space_lte: The perf_valid_data_space_lte of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_lte: int
        """

        self._perf_valid_data_space_lte = perf_valid_data_space_lte

    @property
    def perf_valid_data_space_not(self):
        """Gets the perf_valid_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._perf_valid_data_space_not

    @perf_valid_data_space_not.setter
    def perf_valid_data_space_not(self, perf_valid_data_space_not):
        """Sets the perf_valid_data_space_not of this HostWhereInput.


        :param perf_valid_data_space_not: The perf_valid_data_space_not of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_not: int
        """

        self._perf_valid_data_space_not = perf_valid_data_space_not

    @property
    def perf_valid_data_space_not_in(self):
        """Gets the perf_valid_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The perf_valid_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._perf_valid_data_space_not_in

    @perf_valid_data_space_not_in.setter
    def perf_valid_data_space_not_in(self, perf_valid_data_space_not_in):
        """Sets the perf_valid_data_space_not_in of this HostWhereInput.


        :param perf_valid_data_space_not_in: The perf_valid_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type perf_valid_data_space_not_in: list[int]
        """

        self._perf_valid_data_space_not_in = perf_valid_data_space_not_in

    @property
    def planned_prioritized_space(self):
        """Gets the planned_prioritized_space of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space

    @planned_prioritized_space.setter
    def planned_prioritized_space(self, planned_prioritized_space):
        """Sets the planned_prioritized_space of this HostWhereInput.


        :param planned_prioritized_space: The planned_prioritized_space of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space: int
        """

        self._planned_prioritized_space = planned_prioritized_space

    @property
    def planned_prioritized_space_gt(self):
        """Gets the planned_prioritized_space_gt of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_gt

    @planned_prioritized_space_gt.setter
    def planned_prioritized_space_gt(self, planned_prioritized_space_gt):
        """Sets the planned_prioritized_space_gt of this HostWhereInput.


        :param planned_prioritized_space_gt: The planned_prioritized_space_gt of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_gt: int
        """

        self._planned_prioritized_space_gt = planned_prioritized_space_gt

    @property
    def planned_prioritized_space_gte(self):
        """Gets the planned_prioritized_space_gte of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_gte

    @planned_prioritized_space_gte.setter
    def planned_prioritized_space_gte(self, planned_prioritized_space_gte):
        """Sets the planned_prioritized_space_gte of this HostWhereInput.


        :param planned_prioritized_space_gte: The planned_prioritized_space_gte of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_gte: int
        """

        self._planned_prioritized_space_gte = planned_prioritized_space_gte

    @property
    def planned_prioritized_space_in(self):
        """Gets the planned_prioritized_space_in of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._planned_prioritized_space_in

    @planned_prioritized_space_in.setter
    def planned_prioritized_space_in(self, planned_prioritized_space_in):
        """Sets the planned_prioritized_space_in of this HostWhereInput.


        :param planned_prioritized_space_in: The planned_prioritized_space_in of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_in: list[int]
        """

        self._planned_prioritized_space_in = planned_prioritized_space_in

    @property
    def planned_prioritized_space_lt(self):
        """Gets the planned_prioritized_space_lt of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_lt

    @planned_prioritized_space_lt.setter
    def planned_prioritized_space_lt(self, planned_prioritized_space_lt):
        """Sets the planned_prioritized_space_lt of this HostWhereInput.


        :param planned_prioritized_space_lt: The planned_prioritized_space_lt of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_lt: int
        """

        self._planned_prioritized_space_lt = planned_prioritized_space_lt

    @property
    def planned_prioritized_space_lte(self):
        """Gets the planned_prioritized_space_lte of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_lte

    @planned_prioritized_space_lte.setter
    def planned_prioritized_space_lte(self, planned_prioritized_space_lte):
        """Sets the planned_prioritized_space_lte of this HostWhereInput.


        :param planned_prioritized_space_lte: The planned_prioritized_space_lte of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_lte: int
        """

        self._planned_prioritized_space_lte = planned_prioritized_space_lte

    @property
    def planned_prioritized_space_not(self):
        """Gets the planned_prioritized_space_not of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space_not

    @planned_prioritized_space_not.setter
    def planned_prioritized_space_not(self, planned_prioritized_space_not):
        """Sets the planned_prioritized_space_not of this HostWhereInput.


        :param planned_prioritized_space_not: The planned_prioritized_space_not of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_not: int
        """

        self._planned_prioritized_space_not = planned_prioritized_space_not

    @property
    def planned_prioritized_space_not_in(self):
        """Gets the planned_prioritized_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The planned_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._planned_prioritized_space_not_in

    @planned_prioritized_space_not_in.setter
    def planned_prioritized_space_not_in(self, planned_prioritized_space_not_in):
        """Sets the planned_prioritized_space_not_in of this HostWhereInput.


        :param planned_prioritized_space_not_in: The planned_prioritized_space_not_in of this HostWhereInput.  # noqa: E501
        :type planned_prioritized_space_not_in: list[int]
        """

        self._planned_prioritized_space_not_in = planned_prioritized_space_not_in

    @property
    def pmem_dimm_capacity(self):
        """Gets the pmem_dimm_capacity of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity

    @pmem_dimm_capacity.setter
    def pmem_dimm_capacity(self, pmem_dimm_capacity):
        """Sets the pmem_dimm_capacity of this HostWhereInput.


        :param pmem_dimm_capacity: The pmem_dimm_capacity of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity: int
        """

        self._pmem_dimm_capacity = pmem_dimm_capacity

    @property
    def pmem_dimm_capacity_gt(self):
        """Gets the pmem_dimm_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity_gt

    @pmem_dimm_capacity_gt.setter
    def pmem_dimm_capacity_gt(self, pmem_dimm_capacity_gt):
        """Sets the pmem_dimm_capacity_gt of this HostWhereInput.


        :param pmem_dimm_capacity_gt: The pmem_dimm_capacity_gt of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_gt: int
        """

        self._pmem_dimm_capacity_gt = pmem_dimm_capacity_gt

    @property
    def pmem_dimm_capacity_gte(self):
        """Gets the pmem_dimm_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity_gte

    @pmem_dimm_capacity_gte.setter
    def pmem_dimm_capacity_gte(self, pmem_dimm_capacity_gte):
        """Sets the pmem_dimm_capacity_gte of this HostWhereInput.


        :param pmem_dimm_capacity_gte: The pmem_dimm_capacity_gte of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_gte: int
        """

        self._pmem_dimm_capacity_gte = pmem_dimm_capacity_gte

    @property
    def pmem_dimm_capacity_in(self):
        """Gets the pmem_dimm_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_dimm_capacity_in

    @pmem_dimm_capacity_in.setter
    def pmem_dimm_capacity_in(self, pmem_dimm_capacity_in):
        """Sets the pmem_dimm_capacity_in of this HostWhereInput.


        :param pmem_dimm_capacity_in: The pmem_dimm_capacity_in of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_in: list[int]
        """

        self._pmem_dimm_capacity_in = pmem_dimm_capacity_in

    @property
    def pmem_dimm_capacity_lt(self):
        """Gets the pmem_dimm_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity_lt

    @pmem_dimm_capacity_lt.setter
    def pmem_dimm_capacity_lt(self, pmem_dimm_capacity_lt):
        """Sets the pmem_dimm_capacity_lt of this HostWhereInput.


        :param pmem_dimm_capacity_lt: The pmem_dimm_capacity_lt of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_lt: int
        """

        self._pmem_dimm_capacity_lt = pmem_dimm_capacity_lt

    @property
    def pmem_dimm_capacity_lte(self):
        """Gets the pmem_dimm_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity_lte

    @pmem_dimm_capacity_lte.setter
    def pmem_dimm_capacity_lte(self, pmem_dimm_capacity_lte):
        """Sets the pmem_dimm_capacity_lte of this HostWhereInput.


        :param pmem_dimm_capacity_lte: The pmem_dimm_capacity_lte of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_lte: int
        """

        self._pmem_dimm_capacity_lte = pmem_dimm_capacity_lte

    @property
    def pmem_dimm_capacity_not(self):
        """Gets the pmem_dimm_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity_not

    @pmem_dimm_capacity_not.setter
    def pmem_dimm_capacity_not(self, pmem_dimm_capacity_not):
        """Sets the pmem_dimm_capacity_not of this HostWhereInput.


        :param pmem_dimm_capacity_not: The pmem_dimm_capacity_not of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_not: int
        """

        self._pmem_dimm_capacity_not = pmem_dimm_capacity_not

    @property
    def pmem_dimm_capacity_not_in(self):
        """Gets the pmem_dimm_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_dimm_capacity_not_in

    @pmem_dimm_capacity_not_in.setter
    def pmem_dimm_capacity_not_in(self, pmem_dimm_capacity_not_in):
        """Sets the pmem_dimm_capacity_not_in of this HostWhereInput.


        :param pmem_dimm_capacity_not_in: The pmem_dimm_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_capacity_not_in: list[int]
        """

        self._pmem_dimm_capacity_not_in = pmem_dimm_capacity_not_in

    @property
    def pmem_dimm_count(self):
        """Gets the pmem_dimm_count of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count

    @pmem_dimm_count.setter
    def pmem_dimm_count(self, pmem_dimm_count):
        """Sets the pmem_dimm_count of this HostWhereInput.


        :param pmem_dimm_count: The pmem_dimm_count of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count: int
        """

        self._pmem_dimm_count = pmem_dimm_count

    @property
    def pmem_dimm_count_gt(self):
        """Gets the pmem_dimm_count_gt of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count_gt

    @pmem_dimm_count_gt.setter
    def pmem_dimm_count_gt(self, pmem_dimm_count_gt):
        """Sets the pmem_dimm_count_gt of this HostWhereInput.


        :param pmem_dimm_count_gt: The pmem_dimm_count_gt of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_gt: int
        """

        self._pmem_dimm_count_gt = pmem_dimm_count_gt

    @property
    def pmem_dimm_count_gte(self):
        """Gets the pmem_dimm_count_gte of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count_gte

    @pmem_dimm_count_gte.setter
    def pmem_dimm_count_gte(self, pmem_dimm_count_gte):
        """Sets the pmem_dimm_count_gte of this HostWhereInput.


        :param pmem_dimm_count_gte: The pmem_dimm_count_gte of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_gte: int
        """

        self._pmem_dimm_count_gte = pmem_dimm_count_gte

    @property
    def pmem_dimm_count_in(self):
        """Gets the pmem_dimm_count_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_dimm_count_in

    @pmem_dimm_count_in.setter
    def pmem_dimm_count_in(self, pmem_dimm_count_in):
        """Sets the pmem_dimm_count_in of this HostWhereInput.


        :param pmem_dimm_count_in: The pmem_dimm_count_in of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_in: list[int]
        """

        self._pmem_dimm_count_in = pmem_dimm_count_in

    @property
    def pmem_dimm_count_lt(self):
        """Gets the pmem_dimm_count_lt of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count_lt

    @pmem_dimm_count_lt.setter
    def pmem_dimm_count_lt(self, pmem_dimm_count_lt):
        """Sets the pmem_dimm_count_lt of this HostWhereInput.


        :param pmem_dimm_count_lt: The pmem_dimm_count_lt of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_lt: int
        """

        self._pmem_dimm_count_lt = pmem_dimm_count_lt

    @property
    def pmem_dimm_count_lte(self):
        """Gets the pmem_dimm_count_lte of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count_lte

    @pmem_dimm_count_lte.setter
    def pmem_dimm_count_lte(self, pmem_dimm_count_lte):
        """Sets the pmem_dimm_count_lte of this HostWhereInput.


        :param pmem_dimm_count_lte: The pmem_dimm_count_lte of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_lte: int
        """

        self._pmem_dimm_count_lte = pmem_dimm_count_lte

    @property
    def pmem_dimm_count_not(self):
        """Gets the pmem_dimm_count_not of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count_not

    @pmem_dimm_count_not.setter
    def pmem_dimm_count_not(self, pmem_dimm_count_not):
        """Sets the pmem_dimm_count_not of this HostWhereInput.


        :param pmem_dimm_count_not: The pmem_dimm_count_not of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_not: int
        """

        self._pmem_dimm_count_not = pmem_dimm_count_not

    @property
    def pmem_dimm_count_not_in(self):
        """Gets the pmem_dimm_count_not_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimm_count_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_dimm_count_not_in

    @pmem_dimm_count_not_in.setter
    def pmem_dimm_count_not_in(self, pmem_dimm_count_not_in):
        """Sets the pmem_dimm_count_not_in of this HostWhereInput.


        :param pmem_dimm_count_not_in: The pmem_dimm_count_not_in of this HostWhereInput.  # noqa: E501
        :type pmem_dimm_count_not_in: list[int]
        """

        self._pmem_dimm_count_not_in = pmem_dimm_count_not_in

    @property
    def pmem_dimms_every(self):
        """Gets the pmem_dimms_every of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimms_every of this HostWhereInput.  # noqa: E501
        :rtype: PmemDimmWhereInput
        """
        return self._pmem_dimms_every

    @pmem_dimms_every.setter
    def pmem_dimms_every(self, pmem_dimms_every):
        """Sets the pmem_dimms_every of this HostWhereInput.


        :param pmem_dimms_every: The pmem_dimms_every of this HostWhereInput.  # noqa: E501
        :type pmem_dimms_every: PmemDimmWhereInput
        """

        self._pmem_dimms_every = pmem_dimms_every

    @property
    def pmem_dimms_none(self):
        """Gets the pmem_dimms_none of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimms_none of this HostWhereInput.  # noqa: E501
        :rtype: PmemDimmWhereInput
        """
        return self._pmem_dimms_none

    @pmem_dimms_none.setter
    def pmem_dimms_none(self, pmem_dimms_none):
        """Sets the pmem_dimms_none of this HostWhereInput.


        :param pmem_dimms_none: The pmem_dimms_none of this HostWhereInput.  # noqa: E501
        :type pmem_dimms_none: PmemDimmWhereInput
        """

        self._pmem_dimms_none = pmem_dimms_none

    @property
    def pmem_dimms_some(self):
        """Gets the pmem_dimms_some of this HostWhereInput.  # noqa: E501


        :return: The pmem_dimms_some of this HostWhereInput.  # noqa: E501
        :rtype: PmemDimmWhereInput
        """
        return self._pmem_dimms_some

    @pmem_dimms_some.setter
    def pmem_dimms_some(self, pmem_dimms_some):
        """Sets the pmem_dimms_some of this HostWhereInput.


        :param pmem_dimms_some: The pmem_dimms_some of this HostWhereInput.  # noqa: E501
        :type pmem_dimms_some: PmemDimmWhereInput
        """

        self._pmem_dimms_some = pmem_dimms_some

    @property
    def pmem_disk_count(self):
        """Gets the pmem_disk_count of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count

    @pmem_disk_count.setter
    def pmem_disk_count(self, pmem_disk_count):
        """Sets the pmem_disk_count of this HostWhereInput.


        :param pmem_disk_count: The pmem_disk_count of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count: int
        """

        self._pmem_disk_count = pmem_disk_count

    @property
    def pmem_disk_count_gt(self):
        """Gets the pmem_disk_count_gt of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count_gt

    @pmem_disk_count_gt.setter
    def pmem_disk_count_gt(self, pmem_disk_count_gt):
        """Sets the pmem_disk_count_gt of this HostWhereInput.


        :param pmem_disk_count_gt: The pmem_disk_count_gt of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_gt: int
        """

        self._pmem_disk_count_gt = pmem_disk_count_gt

    @property
    def pmem_disk_count_gte(self):
        """Gets the pmem_disk_count_gte of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count_gte

    @pmem_disk_count_gte.setter
    def pmem_disk_count_gte(self, pmem_disk_count_gte):
        """Sets the pmem_disk_count_gte of this HostWhereInput.


        :param pmem_disk_count_gte: The pmem_disk_count_gte of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_gte: int
        """

        self._pmem_disk_count_gte = pmem_disk_count_gte

    @property
    def pmem_disk_count_in(self):
        """Gets the pmem_disk_count_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_disk_count_in

    @pmem_disk_count_in.setter
    def pmem_disk_count_in(self, pmem_disk_count_in):
        """Sets the pmem_disk_count_in of this HostWhereInput.


        :param pmem_disk_count_in: The pmem_disk_count_in of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_in: list[int]
        """

        self._pmem_disk_count_in = pmem_disk_count_in

    @property
    def pmem_disk_count_lt(self):
        """Gets the pmem_disk_count_lt of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count_lt

    @pmem_disk_count_lt.setter
    def pmem_disk_count_lt(self, pmem_disk_count_lt):
        """Sets the pmem_disk_count_lt of this HostWhereInput.


        :param pmem_disk_count_lt: The pmem_disk_count_lt of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_lt: int
        """

        self._pmem_disk_count_lt = pmem_disk_count_lt

    @property
    def pmem_disk_count_lte(self):
        """Gets the pmem_disk_count_lte of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count_lte

    @pmem_disk_count_lte.setter
    def pmem_disk_count_lte(self, pmem_disk_count_lte):
        """Sets the pmem_disk_count_lte of this HostWhereInput.


        :param pmem_disk_count_lte: The pmem_disk_count_lte of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_lte: int
        """

        self._pmem_disk_count_lte = pmem_disk_count_lte

    @property
    def pmem_disk_count_not(self):
        """Gets the pmem_disk_count_not of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count_not

    @pmem_disk_count_not.setter
    def pmem_disk_count_not(self, pmem_disk_count_not):
        """Sets the pmem_disk_count_not of this HostWhereInput.


        :param pmem_disk_count_not: The pmem_disk_count_not of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_not: int
        """

        self._pmem_disk_count_not = pmem_disk_count_not

    @property
    def pmem_disk_count_not_in(self):
        """Gets the pmem_disk_count_not_in of this HostWhereInput.  # noqa: E501


        :return: The pmem_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._pmem_disk_count_not_in

    @pmem_disk_count_not_in.setter
    def pmem_disk_count_not_in(self, pmem_disk_count_not_in):
        """Sets the pmem_disk_count_not_in of this HostWhereInput.


        :param pmem_disk_count_not_in: The pmem_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :type pmem_disk_count_not_in: list[int]
        """

        self._pmem_disk_count_not_in = pmem_disk_count_not_in

    @property
    def prio_space_percentage(self):
        """Gets the prio_space_percentage of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage

    @prio_space_percentage.setter
    def prio_space_percentage(self, prio_space_percentage):
        """Sets the prio_space_percentage of this HostWhereInput.


        :param prio_space_percentage: The prio_space_percentage of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage: float
        """

        self._prio_space_percentage = prio_space_percentage

    @property
    def prio_space_percentage_gt(self):
        """Gets the prio_space_percentage_gt of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_gt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_gt

    @prio_space_percentage_gt.setter
    def prio_space_percentage_gt(self, prio_space_percentage_gt):
        """Sets the prio_space_percentage_gt of this HostWhereInput.


        :param prio_space_percentage_gt: The prio_space_percentage_gt of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_gt: float
        """

        self._prio_space_percentage_gt = prio_space_percentage_gt

    @property
    def prio_space_percentage_gte(self):
        """Gets the prio_space_percentage_gte of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_gte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_gte

    @prio_space_percentage_gte.setter
    def prio_space_percentage_gte(self, prio_space_percentage_gte):
        """Sets the prio_space_percentage_gte of this HostWhereInput.


        :param prio_space_percentage_gte: The prio_space_percentage_gte of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_gte: float
        """

        self._prio_space_percentage_gte = prio_space_percentage_gte

    @property
    def prio_space_percentage_in(self):
        """Gets the prio_space_percentage_in of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._prio_space_percentage_in

    @prio_space_percentage_in.setter
    def prio_space_percentage_in(self, prio_space_percentage_in):
        """Sets the prio_space_percentage_in of this HostWhereInput.


        :param prio_space_percentage_in: The prio_space_percentage_in of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_in: list[float]
        """

        self._prio_space_percentage_in = prio_space_percentage_in

    @property
    def prio_space_percentage_lt(self):
        """Gets the prio_space_percentage_lt of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_lt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_lt

    @prio_space_percentage_lt.setter
    def prio_space_percentage_lt(self, prio_space_percentage_lt):
        """Sets the prio_space_percentage_lt of this HostWhereInput.


        :param prio_space_percentage_lt: The prio_space_percentage_lt of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_lt: float
        """

        self._prio_space_percentage_lt = prio_space_percentage_lt

    @property
    def prio_space_percentage_lte(self):
        """Gets the prio_space_percentage_lte of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_lte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_lte

    @prio_space_percentage_lte.setter
    def prio_space_percentage_lte(self, prio_space_percentage_lte):
        """Sets the prio_space_percentage_lte of this HostWhereInput.


        :param prio_space_percentage_lte: The prio_space_percentage_lte of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_lte: float
        """

        self._prio_space_percentage_lte = prio_space_percentage_lte

    @property
    def prio_space_percentage_not(self):
        """Gets the prio_space_percentage_not of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_not of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage_not

    @prio_space_percentage_not.setter
    def prio_space_percentage_not(self, prio_space_percentage_not):
        """Sets the prio_space_percentage_not of this HostWhereInput.


        :param prio_space_percentage_not: The prio_space_percentage_not of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_not: float
        """

        self._prio_space_percentage_not = prio_space_percentage_not

    @property
    def prio_space_percentage_not_in(self):
        """Gets the prio_space_percentage_not_in of this HostWhereInput.  # noqa: E501


        :return: The prio_space_percentage_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._prio_space_percentage_not_in

    @prio_space_percentage_not_in.setter
    def prio_space_percentage_not_in(self, prio_space_percentage_not_in):
        """Sets the prio_space_percentage_not_in of this HostWhereInput.


        :param prio_space_percentage_not_in: The prio_space_percentage_not_in of this HostWhereInput.  # noqa: E501
        :type prio_space_percentage_not_in: list[float]
        """

        self._prio_space_percentage_not_in = prio_space_percentage_not_in

    @property
    def provisioned_cpu_cores(self):
        """Gets the provisioned_cpu_cores of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores

    @provisioned_cpu_cores.setter
    def provisioned_cpu_cores(self, provisioned_cpu_cores):
        """Sets the provisioned_cpu_cores of this HostWhereInput.


        :param provisioned_cpu_cores: The provisioned_cpu_cores of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores: int
        """

        self._provisioned_cpu_cores = provisioned_cpu_cores

    @property
    def provisioned_cpu_cores_gt(self):
        """Gets the provisioned_cpu_cores_gt of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_gt

    @provisioned_cpu_cores_gt.setter
    def provisioned_cpu_cores_gt(self, provisioned_cpu_cores_gt):
        """Sets the provisioned_cpu_cores_gt of this HostWhereInput.


        :param provisioned_cpu_cores_gt: The provisioned_cpu_cores_gt of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_gt: int
        """

        self._provisioned_cpu_cores_gt = provisioned_cpu_cores_gt

    @property
    def provisioned_cpu_cores_gte(self):
        """Gets the provisioned_cpu_cores_gte of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_gte

    @provisioned_cpu_cores_gte.setter
    def provisioned_cpu_cores_gte(self, provisioned_cpu_cores_gte):
        """Sets the provisioned_cpu_cores_gte of this HostWhereInput.


        :param provisioned_cpu_cores_gte: The provisioned_cpu_cores_gte of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_gte: int
        """

        self._provisioned_cpu_cores_gte = provisioned_cpu_cores_gte

    @property
    def provisioned_cpu_cores_in(self):
        """Gets the provisioned_cpu_cores_in of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_in

    @provisioned_cpu_cores_in.setter
    def provisioned_cpu_cores_in(self, provisioned_cpu_cores_in):
        """Sets the provisioned_cpu_cores_in of this HostWhereInput.


        :param provisioned_cpu_cores_in: The provisioned_cpu_cores_in of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_in: list[int]
        """

        self._provisioned_cpu_cores_in = provisioned_cpu_cores_in

    @property
    def provisioned_cpu_cores_lt(self):
        """Gets the provisioned_cpu_cores_lt of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_lt

    @provisioned_cpu_cores_lt.setter
    def provisioned_cpu_cores_lt(self, provisioned_cpu_cores_lt):
        """Sets the provisioned_cpu_cores_lt of this HostWhereInput.


        :param provisioned_cpu_cores_lt: The provisioned_cpu_cores_lt of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_lt: int
        """

        self._provisioned_cpu_cores_lt = provisioned_cpu_cores_lt

    @property
    def provisioned_cpu_cores_lte(self):
        """Gets the provisioned_cpu_cores_lte of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_lte

    @provisioned_cpu_cores_lte.setter
    def provisioned_cpu_cores_lte(self, provisioned_cpu_cores_lte):
        """Sets the provisioned_cpu_cores_lte of this HostWhereInput.


        :param provisioned_cpu_cores_lte: The provisioned_cpu_cores_lte of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_lte: int
        """

        self._provisioned_cpu_cores_lte = provisioned_cpu_cores_lte

    @property
    def provisioned_cpu_cores_not(self):
        """Gets the provisioned_cpu_cores_not of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_not

    @provisioned_cpu_cores_not.setter
    def provisioned_cpu_cores_not(self, provisioned_cpu_cores_not):
        """Sets the provisioned_cpu_cores_not of this HostWhereInput.


        :param provisioned_cpu_cores_not: The provisioned_cpu_cores_not of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_not: int
        """

        self._provisioned_cpu_cores_not = provisioned_cpu_cores_not

    @property
    def provisioned_cpu_cores_not_in(self):
        """Gets the provisioned_cpu_cores_not_in of this HostWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_not_in

    @provisioned_cpu_cores_not_in.setter
    def provisioned_cpu_cores_not_in(self, provisioned_cpu_cores_not_in):
        """Sets the provisioned_cpu_cores_not_in of this HostWhereInput.


        :param provisioned_cpu_cores_not_in: The provisioned_cpu_cores_not_in of this HostWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_not_in: list[int]
        """

        self._provisioned_cpu_cores_not_in = provisioned_cpu_cores_not_in

    @property
    def provisioned_memory_bytes(self):
        """Gets the provisioned_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes

    @provisioned_memory_bytes.setter
    def provisioned_memory_bytes(self, provisioned_memory_bytes):
        """Sets the provisioned_memory_bytes of this HostWhereInput.


        :param provisioned_memory_bytes: The provisioned_memory_bytes of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes: int
        """

        self._provisioned_memory_bytes = provisioned_memory_bytes

    @property
    def provisioned_memory_bytes_gt(self):
        """Gets the provisioned_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_gt

    @provisioned_memory_bytes_gt.setter
    def provisioned_memory_bytes_gt(self, provisioned_memory_bytes_gt):
        """Sets the provisioned_memory_bytes_gt of this HostWhereInput.


        :param provisioned_memory_bytes_gt: The provisioned_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_gt: int
        """

        self._provisioned_memory_bytes_gt = provisioned_memory_bytes_gt

    @property
    def provisioned_memory_bytes_gte(self):
        """Gets the provisioned_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_gte

    @provisioned_memory_bytes_gte.setter
    def provisioned_memory_bytes_gte(self, provisioned_memory_bytes_gte):
        """Sets the provisioned_memory_bytes_gte of this HostWhereInput.


        :param provisioned_memory_bytes_gte: The provisioned_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_gte: int
        """

        self._provisioned_memory_bytes_gte = provisioned_memory_bytes_gte

    @property
    def provisioned_memory_bytes_in(self):
        """Gets the provisioned_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_memory_bytes_in

    @provisioned_memory_bytes_in.setter
    def provisioned_memory_bytes_in(self, provisioned_memory_bytes_in):
        """Sets the provisioned_memory_bytes_in of this HostWhereInput.


        :param provisioned_memory_bytes_in: The provisioned_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_in: list[int]
        """

        self._provisioned_memory_bytes_in = provisioned_memory_bytes_in

    @property
    def provisioned_memory_bytes_lt(self):
        """Gets the provisioned_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_lt

    @provisioned_memory_bytes_lt.setter
    def provisioned_memory_bytes_lt(self, provisioned_memory_bytes_lt):
        """Sets the provisioned_memory_bytes_lt of this HostWhereInput.


        :param provisioned_memory_bytes_lt: The provisioned_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_lt: int
        """

        self._provisioned_memory_bytes_lt = provisioned_memory_bytes_lt

    @property
    def provisioned_memory_bytes_lte(self):
        """Gets the provisioned_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_lte

    @provisioned_memory_bytes_lte.setter
    def provisioned_memory_bytes_lte(self, provisioned_memory_bytes_lte):
        """Sets the provisioned_memory_bytes_lte of this HostWhereInput.


        :param provisioned_memory_bytes_lte: The provisioned_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_lte: int
        """

        self._provisioned_memory_bytes_lte = provisioned_memory_bytes_lte

    @property
    def provisioned_memory_bytes_not(self):
        """Gets the provisioned_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_not

    @provisioned_memory_bytes_not.setter
    def provisioned_memory_bytes_not(self, provisioned_memory_bytes_not):
        """Sets the provisioned_memory_bytes_not of this HostWhereInput.


        :param provisioned_memory_bytes_not: The provisioned_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_not: int
        """

        self._provisioned_memory_bytes_not = provisioned_memory_bytes_not

    @property
    def provisioned_memory_bytes_not_in(self):
        """Gets the provisioned_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_memory_bytes_not_in

    @provisioned_memory_bytes_not_in.setter
    def provisioned_memory_bytes_not_in(self, provisioned_memory_bytes_not_in):
        """Sets the provisioned_memory_bytes_not_in of this HostWhereInput.


        :param provisioned_memory_bytes_not_in: The provisioned_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_not_in: list[int]
        """

        self._provisioned_memory_bytes_not_in = provisioned_memory_bytes_not_in

    @property
    def running_pause_vm_memory_bytes(self):
        """Gets the running_pause_vm_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes

    @running_pause_vm_memory_bytes.setter
    def running_pause_vm_memory_bytes(self, running_pause_vm_memory_bytes):
        """Sets the running_pause_vm_memory_bytes of this HostWhereInput.


        :param running_pause_vm_memory_bytes: The running_pause_vm_memory_bytes of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes: int
        """

        self._running_pause_vm_memory_bytes = running_pause_vm_memory_bytes

    @property
    def running_pause_vm_memory_bytes_gt(self):
        """Gets the running_pause_vm_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes_gt

    @running_pause_vm_memory_bytes_gt.setter
    def running_pause_vm_memory_bytes_gt(self, running_pause_vm_memory_bytes_gt):
        """Sets the running_pause_vm_memory_bytes_gt of this HostWhereInput.


        :param running_pause_vm_memory_bytes_gt: The running_pause_vm_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_gt: int
        """

        self._running_pause_vm_memory_bytes_gt = running_pause_vm_memory_bytes_gt

    @property
    def running_pause_vm_memory_bytes_gte(self):
        """Gets the running_pause_vm_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes_gte

    @running_pause_vm_memory_bytes_gte.setter
    def running_pause_vm_memory_bytes_gte(self, running_pause_vm_memory_bytes_gte):
        """Sets the running_pause_vm_memory_bytes_gte of this HostWhereInput.


        :param running_pause_vm_memory_bytes_gte: The running_pause_vm_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_gte: int
        """

        self._running_pause_vm_memory_bytes_gte = running_pause_vm_memory_bytes_gte

    @property
    def running_pause_vm_memory_bytes_in(self):
        """Gets the running_pause_vm_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_pause_vm_memory_bytes_in

    @running_pause_vm_memory_bytes_in.setter
    def running_pause_vm_memory_bytes_in(self, running_pause_vm_memory_bytes_in):
        """Sets the running_pause_vm_memory_bytes_in of this HostWhereInput.


        :param running_pause_vm_memory_bytes_in: The running_pause_vm_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_in: list[int]
        """

        self._running_pause_vm_memory_bytes_in = running_pause_vm_memory_bytes_in

    @property
    def running_pause_vm_memory_bytes_lt(self):
        """Gets the running_pause_vm_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes_lt

    @running_pause_vm_memory_bytes_lt.setter
    def running_pause_vm_memory_bytes_lt(self, running_pause_vm_memory_bytes_lt):
        """Sets the running_pause_vm_memory_bytes_lt of this HostWhereInput.


        :param running_pause_vm_memory_bytes_lt: The running_pause_vm_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_lt: int
        """

        self._running_pause_vm_memory_bytes_lt = running_pause_vm_memory_bytes_lt

    @property
    def running_pause_vm_memory_bytes_lte(self):
        """Gets the running_pause_vm_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes_lte

    @running_pause_vm_memory_bytes_lte.setter
    def running_pause_vm_memory_bytes_lte(self, running_pause_vm_memory_bytes_lte):
        """Sets the running_pause_vm_memory_bytes_lte of this HostWhereInput.


        :param running_pause_vm_memory_bytes_lte: The running_pause_vm_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_lte: int
        """

        self._running_pause_vm_memory_bytes_lte = running_pause_vm_memory_bytes_lte

    @property
    def running_pause_vm_memory_bytes_not(self):
        """Gets the running_pause_vm_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes_not

    @running_pause_vm_memory_bytes_not.setter
    def running_pause_vm_memory_bytes_not(self, running_pause_vm_memory_bytes_not):
        """Sets the running_pause_vm_memory_bytes_not of this HostWhereInput.


        :param running_pause_vm_memory_bytes_not: The running_pause_vm_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_not: int
        """

        self._running_pause_vm_memory_bytes_not = running_pause_vm_memory_bytes_not

    @property
    def running_pause_vm_memory_bytes_not_in(self):
        """Gets the running_pause_vm_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The running_pause_vm_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_pause_vm_memory_bytes_not_in

    @running_pause_vm_memory_bytes_not_in.setter
    def running_pause_vm_memory_bytes_not_in(self, running_pause_vm_memory_bytes_not_in):
        """Sets the running_pause_vm_memory_bytes_not_in of this HostWhereInput.


        :param running_pause_vm_memory_bytes_not_in: The running_pause_vm_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type running_pause_vm_memory_bytes_not_in: list[int]
        """

        self._running_pause_vm_memory_bytes_not_in = running_pause_vm_memory_bytes_not_in

    @property
    def running_vm_num(self):
        """Gets the running_vm_num of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num

    @running_vm_num.setter
    def running_vm_num(self, running_vm_num):
        """Sets the running_vm_num of this HostWhereInput.


        :param running_vm_num: The running_vm_num of this HostWhereInput.  # noqa: E501
        :type running_vm_num: int
        """

        self._running_vm_num = running_vm_num

    @property
    def running_vm_num_gt(self):
        """Gets the running_vm_num_gt of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_gt

    @running_vm_num_gt.setter
    def running_vm_num_gt(self, running_vm_num_gt):
        """Sets the running_vm_num_gt of this HostWhereInput.


        :param running_vm_num_gt: The running_vm_num_gt of this HostWhereInput.  # noqa: E501
        :type running_vm_num_gt: int
        """

        self._running_vm_num_gt = running_vm_num_gt

    @property
    def running_vm_num_gte(self):
        """Gets the running_vm_num_gte of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_gte

    @running_vm_num_gte.setter
    def running_vm_num_gte(self, running_vm_num_gte):
        """Sets the running_vm_num_gte of this HostWhereInput.


        :param running_vm_num_gte: The running_vm_num_gte of this HostWhereInput.  # noqa: E501
        :type running_vm_num_gte: int
        """

        self._running_vm_num_gte = running_vm_num_gte

    @property
    def running_vm_num_in(self):
        """Gets the running_vm_num_in of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_vm_num_in

    @running_vm_num_in.setter
    def running_vm_num_in(self, running_vm_num_in):
        """Sets the running_vm_num_in of this HostWhereInput.


        :param running_vm_num_in: The running_vm_num_in of this HostWhereInput.  # noqa: E501
        :type running_vm_num_in: list[int]
        """

        self._running_vm_num_in = running_vm_num_in

    @property
    def running_vm_num_lt(self):
        """Gets the running_vm_num_lt of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_lt

    @running_vm_num_lt.setter
    def running_vm_num_lt(self, running_vm_num_lt):
        """Sets the running_vm_num_lt of this HostWhereInput.


        :param running_vm_num_lt: The running_vm_num_lt of this HostWhereInput.  # noqa: E501
        :type running_vm_num_lt: int
        """

        self._running_vm_num_lt = running_vm_num_lt

    @property
    def running_vm_num_lte(self):
        """Gets the running_vm_num_lte of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_lte

    @running_vm_num_lte.setter
    def running_vm_num_lte(self, running_vm_num_lte):
        """Sets the running_vm_num_lte of this HostWhereInput.


        :param running_vm_num_lte: The running_vm_num_lte of this HostWhereInput.  # noqa: E501
        :type running_vm_num_lte: int
        """

        self._running_vm_num_lte = running_vm_num_lte

    @property
    def running_vm_num_not(self):
        """Gets the running_vm_num_not of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_not

    @running_vm_num_not.setter
    def running_vm_num_not(self, running_vm_num_not):
        """Sets the running_vm_num_not of this HostWhereInput.


        :param running_vm_num_not: The running_vm_num_not of this HostWhereInput.  # noqa: E501
        :type running_vm_num_not: int
        """

        self._running_vm_num_not = running_vm_num_not

    @property
    def running_vm_num_not_in(self):
        """Gets the running_vm_num_not_in of this HostWhereInput.  # noqa: E501


        :return: The running_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_vm_num_not_in

    @running_vm_num_not_in.setter
    def running_vm_num_not_in(self, running_vm_num_not_in):
        """Sets the running_vm_num_not_in of this HostWhereInput.


        :param running_vm_num_not_in: The running_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :type running_vm_num_not_in: list[int]
        """

        self._running_vm_num_not_in = running_vm_num_not_in

    @property
    def scvm_cpu(self):
        """Gets the scvm_cpu of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu

    @scvm_cpu.setter
    def scvm_cpu(self, scvm_cpu):
        """Sets the scvm_cpu of this HostWhereInput.


        :param scvm_cpu: The scvm_cpu of this HostWhereInput.  # noqa: E501
        :type scvm_cpu: int
        """

        self._scvm_cpu = scvm_cpu

    @property
    def scvm_cpu_gt(self):
        """Gets the scvm_cpu_gt of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu_gt

    @scvm_cpu_gt.setter
    def scvm_cpu_gt(self, scvm_cpu_gt):
        """Sets the scvm_cpu_gt of this HostWhereInput.


        :param scvm_cpu_gt: The scvm_cpu_gt of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_gt: int
        """

        self._scvm_cpu_gt = scvm_cpu_gt

    @property
    def scvm_cpu_gte(self):
        """Gets the scvm_cpu_gte of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu_gte

    @scvm_cpu_gte.setter
    def scvm_cpu_gte(self, scvm_cpu_gte):
        """Sets the scvm_cpu_gte of this HostWhereInput.


        :param scvm_cpu_gte: The scvm_cpu_gte of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_gte: int
        """

        self._scvm_cpu_gte = scvm_cpu_gte

    @property
    def scvm_cpu_in(self):
        """Gets the scvm_cpu_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._scvm_cpu_in

    @scvm_cpu_in.setter
    def scvm_cpu_in(self, scvm_cpu_in):
        """Sets the scvm_cpu_in of this HostWhereInput.


        :param scvm_cpu_in: The scvm_cpu_in of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_in: list[int]
        """

        self._scvm_cpu_in = scvm_cpu_in

    @property
    def scvm_cpu_lt(self):
        """Gets the scvm_cpu_lt of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu_lt

    @scvm_cpu_lt.setter
    def scvm_cpu_lt(self, scvm_cpu_lt):
        """Sets the scvm_cpu_lt of this HostWhereInput.


        :param scvm_cpu_lt: The scvm_cpu_lt of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_lt: int
        """

        self._scvm_cpu_lt = scvm_cpu_lt

    @property
    def scvm_cpu_lte(self):
        """Gets the scvm_cpu_lte of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu_lte

    @scvm_cpu_lte.setter
    def scvm_cpu_lte(self, scvm_cpu_lte):
        """Sets the scvm_cpu_lte of this HostWhereInput.


        :param scvm_cpu_lte: The scvm_cpu_lte of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_lte: int
        """

        self._scvm_cpu_lte = scvm_cpu_lte

    @property
    def scvm_cpu_not(self):
        """Gets the scvm_cpu_not of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu_not

    @scvm_cpu_not.setter
    def scvm_cpu_not(self, scvm_cpu_not):
        """Sets the scvm_cpu_not of this HostWhereInput.


        :param scvm_cpu_not: The scvm_cpu_not of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_not: int
        """

        self._scvm_cpu_not = scvm_cpu_not

    @property
    def scvm_cpu_not_in(self):
        """Gets the scvm_cpu_not_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_cpu_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._scvm_cpu_not_in

    @scvm_cpu_not_in.setter
    def scvm_cpu_not_in(self, scvm_cpu_not_in):
        """Sets the scvm_cpu_not_in of this HostWhereInput.


        :param scvm_cpu_not_in: The scvm_cpu_not_in of this HostWhereInput.  # noqa: E501
        :type scvm_cpu_not_in: list[int]
        """

        self._scvm_cpu_not_in = scvm_cpu_not_in

    @property
    def scvm_memory(self):
        """Gets the scvm_memory of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory

    @scvm_memory.setter
    def scvm_memory(self, scvm_memory):
        """Sets the scvm_memory of this HostWhereInput.


        :param scvm_memory: The scvm_memory of this HostWhereInput.  # noqa: E501
        :type scvm_memory: int
        """

        self._scvm_memory = scvm_memory

    @property
    def scvm_memory_gt(self):
        """Gets the scvm_memory_gt of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory_gt

    @scvm_memory_gt.setter
    def scvm_memory_gt(self, scvm_memory_gt):
        """Sets the scvm_memory_gt of this HostWhereInput.


        :param scvm_memory_gt: The scvm_memory_gt of this HostWhereInput.  # noqa: E501
        :type scvm_memory_gt: int
        """

        self._scvm_memory_gt = scvm_memory_gt

    @property
    def scvm_memory_gte(self):
        """Gets the scvm_memory_gte of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory_gte

    @scvm_memory_gte.setter
    def scvm_memory_gte(self, scvm_memory_gte):
        """Sets the scvm_memory_gte of this HostWhereInput.


        :param scvm_memory_gte: The scvm_memory_gte of this HostWhereInput.  # noqa: E501
        :type scvm_memory_gte: int
        """

        self._scvm_memory_gte = scvm_memory_gte

    @property
    def scvm_memory_in(self):
        """Gets the scvm_memory_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._scvm_memory_in

    @scvm_memory_in.setter
    def scvm_memory_in(self, scvm_memory_in):
        """Sets the scvm_memory_in of this HostWhereInput.


        :param scvm_memory_in: The scvm_memory_in of this HostWhereInput.  # noqa: E501
        :type scvm_memory_in: list[int]
        """

        self._scvm_memory_in = scvm_memory_in

    @property
    def scvm_memory_lt(self):
        """Gets the scvm_memory_lt of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory_lt

    @scvm_memory_lt.setter
    def scvm_memory_lt(self, scvm_memory_lt):
        """Sets the scvm_memory_lt of this HostWhereInput.


        :param scvm_memory_lt: The scvm_memory_lt of this HostWhereInput.  # noqa: E501
        :type scvm_memory_lt: int
        """

        self._scvm_memory_lt = scvm_memory_lt

    @property
    def scvm_memory_lte(self):
        """Gets the scvm_memory_lte of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory_lte

    @scvm_memory_lte.setter
    def scvm_memory_lte(self, scvm_memory_lte):
        """Sets the scvm_memory_lte of this HostWhereInput.


        :param scvm_memory_lte: The scvm_memory_lte of this HostWhereInput.  # noqa: E501
        :type scvm_memory_lte: int
        """

        self._scvm_memory_lte = scvm_memory_lte

    @property
    def scvm_memory_not(self):
        """Gets the scvm_memory_not of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory_not

    @scvm_memory_not.setter
    def scvm_memory_not(self, scvm_memory_not):
        """Sets the scvm_memory_not of this HostWhereInput.


        :param scvm_memory_not: The scvm_memory_not of this HostWhereInput.  # noqa: E501
        :type scvm_memory_not: int
        """

        self._scvm_memory_not = scvm_memory_not

    @property
    def scvm_memory_not_in(self):
        """Gets the scvm_memory_not_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_memory_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._scvm_memory_not_in

    @scvm_memory_not_in.setter
    def scvm_memory_not_in(self, scvm_memory_not_in):
        """Sets the scvm_memory_not_in of this HostWhereInput.


        :param scvm_memory_not_in: The scvm_memory_not_in of this HostWhereInput.  # noqa: E501
        :type scvm_memory_not_in: list[int]
        """

        self._scvm_memory_not_in = scvm_memory_not_in

    @property
    def scvm_name(self):
        """Gets the scvm_name of this HostWhereInput.  # noqa: E501


        :return: The scvm_name of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name

    @scvm_name.setter
    def scvm_name(self, scvm_name):
        """Sets the scvm_name of this HostWhereInput.


        :param scvm_name: The scvm_name of this HostWhereInput.  # noqa: E501
        :type scvm_name: str
        """

        self._scvm_name = scvm_name

    @property
    def scvm_name_contains(self):
        """Gets the scvm_name_contains of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_contains

    @scvm_name_contains.setter
    def scvm_name_contains(self, scvm_name_contains):
        """Sets the scvm_name_contains of this HostWhereInput.


        :param scvm_name_contains: The scvm_name_contains of this HostWhereInput.  # noqa: E501
        :type scvm_name_contains: str
        """

        self._scvm_name_contains = scvm_name_contains

    @property
    def scvm_name_ends_with(self):
        """Gets the scvm_name_ends_with of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_ends_with

    @scvm_name_ends_with.setter
    def scvm_name_ends_with(self, scvm_name_ends_with):
        """Sets the scvm_name_ends_with of this HostWhereInput.


        :param scvm_name_ends_with: The scvm_name_ends_with of this HostWhereInput.  # noqa: E501
        :type scvm_name_ends_with: str
        """

        self._scvm_name_ends_with = scvm_name_ends_with

    @property
    def scvm_name_gt(self):
        """Gets the scvm_name_gt of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_gt

    @scvm_name_gt.setter
    def scvm_name_gt(self, scvm_name_gt):
        """Sets the scvm_name_gt of this HostWhereInput.


        :param scvm_name_gt: The scvm_name_gt of this HostWhereInput.  # noqa: E501
        :type scvm_name_gt: str
        """

        self._scvm_name_gt = scvm_name_gt

    @property
    def scvm_name_gte(self):
        """Gets the scvm_name_gte of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_gte

    @scvm_name_gte.setter
    def scvm_name_gte(self, scvm_name_gte):
        """Sets the scvm_name_gte of this HostWhereInput.


        :param scvm_name_gte: The scvm_name_gte of this HostWhereInput.  # noqa: E501
        :type scvm_name_gte: str
        """

        self._scvm_name_gte = scvm_name_gte

    @property
    def scvm_name_in(self):
        """Gets the scvm_name_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._scvm_name_in

    @scvm_name_in.setter
    def scvm_name_in(self, scvm_name_in):
        """Sets the scvm_name_in of this HostWhereInput.


        :param scvm_name_in: The scvm_name_in of this HostWhereInput.  # noqa: E501
        :type scvm_name_in: list[str]
        """

        self._scvm_name_in = scvm_name_in

    @property
    def scvm_name_lt(self):
        """Gets the scvm_name_lt of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_lt

    @scvm_name_lt.setter
    def scvm_name_lt(self, scvm_name_lt):
        """Sets the scvm_name_lt of this HostWhereInput.


        :param scvm_name_lt: The scvm_name_lt of this HostWhereInput.  # noqa: E501
        :type scvm_name_lt: str
        """

        self._scvm_name_lt = scvm_name_lt

    @property
    def scvm_name_lte(self):
        """Gets the scvm_name_lte of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_lte

    @scvm_name_lte.setter
    def scvm_name_lte(self, scvm_name_lte):
        """Sets the scvm_name_lte of this HostWhereInput.


        :param scvm_name_lte: The scvm_name_lte of this HostWhereInput.  # noqa: E501
        :type scvm_name_lte: str
        """

        self._scvm_name_lte = scvm_name_lte

    @property
    def scvm_name_not(self):
        """Gets the scvm_name_not of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_not

    @scvm_name_not.setter
    def scvm_name_not(self, scvm_name_not):
        """Sets the scvm_name_not of this HostWhereInput.


        :param scvm_name_not: The scvm_name_not of this HostWhereInput.  # noqa: E501
        :type scvm_name_not: str
        """

        self._scvm_name_not = scvm_name_not

    @property
    def scvm_name_not_contains(self):
        """Gets the scvm_name_not_contains of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_not_contains

    @scvm_name_not_contains.setter
    def scvm_name_not_contains(self, scvm_name_not_contains):
        """Sets the scvm_name_not_contains of this HostWhereInput.


        :param scvm_name_not_contains: The scvm_name_not_contains of this HostWhereInput.  # noqa: E501
        :type scvm_name_not_contains: str
        """

        self._scvm_name_not_contains = scvm_name_not_contains

    @property
    def scvm_name_not_ends_with(self):
        """Gets the scvm_name_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_not_ends_with

    @scvm_name_not_ends_with.setter
    def scvm_name_not_ends_with(self, scvm_name_not_ends_with):
        """Sets the scvm_name_not_ends_with of this HostWhereInput.


        :param scvm_name_not_ends_with: The scvm_name_not_ends_with of this HostWhereInput.  # noqa: E501
        :type scvm_name_not_ends_with: str
        """

        self._scvm_name_not_ends_with = scvm_name_not_ends_with

    @property
    def scvm_name_not_in(self):
        """Gets the scvm_name_not_in of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._scvm_name_not_in

    @scvm_name_not_in.setter
    def scvm_name_not_in(self, scvm_name_not_in):
        """Sets the scvm_name_not_in of this HostWhereInput.


        :param scvm_name_not_in: The scvm_name_not_in of this HostWhereInput.  # noqa: E501
        :type scvm_name_not_in: list[str]
        """

        self._scvm_name_not_in = scvm_name_not_in

    @property
    def scvm_name_not_starts_with(self):
        """Gets the scvm_name_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_not_starts_with

    @scvm_name_not_starts_with.setter
    def scvm_name_not_starts_with(self, scvm_name_not_starts_with):
        """Sets the scvm_name_not_starts_with of this HostWhereInput.


        :param scvm_name_not_starts_with: The scvm_name_not_starts_with of this HostWhereInput.  # noqa: E501
        :type scvm_name_not_starts_with: str
        """

        self._scvm_name_not_starts_with = scvm_name_not_starts_with

    @property
    def scvm_name_starts_with(self):
        """Gets the scvm_name_starts_with of this HostWhereInput.  # noqa: E501


        :return: The scvm_name_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name_starts_with

    @scvm_name_starts_with.setter
    def scvm_name_starts_with(self, scvm_name_starts_with):
        """Sets the scvm_name_starts_with of this HostWhereInput.


        :param scvm_name_starts_with: The scvm_name_starts_with of this HostWhereInput.  # noqa: E501
        :type scvm_name_starts_with: str
        """

        self._scvm_name_starts_with = scvm_name_starts_with

    @property
    def serial(self):
        """Gets the serial of this HostWhereInput.  # noqa: E501


        :return: The serial of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial

    @serial.setter
    def serial(self, serial):
        """Sets the serial of this HostWhereInput.


        :param serial: The serial of this HostWhereInput.  # noqa: E501
        :type serial: str
        """

        self._serial = serial

    @property
    def serial_contains(self):
        """Gets the serial_contains of this HostWhereInput.  # noqa: E501


        :return: The serial_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_contains

    @serial_contains.setter
    def serial_contains(self, serial_contains):
        """Sets the serial_contains of this HostWhereInput.


        :param serial_contains: The serial_contains of this HostWhereInput.  # noqa: E501
        :type serial_contains: str
        """

        self._serial_contains = serial_contains

    @property
    def serial_ends_with(self):
        """Gets the serial_ends_with of this HostWhereInput.  # noqa: E501


        :return: The serial_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_ends_with

    @serial_ends_with.setter
    def serial_ends_with(self, serial_ends_with):
        """Sets the serial_ends_with of this HostWhereInput.


        :param serial_ends_with: The serial_ends_with of this HostWhereInput.  # noqa: E501
        :type serial_ends_with: str
        """

        self._serial_ends_with = serial_ends_with

    @property
    def serial_gt(self):
        """Gets the serial_gt of this HostWhereInput.  # noqa: E501


        :return: The serial_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_gt

    @serial_gt.setter
    def serial_gt(self, serial_gt):
        """Sets the serial_gt of this HostWhereInput.


        :param serial_gt: The serial_gt of this HostWhereInput.  # noqa: E501
        :type serial_gt: str
        """

        self._serial_gt = serial_gt

    @property
    def serial_gte(self):
        """Gets the serial_gte of this HostWhereInput.  # noqa: E501


        :return: The serial_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_gte

    @serial_gte.setter
    def serial_gte(self, serial_gte):
        """Sets the serial_gte of this HostWhereInput.


        :param serial_gte: The serial_gte of this HostWhereInput.  # noqa: E501
        :type serial_gte: str
        """

        self._serial_gte = serial_gte

    @property
    def serial_in(self):
        """Gets the serial_in of this HostWhereInput.  # noqa: E501


        :return: The serial_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._serial_in

    @serial_in.setter
    def serial_in(self, serial_in):
        """Sets the serial_in of this HostWhereInput.


        :param serial_in: The serial_in of this HostWhereInput.  # noqa: E501
        :type serial_in: list[str]
        """

        self._serial_in = serial_in

    @property
    def serial_lt(self):
        """Gets the serial_lt of this HostWhereInput.  # noqa: E501


        :return: The serial_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_lt

    @serial_lt.setter
    def serial_lt(self, serial_lt):
        """Sets the serial_lt of this HostWhereInput.


        :param serial_lt: The serial_lt of this HostWhereInput.  # noqa: E501
        :type serial_lt: str
        """

        self._serial_lt = serial_lt

    @property
    def serial_lte(self):
        """Gets the serial_lte of this HostWhereInput.  # noqa: E501


        :return: The serial_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_lte

    @serial_lte.setter
    def serial_lte(self, serial_lte):
        """Sets the serial_lte of this HostWhereInput.


        :param serial_lte: The serial_lte of this HostWhereInput.  # noqa: E501
        :type serial_lte: str
        """

        self._serial_lte = serial_lte

    @property
    def serial_not(self):
        """Gets the serial_not of this HostWhereInput.  # noqa: E501


        :return: The serial_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_not

    @serial_not.setter
    def serial_not(self, serial_not):
        """Sets the serial_not of this HostWhereInput.


        :param serial_not: The serial_not of this HostWhereInput.  # noqa: E501
        :type serial_not: str
        """

        self._serial_not = serial_not

    @property
    def serial_not_contains(self):
        """Gets the serial_not_contains of this HostWhereInput.  # noqa: E501


        :return: The serial_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_not_contains

    @serial_not_contains.setter
    def serial_not_contains(self, serial_not_contains):
        """Sets the serial_not_contains of this HostWhereInput.


        :param serial_not_contains: The serial_not_contains of this HostWhereInput.  # noqa: E501
        :type serial_not_contains: str
        """

        self._serial_not_contains = serial_not_contains

    @property
    def serial_not_ends_with(self):
        """Gets the serial_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The serial_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_not_ends_with

    @serial_not_ends_with.setter
    def serial_not_ends_with(self, serial_not_ends_with):
        """Sets the serial_not_ends_with of this HostWhereInput.


        :param serial_not_ends_with: The serial_not_ends_with of this HostWhereInput.  # noqa: E501
        :type serial_not_ends_with: str
        """

        self._serial_not_ends_with = serial_not_ends_with

    @property
    def serial_not_in(self):
        """Gets the serial_not_in of this HostWhereInput.  # noqa: E501


        :return: The serial_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._serial_not_in

    @serial_not_in.setter
    def serial_not_in(self, serial_not_in):
        """Sets the serial_not_in of this HostWhereInput.


        :param serial_not_in: The serial_not_in of this HostWhereInput.  # noqa: E501
        :type serial_not_in: list[str]
        """

        self._serial_not_in = serial_not_in

    @property
    def serial_not_starts_with(self):
        """Gets the serial_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The serial_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_not_starts_with

    @serial_not_starts_with.setter
    def serial_not_starts_with(self, serial_not_starts_with):
        """Sets the serial_not_starts_with of this HostWhereInput.


        :param serial_not_starts_with: The serial_not_starts_with of this HostWhereInput.  # noqa: E501
        :type serial_not_starts_with: str
        """

        self._serial_not_starts_with = serial_not_starts_with

    @property
    def serial_starts_with(self):
        """Gets the serial_starts_with of this HostWhereInput.  # noqa: E501


        :return: The serial_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._serial_starts_with

    @serial_starts_with.setter
    def serial_starts_with(self, serial_starts_with):
        """Sets the serial_starts_with of this HostWhereInput.


        :param serial_starts_with: The serial_starts_with of this HostWhereInput.  # noqa: E501
        :type serial_starts_with: str
        """

        self._serial_starts_with = serial_starts_with

    @property
    def ssd_data_capacity(self):
        """Gets the ssd_data_capacity of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity

    @ssd_data_capacity.setter
    def ssd_data_capacity(self, ssd_data_capacity):
        """Sets the ssd_data_capacity of this HostWhereInput.


        :param ssd_data_capacity: The ssd_data_capacity of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity: int
        """

        self._ssd_data_capacity = ssd_data_capacity

    @property
    def ssd_data_capacity_gt(self):
        """Gets the ssd_data_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity_gt

    @ssd_data_capacity_gt.setter
    def ssd_data_capacity_gt(self, ssd_data_capacity_gt):
        """Sets the ssd_data_capacity_gt of this HostWhereInput.


        :param ssd_data_capacity_gt: The ssd_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_gt: int
        """

        self._ssd_data_capacity_gt = ssd_data_capacity_gt

    @property
    def ssd_data_capacity_gte(self):
        """Gets the ssd_data_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity_gte

    @ssd_data_capacity_gte.setter
    def ssd_data_capacity_gte(self, ssd_data_capacity_gte):
        """Sets the ssd_data_capacity_gte of this HostWhereInput.


        :param ssd_data_capacity_gte: The ssd_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_gte: int
        """

        self._ssd_data_capacity_gte = ssd_data_capacity_gte

    @property
    def ssd_data_capacity_in(self):
        """Gets the ssd_data_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ssd_data_capacity_in

    @ssd_data_capacity_in.setter
    def ssd_data_capacity_in(self, ssd_data_capacity_in):
        """Sets the ssd_data_capacity_in of this HostWhereInput.


        :param ssd_data_capacity_in: The ssd_data_capacity_in of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_in: list[int]
        """

        self._ssd_data_capacity_in = ssd_data_capacity_in

    @property
    def ssd_data_capacity_lt(self):
        """Gets the ssd_data_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity_lt

    @ssd_data_capacity_lt.setter
    def ssd_data_capacity_lt(self, ssd_data_capacity_lt):
        """Sets the ssd_data_capacity_lt of this HostWhereInput.


        :param ssd_data_capacity_lt: The ssd_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_lt: int
        """

        self._ssd_data_capacity_lt = ssd_data_capacity_lt

    @property
    def ssd_data_capacity_lte(self):
        """Gets the ssd_data_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity_lte

    @ssd_data_capacity_lte.setter
    def ssd_data_capacity_lte(self, ssd_data_capacity_lte):
        """Sets the ssd_data_capacity_lte of this HostWhereInput.


        :param ssd_data_capacity_lte: The ssd_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_lte: int
        """

        self._ssd_data_capacity_lte = ssd_data_capacity_lte

    @property
    def ssd_data_capacity_not(self):
        """Gets the ssd_data_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity_not

    @ssd_data_capacity_not.setter
    def ssd_data_capacity_not(self, ssd_data_capacity_not):
        """Sets the ssd_data_capacity_not of this HostWhereInput.


        :param ssd_data_capacity_not: The ssd_data_capacity_not of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_not: int
        """

        self._ssd_data_capacity_not = ssd_data_capacity_not

    @property
    def ssd_data_capacity_not_in(self):
        """Gets the ssd_data_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The ssd_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ssd_data_capacity_not_in

    @ssd_data_capacity_not_in.setter
    def ssd_data_capacity_not_in(self, ssd_data_capacity_not_in):
        """Sets the ssd_data_capacity_not_in of this HostWhereInput.


        :param ssd_data_capacity_not_in: The ssd_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type ssd_data_capacity_not_in: list[int]
        """

        self._ssd_data_capacity_not_in = ssd_data_capacity_not_in

    @property
    def ssd_disk_count(self):
        """Gets the ssd_disk_count of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count

    @ssd_disk_count.setter
    def ssd_disk_count(self, ssd_disk_count):
        """Sets the ssd_disk_count of this HostWhereInput.


        :param ssd_disk_count: The ssd_disk_count of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count: int
        """

        self._ssd_disk_count = ssd_disk_count

    @property
    def ssd_disk_count_gt(self):
        """Gets the ssd_disk_count_gt of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count_gt

    @ssd_disk_count_gt.setter
    def ssd_disk_count_gt(self, ssd_disk_count_gt):
        """Sets the ssd_disk_count_gt of this HostWhereInput.


        :param ssd_disk_count_gt: The ssd_disk_count_gt of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_gt: int
        """

        self._ssd_disk_count_gt = ssd_disk_count_gt

    @property
    def ssd_disk_count_gte(self):
        """Gets the ssd_disk_count_gte of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count_gte

    @ssd_disk_count_gte.setter
    def ssd_disk_count_gte(self, ssd_disk_count_gte):
        """Sets the ssd_disk_count_gte of this HostWhereInput.


        :param ssd_disk_count_gte: The ssd_disk_count_gte of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_gte: int
        """

        self._ssd_disk_count_gte = ssd_disk_count_gte

    @property
    def ssd_disk_count_in(self):
        """Gets the ssd_disk_count_in of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ssd_disk_count_in

    @ssd_disk_count_in.setter
    def ssd_disk_count_in(self, ssd_disk_count_in):
        """Sets the ssd_disk_count_in of this HostWhereInput.


        :param ssd_disk_count_in: The ssd_disk_count_in of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_in: list[int]
        """

        self._ssd_disk_count_in = ssd_disk_count_in

    @property
    def ssd_disk_count_lt(self):
        """Gets the ssd_disk_count_lt of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count_lt

    @ssd_disk_count_lt.setter
    def ssd_disk_count_lt(self, ssd_disk_count_lt):
        """Sets the ssd_disk_count_lt of this HostWhereInput.


        :param ssd_disk_count_lt: The ssd_disk_count_lt of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_lt: int
        """

        self._ssd_disk_count_lt = ssd_disk_count_lt

    @property
    def ssd_disk_count_lte(self):
        """Gets the ssd_disk_count_lte of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count_lte

    @ssd_disk_count_lte.setter
    def ssd_disk_count_lte(self, ssd_disk_count_lte):
        """Sets the ssd_disk_count_lte of this HostWhereInput.


        :param ssd_disk_count_lte: The ssd_disk_count_lte of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_lte: int
        """

        self._ssd_disk_count_lte = ssd_disk_count_lte

    @property
    def ssd_disk_count_not(self):
        """Gets the ssd_disk_count_not of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count_not

    @ssd_disk_count_not.setter
    def ssd_disk_count_not(self, ssd_disk_count_not):
        """Sets the ssd_disk_count_not of this HostWhereInput.


        :param ssd_disk_count_not: The ssd_disk_count_not of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_not: int
        """

        self._ssd_disk_count_not = ssd_disk_count_not

    @property
    def ssd_disk_count_not_in(self):
        """Gets the ssd_disk_count_not_in of this HostWhereInput.  # noqa: E501


        :return: The ssd_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ssd_disk_count_not_in

    @ssd_disk_count_not_in.setter
    def ssd_disk_count_not_in(self, ssd_disk_count_not_in):
        """Sets the ssd_disk_count_not_in of this HostWhereInput.


        :param ssd_disk_count_not_in: The ssd_disk_count_not_in of this HostWhereInput.  # noqa: E501
        :type ssd_disk_count_not_in: list[int]
        """

        self._ssd_disk_count_not_in = ssd_disk_count_not_in

    @property
    def state(self):
        """Gets the state of this HostWhereInput.  # noqa: E501


        :return: The state of this HostWhereInput.  # noqa: E501
        :rtype: HostState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this HostWhereInput.


        :param state: The state of this HostWhereInput.  # noqa: E501
        :type state: HostState
        """

        self._state = state

    @property
    def state_in(self):
        """Gets the state_in of this HostWhereInput.  # noqa: E501


        :return: The state_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostState]
        """
        return self._state_in

    @state_in.setter
    def state_in(self, state_in):
        """Sets the state_in of this HostWhereInput.


        :param state_in: The state_in of this HostWhereInput.  # noqa: E501
        :type state_in: list[HostState]
        """

        self._state_in = state_in

    @property
    def state_not(self):
        """Gets the state_not of this HostWhereInput.  # noqa: E501


        :return: The state_not of this HostWhereInput.  # noqa: E501
        :rtype: HostState
        """
        return self._state_not

    @state_not.setter
    def state_not(self, state_not):
        """Sets the state_not of this HostWhereInput.


        :param state_not: The state_not of this HostWhereInput.  # noqa: E501
        :type state_not: HostState
        """

        self._state_not = state_not

    @property
    def state_not_in(self):
        """Gets the state_not_in of this HostWhereInput.  # noqa: E501


        :return: The state_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostState]
        """
        return self._state_not_in

    @state_not_in.setter
    def state_not_in(self, state_not_in):
        """Sets the state_not_in of this HostWhereInput.


        :param state_not_in: The state_not_in of this HostWhereInput.  # noqa: E501
        :type state_not_in: list[HostState]
        """

        self._state_not_in = state_not_in

    @property
    def status(self):
        """Gets the status of this HostWhereInput.  # noqa: E501


        :return: The status of this HostWhereInput.  # noqa: E501
        :rtype: HostStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this HostWhereInput.


        :param status: The status of this HostWhereInput.  # noqa: E501
        :type status: HostStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this HostWhereInput.  # noqa: E501


        :return: The status_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this HostWhereInput.


        :param status_in: The status_in of this HostWhereInput.  # noqa: E501
        :type status_in: list[HostStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this HostWhereInput.  # noqa: E501


        :return: The status_not of this HostWhereInput.  # noqa: E501
        :rtype: HostStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this HostWhereInput.


        :param status_not: The status_not of this HostWhereInput.  # noqa: E501
        :type status_not: HostStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this HostWhereInput.  # noqa: E501


        :return: The status_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[HostStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this HostWhereInput.


        :param status_not_in: The status_not_in of this HostWhereInput.  # noqa: E501
        :type status_not_in: list[HostStatus]
        """

        self._status_not_in = status_not_in

    @property
    def stopped_vm_num(self):
        """Gets the stopped_vm_num of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num

    @stopped_vm_num.setter
    def stopped_vm_num(self, stopped_vm_num):
        """Sets the stopped_vm_num of this HostWhereInput.


        :param stopped_vm_num: The stopped_vm_num of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num: int
        """

        self._stopped_vm_num = stopped_vm_num

    @property
    def stopped_vm_num_gt(self):
        """Gets the stopped_vm_num_gt of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_gt

    @stopped_vm_num_gt.setter
    def stopped_vm_num_gt(self, stopped_vm_num_gt):
        """Sets the stopped_vm_num_gt of this HostWhereInput.


        :param stopped_vm_num_gt: The stopped_vm_num_gt of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_gt: int
        """

        self._stopped_vm_num_gt = stopped_vm_num_gt

    @property
    def stopped_vm_num_gte(self):
        """Gets the stopped_vm_num_gte of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_gte

    @stopped_vm_num_gte.setter
    def stopped_vm_num_gte(self, stopped_vm_num_gte):
        """Sets the stopped_vm_num_gte of this HostWhereInput.


        :param stopped_vm_num_gte: The stopped_vm_num_gte of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_gte: int
        """

        self._stopped_vm_num_gte = stopped_vm_num_gte

    @property
    def stopped_vm_num_in(self):
        """Gets the stopped_vm_num_in of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._stopped_vm_num_in

    @stopped_vm_num_in.setter
    def stopped_vm_num_in(self, stopped_vm_num_in):
        """Sets the stopped_vm_num_in of this HostWhereInput.


        :param stopped_vm_num_in: The stopped_vm_num_in of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_in: list[int]
        """

        self._stopped_vm_num_in = stopped_vm_num_in

    @property
    def stopped_vm_num_lt(self):
        """Gets the stopped_vm_num_lt of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_lt

    @stopped_vm_num_lt.setter
    def stopped_vm_num_lt(self, stopped_vm_num_lt):
        """Sets the stopped_vm_num_lt of this HostWhereInput.


        :param stopped_vm_num_lt: The stopped_vm_num_lt of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_lt: int
        """

        self._stopped_vm_num_lt = stopped_vm_num_lt

    @property
    def stopped_vm_num_lte(self):
        """Gets the stopped_vm_num_lte of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_lte

    @stopped_vm_num_lte.setter
    def stopped_vm_num_lte(self, stopped_vm_num_lte):
        """Sets the stopped_vm_num_lte of this HostWhereInput.


        :param stopped_vm_num_lte: The stopped_vm_num_lte of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_lte: int
        """

        self._stopped_vm_num_lte = stopped_vm_num_lte

    @property
    def stopped_vm_num_not(self):
        """Gets the stopped_vm_num_not of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_not

    @stopped_vm_num_not.setter
    def stopped_vm_num_not(self, stopped_vm_num_not):
        """Sets the stopped_vm_num_not of this HostWhereInput.


        :param stopped_vm_num_not: The stopped_vm_num_not of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_not: int
        """

        self._stopped_vm_num_not = stopped_vm_num_not

    @property
    def stopped_vm_num_not_in(self):
        """Gets the stopped_vm_num_not_in of this HostWhereInput.  # noqa: E501


        :return: The stopped_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._stopped_vm_num_not_in

    @stopped_vm_num_not_in.setter
    def stopped_vm_num_not_in(self, stopped_vm_num_not_in):
        """Sets the stopped_vm_num_not_in of this HostWhereInput.


        :param stopped_vm_num_not_in: The stopped_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :type stopped_vm_num_not_in: list[int]
        """

        self._stopped_vm_num_not_in = stopped_vm_num_not_in

    @property
    def suspended_vm_num(self):
        """Gets the suspended_vm_num of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num

    @suspended_vm_num.setter
    def suspended_vm_num(self, suspended_vm_num):
        """Sets the suspended_vm_num of this HostWhereInput.


        :param suspended_vm_num: The suspended_vm_num of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num: int
        """

        self._suspended_vm_num = suspended_vm_num

    @property
    def suspended_vm_num_gt(self):
        """Gets the suspended_vm_num_gt of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_gt

    @suspended_vm_num_gt.setter
    def suspended_vm_num_gt(self, suspended_vm_num_gt):
        """Sets the suspended_vm_num_gt of this HostWhereInput.


        :param suspended_vm_num_gt: The suspended_vm_num_gt of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_gt: int
        """

        self._suspended_vm_num_gt = suspended_vm_num_gt

    @property
    def suspended_vm_num_gte(self):
        """Gets the suspended_vm_num_gte of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_gte

    @suspended_vm_num_gte.setter
    def suspended_vm_num_gte(self, suspended_vm_num_gte):
        """Sets the suspended_vm_num_gte of this HostWhereInput.


        :param suspended_vm_num_gte: The suspended_vm_num_gte of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_gte: int
        """

        self._suspended_vm_num_gte = suspended_vm_num_gte

    @property
    def suspended_vm_num_in(self):
        """Gets the suspended_vm_num_in of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._suspended_vm_num_in

    @suspended_vm_num_in.setter
    def suspended_vm_num_in(self, suspended_vm_num_in):
        """Sets the suspended_vm_num_in of this HostWhereInput.


        :param suspended_vm_num_in: The suspended_vm_num_in of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_in: list[int]
        """

        self._suspended_vm_num_in = suspended_vm_num_in

    @property
    def suspended_vm_num_lt(self):
        """Gets the suspended_vm_num_lt of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_lt

    @suspended_vm_num_lt.setter
    def suspended_vm_num_lt(self, suspended_vm_num_lt):
        """Sets the suspended_vm_num_lt of this HostWhereInput.


        :param suspended_vm_num_lt: The suspended_vm_num_lt of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_lt: int
        """

        self._suspended_vm_num_lt = suspended_vm_num_lt

    @property
    def suspended_vm_num_lte(self):
        """Gets the suspended_vm_num_lte of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_lte

    @suspended_vm_num_lte.setter
    def suspended_vm_num_lte(self, suspended_vm_num_lte):
        """Sets the suspended_vm_num_lte of this HostWhereInput.


        :param suspended_vm_num_lte: The suspended_vm_num_lte of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_lte: int
        """

        self._suspended_vm_num_lte = suspended_vm_num_lte

    @property
    def suspended_vm_num_not(self):
        """Gets the suspended_vm_num_not of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_not

    @suspended_vm_num_not.setter
    def suspended_vm_num_not(self, suspended_vm_num_not):
        """Sets the suspended_vm_num_not of this HostWhereInput.


        :param suspended_vm_num_not: The suspended_vm_num_not of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_not: int
        """

        self._suspended_vm_num_not = suspended_vm_num_not

    @property
    def suspended_vm_num_not_in(self):
        """Gets the suspended_vm_num_not_in of this HostWhereInput.  # noqa: E501


        :return: The suspended_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._suspended_vm_num_not_in

    @suspended_vm_num_not_in.setter
    def suspended_vm_num_not_in(self, suspended_vm_num_not_in):
        """Sets the suspended_vm_num_not_in of this HostWhereInput.


        :param suspended_vm_num_not_in: The suspended_vm_num_not_in of this HostWhereInput.  # noqa: E501
        :type suspended_vm_num_not_in: list[int]
        """

        self._suspended_vm_num_not_in = suspended_vm_num_not_in

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this HostWhereInput.


        :param total_cache_capacity: The total_cache_capacity of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity: int
        """

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_cache_capacity_gt(self):
        """Gets the total_cache_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gt

    @total_cache_capacity_gt.setter
    def total_cache_capacity_gt(self, total_cache_capacity_gt):
        """Sets the total_cache_capacity_gt of this HostWhereInput.


        :param total_cache_capacity_gt: The total_cache_capacity_gt of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_gt: int
        """

        self._total_cache_capacity_gt = total_cache_capacity_gt

    @property
    def total_cache_capacity_gte(self):
        """Gets the total_cache_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gte

    @total_cache_capacity_gte.setter
    def total_cache_capacity_gte(self, total_cache_capacity_gte):
        """Sets the total_cache_capacity_gte of this HostWhereInput.


        :param total_cache_capacity_gte: The total_cache_capacity_gte of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_gte: int
        """

        self._total_cache_capacity_gte = total_cache_capacity_gte

    @property
    def total_cache_capacity_in(self):
        """Gets the total_cache_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_in

    @total_cache_capacity_in.setter
    def total_cache_capacity_in(self, total_cache_capacity_in):
        """Sets the total_cache_capacity_in of this HostWhereInput.


        :param total_cache_capacity_in: The total_cache_capacity_in of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_in: list[int]
        """

        self._total_cache_capacity_in = total_cache_capacity_in

    @property
    def total_cache_capacity_lt(self):
        """Gets the total_cache_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lt

    @total_cache_capacity_lt.setter
    def total_cache_capacity_lt(self, total_cache_capacity_lt):
        """Sets the total_cache_capacity_lt of this HostWhereInput.


        :param total_cache_capacity_lt: The total_cache_capacity_lt of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_lt: int
        """

        self._total_cache_capacity_lt = total_cache_capacity_lt

    @property
    def total_cache_capacity_lte(self):
        """Gets the total_cache_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lte

    @total_cache_capacity_lte.setter
    def total_cache_capacity_lte(self, total_cache_capacity_lte):
        """Sets the total_cache_capacity_lte of this HostWhereInput.


        :param total_cache_capacity_lte: The total_cache_capacity_lte of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_lte: int
        """

        self._total_cache_capacity_lte = total_cache_capacity_lte

    @property
    def total_cache_capacity_not(self):
        """Gets the total_cache_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_not

    @total_cache_capacity_not.setter
    def total_cache_capacity_not(self, total_cache_capacity_not):
        """Sets the total_cache_capacity_not of this HostWhereInput.


        :param total_cache_capacity_not: The total_cache_capacity_not of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_not: int
        """

        self._total_cache_capacity_not = total_cache_capacity_not

    @property
    def total_cache_capacity_not_in(self):
        """Gets the total_cache_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_not_in

    @total_cache_capacity_not_in.setter
    def total_cache_capacity_not_in(self, total_cache_capacity_not_in):
        """Sets the total_cache_capacity_not_in of this HostWhereInput.


        :param total_cache_capacity_not_in: The total_cache_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type total_cache_capacity_not_in: list[int]
        """

        self._total_cache_capacity_not_in = total_cache_capacity_not_in

    @property
    def total_cpu_cores(self):
        """Gets the total_cpu_cores of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """Sets the total_cpu_cores of this HostWhereInput.


        :param total_cpu_cores: The total_cpu_cores of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores: int
        """

        self._total_cpu_cores = total_cpu_cores

    @property
    def total_cpu_cores_gt(self):
        """Gets the total_cpu_cores_gt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gt

    @total_cpu_cores_gt.setter
    def total_cpu_cores_gt(self, total_cpu_cores_gt):
        """Sets the total_cpu_cores_gt of this HostWhereInput.


        :param total_cpu_cores_gt: The total_cpu_cores_gt of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_gt: int
        """

        self._total_cpu_cores_gt = total_cpu_cores_gt

    @property
    def total_cpu_cores_gte(self):
        """Gets the total_cpu_cores_gte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gte

    @total_cpu_cores_gte.setter
    def total_cpu_cores_gte(self, total_cpu_cores_gte):
        """Sets the total_cpu_cores_gte of this HostWhereInput.


        :param total_cpu_cores_gte: The total_cpu_cores_gte of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_gte: int
        """

        self._total_cpu_cores_gte = total_cpu_cores_gte

    @property
    def total_cpu_cores_in(self):
        """Gets the total_cpu_cores_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_in

    @total_cpu_cores_in.setter
    def total_cpu_cores_in(self, total_cpu_cores_in):
        """Sets the total_cpu_cores_in of this HostWhereInput.


        :param total_cpu_cores_in: The total_cpu_cores_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_in: list[int]
        """

        self._total_cpu_cores_in = total_cpu_cores_in

    @property
    def total_cpu_cores_lt(self):
        """Gets the total_cpu_cores_lt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lt

    @total_cpu_cores_lt.setter
    def total_cpu_cores_lt(self, total_cpu_cores_lt):
        """Sets the total_cpu_cores_lt of this HostWhereInput.


        :param total_cpu_cores_lt: The total_cpu_cores_lt of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_lt: int
        """

        self._total_cpu_cores_lt = total_cpu_cores_lt

    @property
    def total_cpu_cores_lte(self):
        """Gets the total_cpu_cores_lte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lte

    @total_cpu_cores_lte.setter
    def total_cpu_cores_lte(self, total_cpu_cores_lte):
        """Sets the total_cpu_cores_lte of this HostWhereInput.


        :param total_cpu_cores_lte: The total_cpu_cores_lte of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_lte: int
        """

        self._total_cpu_cores_lte = total_cpu_cores_lte

    @property
    def total_cpu_cores_not(self):
        """Gets the total_cpu_cores_not of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_not

    @total_cpu_cores_not.setter
    def total_cpu_cores_not(self, total_cpu_cores_not):
        """Sets the total_cpu_cores_not of this HostWhereInput.


        :param total_cpu_cores_not: The total_cpu_cores_not of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_not: int
        """

        self._total_cpu_cores_not = total_cpu_cores_not

    @property
    def total_cpu_cores_not_in(self):
        """Gets the total_cpu_cores_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_not_in

    @total_cpu_cores_not_in.setter
    def total_cpu_cores_not_in(self, total_cpu_cores_not_in):
        """Sets the total_cpu_cores_not_in of this HostWhereInput.


        :param total_cpu_cores_not_in: The total_cpu_cores_not_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_cores_not_in: list[int]
        """

        self._total_cpu_cores_not_in = total_cpu_cores_not_in

    @property
    def total_cpu_hz(self):
        """Gets the total_cpu_hz of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz

    @total_cpu_hz.setter
    def total_cpu_hz(self, total_cpu_hz):
        """Sets the total_cpu_hz of this HostWhereInput.


        :param total_cpu_hz: The total_cpu_hz of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz: int
        """

        self._total_cpu_hz = total_cpu_hz

    @property
    def total_cpu_hz_gt(self):
        """Gets the total_cpu_hz_gt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gt

    @total_cpu_hz_gt.setter
    def total_cpu_hz_gt(self, total_cpu_hz_gt):
        """Sets the total_cpu_hz_gt of this HostWhereInput.


        :param total_cpu_hz_gt: The total_cpu_hz_gt of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_gt: int
        """

        self._total_cpu_hz_gt = total_cpu_hz_gt

    @property
    def total_cpu_hz_gte(self):
        """Gets the total_cpu_hz_gte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gte

    @total_cpu_hz_gte.setter
    def total_cpu_hz_gte(self, total_cpu_hz_gte):
        """Sets the total_cpu_hz_gte of this HostWhereInput.


        :param total_cpu_hz_gte: The total_cpu_hz_gte of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_gte: int
        """

        self._total_cpu_hz_gte = total_cpu_hz_gte

    @property
    def total_cpu_hz_in(self):
        """Gets the total_cpu_hz_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_in

    @total_cpu_hz_in.setter
    def total_cpu_hz_in(self, total_cpu_hz_in):
        """Sets the total_cpu_hz_in of this HostWhereInput.


        :param total_cpu_hz_in: The total_cpu_hz_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_in: list[int]
        """

        self._total_cpu_hz_in = total_cpu_hz_in

    @property
    def total_cpu_hz_lt(self):
        """Gets the total_cpu_hz_lt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lt

    @total_cpu_hz_lt.setter
    def total_cpu_hz_lt(self, total_cpu_hz_lt):
        """Sets the total_cpu_hz_lt of this HostWhereInput.


        :param total_cpu_hz_lt: The total_cpu_hz_lt of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_lt: int
        """

        self._total_cpu_hz_lt = total_cpu_hz_lt

    @property
    def total_cpu_hz_lte(self):
        """Gets the total_cpu_hz_lte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lte

    @total_cpu_hz_lte.setter
    def total_cpu_hz_lte(self, total_cpu_hz_lte):
        """Sets the total_cpu_hz_lte of this HostWhereInput.


        :param total_cpu_hz_lte: The total_cpu_hz_lte of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_lte: int
        """

        self._total_cpu_hz_lte = total_cpu_hz_lte

    @property
    def total_cpu_hz_not(self):
        """Gets the total_cpu_hz_not of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_not

    @total_cpu_hz_not.setter
    def total_cpu_hz_not(self, total_cpu_hz_not):
        """Sets the total_cpu_hz_not of this HostWhereInput.


        :param total_cpu_hz_not: The total_cpu_hz_not of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_not: int
        """

        self._total_cpu_hz_not = total_cpu_hz_not

    @property
    def total_cpu_hz_not_in(self):
        """Gets the total_cpu_hz_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_not_in

    @total_cpu_hz_not_in.setter
    def total_cpu_hz_not_in(self, total_cpu_hz_not_in):
        """Sets the total_cpu_hz_not_in of this HostWhereInput.


        :param total_cpu_hz_not_in: The total_cpu_hz_not_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_hz_not_in: list[int]
        """

        self._total_cpu_hz_not_in = total_cpu_hz_not_in

    @property
    def total_cpu_sockets(self):
        """Gets the total_cpu_sockets of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets

    @total_cpu_sockets.setter
    def total_cpu_sockets(self, total_cpu_sockets):
        """Sets the total_cpu_sockets of this HostWhereInput.


        :param total_cpu_sockets: The total_cpu_sockets of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets: int
        """

        self._total_cpu_sockets = total_cpu_sockets

    @property
    def total_cpu_sockets_gt(self):
        """Gets the total_cpu_sockets_gt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets_gt

    @total_cpu_sockets_gt.setter
    def total_cpu_sockets_gt(self, total_cpu_sockets_gt):
        """Sets the total_cpu_sockets_gt of this HostWhereInput.


        :param total_cpu_sockets_gt: The total_cpu_sockets_gt of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_gt: int
        """

        self._total_cpu_sockets_gt = total_cpu_sockets_gt

    @property
    def total_cpu_sockets_gte(self):
        """Gets the total_cpu_sockets_gte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets_gte

    @total_cpu_sockets_gte.setter
    def total_cpu_sockets_gte(self, total_cpu_sockets_gte):
        """Sets the total_cpu_sockets_gte of this HostWhereInput.


        :param total_cpu_sockets_gte: The total_cpu_sockets_gte of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_gte: int
        """

        self._total_cpu_sockets_gte = total_cpu_sockets_gte

    @property
    def total_cpu_sockets_in(self):
        """Gets the total_cpu_sockets_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_sockets_in

    @total_cpu_sockets_in.setter
    def total_cpu_sockets_in(self, total_cpu_sockets_in):
        """Sets the total_cpu_sockets_in of this HostWhereInput.


        :param total_cpu_sockets_in: The total_cpu_sockets_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_in: list[int]
        """

        self._total_cpu_sockets_in = total_cpu_sockets_in

    @property
    def total_cpu_sockets_lt(self):
        """Gets the total_cpu_sockets_lt of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets_lt

    @total_cpu_sockets_lt.setter
    def total_cpu_sockets_lt(self, total_cpu_sockets_lt):
        """Sets the total_cpu_sockets_lt of this HostWhereInput.


        :param total_cpu_sockets_lt: The total_cpu_sockets_lt of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_lt: int
        """

        self._total_cpu_sockets_lt = total_cpu_sockets_lt

    @property
    def total_cpu_sockets_lte(self):
        """Gets the total_cpu_sockets_lte of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets_lte

    @total_cpu_sockets_lte.setter
    def total_cpu_sockets_lte(self, total_cpu_sockets_lte):
        """Sets the total_cpu_sockets_lte of this HostWhereInput.


        :param total_cpu_sockets_lte: The total_cpu_sockets_lte of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_lte: int
        """

        self._total_cpu_sockets_lte = total_cpu_sockets_lte

    @property
    def total_cpu_sockets_not(self):
        """Gets the total_cpu_sockets_not of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets_not

    @total_cpu_sockets_not.setter
    def total_cpu_sockets_not(self, total_cpu_sockets_not):
        """Sets the total_cpu_sockets_not of this HostWhereInput.


        :param total_cpu_sockets_not: The total_cpu_sockets_not of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_not: int
        """

        self._total_cpu_sockets_not = total_cpu_sockets_not

    @property
    def total_cpu_sockets_not_in(self):
        """Gets the total_cpu_sockets_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_cpu_sockets_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_sockets_not_in

    @total_cpu_sockets_not_in.setter
    def total_cpu_sockets_not_in(self, total_cpu_sockets_not_in):
        """Sets the total_cpu_sockets_not_in of this HostWhereInput.


        :param total_cpu_sockets_not_in: The total_cpu_sockets_not_in of this HostWhereInput.  # noqa: E501
        :type total_cpu_sockets_not_in: list[int]
        """

        self._total_cpu_sockets_not_in = total_cpu_sockets_not_in

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this HostWhereInput.


        :param total_data_capacity: The total_data_capacity of this HostWhereInput.  # noqa: E501
        :type total_data_capacity: int
        """

        self._total_data_capacity = total_data_capacity

    @property
    def total_data_capacity_gt(self):
        """Gets the total_data_capacity_gt of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gt

    @total_data_capacity_gt.setter
    def total_data_capacity_gt(self, total_data_capacity_gt):
        """Sets the total_data_capacity_gt of this HostWhereInput.


        :param total_data_capacity_gt: The total_data_capacity_gt of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_gt: int
        """

        self._total_data_capacity_gt = total_data_capacity_gt

    @property
    def total_data_capacity_gte(self):
        """Gets the total_data_capacity_gte of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gte

    @total_data_capacity_gte.setter
    def total_data_capacity_gte(self, total_data_capacity_gte):
        """Sets the total_data_capacity_gte of this HostWhereInput.


        :param total_data_capacity_gte: The total_data_capacity_gte of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_gte: int
        """

        self._total_data_capacity_gte = total_data_capacity_gte

    @property
    def total_data_capacity_in(self):
        """Gets the total_data_capacity_in of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_in

    @total_data_capacity_in.setter
    def total_data_capacity_in(self, total_data_capacity_in):
        """Sets the total_data_capacity_in of this HostWhereInput.


        :param total_data_capacity_in: The total_data_capacity_in of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_in: list[int]
        """

        self._total_data_capacity_in = total_data_capacity_in

    @property
    def total_data_capacity_lt(self):
        """Gets the total_data_capacity_lt of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lt

    @total_data_capacity_lt.setter
    def total_data_capacity_lt(self, total_data_capacity_lt):
        """Sets the total_data_capacity_lt of this HostWhereInput.


        :param total_data_capacity_lt: The total_data_capacity_lt of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_lt: int
        """

        self._total_data_capacity_lt = total_data_capacity_lt

    @property
    def total_data_capacity_lte(self):
        """Gets the total_data_capacity_lte of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lte

    @total_data_capacity_lte.setter
    def total_data_capacity_lte(self, total_data_capacity_lte):
        """Sets the total_data_capacity_lte of this HostWhereInput.


        :param total_data_capacity_lte: The total_data_capacity_lte of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_lte: int
        """

        self._total_data_capacity_lte = total_data_capacity_lte

    @property
    def total_data_capacity_not(self):
        """Gets the total_data_capacity_not of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_not

    @total_data_capacity_not.setter
    def total_data_capacity_not(self, total_data_capacity_not):
        """Sets the total_data_capacity_not of this HostWhereInput.


        :param total_data_capacity_not: The total_data_capacity_not of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_not: int
        """

        self._total_data_capacity_not = total_data_capacity_not

    @property
    def total_data_capacity_not_in(self):
        """Gets the total_data_capacity_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_not_in

    @total_data_capacity_not_in.setter
    def total_data_capacity_not_in(self, total_data_capacity_not_in):
        """Sets the total_data_capacity_not_in of this HostWhereInput.


        :param total_data_capacity_not_in: The total_data_capacity_not_in of this HostWhereInput.  # noqa: E501
        :type total_data_capacity_not_in: list[int]
        """

        self._total_data_capacity_not_in = total_data_capacity_not_in

    @property
    def total_memory_bytes(self):
        """Gets the total_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes

    @total_memory_bytes.setter
    def total_memory_bytes(self, total_memory_bytes):
        """Sets the total_memory_bytes of this HostWhereInput.


        :param total_memory_bytes: The total_memory_bytes of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes: int
        """

        self._total_memory_bytes = total_memory_bytes

    @property
    def total_memory_bytes_gt(self):
        """Gets the total_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gt

    @total_memory_bytes_gt.setter
    def total_memory_bytes_gt(self, total_memory_bytes_gt):
        """Sets the total_memory_bytes_gt of this HostWhereInput.


        :param total_memory_bytes_gt: The total_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_gt: int
        """

        self._total_memory_bytes_gt = total_memory_bytes_gt

    @property
    def total_memory_bytes_gte(self):
        """Gets the total_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gte

    @total_memory_bytes_gte.setter
    def total_memory_bytes_gte(self, total_memory_bytes_gte):
        """Sets the total_memory_bytes_gte of this HostWhereInput.


        :param total_memory_bytes_gte: The total_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_gte: int
        """

        self._total_memory_bytes_gte = total_memory_bytes_gte

    @property
    def total_memory_bytes_in(self):
        """Gets the total_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_in

    @total_memory_bytes_in.setter
    def total_memory_bytes_in(self, total_memory_bytes_in):
        """Sets the total_memory_bytes_in of this HostWhereInput.


        :param total_memory_bytes_in: The total_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_in: list[int]
        """

        self._total_memory_bytes_in = total_memory_bytes_in

    @property
    def total_memory_bytes_lt(self):
        """Gets the total_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lt

    @total_memory_bytes_lt.setter
    def total_memory_bytes_lt(self, total_memory_bytes_lt):
        """Sets the total_memory_bytes_lt of this HostWhereInput.


        :param total_memory_bytes_lt: The total_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_lt: int
        """

        self._total_memory_bytes_lt = total_memory_bytes_lt

    @property
    def total_memory_bytes_lte(self):
        """Gets the total_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lte

    @total_memory_bytes_lte.setter
    def total_memory_bytes_lte(self, total_memory_bytes_lte):
        """Sets the total_memory_bytes_lte of this HostWhereInput.


        :param total_memory_bytes_lte: The total_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_lte: int
        """

        self._total_memory_bytes_lte = total_memory_bytes_lte

    @property
    def total_memory_bytes_not(self):
        """Gets the total_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_not

    @total_memory_bytes_not.setter
    def total_memory_bytes_not(self, total_memory_bytes_not):
        """Sets the total_memory_bytes_not of this HostWhereInput.


        :param total_memory_bytes_not: The total_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_not: int
        """

        self._total_memory_bytes_not = total_memory_bytes_not

    @property
    def total_memory_bytes_not_in(self):
        """Gets the total_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_not_in

    @total_memory_bytes_not_in.setter
    def total_memory_bytes_not_in(self, total_memory_bytes_not_in):
        """Sets the total_memory_bytes_not_in of this HostWhereInput.


        :param total_memory_bytes_not_in: The total_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type total_memory_bytes_not_in: list[int]
        """

        self._total_memory_bytes_not_in = total_memory_bytes_not_in

    @property
    def usb_devices_every(self):
        """Gets the usb_devices_every of this HostWhereInput.  # noqa: E501


        :return: The usb_devices_every of this HostWhereInput.  # noqa: E501
        :rtype: UsbDeviceWhereInput
        """
        return self._usb_devices_every

    @usb_devices_every.setter
    def usb_devices_every(self, usb_devices_every):
        """Sets the usb_devices_every of this HostWhereInput.


        :param usb_devices_every: The usb_devices_every of this HostWhereInput.  # noqa: E501
        :type usb_devices_every: UsbDeviceWhereInput
        """

        self._usb_devices_every = usb_devices_every

    @property
    def usb_devices_none(self):
        """Gets the usb_devices_none of this HostWhereInput.  # noqa: E501


        :return: The usb_devices_none of this HostWhereInput.  # noqa: E501
        :rtype: UsbDeviceWhereInput
        """
        return self._usb_devices_none

    @usb_devices_none.setter
    def usb_devices_none(self, usb_devices_none):
        """Sets the usb_devices_none of this HostWhereInput.


        :param usb_devices_none: The usb_devices_none of this HostWhereInput.  # noqa: E501
        :type usb_devices_none: UsbDeviceWhereInput
        """

        self._usb_devices_none = usb_devices_none

    @property
    def usb_devices_some(self):
        """Gets the usb_devices_some of this HostWhereInput.  # noqa: E501


        :return: The usb_devices_some of this HostWhereInput.  # noqa: E501
        :rtype: UsbDeviceWhereInput
        """
        return self._usb_devices_some

    @usb_devices_some.setter
    def usb_devices_some(self, usb_devices_some):
        """Sets the usb_devices_some of this HostWhereInput.


        :param usb_devices_some: The usb_devices_some of this HostWhereInput.  # noqa: E501
        :type usb_devices_some: UsbDeviceWhereInput
        """

        self._usb_devices_some = usb_devices_some

    @property
    def used_cache_space(self):
        """Gets the used_cache_space of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space

    @used_cache_space.setter
    def used_cache_space(self, used_cache_space):
        """Sets the used_cache_space of this HostWhereInput.


        :param used_cache_space: The used_cache_space of this HostWhereInput.  # noqa: E501
        :type used_cache_space: int
        """

        self._used_cache_space = used_cache_space

    @property
    def used_cache_space_gt(self):
        """Gets the used_cache_space_gt of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_gt

    @used_cache_space_gt.setter
    def used_cache_space_gt(self, used_cache_space_gt):
        """Sets the used_cache_space_gt of this HostWhereInput.


        :param used_cache_space_gt: The used_cache_space_gt of this HostWhereInput.  # noqa: E501
        :type used_cache_space_gt: int
        """

        self._used_cache_space_gt = used_cache_space_gt

    @property
    def used_cache_space_gte(self):
        """Gets the used_cache_space_gte of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_gte

    @used_cache_space_gte.setter
    def used_cache_space_gte(self, used_cache_space_gte):
        """Sets the used_cache_space_gte of this HostWhereInput.


        :param used_cache_space_gte: The used_cache_space_gte of this HostWhereInput.  # noqa: E501
        :type used_cache_space_gte: int
        """

        self._used_cache_space_gte = used_cache_space_gte

    @property
    def used_cache_space_in(self):
        """Gets the used_cache_space_in of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_cache_space_in

    @used_cache_space_in.setter
    def used_cache_space_in(self, used_cache_space_in):
        """Sets the used_cache_space_in of this HostWhereInput.


        :param used_cache_space_in: The used_cache_space_in of this HostWhereInput.  # noqa: E501
        :type used_cache_space_in: list[int]
        """

        self._used_cache_space_in = used_cache_space_in

    @property
    def used_cache_space_lt(self):
        """Gets the used_cache_space_lt of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_lt

    @used_cache_space_lt.setter
    def used_cache_space_lt(self, used_cache_space_lt):
        """Sets the used_cache_space_lt of this HostWhereInput.


        :param used_cache_space_lt: The used_cache_space_lt of this HostWhereInput.  # noqa: E501
        :type used_cache_space_lt: int
        """

        self._used_cache_space_lt = used_cache_space_lt

    @property
    def used_cache_space_lte(self):
        """Gets the used_cache_space_lte of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_lte

    @used_cache_space_lte.setter
    def used_cache_space_lte(self, used_cache_space_lte):
        """Sets the used_cache_space_lte of this HostWhereInput.


        :param used_cache_space_lte: The used_cache_space_lte of this HostWhereInput.  # noqa: E501
        :type used_cache_space_lte: int
        """

        self._used_cache_space_lte = used_cache_space_lte

    @property
    def used_cache_space_not(self):
        """Gets the used_cache_space_not of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_cache_space_not

    @used_cache_space_not.setter
    def used_cache_space_not(self, used_cache_space_not):
        """Sets the used_cache_space_not of this HostWhereInput.


        :param used_cache_space_not: The used_cache_space_not of this HostWhereInput.  # noqa: E501
        :type used_cache_space_not: int
        """

        self._used_cache_space_not = used_cache_space_not

    @property
    def used_cache_space_not_in(self):
        """Gets the used_cache_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The used_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_cache_space_not_in

    @used_cache_space_not_in.setter
    def used_cache_space_not_in(self, used_cache_space_not_in):
        """Sets the used_cache_space_not_in of this HostWhereInput.


        :param used_cache_space_not_in: The used_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :type used_cache_space_not_in: list[int]
        """

        self._used_cache_space_not_in = used_cache_space_not_in

    @property
    def used_cpu_hz(self):
        """Gets the used_cpu_hz of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz

    @used_cpu_hz.setter
    def used_cpu_hz(self, used_cpu_hz):
        """Sets the used_cpu_hz of this HostWhereInput.


        :param used_cpu_hz: The used_cpu_hz of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz: float
        """

        self._used_cpu_hz = used_cpu_hz

    @property
    def used_cpu_hz_gt(self):
        """Gets the used_cpu_hz_gt of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_gt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz_gt

    @used_cpu_hz_gt.setter
    def used_cpu_hz_gt(self, used_cpu_hz_gt):
        """Sets the used_cpu_hz_gt of this HostWhereInput.


        :param used_cpu_hz_gt: The used_cpu_hz_gt of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_gt: float
        """

        self._used_cpu_hz_gt = used_cpu_hz_gt

    @property
    def used_cpu_hz_gte(self):
        """Gets the used_cpu_hz_gte of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_gte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz_gte

    @used_cpu_hz_gte.setter
    def used_cpu_hz_gte(self, used_cpu_hz_gte):
        """Sets the used_cpu_hz_gte of this HostWhereInput.


        :param used_cpu_hz_gte: The used_cpu_hz_gte of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_gte: float
        """

        self._used_cpu_hz_gte = used_cpu_hz_gte

    @property
    def used_cpu_hz_in(self):
        """Gets the used_cpu_hz_in of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_cpu_hz_in

    @used_cpu_hz_in.setter
    def used_cpu_hz_in(self, used_cpu_hz_in):
        """Sets the used_cpu_hz_in of this HostWhereInput.


        :param used_cpu_hz_in: The used_cpu_hz_in of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_in: list[float]
        """

        self._used_cpu_hz_in = used_cpu_hz_in

    @property
    def used_cpu_hz_lt(self):
        """Gets the used_cpu_hz_lt of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_lt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz_lt

    @used_cpu_hz_lt.setter
    def used_cpu_hz_lt(self, used_cpu_hz_lt):
        """Sets the used_cpu_hz_lt of this HostWhereInput.


        :param used_cpu_hz_lt: The used_cpu_hz_lt of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_lt: float
        """

        self._used_cpu_hz_lt = used_cpu_hz_lt

    @property
    def used_cpu_hz_lte(self):
        """Gets the used_cpu_hz_lte of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_lte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz_lte

    @used_cpu_hz_lte.setter
    def used_cpu_hz_lte(self, used_cpu_hz_lte):
        """Sets the used_cpu_hz_lte of this HostWhereInput.


        :param used_cpu_hz_lte: The used_cpu_hz_lte of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_lte: float
        """

        self._used_cpu_hz_lte = used_cpu_hz_lte

    @property
    def used_cpu_hz_not(self):
        """Gets the used_cpu_hz_not of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_not of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_cpu_hz_not

    @used_cpu_hz_not.setter
    def used_cpu_hz_not(self, used_cpu_hz_not):
        """Sets the used_cpu_hz_not of this HostWhereInput.


        :param used_cpu_hz_not: The used_cpu_hz_not of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_not: float
        """

        self._used_cpu_hz_not = used_cpu_hz_not

    @property
    def used_cpu_hz_not_in(self):
        """Gets the used_cpu_hz_not_in of this HostWhereInput.  # noqa: E501


        :return: The used_cpu_hz_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_cpu_hz_not_in

    @used_cpu_hz_not_in.setter
    def used_cpu_hz_not_in(self, used_cpu_hz_not_in):
        """Sets the used_cpu_hz_not_in of this HostWhereInput.


        :param used_cpu_hz_not_in: The used_cpu_hz_not_in of this HostWhereInput.  # noqa: E501
        :type used_cpu_hz_not_in: list[float]
        """

        self._used_cpu_hz_not_in = used_cpu_hz_not_in

    @property
    def used_data_space(self):
        """Gets the used_data_space of this HostWhereInput.  # noqa: E501


        :return: The used_data_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this HostWhereInput.


        :param used_data_space: The used_data_space of this HostWhereInput.  # noqa: E501
        :type used_data_space: int
        """

        self._used_data_space = used_data_space

    @property
    def used_data_space_gt(self):
        """Gets the used_data_space_gt of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gt

    @used_data_space_gt.setter
    def used_data_space_gt(self, used_data_space_gt):
        """Sets the used_data_space_gt of this HostWhereInput.


        :param used_data_space_gt: The used_data_space_gt of this HostWhereInput.  # noqa: E501
        :type used_data_space_gt: int
        """

        self._used_data_space_gt = used_data_space_gt

    @property
    def used_data_space_gte(self):
        """Gets the used_data_space_gte of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gte

    @used_data_space_gte.setter
    def used_data_space_gte(self, used_data_space_gte):
        """Sets the used_data_space_gte of this HostWhereInput.


        :param used_data_space_gte: The used_data_space_gte of this HostWhereInput.  # noqa: E501
        :type used_data_space_gte: int
        """

        self._used_data_space_gte = used_data_space_gte

    @property
    def used_data_space_in(self):
        """Gets the used_data_space_in of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_in

    @used_data_space_in.setter
    def used_data_space_in(self, used_data_space_in):
        """Sets the used_data_space_in of this HostWhereInput.


        :param used_data_space_in: The used_data_space_in of this HostWhereInput.  # noqa: E501
        :type used_data_space_in: list[int]
        """

        self._used_data_space_in = used_data_space_in

    @property
    def used_data_space_lt(self):
        """Gets the used_data_space_lt of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lt

    @used_data_space_lt.setter
    def used_data_space_lt(self, used_data_space_lt):
        """Sets the used_data_space_lt of this HostWhereInput.


        :param used_data_space_lt: The used_data_space_lt of this HostWhereInput.  # noqa: E501
        :type used_data_space_lt: int
        """

        self._used_data_space_lt = used_data_space_lt

    @property
    def used_data_space_lte(self):
        """Gets the used_data_space_lte of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lte

    @used_data_space_lte.setter
    def used_data_space_lte(self, used_data_space_lte):
        """Sets the used_data_space_lte of this HostWhereInput.


        :param used_data_space_lte: The used_data_space_lte of this HostWhereInput.  # noqa: E501
        :type used_data_space_lte: int
        """

        self._used_data_space_lte = used_data_space_lte

    @property
    def used_data_space_not(self):
        """Gets the used_data_space_not of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_not

    @used_data_space_not.setter
    def used_data_space_not(self, used_data_space_not):
        """Sets the used_data_space_not of this HostWhereInput.


        :param used_data_space_not: The used_data_space_not of this HostWhereInput.  # noqa: E501
        :type used_data_space_not: int
        """

        self._used_data_space_not = used_data_space_not

    @property
    def used_data_space_not_in(self):
        """Gets the used_data_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The used_data_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_not_in

    @used_data_space_not_in.setter
    def used_data_space_not_in(self, used_data_space_not_in):
        """Sets the used_data_space_not_in of this HostWhereInput.


        :param used_data_space_not_in: The used_data_space_not_in of this HostWhereInput.  # noqa: E501
        :type used_data_space_not_in: list[int]
        """

        self._used_data_space_not_in = used_data_space_not_in

    @property
    def used_memory_bytes(self):
        """Gets the used_memory_bytes of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes

    @used_memory_bytes.setter
    def used_memory_bytes(self, used_memory_bytes):
        """Sets the used_memory_bytes of this HostWhereInput.


        :param used_memory_bytes: The used_memory_bytes of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes: float
        """

        self._used_memory_bytes = used_memory_bytes

    @property
    def used_memory_bytes_gt(self):
        """Gets the used_memory_bytes_gt of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes_gt

    @used_memory_bytes_gt.setter
    def used_memory_bytes_gt(self, used_memory_bytes_gt):
        """Sets the used_memory_bytes_gt of this HostWhereInput.


        :param used_memory_bytes_gt: The used_memory_bytes_gt of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_gt: float
        """

        self._used_memory_bytes_gt = used_memory_bytes_gt

    @property
    def used_memory_bytes_gte(self):
        """Gets the used_memory_bytes_gte of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes_gte

    @used_memory_bytes_gte.setter
    def used_memory_bytes_gte(self, used_memory_bytes_gte):
        """Sets the used_memory_bytes_gte of this HostWhereInput.


        :param used_memory_bytes_gte: The used_memory_bytes_gte of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_gte: float
        """

        self._used_memory_bytes_gte = used_memory_bytes_gte

    @property
    def used_memory_bytes_in(self):
        """Gets the used_memory_bytes_in of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_memory_bytes_in

    @used_memory_bytes_in.setter
    def used_memory_bytes_in(self, used_memory_bytes_in):
        """Sets the used_memory_bytes_in of this HostWhereInput.


        :param used_memory_bytes_in: The used_memory_bytes_in of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_in: list[float]
        """

        self._used_memory_bytes_in = used_memory_bytes_in

    @property
    def used_memory_bytes_lt(self):
        """Gets the used_memory_bytes_lt of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes_lt

    @used_memory_bytes_lt.setter
    def used_memory_bytes_lt(self, used_memory_bytes_lt):
        """Sets the used_memory_bytes_lt of this HostWhereInput.


        :param used_memory_bytes_lt: The used_memory_bytes_lt of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_lt: float
        """

        self._used_memory_bytes_lt = used_memory_bytes_lt

    @property
    def used_memory_bytes_lte(self):
        """Gets the used_memory_bytes_lte of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes_lte

    @used_memory_bytes_lte.setter
    def used_memory_bytes_lte(self, used_memory_bytes_lte):
        """Sets the used_memory_bytes_lte of this HostWhereInput.


        :param used_memory_bytes_lte: The used_memory_bytes_lte of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_lte: float
        """

        self._used_memory_bytes_lte = used_memory_bytes_lte

    @property
    def used_memory_bytes_not(self):
        """Gets the used_memory_bytes_not of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_memory_bytes_not

    @used_memory_bytes_not.setter
    def used_memory_bytes_not(self, used_memory_bytes_not):
        """Sets the used_memory_bytes_not of this HostWhereInput.


        :param used_memory_bytes_not: The used_memory_bytes_not of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_not: float
        """

        self._used_memory_bytes_not = used_memory_bytes_not

    @property
    def used_memory_bytes_not_in(self):
        """Gets the used_memory_bytes_not_in of this HostWhereInput.  # noqa: E501


        :return: The used_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_memory_bytes_not_in

    @used_memory_bytes_not_in.setter
    def used_memory_bytes_not_in(self, used_memory_bytes_not_in):
        """Sets the used_memory_bytes_not_in of this HostWhereInput.


        :param used_memory_bytes_not_in: The used_memory_bytes_not_in of this HostWhereInput.  # noqa: E501
        :type used_memory_bytes_not_in: list[float]
        """

        self._used_memory_bytes_not_in = used_memory_bytes_not_in

    @property
    def valid_cache_space(self):
        """Gets the valid_cache_space of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space

    @valid_cache_space.setter
    def valid_cache_space(self, valid_cache_space):
        """Sets the valid_cache_space of this HostWhereInput.


        :param valid_cache_space: The valid_cache_space of this HostWhereInput.  # noqa: E501
        :type valid_cache_space: int
        """

        self._valid_cache_space = valid_cache_space

    @property
    def valid_cache_space_gt(self):
        """Gets the valid_cache_space_gt of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_gt

    @valid_cache_space_gt.setter
    def valid_cache_space_gt(self, valid_cache_space_gt):
        """Sets the valid_cache_space_gt of this HostWhereInput.


        :param valid_cache_space_gt: The valid_cache_space_gt of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_gt: int
        """

        self._valid_cache_space_gt = valid_cache_space_gt

    @property
    def valid_cache_space_gte(self):
        """Gets the valid_cache_space_gte of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_gte

    @valid_cache_space_gte.setter
    def valid_cache_space_gte(self, valid_cache_space_gte):
        """Sets the valid_cache_space_gte of this HostWhereInput.


        :param valid_cache_space_gte: The valid_cache_space_gte of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_gte: int
        """

        self._valid_cache_space_gte = valid_cache_space_gte

    @property
    def valid_cache_space_in(self):
        """Gets the valid_cache_space_in of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_cache_space_in

    @valid_cache_space_in.setter
    def valid_cache_space_in(self, valid_cache_space_in):
        """Sets the valid_cache_space_in of this HostWhereInput.


        :param valid_cache_space_in: The valid_cache_space_in of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_in: list[int]
        """

        self._valid_cache_space_in = valid_cache_space_in

    @property
    def valid_cache_space_lt(self):
        """Gets the valid_cache_space_lt of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_lt

    @valid_cache_space_lt.setter
    def valid_cache_space_lt(self, valid_cache_space_lt):
        """Sets the valid_cache_space_lt of this HostWhereInput.


        :param valid_cache_space_lt: The valid_cache_space_lt of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_lt: int
        """

        self._valid_cache_space_lt = valid_cache_space_lt

    @property
    def valid_cache_space_lte(self):
        """Gets the valid_cache_space_lte of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_lte

    @valid_cache_space_lte.setter
    def valid_cache_space_lte(self, valid_cache_space_lte):
        """Sets the valid_cache_space_lte of this HostWhereInput.


        :param valid_cache_space_lte: The valid_cache_space_lte of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_lte: int
        """

        self._valid_cache_space_lte = valid_cache_space_lte

    @property
    def valid_cache_space_not(self):
        """Gets the valid_cache_space_not of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_cache_space_not

    @valid_cache_space_not.setter
    def valid_cache_space_not(self, valid_cache_space_not):
        """Sets the valid_cache_space_not of this HostWhereInput.


        :param valid_cache_space_not: The valid_cache_space_not of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_not: int
        """

        self._valid_cache_space_not = valid_cache_space_not

    @property
    def valid_cache_space_not_in(self):
        """Gets the valid_cache_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The valid_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_cache_space_not_in

    @valid_cache_space_not_in.setter
    def valid_cache_space_not_in(self, valid_cache_space_not_in):
        """Sets the valid_cache_space_not_in of this HostWhereInput.


        :param valid_cache_space_not_in: The valid_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :type valid_cache_space_not_in: list[int]
        """

        self._valid_cache_space_not_in = valid_cache_space_not_in

    @property
    def valid_free_cache_space(self):
        """Gets the valid_free_cache_space of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space

    @valid_free_cache_space.setter
    def valid_free_cache_space(self, valid_free_cache_space):
        """Sets the valid_free_cache_space of this HostWhereInput.


        :param valid_free_cache_space: The valid_free_cache_space of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space: int
        """

        self._valid_free_cache_space = valid_free_cache_space

    @property
    def valid_free_cache_space_gt(self):
        """Gets the valid_free_cache_space_gt of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_gt

    @valid_free_cache_space_gt.setter
    def valid_free_cache_space_gt(self, valid_free_cache_space_gt):
        """Sets the valid_free_cache_space_gt of this HostWhereInput.


        :param valid_free_cache_space_gt: The valid_free_cache_space_gt of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_gt: int
        """

        self._valid_free_cache_space_gt = valid_free_cache_space_gt

    @property
    def valid_free_cache_space_gte(self):
        """Gets the valid_free_cache_space_gte of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_gte

    @valid_free_cache_space_gte.setter
    def valid_free_cache_space_gte(self, valid_free_cache_space_gte):
        """Sets the valid_free_cache_space_gte of this HostWhereInput.


        :param valid_free_cache_space_gte: The valid_free_cache_space_gte of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_gte: int
        """

        self._valid_free_cache_space_gte = valid_free_cache_space_gte

    @property
    def valid_free_cache_space_in(self):
        """Gets the valid_free_cache_space_in of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_free_cache_space_in

    @valid_free_cache_space_in.setter
    def valid_free_cache_space_in(self, valid_free_cache_space_in):
        """Sets the valid_free_cache_space_in of this HostWhereInput.


        :param valid_free_cache_space_in: The valid_free_cache_space_in of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_in: list[int]
        """

        self._valid_free_cache_space_in = valid_free_cache_space_in

    @property
    def valid_free_cache_space_lt(self):
        """Gets the valid_free_cache_space_lt of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_lt

    @valid_free_cache_space_lt.setter
    def valid_free_cache_space_lt(self, valid_free_cache_space_lt):
        """Sets the valid_free_cache_space_lt of this HostWhereInput.


        :param valid_free_cache_space_lt: The valid_free_cache_space_lt of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_lt: int
        """

        self._valid_free_cache_space_lt = valid_free_cache_space_lt

    @property
    def valid_free_cache_space_lte(self):
        """Gets the valid_free_cache_space_lte of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_lte

    @valid_free_cache_space_lte.setter
    def valid_free_cache_space_lte(self, valid_free_cache_space_lte):
        """Sets the valid_free_cache_space_lte of this HostWhereInput.


        :param valid_free_cache_space_lte: The valid_free_cache_space_lte of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_lte: int
        """

        self._valid_free_cache_space_lte = valid_free_cache_space_lte

    @property
    def valid_free_cache_space_not(self):
        """Gets the valid_free_cache_space_not of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_free_cache_space_not

    @valid_free_cache_space_not.setter
    def valid_free_cache_space_not(self, valid_free_cache_space_not):
        """Sets the valid_free_cache_space_not of this HostWhereInput.


        :param valid_free_cache_space_not: The valid_free_cache_space_not of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_not: int
        """

        self._valid_free_cache_space_not = valid_free_cache_space_not

    @property
    def valid_free_cache_space_not_in(self):
        """Gets the valid_free_cache_space_not_in of this HostWhereInput.  # noqa: E501


        :return: The valid_free_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_free_cache_space_not_in

    @valid_free_cache_space_not_in.setter
    def valid_free_cache_space_not_in(self, valid_free_cache_space_not_in):
        """Sets the valid_free_cache_space_not_in of this HostWhereInput.


        :param valid_free_cache_space_not_in: The valid_free_cache_space_not_in of this HostWhereInput.  # noqa: E501
        :type valid_free_cache_space_not_in: list[int]
        """

        self._valid_free_cache_space_not_in = valid_free_cache_space_not_in

    @property
    def vm_num(self):
        """Gets the vm_num of this HostWhereInput.  # noqa: E501


        :return: The vm_num of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this HostWhereInput.


        :param vm_num: The vm_num of this HostWhereInput.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vm_num_gt(self):
        """Gets the vm_num_gt of this HostWhereInput.  # noqa: E501


        :return: The vm_num_gt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_gt

    @vm_num_gt.setter
    def vm_num_gt(self, vm_num_gt):
        """Sets the vm_num_gt of this HostWhereInput.


        :param vm_num_gt: The vm_num_gt of this HostWhereInput.  # noqa: E501
        :type vm_num_gt: int
        """

        self._vm_num_gt = vm_num_gt

    @property
    def vm_num_gte(self):
        """Gets the vm_num_gte of this HostWhereInput.  # noqa: E501


        :return: The vm_num_gte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_gte

    @vm_num_gte.setter
    def vm_num_gte(self, vm_num_gte):
        """Sets the vm_num_gte of this HostWhereInput.


        :param vm_num_gte: The vm_num_gte of this HostWhereInput.  # noqa: E501
        :type vm_num_gte: int
        """

        self._vm_num_gte = vm_num_gte

    @property
    def vm_num_in(self):
        """Gets the vm_num_in of this HostWhereInput.  # noqa: E501


        :return: The vm_num_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vm_num_in

    @vm_num_in.setter
    def vm_num_in(self, vm_num_in):
        """Sets the vm_num_in of this HostWhereInput.


        :param vm_num_in: The vm_num_in of this HostWhereInput.  # noqa: E501
        :type vm_num_in: list[int]
        """

        self._vm_num_in = vm_num_in

    @property
    def vm_num_lt(self):
        """Gets the vm_num_lt of this HostWhereInput.  # noqa: E501


        :return: The vm_num_lt of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_lt

    @vm_num_lt.setter
    def vm_num_lt(self, vm_num_lt):
        """Sets the vm_num_lt of this HostWhereInput.


        :param vm_num_lt: The vm_num_lt of this HostWhereInput.  # noqa: E501
        :type vm_num_lt: int
        """

        self._vm_num_lt = vm_num_lt

    @property
    def vm_num_lte(self):
        """Gets the vm_num_lte of this HostWhereInput.  # noqa: E501


        :return: The vm_num_lte of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_lte

    @vm_num_lte.setter
    def vm_num_lte(self, vm_num_lte):
        """Sets the vm_num_lte of this HostWhereInput.


        :param vm_num_lte: The vm_num_lte of this HostWhereInput.  # noqa: E501
        :type vm_num_lte: int
        """

        self._vm_num_lte = vm_num_lte

    @property
    def vm_num_not(self):
        """Gets the vm_num_not of this HostWhereInput.  # noqa: E501


        :return: The vm_num_not of this HostWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_not

    @vm_num_not.setter
    def vm_num_not(self, vm_num_not):
        """Sets the vm_num_not of this HostWhereInput.


        :param vm_num_not: The vm_num_not of this HostWhereInput.  # noqa: E501
        :type vm_num_not: int
        """

        self._vm_num_not = vm_num_not

    @property
    def vm_num_not_in(self):
        """Gets the vm_num_not_in of this HostWhereInput.  # noqa: E501


        :return: The vm_num_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vm_num_not_in

    @vm_num_not_in.setter
    def vm_num_not_in(self, vm_num_not_in):
        """Sets the vm_num_not_in of this HostWhereInput.


        :param vm_num_not_in: The vm_num_not_in of this HostWhereInput.  # noqa: E501
        :type vm_num_not_in: list[int]
        """

        self._vm_num_not_in = vm_num_not_in

    @property
    def vmotion_ip(self):
        """Gets the vmotion_ip of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip

    @vmotion_ip.setter
    def vmotion_ip(self, vmotion_ip):
        """Sets the vmotion_ip of this HostWhereInput.


        :param vmotion_ip: The vmotion_ip of this HostWhereInput.  # noqa: E501
        :type vmotion_ip: str
        """

        self._vmotion_ip = vmotion_ip

    @property
    def vmotion_ip_contains(self):
        """Gets the vmotion_ip_contains of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_contains

    @vmotion_ip_contains.setter
    def vmotion_ip_contains(self, vmotion_ip_contains):
        """Sets the vmotion_ip_contains of this HostWhereInput.


        :param vmotion_ip_contains: The vmotion_ip_contains of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_contains: str
        """

        self._vmotion_ip_contains = vmotion_ip_contains

    @property
    def vmotion_ip_ends_with(self):
        """Gets the vmotion_ip_ends_with of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_ends_with

    @vmotion_ip_ends_with.setter
    def vmotion_ip_ends_with(self, vmotion_ip_ends_with):
        """Sets the vmotion_ip_ends_with of this HostWhereInput.


        :param vmotion_ip_ends_with: The vmotion_ip_ends_with of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_ends_with: str
        """

        self._vmotion_ip_ends_with = vmotion_ip_ends_with

    @property
    def vmotion_ip_gt(self):
        """Gets the vmotion_ip_gt of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_gt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_gt

    @vmotion_ip_gt.setter
    def vmotion_ip_gt(self, vmotion_ip_gt):
        """Sets the vmotion_ip_gt of this HostWhereInput.


        :param vmotion_ip_gt: The vmotion_ip_gt of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_gt: str
        """

        self._vmotion_ip_gt = vmotion_ip_gt

    @property
    def vmotion_ip_gte(self):
        """Gets the vmotion_ip_gte of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_gte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_gte

    @vmotion_ip_gte.setter
    def vmotion_ip_gte(self, vmotion_ip_gte):
        """Sets the vmotion_ip_gte of this HostWhereInput.


        :param vmotion_ip_gte: The vmotion_ip_gte of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_gte: str
        """

        self._vmotion_ip_gte = vmotion_ip_gte

    @property
    def vmotion_ip_in(self):
        """Gets the vmotion_ip_in of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vmotion_ip_in

    @vmotion_ip_in.setter
    def vmotion_ip_in(self, vmotion_ip_in):
        """Sets the vmotion_ip_in of this HostWhereInput.


        :param vmotion_ip_in: The vmotion_ip_in of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_in: list[str]
        """

        self._vmotion_ip_in = vmotion_ip_in

    @property
    def vmotion_ip_lt(self):
        """Gets the vmotion_ip_lt of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_lt of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_lt

    @vmotion_ip_lt.setter
    def vmotion_ip_lt(self, vmotion_ip_lt):
        """Sets the vmotion_ip_lt of this HostWhereInput.


        :param vmotion_ip_lt: The vmotion_ip_lt of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_lt: str
        """

        self._vmotion_ip_lt = vmotion_ip_lt

    @property
    def vmotion_ip_lte(self):
        """Gets the vmotion_ip_lte of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_lte of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_lte

    @vmotion_ip_lte.setter
    def vmotion_ip_lte(self, vmotion_ip_lte):
        """Sets the vmotion_ip_lte of this HostWhereInput.


        :param vmotion_ip_lte: The vmotion_ip_lte of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_lte: str
        """

        self._vmotion_ip_lte = vmotion_ip_lte

    @property
    def vmotion_ip_not(self):
        """Gets the vmotion_ip_not of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_not of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_not

    @vmotion_ip_not.setter
    def vmotion_ip_not(self, vmotion_ip_not):
        """Sets the vmotion_ip_not of this HostWhereInput.


        :param vmotion_ip_not: The vmotion_ip_not of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_not: str
        """

        self._vmotion_ip_not = vmotion_ip_not

    @property
    def vmotion_ip_not_contains(self):
        """Gets the vmotion_ip_not_contains of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_not_contains of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_not_contains

    @vmotion_ip_not_contains.setter
    def vmotion_ip_not_contains(self, vmotion_ip_not_contains):
        """Sets the vmotion_ip_not_contains of this HostWhereInput.


        :param vmotion_ip_not_contains: The vmotion_ip_not_contains of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_not_contains: str
        """

        self._vmotion_ip_not_contains = vmotion_ip_not_contains

    @property
    def vmotion_ip_not_ends_with(self):
        """Gets the vmotion_ip_not_ends_with of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_not_ends_with

    @vmotion_ip_not_ends_with.setter
    def vmotion_ip_not_ends_with(self, vmotion_ip_not_ends_with):
        """Sets the vmotion_ip_not_ends_with of this HostWhereInput.


        :param vmotion_ip_not_ends_with: The vmotion_ip_not_ends_with of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_not_ends_with: str
        """

        self._vmotion_ip_not_ends_with = vmotion_ip_not_ends_with

    @property
    def vmotion_ip_not_in(self):
        """Gets the vmotion_ip_not_in of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_not_in of this HostWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vmotion_ip_not_in

    @vmotion_ip_not_in.setter
    def vmotion_ip_not_in(self, vmotion_ip_not_in):
        """Sets the vmotion_ip_not_in of this HostWhereInput.


        :param vmotion_ip_not_in: The vmotion_ip_not_in of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_not_in: list[str]
        """

        self._vmotion_ip_not_in = vmotion_ip_not_in

    @property
    def vmotion_ip_not_starts_with(self):
        """Gets the vmotion_ip_not_starts_with of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_not_starts_with

    @vmotion_ip_not_starts_with.setter
    def vmotion_ip_not_starts_with(self, vmotion_ip_not_starts_with):
        """Sets the vmotion_ip_not_starts_with of this HostWhereInput.


        :param vmotion_ip_not_starts_with: The vmotion_ip_not_starts_with of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_not_starts_with: str
        """

        self._vmotion_ip_not_starts_with = vmotion_ip_not_starts_with

    @property
    def vmotion_ip_starts_with(self):
        """Gets the vmotion_ip_starts_with of this HostWhereInput.  # noqa: E501


        :return: The vmotion_ip_starts_with of this HostWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip_starts_with

    @vmotion_ip_starts_with.setter
    def vmotion_ip_starts_with(self, vmotion_ip_starts_with):
        """Sets the vmotion_ip_starts_with of this HostWhereInput.


        :param vmotion_ip_starts_with: The vmotion_ip_starts_with of this HostWhereInput.  # noqa: E501
        :type vmotion_ip_starts_with: str
        """

        self._vmotion_ip_starts_with = vmotion_ip_starts_with

    @property
    def vms_every(self):
        """Gets the vms_every of this HostWhereInput.  # noqa: E501


        :return: The vms_every of this HostWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_every

    @vms_every.setter
    def vms_every(self, vms_every):
        """Sets the vms_every of this HostWhereInput.


        :param vms_every: The vms_every of this HostWhereInput.  # noqa: E501
        :type vms_every: VmWhereInput
        """

        self._vms_every = vms_every

    @property
    def vms_none(self):
        """Gets the vms_none of this HostWhereInput.  # noqa: E501


        :return: The vms_none of this HostWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_none

    @vms_none.setter
    def vms_none(self, vms_none):
        """Sets the vms_none of this HostWhereInput.


        :param vms_none: The vms_none of this HostWhereInput.  # noqa: E501
        :type vms_none: VmWhereInput
        """

        self._vms_none = vms_none

    @property
    def vms_some(self):
        """Gets the vms_some of this HostWhereInput.  # noqa: E501


        :return: The vms_some of this HostWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_some

    @vms_some.setter
    def vms_some(self, vms_some):
        """Sets the vms_some of this HostWhereInput.


        :param vms_some: The vms_some of this HostWhereInput.  # noqa: E501
        :type vms_some: VmWhereInput
        """

        self._vms_some = vms_some

    @property
    def vsphere_esxi_account(self):
        """Gets the vsphere_esxi_account of this HostWhereInput.  # noqa: E501


        :return: The vsphere_esxi_account of this HostWhereInput.  # noqa: E501
        :rtype: VsphereEsxiAccountWhereInput
        """
        return self._vsphere_esxi_account

    @vsphere_esxi_account.setter
    def vsphere_esxi_account(self, vsphere_esxi_account):
        """Sets the vsphere_esxi_account of this HostWhereInput.


        :param vsphere_esxi_account: The vsphere_esxi_account of this HostWhereInput.  # noqa: E501
        :type vsphere_esxi_account: VsphereEsxiAccountWhereInput
        """

        self._vsphere_esxi_account = vsphere_esxi_account

    @property
    def with_faster_ssd_as_cache(self):
        """Gets the with_faster_ssd_as_cache of this HostWhereInput.  # noqa: E501


        :return: The with_faster_ssd_as_cache of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._with_faster_ssd_as_cache

    @with_faster_ssd_as_cache.setter
    def with_faster_ssd_as_cache(self, with_faster_ssd_as_cache):
        """Sets the with_faster_ssd_as_cache of this HostWhereInput.


        :param with_faster_ssd_as_cache: The with_faster_ssd_as_cache of this HostWhereInput.  # noqa: E501
        :type with_faster_ssd_as_cache: bool
        """

        self._with_faster_ssd_as_cache = with_faster_ssd_as_cache

    @property
    def with_faster_ssd_as_cache_not(self):
        """Gets the with_faster_ssd_as_cache_not of this HostWhereInput.  # noqa: E501


        :return: The with_faster_ssd_as_cache_not of this HostWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._with_faster_ssd_as_cache_not

    @with_faster_ssd_as_cache_not.setter
    def with_faster_ssd_as_cache_not(self, with_faster_ssd_as_cache_not):
        """Sets the with_faster_ssd_as_cache_not of this HostWhereInput.


        :param with_faster_ssd_as_cache_not: The with_faster_ssd_as_cache_not of this HostWhereInput.  # noqa: E501
        :type with_faster_ssd_as_cache_not: bool
        """

        self._with_faster_ssd_as_cache_not = with_faster_ssd_as_cache_not

    @property
    def zone(self):
        """Gets the zone of this HostWhereInput.  # noqa: E501


        :return: The zone of this HostWhereInput.  # noqa: E501
        :rtype: ZoneWhereInput
        """
        return self._zone

    @zone.setter
    def zone(self, zone):
        """Sets the zone of this HostWhereInput.


        :param zone: The zone of this HostWhereInput.  # noqa: E501
        :type zone: ZoneWhereInput
        """

        self._zone = zone

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HostWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HostWhereInput):
            return True

        return self.to_dict() != other.to_dict()
