# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class HostWhereUniqueInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'chunk_id': 'str',
        'id': 'str',
        'local_id': 'str',
        'node_topo_local_id': 'str'
    }

    attribute_map = {
        'chunk_id': 'chunk_id',
        'id': 'id',
        'local_id': 'local_id',
        'node_topo_local_id': 'node_topo_local_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """HostWhereUniqueInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._chunk_id = None
        self._id = None
        self._local_id = None
        self._node_topo_local_id = None
        self.discriminator = None

        self.chunk_id = kwargs.get("chunk_id", None)
        self.id = kwargs.get("id", None)
        self.local_id = kwargs.get("local_id", None)
        self.node_topo_local_id = kwargs.get("node_topo_local_id", None)

    @property
    def chunk_id(self):
        """Gets the chunk_id of this HostWhereUniqueInput.  # noqa: E501


        :return: The chunk_id of this HostWhereUniqueInput.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id

    @chunk_id.setter
    def chunk_id(self, chunk_id):
        """Sets the chunk_id of this HostWhereUniqueInput.


        :param chunk_id: The chunk_id of this HostWhereUniqueInput.  # noqa: E501
        :type chunk_id: str
        """

        self._chunk_id = chunk_id

    @property
    def id(self):
        """Gets the id of this HostWhereUniqueInput.  # noqa: E501


        :return: The id of this HostWhereUniqueInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HostWhereUniqueInput.


        :param id: The id of this HostWhereUniqueInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def local_id(self):
        """Gets the local_id of this HostWhereUniqueInput.  # noqa: E501


        :return: The local_id of this HostWhereUniqueInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this HostWhereUniqueInput.


        :param local_id: The local_id of this HostWhereUniqueInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def node_topo_local_id(self):
        """Gets the node_topo_local_id of this HostWhereUniqueInput.  # noqa: E501


        :return: The node_topo_local_id of this HostWhereUniqueInput.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id

    @node_topo_local_id.setter
    def node_topo_local_id(self, node_topo_local_id):
        """Sets the node_topo_local_id of this HostWhereUniqueInput.


        :param node_topo_local_id: The node_topo_local_id of this HostWhereUniqueInput.  # noqa: E501
        :type node_topo_local_id: str
        """

        self._node_topo_local_id = node_topo_local_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HostWhereUniqueInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HostWhereUniqueInput):
            return True

        return self.to_dict() != other.to_dict()
