# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ImportVmVolumeParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'upload_task_id': 'str',
        'name': 'str',
        'elf_ec_storage_policy': 'MountNewCreateDisksParamsVmVolumeElfEcStoragePolicy',
        'elf_replica_storage_policy': 'VmVolumeElfStoragePolicyType',
        'storage_policy': 'VmVolumeElfStoragePolicyType',
        'cluster_id': 'str'
    }

    attribute_map = {
        'upload_task_id': 'upload_task_id',
        'name': 'name',
        'elf_ec_storage_policy': 'elf_ec_storage_policy',
        'elf_replica_storage_policy': 'elf_replica_storage_policy',
        'storage_policy': 'storage_policy',
        'cluster_id': 'cluster_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ImportVmVolumeParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._upload_task_id = None
        self._name = None
        self._elf_ec_storage_policy = None
        self._elf_replica_storage_policy = None
        self._storage_policy = None
        self._cluster_id = None
        self.discriminator = None

        if "upload_task_id" in kwargs:
            self.upload_task_id = kwargs["upload_task_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "elf_ec_storage_policy" in kwargs:
            self.elf_ec_storage_policy = kwargs["elf_ec_storage_policy"]
        if "elf_replica_storage_policy" in kwargs:
            self.elf_replica_storage_policy = kwargs["elf_replica_storage_policy"]
        if "storage_policy" in kwargs:
            self.storage_policy = kwargs["storage_policy"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]

    @property
    def upload_task_id(self):
        """Gets the upload_task_id of this ImportVmVolumeParams.  # noqa: E501


        :return: The upload_task_id of this ImportVmVolumeParams.  # noqa: E501
        :rtype: str
        """
        return self._upload_task_id

    @upload_task_id.setter
    def upload_task_id(self, upload_task_id):
        """Sets the upload_task_id of this ImportVmVolumeParams.


        :param upload_task_id: The upload_task_id of this ImportVmVolumeParams.  # noqa: E501
        :type upload_task_id: str
        """
        if self.local_vars_configuration.client_side_validation and upload_task_id is None:  # noqa: E501
            raise ValueError("Invalid value for `upload_task_id`, must not be `None`")  # noqa: E501

        self._upload_task_id = upload_task_id

    @property
    def name(self):
        """Gets the name of this ImportVmVolumeParams.  # noqa: E501


        :return: The name of this ImportVmVolumeParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ImportVmVolumeParams.


        :param name: The name of this ImportVmVolumeParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def elf_ec_storage_policy(self):
        """Gets the elf_ec_storage_policy of this ImportVmVolumeParams.  # noqa: E501


        :return: The elf_ec_storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :rtype: MountNewCreateDisksParamsVmVolumeElfEcStoragePolicy
        """
        return self._elf_ec_storage_policy

    @elf_ec_storage_policy.setter
    def elf_ec_storage_policy(self, elf_ec_storage_policy):
        """Sets the elf_ec_storage_policy of this ImportVmVolumeParams.


        :param elf_ec_storage_policy: The elf_ec_storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :type elf_ec_storage_policy: MountNewCreateDisksParamsVmVolumeElfEcStoragePolicy
        """

        self._elf_ec_storage_policy = elf_ec_storage_policy

    @property
    def elf_replica_storage_policy(self):
        """Gets the elf_replica_storage_policy of this ImportVmVolumeParams.  # noqa: E501


        :return: The elf_replica_storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_replica_storage_policy

    @elf_replica_storage_policy.setter
    def elf_replica_storage_policy(self, elf_replica_storage_policy):
        """Sets the elf_replica_storage_policy of this ImportVmVolumeParams.


        :param elf_replica_storage_policy: The elf_replica_storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :type elf_replica_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._elf_replica_storage_policy = elf_replica_storage_policy

    @property
    def storage_policy(self):
        """Gets the storage_policy of this ImportVmVolumeParams.  # noqa: E501


        :return: The storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._storage_policy

    @storage_policy.setter
    def storage_policy(self, storage_policy):
        """Sets the storage_policy of this ImportVmVolumeParams.


        :param storage_policy: The storage_policy of this ImportVmVolumeParams.  # noqa: E501
        :type storage_policy: VmVolumeElfStoragePolicyType
        """

        self._storage_policy = storage_policy

    @property
    def cluster_id(self):
        """Gets the cluster_id of this ImportVmVolumeParams.  # noqa: E501


        :return: The cluster_id of this ImportVmVolumeParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this ImportVmVolumeParams.


        :param cluster_id: The cluster_id of this ImportVmVolumeParams.  # noqa: E501
        :type cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_id`, must not be `None`")  # noqa: E501

        self._cluster_id = cluster_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImportVmVolumeParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ImportVmVolumeParams):
            return True

        return self.to_dict() != other.to_dict()
