# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IPSecurityPolicy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'except_ip_block': 'list[str]',
        'ip_block': 'str'
    }

    attribute_map = {
        'except_ip_block': 'except_ip_block',
        'ip_block': 'ip_block'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IPSecurityPolicy - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._except_ip_block = None
        self._ip_block = None
        self.discriminator = None

        if "except_ip_block" in kwargs:
            self.except_ip_block = kwargs["except_ip_block"]
        if "ip_block" in kwargs:
            self.ip_block = kwargs["ip_block"]

    @property
    def except_ip_block(self):
        """Gets the except_ip_block of this IPSecurityPolicy.  # noqa: E501


        :return: The except_ip_block of this IPSecurityPolicy.  # noqa: E501
        :rtype: list[str]
        """
        return self._except_ip_block

    @except_ip_block.setter
    def except_ip_block(self, except_ip_block):
        """Sets the except_ip_block of this IPSecurityPolicy.


        :param except_ip_block: The except_ip_block of this IPSecurityPolicy.  # noqa: E501
        :type except_ip_block: list[str]
        """

        self._except_ip_block = except_ip_block

    @property
    def ip_block(self):
        """Gets the ip_block of this IPSecurityPolicy.  # noqa: E501


        :return: The ip_block of this IPSecurityPolicy.  # noqa: E501
        :rtype: str
        """
        return self._ip_block

    @ip_block.setter
    def ip_block(self, ip_block):
        """Sets the ip_block of this IPSecurityPolicy.


        :param ip_block: The ip_block of this IPSecurityPolicy.  # noqa: E501
        :type ip_block: str
        """
        if self.local_vars_configuration.client_side_validation and ip_block is None:  # noqa: E501
            raise ValueError("Invalid value for `ip_block`, must not be `None`")  # noqa: E501

        self._ip_block = ip_block

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IPSecurityPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IPSecurityPolicy):
            return True

        return self.to_dict() != other.to_dict()
