# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IscsiLunCreationParamsAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ec_m': 'float',
        'ec_k': 'float',
        'resiliency_type': 'ResiliencyType',
        'thin_provision': 'bool',
        'lun_id': 'int',
        'assigned_size_unit': 'ByteUnit',
        'assigned_size': 'int',
        'replica_num': 'int',
        'iscsi_target_id': 'str',
        'name': 'str'
    }

    attribute_map = {
        'ec_m': 'ec_m',
        'ec_k': 'ec_k',
        'resiliency_type': 'resiliency_type',
        'thin_provision': 'thin_provision',
        'lun_id': 'lun_id',
        'assigned_size_unit': 'assigned_size_unit',
        'assigned_size': 'assigned_size',
        'replica_num': 'replica_num',
        'iscsi_target_id': 'iscsi_target_id',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IscsiLunCreationParamsAllOf - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._ec_m = None
        self._ec_k = None
        self._resiliency_type = None
        self._thin_provision = None
        self._lun_id = None
        self._assigned_size_unit = None
        self._assigned_size = None
        self._replica_num = None
        self._iscsi_target_id = None
        self._name = None
        self.discriminator = None

        if "ec_m" in kwargs:
            self.ec_m = kwargs["ec_m"]
        if "ec_k" in kwargs:
            self.ec_k = kwargs["ec_k"]
        if "resiliency_type" in kwargs:
            self.resiliency_type = kwargs["resiliency_type"]
        if "thin_provision" in kwargs:
            self.thin_provision = kwargs["thin_provision"]
        if "lun_id" in kwargs:
            self.lun_id = kwargs["lun_id"]
        if "assigned_size_unit" in kwargs:
            self.assigned_size_unit = kwargs["assigned_size_unit"]
        if "assigned_size" in kwargs:
            self.assigned_size = kwargs["assigned_size"]
        if "replica_num" in kwargs:
            self.replica_num = kwargs["replica_num"]
        if "iscsi_target_id" in kwargs:
            self.iscsi_target_id = kwargs["iscsi_target_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def ec_m(self):
        """Gets the ec_m of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The ec_m of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: float
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this IscsiLunCreationParamsAllOf.


        :param ec_m: The ec_m of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type ec_m: float
        """

        self._ec_m = ec_m

    @property
    def ec_k(self):
        """Gets the ec_k of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The ec_k of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: float
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this IscsiLunCreationParamsAllOf.


        :param ec_k: The ec_k of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type ec_k: float
        """

        self._ec_k = ec_k

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The resiliency_type of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this IscsiLunCreationParamsAllOf.


        :param resiliency_type: The resiliency_type of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def thin_provision(self):
        """Gets the thin_provision of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The thin_provision of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this IscsiLunCreationParamsAllOf.


        :param thin_provision: The thin_provision of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type thin_provision: bool
        """

        self._thin_provision = thin_provision

    @property
    def lun_id(self):
        """Gets the lun_id of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The lun_id of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: int
        """
        return self._lun_id

    @lun_id.setter
    def lun_id(self, lun_id):
        """Sets the lun_id of this IscsiLunCreationParamsAllOf.


        :param lun_id: The lun_id of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type lun_id: int
        """

        self._lun_id = lun_id

    @property
    def assigned_size_unit(self):
        """Gets the assigned_size_unit of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The assigned_size_unit of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: ByteUnit
        """
        return self._assigned_size_unit

    @assigned_size_unit.setter
    def assigned_size_unit(self, assigned_size_unit):
        """Sets the assigned_size_unit of this IscsiLunCreationParamsAllOf.


        :param assigned_size_unit: The assigned_size_unit of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type assigned_size_unit: ByteUnit
        """

        self._assigned_size_unit = assigned_size_unit

    @property
    def assigned_size(self):
        """Gets the assigned_size of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The assigned_size of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: int
        """
        return self._assigned_size

    @assigned_size.setter
    def assigned_size(self, assigned_size):
        """Sets the assigned_size of this IscsiLunCreationParamsAllOf.


        :param assigned_size: The assigned_size of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type assigned_size: int
        """
        if self.local_vars_configuration.client_side_validation and assigned_size is None:  # noqa: E501
            raise ValueError("Invalid value for `assigned_size`, must not be `None`")  # noqa: E501

        self._assigned_size = assigned_size

    @property
    def replica_num(self):
        """Gets the replica_num of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The replica_num of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this IscsiLunCreationParamsAllOf.


        :param replica_num: The replica_num of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type replica_num: int
        """
        if self.local_vars_configuration.client_side_validation and replica_num is None:  # noqa: E501
            raise ValueError("Invalid value for `replica_num`, must not be `None`")  # noqa: E501

        self._replica_num = replica_num

    @property
    def iscsi_target_id(self):
        """Gets the iscsi_target_id of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The iscsi_target_id of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_id

    @iscsi_target_id.setter
    def iscsi_target_id(self, iscsi_target_id):
        """Sets the iscsi_target_id of this IscsiLunCreationParamsAllOf.


        :param iscsi_target_id: The iscsi_target_id of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type iscsi_target_id: str
        """
        if self.local_vars_configuration.client_side_validation and iscsi_target_id is None:  # noqa: E501
            raise ValueError("Invalid value for `iscsi_target_id`, must not be `None`")  # noqa: E501

        self._iscsi_target_id = iscsi_target_id

    @property
    def name(self):
        """Gets the name of this IscsiLunCreationParamsAllOf.  # noqa: E501


        :return: The name of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IscsiLunCreationParamsAllOf.


        :param name: The name of this IscsiLunCreationParamsAllOf.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IscsiLunCreationParamsAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IscsiLunCreationParamsAllOf):
            return True

        return self.to_dict() != other.to_dict()
