# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IscsiLunSnapshotWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[IscsiLunSnapshotWhereInput]',
        '_not': 'list[IscsiLunSnapshotWhereInput]',
        '_or': 'list[IscsiLunSnapshotWhereInput]',
        'consistency_group_snapshot': 'ConsistencyGroupSnapshotWhereInput',
        'ec_k': 'int',
        'ec_k_gt': 'int',
        'ec_k_gte': 'int',
        'ec_k_in': 'list[int]',
        'ec_k_lt': 'int',
        'ec_k_lte': 'int',
        'ec_k_not': 'int',
        'ec_k_not_in': 'list[int]',
        'ec_m': 'int',
        'ec_m_gt': 'int',
        'ec_m_gte': 'int',
        'ec_m_in': 'list[int]',
        'ec_m_lt': 'int',
        'ec_m_lte': 'int',
        'ec_m_not': 'int',
        'ec_m_not_in': 'list[int]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'iscsi_lun': 'IscsiLunWhereInput',
        'iscsi_target': 'IscsiTargetWhereInput',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'resiliency_type': 'ResiliencyType',
        'resiliency_type_in': 'list[ResiliencyType]',
        'resiliency_type_not': 'ResiliencyType',
        'resiliency_type_not_in': 'list[ResiliencyType]',
        'snapshot_group': 'SnapshotGroupWhereInput',
        'unique_size': 'int',
        'unique_size_gt': 'int',
        'unique_size_gte': 'int',
        'unique_size_in': 'list[int]',
        'unique_size_lt': 'int',
        'unique_size_lte': 'int',
        'unique_size_not': 'int',
        'unique_size_not_in': 'list[int]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'consistency_group_snapshot': 'consistency_group_snapshot',
        'ec_k': 'ec_k',
        'ec_k_gt': 'ec_k_gt',
        'ec_k_gte': 'ec_k_gte',
        'ec_k_in': 'ec_k_in',
        'ec_k_lt': 'ec_k_lt',
        'ec_k_lte': 'ec_k_lte',
        'ec_k_not': 'ec_k_not',
        'ec_k_not_in': 'ec_k_not_in',
        'ec_m': 'ec_m',
        'ec_m_gt': 'ec_m_gt',
        'ec_m_gte': 'ec_m_gte',
        'ec_m_in': 'ec_m_in',
        'ec_m_lt': 'ec_m_lt',
        'ec_m_lte': 'ec_m_lte',
        'ec_m_not': 'ec_m_not',
        'ec_m_not_in': 'ec_m_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'iscsi_lun': 'iscsi_lun',
        'iscsi_target': 'iscsi_target',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'resiliency_type': 'resiliency_type',
        'resiliency_type_in': 'resiliency_type_in',
        'resiliency_type_not': 'resiliency_type_not',
        'resiliency_type_not_in': 'resiliency_type_not_in',
        'snapshot_group': 'snapshot_group',
        'unique_size': 'unique_size',
        'unique_size_gt': 'unique_size_gt',
        'unique_size_gte': 'unique_size_gte',
        'unique_size_in': 'unique_size_in',
        'unique_size_lt': 'unique_size_lt',
        'unique_size_lte': 'unique_size_lte',
        'unique_size_not': 'unique_size_not',
        'unique_size_not_in': 'unique_size_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IscsiLunSnapshotWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._consistency_group_snapshot = None
        self._ec_k = None
        self._ec_k_gt = None
        self._ec_k_gte = None
        self._ec_k_in = None
        self._ec_k_lt = None
        self._ec_k_lte = None
        self._ec_k_not = None
        self._ec_k_not_in = None
        self._ec_m = None
        self._ec_m_gt = None
        self._ec_m_gte = None
        self._ec_m_in = None
        self._ec_m_lt = None
        self._ec_m_lte = None
        self._ec_m_not = None
        self._ec_m_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._iscsi_lun = None
        self._iscsi_target = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._resiliency_type = None
        self._resiliency_type_in = None
        self._resiliency_type_not = None
        self._resiliency_type_not_in = None
        self._snapshot_group = None
        self._unique_size = None
        self._unique_size_gt = None
        self._unique_size_gte = None
        self._unique_size_in = None
        self._unique_size_lt = None
        self._unique_size_lte = None
        self._unique_size_not = None
        self._unique_size_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.consistency_group_snapshot = kwargs.get("consistency_group_snapshot", None)
        self.ec_k = kwargs.get("ec_k", None)
        self.ec_k_gt = kwargs.get("ec_k_gt", None)
        self.ec_k_gte = kwargs.get("ec_k_gte", None)
        self.ec_k_in = kwargs.get("ec_k_in", None)
        self.ec_k_lt = kwargs.get("ec_k_lt", None)
        self.ec_k_lte = kwargs.get("ec_k_lte", None)
        self.ec_k_not = kwargs.get("ec_k_not", None)
        self.ec_k_not_in = kwargs.get("ec_k_not_in", None)
        self.ec_m = kwargs.get("ec_m", None)
        self.ec_m_gt = kwargs.get("ec_m_gt", None)
        self.ec_m_gte = kwargs.get("ec_m_gte", None)
        self.ec_m_in = kwargs.get("ec_m_in", None)
        self.ec_m_lt = kwargs.get("ec_m_lt", None)
        self.ec_m_lte = kwargs.get("ec_m_lte", None)
        self.ec_m_not = kwargs.get("ec_m_not", None)
        self.ec_m_not_in = kwargs.get("ec_m_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.iscsi_lun = kwargs.get("iscsi_lun", None)
        self.iscsi_target = kwargs.get("iscsi_target", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.resiliency_type = kwargs.get("resiliency_type", None)
        self.resiliency_type_in = kwargs.get("resiliency_type_in", None)
        self.resiliency_type_not = kwargs.get("resiliency_type_not", None)
        self.resiliency_type_not_in = kwargs.get("resiliency_type_not_in", None)
        self.snapshot_group = kwargs.get("snapshot_group", None)
        self.unique_size = kwargs.get("unique_size", None)
        self.unique_size_gt = kwargs.get("unique_size_gt", None)
        self.unique_size_gte = kwargs.get("unique_size_gte", None)
        self.unique_size_in = kwargs.get("unique_size_in", None)
        self.unique_size_lt = kwargs.get("unique_size_lt", None)
        self.unique_size_lte = kwargs.get("unique_size_lte", None)
        self.unique_size_not = kwargs.get("unique_size_not", None)
        self.unique_size_not_in = kwargs.get("unique_size_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The _and of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[IscsiLunSnapshotWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this IscsiLunSnapshotWhereInput.


        :param _and: The _and of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type _and: list[IscsiLunSnapshotWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The _not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[IscsiLunSnapshotWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this IscsiLunSnapshotWhereInput.


        :param _not: The _not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type _not: list[IscsiLunSnapshotWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The _or of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[IscsiLunSnapshotWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this IscsiLunSnapshotWhereInput.


        :param _or: The _or of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type _or: list[IscsiLunSnapshotWhereInput]
        """

        self.__or = _or

    @property
    def consistency_group_snapshot(self):
        """Gets the consistency_group_snapshot of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The consistency_group_snapshot of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: ConsistencyGroupSnapshotWhereInput
        """
        return self._consistency_group_snapshot

    @consistency_group_snapshot.setter
    def consistency_group_snapshot(self, consistency_group_snapshot):
        """Sets the consistency_group_snapshot of this IscsiLunSnapshotWhereInput.


        :param consistency_group_snapshot: The consistency_group_snapshot of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type consistency_group_snapshot: ConsistencyGroupSnapshotWhereInput
        """

        self._consistency_group_snapshot = consistency_group_snapshot

    @property
    def ec_k(self):
        """Gets the ec_k of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this IscsiLunSnapshotWhereInput.


        :param ec_k: The ec_k of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k: int
        """

        self._ec_k = ec_k

    @property
    def ec_k_gt(self):
        """Gets the ec_k_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_gt

    @ec_k_gt.setter
    def ec_k_gt(self, ec_k_gt):
        """Sets the ec_k_gt of this IscsiLunSnapshotWhereInput.


        :param ec_k_gt: The ec_k_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_gt: int
        """

        self._ec_k_gt = ec_k_gt

    @property
    def ec_k_gte(self):
        """Gets the ec_k_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_gte

    @ec_k_gte.setter
    def ec_k_gte(self, ec_k_gte):
        """Sets the ec_k_gte of this IscsiLunSnapshotWhereInput.


        :param ec_k_gte: The ec_k_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_gte: int
        """

        self._ec_k_gte = ec_k_gte

    @property
    def ec_k_in(self):
        """Gets the ec_k_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_k_in

    @ec_k_in.setter
    def ec_k_in(self, ec_k_in):
        """Sets the ec_k_in of this IscsiLunSnapshotWhereInput.


        :param ec_k_in: The ec_k_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_in: list[int]
        """

        self._ec_k_in = ec_k_in

    @property
    def ec_k_lt(self):
        """Gets the ec_k_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_lt

    @ec_k_lt.setter
    def ec_k_lt(self, ec_k_lt):
        """Sets the ec_k_lt of this IscsiLunSnapshotWhereInput.


        :param ec_k_lt: The ec_k_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_lt: int
        """

        self._ec_k_lt = ec_k_lt

    @property
    def ec_k_lte(self):
        """Gets the ec_k_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_lte

    @ec_k_lte.setter
    def ec_k_lte(self, ec_k_lte):
        """Sets the ec_k_lte of this IscsiLunSnapshotWhereInput.


        :param ec_k_lte: The ec_k_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_lte: int
        """

        self._ec_k_lte = ec_k_lte

    @property
    def ec_k_not(self):
        """Gets the ec_k_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_not

    @ec_k_not.setter
    def ec_k_not(self, ec_k_not):
        """Sets the ec_k_not of this IscsiLunSnapshotWhereInput.


        :param ec_k_not: The ec_k_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_not: int
        """

        self._ec_k_not = ec_k_not

    @property
    def ec_k_not_in(self):
        """Gets the ec_k_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_k_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_k_not_in

    @ec_k_not_in.setter
    def ec_k_not_in(self, ec_k_not_in):
        """Sets the ec_k_not_in of this IscsiLunSnapshotWhereInput.


        :param ec_k_not_in: The ec_k_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_k_not_in: list[int]
        """

        self._ec_k_not_in = ec_k_not_in

    @property
    def ec_m(self):
        """Gets the ec_m of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this IscsiLunSnapshotWhereInput.


        :param ec_m: The ec_m of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m: int
        """

        self._ec_m = ec_m

    @property
    def ec_m_gt(self):
        """Gets the ec_m_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_gt

    @ec_m_gt.setter
    def ec_m_gt(self, ec_m_gt):
        """Sets the ec_m_gt of this IscsiLunSnapshotWhereInput.


        :param ec_m_gt: The ec_m_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_gt: int
        """

        self._ec_m_gt = ec_m_gt

    @property
    def ec_m_gte(self):
        """Gets the ec_m_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_gte

    @ec_m_gte.setter
    def ec_m_gte(self, ec_m_gte):
        """Sets the ec_m_gte of this IscsiLunSnapshotWhereInput.


        :param ec_m_gte: The ec_m_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_gte: int
        """

        self._ec_m_gte = ec_m_gte

    @property
    def ec_m_in(self):
        """Gets the ec_m_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_m_in

    @ec_m_in.setter
    def ec_m_in(self, ec_m_in):
        """Sets the ec_m_in of this IscsiLunSnapshotWhereInput.


        :param ec_m_in: The ec_m_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_in: list[int]
        """

        self._ec_m_in = ec_m_in

    @property
    def ec_m_lt(self):
        """Gets the ec_m_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_lt

    @ec_m_lt.setter
    def ec_m_lt(self, ec_m_lt):
        """Sets the ec_m_lt of this IscsiLunSnapshotWhereInput.


        :param ec_m_lt: The ec_m_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_lt: int
        """

        self._ec_m_lt = ec_m_lt

    @property
    def ec_m_lte(self):
        """Gets the ec_m_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_lte

    @ec_m_lte.setter
    def ec_m_lte(self, ec_m_lte):
        """Sets the ec_m_lte of this IscsiLunSnapshotWhereInput.


        :param ec_m_lte: The ec_m_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_lte: int
        """

        self._ec_m_lte = ec_m_lte

    @property
    def ec_m_not(self):
        """Gets the ec_m_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_not

    @ec_m_not.setter
    def ec_m_not(self, ec_m_not):
        """Sets the ec_m_not of this IscsiLunSnapshotWhereInput.


        :param ec_m_not: The ec_m_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_not: int
        """

        self._ec_m_not = ec_m_not

    @property
    def ec_m_not_in(self):
        """Gets the ec_m_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The ec_m_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_m_not_in

    @ec_m_not_in.setter
    def ec_m_not_in(self, ec_m_not_in):
        """Sets the ec_m_not_in of this IscsiLunSnapshotWhereInput.


        :param ec_m_not_in: The ec_m_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type ec_m_not_in: list[int]
        """

        self._ec_m_not_in = ec_m_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this IscsiLunSnapshotWhereInput.


        :param entity_async_status: The entity_async_status of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this IscsiLunSnapshotWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this IscsiLunSnapshotWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this IscsiLunSnapshotWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this IscsiLunSnapshotWhereInput.


        :param id: The id of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this IscsiLunSnapshotWhereInput.


        :param id_contains: The id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this IscsiLunSnapshotWhereInput.


        :param id_ends_with: The id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this IscsiLunSnapshotWhereInput.


        :param id_gt: The id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this IscsiLunSnapshotWhereInput.


        :param id_gte: The id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this IscsiLunSnapshotWhereInput.


        :param id_in: The id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this IscsiLunSnapshotWhereInput.


        :param id_lt: The id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this IscsiLunSnapshotWhereInput.


        :param id_lte: The id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this IscsiLunSnapshotWhereInput.


        :param id_not: The id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this IscsiLunSnapshotWhereInput.


        :param id_not_contains: The id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this IscsiLunSnapshotWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this IscsiLunSnapshotWhereInput.


        :param id_not_in: The id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this IscsiLunSnapshotWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this IscsiLunSnapshotWhereInput.


        :param id_starts_with: The id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def iscsi_lun(self):
        """Gets the iscsi_lun of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The iscsi_lun of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._iscsi_lun

    @iscsi_lun.setter
    def iscsi_lun(self, iscsi_lun):
        """Sets the iscsi_lun of this IscsiLunSnapshotWhereInput.


        :param iscsi_lun: The iscsi_lun of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type iscsi_lun: IscsiLunWhereInput
        """

        self._iscsi_lun = iscsi_lun

    @property
    def iscsi_target(self):
        """Gets the iscsi_target of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The iscsi_target of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: IscsiTargetWhereInput
        """
        return self._iscsi_target

    @iscsi_target.setter
    def iscsi_target(self, iscsi_target):
        """Sets the iscsi_target of this IscsiLunSnapshotWhereInput.


        :param iscsi_target: The iscsi_target of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type iscsi_target: IscsiTargetWhereInput
        """

        self._iscsi_target = iscsi_target

    @property
    def labels_every(self):
        """Gets the labels_every of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The labels_every of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this IscsiLunSnapshotWhereInput.


        :param labels_every: The labels_every of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The labels_none of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this IscsiLunSnapshotWhereInput.


        :param labels_none: The labels_none of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The labels_some of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this IscsiLunSnapshotWhereInput.


        :param labels_some: The labels_some of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_created_at(self):
        """Gets the local_created_at of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this IscsiLunSnapshotWhereInput.


        :param local_created_at: The local_created_at of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this IscsiLunSnapshotWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this IscsiLunSnapshotWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this IscsiLunSnapshotWhereInput.


        :param local_created_at_in: The local_created_at_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this IscsiLunSnapshotWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this IscsiLunSnapshotWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this IscsiLunSnapshotWhereInput.


        :param local_created_at_not: The local_created_at_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this IscsiLunSnapshotWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this IscsiLunSnapshotWhereInput.


        :param local_id: The local_id of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this IscsiLunSnapshotWhereInput.


        :param local_id_contains: The local_id_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this IscsiLunSnapshotWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this IscsiLunSnapshotWhereInput.


        :param local_id_gt: The local_id_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this IscsiLunSnapshotWhereInput.


        :param local_id_gte: The local_id_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this IscsiLunSnapshotWhereInput.


        :param local_id_in: The local_id_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this IscsiLunSnapshotWhereInput.


        :param local_id_lt: The local_id_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this IscsiLunSnapshotWhereInput.


        :param local_id_lte: The local_id_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this IscsiLunSnapshotWhereInput.


        :param local_id_not: The local_id_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this IscsiLunSnapshotWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this IscsiLunSnapshotWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this IscsiLunSnapshotWhereInput.


        :param local_id_not_in: The local_id_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this IscsiLunSnapshotWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this IscsiLunSnapshotWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def name(self):
        """Gets the name of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IscsiLunSnapshotWhereInput.


        :param name: The name of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this IscsiLunSnapshotWhereInput.


        :param name_contains: The name_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this IscsiLunSnapshotWhereInput.


        :param name_ends_with: The name_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this IscsiLunSnapshotWhereInput.


        :param name_gt: The name_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this IscsiLunSnapshotWhereInput.


        :param name_gte: The name_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this IscsiLunSnapshotWhereInput.


        :param name_in: The name_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this IscsiLunSnapshotWhereInput.


        :param name_lt: The name_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this IscsiLunSnapshotWhereInput.


        :param name_lte: The name_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this IscsiLunSnapshotWhereInput.


        :param name_not: The name_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this IscsiLunSnapshotWhereInput.


        :param name_not_contains: The name_not_contains of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this IscsiLunSnapshotWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this IscsiLunSnapshotWhereInput.


        :param name_not_in: The name_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this IscsiLunSnapshotWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The name_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this IscsiLunSnapshotWhereInput.


        :param name_starts_with: The name_starts_with of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The resiliency_type of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this IscsiLunSnapshotWhereInput.


        :param resiliency_type: The resiliency_type of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def resiliency_type_in(self):
        """Gets the resiliency_type_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The resiliency_type_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[ResiliencyType]
        """
        return self._resiliency_type_in

    @resiliency_type_in.setter
    def resiliency_type_in(self, resiliency_type_in):
        """Sets the resiliency_type_in of this IscsiLunSnapshotWhereInput.


        :param resiliency_type_in: The resiliency_type_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type resiliency_type_in: list[ResiliencyType]
        """

        self._resiliency_type_in = resiliency_type_in

    @property
    def resiliency_type_not(self):
        """Gets the resiliency_type_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The resiliency_type_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type_not

    @resiliency_type_not.setter
    def resiliency_type_not(self, resiliency_type_not):
        """Sets the resiliency_type_not of this IscsiLunSnapshotWhereInput.


        :param resiliency_type_not: The resiliency_type_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type resiliency_type_not: ResiliencyType
        """

        self._resiliency_type_not = resiliency_type_not

    @property
    def resiliency_type_not_in(self):
        """Gets the resiliency_type_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The resiliency_type_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[ResiliencyType]
        """
        return self._resiliency_type_not_in

    @resiliency_type_not_in.setter
    def resiliency_type_not_in(self, resiliency_type_not_in):
        """Sets the resiliency_type_not_in of this IscsiLunSnapshotWhereInput.


        :param resiliency_type_not_in: The resiliency_type_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type resiliency_type_not_in: list[ResiliencyType]
        """

        self._resiliency_type_not_in = resiliency_type_not_in

    @property
    def snapshot_group(self):
        """Gets the snapshot_group of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The snapshot_group of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: SnapshotGroupWhereInput
        """
        return self._snapshot_group

    @snapshot_group.setter
    def snapshot_group(self, snapshot_group):
        """Sets the snapshot_group of this IscsiLunSnapshotWhereInput.


        :param snapshot_group: The snapshot_group of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type snapshot_group: SnapshotGroupWhereInput
        """

        self._snapshot_group = snapshot_group

    @property
    def unique_size(self):
        """Gets the unique_size of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this IscsiLunSnapshotWhereInput.


        :param unique_size: The unique_size of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size: int
        """

        self._unique_size = unique_size

    @property
    def unique_size_gt(self):
        """Gets the unique_size_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_gt

    @unique_size_gt.setter
    def unique_size_gt(self, unique_size_gt):
        """Sets the unique_size_gt of this IscsiLunSnapshotWhereInput.


        :param unique_size_gt: The unique_size_gt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_gt: int
        """

        self._unique_size_gt = unique_size_gt

    @property
    def unique_size_gte(self):
        """Gets the unique_size_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_gte

    @unique_size_gte.setter
    def unique_size_gte(self, unique_size_gte):
        """Sets the unique_size_gte of this IscsiLunSnapshotWhereInput.


        :param unique_size_gte: The unique_size_gte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_gte: int
        """

        self._unique_size_gte = unique_size_gte

    @property
    def unique_size_in(self):
        """Gets the unique_size_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._unique_size_in

    @unique_size_in.setter
    def unique_size_in(self, unique_size_in):
        """Sets the unique_size_in of this IscsiLunSnapshotWhereInput.


        :param unique_size_in: The unique_size_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_in: list[int]
        """

        self._unique_size_in = unique_size_in

    @property
    def unique_size_lt(self):
        """Gets the unique_size_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_lt

    @unique_size_lt.setter
    def unique_size_lt(self, unique_size_lt):
        """Sets the unique_size_lt of this IscsiLunSnapshotWhereInput.


        :param unique_size_lt: The unique_size_lt of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_lt: int
        """

        self._unique_size_lt = unique_size_lt

    @property
    def unique_size_lte(self):
        """Gets the unique_size_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_lte

    @unique_size_lte.setter
    def unique_size_lte(self, unique_size_lte):
        """Sets the unique_size_lte of this IscsiLunSnapshotWhereInput.


        :param unique_size_lte: The unique_size_lte of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_lte: int
        """

        self._unique_size_lte = unique_size_lte

    @property
    def unique_size_not(self):
        """Gets the unique_size_not of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_not

    @unique_size_not.setter
    def unique_size_not(self, unique_size_not):
        """Sets the unique_size_not of this IscsiLunSnapshotWhereInput.


        :param unique_size_not: The unique_size_not of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_not: int
        """

        self._unique_size_not = unique_size_not

    @property
    def unique_size_not_in(self):
        """Gets the unique_size_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._unique_size_not_in

    @unique_size_not_in.setter
    def unique_size_not_in(self, unique_size_not_in):
        """Sets the unique_size_not_in of this IscsiLunSnapshotWhereInput.


        :param unique_size_not_in: The unique_size_not_in of this IscsiLunSnapshotWhereInput.  # noqa: E501
        :type unique_size_not_in: list[int]
        """

        self._unique_size_not_in = unique_size_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IscsiLunSnapshotWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IscsiLunSnapshotWhereInput):
            return True

        return self.to_dict() != other.to_dict()
