# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IscsiTargetCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'stripe_size_unit': 'ByteUnit',
        'stripe_size': 'int',
        'stripe_num': 'int',
        'replica_num': 'int',
        'thin_provision': 'bool',
        'cluster_id': 'str',
        'name': 'str',
        'business_host_groups': 'BusinessHostGroupWhereInput',
        'business_hosts': 'BusinessHostWhereInput',
        'configuration_adaptive': 'bool',
        'configuration_method': 'ConfigurationMethod',
        'encrypt_method': 'EncryptMethod',
        'prioritized': 'bool',
        'ec_m': 'float',
        'ec_k': 'float',
        'resiliency_type': 'ResiliencyType',
        'bps_wr_max_length': 'int',
        'bps_wr_max_unit': 'BPSUnit',
        'bps_wr_max_size': 'BPSUnit',
        'bps_wr_max': 'int',
        'bps_rd_max_length': 'int',
        'bps_rd_max_unit': 'BPSUnit',
        'bps_rd_max': 'int',
        'bps_max_length': 'int',
        'bps_max_unit': 'BPSUnit',
        'bps_max': 'int',
        'iops_wr_max_length': 'int',
        'iops_wr_max': 'int',
        'iops_rd_max_length': 'int',
        'iops_rd_max': 'int',
        'iops_max_length': 'int',
        'iops_max': 'int',
        'bps_wr_unit': 'BPSUnit',
        'bps_wr': 'int',
        'bps_rd_unit': 'BPSUnit',
        'bps_rd': 'int',
        'bps_unit': 'BPSUnit',
        'bps': 'int',
        'iops_wr': 'int',
        'iops_rd': 'int',
        'iops': 'int',
        'initiator_chaps': 'list[IscsiTargetCommonParamsInitiatorChaps]',
        'chap_secret': 'str',
        'chap_name': 'str',
        'chap_enabled': 'bool',
        'description': 'str',
        'iqn_whitelist': 'str',
        'ip_whitelist': 'str'
    }

    attribute_map = {
        'stripe_size_unit': 'stripe_size_unit',
        'stripe_size': 'stripe_size',
        'stripe_num': 'stripe_num',
        'replica_num': 'replica_num',
        'thin_provision': 'thin_provision',
        'cluster_id': 'cluster_id',
        'name': 'name',
        'business_host_groups': 'business_host_groups',
        'business_hosts': 'business_hosts',
        'configuration_adaptive': 'configuration_adaptive',
        'configuration_method': 'configuration_method',
        'encrypt_method': 'encrypt_method',
        'prioritized': 'prioritized',
        'ec_m': 'ec_m',
        'ec_k': 'ec_k',
        'resiliency_type': 'resiliency_type',
        'bps_wr_max_length': 'bps_wr_max_length',
        'bps_wr_max_unit': 'bps_wr_max_unit',
        'bps_wr_max_size': 'bps_wr_max_size',
        'bps_wr_max': 'bps_wr_max',
        'bps_rd_max_length': 'bps_rd_max_length',
        'bps_rd_max_unit': 'bps_rd_max_unit',
        'bps_rd_max': 'bps_rd_max',
        'bps_max_length': 'bps_max_length',
        'bps_max_unit': 'bps_max_unit',
        'bps_max': 'bps_max',
        'iops_wr_max_length': 'iops_wr_max_length',
        'iops_wr_max': 'iops_wr_max',
        'iops_rd_max_length': 'iops_rd_max_length',
        'iops_rd_max': 'iops_rd_max',
        'iops_max_length': 'iops_max_length',
        'iops_max': 'iops_max',
        'bps_wr_unit': 'bps_wr_unit',
        'bps_wr': 'bps_wr',
        'bps_rd_unit': 'bps_rd_unit',
        'bps_rd': 'bps_rd',
        'bps_unit': 'bps_unit',
        'bps': 'bps',
        'iops_wr': 'iops_wr',
        'iops_rd': 'iops_rd',
        'iops': 'iops',
        'initiator_chaps': 'initiator_chaps',
        'chap_secret': 'chap_secret',
        'chap_name': 'chap_name',
        'chap_enabled': 'chap_enabled',
        'description': 'description',
        'iqn_whitelist': 'iqn_whitelist',
        'ip_whitelist': 'ip_whitelist'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IscsiTargetCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._stripe_size_unit = None
        self._stripe_size = None
        self._stripe_num = None
        self._replica_num = None
        self._thin_provision = None
        self._cluster_id = None
        self._name = None
        self._business_host_groups = None
        self._business_hosts = None
        self._configuration_adaptive = None
        self._configuration_method = None
        self._encrypt_method = None
        self._prioritized = None
        self._ec_m = None
        self._ec_k = None
        self._resiliency_type = None
        self._bps_wr_max_length = None
        self._bps_wr_max_unit = None
        self._bps_wr_max_size = None
        self._bps_wr_max = None
        self._bps_rd_max_length = None
        self._bps_rd_max_unit = None
        self._bps_rd_max = None
        self._bps_max_length = None
        self._bps_max_unit = None
        self._bps_max = None
        self._iops_wr_max_length = None
        self._iops_wr_max = None
        self._iops_rd_max_length = None
        self._iops_rd_max = None
        self._iops_max_length = None
        self._iops_max = None
        self._bps_wr_unit = None
        self._bps_wr = None
        self._bps_rd_unit = None
        self._bps_rd = None
        self._bps_unit = None
        self._bps = None
        self._iops_wr = None
        self._iops_rd = None
        self._iops = None
        self._initiator_chaps = None
        self._chap_secret = None
        self._chap_name = None
        self._chap_enabled = None
        self._description = None
        self._iqn_whitelist = None
        self._ip_whitelist = None
        self.discriminator = None

        if "stripe_size_unit" in kwargs:
            self.stripe_size_unit = kwargs["stripe_size_unit"]
        if "stripe_size" in kwargs:
            self.stripe_size = kwargs["stripe_size"]
        if "stripe_num" in kwargs:
            self.stripe_num = kwargs["stripe_num"]
        if "replica_num" in kwargs:
            self.replica_num = kwargs["replica_num"]
        if "thin_provision" in kwargs:
            self.thin_provision = kwargs["thin_provision"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "business_host_groups" in kwargs:
            self.business_host_groups = kwargs["business_host_groups"]
        if "business_hosts" in kwargs:
            self.business_hosts = kwargs["business_hosts"]
        if "configuration_adaptive" in kwargs:
            self.configuration_adaptive = kwargs["configuration_adaptive"]
        if "configuration_method" in kwargs:
            self.configuration_method = kwargs["configuration_method"]
        if "encrypt_method" in kwargs:
            self.encrypt_method = kwargs["encrypt_method"]
        if "prioritized" in kwargs:
            self.prioritized = kwargs["prioritized"]
        if "ec_m" in kwargs:
            self.ec_m = kwargs["ec_m"]
        if "ec_k" in kwargs:
            self.ec_k = kwargs["ec_k"]
        if "resiliency_type" in kwargs:
            self.resiliency_type = kwargs["resiliency_type"]
        if "bps_wr_max_length" in kwargs:
            self.bps_wr_max_length = kwargs["bps_wr_max_length"]
        if "bps_wr_max_unit" in kwargs:
            self.bps_wr_max_unit = kwargs["bps_wr_max_unit"]
        if "bps_wr_max_size" in kwargs:
            self.bps_wr_max_size = kwargs["bps_wr_max_size"]
        if "bps_wr_max" in kwargs:
            self.bps_wr_max = kwargs["bps_wr_max"]
        if "bps_rd_max_length" in kwargs:
            self.bps_rd_max_length = kwargs["bps_rd_max_length"]
        if "bps_rd_max_unit" in kwargs:
            self.bps_rd_max_unit = kwargs["bps_rd_max_unit"]
        if "bps_rd_max" in kwargs:
            self.bps_rd_max = kwargs["bps_rd_max"]
        if "bps_max_length" in kwargs:
            self.bps_max_length = kwargs["bps_max_length"]
        if "bps_max_unit" in kwargs:
            self.bps_max_unit = kwargs["bps_max_unit"]
        if "bps_max" in kwargs:
            self.bps_max = kwargs["bps_max"]
        if "iops_wr_max_length" in kwargs:
            self.iops_wr_max_length = kwargs["iops_wr_max_length"]
        if "iops_wr_max" in kwargs:
            self.iops_wr_max = kwargs["iops_wr_max"]
        if "iops_rd_max_length" in kwargs:
            self.iops_rd_max_length = kwargs["iops_rd_max_length"]
        if "iops_rd_max" in kwargs:
            self.iops_rd_max = kwargs["iops_rd_max"]
        if "iops_max_length" in kwargs:
            self.iops_max_length = kwargs["iops_max_length"]
        if "iops_max" in kwargs:
            self.iops_max = kwargs["iops_max"]
        if "bps_wr_unit" in kwargs:
            self.bps_wr_unit = kwargs["bps_wr_unit"]
        if "bps_wr" in kwargs:
            self.bps_wr = kwargs["bps_wr"]
        if "bps_rd_unit" in kwargs:
            self.bps_rd_unit = kwargs["bps_rd_unit"]
        if "bps_rd" in kwargs:
            self.bps_rd = kwargs["bps_rd"]
        if "bps_unit" in kwargs:
            self.bps_unit = kwargs["bps_unit"]
        if "bps" in kwargs:
            self.bps = kwargs["bps"]
        if "iops_wr" in kwargs:
            self.iops_wr = kwargs["iops_wr"]
        if "iops_rd" in kwargs:
            self.iops_rd = kwargs["iops_rd"]
        if "iops" in kwargs:
            self.iops = kwargs["iops"]
        if "initiator_chaps" in kwargs:
            self.initiator_chaps = kwargs["initiator_chaps"]
        if "chap_secret" in kwargs:
            self.chap_secret = kwargs["chap_secret"]
        if "chap_name" in kwargs:
            self.chap_name = kwargs["chap_name"]
        if "chap_enabled" in kwargs:
            self.chap_enabled = kwargs["chap_enabled"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "iqn_whitelist" in kwargs:
            self.iqn_whitelist = kwargs["iqn_whitelist"]
        if "ip_whitelist" in kwargs:
            self.ip_whitelist = kwargs["ip_whitelist"]

    @property
    def stripe_size_unit(self):
        """Gets the stripe_size_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The stripe_size_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: ByteUnit
        """
        return self._stripe_size_unit

    @stripe_size_unit.setter
    def stripe_size_unit(self, stripe_size_unit):
        """Sets the stripe_size_unit of this IscsiTargetCreationParams.


        :param stripe_size_unit: The stripe_size_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type stripe_size_unit: ByteUnit
        """

        self._stripe_size_unit = stripe_size_unit

    @property
    def stripe_size(self):
        """Gets the stripe_size of this IscsiTargetCreationParams.  # noqa: E501


        :return: The stripe_size of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._stripe_size

    @stripe_size.setter
    def stripe_size(self, stripe_size):
        """Sets the stripe_size of this IscsiTargetCreationParams.


        :param stripe_size: The stripe_size of this IscsiTargetCreationParams.  # noqa: E501
        :type stripe_size: int
        """
        if self.local_vars_configuration.client_side_validation and stripe_size is None:  # noqa: E501
            raise ValueError("Invalid value for `stripe_size`, must not be `None`")  # noqa: E501

        self._stripe_size = stripe_size

    @property
    def stripe_num(self):
        """Gets the stripe_num of this IscsiTargetCreationParams.  # noqa: E501


        :return: The stripe_num of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._stripe_num

    @stripe_num.setter
    def stripe_num(self, stripe_num):
        """Sets the stripe_num of this IscsiTargetCreationParams.


        :param stripe_num: The stripe_num of this IscsiTargetCreationParams.  # noqa: E501
        :type stripe_num: int
        """
        if self.local_vars_configuration.client_side_validation and stripe_num is None:  # noqa: E501
            raise ValueError("Invalid value for `stripe_num`, must not be `None`")  # noqa: E501

        self._stripe_num = stripe_num

    @property
    def replica_num(self):
        """Gets the replica_num of this IscsiTargetCreationParams.  # noqa: E501


        :return: The replica_num of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this IscsiTargetCreationParams.


        :param replica_num: The replica_num of this IscsiTargetCreationParams.  # noqa: E501
        :type replica_num: int
        """
        if self.local_vars_configuration.client_side_validation and replica_num is None:  # noqa: E501
            raise ValueError("Invalid value for `replica_num`, must not be `None`")  # noqa: E501

        self._replica_num = replica_num

    @property
    def thin_provision(self):
        """Gets the thin_provision of this IscsiTargetCreationParams.  # noqa: E501


        :return: The thin_provision of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this IscsiTargetCreationParams.


        :param thin_provision: The thin_provision of this IscsiTargetCreationParams.  # noqa: E501
        :type thin_provision: bool
        """
        if self.local_vars_configuration.client_side_validation and thin_provision is None:  # noqa: E501
            raise ValueError("Invalid value for `thin_provision`, must not be `None`")  # noqa: E501

        self._thin_provision = thin_provision

    @property
    def cluster_id(self):
        """Gets the cluster_id of this IscsiTargetCreationParams.  # noqa: E501


        :return: The cluster_id of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this IscsiTargetCreationParams.


        :param cluster_id: The cluster_id of this IscsiTargetCreationParams.  # noqa: E501
        :type cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_id`, must not be `None`")  # noqa: E501

        self._cluster_id = cluster_id

    @property
    def name(self):
        """Gets the name of this IscsiTargetCreationParams.  # noqa: E501


        :return: The name of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IscsiTargetCreationParams.


        :param name: The name of this IscsiTargetCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def business_host_groups(self):
        """Gets the business_host_groups of this IscsiTargetCreationParams.  # noqa: E501


        :return: The business_host_groups of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BusinessHostGroupWhereInput
        """
        return self._business_host_groups

    @business_host_groups.setter
    def business_host_groups(self, business_host_groups):
        """Sets the business_host_groups of this IscsiTargetCreationParams.


        :param business_host_groups: The business_host_groups of this IscsiTargetCreationParams.  # noqa: E501
        :type business_host_groups: BusinessHostGroupWhereInput
        """

        self._business_host_groups = business_host_groups

    @property
    def business_hosts(self):
        """Gets the business_hosts of this IscsiTargetCreationParams.  # noqa: E501


        :return: The business_hosts of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BusinessHostWhereInput
        """
        return self._business_hosts

    @business_hosts.setter
    def business_hosts(self, business_hosts):
        """Sets the business_hosts of this IscsiTargetCreationParams.


        :param business_hosts: The business_hosts of this IscsiTargetCreationParams.  # noqa: E501
        :type business_hosts: BusinessHostWhereInput
        """

        self._business_hosts = business_hosts

    @property
    def configuration_adaptive(self):
        """Gets the configuration_adaptive of this IscsiTargetCreationParams.  # noqa: E501


        :return: The configuration_adaptive of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._configuration_adaptive

    @configuration_adaptive.setter
    def configuration_adaptive(self, configuration_adaptive):
        """Sets the configuration_adaptive of this IscsiTargetCreationParams.


        :param configuration_adaptive: The configuration_adaptive of this IscsiTargetCreationParams.  # noqa: E501
        :type configuration_adaptive: bool
        """

        self._configuration_adaptive = configuration_adaptive

    @property
    def configuration_method(self):
        """Gets the configuration_method of this IscsiTargetCreationParams.  # noqa: E501


        :return: The configuration_method of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: ConfigurationMethod
        """
        return self._configuration_method

    @configuration_method.setter
    def configuration_method(self, configuration_method):
        """Sets the configuration_method of this IscsiTargetCreationParams.


        :param configuration_method: The configuration_method of this IscsiTargetCreationParams.  # noqa: E501
        :type configuration_method: ConfigurationMethod
        """

        self._configuration_method = configuration_method

    @property
    def encrypt_method(self):
        """Gets the encrypt_method of this IscsiTargetCreationParams.  # noqa: E501


        :return: The encrypt_method of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: EncryptMethod
        """
        return self._encrypt_method

    @encrypt_method.setter
    def encrypt_method(self, encrypt_method):
        """Sets the encrypt_method of this IscsiTargetCreationParams.


        :param encrypt_method: The encrypt_method of this IscsiTargetCreationParams.  # noqa: E501
        :type encrypt_method: EncryptMethod
        """

        self._encrypt_method = encrypt_method

    @property
    def prioritized(self):
        """Gets the prioritized of this IscsiTargetCreationParams.  # noqa: E501


        :return: The prioritized of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._prioritized

    @prioritized.setter
    def prioritized(self, prioritized):
        """Sets the prioritized of this IscsiTargetCreationParams.


        :param prioritized: The prioritized of this IscsiTargetCreationParams.  # noqa: E501
        :type prioritized: bool
        """

        self._prioritized = prioritized

    @property
    def ec_m(self):
        """Gets the ec_m of this IscsiTargetCreationParams.  # noqa: E501


        :return: The ec_m of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: float
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this IscsiTargetCreationParams.


        :param ec_m: The ec_m of this IscsiTargetCreationParams.  # noqa: E501
        :type ec_m: float
        """

        self._ec_m = ec_m

    @property
    def ec_k(self):
        """Gets the ec_k of this IscsiTargetCreationParams.  # noqa: E501


        :return: The ec_k of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: float
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this IscsiTargetCreationParams.


        :param ec_k: The ec_k of this IscsiTargetCreationParams.  # noqa: E501
        :type ec_k: float
        """

        self._ec_k = ec_k

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this IscsiTargetCreationParams.  # noqa: E501


        :return: The resiliency_type of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this IscsiTargetCreationParams.


        :param resiliency_type: The resiliency_type of this IscsiTargetCreationParams.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def bps_wr_max_length(self):
        """Gets the bps_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_wr_max_length

    @bps_wr_max_length.setter
    def bps_wr_max_length(self, bps_wr_max_length):
        """Sets the bps_wr_max_length of this IscsiTargetCreationParams.


        :param bps_wr_max_length: The bps_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr_max_length: int
        """

        self._bps_wr_max_length = bps_wr_max_length

    @property
    def bps_wr_max_unit(self):
        """Gets the bps_wr_max_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_wr_max_unit

    @bps_wr_max_unit.setter
    def bps_wr_max_unit(self, bps_wr_max_unit):
        """Sets the bps_wr_max_unit of this IscsiTargetCreationParams.


        :param bps_wr_max_unit: The bps_wr_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr_max_unit: BPSUnit
        """

        self._bps_wr_max_unit = bps_wr_max_unit

    @property
    def bps_wr_max_size(self):
        """Gets the bps_wr_max_size of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr_max_size of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_wr_max_size

    @bps_wr_max_size.setter
    def bps_wr_max_size(self, bps_wr_max_size):
        """Sets the bps_wr_max_size of this IscsiTargetCreationParams.


        :param bps_wr_max_size: The bps_wr_max_size of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr_max_size: BPSUnit
        """

        self._bps_wr_max_size = bps_wr_max_size

    @property
    def bps_wr_max(self):
        """Gets the bps_wr_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_wr_max

    @bps_wr_max.setter
    def bps_wr_max(self, bps_wr_max):
        """Sets the bps_wr_max of this IscsiTargetCreationParams.


        :param bps_wr_max: The bps_wr_max of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr_max: int
        """

        self._bps_wr_max = bps_wr_max

    @property
    def bps_rd_max_length(self):
        """Gets the bps_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_rd_max_length

    @bps_rd_max_length.setter
    def bps_rd_max_length(self, bps_rd_max_length):
        """Sets the bps_rd_max_length of this IscsiTargetCreationParams.


        :param bps_rd_max_length: The bps_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_rd_max_length: int
        """

        self._bps_rd_max_length = bps_rd_max_length

    @property
    def bps_rd_max_unit(self):
        """Gets the bps_rd_max_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_rd_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_rd_max_unit

    @bps_rd_max_unit.setter
    def bps_rd_max_unit(self, bps_rd_max_unit):
        """Sets the bps_rd_max_unit of this IscsiTargetCreationParams.


        :param bps_rd_max_unit: The bps_rd_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_rd_max_unit: BPSUnit
        """

        self._bps_rd_max_unit = bps_rd_max_unit

    @property
    def bps_rd_max(self):
        """Gets the bps_rd_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_rd_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_rd_max

    @bps_rd_max.setter
    def bps_rd_max(self, bps_rd_max):
        """Sets the bps_rd_max of this IscsiTargetCreationParams.


        :param bps_rd_max: The bps_rd_max of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_rd_max: int
        """

        self._bps_rd_max = bps_rd_max

    @property
    def bps_max_length(self):
        """Gets the bps_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_max_length

    @bps_max_length.setter
    def bps_max_length(self, bps_max_length):
        """Sets the bps_max_length of this IscsiTargetCreationParams.


        :param bps_max_length: The bps_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_max_length: int
        """

        self._bps_max_length = bps_max_length

    @property
    def bps_max_unit(self):
        """Gets the bps_max_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_max_unit

    @bps_max_unit.setter
    def bps_max_unit(self, bps_max_unit):
        """Sets the bps_max_unit of this IscsiTargetCreationParams.


        :param bps_max_unit: The bps_max_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_max_unit: BPSUnit
        """

        self._bps_max_unit = bps_max_unit

    @property
    def bps_max(self):
        """Gets the bps_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_max

    @bps_max.setter
    def bps_max(self, bps_max):
        """Sets the bps_max of this IscsiTargetCreationParams.


        :param bps_max: The bps_max of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_max: int
        """

        self._bps_max = bps_max

    @property
    def iops_wr_max_length(self):
        """Gets the iops_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_wr_max_length

    @iops_wr_max_length.setter
    def iops_wr_max_length(self, iops_wr_max_length):
        """Sets the iops_wr_max_length of this IscsiTargetCreationParams.


        :param iops_wr_max_length: The iops_wr_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_wr_max_length: int
        """

        self._iops_wr_max_length = iops_wr_max_length

    @property
    def iops_wr_max(self):
        """Gets the iops_wr_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_wr_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_wr_max

    @iops_wr_max.setter
    def iops_wr_max(self, iops_wr_max):
        """Sets the iops_wr_max of this IscsiTargetCreationParams.


        :param iops_wr_max: The iops_wr_max of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_wr_max: int
        """

        self._iops_wr_max = iops_wr_max

    @property
    def iops_rd_max_length(self):
        """Gets the iops_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_rd_max_length

    @iops_rd_max_length.setter
    def iops_rd_max_length(self, iops_rd_max_length):
        """Sets the iops_rd_max_length of this IscsiTargetCreationParams.


        :param iops_rd_max_length: The iops_rd_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_rd_max_length: int
        """

        self._iops_rd_max_length = iops_rd_max_length

    @property
    def iops_rd_max(self):
        """Gets the iops_rd_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_rd_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_rd_max

    @iops_rd_max.setter
    def iops_rd_max(self, iops_rd_max):
        """Sets the iops_rd_max of this IscsiTargetCreationParams.


        :param iops_rd_max: The iops_rd_max of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_rd_max: int
        """

        self._iops_rd_max = iops_rd_max

    @property
    def iops_max_length(self):
        """Gets the iops_max_length of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_max_length

    @iops_max_length.setter
    def iops_max_length(self, iops_max_length):
        """Sets the iops_max_length of this IscsiTargetCreationParams.


        :param iops_max_length: The iops_max_length of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_max_length: int
        """

        self._iops_max_length = iops_max_length

    @property
    def iops_max(self):
        """Gets the iops_max of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_max of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_max

    @iops_max.setter
    def iops_max(self, iops_max):
        """Sets the iops_max of this IscsiTargetCreationParams.


        :param iops_max: The iops_max of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_max: int
        """

        self._iops_max = iops_max

    @property
    def bps_wr_unit(self):
        """Gets the bps_wr_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_wr_unit

    @bps_wr_unit.setter
    def bps_wr_unit(self, bps_wr_unit):
        """Sets the bps_wr_unit of this IscsiTargetCreationParams.


        :param bps_wr_unit: The bps_wr_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr_unit: BPSUnit
        """

        self._bps_wr_unit = bps_wr_unit

    @property
    def bps_wr(self):
        """Gets the bps_wr of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_wr of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_wr

    @bps_wr.setter
    def bps_wr(self, bps_wr):
        """Sets the bps_wr of this IscsiTargetCreationParams.


        :param bps_wr: The bps_wr of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_wr: int
        """

        self._bps_wr = bps_wr

    @property
    def bps_rd_unit(self):
        """Gets the bps_rd_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_rd_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_rd_unit

    @bps_rd_unit.setter
    def bps_rd_unit(self, bps_rd_unit):
        """Sets the bps_rd_unit of this IscsiTargetCreationParams.


        :param bps_rd_unit: The bps_rd_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_rd_unit: BPSUnit
        """

        self._bps_rd_unit = bps_rd_unit

    @property
    def bps_rd(self):
        """Gets the bps_rd of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_rd of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps_rd

    @bps_rd.setter
    def bps_rd(self, bps_rd):
        """Sets the bps_rd of this IscsiTargetCreationParams.


        :param bps_rd: The bps_rd of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_rd: int
        """

        self._bps_rd = bps_rd

    @property
    def bps_unit(self):
        """Gets the bps_unit of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps_unit of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._bps_unit

    @bps_unit.setter
    def bps_unit(self, bps_unit):
        """Sets the bps_unit of this IscsiTargetCreationParams.


        :param bps_unit: The bps_unit of this IscsiTargetCreationParams.  # noqa: E501
        :type bps_unit: BPSUnit
        """

        self._bps_unit = bps_unit

    @property
    def bps(self):
        """Gets the bps of this IscsiTargetCreationParams.  # noqa: E501


        :return: The bps of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._bps

    @bps.setter
    def bps(self, bps):
        """Sets the bps of this IscsiTargetCreationParams.


        :param bps: The bps of this IscsiTargetCreationParams.  # noqa: E501
        :type bps: int
        """

        self._bps = bps

    @property
    def iops_wr(self):
        """Gets the iops_wr of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_wr of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_wr

    @iops_wr.setter
    def iops_wr(self, iops_wr):
        """Sets the iops_wr of this IscsiTargetCreationParams.


        :param iops_wr: The iops_wr of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_wr: int
        """

        self._iops_wr = iops_wr

    @property
    def iops_rd(self):
        """Gets the iops_rd of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops_rd of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops_rd

    @iops_rd.setter
    def iops_rd(self, iops_rd):
        """Sets the iops_rd of this IscsiTargetCreationParams.


        :param iops_rd: The iops_rd of this IscsiTargetCreationParams.  # noqa: E501
        :type iops_rd: int
        """

        self._iops_rd = iops_rd

    @property
    def iops(self):
        """Gets the iops of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iops of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._iops

    @iops.setter
    def iops(self, iops):
        """Sets the iops of this IscsiTargetCreationParams.


        :param iops: The iops of this IscsiTargetCreationParams.  # noqa: E501
        :type iops: int
        """

        self._iops = iops

    @property
    def initiator_chaps(self):
        """Gets the initiator_chaps of this IscsiTargetCreationParams.  # noqa: E501


        :return: The initiator_chaps of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: list[IscsiTargetCommonParamsInitiatorChaps]
        """
        return self._initiator_chaps

    @initiator_chaps.setter
    def initiator_chaps(self, initiator_chaps):
        """Sets the initiator_chaps of this IscsiTargetCreationParams.


        :param initiator_chaps: The initiator_chaps of this IscsiTargetCreationParams.  # noqa: E501
        :type initiator_chaps: list[IscsiTargetCommonParamsInitiatorChaps]
        """

        self._initiator_chaps = initiator_chaps

    @property
    def chap_secret(self):
        """Gets the chap_secret of this IscsiTargetCreationParams.  # noqa: E501


        :return: The chap_secret of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._chap_secret

    @chap_secret.setter
    def chap_secret(self, chap_secret):
        """Sets the chap_secret of this IscsiTargetCreationParams.


        :param chap_secret: The chap_secret of this IscsiTargetCreationParams.  # noqa: E501
        :type chap_secret: str
        """

        self._chap_secret = chap_secret

    @property
    def chap_name(self):
        """Gets the chap_name of this IscsiTargetCreationParams.  # noqa: E501


        :return: The chap_name of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._chap_name

    @chap_name.setter
    def chap_name(self, chap_name):
        """Sets the chap_name of this IscsiTargetCreationParams.


        :param chap_name: The chap_name of this IscsiTargetCreationParams.  # noqa: E501
        :type chap_name: str
        """

        self._chap_name = chap_name

    @property
    def chap_enabled(self):
        """Gets the chap_enabled of this IscsiTargetCreationParams.  # noqa: E501


        :return: The chap_enabled of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._chap_enabled

    @chap_enabled.setter
    def chap_enabled(self, chap_enabled):
        """Sets the chap_enabled of this IscsiTargetCreationParams.


        :param chap_enabled: The chap_enabled of this IscsiTargetCreationParams.  # noqa: E501
        :type chap_enabled: bool
        """

        self._chap_enabled = chap_enabled

    @property
    def description(self):
        """Gets the description of this IscsiTargetCreationParams.  # noqa: E501


        :return: The description of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this IscsiTargetCreationParams.


        :param description: The description of this IscsiTargetCreationParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def iqn_whitelist(self):
        """Gets the iqn_whitelist of this IscsiTargetCreationParams.  # noqa: E501


        :return: The iqn_whitelist of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._iqn_whitelist

    @iqn_whitelist.setter
    def iqn_whitelist(self, iqn_whitelist):
        """Sets the iqn_whitelist of this IscsiTargetCreationParams.


        :param iqn_whitelist: The iqn_whitelist of this IscsiTargetCreationParams.  # noqa: E501
        :type iqn_whitelist: str
        """

        self._iqn_whitelist = iqn_whitelist

    @property
    def ip_whitelist(self):
        """Gets the ip_whitelist of this IscsiTargetCreationParams.  # noqa: E501


        :return: The ip_whitelist of this IscsiTargetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._ip_whitelist

    @ip_whitelist.setter
    def ip_whitelist(self, ip_whitelist):
        """Sets the ip_whitelist of this IscsiTargetCreationParams.


        :param ip_whitelist: The ip_whitelist of this IscsiTargetCreationParams.  # noqa: E501
        :type ip_whitelist: str
        """

        self._ip_whitelist = ip_whitelist

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IscsiTargetCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IscsiTargetCreationParams):
            return True

        return self.to_dict() != other.to_dict()
