# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IscsiTargetUpdationParamsDataAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'replica_num': 'int',
        'thin_provision': 'bool'
    }

    attribute_map = {
        'replica_num': 'replica_num',
        'thin_provision': 'thin_provision'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IscsiTargetUpdationParamsDataAllOf - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._replica_num = None
        self._thin_provision = None
        self.discriminator = None

        if "replica_num" in kwargs:
            self.replica_num = kwargs["replica_num"]
        if "thin_provision" in kwargs:
            self.thin_provision = kwargs["thin_provision"]

    @property
    def replica_num(self):
        """Gets the replica_num of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501


        :return: The replica_num of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this IscsiTargetUpdationParamsDataAllOf.


        :param replica_num: The replica_num of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501
        :type replica_num: int
        """

        self._replica_num = replica_num

    @property
    def thin_provision(self):
        """Gets the thin_provision of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501


        :return: The thin_provision of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this IscsiTargetUpdationParamsDataAllOf.


        :param thin_provision: The thin_provision of this IscsiTargetUpdationParamsDataAllOf.  # noqa: E501
        :type thin_provision: bool
        """

        self._thin_provision = thin_provision

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IscsiTargetUpdationParamsDataAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IscsiTargetUpdationParamsDataAllOf):
            return True

        return self.to_dict() != other.to_dict()
