# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IsolationPolicyCreateParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ingress': 'list[SecurityPolicyIngressEgressInput]',
        'egress': 'list[SecurityPolicyIngressEgressInput]',
        'mode': 'IsolationMode',
        'vm_id': 'str',
        'everoute_cluster_id': 'str'
    }

    attribute_map = {
        'ingress': 'ingress',
        'egress': 'egress',
        'mode': 'mode',
        'vm_id': 'vm_id',
        'everoute_cluster_id': 'everoute_cluster_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IsolationPolicyCreateParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._ingress = None
        self._egress = None
        self._mode = None
        self._vm_id = None
        self._everoute_cluster_id = None
        self.discriminator = None

        if "ingress" in kwargs:
            self.ingress = kwargs["ingress"]
        if "egress" in kwargs:
            self.egress = kwargs["egress"]
        if "mode" in kwargs:
            self.mode = kwargs["mode"]
        if "vm_id" in kwargs:
            self.vm_id = kwargs["vm_id"]
        if "everoute_cluster_id" in kwargs:
            self.everoute_cluster_id = kwargs["everoute_cluster_id"]

    @property
    def ingress(self):
        """Gets the ingress of this IsolationPolicyCreateParams.  # noqa: E501


        :return: The ingress of this IsolationPolicyCreateParams.  # noqa: E501
        :rtype: list[SecurityPolicyIngressEgressInput]
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this IsolationPolicyCreateParams.


        :param ingress: The ingress of this IsolationPolicyCreateParams.  # noqa: E501
        :type ingress: list[SecurityPolicyIngressEgressInput]
        """

        self._ingress = ingress

    @property
    def egress(self):
        """Gets the egress of this IsolationPolicyCreateParams.  # noqa: E501


        :return: The egress of this IsolationPolicyCreateParams.  # noqa: E501
        :rtype: list[SecurityPolicyIngressEgressInput]
        """
        return self._egress

    @egress.setter
    def egress(self, egress):
        """Sets the egress of this IsolationPolicyCreateParams.


        :param egress: The egress of this IsolationPolicyCreateParams.  # noqa: E501
        :type egress: list[SecurityPolicyIngressEgressInput]
        """

        self._egress = egress

    @property
    def mode(self):
        """Gets the mode of this IsolationPolicyCreateParams.  # noqa: E501


        :return: The mode of this IsolationPolicyCreateParams.  # noqa: E501
        :rtype: IsolationMode
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this IsolationPolicyCreateParams.


        :param mode: The mode of this IsolationPolicyCreateParams.  # noqa: E501
        :type mode: IsolationMode
        """
        if self.local_vars_configuration.client_side_validation and mode is None:  # noqa: E501
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501

        self._mode = mode

    @property
    def vm_id(self):
        """Gets the vm_id of this IsolationPolicyCreateParams.  # noqa: E501


        :return: The vm_id of this IsolationPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._vm_id

    @vm_id.setter
    def vm_id(self, vm_id):
        """Sets the vm_id of this IsolationPolicyCreateParams.


        :param vm_id: The vm_id of this IsolationPolicyCreateParams.  # noqa: E501
        :type vm_id: str
        """
        if self.local_vars_configuration.client_side_validation and vm_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_id`, must not be `None`")  # noqa: E501

        self._vm_id = vm_id

    @property
    def everoute_cluster_id(self):
        """Gets the everoute_cluster_id of this IsolationPolicyCreateParams.  # noqa: E501


        :return: The everoute_cluster_id of this IsolationPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._everoute_cluster_id

    @everoute_cluster_id.setter
    def everoute_cluster_id(self, everoute_cluster_id):
        """Sets the everoute_cluster_id of this IsolationPolicyCreateParams.


        :param everoute_cluster_id: The everoute_cluster_id of this IsolationPolicyCreateParams.  # noqa: E501
        :type everoute_cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and everoute_cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `everoute_cluster_id`, must not be `None`")  # noqa: E501

        self._everoute_cluster_id = everoute_cluster_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IsolationPolicyCreateParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IsolationPolicyCreateParams):
            return True

        return self.to_dict() != other.to_dict()
