# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Label(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster_num': 'int',
        'clusters': 'list[NestedCluster]',
        'consistency_group_num': 'int',
        'consistency_group_snapshot_num': 'int',
        'consistency_group_snapshots': 'list[NestedConsistencyGroupSnapshot]',
        'consistency_groups': 'list[NestedConsistencyGroup]',
        'content_library_image_num': 'int',
        'content_library_images': 'list[NestedContentLibraryImage]',
        'content_library_vm_template_num': 'int',
        'content_library_vm_templates': 'list[NestedContentLibraryVmTemplate]',
        'created_at': 'str',
        'datacenter_num': 'int',
        'datacenters': 'list[NestedDatacenter]',
        'disk_num': 'int',
        'disks': 'list[NestedDisk]',
        'elf_image_num': 'int',
        'elf_images': 'list[NestedElfImage]',
        'gpu_device_num': 'int',
        'gpu_devices': 'list[NestedGpuDevice]',
        'host_num': 'int',
        'hosts': 'list[NestedHost]',
        'id': 'str',
        'iscsi_lun_num': 'int',
        'iscsi_lun_snapshot_num': 'int',
        'iscsi_lun_snapshots': 'list[NestedIscsiLunSnapshot]',
        'iscsi_luns': 'list[NestedIscsiLun]',
        'iscsi_target_num': 'int',
        'iscsi_targets': 'list[NestedIscsiTarget]',
        'isolation_policies': 'list[NestedIsolationPolicy]',
        'isolation_policy_num': 'int',
        'key': 'str',
        'namespace_group_num': 'int',
        'namespace_groups': 'list[NestedNamespaceGroup]',
        'nfs_export_num': 'int',
        'nfs_exports': 'list[NestedNfsExport]',
        'nfs_inode_num': 'int',
        'nfs_inodes': 'list[NestedNfsInode]',
        'nic_num': 'int',
        'nics': 'list[NestedNic]',
        'nvmf_namespace_num': 'int',
        'nvmf_namespace_snapshot_num': 'int',
        'nvmf_namespace_snapshots': 'list[NestedNvmfNamespaceSnapshot]',
        'nvmf_namespaces': 'list[NestedNvmfNamespace]',
        'nvmf_subsystem_num': 'int',
        'nvmf_subsystems': 'list[NestedNvmfSubsystem]',
        'security_policies': 'list[NestedSecurityPolicy]',
        'security_policy_num': 'int',
        'system_vlan_num': 'int',
        'total_num': 'int',
        'value': 'str',
        'vds_num': 'int',
        'vdses': 'list[NestedVds]',
        'vlans': 'list[NestedVlan]',
        'vm_num': 'int',
        'vm_snapshot_num': 'int',
        'vm_snapshots': 'list[NestedVmSnapshot]',
        'vm_template_num': 'int',
        'vm_templates': 'list[NestedVmTemplate]',
        'vm_vlan_num': 'int',
        'vm_volume_num': 'int',
        'vm_volume_snapshot_num': 'int',
        'vm_volume_snapshots': 'list[NestedVmVolumeSnapshot]',
        'vm_volumes': 'list[NestedVmVolume]',
        'vms': 'list[NestedVm]'
    }

    attribute_map = {
        'cluster_num': 'cluster_num',
        'clusters': 'clusters',
        'consistency_group_num': 'consistency_group_num',
        'consistency_group_snapshot_num': 'consistency_group_snapshot_num',
        'consistency_group_snapshots': 'consistency_group_snapshots',
        'consistency_groups': 'consistency_groups',
        'content_library_image_num': 'content_library_image_num',
        'content_library_images': 'content_library_images',
        'content_library_vm_template_num': 'content_library_vm_template_num',
        'content_library_vm_templates': 'content_library_vm_templates',
        'created_at': 'createdAt',
        'datacenter_num': 'datacenter_num',
        'datacenters': 'datacenters',
        'disk_num': 'disk_num',
        'disks': 'disks',
        'elf_image_num': 'elf_image_num',
        'elf_images': 'elf_images',
        'gpu_device_num': 'gpu_device_num',
        'gpu_devices': 'gpu_devices',
        'host_num': 'host_num',
        'hosts': 'hosts',
        'id': 'id',
        'iscsi_lun_num': 'iscsi_lun_num',
        'iscsi_lun_snapshot_num': 'iscsi_lun_snapshot_num',
        'iscsi_lun_snapshots': 'iscsi_lun_snapshots',
        'iscsi_luns': 'iscsi_luns',
        'iscsi_target_num': 'iscsi_target_num',
        'iscsi_targets': 'iscsi_targets',
        'isolation_policies': 'isolation_policies',
        'isolation_policy_num': 'isolation_policy_num',
        'key': 'key',
        'namespace_group_num': 'namespace_group_num',
        'namespace_groups': 'namespace_groups',
        'nfs_export_num': 'nfs_export_num',
        'nfs_exports': 'nfs_exports',
        'nfs_inode_num': 'nfs_inode_num',
        'nfs_inodes': 'nfs_inodes',
        'nic_num': 'nic_num',
        'nics': 'nics',
        'nvmf_namespace_num': 'nvmf_namespace_num',
        'nvmf_namespace_snapshot_num': 'nvmf_namespace_snapshot_num',
        'nvmf_namespace_snapshots': 'nvmf_namespace_snapshots',
        'nvmf_namespaces': 'nvmf_namespaces',
        'nvmf_subsystem_num': 'nvmf_subsystem_num',
        'nvmf_subsystems': 'nvmf_subsystems',
        'security_policies': 'security_policies',
        'security_policy_num': 'security_policy_num',
        'system_vlan_num': 'system_vlan_num',
        'total_num': 'total_num',
        'value': 'value',
        'vds_num': 'vds_num',
        'vdses': 'vdses',
        'vlans': 'vlans',
        'vm_num': 'vm_num',
        'vm_snapshot_num': 'vm_snapshot_num',
        'vm_snapshots': 'vm_snapshots',
        'vm_template_num': 'vm_template_num',
        'vm_templates': 'vm_templates',
        'vm_vlan_num': 'vm_vlan_num',
        'vm_volume_num': 'vm_volume_num',
        'vm_volume_snapshot_num': 'vm_volume_snapshot_num',
        'vm_volume_snapshots': 'vm_volume_snapshots',
        'vm_volumes': 'vm_volumes',
        'vms': 'vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Label - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster_num = None
        self._clusters = None
        self._consistency_group_num = None
        self._consistency_group_snapshot_num = None
        self._consistency_group_snapshots = None
        self._consistency_groups = None
        self._content_library_image_num = None
        self._content_library_images = None
        self._content_library_vm_template_num = None
        self._content_library_vm_templates = None
        self._created_at = None
        self._datacenter_num = None
        self._datacenters = None
        self._disk_num = None
        self._disks = None
        self._elf_image_num = None
        self._elf_images = None
        self._gpu_device_num = None
        self._gpu_devices = None
        self._host_num = None
        self._hosts = None
        self._id = None
        self._iscsi_lun_num = None
        self._iscsi_lun_snapshot_num = None
        self._iscsi_lun_snapshots = None
        self._iscsi_luns = None
        self._iscsi_target_num = None
        self._iscsi_targets = None
        self._isolation_policies = None
        self._isolation_policy_num = None
        self._key = None
        self._namespace_group_num = None
        self._namespace_groups = None
        self._nfs_export_num = None
        self._nfs_exports = None
        self._nfs_inode_num = None
        self._nfs_inodes = None
        self._nic_num = None
        self._nics = None
        self._nvmf_namespace_num = None
        self._nvmf_namespace_snapshot_num = None
        self._nvmf_namespace_snapshots = None
        self._nvmf_namespaces = None
        self._nvmf_subsystem_num = None
        self._nvmf_subsystems = None
        self._security_policies = None
        self._security_policy_num = None
        self._system_vlan_num = None
        self._total_num = None
        self._value = None
        self._vds_num = None
        self._vdses = None
        self._vlans = None
        self._vm_num = None
        self._vm_snapshot_num = None
        self._vm_snapshots = None
        self._vm_template_num = None
        self._vm_templates = None
        self._vm_vlan_num = None
        self._vm_volume_num = None
        self._vm_volume_snapshot_num = None
        self._vm_volume_snapshots = None
        self._vm_volumes = None
        self._vms = None
        self.discriminator = None

        self.cluster_num = kwargs.get("cluster_num", None)
        self.clusters = kwargs.get("clusters", None)
        self.consistency_group_num = kwargs.get("consistency_group_num", None)
        self.consistency_group_snapshot_num = kwargs.get("consistency_group_snapshot_num", None)
        self.consistency_group_snapshots = kwargs.get("consistency_group_snapshots", None)
        self.consistency_groups = kwargs.get("consistency_groups", None)
        self.content_library_image_num = kwargs.get("content_library_image_num", None)
        self.content_library_images = kwargs.get("content_library_images", None)
        self.content_library_vm_template_num = kwargs.get("content_library_vm_template_num", None)
        self.content_library_vm_templates = kwargs.get("content_library_vm_templates", None)
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.datacenter_num = kwargs.get("datacenter_num", None)
        self.datacenters = kwargs.get("datacenters", None)
        self.disk_num = kwargs.get("disk_num", None)
        self.disks = kwargs.get("disks", None)
        self.elf_image_num = kwargs.get("elf_image_num", None)
        self.elf_images = kwargs.get("elf_images", None)
        self.gpu_device_num = kwargs.get("gpu_device_num", None)
        self.gpu_devices = kwargs.get("gpu_devices", None)
        self.host_num = kwargs.get("host_num", None)
        self.hosts = kwargs.get("hosts", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.iscsi_lun_num = kwargs.get("iscsi_lun_num", None)
        self.iscsi_lun_snapshot_num = kwargs.get("iscsi_lun_snapshot_num", None)
        self.iscsi_lun_snapshots = kwargs.get("iscsi_lun_snapshots", None)
        self.iscsi_luns = kwargs.get("iscsi_luns", None)
        self.iscsi_target_num = kwargs.get("iscsi_target_num", None)
        self.iscsi_targets = kwargs.get("iscsi_targets", None)
        self.isolation_policies = kwargs.get("isolation_policies", None)
        self.isolation_policy_num = kwargs.get("isolation_policy_num", None)
        if "key" in kwargs:
            self.key = kwargs["key"]
        self.namespace_group_num = kwargs.get("namespace_group_num", None)
        self.namespace_groups = kwargs.get("namespace_groups", None)
        self.nfs_export_num = kwargs.get("nfs_export_num", None)
        self.nfs_exports = kwargs.get("nfs_exports", None)
        self.nfs_inode_num = kwargs.get("nfs_inode_num", None)
        self.nfs_inodes = kwargs.get("nfs_inodes", None)
        self.nic_num = kwargs.get("nic_num", None)
        self.nics = kwargs.get("nics", None)
        self.nvmf_namespace_num = kwargs.get("nvmf_namespace_num", None)
        self.nvmf_namespace_snapshot_num = kwargs.get("nvmf_namespace_snapshot_num", None)
        self.nvmf_namespace_snapshots = kwargs.get("nvmf_namespace_snapshots", None)
        self.nvmf_namespaces = kwargs.get("nvmf_namespaces", None)
        self.nvmf_subsystem_num = kwargs.get("nvmf_subsystem_num", None)
        self.nvmf_subsystems = kwargs.get("nvmf_subsystems", None)
        self.security_policies = kwargs.get("security_policies", None)
        self.security_policy_num = kwargs.get("security_policy_num", None)
        self.system_vlan_num = kwargs.get("system_vlan_num", None)
        self.total_num = kwargs.get("total_num", None)
        self.value = kwargs.get("value", None)
        self.vds_num = kwargs.get("vds_num", None)
        self.vdses = kwargs.get("vdses", None)
        self.vlans = kwargs.get("vlans", None)
        self.vm_num = kwargs.get("vm_num", None)
        self.vm_snapshot_num = kwargs.get("vm_snapshot_num", None)
        self.vm_snapshots = kwargs.get("vm_snapshots", None)
        self.vm_template_num = kwargs.get("vm_template_num", None)
        self.vm_templates = kwargs.get("vm_templates", None)
        self.vm_vlan_num = kwargs.get("vm_vlan_num", None)
        self.vm_volume_num = kwargs.get("vm_volume_num", None)
        self.vm_volume_snapshot_num = kwargs.get("vm_volume_snapshot_num", None)
        self.vm_volume_snapshots = kwargs.get("vm_volume_snapshots", None)
        self.vm_volumes = kwargs.get("vm_volumes", None)
        self.vms = kwargs.get("vms", None)

    @property
    def cluster_num(self):
        """Gets the cluster_num of this Label.  # noqa: E501


        :return: The cluster_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._cluster_num

    @cluster_num.setter
    def cluster_num(self, cluster_num):
        """Sets the cluster_num of this Label.


        :param cluster_num: The cluster_num of this Label.  # noqa: E501
        :type cluster_num: int
        """

        self._cluster_num = cluster_num

    @property
    def clusters(self):
        """Gets the clusters of this Label.  # noqa: E501


        :return: The clusters of this Label.  # noqa: E501
        :rtype: list[NestedCluster]
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """Sets the clusters of this Label.


        :param clusters: The clusters of this Label.  # noqa: E501
        :type clusters: list[NestedCluster]
        """

        self._clusters = clusters

    @property
    def consistency_group_num(self):
        """Gets the consistency_group_num of this Label.  # noqa: E501


        :return: The consistency_group_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._consistency_group_num

    @consistency_group_num.setter
    def consistency_group_num(self, consistency_group_num):
        """Sets the consistency_group_num of this Label.


        :param consistency_group_num: The consistency_group_num of this Label.  # noqa: E501
        :type consistency_group_num: int
        """

        self._consistency_group_num = consistency_group_num

    @property
    def consistency_group_snapshot_num(self):
        """Gets the consistency_group_snapshot_num of this Label.  # noqa: E501


        :return: The consistency_group_snapshot_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._consistency_group_snapshot_num

    @consistency_group_snapshot_num.setter
    def consistency_group_snapshot_num(self, consistency_group_snapshot_num):
        """Sets the consistency_group_snapshot_num of this Label.


        :param consistency_group_snapshot_num: The consistency_group_snapshot_num of this Label.  # noqa: E501
        :type consistency_group_snapshot_num: int
        """

        self._consistency_group_snapshot_num = consistency_group_snapshot_num

    @property
    def consistency_group_snapshots(self):
        """Gets the consistency_group_snapshots of this Label.  # noqa: E501


        :return: The consistency_group_snapshots of this Label.  # noqa: E501
        :rtype: list[NestedConsistencyGroupSnapshot]
        """
        return self._consistency_group_snapshots

    @consistency_group_snapshots.setter
    def consistency_group_snapshots(self, consistency_group_snapshots):
        """Sets the consistency_group_snapshots of this Label.


        :param consistency_group_snapshots: The consistency_group_snapshots of this Label.  # noqa: E501
        :type consistency_group_snapshots: list[NestedConsistencyGroupSnapshot]
        """

        self._consistency_group_snapshots = consistency_group_snapshots

    @property
    def consistency_groups(self):
        """Gets the consistency_groups of this Label.  # noqa: E501


        :return: The consistency_groups of this Label.  # noqa: E501
        :rtype: list[NestedConsistencyGroup]
        """
        return self._consistency_groups

    @consistency_groups.setter
    def consistency_groups(self, consistency_groups):
        """Sets the consistency_groups of this Label.


        :param consistency_groups: The consistency_groups of this Label.  # noqa: E501
        :type consistency_groups: list[NestedConsistencyGroup]
        """

        self._consistency_groups = consistency_groups

    @property
    def content_library_image_num(self):
        """Gets the content_library_image_num of this Label.  # noqa: E501


        :return: The content_library_image_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._content_library_image_num

    @content_library_image_num.setter
    def content_library_image_num(self, content_library_image_num):
        """Sets the content_library_image_num of this Label.


        :param content_library_image_num: The content_library_image_num of this Label.  # noqa: E501
        :type content_library_image_num: int
        """

        self._content_library_image_num = content_library_image_num

    @property
    def content_library_images(self):
        """Gets the content_library_images of this Label.  # noqa: E501


        :return: The content_library_images of this Label.  # noqa: E501
        :rtype: list[NestedContentLibraryImage]
        """
        return self._content_library_images

    @content_library_images.setter
    def content_library_images(self, content_library_images):
        """Sets the content_library_images of this Label.


        :param content_library_images: The content_library_images of this Label.  # noqa: E501
        :type content_library_images: list[NestedContentLibraryImage]
        """

        self._content_library_images = content_library_images

    @property
    def content_library_vm_template_num(self):
        """Gets the content_library_vm_template_num of this Label.  # noqa: E501


        :return: The content_library_vm_template_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._content_library_vm_template_num

    @content_library_vm_template_num.setter
    def content_library_vm_template_num(self, content_library_vm_template_num):
        """Sets the content_library_vm_template_num of this Label.


        :param content_library_vm_template_num: The content_library_vm_template_num of this Label.  # noqa: E501
        :type content_library_vm_template_num: int
        """

        self._content_library_vm_template_num = content_library_vm_template_num

    @property
    def content_library_vm_templates(self):
        """Gets the content_library_vm_templates of this Label.  # noqa: E501


        :return: The content_library_vm_templates of this Label.  # noqa: E501
        :rtype: list[NestedContentLibraryVmTemplate]
        """
        return self._content_library_vm_templates

    @content_library_vm_templates.setter
    def content_library_vm_templates(self, content_library_vm_templates):
        """Sets the content_library_vm_templates of this Label.


        :param content_library_vm_templates: The content_library_vm_templates of this Label.  # noqa: E501
        :type content_library_vm_templates: list[NestedContentLibraryVmTemplate]
        """

        self._content_library_vm_templates = content_library_vm_templates

    @property
    def created_at(self):
        """Gets the created_at of this Label.  # noqa: E501


        :return: The created_at of this Label.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Label.


        :param created_at: The created_at of this Label.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def datacenter_num(self):
        """Gets the datacenter_num of this Label.  # noqa: E501


        :return: The datacenter_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._datacenter_num

    @datacenter_num.setter
    def datacenter_num(self, datacenter_num):
        """Sets the datacenter_num of this Label.


        :param datacenter_num: The datacenter_num of this Label.  # noqa: E501
        :type datacenter_num: int
        """

        self._datacenter_num = datacenter_num

    @property
    def datacenters(self):
        """Gets the datacenters of this Label.  # noqa: E501


        :return: The datacenters of this Label.  # noqa: E501
        :rtype: list[NestedDatacenter]
        """
        return self._datacenters

    @datacenters.setter
    def datacenters(self, datacenters):
        """Sets the datacenters of this Label.


        :param datacenters: The datacenters of this Label.  # noqa: E501
        :type datacenters: list[NestedDatacenter]
        """

        self._datacenters = datacenters

    @property
    def disk_num(self):
        """Gets the disk_num of this Label.  # noqa: E501


        :return: The disk_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._disk_num

    @disk_num.setter
    def disk_num(self, disk_num):
        """Sets the disk_num of this Label.


        :param disk_num: The disk_num of this Label.  # noqa: E501
        :type disk_num: int
        """

        self._disk_num = disk_num

    @property
    def disks(self):
        """Gets the disks of this Label.  # noqa: E501


        :return: The disks of this Label.  # noqa: E501
        :rtype: list[NestedDisk]
        """
        return self._disks

    @disks.setter
    def disks(self, disks):
        """Sets the disks of this Label.


        :param disks: The disks of this Label.  # noqa: E501
        :type disks: list[NestedDisk]
        """

        self._disks = disks

    @property
    def elf_image_num(self):
        """Gets the elf_image_num of this Label.  # noqa: E501


        :return: The elf_image_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._elf_image_num

    @elf_image_num.setter
    def elf_image_num(self, elf_image_num):
        """Sets the elf_image_num of this Label.


        :param elf_image_num: The elf_image_num of this Label.  # noqa: E501
        :type elf_image_num: int
        """

        self._elf_image_num = elf_image_num

    @property
    def elf_images(self):
        """Gets the elf_images of this Label.  # noqa: E501


        :return: The elf_images of this Label.  # noqa: E501
        :rtype: list[NestedElfImage]
        """
        return self._elf_images

    @elf_images.setter
    def elf_images(self, elf_images):
        """Sets the elf_images of this Label.


        :param elf_images: The elf_images of this Label.  # noqa: E501
        :type elf_images: list[NestedElfImage]
        """

        self._elf_images = elf_images

    @property
    def gpu_device_num(self):
        """Gets the gpu_device_num of this Label.  # noqa: E501


        :return: The gpu_device_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._gpu_device_num

    @gpu_device_num.setter
    def gpu_device_num(self, gpu_device_num):
        """Sets the gpu_device_num of this Label.


        :param gpu_device_num: The gpu_device_num of this Label.  # noqa: E501
        :type gpu_device_num: int
        """

        self._gpu_device_num = gpu_device_num

    @property
    def gpu_devices(self):
        """Gets the gpu_devices of this Label.  # noqa: E501


        :return: The gpu_devices of this Label.  # noqa: E501
        :rtype: list[NestedGpuDevice]
        """
        return self._gpu_devices

    @gpu_devices.setter
    def gpu_devices(self, gpu_devices):
        """Sets the gpu_devices of this Label.


        :param gpu_devices: The gpu_devices of this Label.  # noqa: E501
        :type gpu_devices: list[NestedGpuDevice]
        """

        self._gpu_devices = gpu_devices

    @property
    def host_num(self):
        """Gets the host_num of this Label.  # noqa: E501


        :return: The host_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._host_num

    @host_num.setter
    def host_num(self, host_num):
        """Sets the host_num of this Label.


        :param host_num: The host_num of this Label.  # noqa: E501
        :type host_num: int
        """

        self._host_num = host_num

    @property
    def hosts(self):
        """Gets the hosts of this Label.  # noqa: E501


        :return: The hosts of this Label.  # noqa: E501
        :rtype: list[NestedHost]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this Label.


        :param hosts: The hosts of this Label.  # noqa: E501
        :type hosts: list[NestedHost]
        """

        self._hosts = hosts

    @property
    def id(self):
        """Gets the id of this Label.  # noqa: E501


        :return: The id of this Label.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Label.


        :param id: The id of this Label.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def iscsi_lun_num(self):
        """Gets the iscsi_lun_num of this Label.  # noqa: E501


        :return: The iscsi_lun_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_lun_num

    @iscsi_lun_num.setter
    def iscsi_lun_num(self, iscsi_lun_num):
        """Sets the iscsi_lun_num of this Label.


        :param iscsi_lun_num: The iscsi_lun_num of this Label.  # noqa: E501
        :type iscsi_lun_num: int
        """

        self._iscsi_lun_num = iscsi_lun_num

    @property
    def iscsi_lun_snapshot_num(self):
        """Gets the iscsi_lun_snapshot_num of this Label.  # noqa: E501


        :return: The iscsi_lun_snapshot_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_lun_snapshot_num

    @iscsi_lun_snapshot_num.setter
    def iscsi_lun_snapshot_num(self, iscsi_lun_snapshot_num):
        """Sets the iscsi_lun_snapshot_num of this Label.


        :param iscsi_lun_snapshot_num: The iscsi_lun_snapshot_num of this Label.  # noqa: E501
        :type iscsi_lun_snapshot_num: int
        """

        self._iscsi_lun_snapshot_num = iscsi_lun_snapshot_num

    @property
    def iscsi_lun_snapshots(self):
        """Gets the iscsi_lun_snapshots of this Label.  # noqa: E501


        :return: The iscsi_lun_snapshots of this Label.  # noqa: E501
        :rtype: list[NestedIscsiLunSnapshot]
        """
        return self._iscsi_lun_snapshots

    @iscsi_lun_snapshots.setter
    def iscsi_lun_snapshots(self, iscsi_lun_snapshots):
        """Sets the iscsi_lun_snapshots of this Label.


        :param iscsi_lun_snapshots: The iscsi_lun_snapshots of this Label.  # noqa: E501
        :type iscsi_lun_snapshots: list[NestedIscsiLunSnapshot]
        """

        self._iscsi_lun_snapshots = iscsi_lun_snapshots

    @property
    def iscsi_luns(self):
        """Gets the iscsi_luns of this Label.  # noqa: E501


        :return: The iscsi_luns of this Label.  # noqa: E501
        :rtype: list[NestedIscsiLun]
        """
        return self._iscsi_luns

    @iscsi_luns.setter
    def iscsi_luns(self, iscsi_luns):
        """Sets the iscsi_luns of this Label.


        :param iscsi_luns: The iscsi_luns of this Label.  # noqa: E501
        :type iscsi_luns: list[NestedIscsiLun]
        """

        self._iscsi_luns = iscsi_luns

    @property
    def iscsi_target_num(self):
        """Gets the iscsi_target_num of this Label.  # noqa: E501


        :return: The iscsi_target_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_target_num

    @iscsi_target_num.setter
    def iscsi_target_num(self, iscsi_target_num):
        """Sets the iscsi_target_num of this Label.


        :param iscsi_target_num: The iscsi_target_num of this Label.  # noqa: E501
        :type iscsi_target_num: int
        """

        self._iscsi_target_num = iscsi_target_num

    @property
    def iscsi_targets(self):
        """Gets the iscsi_targets of this Label.  # noqa: E501


        :return: The iscsi_targets of this Label.  # noqa: E501
        :rtype: list[NestedIscsiTarget]
        """
        return self._iscsi_targets

    @iscsi_targets.setter
    def iscsi_targets(self, iscsi_targets):
        """Sets the iscsi_targets of this Label.


        :param iscsi_targets: The iscsi_targets of this Label.  # noqa: E501
        :type iscsi_targets: list[NestedIscsiTarget]
        """

        self._iscsi_targets = iscsi_targets

    @property
    def isolation_policies(self):
        """Gets the isolation_policies of this Label.  # noqa: E501


        :return: The isolation_policies of this Label.  # noqa: E501
        :rtype: list[NestedIsolationPolicy]
        """
        return self._isolation_policies

    @isolation_policies.setter
    def isolation_policies(self, isolation_policies):
        """Sets the isolation_policies of this Label.


        :param isolation_policies: The isolation_policies of this Label.  # noqa: E501
        :type isolation_policies: list[NestedIsolationPolicy]
        """

        self._isolation_policies = isolation_policies

    @property
    def isolation_policy_num(self):
        """Gets the isolation_policy_num of this Label.  # noqa: E501


        :return: The isolation_policy_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._isolation_policy_num

    @isolation_policy_num.setter
    def isolation_policy_num(self, isolation_policy_num):
        """Sets the isolation_policy_num of this Label.


        :param isolation_policy_num: The isolation_policy_num of this Label.  # noqa: E501
        :type isolation_policy_num: int
        """

        self._isolation_policy_num = isolation_policy_num

    @property
    def key(self):
        """Gets the key of this Label.  # noqa: E501


        :return: The key of this Label.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Label.


        :param key: The key of this Label.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    @property
    def namespace_group_num(self):
        """Gets the namespace_group_num of this Label.  # noqa: E501


        :return: The namespace_group_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._namespace_group_num

    @namespace_group_num.setter
    def namespace_group_num(self, namespace_group_num):
        """Sets the namespace_group_num of this Label.


        :param namespace_group_num: The namespace_group_num of this Label.  # noqa: E501
        :type namespace_group_num: int
        """

        self._namespace_group_num = namespace_group_num

    @property
    def namespace_groups(self):
        """Gets the namespace_groups of this Label.  # noqa: E501


        :return: The namespace_groups of this Label.  # noqa: E501
        :rtype: list[NestedNamespaceGroup]
        """
        return self._namespace_groups

    @namespace_groups.setter
    def namespace_groups(self, namespace_groups):
        """Sets the namespace_groups of this Label.


        :param namespace_groups: The namespace_groups of this Label.  # noqa: E501
        :type namespace_groups: list[NestedNamespaceGroup]
        """

        self._namespace_groups = namespace_groups

    @property
    def nfs_export_num(self):
        """Gets the nfs_export_num of this Label.  # noqa: E501


        :return: The nfs_export_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nfs_export_num

    @nfs_export_num.setter
    def nfs_export_num(self, nfs_export_num):
        """Sets the nfs_export_num of this Label.


        :param nfs_export_num: The nfs_export_num of this Label.  # noqa: E501
        :type nfs_export_num: int
        """

        self._nfs_export_num = nfs_export_num

    @property
    def nfs_exports(self):
        """Gets the nfs_exports of this Label.  # noqa: E501


        :return: The nfs_exports of this Label.  # noqa: E501
        :rtype: list[NestedNfsExport]
        """
        return self._nfs_exports

    @nfs_exports.setter
    def nfs_exports(self, nfs_exports):
        """Sets the nfs_exports of this Label.


        :param nfs_exports: The nfs_exports of this Label.  # noqa: E501
        :type nfs_exports: list[NestedNfsExport]
        """

        self._nfs_exports = nfs_exports

    @property
    def nfs_inode_num(self):
        """Gets the nfs_inode_num of this Label.  # noqa: E501


        :return: The nfs_inode_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nfs_inode_num

    @nfs_inode_num.setter
    def nfs_inode_num(self, nfs_inode_num):
        """Sets the nfs_inode_num of this Label.


        :param nfs_inode_num: The nfs_inode_num of this Label.  # noqa: E501
        :type nfs_inode_num: int
        """

        self._nfs_inode_num = nfs_inode_num

    @property
    def nfs_inodes(self):
        """Gets the nfs_inodes of this Label.  # noqa: E501


        :return: The nfs_inodes of this Label.  # noqa: E501
        :rtype: list[NestedNfsInode]
        """
        return self._nfs_inodes

    @nfs_inodes.setter
    def nfs_inodes(self, nfs_inodes):
        """Sets the nfs_inodes of this Label.


        :param nfs_inodes: The nfs_inodes of this Label.  # noqa: E501
        :type nfs_inodes: list[NestedNfsInode]
        """

        self._nfs_inodes = nfs_inodes

    @property
    def nic_num(self):
        """Gets the nic_num of this Label.  # noqa: E501


        :return: The nic_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nic_num

    @nic_num.setter
    def nic_num(self, nic_num):
        """Sets the nic_num of this Label.


        :param nic_num: The nic_num of this Label.  # noqa: E501
        :type nic_num: int
        """

        self._nic_num = nic_num

    @property
    def nics(self):
        """Gets the nics of this Label.  # noqa: E501


        :return: The nics of this Label.  # noqa: E501
        :rtype: list[NestedNic]
        """
        return self._nics

    @nics.setter
    def nics(self, nics):
        """Sets the nics of this Label.


        :param nics: The nics of this Label.  # noqa: E501
        :type nics: list[NestedNic]
        """

        self._nics = nics

    @property
    def nvmf_namespace_num(self):
        """Gets the nvmf_namespace_num of this Label.  # noqa: E501


        :return: The nvmf_namespace_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nvmf_namespace_num

    @nvmf_namespace_num.setter
    def nvmf_namespace_num(self, nvmf_namespace_num):
        """Sets the nvmf_namespace_num of this Label.


        :param nvmf_namespace_num: The nvmf_namespace_num of this Label.  # noqa: E501
        :type nvmf_namespace_num: int
        """

        self._nvmf_namespace_num = nvmf_namespace_num

    @property
    def nvmf_namespace_snapshot_num(self):
        """Gets the nvmf_namespace_snapshot_num of this Label.  # noqa: E501


        :return: The nvmf_namespace_snapshot_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nvmf_namespace_snapshot_num

    @nvmf_namespace_snapshot_num.setter
    def nvmf_namespace_snapshot_num(self, nvmf_namespace_snapshot_num):
        """Sets the nvmf_namespace_snapshot_num of this Label.


        :param nvmf_namespace_snapshot_num: The nvmf_namespace_snapshot_num of this Label.  # noqa: E501
        :type nvmf_namespace_snapshot_num: int
        """

        self._nvmf_namespace_snapshot_num = nvmf_namespace_snapshot_num

    @property
    def nvmf_namespace_snapshots(self):
        """Gets the nvmf_namespace_snapshots of this Label.  # noqa: E501


        :return: The nvmf_namespace_snapshots of this Label.  # noqa: E501
        :rtype: list[NestedNvmfNamespaceSnapshot]
        """
        return self._nvmf_namespace_snapshots

    @nvmf_namespace_snapshots.setter
    def nvmf_namespace_snapshots(self, nvmf_namespace_snapshots):
        """Sets the nvmf_namespace_snapshots of this Label.


        :param nvmf_namespace_snapshots: The nvmf_namespace_snapshots of this Label.  # noqa: E501
        :type nvmf_namespace_snapshots: list[NestedNvmfNamespaceSnapshot]
        """

        self._nvmf_namespace_snapshots = nvmf_namespace_snapshots

    @property
    def nvmf_namespaces(self):
        """Gets the nvmf_namespaces of this Label.  # noqa: E501


        :return: The nvmf_namespaces of this Label.  # noqa: E501
        :rtype: list[NestedNvmfNamespace]
        """
        return self._nvmf_namespaces

    @nvmf_namespaces.setter
    def nvmf_namespaces(self, nvmf_namespaces):
        """Sets the nvmf_namespaces of this Label.


        :param nvmf_namespaces: The nvmf_namespaces of this Label.  # noqa: E501
        :type nvmf_namespaces: list[NestedNvmfNamespace]
        """

        self._nvmf_namespaces = nvmf_namespaces

    @property
    def nvmf_subsystem_num(self):
        """Gets the nvmf_subsystem_num of this Label.  # noqa: E501


        :return: The nvmf_subsystem_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._nvmf_subsystem_num

    @nvmf_subsystem_num.setter
    def nvmf_subsystem_num(self, nvmf_subsystem_num):
        """Sets the nvmf_subsystem_num of this Label.


        :param nvmf_subsystem_num: The nvmf_subsystem_num of this Label.  # noqa: E501
        :type nvmf_subsystem_num: int
        """

        self._nvmf_subsystem_num = nvmf_subsystem_num

    @property
    def nvmf_subsystems(self):
        """Gets the nvmf_subsystems of this Label.  # noqa: E501


        :return: The nvmf_subsystems of this Label.  # noqa: E501
        :rtype: list[NestedNvmfSubsystem]
        """
        return self._nvmf_subsystems

    @nvmf_subsystems.setter
    def nvmf_subsystems(self, nvmf_subsystems):
        """Sets the nvmf_subsystems of this Label.


        :param nvmf_subsystems: The nvmf_subsystems of this Label.  # noqa: E501
        :type nvmf_subsystems: list[NestedNvmfSubsystem]
        """

        self._nvmf_subsystems = nvmf_subsystems

    @property
    def security_policies(self):
        """Gets the security_policies of this Label.  # noqa: E501


        :return: The security_policies of this Label.  # noqa: E501
        :rtype: list[NestedSecurityPolicy]
        """
        return self._security_policies

    @security_policies.setter
    def security_policies(self, security_policies):
        """Sets the security_policies of this Label.


        :param security_policies: The security_policies of this Label.  # noqa: E501
        :type security_policies: list[NestedSecurityPolicy]
        """

        self._security_policies = security_policies

    @property
    def security_policy_num(self):
        """Gets the security_policy_num of this Label.  # noqa: E501


        :return: The security_policy_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._security_policy_num

    @security_policy_num.setter
    def security_policy_num(self, security_policy_num):
        """Sets the security_policy_num of this Label.


        :param security_policy_num: The security_policy_num of this Label.  # noqa: E501
        :type security_policy_num: int
        """

        self._security_policy_num = security_policy_num

    @property
    def system_vlan_num(self):
        """Gets the system_vlan_num of this Label.  # noqa: E501


        :return: The system_vlan_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._system_vlan_num

    @system_vlan_num.setter
    def system_vlan_num(self, system_vlan_num):
        """Sets the system_vlan_num of this Label.


        :param system_vlan_num: The system_vlan_num of this Label.  # noqa: E501
        :type system_vlan_num: int
        """

        self._system_vlan_num = system_vlan_num

    @property
    def total_num(self):
        """Gets the total_num of this Label.  # noqa: E501


        :return: The total_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._total_num

    @total_num.setter
    def total_num(self, total_num):
        """Sets the total_num of this Label.


        :param total_num: The total_num of this Label.  # noqa: E501
        :type total_num: int
        """

        self._total_num = total_num

    @property
    def value(self):
        """Gets the value of this Label.  # noqa: E501


        :return: The value of this Label.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this Label.


        :param value: The value of this Label.  # noqa: E501
        :type value: str
        """

        self._value = value

    @property
    def vds_num(self):
        """Gets the vds_num of this Label.  # noqa: E501


        :return: The vds_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vds_num

    @vds_num.setter
    def vds_num(self, vds_num):
        """Sets the vds_num of this Label.


        :param vds_num: The vds_num of this Label.  # noqa: E501
        :type vds_num: int
        """

        self._vds_num = vds_num

    @property
    def vdses(self):
        """Gets the vdses of this Label.  # noqa: E501


        :return: The vdses of this Label.  # noqa: E501
        :rtype: list[NestedVds]
        """
        return self._vdses

    @vdses.setter
    def vdses(self, vdses):
        """Sets the vdses of this Label.


        :param vdses: The vdses of this Label.  # noqa: E501
        :type vdses: list[NestedVds]
        """

        self._vdses = vdses

    @property
    def vlans(self):
        """Gets the vlans of this Label.  # noqa: E501


        :return: The vlans of this Label.  # noqa: E501
        :rtype: list[NestedVlan]
        """
        return self._vlans

    @vlans.setter
    def vlans(self, vlans):
        """Sets the vlans of this Label.


        :param vlans: The vlans of this Label.  # noqa: E501
        :type vlans: list[NestedVlan]
        """

        self._vlans = vlans

    @property
    def vm_num(self):
        """Gets the vm_num of this Label.  # noqa: E501


        :return: The vm_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this Label.


        :param vm_num: The vm_num of this Label.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vm_snapshot_num(self):
        """Gets the vm_snapshot_num of this Label.  # noqa: E501


        :return: The vm_snapshot_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_snapshot_num

    @vm_snapshot_num.setter
    def vm_snapshot_num(self, vm_snapshot_num):
        """Sets the vm_snapshot_num of this Label.


        :param vm_snapshot_num: The vm_snapshot_num of this Label.  # noqa: E501
        :type vm_snapshot_num: int
        """

        self._vm_snapshot_num = vm_snapshot_num

    @property
    def vm_snapshots(self):
        """Gets the vm_snapshots of this Label.  # noqa: E501


        :return: The vm_snapshots of this Label.  # noqa: E501
        :rtype: list[NestedVmSnapshot]
        """
        return self._vm_snapshots

    @vm_snapshots.setter
    def vm_snapshots(self, vm_snapshots):
        """Sets the vm_snapshots of this Label.


        :param vm_snapshots: The vm_snapshots of this Label.  # noqa: E501
        :type vm_snapshots: list[NestedVmSnapshot]
        """

        self._vm_snapshots = vm_snapshots

    @property
    def vm_template_num(self):
        """Gets the vm_template_num of this Label.  # noqa: E501


        :return: The vm_template_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_template_num

    @vm_template_num.setter
    def vm_template_num(self, vm_template_num):
        """Sets the vm_template_num of this Label.


        :param vm_template_num: The vm_template_num of this Label.  # noqa: E501
        :type vm_template_num: int
        """

        self._vm_template_num = vm_template_num

    @property
    def vm_templates(self):
        """Gets the vm_templates of this Label.  # noqa: E501


        :return: The vm_templates of this Label.  # noqa: E501
        :rtype: list[NestedVmTemplate]
        """
        return self._vm_templates

    @vm_templates.setter
    def vm_templates(self, vm_templates):
        """Sets the vm_templates of this Label.


        :param vm_templates: The vm_templates of this Label.  # noqa: E501
        :type vm_templates: list[NestedVmTemplate]
        """

        self._vm_templates = vm_templates

    @property
    def vm_vlan_num(self):
        """Gets the vm_vlan_num of this Label.  # noqa: E501


        :return: The vm_vlan_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_vlan_num

    @vm_vlan_num.setter
    def vm_vlan_num(self, vm_vlan_num):
        """Sets the vm_vlan_num of this Label.


        :param vm_vlan_num: The vm_vlan_num of this Label.  # noqa: E501
        :type vm_vlan_num: int
        """

        self._vm_vlan_num = vm_vlan_num

    @property
    def vm_volume_num(self):
        """Gets the vm_volume_num of this Label.  # noqa: E501


        :return: The vm_volume_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_volume_num

    @vm_volume_num.setter
    def vm_volume_num(self, vm_volume_num):
        """Sets the vm_volume_num of this Label.


        :param vm_volume_num: The vm_volume_num of this Label.  # noqa: E501
        :type vm_volume_num: int
        """

        self._vm_volume_num = vm_volume_num

    @property
    def vm_volume_snapshot_num(self):
        """Gets the vm_volume_snapshot_num of this Label.  # noqa: E501


        :return: The vm_volume_snapshot_num of this Label.  # noqa: E501
        :rtype: int
        """
        return self._vm_volume_snapshot_num

    @vm_volume_snapshot_num.setter
    def vm_volume_snapshot_num(self, vm_volume_snapshot_num):
        """Sets the vm_volume_snapshot_num of this Label.


        :param vm_volume_snapshot_num: The vm_volume_snapshot_num of this Label.  # noqa: E501
        :type vm_volume_snapshot_num: int
        """

        self._vm_volume_snapshot_num = vm_volume_snapshot_num

    @property
    def vm_volume_snapshots(self):
        """Gets the vm_volume_snapshots of this Label.  # noqa: E501


        :return: The vm_volume_snapshots of this Label.  # noqa: E501
        :rtype: list[NestedVmVolumeSnapshot]
        """
        return self._vm_volume_snapshots

    @vm_volume_snapshots.setter
    def vm_volume_snapshots(self, vm_volume_snapshots):
        """Sets the vm_volume_snapshots of this Label.


        :param vm_volume_snapshots: The vm_volume_snapshots of this Label.  # noqa: E501
        :type vm_volume_snapshots: list[NestedVmVolumeSnapshot]
        """

        self._vm_volume_snapshots = vm_volume_snapshots

    @property
    def vm_volumes(self):
        """Gets the vm_volumes of this Label.  # noqa: E501


        :return: The vm_volumes of this Label.  # noqa: E501
        :rtype: list[NestedVmVolume]
        """
        return self._vm_volumes

    @vm_volumes.setter
    def vm_volumes(self, vm_volumes):
        """Sets the vm_volumes of this Label.


        :param vm_volumes: The vm_volumes of this Label.  # noqa: E501
        :type vm_volumes: list[NestedVmVolume]
        """

        self._vm_volumes = vm_volumes

    @property
    def vms(self):
        """Gets the vms of this Label.  # noqa: E501


        :return: The vms of this Label.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this Label.


        :param vms: The vms of this Label.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Label):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Label):
            return True

        return self.to_dict() != other.to_dict()
