# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class License(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'expire_date': 'str',
        'id': 'str',
        'license_serial': 'str',
        'maintenance_end_date': 'str',
        'maintenance_start_date': 'str',
        'max_chunk_num': 'int',
        'max_cluster_num': 'int',
        'sign_date': 'str',
        'software_edition': 'SoftwareEdition',
        'type': 'LicenseType'
    }

    attribute_map = {
        'expire_date': 'expire_date',
        'id': 'id',
        'license_serial': 'license_serial',
        'maintenance_end_date': 'maintenance_end_date',
        'maintenance_start_date': 'maintenance_start_date',
        'max_chunk_num': 'max_chunk_num',
        'max_cluster_num': 'max_cluster_num',
        'sign_date': 'sign_date',
        'software_edition': 'software_edition',
        'type': 'type'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """License - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._expire_date = None
        self._id = None
        self._license_serial = None
        self._maintenance_end_date = None
        self._maintenance_start_date = None
        self._max_chunk_num = None
        self._max_cluster_num = None
        self._sign_date = None
        self._software_edition = None
        self._type = None
        self.discriminator = None

        if "expire_date" in kwargs:
            self.expire_date = kwargs["expire_date"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "license_serial" in kwargs:
            self.license_serial = kwargs["license_serial"]
        self.maintenance_end_date = kwargs.get("maintenance_end_date", None)
        self.maintenance_start_date = kwargs.get("maintenance_start_date", None)
        if "max_chunk_num" in kwargs:
            self.max_chunk_num = kwargs["max_chunk_num"]
        if "max_cluster_num" in kwargs:
            self.max_cluster_num = kwargs["max_cluster_num"]
        if "sign_date" in kwargs:
            self.sign_date = kwargs["sign_date"]
        if "software_edition" in kwargs:
            self.software_edition = kwargs["software_edition"]
        if "type" in kwargs:
            self.type = kwargs["type"]

    @property
    def expire_date(self):
        """Gets the expire_date of this License.  # noqa: E501


        :return: The expire_date of this License.  # noqa: E501
        :rtype: str
        """
        return self._expire_date

    @expire_date.setter
    def expire_date(self, expire_date):
        """Sets the expire_date of this License.


        :param expire_date: The expire_date of this License.  # noqa: E501
        :type expire_date: str
        """
        if self.local_vars_configuration.client_side_validation and expire_date is None:  # noqa: E501
            raise ValueError("Invalid value for `expire_date`, must not be `None`")  # noqa: E501

        self._expire_date = expire_date

    @property
    def id(self):
        """Gets the id of this License.  # noqa: E501


        :return: The id of this License.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this License.


        :param id: The id of this License.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def license_serial(self):
        """Gets the license_serial of this License.  # noqa: E501


        :return: The license_serial of this License.  # noqa: E501
        :rtype: str
        """
        return self._license_serial

    @license_serial.setter
    def license_serial(self, license_serial):
        """Sets the license_serial of this License.


        :param license_serial: The license_serial of this License.  # noqa: E501
        :type license_serial: str
        """
        if self.local_vars_configuration.client_side_validation and license_serial is None:  # noqa: E501
            raise ValueError("Invalid value for `license_serial`, must not be `None`")  # noqa: E501

        self._license_serial = license_serial

    @property
    def maintenance_end_date(self):
        """Gets the maintenance_end_date of this License.  # noqa: E501


        :return: The maintenance_end_date of this License.  # noqa: E501
        :rtype: str
        """
        return self._maintenance_end_date

    @maintenance_end_date.setter
    def maintenance_end_date(self, maintenance_end_date):
        """Sets the maintenance_end_date of this License.


        :param maintenance_end_date: The maintenance_end_date of this License.  # noqa: E501
        :type maintenance_end_date: str
        """

        self._maintenance_end_date = maintenance_end_date

    @property
    def maintenance_start_date(self):
        """Gets the maintenance_start_date of this License.  # noqa: E501


        :return: The maintenance_start_date of this License.  # noqa: E501
        :rtype: str
        """
        return self._maintenance_start_date

    @maintenance_start_date.setter
    def maintenance_start_date(self, maintenance_start_date):
        """Sets the maintenance_start_date of this License.


        :param maintenance_start_date: The maintenance_start_date of this License.  # noqa: E501
        :type maintenance_start_date: str
        """

        self._maintenance_start_date = maintenance_start_date

    @property
    def max_chunk_num(self):
        """Gets the max_chunk_num of this License.  # noqa: E501


        :return: The max_chunk_num of this License.  # noqa: E501
        :rtype: int
        """
        return self._max_chunk_num

    @max_chunk_num.setter
    def max_chunk_num(self, max_chunk_num):
        """Sets the max_chunk_num of this License.


        :param max_chunk_num: The max_chunk_num of this License.  # noqa: E501
        :type max_chunk_num: int
        """
        if self.local_vars_configuration.client_side_validation and max_chunk_num is None:  # noqa: E501
            raise ValueError("Invalid value for `max_chunk_num`, must not be `None`")  # noqa: E501

        self._max_chunk_num = max_chunk_num

    @property
    def max_cluster_num(self):
        """Gets the max_cluster_num of this License.  # noqa: E501


        :return: The max_cluster_num of this License.  # noqa: E501
        :rtype: int
        """
        return self._max_cluster_num

    @max_cluster_num.setter
    def max_cluster_num(self, max_cluster_num):
        """Sets the max_cluster_num of this License.


        :param max_cluster_num: The max_cluster_num of this License.  # noqa: E501
        :type max_cluster_num: int
        """
        if self.local_vars_configuration.client_side_validation and max_cluster_num is None:  # noqa: E501
            raise ValueError("Invalid value for `max_cluster_num`, must not be `None`")  # noqa: E501

        self._max_cluster_num = max_cluster_num

    @property
    def sign_date(self):
        """Gets the sign_date of this License.  # noqa: E501


        :return: The sign_date of this License.  # noqa: E501
        :rtype: str
        """
        return self._sign_date

    @sign_date.setter
    def sign_date(self, sign_date):
        """Sets the sign_date of this License.


        :param sign_date: The sign_date of this License.  # noqa: E501
        :type sign_date: str
        """
        if self.local_vars_configuration.client_side_validation and sign_date is None:  # noqa: E501
            raise ValueError("Invalid value for `sign_date`, must not be `None`")  # noqa: E501

        self._sign_date = sign_date

    @property
    def software_edition(self):
        """Gets the software_edition of this License.  # noqa: E501


        :return: The software_edition of this License.  # noqa: E501
        :rtype: SoftwareEdition
        """
        return self._software_edition

    @software_edition.setter
    def software_edition(self, software_edition):
        """Sets the software_edition of this License.


        :param software_edition: The software_edition of this License.  # noqa: E501
        :type software_edition: SoftwareEdition
        """
        if self.local_vars_configuration.client_side_validation and software_edition is None:  # noqa: E501
            raise ValueError("Invalid value for `software_edition`, must not be `None`")  # noqa: E501

        self._software_edition = software_edition

    @property
    def type(self):
        """Gets the type of this License.  # noqa: E501


        :return: The type of this License.  # noqa: E501
        :rtype: LicenseType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this License.


        :param type: The type of this License.  # noqa: E501
        :type type: LicenseType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, License):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, License):
            return True

        return self.to_dict() != other.to_dict()
