# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class LoadBalancerServiceWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[LoadBalancerServiceWhereInput]',
        '_not': 'list[LoadBalancerServiceWhereInput]',
        '_or': 'list[LoadBalancerServiceWhereInput]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'everoute_cluster': 'EverouteClusterWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'phase': 'EverouteClusterPhase',
        'phase_in': 'list[EverouteClusterPhase]',
        'phase_not': 'EverouteClusterPhase',
        'phase_not_in': 'list[EverouteClusterPhase]',
        'vm_instances_every': 'VmWhereInput',
        'vm_instances_none': 'VmWhereInput',
        'vm_instances_some': 'VmWhereInput',
        'vnet_bonds_every': 'VnetBondWhereInput',
        'vnet_bonds_none': 'VnetBondWhereInput',
        'vnet_bonds_some': 'VnetBondWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'everoute_cluster': 'everoute_cluster',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'vm_instances_every': 'vm_instances_every',
        'vm_instances_none': 'vm_instances_none',
        'vm_instances_some': 'vm_instances_some',
        'vnet_bonds_every': 'vnet_bonds_every',
        'vnet_bonds_none': 'vnet_bonds_none',
        'vnet_bonds_some': 'vnet_bonds_some'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """LoadBalancerServiceWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._everoute_cluster = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._vm_instances_every = None
        self._vm_instances_none = None
        self._vm_instances_some = None
        self._vnet_bonds_every = None
        self._vnet_bonds_none = None
        self._vnet_bonds_some = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.everoute_cluster = kwargs.get("everoute_cluster", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.vm_instances_every = kwargs.get("vm_instances_every", None)
        self.vm_instances_none = kwargs.get("vm_instances_none", None)
        self.vm_instances_some = kwargs.get("vm_instances_some", None)
        self.vnet_bonds_every = kwargs.get("vnet_bonds_every", None)
        self.vnet_bonds_none = kwargs.get("vnet_bonds_none", None)
        self.vnet_bonds_some = kwargs.get("vnet_bonds_some", None)

    @property
    def _and(self):
        """Gets the _and of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The _and of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[LoadBalancerServiceWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this LoadBalancerServiceWhereInput.


        :param _and: The _and of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type _and: list[LoadBalancerServiceWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The _not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[LoadBalancerServiceWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this LoadBalancerServiceWhereInput.


        :param _not: The _not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type _not: list[LoadBalancerServiceWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The _or of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[LoadBalancerServiceWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this LoadBalancerServiceWhereInput.


        :param _or: The _or of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type _or: list[LoadBalancerServiceWhereInput]
        """

        self.__or = _or

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The entity_async_status of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this LoadBalancerServiceWhereInput.


        :param entity_async_status: The entity_async_status of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this LoadBalancerServiceWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this LoadBalancerServiceWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this LoadBalancerServiceWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The everoute_cluster of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterWhereInput
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this LoadBalancerServiceWhereInput.


        :param everoute_cluster: The everoute_cluster of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type everoute_cluster: EverouteClusterWhereInput
        """

        self._everoute_cluster = everoute_cluster

    @property
    def id(self):
        """Gets the id of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LoadBalancerServiceWhereInput.


        :param id: The id of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_contains of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this LoadBalancerServiceWhereInput.


        :param id_contains: The id_contains of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this LoadBalancerServiceWhereInput.


        :param id_ends_with: The id_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_gt of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this LoadBalancerServiceWhereInput.


        :param id_gt: The id_gt of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_gte of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this LoadBalancerServiceWhereInput.


        :param id_gte: The id_gte of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this LoadBalancerServiceWhereInput.


        :param id_in: The id_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_lt of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this LoadBalancerServiceWhereInput.


        :param id_lt: The id_lt of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_lte of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this LoadBalancerServiceWhereInput.


        :param id_lte: The id_lte of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this LoadBalancerServiceWhereInput.


        :param id_not: The id_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_not_contains of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this LoadBalancerServiceWhereInput.


        :param id_not_contains: The id_not_contains of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this LoadBalancerServiceWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this LoadBalancerServiceWhereInput.


        :param id_not_in: The id_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this LoadBalancerServiceWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The id_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this LoadBalancerServiceWhereInput.


        :param id_starts_with: The id_starts_with of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def phase(self):
        """Gets the phase of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The phase of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this LoadBalancerServiceWhereInput.


        :param phase: The phase of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type phase: EverouteClusterPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The phase_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this LoadBalancerServiceWhereInput.


        :param phase_in: The phase_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type phase_in: list[EverouteClusterPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The phase_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this LoadBalancerServiceWhereInput.


        :param phase_not: The phase_not of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type phase_not: EverouteClusterPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The phase_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this LoadBalancerServiceWhereInput.


        :param phase_not_in: The phase_not_in of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type phase_not_in: list[EverouteClusterPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def vm_instances_every(self):
        """Gets the vm_instances_every of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vm_instances_every of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm_instances_every

    @vm_instances_every.setter
    def vm_instances_every(self, vm_instances_every):
        """Sets the vm_instances_every of this LoadBalancerServiceWhereInput.


        :param vm_instances_every: The vm_instances_every of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vm_instances_every: VmWhereInput
        """

        self._vm_instances_every = vm_instances_every

    @property
    def vm_instances_none(self):
        """Gets the vm_instances_none of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vm_instances_none of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm_instances_none

    @vm_instances_none.setter
    def vm_instances_none(self, vm_instances_none):
        """Sets the vm_instances_none of this LoadBalancerServiceWhereInput.


        :param vm_instances_none: The vm_instances_none of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vm_instances_none: VmWhereInput
        """

        self._vm_instances_none = vm_instances_none

    @property
    def vm_instances_some(self):
        """Gets the vm_instances_some of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vm_instances_some of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm_instances_some

    @vm_instances_some.setter
    def vm_instances_some(self, vm_instances_some):
        """Sets the vm_instances_some of this LoadBalancerServiceWhereInput.


        :param vm_instances_some: The vm_instances_some of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vm_instances_some: VmWhereInput
        """

        self._vm_instances_some = vm_instances_some

    @property
    def vnet_bonds_every(self):
        """Gets the vnet_bonds_every of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vnet_bonds_every of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VnetBondWhereInput
        """
        return self._vnet_bonds_every

    @vnet_bonds_every.setter
    def vnet_bonds_every(self, vnet_bonds_every):
        """Sets the vnet_bonds_every of this LoadBalancerServiceWhereInput.


        :param vnet_bonds_every: The vnet_bonds_every of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vnet_bonds_every: VnetBondWhereInput
        """

        self._vnet_bonds_every = vnet_bonds_every

    @property
    def vnet_bonds_none(self):
        """Gets the vnet_bonds_none of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vnet_bonds_none of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VnetBondWhereInput
        """
        return self._vnet_bonds_none

    @vnet_bonds_none.setter
    def vnet_bonds_none(self, vnet_bonds_none):
        """Sets the vnet_bonds_none of this LoadBalancerServiceWhereInput.


        :param vnet_bonds_none: The vnet_bonds_none of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vnet_bonds_none: VnetBondWhereInput
        """

        self._vnet_bonds_none = vnet_bonds_none

    @property
    def vnet_bonds_some(self):
        """Gets the vnet_bonds_some of this LoadBalancerServiceWhereInput.  # noqa: E501


        :return: The vnet_bonds_some of this LoadBalancerServiceWhereInput.  # noqa: E501
        :rtype: VnetBondWhereInput
        """
        return self._vnet_bonds_some

    @vnet_bonds_some.setter
    def vnet_bonds_some(self, vnet_bonds_some):
        """Sets the vnet_bonds_some of this LoadBalancerServiceWhereInput.


        :param vnet_bonds_some: The vnet_bonds_some of this LoadBalancerServiceWhereInput.  # noqa: E501
        :type vnet_bonds_some: VnetBondWhereInput
        """

        self._vnet_bonds_some = vnet_bonds_some

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoadBalancerServiceWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LoadBalancerServiceWhereInput):
            return True

        return self.to_dict() != other.to_dict()
