# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class LoginInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'source': 'UserSource',
        'password': 'str',
        'mfa_type': 'MfaType',
        'auth_config_id': 'str'
    }

    attribute_map = {
        'username': 'username',
        'source': 'source',
        'password': 'password',
        'mfa_type': 'mfa_type',
        'auth_config_id': 'auth_config_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """LoginInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._username = None
        self._source = None
        self._password = None
        self._mfa_type = None
        self._auth_config_id = None
        self.discriminator = None

        if "username" in kwargs:
            self.username = kwargs["username"]
        self.source = kwargs.get("source", None)
        if "password" in kwargs:
            self.password = kwargs["password"]
        self.mfa_type = kwargs.get("mfa_type", None)
        self.auth_config_id = kwargs.get("auth_config_id", None)

    @property
    def username(self):
        """Gets the username of this LoginInput.  # noqa: E501


        :return: The username of this LoginInput.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this LoginInput.


        :param username: The username of this LoginInput.  # noqa: E501
        :type username: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def source(self):
        """Gets the source of this LoginInput.  # noqa: E501


        :return: The source of this LoginInput.  # noqa: E501
        :rtype: UserSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this LoginInput.


        :param source: The source of this LoginInput.  # noqa: E501
        :type source: UserSource
        """

        self._source = source

    @property
    def password(self):
        """Gets the password of this LoginInput.  # noqa: E501


        :return: The password of this LoginInput.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this LoginInput.


        :param password: The password of this LoginInput.  # noqa: E501
        :type password: str
        """
        if self.local_vars_configuration.client_side_validation and password is None:  # noqa: E501
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501

        self._password = password

    @property
    def mfa_type(self):
        """Gets the mfa_type of this LoginInput.  # noqa: E501


        :return: The mfa_type of this LoginInput.  # noqa: E501
        :rtype: MfaType
        """
        return self._mfa_type

    @mfa_type.setter
    def mfa_type(self, mfa_type):
        """Sets the mfa_type of this LoginInput.


        :param mfa_type: The mfa_type of this LoginInput.  # noqa: E501
        :type mfa_type: MfaType
        """

        self._mfa_type = mfa_type

    @property
    def auth_config_id(self):
        """Gets the auth_config_id of this LoginInput.  # noqa: E501


        :return: The auth_config_id of this LoginInput.  # noqa: E501
        :rtype: str
        """
        return self._auth_config_id

    @auth_config_id.setter
    def auth_config_id(self, auth_config_id):
        """Sets the auth_config_id of this LoginInput.


        :param auth_config_id: The auth_config_id of this LoginInput.  # noqa: E501
        :type auth_config_id: str
        """

        self._auth_config_id = auth_config_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoginInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LoginInput):
            return True

        return self.to_dict() != other.to_dict()
