# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Metric(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'unit': 'MetricUnit',
        'step': 'int',
        'samples': 'list[MetricSample]',
        'sample_streams': 'list[MetricStream]',
        'dropped': 'bool',
        'typename': 'str'
    }

    attribute_map = {
        'unit': 'unit',
        'step': 'step',
        'samples': 'samples',
        'sample_streams': 'sample_streams',
        'dropped': 'dropped',
        'typename': '__typename'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Metric - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._unit = None
        self._step = None
        self._samples = None
        self._sample_streams = None
        self._dropped = None
        self._typename = None
        self.discriminator = None

        if "unit" in kwargs:
            self.unit = kwargs["unit"]
        if "step" in kwargs:
            self.step = kwargs["step"]
        self.samples = kwargs.get("samples", None)
        self.sample_streams = kwargs.get("sample_streams", None)
        if "dropped" in kwargs:
            self.dropped = kwargs["dropped"]
        if "typename" in kwargs:
            self.typename = kwargs["typename"]

    @property
    def unit(self):
        """Gets the unit of this Metric.  # noqa: E501


        :return: The unit of this Metric.  # noqa: E501
        :rtype: MetricUnit
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """Sets the unit of this Metric.


        :param unit: The unit of this Metric.  # noqa: E501
        :type unit: MetricUnit
        """
        if self.local_vars_configuration.client_side_validation and unit is None:  # noqa: E501
            raise ValueError("Invalid value for `unit`, must not be `None`")  # noqa: E501

        self._unit = unit

    @property
    def step(self):
        """Gets the step of this Metric.  # noqa: E501


        :return: The step of this Metric.  # noqa: E501
        :rtype: int
        """
        return self._step

    @step.setter
    def step(self, step):
        """Sets the step of this Metric.


        :param step: The step of this Metric.  # noqa: E501
        :type step: int
        """
        if self.local_vars_configuration.client_side_validation and step is None:  # noqa: E501
            raise ValueError("Invalid value for `step`, must not be `None`")  # noqa: E501

        self._step = step

    @property
    def samples(self):
        """Gets the samples of this Metric.  # noqa: E501


        :return: The samples of this Metric.  # noqa: E501
        :rtype: list[MetricSample]
        """
        return self._samples

    @samples.setter
    def samples(self, samples):
        """Sets the samples of this Metric.


        :param samples: The samples of this Metric.  # noqa: E501
        :type samples: list[MetricSample]
        """

        self._samples = samples

    @property
    def sample_streams(self):
        """Gets the sample_streams of this Metric.  # noqa: E501


        :return: The sample_streams of this Metric.  # noqa: E501
        :rtype: list[MetricStream]
        """
        return self._sample_streams

    @sample_streams.setter
    def sample_streams(self, sample_streams):
        """Sets the sample_streams of this Metric.


        :param sample_streams: The sample_streams of this Metric.  # noqa: E501
        :type sample_streams: list[MetricStream]
        """

        self._sample_streams = sample_streams

    @property
    def dropped(self):
        """Gets the dropped of this Metric.  # noqa: E501


        :return: The dropped of this Metric.  # noqa: E501
        :rtype: bool
        """
        return self._dropped

    @dropped.setter
    def dropped(self, dropped):
        """Sets the dropped of this Metric.


        :param dropped: The dropped of this Metric.  # noqa: E501
        :type dropped: bool
        """
        if self.local_vars_configuration.client_side_validation and dropped is None:  # noqa: E501
            raise ValueError("Invalid value for `dropped`, must not be `None`")  # noqa: E501

        self._dropped = dropped

    @property
    def typename(self):
        """Gets the typename of this Metric.  # noqa: E501


        :return: The typename of this Metric.  # noqa: E501
        :rtype: str
        """
        return self._typename

    @typename.setter
    def typename(self, typename):
        """Sets the typename of this Metric.


        :param typename: The typename of this Metric.  # noqa: E501
        :type typename: str
        """
        allowed_values = ["Metric"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and typename not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `typename` ({0}), must be one of {1}"  # noqa: E501
                .format(typename, allowed_values)
            )

        self._typename = typename

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Metric):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Metric):
            return True

        return self.to_dict() != other.to_dict()
