# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedBackupPlanTimePoint(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'date': 'int',
        'date_position': 'list[int]',
        'hour': 'int',
        'minute': 'int',
        'weekday': 'WeekdayTypeEnum'
    }

    attribute_map = {
        'date': 'date',
        'date_position': 'date_position',
        'hour': 'hour',
        'minute': 'minute',
        'weekday': 'weekday'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedBackupPlanTimePoint - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._date = None
        self._date_position = None
        self._hour = None
        self._minute = None
        self._weekday = None
        self.discriminator = None

        self.date = kwargs.get("date", None)
        self.date_position = kwargs.get("date_position", None)
        if "hour" in kwargs:
            self.hour = kwargs["hour"]
        if "minute" in kwargs:
            self.minute = kwargs["minute"]
        self.weekday = kwargs.get("weekday", None)

    @property
    def date(self):
        """Gets the date of this NestedBackupPlanTimePoint.  # noqa: E501


        :return: The date of this NestedBackupPlanTimePoint.  # noqa: E501
        :rtype: int
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this NestedBackupPlanTimePoint.


        :param date: The date of this NestedBackupPlanTimePoint.  # noqa: E501
        :type date: int
        """

        self._date = date

    @property
    def date_position(self):
        """Gets the date_position of this NestedBackupPlanTimePoint.  # noqa: E501


        :return: The date_position of this NestedBackupPlanTimePoint.  # noqa: E501
        :rtype: list[int]
        """
        return self._date_position

    @date_position.setter
    def date_position(self, date_position):
        """Sets the date_position of this NestedBackupPlanTimePoint.


        :param date_position: The date_position of this NestedBackupPlanTimePoint.  # noqa: E501
        :type date_position: list[int]
        """

        self._date_position = date_position

    @property
    def hour(self):
        """Gets the hour of this NestedBackupPlanTimePoint.  # noqa: E501


        :return: The hour of this NestedBackupPlanTimePoint.  # noqa: E501
        :rtype: int
        """
        return self._hour

    @hour.setter
    def hour(self, hour):
        """Sets the hour of this NestedBackupPlanTimePoint.


        :param hour: The hour of this NestedBackupPlanTimePoint.  # noqa: E501
        :type hour: int
        """
        if self.local_vars_configuration.client_side_validation and hour is None:  # noqa: E501
            raise ValueError("Invalid value for `hour`, must not be `None`")  # noqa: E501

        self._hour = hour

    @property
    def minute(self):
        """Gets the minute of this NestedBackupPlanTimePoint.  # noqa: E501


        :return: The minute of this NestedBackupPlanTimePoint.  # noqa: E501
        :rtype: int
        """
        return self._minute

    @minute.setter
    def minute(self, minute):
        """Sets the minute of this NestedBackupPlanTimePoint.


        :param minute: The minute of this NestedBackupPlanTimePoint.  # noqa: E501
        :type minute: int
        """
        if self.local_vars_configuration.client_side_validation and minute is None:  # noqa: E501
            raise ValueError("Invalid value for `minute`, must not be `None`")  # noqa: E501

        self._minute = minute

    @property
    def weekday(self):
        """Gets the weekday of this NestedBackupPlanTimePoint.  # noqa: E501


        :return: The weekday of this NestedBackupPlanTimePoint.  # noqa: E501
        :rtype: WeekdayTypeEnum
        """
        return self._weekday

    @weekday.setter
    def weekday(self, weekday):
        """Sets the weekday of this NestedBackupPlanTimePoint.


        :param weekday: The weekday of this NestedBackupPlanTimePoint.  # noqa: E501
        :type weekday: WeekdayTypeEnum
        """

        self._weekday = weekday

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedBackupPlanTimePoint):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedBackupPlanTimePoint):
            return True

        return self.to_dict() != other.to_dict()
