# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedContentLibraryVmTemplateDisk(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'boot': 'int',
        'bus': 'Bus',
        'content_library_image_id': 'str',
        'disabled': 'bool',
        'disk_name': 'str',
        'elf_storage_policy_ec_k': 'int',
        'elf_storage_policy_ec_m': 'int',
        'elf_storage_policy_replica_num': 'int',
        'elf_storage_policy_thin_provision': 'bool',
        'index': 'int',
        'max_bandwidth': 'int',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_iops': 'int',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'path': 'str',
        'resident_in_cache': 'bool',
        'size': 'int',
        'storage_encrypted': 'bool',
        'storage_policy': 'VmVolumeElfStoragePolicyType',
        'type': 'VmDiskType'
    }

    attribute_map = {
        'boot': 'boot',
        'bus': 'bus',
        'content_library_image_id': 'content_library_image_id',
        'disabled': 'disabled',
        'disk_name': 'disk_name',
        'elf_storage_policy_ec_k': 'elf_storage_policy_ec_k',
        'elf_storage_policy_ec_m': 'elf_storage_policy_ec_m',
        'elf_storage_policy_replica_num': 'elf_storage_policy_replica_num',
        'elf_storage_policy_thin_provision': 'elf_storage_policy_thin_provision',
        'index': 'index',
        'max_bandwidth': 'max_bandwidth',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_iops': 'max_iops',
        'max_iops_policy': 'max_iops_policy',
        'path': 'path',
        'resident_in_cache': 'resident_in_cache',
        'size': 'size',
        'storage_encrypted': 'storage_encrypted',
        'storage_policy': 'storage_policy',
        'type': 'type'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedContentLibraryVmTemplateDisk - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._boot = None
        self._bus = None
        self._content_library_image_id = None
        self._disabled = None
        self._disk_name = None
        self._elf_storage_policy_ec_k = None
        self._elf_storage_policy_ec_m = None
        self._elf_storage_policy_replica_num = None
        self._elf_storage_policy_thin_provision = None
        self._index = None
        self._max_bandwidth = None
        self._max_bandwidth_policy = None
        self._max_iops = None
        self._max_iops_policy = None
        self._path = None
        self._resident_in_cache = None
        self._size = None
        self._storage_encrypted = None
        self._storage_policy = None
        self._type = None
        self.discriminator = None

        if "boot" in kwargs:
            self.boot = kwargs["boot"]
        if "bus" in kwargs:
            self.bus = kwargs["bus"]
        self.content_library_image_id = kwargs.get("content_library_image_id", None)
        self.disabled = kwargs.get("disabled", None)
        self.disk_name = kwargs.get("disk_name", None)
        self.elf_storage_policy_ec_k = kwargs.get("elf_storage_policy_ec_k", None)
        self.elf_storage_policy_ec_m = kwargs.get("elf_storage_policy_ec_m", None)
        self.elf_storage_policy_replica_num = kwargs.get("elf_storage_policy_replica_num", None)
        self.elf_storage_policy_thin_provision = kwargs.get("elf_storage_policy_thin_provision", None)
        if "index" in kwargs:
            self.index = kwargs["index"]
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        self.path = kwargs.get("path", None)
        self.resident_in_cache = kwargs.get("resident_in_cache", None)
        self.size = kwargs.get("size", None)
        self.storage_encrypted = kwargs.get("storage_encrypted", None)
        self.storage_policy = kwargs.get("storage_policy", None)
        if "type" in kwargs:
            self.type = kwargs["type"]

    @property
    def boot(self):
        """Gets the boot of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The boot of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._boot

    @boot.setter
    def boot(self, boot):
        """Sets the boot of this NestedContentLibraryVmTemplateDisk.


        :param boot: The boot of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type boot: int
        """
        if self.local_vars_configuration.client_side_validation and boot is None:  # noqa: E501
            raise ValueError("Invalid value for `boot`, must not be `None`")  # noqa: E501

        self._boot = boot

    @property
    def bus(self):
        """Gets the bus of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The bus of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: Bus
        """
        return self._bus

    @bus.setter
    def bus(self, bus):
        """Sets the bus of this NestedContentLibraryVmTemplateDisk.


        :param bus: The bus of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type bus: Bus
        """
        if self.local_vars_configuration.client_side_validation and bus is None:  # noqa: E501
            raise ValueError("Invalid value for `bus`, must not be `None`")  # noqa: E501

        self._bus = bus

    @property
    def content_library_image_id(self):
        """Gets the content_library_image_id of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The content_library_image_id of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: str
        """
        return self._content_library_image_id

    @content_library_image_id.setter
    def content_library_image_id(self, content_library_image_id):
        """Sets the content_library_image_id of this NestedContentLibraryVmTemplateDisk.


        :param content_library_image_id: The content_library_image_id of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type content_library_image_id: str
        """

        self._content_library_image_id = content_library_image_id

    @property
    def disabled(self):
        """Gets the disabled of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The disabled of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this NestedContentLibraryVmTemplateDisk.


        :param disabled: The disabled of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type disabled: bool
        """

        self._disabled = disabled

    @property
    def disk_name(self):
        """Gets the disk_name of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The disk_name of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: str
        """
        return self._disk_name

    @disk_name.setter
    def disk_name(self, disk_name):
        """Sets the disk_name of this NestedContentLibraryVmTemplateDisk.


        :param disk_name: The disk_name of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type disk_name: str
        """

        self._disk_name = disk_name

    @property
    def elf_storage_policy_ec_k(self):
        """Gets the elf_storage_policy_ec_k of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The elf_storage_policy_ec_k of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k

    @elf_storage_policy_ec_k.setter
    def elf_storage_policy_ec_k(self, elf_storage_policy_ec_k):
        """Sets the elf_storage_policy_ec_k of this NestedContentLibraryVmTemplateDisk.


        :param elf_storage_policy_ec_k: The elf_storage_policy_ec_k of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type elf_storage_policy_ec_k: int
        """

        self._elf_storage_policy_ec_k = elf_storage_policy_ec_k

    @property
    def elf_storage_policy_ec_m(self):
        """Gets the elf_storage_policy_ec_m of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The elf_storage_policy_ec_m of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m

    @elf_storage_policy_ec_m.setter
    def elf_storage_policy_ec_m(self, elf_storage_policy_ec_m):
        """Sets the elf_storage_policy_ec_m of this NestedContentLibraryVmTemplateDisk.


        :param elf_storage_policy_ec_m: The elf_storage_policy_ec_m of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type elf_storage_policy_ec_m: int
        """

        self._elf_storage_policy_ec_m = elf_storage_policy_ec_m

    @property
    def elf_storage_policy_replica_num(self):
        """Gets the elf_storage_policy_replica_num of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The elf_storage_policy_replica_num of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num

    @elf_storage_policy_replica_num.setter
    def elf_storage_policy_replica_num(self, elf_storage_policy_replica_num):
        """Sets the elf_storage_policy_replica_num of this NestedContentLibraryVmTemplateDisk.


        :param elf_storage_policy_replica_num: The elf_storage_policy_replica_num of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type elf_storage_policy_replica_num: int
        """

        self._elf_storage_policy_replica_num = elf_storage_policy_replica_num

    @property
    def elf_storage_policy_thin_provision(self):
        """Gets the elf_storage_policy_thin_provision of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The elf_storage_policy_thin_provision of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision

    @elf_storage_policy_thin_provision.setter
    def elf_storage_policy_thin_provision(self, elf_storage_policy_thin_provision):
        """Sets the elf_storage_policy_thin_provision of this NestedContentLibraryVmTemplateDisk.


        :param elf_storage_policy_thin_provision: The elf_storage_policy_thin_provision of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type elf_storage_policy_thin_provision: bool
        """

        self._elf_storage_policy_thin_provision = elf_storage_policy_thin_provision

    @property
    def index(self):
        """Gets the index of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The index of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this NestedContentLibraryVmTemplateDisk.


        :param index: The index of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type index: int
        """
        if self.local_vars_configuration.client_side_validation and index is None:  # noqa: E501
            raise ValueError("Invalid value for `index`, must not be `None`")  # noqa: E501

        self._index = index

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The max_bandwidth of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this NestedContentLibraryVmTemplateDisk.


        :param max_bandwidth: The max_bandwidth of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type max_bandwidth: int
        """

        self._max_bandwidth = max_bandwidth

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The max_bandwidth_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this NestedContentLibraryVmTemplateDisk.


        :param max_bandwidth_policy: The max_bandwidth_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_iops(self):
        """Gets the max_iops of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The max_iops of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this NestedContentLibraryVmTemplateDisk.


        :param max_iops: The max_iops of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The max_iops_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this NestedContentLibraryVmTemplateDisk.


        :param max_iops_policy: The max_iops_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def path(self):
        """Gets the path of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The path of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this NestedContentLibraryVmTemplateDisk.


        :param path: The path of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type path: str
        """

        self._path = path

    @property
    def resident_in_cache(self):
        """Gets the resident_in_cache of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The resident_in_cache of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache

    @resident_in_cache.setter
    def resident_in_cache(self, resident_in_cache):
        """Sets the resident_in_cache of this NestedContentLibraryVmTemplateDisk.


        :param resident_in_cache: The resident_in_cache of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type resident_in_cache: bool
        """

        self._resident_in_cache = resident_in_cache

    @property
    def size(self):
        """Gets the size of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The size of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this NestedContentLibraryVmTemplateDisk.


        :param size: The size of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def storage_encrypted(self):
        """Gets the storage_encrypted of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The storage_encrypted of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: bool
        """
        return self._storage_encrypted

    @storage_encrypted.setter
    def storage_encrypted(self, storage_encrypted):
        """Sets the storage_encrypted of this NestedContentLibraryVmTemplateDisk.


        :param storage_encrypted: The storage_encrypted of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type storage_encrypted: bool
        """

        self._storage_encrypted = storage_encrypted

    @property
    def storage_policy(self):
        """Gets the storage_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The storage_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._storage_policy

    @storage_policy.setter
    def storage_policy(self, storage_policy):
        """Sets the storage_policy of this NestedContentLibraryVmTemplateDisk.


        :param storage_policy: The storage_policy of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type storage_policy: VmVolumeElfStoragePolicyType
        """

        self._storage_policy = storage_policy

    @property
    def type(self):
        """Gets the type of this NestedContentLibraryVmTemplateDisk.  # noqa: E501


        :return: The type of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :rtype: VmDiskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NestedContentLibraryVmTemplateDisk.


        :param type: The type of this NestedContentLibraryVmTemplateDisk.  # noqa: E501
        :type type: VmDiskType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedContentLibraryVmTemplateDisk):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedContentLibraryVmTemplateDisk):
            return True

        return self.to_dict() != other.to_dict()
