# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedContentLibraryVmTemplateNic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'egress_rate_limit_burst_in_bit': 'float',
        'egress_rate_limit_enabled': 'bool',
        'egress_rate_limit_max_rate_in_bitps': 'float',
        'enabled': 'bool',
        'index': 'int',
        'ingress_rate_limit_burst_in_bit': 'float',
        'ingress_rate_limit_enabled': 'bool',
        'ingress_rate_limit_max_rate_in_bitps': 'float',
        'mirror': 'bool',
        'model': 'VmNicModel',
        'type': 'VmNicType',
        'vlan': 'NestedFrozenVlan',
        'vpc_nic': 'NestedTemplateVpcNic'
    }

    attribute_map = {
        'egress_rate_limit_burst_in_bit': 'egress_rate_limit_burst_in_bit',
        'egress_rate_limit_enabled': 'egress_rate_limit_enabled',
        'egress_rate_limit_max_rate_in_bitps': 'egress_rate_limit_max_rate_in_bitps',
        'enabled': 'enabled',
        'index': 'index',
        'ingress_rate_limit_burst_in_bit': 'ingress_rate_limit_burst_in_bit',
        'ingress_rate_limit_enabled': 'ingress_rate_limit_enabled',
        'ingress_rate_limit_max_rate_in_bitps': 'ingress_rate_limit_max_rate_in_bitps',
        'mirror': 'mirror',
        'model': 'model',
        'type': 'type',
        'vlan': 'vlan',
        'vpc_nic': 'vpc_nic'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedContentLibraryVmTemplateNic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._egress_rate_limit_burst_in_bit = None
        self._egress_rate_limit_enabled = None
        self._egress_rate_limit_max_rate_in_bitps = None
        self._enabled = None
        self._index = None
        self._ingress_rate_limit_burst_in_bit = None
        self._ingress_rate_limit_enabled = None
        self._ingress_rate_limit_max_rate_in_bitps = None
        self._mirror = None
        self._model = None
        self._type = None
        self._vlan = None
        self._vpc_nic = None
        self.discriminator = None

        self.egress_rate_limit_burst_in_bit = kwargs.get("egress_rate_limit_burst_in_bit", None)
        self.egress_rate_limit_enabled = kwargs.get("egress_rate_limit_enabled", None)
        self.egress_rate_limit_max_rate_in_bitps = kwargs.get("egress_rate_limit_max_rate_in_bitps", None)
        self.enabled = kwargs.get("enabled", None)
        if "index" in kwargs:
            self.index = kwargs["index"]
        self.ingress_rate_limit_burst_in_bit = kwargs.get("ingress_rate_limit_burst_in_bit", None)
        self.ingress_rate_limit_enabled = kwargs.get("ingress_rate_limit_enabled", None)
        self.ingress_rate_limit_max_rate_in_bitps = kwargs.get("ingress_rate_limit_max_rate_in_bitps", None)
        self.mirror = kwargs.get("mirror", None)
        self.model = kwargs.get("model", None)
        self.type = kwargs.get("type", None)
        self.vlan = kwargs.get("vlan", None)
        self.vpc_nic = kwargs.get("vpc_nic", None)

    @property
    def egress_rate_limit_burst_in_bit(self):
        """Gets the egress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The egress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: float
        """
        return self._egress_rate_limit_burst_in_bit

    @egress_rate_limit_burst_in_bit.setter
    def egress_rate_limit_burst_in_bit(self, egress_rate_limit_burst_in_bit):
        """Sets the egress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.


        :param egress_rate_limit_burst_in_bit: The egress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type egress_rate_limit_burst_in_bit: float
        """

        self._egress_rate_limit_burst_in_bit = egress_rate_limit_burst_in_bit

    @property
    def egress_rate_limit_enabled(self):
        """Gets the egress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The egress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: bool
        """
        return self._egress_rate_limit_enabled

    @egress_rate_limit_enabled.setter
    def egress_rate_limit_enabled(self, egress_rate_limit_enabled):
        """Sets the egress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.


        :param egress_rate_limit_enabled: The egress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type egress_rate_limit_enabled: bool
        """

        self._egress_rate_limit_enabled = egress_rate_limit_enabled

    @property
    def egress_rate_limit_max_rate_in_bitps(self):
        """Gets the egress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The egress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: float
        """
        return self._egress_rate_limit_max_rate_in_bitps

    @egress_rate_limit_max_rate_in_bitps.setter
    def egress_rate_limit_max_rate_in_bitps(self, egress_rate_limit_max_rate_in_bitps):
        """Sets the egress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.


        :param egress_rate_limit_max_rate_in_bitps: The egress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type egress_rate_limit_max_rate_in_bitps: float
        """

        self._egress_rate_limit_max_rate_in_bitps = egress_rate_limit_max_rate_in_bitps

    @property
    def enabled(self):
        """Gets the enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this NestedContentLibraryVmTemplateNic.


        :param enabled: The enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def index(self):
        """Gets the index of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The index of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this NestedContentLibraryVmTemplateNic.


        :param index: The index of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type index: int
        """
        if self.local_vars_configuration.client_side_validation and index is None:  # noqa: E501
            raise ValueError("Invalid value for `index`, must not be `None`")  # noqa: E501

        self._index = index

    @property
    def ingress_rate_limit_burst_in_bit(self):
        """Gets the ingress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The ingress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: float
        """
        return self._ingress_rate_limit_burst_in_bit

    @ingress_rate_limit_burst_in_bit.setter
    def ingress_rate_limit_burst_in_bit(self, ingress_rate_limit_burst_in_bit):
        """Sets the ingress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.


        :param ingress_rate_limit_burst_in_bit: The ingress_rate_limit_burst_in_bit of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type ingress_rate_limit_burst_in_bit: float
        """

        self._ingress_rate_limit_burst_in_bit = ingress_rate_limit_burst_in_bit

    @property
    def ingress_rate_limit_enabled(self):
        """Gets the ingress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The ingress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: bool
        """
        return self._ingress_rate_limit_enabled

    @ingress_rate_limit_enabled.setter
    def ingress_rate_limit_enabled(self, ingress_rate_limit_enabled):
        """Sets the ingress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.


        :param ingress_rate_limit_enabled: The ingress_rate_limit_enabled of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type ingress_rate_limit_enabled: bool
        """

        self._ingress_rate_limit_enabled = ingress_rate_limit_enabled

    @property
    def ingress_rate_limit_max_rate_in_bitps(self):
        """Gets the ingress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The ingress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: float
        """
        return self._ingress_rate_limit_max_rate_in_bitps

    @ingress_rate_limit_max_rate_in_bitps.setter
    def ingress_rate_limit_max_rate_in_bitps(self, ingress_rate_limit_max_rate_in_bitps):
        """Sets the ingress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.


        :param ingress_rate_limit_max_rate_in_bitps: The ingress_rate_limit_max_rate_in_bitps of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type ingress_rate_limit_max_rate_in_bitps: float
        """

        self._ingress_rate_limit_max_rate_in_bitps = ingress_rate_limit_max_rate_in_bitps

    @property
    def mirror(self):
        """Gets the mirror of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The mirror of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this NestedContentLibraryVmTemplateNic.


        :param mirror: The mirror of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type mirror: bool
        """

        self._mirror = mirror

    @property
    def model(self):
        """Gets the model of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The model of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: VmNicModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this NestedContentLibraryVmTemplateNic.


        :param model: The model of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type model: VmNicModel
        """

        self._model = model

    @property
    def type(self):
        """Gets the type of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The type of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: VmNicType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NestedContentLibraryVmTemplateNic.


        :param type: The type of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type type: VmNicType
        """

        self._type = type

    @property
    def vlan(self):
        """Gets the vlan of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The vlan of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: NestedFrozenVlan
        """
        return self._vlan

    @vlan.setter
    def vlan(self, vlan):
        """Sets the vlan of this NestedContentLibraryVmTemplateNic.


        :param vlan: The vlan of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type vlan: NestedFrozenVlan
        """

        self._vlan = vlan

    @property
    def vpc_nic(self):
        """Gets the vpc_nic of this NestedContentLibraryVmTemplateNic.  # noqa: E501


        :return: The vpc_nic of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :rtype: NestedTemplateVpcNic
        """
        return self._vpc_nic

    @vpc_nic.setter
    def vpc_nic(self, vpc_nic):
        """Sets the vpc_nic of this NestedContentLibraryVmTemplateNic.


        :param vpc_nic: The vpc_nic of this NestedContentLibraryVmTemplateNic.  # noqa: E501
        :type vpc_nic: NestedTemplateVpcNic
        """

        self._vpc_nic = vpc_nic

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedContentLibraryVmTemplateNic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedContentLibraryVmTemplateNic):
            return True

        return self.to_dict() != other.to_dict()
