# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedDiskFailureInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'chunk_checksum_error': 'bool',
        'chunk_errflag': 'bool',
        'chunk_io_error': 'bool',
        'chunk_warnflag': 'bool',
        'iostat_latency': 'bool',
        'iostat_latency_ms': 'int',
        'smart_check': 'bool'
    }

    attribute_map = {
        'chunk_checksum_error': 'chunk_checksum_error',
        'chunk_errflag': 'chunk_errflag',
        'chunk_io_error': 'chunk_io_error',
        'chunk_warnflag': 'chunk_warnflag',
        'iostat_latency': 'iostat_latency',
        'iostat_latency_ms': 'iostat_latency_ms',
        'smart_check': 'smart_check'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedDiskFailureInformation - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._chunk_checksum_error = None
        self._chunk_errflag = None
        self._chunk_io_error = None
        self._chunk_warnflag = None
        self._iostat_latency = None
        self._iostat_latency_ms = None
        self._smart_check = None
        self.discriminator = None

        self.chunk_checksum_error = kwargs.get("chunk_checksum_error", None)
        self.chunk_errflag = kwargs.get("chunk_errflag", None)
        self.chunk_io_error = kwargs.get("chunk_io_error", None)
        self.chunk_warnflag = kwargs.get("chunk_warnflag", None)
        self.iostat_latency = kwargs.get("iostat_latency", None)
        self.iostat_latency_ms = kwargs.get("iostat_latency_ms", None)
        self.smart_check = kwargs.get("smart_check", None)

    @property
    def chunk_checksum_error(self):
        """Gets the chunk_checksum_error of this NestedDiskFailureInformation.  # noqa: E501


        :return: The chunk_checksum_error of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._chunk_checksum_error

    @chunk_checksum_error.setter
    def chunk_checksum_error(self, chunk_checksum_error):
        """Sets the chunk_checksum_error of this NestedDiskFailureInformation.


        :param chunk_checksum_error: The chunk_checksum_error of this NestedDiskFailureInformation.  # noqa: E501
        :type chunk_checksum_error: bool
        """

        self._chunk_checksum_error = chunk_checksum_error

    @property
    def chunk_errflag(self):
        """Gets the chunk_errflag of this NestedDiskFailureInformation.  # noqa: E501


        :return: The chunk_errflag of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._chunk_errflag

    @chunk_errflag.setter
    def chunk_errflag(self, chunk_errflag):
        """Sets the chunk_errflag of this NestedDiskFailureInformation.


        :param chunk_errflag: The chunk_errflag of this NestedDiskFailureInformation.  # noqa: E501
        :type chunk_errflag: bool
        """

        self._chunk_errflag = chunk_errflag

    @property
    def chunk_io_error(self):
        """Gets the chunk_io_error of this NestedDiskFailureInformation.  # noqa: E501


        :return: The chunk_io_error of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._chunk_io_error

    @chunk_io_error.setter
    def chunk_io_error(self, chunk_io_error):
        """Sets the chunk_io_error of this NestedDiskFailureInformation.


        :param chunk_io_error: The chunk_io_error of this NestedDiskFailureInformation.  # noqa: E501
        :type chunk_io_error: bool
        """

        self._chunk_io_error = chunk_io_error

    @property
    def chunk_warnflag(self):
        """Gets the chunk_warnflag of this NestedDiskFailureInformation.  # noqa: E501


        :return: The chunk_warnflag of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._chunk_warnflag

    @chunk_warnflag.setter
    def chunk_warnflag(self, chunk_warnflag):
        """Sets the chunk_warnflag of this NestedDiskFailureInformation.


        :param chunk_warnflag: The chunk_warnflag of this NestedDiskFailureInformation.  # noqa: E501
        :type chunk_warnflag: bool
        """

        self._chunk_warnflag = chunk_warnflag

    @property
    def iostat_latency(self):
        """Gets the iostat_latency of this NestedDiskFailureInformation.  # noqa: E501


        :return: The iostat_latency of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._iostat_latency

    @iostat_latency.setter
    def iostat_latency(self, iostat_latency):
        """Sets the iostat_latency of this NestedDiskFailureInformation.


        :param iostat_latency: The iostat_latency of this NestedDiskFailureInformation.  # noqa: E501
        :type iostat_latency: bool
        """

        self._iostat_latency = iostat_latency

    @property
    def iostat_latency_ms(self):
        """Gets the iostat_latency_ms of this NestedDiskFailureInformation.  # noqa: E501


        :return: The iostat_latency_ms of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: int
        """
        return self._iostat_latency_ms

    @iostat_latency_ms.setter
    def iostat_latency_ms(self, iostat_latency_ms):
        """Sets the iostat_latency_ms of this NestedDiskFailureInformation.


        :param iostat_latency_ms: The iostat_latency_ms of this NestedDiskFailureInformation.  # noqa: E501
        :type iostat_latency_ms: int
        """

        self._iostat_latency_ms = iostat_latency_ms

    @property
    def smart_check(self):
        """Gets the smart_check of this NestedDiskFailureInformation.  # noqa: E501


        :return: The smart_check of this NestedDiskFailureInformation.  # noqa: E501
        :rtype: bool
        """
        return self._smart_check

    @smart_check.setter
    def smart_check(self, smart_check):
        """Sets the smart_check of this NestedDiskFailureInformation.


        :param smart_check: The smart_check of this NestedDiskFailureInformation.  # noqa: E501
        :type smart_check: bool
        """

        self._smart_check = smart_check

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedDiskFailureInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedDiskFailureInformation):
            return True

        return self.to_dict() != other.to_dict()
