# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedEverouteClusterAgentStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'current_number': 'int',
        'expect_number': 'int',
        'instances': 'list[NestedEverouteAgentStatus]',
        'manage_vd_ses': 'list[NestedEverouteManageVDSStatus]',
        'number_health': 'int'
    }

    attribute_map = {
        'current_number': 'currentNumber',
        'expect_number': 'expectNumber',
        'instances': 'instances',
        'manage_vd_ses': 'manageVDSes',
        'number_health': 'numberHealth'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedEverouteClusterAgentStatus - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._current_number = None
        self._expect_number = None
        self._instances = None
        self._manage_vd_ses = None
        self._number_health = None
        self.discriminator = None

        self.current_number = kwargs.get("current_number", None)
        self.expect_number = kwargs.get("expect_number", None)
        self.instances = kwargs.get("instances", None)
        self.manage_vd_ses = kwargs.get("manage_vd_ses", None)
        self.number_health = kwargs.get("number_health", None)

    @property
    def current_number(self):
        """Gets the current_number of this NestedEverouteClusterAgentStatus.  # noqa: E501


        :return: The current_number of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :rtype: int
        """
        return self._current_number

    @current_number.setter
    def current_number(self, current_number):
        """Sets the current_number of this NestedEverouteClusterAgentStatus.


        :param current_number: The current_number of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :type current_number: int
        """

        self._current_number = current_number

    @property
    def expect_number(self):
        """Gets the expect_number of this NestedEverouteClusterAgentStatus.  # noqa: E501


        :return: The expect_number of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :rtype: int
        """
        return self._expect_number

    @expect_number.setter
    def expect_number(self, expect_number):
        """Sets the expect_number of this NestedEverouteClusterAgentStatus.


        :param expect_number: The expect_number of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :type expect_number: int
        """

        self._expect_number = expect_number

    @property
    def instances(self):
        """Gets the instances of this NestedEverouteClusterAgentStatus.  # noqa: E501


        :return: The instances of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :rtype: list[NestedEverouteAgentStatus]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this NestedEverouteClusterAgentStatus.


        :param instances: The instances of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :type instances: list[NestedEverouteAgentStatus]
        """

        self._instances = instances

    @property
    def manage_vd_ses(self):
        """Gets the manage_vd_ses of this NestedEverouteClusterAgentStatus.  # noqa: E501


        :return: The manage_vd_ses of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :rtype: list[NestedEverouteManageVDSStatus]
        """
        return self._manage_vd_ses

    @manage_vd_ses.setter
    def manage_vd_ses(self, manage_vd_ses):
        """Sets the manage_vd_ses of this NestedEverouteClusterAgentStatus.


        :param manage_vd_ses: The manage_vd_ses of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :type manage_vd_ses: list[NestedEverouteManageVDSStatus]
        """

        self._manage_vd_ses = manage_vd_ses

    @property
    def number_health(self):
        """Gets the number_health of this NestedEverouteClusterAgentStatus.  # noqa: E501


        :return: The number_health of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :rtype: int
        """
        return self._number_health

    @number_health.setter
    def number_health(self, number_health):
        """Sets the number_health of this NestedEverouteClusterAgentStatus.


        :param number_health: The number_health of this NestedEverouteClusterAgentStatus.  # noqa: E501
        :type number_health: int
        """

        self._number_health = number_health

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedEverouteClusterAgentStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedEverouteClusterAgentStatus):
            return True

        return self.to_dict() != other.to_dict()
