# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedEverouteClusterVMMetrics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cpu_usage': 'float',
        'data_volume_usage': 'float',
        'last_acquisition_time': 'str',
        'memory_usage': 'float'
    }

    attribute_map = {
        'cpu_usage': 'cpuUsage',
        'data_volume_usage': 'dataVolumeUsage',
        'last_acquisition_time': 'lastAcquisitionTime',
        'memory_usage': 'memoryUsage'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedEverouteClusterVMMetrics - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cpu_usage = None
        self._data_volume_usage = None
        self._last_acquisition_time = None
        self._memory_usage = None
        self.discriminator = None

        if "cpu_usage" in kwargs:
            self.cpu_usage = kwargs["cpu_usage"]
        if "data_volume_usage" in kwargs:
            self.data_volume_usage = kwargs["data_volume_usage"]
        if "last_acquisition_time" in kwargs:
            self.last_acquisition_time = kwargs["last_acquisition_time"]
        if "memory_usage" in kwargs:
            self.memory_usage = kwargs["memory_usage"]

    @property
    def cpu_usage(self):
        """Gets the cpu_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501


        :return: The cpu_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :rtype: float
        """
        return self._cpu_usage

    @cpu_usage.setter
    def cpu_usage(self, cpu_usage):
        """Sets the cpu_usage of this NestedEverouteClusterVMMetrics.


        :param cpu_usage: The cpu_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :type cpu_usage: float
        """
        if self.local_vars_configuration.client_side_validation and cpu_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_usage`, must not be `None`")  # noqa: E501

        self._cpu_usage = cpu_usage

    @property
    def data_volume_usage(self):
        """Gets the data_volume_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501


        :return: The data_volume_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :rtype: float
        """
        return self._data_volume_usage

    @data_volume_usage.setter
    def data_volume_usage(self, data_volume_usage):
        """Sets the data_volume_usage of this NestedEverouteClusterVMMetrics.


        :param data_volume_usage: The data_volume_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :type data_volume_usage: float
        """
        if self.local_vars_configuration.client_side_validation and data_volume_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `data_volume_usage`, must not be `None`")  # noqa: E501

        self._data_volume_usage = data_volume_usage

    @property
    def last_acquisition_time(self):
        """Gets the last_acquisition_time of this NestedEverouteClusterVMMetrics.  # noqa: E501


        :return: The last_acquisition_time of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :rtype: str
        """
        return self._last_acquisition_time

    @last_acquisition_time.setter
    def last_acquisition_time(self, last_acquisition_time):
        """Sets the last_acquisition_time of this NestedEverouteClusterVMMetrics.


        :param last_acquisition_time: The last_acquisition_time of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :type last_acquisition_time: str
        """
        if self.local_vars_configuration.client_side_validation and last_acquisition_time is None:  # noqa: E501
            raise ValueError("Invalid value for `last_acquisition_time`, must not be `None`")  # noqa: E501

        self._last_acquisition_time = last_acquisition_time

    @property
    def memory_usage(self):
        """Gets the memory_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501


        :return: The memory_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :rtype: float
        """
        return self._memory_usage

    @memory_usage.setter
    def memory_usage(self, memory_usage):
        """Sets the memory_usage of this NestedEverouteClusterVMMetrics.


        :param memory_usage: The memory_usage of this NestedEverouteClusterVMMetrics.  # noqa: E501
        :type memory_usage: float
        """
        if self.local_vars_configuration.client_side_validation and memory_usage is None:  # noqa: E501
            raise ValueError("Invalid value for `memory_usage`, must not be `None`")  # noqa: E501

        self._memory_usage = memory_usage

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedEverouteClusterVMMetrics):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedEverouteClusterVMMetrics):
            return True

        return self.to_dict() != other.to_dict()
