# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedEverouteControllerInstance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ip_addr': 'str',
        'vlan': 'str'
    }

    attribute_map = {
        'ip_addr': 'ipAddr',
        'vlan': 'vlan'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedEverouteControllerInstance - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._ip_addr = None
        self._vlan = None
        self.discriminator = None

        if "ip_addr" in kwargs:
            self.ip_addr = kwargs["ip_addr"]
        if "vlan" in kwargs:
            self.vlan = kwargs["vlan"]

    @property
    def ip_addr(self):
        """Gets the ip_addr of this NestedEverouteControllerInstance.  # noqa: E501


        :return: The ip_addr of this NestedEverouteControllerInstance.  # noqa: E501
        :rtype: str
        """
        return self._ip_addr

    @ip_addr.setter
    def ip_addr(self, ip_addr):
        """Sets the ip_addr of this NestedEverouteControllerInstance.


        :param ip_addr: The ip_addr of this NestedEverouteControllerInstance.  # noqa: E501
        :type ip_addr: str
        """
        if self.local_vars_configuration.client_side_validation and ip_addr is None:  # noqa: E501
            raise ValueError("Invalid value for `ip_addr`, must not be `None`")  # noqa: E501

        self._ip_addr = ip_addr

    @property
    def vlan(self):
        """Gets the vlan of this NestedEverouteControllerInstance.  # noqa: E501


        :return: The vlan of this NestedEverouteControllerInstance.  # noqa: E501
        :rtype: str
        """
        return self._vlan

    @vlan.setter
    def vlan(self, vlan):
        """Sets the vlan of this NestedEverouteControllerInstance.


        :param vlan: The vlan of this NestedEverouteControllerInstance.  # noqa: E501
        :type vlan: str
        """
        if self.local_vars_configuration.client_side_validation and vlan is None:  # noqa: E501
            raise ValueError("Invalid value for `vlan`, must not be `None`")  # noqa: E501

        self._vlan = vlan

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedEverouteControllerInstance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedEverouteControllerInstance):
            return True

        return self.to_dict() != other.to_dict()
