# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedEverouteManageVDSStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'message': 'str',
        'phase': 'EverouteClusterPhase',
        'reason': 'str',
        'retry_count': 'int',
        'vds': 'NestedVds',
        'vds_id': 'str'
    }

    attribute_map = {
        'message': 'message',
        'phase': 'phase',
        'reason': 'reason',
        'retry_count': 'retryCount',
        'vds': 'vds',
        'vds_id': 'vdsID'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedEverouteManageVDSStatus - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._message = None
        self._phase = None
        self._reason = None
        self._retry_count = None
        self._vds = None
        self._vds_id = None
        self.discriminator = None

        self.message = kwargs.get("message", None)
        self.phase = kwargs.get("phase", None)
        self.reason = kwargs.get("reason", None)
        self.retry_count = kwargs.get("retry_count", None)
        self.vds = kwargs.get("vds", None)
        if "vds_id" in kwargs:
            self.vds_id = kwargs["vds_id"]

    @property
    def message(self):
        """Gets the message of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The message of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this NestedEverouteManageVDSStatus.


        :param message: The message of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def phase(self):
        """Gets the phase of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The phase of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this NestedEverouteManageVDSStatus.


        :param phase: The phase of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type phase: EverouteClusterPhase
        """

        self._phase = phase

    @property
    def reason(self):
        """Gets the reason of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The reason of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this NestedEverouteManageVDSStatus.


        :param reason: The reason of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type reason: str
        """

        self._reason = reason

    @property
    def retry_count(self):
        """Gets the retry_count of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The retry_count of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: int
        """
        return self._retry_count

    @retry_count.setter
    def retry_count(self, retry_count):
        """Sets the retry_count of this NestedEverouteManageVDSStatus.


        :param retry_count: The retry_count of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type retry_count: int
        """

        self._retry_count = retry_count

    @property
    def vds(self):
        """Gets the vds of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The vds of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: NestedVds
        """
        return self._vds

    @vds.setter
    def vds(self, vds):
        """Sets the vds of this NestedEverouteManageVDSStatus.


        :param vds: The vds of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type vds: NestedVds
        """

        self._vds = vds

    @property
    def vds_id(self):
        """Gets the vds_id of this NestedEverouteManageVDSStatus.  # noqa: E501


        :return: The vds_id of this NestedEverouteManageVDSStatus.  # noqa: E501
        :rtype: str
        """
        return self._vds_id

    @vds_id.setter
    def vds_id(self, vds_id):
        """Sets the vds_id of this NestedEverouteManageVDSStatus.


        :param vds_id: The vds_id of this NestedEverouteManageVDSStatus.  # noqa: E501
        :type vds_id: str
        """
        if self.local_vars_configuration.client_side_validation and vds_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vds_id`, must not be `None`")  # noqa: E501

        self._vds_id = vds_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedEverouteManageVDSStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedEverouteManageVDSStatus):
            return True

        return self.to_dict() != other.to_dict()
