# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedGpuDriverInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'filename': 'str',
        'name': 'str',
        'rhelversion': 'str',
        'srcversion': 'str',
        'supported': 'str',
        'vermagic': 'str',
        'version': 'str'
    }

    attribute_map = {
        'filename': 'filename',
        'name': 'name',
        'rhelversion': 'rhelversion',
        'srcversion': 'srcversion',
        'supported': 'supported',
        'vermagic': 'vermagic',
        'version': 'version'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedGpuDriverInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._filename = None
        self._name = None
        self._rhelversion = None
        self._srcversion = None
        self._supported = None
        self._vermagic = None
        self._version = None
        self.discriminator = None

        self.filename = kwargs.get("filename", None)
        self.name = kwargs.get("name", None)
        self.rhelversion = kwargs.get("rhelversion", None)
        self.srcversion = kwargs.get("srcversion", None)
        self.supported = kwargs.get("supported", None)
        self.vermagic = kwargs.get("vermagic", None)
        self.version = kwargs.get("version", None)

    @property
    def filename(self):
        """Gets the filename of this NestedGpuDriverInfo.  # noqa: E501


        :return: The filename of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this NestedGpuDriverInfo.


        :param filename: The filename of this NestedGpuDriverInfo.  # noqa: E501
        :type filename: str
        """

        self._filename = filename

    @property
    def name(self):
        """Gets the name of this NestedGpuDriverInfo.  # noqa: E501


        :return: The name of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NestedGpuDriverInfo.


        :param name: The name of this NestedGpuDriverInfo.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def rhelversion(self):
        """Gets the rhelversion of this NestedGpuDriverInfo.  # noqa: E501


        :return: The rhelversion of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._rhelversion

    @rhelversion.setter
    def rhelversion(self, rhelversion):
        """Sets the rhelversion of this NestedGpuDriverInfo.


        :param rhelversion: The rhelversion of this NestedGpuDriverInfo.  # noqa: E501
        :type rhelversion: str
        """

        self._rhelversion = rhelversion

    @property
    def srcversion(self):
        """Gets the srcversion of this NestedGpuDriverInfo.  # noqa: E501


        :return: The srcversion of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._srcversion

    @srcversion.setter
    def srcversion(self, srcversion):
        """Sets the srcversion of this NestedGpuDriverInfo.


        :param srcversion: The srcversion of this NestedGpuDriverInfo.  # noqa: E501
        :type srcversion: str
        """

        self._srcversion = srcversion

    @property
    def supported(self):
        """Gets the supported of this NestedGpuDriverInfo.  # noqa: E501


        :return: The supported of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._supported

    @supported.setter
    def supported(self, supported):
        """Sets the supported of this NestedGpuDriverInfo.


        :param supported: The supported of this NestedGpuDriverInfo.  # noqa: E501
        :type supported: str
        """

        self._supported = supported

    @property
    def vermagic(self):
        """Gets the vermagic of this NestedGpuDriverInfo.  # noqa: E501


        :return: The vermagic of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._vermagic

    @vermagic.setter
    def vermagic(self, vermagic):
        """Sets the vermagic of this NestedGpuDriverInfo.


        :param vermagic: The vermagic of this NestedGpuDriverInfo.  # noqa: E501
        :type vermagic: str
        """

        self._vermagic = vermagic

    @property
    def version(self):
        """Gets the version of this NestedGpuDriverInfo.  # noqa: E501


        :return: The version of this NestedGpuDriverInfo.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this NestedGpuDriverInfo.


        :param version: The version of this NestedGpuDriverInfo.  # noqa: E501
        :type version: str
        """

        self._version = version

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedGpuDriverInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedGpuDriverInfo):
            return True

        return self.to_dict() != other.to_dict()
