# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedInitiator(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'chap_name': 'str',
        'chap_secret': 'str',
        'enable_chap': 'bool',
        'identifier': 'str',
        'ips': 'str'
    }

    attribute_map = {
        'chap_name': 'chap_name',
        'chap_secret': 'chap_secret',
        'enable_chap': 'enable_chap',
        'identifier': 'identifier',
        'ips': 'ips'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedInitiator - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._chap_name = None
        self._chap_secret = None
        self._enable_chap = None
        self._identifier = None
        self._ips = None
        self.discriminator = None

        self.chap_name = kwargs.get("chap_name", None)
        self.chap_secret = kwargs.get("chap_secret", None)
        self.enable_chap = kwargs.get("enable_chap", None)
        self.identifier = kwargs.get("identifier", None)
        self.ips = kwargs.get("ips", None)

    @property
    def chap_name(self):
        """Gets the chap_name of this NestedInitiator.  # noqa: E501


        :return: The chap_name of this NestedInitiator.  # noqa: E501
        :rtype: str
        """
        return self._chap_name

    @chap_name.setter
    def chap_name(self, chap_name):
        """Sets the chap_name of this NestedInitiator.


        :param chap_name: The chap_name of this NestedInitiator.  # noqa: E501
        :type chap_name: str
        """

        self._chap_name = chap_name

    @property
    def chap_secret(self):
        """Gets the chap_secret of this NestedInitiator.  # noqa: E501


        :return: The chap_secret of this NestedInitiator.  # noqa: E501
        :rtype: str
        """
        return self._chap_secret

    @chap_secret.setter
    def chap_secret(self, chap_secret):
        """Sets the chap_secret of this NestedInitiator.


        :param chap_secret: The chap_secret of this NestedInitiator.  # noqa: E501
        :type chap_secret: str
        """

        self._chap_secret = chap_secret

    @property
    def enable_chap(self):
        """Gets the enable_chap of this NestedInitiator.  # noqa: E501


        :return: The enable_chap of this NestedInitiator.  # noqa: E501
        :rtype: bool
        """
        return self._enable_chap

    @enable_chap.setter
    def enable_chap(self, enable_chap):
        """Sets the enable_chap of this NestedInitiator.


        :param enable_chap: The enable_chap of this NestedInitiator.  # noqa: E501
        :type enable_chap: bool
        """

        self._enable_chap = enable_chap

    @property
    def identifier(self):
        """Gets the identifier of this NestedInitiator.  # noqa: E501


        :return: The identifier of this NestedInitiator.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this NestedInitiator.


        :param identifier: The identifier of this NestedInitiator.  # noqa: E501
        :type identifier: str
        """

        self._identifier = identifier

    @property
    def ips(self):
        """Gets the ips of this NestedInitiator.  # noqa: E501


        :return: The ips of this NestedInitiator.  # noqa: E501
        :rtype: str
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this NestedInitiator.


        :param ips: The ips of this NestedInitiator.  # noqa: E501
        :type ips: str
        """

        self._ips = ips

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedInitiator):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedInitiator):
            return True

        return self.to_dict() != other.to_dict()
