# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedReplicationObjectDescriptor(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster_local_id': 'str',
        'cluster_name': 'str',
        'object_local_id': 'str',
        'object_name': 'str',
        'parent_object_local_id': 'str',
        'parent_object_name': 'str',
        'tower_deploy_id': 'str',
        'zbs_volume_id': 'str'
    }

    attribute_map = {
        'cluster_local_id': 'cluster_local_id',
        'cluster_name': 'cluster_name',
        'object_local_id': 'object_local_id',
        'object_name': 'object_name',
        'parent_object_local_id': 'parent_object_local_id',
        'parent_object_name': 'parent_object_name',
        'tower_deploy_id': 'tower_deploy_id',
        'zbs_volume_id': 'zbs_volume_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedReplicationObjectDescriptor - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster_local_id = None
        self._cluster_name = None
        self._object_local_id = None
        self._object_name = None
        self._parent_object_local_id = None
        self._parent_object_name = None
        self._tower_deploy_id = None
        self._zbs_volume_id = None
        self.discriminator = None

        if "cluster_local_id" in kwargs:
            self.cluster_local_id = kwargs["cluster_local_id"]
        self.cluster_name = kwargs.get("cluster_name", None)
        if "object_local_id" in kwargs:
            self.object_local_id = kwargs["object_local_id"]
        self.object_name = kwargs.get("object_name", None)
        self.parent_object_local_id = kwargs.get("parent_object_local_id", None)
        self.parent_object_name = kwargs.get("parent_object_name", None)
        self.tower_deploy_id = kwargs.get("tower_deploy_id", None)
        self.zbs_volume_id = kwargs.get("zbs_volume_id", None)

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The cluster_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this NestedReplicationObjectDescriptor.


        :param cluster_local_id: The cluster_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type cluster_local_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_local_id`, must not be `None`")  # noqa: E501

        self._cluster_local_id = cluster_local_id

    @property
    def cluster_name(self):
        """Gets the cluster_name of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The cluster_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """Sets the cluster_name of this NestedReplicationObjectDescriptor.


        :param cluster_name: The cluster_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type cluster_name: str
        """

        self._cluster_name = cluster_name

    @property
    def object_local_id(self):
        """Gets the object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._object_local_id

    @object_local_id.setter
    def object_local_id(self, object_local_id):
        """Sets the object_local_id of this NestedReplicationObjectDescriptor.


        :param object_local_id: The object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type object_local_id: str
        """
        if self.local_vars_configuration.client_side_validation and object_local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `object_local_id`, must not be `None`")  # noqa: E501

        self._object_local_id = object_local_id

    @property
    def object_name(self):
        """Gets the object_name of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The object_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """Sets the object_name of this NestedReplicationObjectDescriptor.


        :param object_name: The object_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type object_name: str
        """

        self._object_name = object_name

    @property
    def parent_object_local_id(self):
        """Gets the parent_object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The parent_object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._parent_object_local_id

    @parent_object_local_id.setter
    def parent_object_local_id(self, parent_object_local_id):
        """Sets the parent_object_local_id of this NestedReplicationObjectDescriptor.


        :param parent_object_local_id: The parent_object_local_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type parent_object_local_id: str
        """

        self._parent_object_local_id = parent_object_local_id

    @property
    def parent_object_name(self):
        """Gets the parent_object_name of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The parent_object_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._parent_object_name

    @parent_object_name.setter
    def parent_object_name(self, parent_object_name):
        """Sets the parent_object_name of this NestedReplicationObjectDescriptor.


        :param parent_object_name: The parent_object_name of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type parent_object_name: str
        """

        self._parent_object_name = parent_object_name

    @property
    def tower_deploy_id(self):
        """Gets the tower_deploy_id of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The tower_deploy_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id

    @tower_deploy_id.setter
    def tower_deploy_id(self, tower_deploy_id):
        """Sets the tower_deploy_id of this NestedReplicationObjectDescriptor.


        :param tower_deploy_id: The tower_deploy_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type tower_deploy_id: str
        """

        self._tower_deploy_id = tower_deploy_id

    @property
    def zbs_volume_id(self):
        """Gets the zbs_volume_id of this NestedReplicationObjectDescriptor.  # noqa: E501


        :return: The zbs_volume_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._zbs_volume_id

    @zbs_volume_id.setter
    def zbs_volume_id(self, zbs_volume_id):
        """Sets the zbs_volume_id of this NestedReplicationObjectDescriptor.


        :param zbs_volume_id: The zbs_volume_id of this NestedReplicationObjectDescriptor.  # noqa: E501
        :type zbs_volume_id: str
        """

        self._zbs_volume_id = zbs_volume_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedReplicationObjectDescriptor):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedReplicationObjectDescriptor):
            return True

        return self.to_dict() != other.to_dict()
