# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedReplicationServiceNetwork(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'gateway': 'str',
        'ip': 'str',
        'mask': 'str',
        'type': 'BackupServiceNetworkType',
        'vlan_id': 'str'
    }

    attribute_map = {
        'gateway': 'gateway',
        'ip': 'ip',
        'mask': 'mask',
        'type': 'type',
        'vlan_id': 'vlanId'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedReplicationServiceNetwork - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._gateway = None
        self._ip = None
        self._mask = None
        self._type = None
        self._vlan_id = None
        self.discriminator = None

        self.gateway = kwargs.get("gateway", None)
        if "ip" in kwargs:
            self.ip = kwargs["ip"]
        if "mask" in kwargs:
            self.mask = kwargs["mask"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        if "vlan_id" in kwargs:
            self.vlan_id = kwargs["vlan_id"]

    @property
    def gateway(self):
        """Gets the gateway of this NestedReplicationServiceNetwork.  # noqa: E501


        :return: The gateway of this NestedReplicationServiceNetwork.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this NestedReplicationServiceNetwork.


        :param gateway: The gateway of this NestedReplicationServiceNetwork.  # noqa: E501
        :type gateway: str
        """

        self._gateway = gateway

    @property
    def ip(self):
        """Gets the ip of this NestedReplicationServiceNetwork.  # noqa: E501


        :return: The ip of this NestedReplicationServiceNetwork.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this NestedReplicationServiceNetwork.


        :param ip: The ip of this NestedReplicationServiceNetwork.  # noqa: E501
        :type ip: str
        """
        if self.local_vars_configuration.client_side_validation and ip is None:  # noqa: E501
            raise ValueError("Invalid value for `ip`, must not be `None`")  # noqa: E501

        self._ip = ip

    @property
    def mask(self):
        """Gets the mask of this NestedReplicationServiceNetwork.  # noqa: E501


        :return: The mask of this NestedReplicationServiceNetwork.  # noqa: E501
        :rtype: str
        """
        return self._mask

    @mask.setter
    def mask(self, mask):
        """Sets the mask of this NestedReplicationServiceNetwork.


        :param mask: The mask of this NestedReplicationServiceNetwork.  # noqa: E501
        :type mask: str
        """
        if self.local_vars_configuration.client_side_validation and mask is None:  # noqa: E501
            raise ValueError("Invalid value for `mask`, must not be `None`")  # noqa: E501

        self._mask = mask

    @property
    def type(self):
        """Gets the type of this NestedReplicationServiceNetwork.  # noqa: E501


        :return: The type of this NestedReplicationServiceNetwork.  # noqa: E501
        :rtype: BackupServiceNetworkType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NestedReplicationServiceNetwork.


        :param type: The type of this NestedReplicationServiceNetwork.  # noqa: E501
        :type type: BackupServiceNetworkType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def vlan_id(self):
        """Gets the vlan_id of this NestedReplicationServiceNetwork.  # noqa: E501


        :return: The vlan_id of this NestedReplicationServiceNetwork.  # noqa: E501
        :rtype: str
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this NestedReplicationServiceNetwork.


        :param vlan_id: The vlan_id of this NestedReplicationServiceNetwork.  # noqa: E501
        :type vlan_id: str
        """
        if self.local_vars_configuration.client_side_validation and vlan_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must not be `None`")  # noqa: E501

        self._vlan_id = vlan_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedReplicationServiceNetwork):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedReplicationServiceNetwork):
            return True

        return self.to_dict() != other.to_dict()
