# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedSecurityPolicyStatistics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'count_reset_timestamp': 'str',
        'count_update_timestamp': 'str',
        'match_allow_count': 'int',
        'match_default_allow_count': 'int',
        'match_default_drop_count': 'int',
        'match_drop_count': 'int',
        'match_whitelist_count': 'int',
        'total_count': 'int'
    }

    attribute_map = {
        'count_reset_timestamp': 'count_reset_timestamp',
        'count_update_timestamp': 'count_update_timestamp',
        'match_allow_count': 'match_allow_count',
        'match_default_allow_count': 'match_default_allow_count',
        'match_default_drop_count': 'match_default_drop_count',
        'match_drop_count': 'match_drop_count',
        'match_whitelist_count': 'match_whitelist_count',
        'total_count': 'total_count'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedSecurityPolicyStatistics - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._count_reset_timestamp = None
        self._count_update_timestamp = None
        self._match_allow_count = None
        self._match_default_allow_count = None
        self._match_default_drop_count = None
        self._match_drop_count = None
        self._match_whitelist_count = None
        self._total_count = None
        self.discriminator = None

        self.count_reset_timestamp = kwargs.get("count_reset_timestamp", None)
        self.count_update_timestamp = kwargs.get("count_update_timestamp", None)
        self.match_allow_count = kwargs.get("match_allow_count", None)
        self.match_default_allow_count = kwargs.get("match_default_allow_count", None)
        self.match_default_drop_count = kwargs.get("match_default_drop_count", None)
        self.match_drop_count = kwargs.get("match_drop_count", None)
        self.match_whitelist_count = kwargs.get("match_whitelist_count", None)
        self.total_count = kwargs.get("total_count", None)

    @property
    def count_reset_timestamp(self):
        """Gets the count_reset_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The count_reset_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: str
        """
        return self._count_reset_timestamp

    @count_reset_timestamp.setter
    def count_reset_timestamp(self, count_reset_timestamp):
        """Sets the count_reset_timestamp of this NestedSecurityPolicyStatistics.


        :param count_reset_timestamp: The count_reset_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type count_reset_timestamp: str
        """

        self._count_reset_timestamp = count_reset_timestamp

    @property
    def count_update_timestamp(self):
        """Gets the count_update_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The count_update_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: str
        """
        return self._count_update_timestamp

    @count_update_timestamp.setter
    def count_update_timestamp(self, count_update_timestamp):
        """Sets the count_update_timestamp of this NestedSecurityPolicyStatistics.


        :param count_update_timestamp: The count_update_timestamp of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type count_update_timestamp: str
        """

        self._count_update_timestamp = count_update_timestamp

    @property
    def match_allow_count(self):
        """Gets the match_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The match_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._match_allow_count

    @match_allow_count.setter
    def match_allow_count(self, match_allow_count):
        """Sets the match_allow_count of this NestedSecurityPolicyStatistics.


        :param match_allow_count: The match_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type match_allow_count: int
        """

        self._match_allow_count = match_allow_count

    @property
    def match_default_allow_count(self):
        """Gets the match_default_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The match_default_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._match_default_allow_count

    @match_default_allow_count.setter
    def match_default_allow_count(self, match_default_allow_count):
        """Sets the match_default_allow_count of this NestedSecurityPolicyStatistics.


        :param match_default_allow_count: The match_default_allow_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type match_default_allow_count: int
        """

        self._match_default_allow_count = match_default_allow_count

    @property
    def match_default_drop_count(self):
        """Gets the match_default_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The match_default_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._match_default_drop_count

    @match_default_drop_count.setter
    def match_default_drop_count(self, match_default_drop_count):
        """Sets the match_default_drop_count of this NestedSecurityPolicyStatistics.


        :param match_default_drop_count: The match_default_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type match_default_drop_count: int
        """

        self._match_default_drop_count = match_default_drop_count

    @property
    def match_drop_count(self):
        """Gets the match_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The match_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._match_drop_count

    @match_drop_count.setter
    def match_drop_count(self, match_drop_count):
        """Sets the match_drop_count of this NestedSecurityPolicyStatistics.


        :param match_drop_count: The match_drop_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type match_drop_count: int
        """

        self._match_drop_count = match_drop_count

    @property
    def match_whitelist_count(self):
        """Gets the match_whitelist_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The match_whitelist_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._match_whitelist_count

    @match_whitelist_count.setter
    def match_whitelist_count(self, match_whitelist_count):
        """Sets the match_whitelist_count of this NestedSecurityPolicyStatistics.


        :param match_whitelist_count: The match_whitelist_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type match_whitelist_count: int
        """

        self._match_whitelist_count = match_whitelist_count

    @property
    def total_count(self):
        """Gets the total_count of this NestedSecurityPolicyStatistics.  # noqa: E501


        :return: The total_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """Sets the total_count of this NestedSecurityPolicyStatistics.


        :param total_count: The total_count of this NestedSecurityPolicyStatistics.  # noqa: E501
        :type total_count: int
        """

        self._total_count = total_count

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedSecurityPolicyStatistics):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedSecurityPolicyStatistics):
            return True

        return self.to_dict() != other.to_dict()
