# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedSnapshotGroupVmInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'disks': 'list[NestedSnapshotGroupVmDiskInfo]',
        'vm_id': 'str',
        'vm_name': 'str',
        'vm_snapshot_status': 'ProtectSnapshotStatus'
    }

    attribute_map = {
        'disks': 'disks',
        'vm_id': 'vm_id',
        'vm_name': 'vm_name',
        'vm_snapshot_status': 'vm_snapshot_status'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedSnapshotGroupVmInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._disks = None
        self._vm_id = None
        self._vm_name = None
        self._vm_snapshot_status = None
        self.discriminator = None

        if "disks" in kwargs:
            self.disks = kwargs["disks"]
        if "vm_id" in kwargs:
            self.vm_id = kwargs["vm_id"]
        if "vm_name" in kwargs:
            self.vm_name = kwargs["vm_name"]
        if "vm_snapshot_status" in kwargs:
            self.vm_snapshot_status = kwargs["vm_snapshot_status"]

    @property
    def disks(self):
        """Gets the disks of this NestedSnapshotGroupVmInfo.  # noqa: E501


        :return: The disks of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :rtype: list[NestedSnapshotGroupVmDiskInfo]
        """
        return self._disks

    @disks.setter
    def disks(self, disks):
        """Sets the disks of this NestedSnapshotGroupVmInfo.


        :param disks: The disks of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :type disks: list[NestedSnapshotGroupVmDiskInfo]
        """
        if self.local_vars_configuration.client_side_validation and disks is None:  # noqa: E501
            raise ValueError("Invalid value for `disks`, must not be `None`")  # noqa: E501

        self._disks = disks

    @property
    def vm_id(self):
        """Gets the vm_id of this NestedSnapshotGroupVmInfo.  # noqa: E501


        :return: The vm_id of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._vm_id

    @vm_id.setter
    def vm_id(self, vm_id):
        """Sets the vm_id of this NestedSnapshotGroupVmInfo.


        :param vm_id: The vm_id of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :type vm_id: str
        """
        if self.local_vars_configuration.client_side_validation and vm_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_id`, must not be `None`")  # noqa: E501

        self._vm_id = vm_id

    @property
    def vm_name(self):
        """Gets the vm_name of this NestedSnapshotGroupVmInfo.  # noqa: E501


        :return: The vm_name of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :rtype: str
        """
        return self._vm_name

    @vm_name.setter
    def vm_name(self, vm_name):
        """Sets the vm_name of this NestedSnapshotGroupVmInfo.


        :param vm_name: The vm_name of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :type vm_name: str
        """
        if self.local_vars_configuration.client_side_validation and vm_name is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_name`, must not be `None`")  # noqa: E501

        self._vm_name = vm_name

    @property
    def vm_snapshot_status(self):
        """Gets the vm_snapshot_status of this NestedSnapshotGroupVmInfo.  # noqa: E501


        :return: The vm_snapshot_status of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :rtype: ProtectSnapshotStatus
        """
        return self._vm_snapshot_status

    @vm_snapshot_status.setter
    def vm_snapshot_status(self, vm_snapshot_status):
        """Sets the vm_snapshot_status of this NestedSnapshotGroupVmInfo.


        :param vm_snapshot_status: The vm_snapshot_status of this NestedSnapshotGroupVmInfo.  # noqa: E501
        :type vm_snapshot_status: ProtectSnapshotStatus
        """
        if self.local_vars_configuration.client_side_validation and vm_snapshot_status is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_snapshot_status`, must not be `None`")  # noqa: E501

        self._vm_snapshot_status = vm_snapshot_status

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedSnapshotGroupVmInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedSnapshotGroupVmInfo):
            return True

        return self.to_dict() != other.to_dict()
