# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedSnapshotInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'index': 'int',
        'iscsi_lun_snapshot_uuid': 'str',
        'storage_encrypted': 'bool',
        'storage_policy_config': 'NestedStoragePolicyConfig'
    }

    attribute_map = {
        'index': 'index',
        'iscsi_lun_snapshot_uuid': 'iscsi_lun_snapshot_uuid',
        'storage_encrypted': 'storage_encrypted',
        'storage_policy_config': 'storage_policy_config'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedSnapshotInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._index = None
        self._iscsi_lun_snapshot_uuid = None
        self._storage_encrypted = None
        self._storage_policy_config = None
        self.discriminator = None

        if "index" in kwargs:
            self.index = kwargs["index"]
        if "iscsi_lun_snapshot_uuid" in kwargs:
            self.iscsi_lun_snapshot_uuid = kwargs["iscsi_lun_snapshot_uuid"]
        self.storage_encrypted = kwargs.get("storage_encrypted", None)
        self.storage_policy_config = kwargs.get("storage_policy_config", None)

    @property
    def index(self):
        """Gets the index of this NestedSnapshotInfo.  # noqa: E501


        :return: The index of this NestedSnapshotInfo.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this NestedSnapshotInfo.


        :param index: The index of this NestedSnapshotInfo.  # noqa: E501
        :type index: int
        """
        if self.local_vars_configuration.client_side_validation and index is None:  # noqa: E501
            raise ValueError("Invalid value for `index`, must not be `None`")  # noqa: E501

        self._index = index

    @property
    def iscsi_lun_snapshot_uuid(self):
        """Gets the iscsi_lun_snapshot_uuid of this NestedSnapshotInfo.  # noqa: E501


        :return: The iscsi_lun_snapshot_uuid of this NestedSnapshotInfo.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_snapshot_uuid

    @iscsi_lun_snapshot_uuid.setter
    def iscsi_lun_snapshot_uuid(self, iscsi_lun_snapshot_uuid):
        """Sets the iscsi_lun_snapshot_uuid of this NestedSnapshotInfo.


        :param iscsi_lun_snapshot_uuid: The iscsi_lun_snapshot_uuid of this NestedSnapshotInfo.  # noqa: E501
        :type iscsi_lun_snapshot_uuid: str
        """
        if self.local_vars_configuration.client_side_validation and iscsi_lun_snapshot_uuid is None:  # noqa: E501
            raise ValueError("Invalid value for `iscsi_lun_snapshot_uuid`, must not be `None`")  # noqa: E501

        self._iscsi_lun_snapshot_uuid = iscsi_lun_snapshot_uuid

    @property
    def storage_encrypted(self):
        """Gets the storage_encrypted of this NestedSnapshotInfo.  # noqa: E501


        :return: The storage_encrypted of this NestedSnapshotInfo.  # noqa: E501
        :rtype: bool
        """
        return self._storage_encrypted

    @storage_encrypted.setter
    def storage_encrypted(self, storage_encrypted):
        """Sets the storage_encrypted of this NestedSnapshotInfo.


        :param storage_encrypted: The storage_encrypted of this NestedSnapshotInfo.  # noqa: E501
        :type storage_encrypted: bool
        """

        self._storage_encrypted = storage_encrypted

    @property
    def storage_policy_config(self):
        """Gets the storage_policy_config of this NestedSnapshotInfo.  # noqa: E501


        :return: The storage_policy_config of this NestedSnapshotInfo.  # noqa: E501
        :rtype: NestedStoragePolicyConfig
        """
        return self._storage_policy_config

    @storage_policy_config.setter
    def storage_policy_config(self, storage_policy_config):
        """Sets the storage_policy_config of this NestedSnapshotInfo.


        :param storage_policy_config: The storage_policy_config of this NestedSnapshotInfo.  # noqa: E501
        :type storage_policy_config: NestedStoragePolicyConfig
        """

        self._storage_policy_config = storage_policy_config

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedSnapshotInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedSnapshotInfo):
            return True

        return self.to_dict() != other.to_dict()
