# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedStep(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'current': 'float',
        'finished': 'bool',
        'key': 'str',
        'per_second': 'float',
        'total': 'float',
        'unit': 'StepUnit'
    }

    attribute_map = {
        'current': 'current',
        'finished': 'finished',
        'key': 'key',
        'per_second': 'per_second',
        'total': 'total',
        'unit': 'unit'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedStep - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._current = None
        self._finished = None
        self._key = None
        self._per_second = None
        self._total = None
        self._unit = None
        self.discriminator = None

        self.current = kwargs.get("current", None)
        self.finished = kwargs.get("finished", None)
        self.key = kwargs.get("key", None)
        self.per_second = kwargs.get("per_second", None)
        self.total = kwargs.get("total", None)
        self.unit = kwargs.get("unit", None)

    @property
    def current(self):
        """Gets the current of this NestedStep.  # noqa: E501


        :return: The current of this NestedStep.  # noqa: E501
        :rtype: float
        """
        return self._current

    @current.setter
    def current(self, current):
        """Sets the current of this NestedStep.


        :param current: The current of this NestedStep.  # noqa: E501
        :type current: float
        """

        self._current = current

    @property
    def finished(self):
        """Gets the finished of this NestedStep.  # noqa: E501


        :return: The finished of this NestedStep.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this NestedStep.


        :param finished: The finished of this NestedStep.  # noqa: E501
        :type finished: bool
        """

        self._finished = finished

    @property
    def key(self):
        """Gets the key of this NestedStep.  # noqa: E501


        :return: The key of this NestedStep.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this NestedStep.


        :param key: The key of this NestedStep.  # noqa: E501
        :type key: str
        """

        self._key = key

    @property
    def per_second(self):
        """Gets the per_second of this NestedStep.  # noqa: E501


        :return: The per_second of this NestedStep.  # noqa: E501
        :rtype: float
        """
        return self._per_second

    @per_second.setter
    def per_second(self, per_second):
        """Sets the per_second of this NestedStep.


        :param per_second: The per_second of this NestedStep.  # noqa: E501
        :type per_second: float
        """

        self._per_second = per_second

    @property
    def total(self):
        """Gets the total of this NestedStep.  # noqa: E501


        :return: The total of this NestedStep.  # noqa: E501
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this NestedStep.


        :param total: The total of this NestedStep.  # noqa: E501
        :type total: float
        """

        self._total = total

    @property
    def unit(self):
        """Gets the unit of this NestedStep.  # noqa: E501


        :return: The unit of this NestedStep.  # noqa: E501
        :rtype: StepUnit
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """Sets the unit of this NestedStep.


        :param unit: The unit of this NestedStep.  # noqa: E501
        :type unit: StepUnit
        """

        self._unit = unit

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedStep):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedStep):
            return True

        return self.to_dict() != other.to_dict()
