# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedTemplateConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cpu_exclusive_expected_enabled': 'bool',
        'guest_os_type': 'str',
        'minimum_replica': 'bool',
        'sync_vm_time_on_resume': 'bool'
    }

    attribute_map = {
        'cpu_exclusive_expected_enabled': 'cpu_exclusive_expected_enabled',
        'guest_os_type': 'guest_os_type',
        'minimum_replica': 'minimum_replica',
        'sync_vm_time_on_resume': 'sync_vm_time_on_resume'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedTemplateConfig - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cpu_exclusive_expected_enabled = None
        self._guest_os_type = None
        self._minimum_replica = None
        self._sync_vm_time_on_resume = None
        self.discriminator = None

        self.cpu_exclusive_expected_enabled = kwargs.get("cpu_exclusive_expected_enabled", None)
        self.guest_os_type = kwargs.get("guest_os_type", None)
        self.minimum_replica = kwargs.get("minimum_replica", None)
        self.sync_vm_time_on_resume = kwargs.get("sync_vm_time_on_resume", None)

    @property
    def cpu_exclusive_expected_enabled(self):
        """Gets the cpu_exclusive_expected_enabled of this NestedTemplateConfig.  # noqa: E501


        :return: The cpu_exclusive_expected_enabled of this NestedTemplateConfig.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_exclusive_expected_enabled

    @cpu_exclusive_expected_enabled.setter
    def cpu_exclusive_expected_enabled(self, cpu_exclusive_expected_enabled):
        """Sets the cpu_exclusive_expected_enabled of this NestedTemplateConfig.


        :param cpu_exclusive_expected_enabled: The cpu_exclusive_expected_enabled of this NestedTemplateConfig.  # noqa: E501
        :type cpu_exclusive_expected_enabled: bool
        """

        self._cpu_exclusive_expected_enabled = cpu_exclusive_expected_enabled

    @property
    def guest_os_type(self):
        """Gets the guest_os_type of this NestedTemplateConfig.  # noqa: E501


        :return: The guest_os_type of this NestedTemplateConfig.  # noqa: E501
        :rtype: str
        """
        return self._guest_os_type

    @guest_os_type.setter
    def guest_os_type(self, guest_os_type):
        """Sets the guest_os_type of this NestedTemplateConfig.


        :param guest_os_type: The guest_os_type of this NestedTemplateConfig.  # noqa: E501
        :type guest_os_type: str
        """

        self._guest_os_type = guest_os_type

    @property
    def minimum_replica(self):
        """Gets the minimum_replica of this NestedTemplateConfig.  # noqa: E501


        :return: The minimum_replica of this NestedTemplateConfig.  # noqa: E501
        :rtype: bool
        """
        return self._minimum_replica

    @minimum_replica.setter
    def minimum_replica(self, minimum_replica):
        """Sets the minimum_replica of this NestedTemplateConfig.


        :param minimum_replica: The minimum_replica of this NestedTemplateConfig.  # noqa: E501
        :type minimum_replica: bool
        """

        self._minimum_replica = minimum_replica

    @property
    def sync_vm_time_on_resume(self):
        """Gets the sync_vm_time_on_resume of this NestedTemplateConfig.  # noqa: E501


        :return: The sync_vm_time_on_resume of this NestedTemplateConfig.  # noqa: E501
        :rtype: bool
        """
        return self._sync_vm_time_on_resume

    @sync_vm_time_on_resume.setter
    def sync_vm_time_on_resume(self, sync_vm_time_on_resume):
        """Sets the sync_vm_time_on_resume of this NestedTemplateConfig.


        :param sync_vm_time_on_resume: The sync_vm_time_on_resume of this NestedTemplateConfig.  # noqa: E501
        :type sync_vm_time_on_resume: bool
        """

        self._sync_vm_time_on_resume = sync_vm_time_on_resume

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedTemplateConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedTemplateConfig):
            return True

        return self.to_dict() != other.to_dict()
