# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedTemplateVpcNic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'use_floating_ip': 'bool',
        'vpc_local_id': 'str',
        'vpc_subnet_local_id': 'str'
    }

    attribute_map = {
        'use_floating_ip': 'use_floating_ip',
        'vpc_local_id': 'vpc_local_id',
        'vpc_subnet_local_id': 'vpc_subnet_local_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedTemplateVpcNic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._use_floating_ip = None
        self._vpc_local_id = None
        self._vpc_subnet_local_id = None
        self.discriminator = None

        if "use_floating_ip" in kwargs:
            self.use_floating_ip = kwargs["use_floating_ip"]
        if "vpc_local_id" in kwargs:
            self.vpc_local_id = kwargs["vpc_local_id"]
        if "vpc_subnet_local_id" in kwargs:
            self.vpc_subnet_local_id = kwargs["vpc_subnet_local_id"]

    @property
    def use_floating_ip(self):
        """Gets the use_floating_ip of this NestedTemplateVpcNic.  # noqa: E501


        :return: The use_floating_ip of this NestedTemplateVpcNic.  # noqa: E501
        :rtype: bool
        """
        return self._use_floating_ip

    @use_floating_ip.setter
    def use_floating_ip(self, use_floating_ip):
        """Sets the use_floating_ip of this NestedTemplateVpcNic.


        :param use_floating_ip: The use_floating_ip of this NestedTemplateVpcNic.  # noqa: E501
        :type use_floating_ip: bool
        """
        if self.local_vars_configuration.client_side_validation and use_floating_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `use_floating_ip`, must not be `None`")  # noqa: E501

        self._use_floating_ip = use_floating_ip

    @property
    def vpc_local_id(self):
        """Gets the vpc_local_id of this NestedTemplateVpcNic.  # noqa: E501


        :return: The vpc_local_id of this NestedTemplateVpcNic.  # noqa: E501
        :rtype: str
        """
        return self._vpc_local_id

    @vpc_local_id.setter
    def vpc_local_id(self, vpc_local_id):
        """Sets the vpc_local_id of this NestedTemplateVpcNic.


        :param vpc_local_id: The vpc_local_id of this NestedTemplateVpcNic.  # noqa: E501
        :type vpc_local_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_local_id`, must not be `None`")  # noqa: E501

        self._vpc_local_id = vpc_local_id

    @property
    def vpc_subnet_local_id(self):
        """Gets the vpc_subnet_local_id of this NestedTemplateVpcNic.  # noqa: E501


        :return: The vpc_subnet_local_id of this NestedTemplateVpcNic.  # noqa: E501
        :rtype: str
        """
        return self._vpc_subnet_local_id

    @vpc_subnet_local_id.setter
    def vpc_subnet_local_id(self, vpc_subnet_local_id):
        """Sets the vpc_subnet_local_id of this NestedTemplateVpcNic.


        :param vpc_subnet_local_id: The vpc_subnet_local_id of this NestedTemplateVpcNic.  # noqa: E501
        :type vpc_subnet_local_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_subnet_local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_subnet_local_id`, must not be `None`")  # noqa: E501

        self._vpc_subnet_local_id = vpc_subnet_local_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedTemplateVpcNic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedTemplateVpcNic):
            return True

        return self.to_dict() != other.to_dict()
