# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudExternalSubnetGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'edge_gateway_group': 'NestedVirtualPrivateCloudEdgeGatewayGroup',
        'id': 'str',
        'name': 'str'
    }

    attribute_map = {
        'edge_gateway_group': 'edge_gateway_group',
        'id': 'id',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudExternalSubnetGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._edge_gateway_group = None
        self._id = None
        self._name = None
        self.discriminator = None

        if "edge_gateway_group" in kwargs:
            self.edge_gateway_group = kwargs["edge_gateway_group"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def edge_gateway_group(self):
        """Gets the edge_gateway_group of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The edge_gateway_group of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudEdgeGatewayGroup
        """
        return self._edge_gateway_group

    @edge_gateway_group.setter
    def edge_gateway_group(self, edge_gateway_group):
        """Sets the edge_gateway_group of this NestedVirtualPrivateCloudExternalSubnetGroup.


        :param edge_gateway_group: The edge_gateway_group of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type edge_gateway_group: NestedVirtualPrivateCloudEdgeGatewayGroup
        """
        if self.local_vars_configuration.client_side_validation and edge_gateway_group is None:  # noqa: E501
            raise ValueError("Invalid value for `edge_gateway_group`, must not be `None`")  # noqa: E501

        self._edge_gateway_group = edge_gateway_group

    @property
    def id(self):
        """Gets the id of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The id of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NestedVirtualPrivateCloudExternalSubnetGroup.


        :param id: The id of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The name of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NestedVirtualPrivateCloudExternalSubnetGroup.


        :param name: The name of this NestedVirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudExternalSubnetGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudExternalSubnetGroup):
            return True

        return self.to_dict() != other.to_dict()
