# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cidr': 'str',
        'edge_gateway_id': 'str',
        'floating_ip_cidr': 'str',
        'gateway': 'str',
        'id': 'str',
        'nat_gateway_cidr': 'str',
        'router_gateway_cidr': 'str',
        'vlan_id': 'str'
    }

    attribute_map = {
        'cidr': 'cidr',
        'edge_gateway_id': 'edge_gateway_id',
        'floating_ip_cidr': 'floating_ip_cidr',
        'gateway': 'gateway',
        'id': 'id',
        'nat_gateway_cidr': 'nat_gateway_cidr',
        'router_gateway_cidr': 'router_gateway_cidr',
        'vlan_id': 'vlan_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cidr = None
        self._edge_gateway_id = None
        self._floating_ip_cidr = None
        self._gateway = None
        self._id = None
        self._nat_gateway_cidr = None
        self._router_gateway_cidr = None
        self._vlan_id = None
        self.discriminator = None

        if "cidr" in kwargs:
            self.cidr = kwargs["cidr"]
        if "edge_gateway_id" in kwargs:
            self.edge_gateway_id = kwargs["edge_gateway_id"]
        self.floating_ip_cidr = kwargs.get("floating_ip_cidr", None)
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.nat_gateway_cidr = kwargs.get("nat_gateway_cidr", None)
        self.router_gateway_cidr = kwargs.get("router_gateway_cidr", None)
        if "vlan_id" in kwargs:
            self.vlan_id = kwargs["vlan_id"]

    @property
    def cidr(self):
        """Gets the cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """Sets the cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param cidr: The cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type cidr: str
        """
        if self.local_vars_configuration.client_side_validation and cidr is None:  # noqa: E501
            raise ValueError("Invalid value for `cidr`, must not be `None`")  # noqa: E501

        self._cidr = cidr

    @property
    def edge_gateway_id(self):
        """Gets the edge_gateway_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The edge_gateway_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._edge_gateway_id

    @edge_gateway_id.setter
    def edge_gateway_id(self, edge_gateway_id):
        """Sets the edge_gateway_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param edge_gateway_id: The edge_gateway_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type edge_gateway_id: str
        """
        if self.local_vars_configuration.client_side_validation and edge_gateway_id is None:  # noqa: E501
            raise ValueError("Invalid value for `edge_gateway_id`, must not be `None`")  # noqa: E501

        self._edge_gateway_id = edge_gateway_id

    @property
    def floating_ip_cidr(self):
        """Gets the floating_ip_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The floating_ip_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._floating_ip_cidr

    @floating_ip_cidr.setter
    def floating_ip_cidr(self, floating_ip_cidr):
        """Sets the floating_ip_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param floating_ip_cidr: The floating_ip_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type floating_ip_cidr: str
        """

        self._floating_ip_cidr = floating_ip_cidr

    @property
    def gateway(self):
        """Gets the gateway of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The gateway of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param gateway: The gateway of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type gateway: str
        """
        if self.local_vars_configuration.client_side_validation and gateway is None:  # noqa: E501
            raise ValueError("Invalid value for `gateway`, must not be `None`")  # noqa: E501

        self._gateway = gateway

    @property
    def id(self):
        """Gets the id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param id: The id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def nat_gateway_cidr(self):
        """Gets the nat_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The nat_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._nat_gateway_cidr

    @nat_gateway_cidr.setter
    def nat_gateway_cidr(self, nat_gateway_cidr):
        """Sets the nat_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param nat_gateway_cidr: The nat_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type nat_gateway_cidr: str
        """

        self._nat_gateway_cidr = nat_gateway_cidr

    @property
    def router_gateway_cidr(self):
        """Gets the router_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The router_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._router_gateway_cidr

    @router_gateway_cidr.setter
    def router_gateway_cidr(self, router_gateway_cidr):
        """Sets the router_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param router_gateway_cidr: The router_gateway_cidr of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type router_gateway_cidr: str
        """

        self._router_gateway_cidr = router_gateway_cidr

    @property
    def vlan_id(self):
        """Gets the vlan_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501


        :return: The vlan_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :rtype: str
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.


        :param vlan_id: The vlan_id of this NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec.  # noqa: E501
        :type vlan_id: str
        """
        if self.local_vars_configuration.client_side_validation and vlan_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must not be `None`")  # noqa: E501

        self._vlan_id = vlan_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec):
            return True

        return self.to_dict() != other.to_dict()
